// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package opsworks provides a client for AWS OpsWorks.
package opsworks

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

// OpsWorks is a client for AWS OpsWorks.
type OpsWorks struct {
	client *aws.JSONClient
}

// New returns a new OpsWorks client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *OpsWorks {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("opsworks", region)

	return &OpsWorks{
		client: &aws.JSONClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			}, Client: client,
			Endpoint:     endpoint,
			JSONVersion:  "1.1",
			TargetPrefix: "OpsWorks_20130218",
		},
	}
}

// AssignInstance assign a registered instance to a custom layer. You
// cannot use this action with instances that were created with AWS
// OpsWorks. Required Permissions : To use this action, an IAM user must
// have a Manage permissions level for the stack or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) AssignInstance(req *AssignInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("AssignInstance", "POST", "/", req, nil)
	return
}

// AssignVolume assigns one of the stack's registered Amazon EBS volumes to
// a specified instance. The volume must first be registered with the stack
// by calling RegisterVolume . For more information, see Resource
// Management Required Permissions : To use this action, an IAM user must
// have a Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) AssignVolume(req *AssignVolumeRequest) (err error) {
	// NRE
	err = c.client.Do("AssignVolume", "POST", "/", req, nil)
	return
}

// AssociateElasticIP associates one of the stack's registered Elastic IP
// addresses with a specified instance. The address must first be
// registered with the stack by calling RegisterElasticIp . For more
// information, see Resource Management Required Permissions : To use this
// action, an IAM user must have a Manage permissions level for the stack,
// or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) AssociateElasticIP(req *AssociateElasticIPRequest) (err error) {
	// NRE
	err = c.client.Do("AssociateElasticIp", "POST", "/", req, nil)
	return
}

// AttachElasticLoadBalancer attaches an Elastic Load Balancing load
// balancer to a specified layer. For more information, see Elastic Load
// Balancing You must create the Elastic Load Balancing instance
// separately, by using the Elastic Load Balancing console, or For more
// information, see Elastic Load Balancing Developer Guide Required
// Permissions : To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information on user permissions, see
// Managing User Permissions
func (c *OpsWorks) AttachElasticLoadBalancer(req *AttachElasticLoadBalancerRequest) (err error) {
	// NRE
	err = c.client.Do("AttachElasticLoadBalancer", "POST", "/", req, nil)
	return
}

// CloneStack creates a clone of a specified stack. For more information,
// see Clone a Stack Required Permissions : To use this action, an IAM user
// must have an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) CloneStack(req *CloneStackRequest) (resp *CloneStackResult, err error) {
	resp = &CloneStackResult{}
	err = c.client.Do("CloneStack", "POST", "/", req, resp)
	return
}

// CreateApp creates an app for a specified stack. For more information,
// see Creating Apps Required Permissions : To use this action, an IAM user
// must have a Manage permissions level for the stack, or an attached
// policy that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) CreateApp(req *CreateAppRequest) (resp *CreateAppResult, err error) {
	resp = &CreateAppResult{}
	err = c.client.Do("CreateApp", "POST", "/", req, resp)
	return
}

// CreateDeployment runs deployment or stack commands. For more
// information, see Deploying Apps and Run Stack Commands Required
// Permissions : To use this action, an IAM user must have a Deploy or
// Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) CreateDeployment(req *CreateDeploymentRequest) (resp *CreateDeploymentResult, err error) {
	resp = &CreateDeploymentResult{}
	err = c.client.Do("CreateDeployment", "POST", "/", req, resp)
	return
}

// CreateInstance creates an instance in a specified stack. For more
// information, see Adding an Instance to a Layer Required Permissions : To
// use this action, an IAM user must have a Manage permissions level for
// the stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) CreateInstance(req *CreateInstanceRequest) (resp *CreateInstanceResult, err error) {
	resp = &CreateInstanceResult{}
	err = c.client.Do("CreateInstance", "POST", "/", req, resp)
	return
}

// CreateLayer creates a layer. For more information, see How to Create a
// Layer You should use CreateLayer for noncustom layer types such as PHP
// App Server only if the stack does not have an existing layer of that
// type. A stack can have at most one instance of each noncustom layer; if
// you attempt to create a second instance, CreateLayer fails. A stack can
// have an arbitrary number of custom layers, so you can call CreateLayer
// as many times as you like for that layer type. Required Permissions : To
// use this action, an IAM user must have a Manage permissions level for
// the stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) CreateLayer(req *CreateLayerRequest) (resp *CreateLayerResult, err error) {
	resp = &CreateLayerResult{}
	err = c.client.Do("CreateLayer", "POST", "/", req, resp)
	return
}

// CreateStack creates a new stack. For more information, see Create a New
// Stack Required Permissions : To use this action, an IAM user must have
// an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) CreateStack(req *CreateStackRequest) (resp *CreateStackResult, err error) {
	resp = &CreateStackResult{}
	err = c.client.Do("CreateStack", "POST", "/", req, resp)
	return
}

// CreateUserProfile creates a new user profile. Required Permissions : To
// use this action, an IAM user must have an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) CreateUserProfile(req *CreateUserProfileRequest) (resp *CreateUserProfileResult, err error) {
	resp = &CreateUserProfileResult{}
	err = c.client.Do("CreateUserProfile", "POST", "/", req, resp)
	return
}

// DeleteApp deletes a specified app. Required Permissions : To use this
// action, an IAM user must have a Manage permissions level for the stack,
// or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) DeleteApp(req *DeleteAppRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteApp", "POST", "/", req, nil)
	return
}

// DeleteInstance deletes a specified instance, which terminates the
// associated Amazon EC2 instance. You must stop an instance before you can
// delete it. For more information, see Deleting Instances Required
// Permissions : To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information on user permissions, see
// Managing User Permissions
func (c *OpsWorks) DeleteInstance(req *DeleteInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteInstance", "POST", "/", req, nil)
	return
}

// DeleteLayer deletes a specified layer. You must first stop and then
// delete all associated instances or unassign registered instances. For
// more information, see How to Delete a Layer Required Permissions : To
// use this action, an IAM user must have a Manage permissions level for
// the stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) DeleteLayer(req *DeleteLayerRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteLayer", "POST", "/", req, nil)
	return
}

// DeleteStack deletes a specified stack. You must first delete all
// instances, layers, and apps or deregister registered instances. For more
// information, see Shut Down a Stack Required Permissions : To use this
// action, an IAM user must have a Manage permissions level for the stack,
// or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) DeleteStack(req *DeleteStackRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteStack", "POST", "/", req, nil)
	return
}

// DeleteUserProfile deletes a user profile. Required Permissions : To use
// this action, an IAM user must have an attached policy that explicitly
// grants permissions. For more information on user permissions, see
// Managing User Permissions
func (c *OpsWorks) DeleteUserProfile(req *DeleteUserProfileRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteUserProfile", "POST", "/", req, nil)
	return
}

// DeregisterElasticIP deregisters a specified Elastic IP address. The
// address can then be registered by another stack. For more information,
// see Resource Management Required Permissions : To use this action, an
// IAM user must have a Manage permissions level for the stack, or an
// attached policy that explicitly grants permissions. For more information
// on user permissions, see Managing User Permissions
func (c *OpsWorks) DeregisterElasticIP(req *DeregisterElasticIPRequest) (err error) {
	// NRE
	err = c.client.Do("DeregisterElasticIp", "POST", "/", req, nil)
	return
}

// DeregisterInstance deregister a registered Amazon EC2 or on-premises
// instance. This action removes the instance from the stack and returns it
// to your control. This action can not be used with instances that were
// created with AWS OpsWorks. Required Permissions : To use this action, an
// IAM user must have a Manage permissions level for the stack or an
// attached policy that explicitly grants permissions. For more information
// on user permissions, see Managing User Permissions
func (c *OpsWorks) DeregisterInstance(req *DeregisterInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("DeregisterInstance", "POST", "/", req, nil)
	return
}

// DeregisterRDSDBInstance deregisters an Amazon RDS instance. Required
// Permissions : To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information on user permissions, see
// Managing User Permissions
func (c *OpsWorks) DeregisterRDSDBInstance(req *DeregisterRDSDBInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("DeregisterRdsDbInstance", "POST", "/", req, nil)
	return
}

// DeregisterVolume deregisters an Amazon EBS volume. The volume can then
// be registered by another stack. For more information, see Resource
// Management Required Permissions : To use this action, an IAM user must
// have a Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) DeregisterVolume(req *DeregisterVolumeRequest) (err error) {
	// NRE
	err = c.client.Do("DeregisterVolume", "POST", "/", req, nil)
	return
}

// DescribeApps you must specify at least one of the parameters. Required
// Permissions : To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) DescribeApps(req *DescribeAppsRequest) (resp *DescribeAppsResult, err error) {
	resp = &DescribeAppsResult{}
	err = c.client.Do("DescribeApps", "POST", "/", req, resp)
	return
}

// DescribeCommands you must specify at least one of the parameters.
// Required Permissions : To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) DescribeCommands(req *DescribeCommandsRequest) (resp *DescribeCommandsResult, err error) {
	resp = &DescribeCommandsResult{}
	err = c.client.Do("DescribeCommands", "POST", "/", req, resp)
	return
}

// DescribeDeployments requests a description of a specified set of
// deployments. You must specify at least one of the parameters. Required
// Permissions : To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) DescribeDeployments(req *DescribeDeploymentsRequest) (resp *DescribeDeploymentsResult, err error) {
	resp = &DescribeDeploymentsResult{}
	err = c.client.Do("DescribeDeployments", "POST", "/", req, resp)
	return
}

// DescribeElasticIPs you must specify at least one of the parameters.
// Required Permissions : To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) DescribeElasticIPs(req *DescribeElasticIPsRequest) (resp *DescribeElasticIPsResult, err error) {
	resp = &DescribeElasticIPsResult{}
	err = c.client.Do("DescribeElasticIps", "POST", "/", req, resp)
	return
}

// DescribeElasticLoadBalancers describes a stack's Elastic Load Balancing
// instances. You must specify at least one of the parameters. Required
// Permissions : To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) DescribeElasticLoadBalancers(req *DescribeElasticLoadBalancersRequest) (resp *DescribeElasticLoadBalancersResult, err error) {
	resp = &DescribeElasticLoadBalancersResult{}
	err = c.client.Do("DescribeElasticLoadBalancers", "POST", "/", req, resp)
	return
}

// DescribeInstances you must specify at least one of the parameters.
// Required Permissions : To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) DescribeInstances(req *DescribeInstancesRequest) (resp *DescribeInstancesResult, err error) {
	resp = &DescribeInstancesResult{}
	err = c.client.Do("DescribeInstances", "POST", "/", req, resp)
	return
}

// DescribeLayers requests a description of one or more layers in a
// specified stack. You must specify at least one of the parameters.
// Required Permissions : To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) DescribeLayers(req *DescribeLayersRequest) (resp *DescribeLayersResult, err error) {
	resp = &DescribeLayersResult{}
	err = c.client.Do("DescribeLayers", "POST", "/", req, resp)
	return
}

// DescribeLoadBasedAutoScaling describes load-based auto scaling
// configurations for specified layers. You must specify at least one of
// the parameters. Required Permissions : To use this action, an IAM user
// must have a Show, Deploy, or Manage permissions level for the stack, or
// an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) DescribeLoadBasedAutoScaling(req *DescribeLoadBasedAutoScalingRequest) (resp *DescribeLoadBasedAutoScalingResult, err error) {
	resp = &DescribeLoadBasedAutoScalingResult{}
	err = c.client.Do("DescribeLoadBasedAutoScaling", "POST", "/", req, resp)
	return
}

// DescribeMyUserProfile describes a user's SSH information. Required
// Permissions : To use this action, an IAM user must have self-management
// enabled or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) DescribeMyUserProfile() (resp *DescribeMyUserProfileResult, err error) {
	resp = &DescribeMyUserProfileResult{}
	err = c.client.Do("DescribeMyUserProfile", "POST", "/", nil, resp)
	return
}

// DescribePermissions describes the permissions for a specified stack.
// Required Permissions : To use this action, an IAM user must have a
// Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) DescribePermissions(req *DescribePermissionsRequest) (resp *DescribePermissionsResult, err error) {
	resp = &DescribePermissionsResult{}
	err = c.client.Do("DescribePermissions", "POST", "/", req, resp)
	return
}

// DescribeRAIDArrays you must specify at least one of the parameters.
// Required Permissions : To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) DescribeRAIDArrays(req *DescribeRAIDArraysRequest) (resp *DescribeRAIDArraysResult, err error) {
	resp = &DescribeRAIDArraysResult{}
	err = c.client.Do("DescribeRaidArrays", "POST", "/", req, resp)
	return
}

// DescribeRDSDBInstances describes Amazon RDS instances. Required
// Permissions : To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) DescribeRDSDBInstances(req *DescribeRDSDBInstancesRequest) (resp *DescribeRDSDBInstancesResult, err error) {
	resp = &DescribeRDSDBInstancesResult{}
	err = c.client.Do("DescribeRdsDbInstances", "POST", "/", req, resp)
	return
}

// DescribeServiceErrors describes AWS OpsWorks service errors. Required
// Permissions : To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) DescribeServiceErrors(req *DescribeServiceErrorsRequest) (resp *DescribeServiceErrorsResult, err error) {
	resp = &DescribeServiceErrorsResult{}
	err = c.client.Do("DescribeServiceErrors", "POST", "/", req, resp)
	return
}

// DescribeStackProvisioningParameters requests a description of a stack's
// provisioning parameters. Required Permissions : To use this action, an
// IAM user must have a Show, Deploy, or Manage permissions level for the
// stack or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) DescribeStackProvisioningParameters(req *DescribeStackProvisioningParametersRequest) (resp *DescribeStackProvisioningParametersResult, err error) {
	resp = &DescribeStackProvisioningParametersResult{}
	err = c.client.Do("DescribeStackProvisioningParameters", "POST", "/", req, resp)
	return
}

// DescribeStackSummary describes the number of layers and apps in a
// specified stack, and the number of instances in each state, such as
// running_setup or online Required Permissions : To use this action, an
// IAM user must have a Show, Deploy, or Manage permissions level for the
// stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) DescribeStackSummary(req *DescribeStackSummaryRequest) (resp *DescribeStackSummaryResult, err error) {
	resp = &DescribeStackSummaryResult{}
	err = c.client.Do("DescribeStackSummary", "POST", "/", req, resp)
	return
}

// DescribeStacks requests a description of one or more stacks. Required
// Permissions : To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) DescribeStacks(req *DescribeStacksRequest) (resp *DescribeStacksResult, err error) {
	resp = &DescribeStacksResult{}
	err = c.client.Do("DescribeStacks", "POST", "/", req, resp)
	return
}

// DescribeTimeBasedAutoScaling describes time-based auto scaling
// configurations for specified instances. You must specify at least one of
// the parameters. Required Permissions : To use this action, an IAM user
// must have a Show, Deploy, or Manage permissions level for the stack, or
// an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) DescribeTimeBasedAutoScaling(req *DescribeTimeBasedAutoScalingRequest) (resp *DescribeTimeBasedAutoScalingResult, err error) {
	resp = &DescribeTimeBasedAutoScalingResult{}
	err = c.client.Do("DescribeTimeBasedAutoScaling", "POST", "/", req, resp)
	return
}

// DescribeUserProfiles describe specified users. Required Permissions : To
// use this action, an IAM user must have an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) DescribeUserProfiles(req *DescribeUserProfilesRequest) (resp *DescribeUserProfilesResult, err error) {
	resp = &DescribeUserProfilesResult{}
	err = c.client.Do("DescribeUserProfiles", "POST", "/", req, resp)
	return
}

// DescribeVolumes you must specify at least one of the parameters.
// Required Permissions : To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) DescribeVolumes(req *DescribeVolumesRequest) (resp *DescribeVolumesResult, err error) {
	resp = &DescribeVolumesResult{}
	err = c.client.Do("DescribeVolumes", "POST", "/", req, resp)
	return
}

// DetachElasticLoadBalancer detaches a specified Elastic Load Balancing
// instance from its layer. Required Permissions : To use this action, an
// IAM user must have a Manage permissions level for the stack, or an
// attached policy that explicitly grants permissions. For more information
// on user permissions, see Managing User Permissions
func (c *OpsWorks) DetachElasticLoadBalancer(req *DetachElasticLoadBalancerRequest) (err error) {
	// NRE
	err = c.client.Do("DetachElasticLoadBalancer", "POST", "/", req, nil)
	return
}

// DisassociateElasticIP disassociates an Elastic IP address from its
// instance. The address remains registered with the stack. For more
// information, see Resource Management Required Permissions : To use this
// action, an IAM user must have a Manage permissions level for the stack,
// or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) DisassociateElasticIP(req *DisassociateElasticIPRequest) (err error) {
	// NRE
	err = c.client.Do("DisassociateElasticIp", "POST", "/", req, nil)
	return
}

// GetHostnameSuggestion gets a generated host name for the specified
// layer, based on the current host name theme. Required Permissions : To
// use this action, an IAM user must have a Manage permissions level for
// the stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) GetHostnameSuggestion(req *GetHostnameSuggestionRequest) (resp *GetHostnameSuggestionResult, err error) {
	resp = &GetHostnameSuggestionResult{}
	err = c.client.Do("GetHostnameSuggestion", "POST", "/", req, resp)
	return
}

// RebootInstance reboots a specified instance. For more information, see
// Starting, Stopping, and Rebooting Instances Required Permissions : To
// use this action, an IAM user must have a Manage permissions level for
// the stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) RebootInstance(req *RebootInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("RebootInstance", "POST", "/", req, nil)
	return
}

// RegisterElasticIP registers an Elastic IP address with a specified
// stack. An address can be registered with only one stack at a time. If
// the address is already registered, you must first deregister it by
// calling DeregisterElasticIp . For more information, see Resource
// Management Required Permissions : To use this action, an IAM user must
// have a Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) RegisterElasticIP(req *RegisterElasticIPRequest) (resp *RegisterElasticIPResult, err error) {
	resp = &RegisterElasticIPResult{}
	err = c.client.Do("RegisterElasticIp", "POST", "/", req, resp)
	return
}

// RegisterInstance registers instances with a specified stack that were
// created outside of AWS OpsWorks. We do not recommend using this action
// to register instances. The complete registration operation has two
// primary steps, installing the AWS OpsWorks agent on the instance and
// registering the instance with the stack. RegisterInstance handles only
// the second step. You should instead use the AWS CLI register command,
// which performs the entire registration operation. Required Permissions :
// To use this action, an IAM user must have a Manage permissions level for
// the stack or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) RegisterInstance(req *RegisterInstanceRequest) (resp *RegisterInstanceResult, err error) {
	resp = &RegisterInstanceResult{}
	err = c.client.Do("RegisterInstance", "POST", "/", req, resp)
	return
}

// RegisterRDSDBInstance registers an Amazon RDS instance with a stack.
// Required Permissions : To use this action, an IAM user must have a
// Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) RegisterRDSDBInstance(req *RegisterRDSDBInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("RegisterRdsDbInstance", "POST", "/", req, nil)
	return
}

// RegisterVolume registers an Amazon EBS volume with a specified stack. A
// volume can be registered with only one stack at a time. If the volume is
// already registered, you must first deregister it by calling
// DeregisterVolume . For more information, see Resource Management
// Required Permissions : To use this action, an IAM user must have a
// Manage permissions level for the stack, or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) RegisterVolume(req *RegisterVolumeRequest) (resp *RegisterVolumeResult, err error) {
	resp = &RegisterVolumeResult{}
	err = c.client.Do("RegisterVolume", "POST", "/", req, resp)
	return
}

// SetLoadBasedAutoScaling specify the load-based auto scaling
// configuration for a specified layer. For more information, see Managing
// Load with Time-based and Load-based Instances To use load-based auto
// scaling, you must create a set of load-based auto scaling instances.
// Load-based auto scaling operates only on the instances from that set, so
// you must ensure that you have created enough instances to handle the
// maximum anticipated load. Required Permissions : To use this action, an
// IAM user must have a Manage permissions level for the stack, or an
// attached policy that explicitly grants permissions. For more information
// on user permissions, see Managing User Permissions
func (c *OpsWorks) SetLoadBasedAutoScaling(req *SetLoadBasedAutoScalingRequest) (err error) {
	// NRE
	err = c.client.Do("SetLoadBasedAutoScaling", "POST", "/", req, nil)
	return
}

// SetPermission specifies a user's permissions. For more information, see
// Security and Permissions Required Permissions : To use this action, an
// IAM user must have a Manage permissions level for the stack, or an
// attached policy that explicitly grants permissions. For more information
// on user permissions, see Managing User Permissions
func (c *OpsWorks) SetPermission(req *SetPermissionRequest) (err error) {
	// NRE
	err = c.client.Do("SetPermission", "POST", "/", req, nil)
	return
}

// SetTimeBasedAutoScaling specify the time-based auto scaling
// configuration for a specified instance. For more information, see
// Managing Load with Time-based and Load-based Instances Required
// Permissions : To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information on user permissions, see
// Managing User Permissions
func (c *OpsWorks) SetTimeBasedAutoScaling(req *SetTimeBasedAutoScalingRequest) (err error) {
	// NRE
	err = c.client.Do("SetTimeBasedAutoScaling", "POST", "/", req, nil)
	return
}

// StartInstance starts a specified instance. For more information, see
// Starting, Stopping, and Rebooting Instances Required Permissions : To
// use this action, an IAM user must have a Manage permissions level for
// the stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) StartInstance(req *StartInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("StartInstance", "POST", "/", req, nil)
	return
}

// StartStack starts a stack's instances. Required Permissions : To use
// this action, an IAM user must have a Manage permissions level for the
// stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) StartStack(req *StartStackRequest) (err error) {
	// NRE
	err = c.client.Do("StartStack", "POST", "/", req, nil)
	return
}

// StopInstance stops a specified instance. When you stop a standard
// instance, the data disappears and must be reinstalled when you restart
// the instance. You can stop an Amazon EBS-backed instance without losing
// data. For more information, see Starting, Stopping, and Rebooting
// Instances Required Permissions : To use this action, an IAM user must
// have a Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) StopInstance(req *StopInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("StopInstance", "POST", "/", req, nil)
	return
}

// StopStack stops a specified stack. Required Permissions : To use this
// action, an IAM user must have a Manage permissions level for the stack,
// or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) StopStack(req *StopStackRequest) (err error) {
	// NRE
	err = c.client.Do("StopStack", "POST", "/", req, nil)
	return
}

// UnassignInstance unassigns a registered instance from all of it's
// layers. The instance remains in the stack as an unassigned instance and
// can be assigned to another layer, as needed. You cannot use this action
// with instances that were created with AWS OpsWorks. Required Permissions
// : To use this action, an IAM user must have a Manage permissions level
// for the stack or an attached policy that explicitly grants permissions.
// For more information on user permissions, see Managing User Permissions
func (c *OpsWorks) UnassignInstance(req *UnassignInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("UnassignInstance", "POST", "/", req, nil)
	return
}

// UnassignVolume unassigns an assigned Amazon EBS volume. The volume
// remains registered with the stack. For more information, see Resource
// Management Required Permissions : To use this action, an IAM user must
// have a Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user
// permissions, see Managing User Permissions
func (c *OpsWorks) UnassignVolume(req *UnassignVolumeRequest) (err error) {
	// NRE
	err = c.client.Do("UnassignVolume", "POST", "/", req, nil)
	return
}

// UpdateApp updates a specified app. Required Permissions : To use this
// action, an IAM user must have a Deploy or Manage permissions level for
// the stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) UpdateApp(req *UpdateAppRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateApp", "POST", "/", req, nil)
	return
}

// UpdateElasticIP updates a registered Elastic IP address's name. For more
// information, see Resource Management Required Permissions : To use this
// action, an IAM user must have a Manage permissions level for the stack,
// or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions
func (c *OpsWorks) UpdateElasticIP(req *UpdateElasticIPRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateElasticIp", "POST", "/", req, nil)
	return
}

// UpdateInstance updates a specified instance. Required Permissions : To
// use this action, an IAM user must have a Manage permissions level for
// the stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) UpdateInstance(req *UpdateInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateInstance", "POST", "/", req, nil)
	return
}

// UpdateLayer updates a specified layer. Required Permissions : To use
// this action, an IAM user must have a Manage permissions level for the
// stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) UpdateLayer(req *UpdateLayerRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateLayer", "POST", "/", req, nil)
	return
}

// UpdateMyUserProfile updates a user's SSH public key. Required
// Permissions : To use this action, an IAM user must have self-management
// enabled or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) UpdateMyUserProfile(req *UpdateMyUserProfileRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateMyUserProfile", "POST", "/", req, nil)
	return
}

// UpdateRDSDBInstance updates an Amazon RDS instance. Required Permissions
// : To use this action, an IAM user must have a Manage permissions level
// for the stack, or an attached policy that explicitly grants permissions.
// For more information on user permissions, see Managing User Permissions
func (c *OpsWorks) UpdateRDSDBInstance(req *UpdateRDSDBInstanceRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateRdsDbInstance", "POST", "/", req, nil)
	return
}

// UpdateStack updates a specified stack. Required Permissions : To use
// this action, an IAM user must have a Manage permissions level for the
// stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) UpdateStack(req *UpdateStackRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateStack", "POST", "/", req, nil)
	return
}

// UpdateUserProfile updates a specified user profile. Required Permissions
// : To use this action, an IAM user must have an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions
func (c *OpsWorks) UpdateUserProfile(req *UpdateUserProfileRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateUserProfile", "POST", "/", req, nil)
	return
}

// UpdateVolume updates an Amazon EBS volume's name or mount point. For
// more information, see Resource Management Required Permissions : To use
// this action, an IAM user must have a Manage permissions level for the
// stack, or an attached policy that explicitly grants permissions. For
// more information on user permissions, see Managing User Permissions
func (c *OpsWorks) UpdateVolume(req *UpdateVolumeRequest) (err error) {
	// NRE
	err = c.client.Do("UpdateVolume", "POST", "/", req, nil)
	return
}

// App is undocumented.
type App struct {
	AppID            aws.StringValue       `json:"AppId,omitempty"`
	AppSource        *Source               `json:"AppSource,omitempty"`
	Attributes       map[string]string     `json:"Attributes,omitempty"`
	CreatedAt        aws.StringValue       `json:"CreatedAt,omitempty"`
	DataSources      []DataSource          `json:"DataSources,omitempty"`
	Description      aws.StringValue       `json:"Description,omitempty"`
	Domains          []string              `json:"Domains,omitempty"`
	EnableSSL        aws.BooleanValue      `json:"EnableSsl,omitempty"`
	Environment      []EnvironmentVariable `json:"Environment,omitempty"`
	Name             aws.StringValue       `json:"Name,omitempty"`
	Shortname        aws.StringValue       `json:"Shortname,omitempty"`
	SSLConfiguration *SSLConfiguration     `json:"SslConfiguration,omitempty"`
	StackID          aws.StringValue       `json:"StackId,omitempty"`
	Type             aws.StringValue       `json:"Type,omitempty"`
}

// Possible values for OpsWorks.
const (
	AppAttributesKeysAutoBundleOnDeploy = "AutoBundleOnDeploy"
	AppAttributesKeysDocumentRoot       = "DocumentRoot"
	AppAttributesKeysRailsEnv           = "RailsEnv"
)

// Possible values for OpsWorks.
const (
	AppTypeJava   = "java"
	AppTypeNodejs = "nodejs"
	AppTypeOther  = "other"
	AppTypePHP    = "php"
	AppTypeRails  = "rails"
	AppTypeStatic = "static"
)

// Possible values for OpsWorks.
const (
	ArchitectureI386  = "i386"
	ArchitectureX8664 = "x86_64"
)

// AssignInstanceRequest is undocumented.
type AssignInstanceRequest struct {
	InstanceID aws.StringValue `json:"InstanceId"`
	LayerIDs   []string        `json:"LayerIds"`
}

// AssignVolumeRequest is undocumented.
type AssignVolumeRequest struct {
	InstanceID aws.StringValue `json:"InstanceId,omitempty"`
	VolumeID   aws.StringValue `json:"VolumeId"`
}

// AssociateElasticIPRequest is undocumented.
type AssociateElasticIPRequest struct {
	ElasticIP  aws.StringValue `json:"ElasticIp"`
	InstanceID aws.StringValue `json:"InstanceId,omitempty"`
}

// AttachElasticLoadBalancerRequest is undocumented.
type AttachElasticLoadBalancerRequest struct {
	ElasticLoadBalancerName aws.StringValue `json:"ElasticLoadBalancerName"`
	LayerID                 aws.StringValue `json:"LayerId"`
}

// AutoScalingThresholds is undocumented.
type AutoScalingThresholds struct {
	CPUThreshold       aws.DoubleValue  `json:"CpuThreshold,omitempty"`
	IgnoreMetricsTime  aws.IntegerValue `json:"IgnoreMetricsTime,omitempty"`
	InstanceCount      aws.IntegerValue `json:"InstanceCount,omitempty"`
	LoadThreshold      aws.DoubleValue  `json:"LoadThreshold,omitempty"`
	MemoryThreshold    aws.DoubleValue  `json:"MemoryThreshold,omitempty"`
	ThresholdsWaitTime aws.IntegerValue `json:"ThresholdsWaitTime,omitempty"`
}

// Possible values for OpsWorks.
const (
	AutoScalingTypeLoad  = "load"
	AutoScalingTypeTimer = "timer"
)

// ChefConfiguration is undocumented.
type ChefConfiguration struct {
	BerkshelfVersion aws.StringValue  `json:"BerkshelfVersion,omitempty"`
	ManageBerkshelf  aws.BooleanValue `json:"ManageBerkshelf,omitempty"`
}

// CloneStackRequest is undocumented.
type CloneStackRequest struct {
	Attributes                map[string]string          `json:"Attributes,omitempty"`
	ChefConfiguration         *ChefConfiguration         `json:"ChefConfiguration,omitempty"`
	CloneAppIDs               []string                   `json:"CloneAppIds,omitempty"`
	ClonePermissions          aws.BooleanValue           `json:"ClonePermissions,omitempty"`
	ConfigurationManager      *StackConfigurationManager `json:"ConfigurationManager,omitempty"`
	CustomCookbooksSource     *Source                    `json:"CustomCookbooksSource,omitempty"`
	CustomJSON                aws.StringValue            `json:"CustomJson,omitempty"`
	DefaultAvailabilityZone   aws.StringValue            `json:"DefaultAvailabilityZone,omitempty"`
	DefaultInstanceProfileARN aws.StringValue            `json:"DefaultInstanceProfileArn,omitempty"`
	DefaultOS                 aws.StringValue            `json:"DefaultOs,omitempty"`
	DefaultRootDeviceType     aws.StringValue            `json:"DefaultRootDeviceType,omitempty"`
	DefaultSSHKeyName         aws.StringValue            `json:"DefaultSshKeyName,omitempty"`
	DefaultSubnetID           aws.StringValue            `json:"DefaultSubnetId,omitempty"`
	HostnameTheme             aws.StringValue            `json:"HostnameTheme,omitempty"`
	Name                      aws.StringValue            `json:"Name,omitempty"`
	Region                    aws.StringValue            `json:"Region,omitempty"`
	ServiceRoleARN            aws.StringValue            `json:"ServiceRoleArn"`
	SourceStackID             aws.StringValue            `json:"SourceStackId"`
	UseCustomCookbooks        aws.BooleanValue           `json:"UseCustomCookbooks,omitempty"`
	UseOpsworksSecurityGroups aws.BooleanValue           `json:"UseOpsworksSecurityGroups,omitempty"`
	VPCID                     aws.StringValue            `json:"VpcId,omitempty"`
}

// CloneStackResult is undocumented.
type CloneStackResult struct {
	StackID aws.StringValue `json:"StackId,omitempty"`
}

// Command is undocumented.
type Command struct {
	AcknowledgedAt aws.StringValue  `json:"AcknowledgedAt,omitempty"`
	CommandID      aws.StringValue  `json:"CommandId,omitempty"`
	CompletedAt    aws.StringValue  `json:"CompletedAt,omitempty"`
	CreatedAt      aws.StringValue  `json:"CreatedAt,omitempty"`
	DeploymentID   aws.StringValue  `json:"DeploymentId,omitempty"`
	ExitCode       aws.IntegerValue `json:"ExitCode,omitempty"`
	InstanceID     aws.StringValue  `json:"InstanceId,omitempty"`
	LogURL         aws.StringValue  `json:"LogUrl,omitempty"`
	Status         aws.StringValue  `json:"Status,omitempty"`
	Type           aws.StringValue  `json:"Type,omitempty"`
}

// CreateAppRequest is undocumented.
type CreateAppRequest struct {
	AppSource        *Source               `json:"AppSource,omitempty"`
	Attributes       map[string]string     `json:"Attributes,omitempty"`
	DataSources      []DataSource          `json:"DataSources,omitempty"`
	Description      aws.StringValue       `json:"Description,omitempty"`
	Domains          []string              `json:"Domains,omitempty"`
	EnableSSL        aws.BooleanValue      `json:"EnableSsl,omitempty"`
	Environment      []EnvironmentVariable `json:"Environment,omitempty"`
	Name             aws.StringValue       `json:"Name"`
	Shortname        aws.StringValue       `json:"Shortname,omitempty"`
	SSLConfiguration *SSLConfiguration     `json:"SslConfiguration,omitempty"`
	StackID          aws.StringValue       `json:"StackId"`
	Type             aws.StringValue       `json:"Type"`
}

// CreateAppResult is undocumented.
type CreateAppResult struct {
	AppID aws.StringValue `json:"AppId,omitempty"`
}

// CreateDeploymentRequest is undocumented.
type CreateDeploymentRequest struct {
	AppID       aws.StringValue    `json:"AppId,omitempty"`
	Command     *DeploymentCommand `json:"Command"`
	Comment     aws.StringValue    `json:"Comment,omitempty"`
	CustomJSON  aws.StringValue    `json:"CustomJson,omitempty"`
	InstanceIDs []string           `json:"InstanceIds,omitempty"`
	StackID     aws.StringValue    `json:"StackId"`
}

// CreateDeploymentResult is undocumented.
type CreateDeploymentResult struct {
	DeploymentID aws.StringValue `json:"DeploymentId,omitempty"`
}

// CreateInstanceRequest is undocumented.
type CreateInstanceRequest struct {
	AMIID                aws.StringValue  `json:"AmiId,omitempty"`
	Architecture         aws.StringValue  `json:"Architecture,omitempty"`
	AutoScalingType      aws.StringValue  `json:"AutoScalingType,omitempty"`
	AvailabilityZone     aws.StringValue  `json:"AvailabilityZone,omitempty"`
	EBSOptimized         aws.BooleanValue `json:"EbsOptimized,omitempty"`
	Hostname             aws.StringValue  `json:"Hostname,omitempty"`
	InstallUpdatesOnBoot aws.BooleanValue `json:"InstallUpdatesOnBoot,omitempty"`
	InstanceType         aws.StringValue  `json:"InstanceType"`
	LayerIDs             []string         `json:"LayerIds"`
	OS                   aws.StringValue  `json:"Os,omitempty"`
	RootDeviceType       aws.StringValue  `json:"RootDeviceType,omitempty"`
	SSHKeyName           aws.StringValue  `json:"SshKeyName,omitempty"`
	StackID              aws.StringValue  `json:"StackId"`
	SubnetID             aws.StringValue  `json:"SubnetId,omitempty"`
	VirtualizationType   aws.StringValue  `json:"VirtualizationType,omitempty"`
}

// CreateInstanceResult is undocumented.
type CreateInstanceResult struct {
	InstanceID aws.StringValue `json:"InstanceId,omitempty"`
}

// CreateLayerRequest is undocumented.
type CreateLayerRequest struct {
	Attributes                  map[string]string            `json:"Attributes,omitempty"`
	AutoAssignElasticIPs        aws.BooleanValue             `json:"AutoAssignElasticIps,omitempty"`
	AutoAssignPublicIPs         aws.BooleanValue             `json:"AutoAssignPublicIps,omitempty"`
	CustomInstanceProfileARN    aws.StringValue              `json:"CustomInstanceProfileArn,omitempty"`
	CustomRecipes               *Recipes                     `json:"CustomRecipes,omitempty"`
	CustomSecurityGroupIDs      []string                     `json:"CustomSecurityGroupIds,omitempty"`
	EnableAutoHealing           aws.BooleanValue             `json:"EnableAutoHealing,omitempty"`
	InstallUpdatesOnBoot        aws.BooleanValue             `json:"InstallUpdatesOnBoot,omitempty"`
	LifecycleEventConfiguration *LifecycleEventConfiguration `json:"LifecycleEventConfiguration,omitempty"`
	Name                        aws.StringValue              `json:"Name"`
	Packages                    []string                     `json:"Packages,omitempty"`
	Shortname                   aws.StringValue              `json:"Shortname"`
	StackID                     aws.StringValue              `json:"StackId"`
	Type                        aws.StringValue              `json:"Type"`
	UseEBSOptimizedInstances    aws.BooleanValue             `json:"UseEbsOptimizedInstances,omitempty"`
	VolumeConfigurations        []VolumeConfiguration        `json:"VolumeConfigurations,omitempty"`
}

// CreateLayerResult is undocumented.
type CreateLayerResult struct {
	LayerID aws.StringValue `json:"LayerId,omitempty"`
}

// CreateStackRequest is undocumented.
type CreateStackRequest struct {
	Attributes                map[string]string          `json:"Attributes,omitempty"`
	ChefConfiguration         *ChefConfiguration         `json:"ChefConfiguration,omitempty"`
	ConfigurationManager      *StackConfigurationManager `json:"ConfigurationManager,omitempty"`
	CustomCookbooksSource     *Source                    `json:"CustomCookbooksSource,omitempty"`
	CustomJSON                aws.StringValue            `json:"CustomJson,omitempty"`
	DefaultAvailabilityZone   aws.StringValue            `json:"DefaultAvailabilityZone,omitempty"`
	DefaultInstanceProfileARN aws.StringValue            `json:"DefaultInstanceProfileArn"`
	DefaultOS                 aws.StringValue            `json:"DefaultOs,omitempty"`
	DefaultRootDeviceType     aws.StringValue            `json:"DefaultRootDeviceType,omitempty"`
	DefaultSSHKeyName         aws.StringValue            `json:"DefaultSshKeyName,omitempty"`
	DefaultSubnetID           aws.StringValue            `json:"DefaultSubnetId,omitempty"`
	HostnameTheme             aws.StringValue            `json:"HostnameTheme,omitempty"`
	Name                      aws.StringValue            `json:"Name"`
	Region                    aws.StringValue            `json:"Region"`
	ServiceRoleARN            aws.StringValue            `json:"ServiceRoleArn"`
	UseCustomCookbooks        aws.BooleanValue           `json:"UseCustomCookbooks,omitempty"`
	UseOpsworksSecurityGroups aws.BooleanValue           `json:"UseOpsworksSecurityGroups,omitempty"`
	VPCID                     aws.StringValue            `json:"VpcId,omitempty"`
}

// CreateStackResult is undocumented.
type CreateStackResult struct {
	StackID aws.StringValue `json:"StackId,omitempty"`
}

// CreateUserProfileRequest is undocumented.
type CreateUserProfileRequest struct {
	AllowSelfManagement aws.BooleanValue `json:"AllowSelfManagement,omitempty"`
	IAMUserARN          aws.StringValue  `json:"IamUserArn"`
	SSHPublicKey        aws.StringValue  `json:"SshPublicKey,omitempty"`
	SSHUsername         aws.StringValue  `json:"SshUsername,omitempty"`
}

// CreateUserProfileResult is undocumented.
type CreateUserProfileResult struct {
	IAMUserARN aws.StringValue `json:"IamUserArn,omitempty"`
}

// DataSource is undocumented.
type DataSource struct {
	ARN          aws.StringValue `json:"Arn,omitempty"`
	DatabaseName aws.StringValue `json:"DatabaseName,omitempty"`
	Type         aws.StringValue `json:"Type,omitempty"`
}

// DeleteAppRequest is undocumented.
type DeleteAppRequest struct {
	AppID aws.StringValue `json:"AppId"`
}

// DeleteInstanceRequest is undocumented.
type DeleteInstanceRequest struct {
	DeleteElasticIP aws.BooleanValue `json:"DeleteElasticIp,omitempty"`
	DeleteVolumes   aws.BooleanValue `json:"DeleteVolumes,omitempty"`
	InstanceID      aws.StringValue  `json:"InstanceId"`
}

// DeleteLayerRequest is undocumented.
type DeleteLayerRequest struct {
	LayerID aws.StringValue `json:"LayerId"`
}

// DeleteStackRequest is undocumented.
type DeleteStackRequest struct {
	StackID aws.StringValue `json:"StackId"`
}

// DeleteUserProfileRequest is undocumented.
type DeleteUserProfileRequest struct {
	IAMUserARN aws.StringValue `json:"IamUserArn"`
}

// Deployment is undocumented.
type Deployment struct {
	AppID        aws.StringValue    `json:"AppId,omitempty"`
	Command      *DeploymentCommand `json:"Command,omitempty"`
	Comment      aws.StringValue    `json:"Comment,omitempty"`
	CompletedAt  aws.StringValue    `json:"CompletedAt,omitempty"`
	CreatedAt    aws.StringValue    `json:"CreatedAt,omitempty"`
	CustomJSON   aws.StringValue    `json:"CustomJson,omitempty"`
	DeploymentID aws.StringValue    `json:"DeploymentId,omitempty"`
	Duration     aws.IntegerValue   `json:"Duration,omitempty"`
	IAMUserARN   aws.StringValue    `json:"IamUserArn,omitempty"`
	InstanceIDs  []string           `json:"InstanceIds,omitempty"`
	StackID      aws.StringValue    `json:"StackId,omitempty"`
	Status       aws.StringValue    `json:"Status,omitempty"`
}

// DeploymentCommand is undocumented.
type DeploymentCommand struct {
	Args map[string][]string `json:"Args,omitempty"`
	Name aws.StringValue     `json:"Name"`
}

// Possible values for OpsWorks.
const (
	DeploymentCommandNameDeploy                = "deploy"
	DeploymentCommandNameExecuteRecipes        = "execute_recipes"
	DeploymentCommandNameInstallDependencies   = "install_dependencies"
	DeploymentCommandNameRestart               = "restart"
	DeploymentCommandNameRollback              = "rollback"
	DeploymentCommandNameStart                 = "start"
	DeploymentCommandNameStop                  = "stop"
	DeploymentCommandNameUndeploy              = "undeploy"
	DeploymentCommandNameUpdateCustomCookbooks = "update_custom_cookbooks"
	DeploymentCommandNameUpdateDependencies    = "update_dependencies"
)

// DeregisterElasticIPRequest is undocumented.
type DeregisterElasticIPRequest struct {
	ElasticIP aws.StringValue `json:"ElasticIp"`
}

// DeregisterInstanceRequest is undocumented.
type DeregisterInstanceRequest struct {
	InstanceID aws.StringValue `json:"InstanceId"`
}

// DeregisterRDSDBInstanceRequest is undocumented.
type DeregisterRDSDBInstanceRequest struct {
	RDSDBInstanceARN aws.StringValue `json:"RdsDbInstanceArn"`
}

// DeregisterVolumeRequest is undocumented.
type DeregisterVolumeRequest struct {
	VolumeID aws.StringValue `json:"VolumeId"`
}

// DescribeAppsRequest is undocumented.
type DescribeAppsRequest struct {
	AppIDs  []string        `json:"AppIds,omitempty"`
	StackID aws.StringValue `json:"StackId,omitempty"`
}

// DescribeAppsResult is undocumented.
type DescribeAppsResult struct {
	Apps []App `json:"Apps,omitempty"`
}

// DescribeCommandsRequest is undocumented.
type DescribeCommandsRequest struct {
	CommandIDs   []string        `json:"CommandIds,omitempty"`
	DeploymentID aws.StringValue `json:"DeploymentId,omitempty"`
	InstanceID   aws.StringValue `json:"InstanceId,omitempty"`
}

// DescribeCommandsResult is undocumented.
type DescribeCommandsResult struct {
	Commands []Command `json:"Commands,omitempty"`
}

// DescribeDeploymentsRequest is undocumented.
type DescribeDeploymentsRequest struct {
	AppID         aws.StringValue `json:"AppId,omitempty"`
	DeploymentIDs []string        `json:"DeploymentIds,omitempty"`
	StackID       aws.StringValue `json:"StackId,omitempty"`
}

// DescribeDeploymentsResult is undocumented.
type DescribeDeploymentsResult struct {
	Deployments []Deployment `json:"Deployments,omitempty"`
}

// DescribeElasticIPsRequest is undocumented.
type DescribeElasticIPsRequest struct {
	InstanceID aws.StringValue `json:"InstanceId,omitempty"`
	IPs        []string        `json:"Ips,omitempty"`
	StackID    aws.StringValue `json:"StackId,omitempty"`
}

// DescribeElasticIPsResult is undocumented.
type DescribeElasticIPsResult struct {
	ElasticIPs []ElasticIP `json:"ElasticIps,omitempty"`
}

// DescribeElasticLoadBalancersRequest is undocumented.
type DescribeElasticLoadBalancersRequest struct {
	LayerIDs []string        `json:"LayerIds,omitempty"`
	StackID  aws.StringValue `json:"StackId,omitempty"`
}

// DescribeElasticLoadBalancersResult is undocumented.
type DescribeElasticLoadBalancersResult struct {
	ElasticLoadBalancers []ElasticLoadBalancer `json:"ElasticLoadBalancers,omitempty"`
}

// DescribeInstancesRequest is undocumented.
type DescribeInstancesRequest struct {
	InstanceIDs []string        `json:"InstanceIds,omitempty"`
	LayerID     aws.StringValue `json:"LayerId,omitempty"`
	StackID     aws.StringValue `json:"StackId,omitempty"`
}

// DescribeInstancesResult is undocumented.
type DescribeInstancesResult struct {
	Instances []Instance `json:"Instances,omitempty"`
}

// DescribeLayersRequest is undocumented.
type DescribeLayersRequest struct {
	LayerIDs []string        `json:"LayerIds,omitempty"`
	StackID  aws.StringValue `json:"StackId,omitempty"`
}

// DescribeLayersResult is undocumented.
type DescribeLayersResult struct {
	Layers []Layer `json:"Layers,omitempty"`
}

// DescribeLoadBasedAutoScalingRequest is undocumented.
type DescribeLoadBasedAutoScalingRequest struct {
	LayerIDs []string `json:"LayerIds"`
}

// DescribeLoadBasedAutoScalingResult is undocumented.
type DescribeLoadBasedAutoScalingResult struct {
	LoadBasedAutoScalingConfigurations []LoadBasedAutoScalingConfiguration `json:"LoadBasedAutoScalingConfigurations,omitempty"`
}

// DescribeMyUserProfileResult is undocumented.
type DescribeMyUserProfileResult struct {
	UserProfile *SelfUserProfile `json:"UserProfile,omitempty"`
}

// DescribePermissionsRequest is undocumented.
type DescribePermissionsRequest struct {
	IAMUserARN aws.StringValue `json:"IamUserArn,omitempty"`
	StackID    aws.StringValue `json:"StackId,omitempty"`
}

// DescribePermissionsResult is undocumented.
type DescribePermissionsResult struct {
	Permissions []Permission `json:"Permissions,omitempty"`
}

// DescribeRAIDArraysRequest is undocumented.
type DescribeRAIDArraysRequest struct {
	InstanceID   aws.StringValue `json:"InstanceId,omitempty"`
	RAIDArrayIDs []string        `json:"RaidArrayIds,omitempty"`
	StackID      aws.StringValue `json:"StackId,omitempty"`
}

// DescribeRAIDArraysResult is undocumented.
type DescribeRAIDArraysResult struct {
	RAIDArrays []RAIDArray `json:"RaidArrays,omitempty"`
}

// DescribeRDSDBInstancesRequest is undocumented.
type DescribeRDSDBInstancesRequest struct {
	RDSDBInstanceARNs []string        `json:"RdsDbInstanceArns,omitempty"`
	StackID           aws.StringValue `json:"StackId"`
}

// DescribeRDSDBInstancesResult is undocumented.
type DescribeRDSDBInstancesResult struct {
	RDSDBInstances []RDSDBInstance `json:"RdsDbInstances,omitempty"`
}

// DescribeServiceErrorsRequest is undocumented.
type DescribeServiceErrorsRequest struct {
	InstanceID      aws.StringValue `json:"InstanceId,omitempty"`
	ServiceErrorIDs []string        `json:"ServiceErrorIds,omitempty"`
	StackID         aws.StringValue `json:"StackId,omitempty"`
}

// DescribeServiceErrorsResult is undocumented.
type DescribeServiceErrorsResult struct {
	ServiceErrors []ServiceError `json:"ServiceErrors,omitempty"`
}

// DescribeStackProvisioningParametersRequest is undocumented.
type DescribeStackProvisioningParametersRequest struct {
	StackID aws.StringValue `json:"StackId"`
}

// DescribeStackProvisioningParametersResult is undocumented.
type DescribeStackProvisioningParametersResult struct {
	AgentInstallerURL aws.StringValue   `json:"AgentInstallerUrl,omitempty"`
	Parameters        map[string]string `json:"Parameters,omitempty"`
}

// DescribeStackSummaryRequest is undocumented.
type DescribeStackSummaryRequest struct {
	StackID aws.StringValue `json:"StackId"`
}

// DescribeStackSummaryResult is undocumented.
type DescribeStackSummaryResult struct {
	StackSummary *StackSummary `json:"StackSummary,omitempty"`
}

// DescribeStacksRequest is undocumented.
type DescribeStacksRequest struct {
	StackIDs []string `json:"StackIds,omitempty"`
}

// DescribeStacksResult is undocumented.
type DescribeStacksResult struct {
	Stacks []Stack `json:"Stacks,omitempty"`
}

// DescribeTimeBasedAutoScalingRequest is undocumented.
type DescribeTimeBasedAutoScalingRequest struct {
	InstanceIDs []string `json:"InstanceIds"`
}

// DescribeTimeBasedAutoScalingResult is undocumented.
type DescribeTimeBasedAutoScalingResult struct {
	TimeBasedAutoScalingConfigurations []TimeBasedAutoScalingConfiguration `json:"TimeBasedAutoScalingConfigurations,omitempty"`
}

// DescribeUserProfilesRequest is undocumented.
type DescribeUserProfilesRequest struct {
	IAMUserARNs []string `json:"IamUserArns,omitempty"`
}

// DescribeUserProfilesResult is undocumented.
type DescribeUserProfilesResult struct {
	UserProfiles []UserProfile `json:"UserProfiles,omitempty"`
}

// DescribeVolumesRequest is undocumented.
type DescribeVolumesRequest struct {
	InstanceID  aws.StringValue `json:"InstanceId,omitempty"`
	RAIDArrayID aws.StringValue `json:"RaidArrayId,omitempty"`
	StackID     aws.StringValue `json:"StackId,omitempty"`
	VolumeIDs   []string        `json:"VolumeIds,omitempty"`
}

// DescribeVolumesResult is undocumented.
type DescribeVolumesResult struct {
	Volumes []Volume `json:"Volumes,omitempty"`
}

// DetachElasticLoadBalancerRequest is undocumented.
type DetachElasticLoadBalancerRequest struct {
	ElasticLoadBalancerName aws.StringValue `json:"ElasticLoadBalancerName"`
	LayerID                 aws.StringValue `json:"LayerId"`
}

// DisassociateElasticIPRequest is undocumented.
type DisassociateElasticIPRequest struct {
	ElasticIP aws.StringValue `json:"ElasticIp"`
}

// ElasticIP is undocumented.
type ElasticIP struct {
	Domain     aws.StringValue `json:"Domain,omitempty"`
	InstanceID aws.StringValue `json:"InstanceId,omitempty"`
	IP         aws.StringValue `json:"Ip,omitempty"`
	Name       aws.StringValue `json:"Name,omitempty"`
	Region     aws.StringValue `json:"Region,omitempty"`
}

// ElasticLoadBalancer is undocumented.
type ElasticLoadBalancer struct {
	AvailabilityZones       []string        `json:"AvailabilityZones,omitempty"`
	DNSName                 aws.StringValue `json:"DnsName,omitempty"`
	EC2InstanceIDs          []string        `json:"Ec2InstanceIds,omitempty"`
	ElasticLoadBalancerName aws.StringValue `json:"ElasticLoadBalancerName,omitempty"`
	LayerID                 aws.StringValue `json:"LayerId,omitempty"`
	Region                  aws.StringValue `json:"Region,omitempty"`
	StackID                 aws.StringValue `json:"StackId,omitempty"`
	SubnetIDs               []string        `json:"SubnetIds,omitempty"`
	VPCID                   aws.StringValue `json:"VpcId,omitempty"`
}

// EnvironmentVariable is undocumented.
type EnvironmentVariable struct {
	Key    aws.StringValue  `json:"Key"`
	Secure aws.BooleanValue `json:"Secure,omitempty"`
	Value  aws.StringValue  `json:"Value"`
}

// GetHostnameSuggestionRequest is undocumented.
type GetHostnameSuggestionRequest struct {
	LayerID aws.StringValue `json:"LayerId"`
}

// GetHostnameSuggestionResult is undocumented.
type GetHostnameSuggestionResult struct {
	Hostname aws.StringValue `json:"Hostname,omitempty"`
	LayerID  aws.StringValue `json:"LayerId,omitempty"`
}

// Instance is undocumented.
type Instance struct {
	AMIID                    aws.StringValue  `json:"AmiId,omitempty"`
	Architecture             aws.StringValue  `json:"Architecture,omitempty"`
	AutoScalingType          aws.StringValue  `json:"AutoScalingType,omitempty"`
	AvailabilityZone         aws.StringValue  `json:"AvailabilityZone,omitempty"`
	CreatedAt                aws.StringValue  `json:"CreatedAt,omitempty"`
	EBSOptimized             aws.BooleanValue `json:"EbsOptimized,omitempty"`
	EC2InstanceID            aws.StringValue  `json:"Ec2InstanceId,omitempty"`
	ElasticIP                aws.StringValue  `json:"ElasticIp,omitempty"`
	Hostname                 aws.StringValue  `json:"Hostname,omitempty"`
	InfrastructureClass      aws.StringValue  `json:"InfrastructureClass,omitempty"`
	InstallUpdatesOnBoot     aws.BooleanValue `json:"InstallUpdatesOnBoot,omitempty"`
	InstanceID               aws.StringValue  `json:"InstanceId,omitempty"`
	InstanceProfileARN       aws.StringValue  `json:"InstanceProfileArn,omitempty"`
	InstanceType             aws.StringValue  `json:"InstanceType,omitempty"`
	LastServiceErrorID       aws.StringValue  `json:"LastServiceErrorId,omitempty"`
	LayerIDs                 []string         `json:"LayerIds,omitempty"`
	OS                       aws.StringValue  `json:"Os,omitempty"`
	PrivateDNS               aws.StringValue  `json:"PrivateDns,omitempty"`
	PrivateIP                aws.StringValue  `json:"PrivateIp,omitempty"`
	PublicDNS                aws.StringValue  `json:"PublicDns,omitempty"`
	PublicIP                 aws.StringValue  `json:"PublicIp,omitempty"`
	RegisteredBy             aws.StringValue  `json:"RegisteredBy,omitempty"`
	ReportedOS               *ReportedOS      `json:"ReportedOs,omitempty"`
	RootDeviceType           aws.StringValue  `json:"RootDeviceType,omitempty"`
	RootDeviceVolumeID       aws.StringValue  `json:"RootDeviceVolumeId,omitempty"`
	SecurityGroupIDs         []string         `json:"SecurityGroupIds,omitempty"`
	SSHHostDsaKeyFingerprint aws.StringValue  `json:"SshHostDsaKeyFingerprint,omitempty"`
	SSHHostRsaKeyFingerprint aws.StringValue  `json:"SshHostRsaKeyFingerprint,omitempty"`
	SSHKeyName               aws.StringValue  `json:"SshKeyName,omitempty"`
	StackID                  aws.StringValue  `json:"StackId,omitempty"`
	Status                   aws.StringValue  `json:"Status,omitempty"`
	SubnetID                 aws.StringValue  `json:"SubnetId,omitempty"`
	VirtualizationType       aws.StringValue  `json:"VirtualizationType,omitempty"`
}

// InstanceIdentity is undocumented.
type InstanceIdentity struct {
	Document  aws.StringValue `json:"Document,omitempty"`
	Signature aws.StringValue `json:"Signature,omitempty"`
}

// InstancesCount is undocumented.
type InstancesCount struct {
	Assigning      aws.IntegerValue `json:"Assigning,omitempty"`
	Booting        aws.IntegerValue `json:"Booting,omitempty"`
	ConnectionLost aws.IntegerValue `json:"ConnectionLost,omitempty"`
	Deregistering  aws.IntegerValue `json:"Deregistering,omitempty"`
	Online         aws.IntegerValue `json:"Online,omitempty"`
	Pending        aws.IntegerValue `json:"Pending,omitempty"`
	Rebooting      aws.IntegerValue `json:"Rebooting,omitempty"`
	Registered     aws.IntegerValue `json:"Registered,omitempty"`
	Registering    aws.IntegerValue `json:"Registering,omitempty"`
	Requested      aws.IntegerValue `json:"Requested,omitempty"`
	RunningSetup   aws.IntegerValue `json:"RunningSetup,omitempty"`
	SetupFailed    aws.IntegerValue `json:"SetupFailed,omitempty"`
	ShuttingDown   aws.IntegerValue `json:"ShuttingDown,omitempty"`
	StartFailed    aws.IntegerValue `json:"StartFailed,omitempty"`
	Stopped        aws.IntegerValue `json:"Stopped,omitempty"`
	Stopping       aws.IntegerValue `json:"Stopping,omitempty"`
	Terminated     aws.IntegerValue `json:"Terminated,omitempty"`
	Terminating    aws.IntegerValue `json:"Terminating,omitempty"`
	Unassigning    aws.IntegerValue `json:"Unassigning,omitempty"`
}

// Layer is undocumented.
type Layer struct {
	Attributes                  map[string]string            `json:"Attributes,omitempty"`
	AutoAssignElasticIPs        aws.BooleanValue             `json:"AutoAssignElasticIps,omitempty"`
	AutoAssignPublicIPs         aws.BooleanValue             `json:"AutoAssignPublicIps,omitempty"`
	CreatedAt                   aws.StringValue              `json:"CreatedAt,omitempty"`
	CustomInstanceProfileARN    aws.StringValue              `json:"CustomInstanceProfileArn,omitempty"`
	CustomRecipes               *Recipes                     `json:"CustomRecipes,omitempty"`
	CustomSecurityGroupIDs      []string                     `json:"CustomSecurityGroupIds,omitempty"`
	DefaultRecipes              *Recipes                     `json:"DefaultRecipes,omitempty"`
	DefaultSecurityGroupNames   []string                     `json:"DefaultSecurityGroupNames,omitempty"`
	EnableAutoHealing           aws.BooleanValue             `json:"EnableAutoHealing,omitempty"`
	InstallUpdatesOnBoot        aws.BooleanValue             `json:"InstallUpdatesOnBoot,omitempty"`
	LayerID                     aws.StringValue              `json:"LayerId,omitempty"`
	LifecycleEventConfiguration *LifecycleEventConfiguration `json:"LifecycleEventConfiguration,omitempty"`
	Name                        aws.StringValue              `json:"Name,omitempty"`
	Packages                    []string                     `json:"Packages,omitempty"`
	Shortname                   aws.StringValue              `json:"Shortname,omitempty"`
	StackID                     aws.StringValue              `json:"StackId,omitempty"`
	Type                        aws.StringValue              `json:"Type,omitempty"`
	UseEBSOptimizedInstances    aws.BooleanValue             `json:"UseEbsOptimizedInstances,omitempty"`
	VolumeConfigurations        []VolumeConfiguration        `json:"VolumeConfigurations,omitempty"`
}

// Possible values for OpsWorks.
const (
	LayerAttributesKeysBundlerVersion              = "BundlerVersion"
	LayerAttributesKeysEnableHaproxyStats          = "EnableHaproxyStats"
	LayerAttributesKeysGangliaPassword             = "GangliaPassword"
	LayerAttributesKeysGangliaURL                  = "GangliaUrl"
	LayerAttributesKeysGangliaUser                 = "GangliaUser"
	LayerAttributesKeysHaproxyHealthCheckMethod    = "HaproxyHealthCheckMethod"
	LayerAttributesKeysHaproxyHealthCheckURL       = "HaproxyHealthCheckUrl"
	LayerAttributesKeysHaproxyStatsPassword        = "HaproxyStatsPassword"
	LayerAttributesKeysHaproxyStatsURL             = "HaproxyStatsUrl"
	LayerAttributesKeysHaproxyStatsUser            = "HaproxyStatsUser"
	LayerAttributesKeysJVM                         = "Jvm"
	LayerAttributesKeysJVMOptions                  = "JvmOptions"
	LayerAttributesKeysJVMVersion                  = "JvmVersion"
	LayerAttributesKeysJavaAppServer               = "JavaAppServer"
	LayerAttributesKeysJavaAppServerVersion        = "JavaAppServerVersion"
	LayerAttributesKeysManageBundler               = "ManageBundler"
	LayerAttributesKeysMemcachedMemory             = "MemcachedMemory"
	LayerAttributesKeysMysqlRootPassword           = "MysqlRootPassword"
	LayerAttributesKeysMysqlRootPasswordUbiquitous = "MysqlRootPasswordUbiquitous"
	LayerAttributesKeysNodejsVersion               = "NodejsVersion"
	LayerAttributesKeysPassengerVersion            = "PassengerVersion"
	LayerAttributesKeysRailsStack                  = "RailsStack"
	LayerAttributesKeysRubyVersion                 = "RubyVersion"
	LayerAttributesKeysRubygemsVersion             = "RubygemsVersion"
)

// Possible values for OpsWorks.
const (
	LayerTypeCustom           = "custom"
	LayerTypeDBMaster         = "db-master"
	LayerTypeJavaApp          = "java-app"
	LayerTypeLb               = "lb"
	LayerTypeMemcached        = "memcached"
	LayerTypeMonitoringMaster = "monitoring-master"
	LayerTypeNodejsApp        = "nodejs-app"
	LayerTypePHPApp           = "php-app"
	LayerTypeRailsApp         = "rails-app"
	LayerTypeWeb              = "web"
)

// LifecycleEventConfiguration is undocumented.
type LifecycleEventConfiguration struct {
	Shutdown *ShutdownEventConfiguration `json:"Shutdown,omitempty"`
}

// LoadBasedAutoScalingConfiguration is undocumented.
type LoadBasedAutoScalingConfiguration struct {
	DownScaling *AutoScalingThresholds `json:"DownScaling,omitempty"`
	Enable      aws.BooleanValue       `json:"Enable,omitempty"`
	LayerID     aws.StringValue        `json:"LayerId,omitempty"`
	UpScaling   *AutoScalingThresholds `json:"UpScaling,omitempty"`
}

// Permission is undocumented.
type Permission struct {
	AllowSSH   aws.BooleanValue `json:"AllowSsh,omitempty"`
	AllowSudo  aws.BooleanValue `json:"AllowSudo,omitempty"`
	IAMUserARN aws.StringValue  `json:"IamUserArn,omitempty"`
	Level      aws.StringValue  `json:"Level,omitempty"`
	StackID    aws.StringValue  `json:"StackId,omitempty"`
}

// RAIDArray is undocumented.
type RAIDArray struct {
	AvailabilityZone aws.StringValue  `json:"AvailabilityZone,omitempty"`
	CreatedAt        aws.StringValue  `json:"CreatedAt,omitempty"`
	Device           aws.StringValue  `json:"Device,omitempty"`
	InstanceID       aws.StringValue  `json:"InstanceId,omitempty"`
	IOPS             aws.IntegerValue `json:"Iops,omitempty"`
	MountPoint       aws.StringValue  `json:"MountPoint,omitempty"`
	Name             aws.StringValue  `json:"Name,omitempty"`
	NumberOfDisks    aws.IntegerValue `json:"NumberOfDisks,omitempty"`
	RAIDArrayID      aws.StringValue  `json:"RaidArrayId,omitempty"`
	RAIDLevel        aws.IntegerValue `json:"RaidLevel,omitempty"`
	Size             aws.IntegerValue `json:"Size,omitempty"`
	StackID          aws.StringValue  `json:"StackId,omitempty"`
	VolumeType       aws.StringValue  `json:"VolumeType,omitempty"`
}

// RDSDBInstance is undocumented.
type RDSDBInstance struct {
	Address              aws.StringValue  `json:"Address,omitempty"`
	DBInstanceIdentifier aws.StringValue  `json:"DbInstanceIdentifier,omitempty"`
	DBPassword           aws.StringValue  `json:"DbPassword,omitempty"`
	DBUser               aws.StringValue  `json:"DbUser,omitempty"`
	Engine               aws.StringValue  `json:"Engine,omitempty"`
	MissingOnRDS         aws.BooleanValue `json:"MissingOnRds,omitempty"`
	RDSDBInstanceARN     aws.StringValue  `json:"RdsDbInstanceArn,omitempty"`
	Region               aws.StringValue  `json:"Region,omitempty"`
	StackID              aws.StringValue  `json:"StackId,omitempty"`
}

// RebootInstanceRequest is undocumented.
type RebootInstanceRequest struct {
	InstanceID aws.StringValue `json:"InstanceId"`
}

// Recipes is undocumented.
type Recipes struct {
	Configure []string `json:"Configure,omitempty"`
	Deploy    []string `json:"Deploy,omitempty"`
	Setup     []string `json:"Setup,omitempty"`
	Shutdown  []string `json:"Shutdown,omitempty"`
	Undeploy  []string `json:"Undeploy,omitempty"`
}

// RegisterElasticIPRequest is undocumented.
type RegisterElasticIPRequest struct {
	ElasticIP aws.StringValue `json:"ElasticIp"`
	StackID   aws.StringValue `json:"StackId"`
}

// RegisterElasticIPResult is undocumented.
type RegisterElasticIPResult struct {
	ElasticIP aws.StringValue `json:"ElasticIp,omitempty"`
}

// RegisterInstanceRequest is undocumented.
type RegisterInstanceRequest struct {
	Hostname                aws.StringValue   `json:"Hostname,omitempty"`
	InstanceIdentity        *InstanceIdentity `json:"InstanceIdentity,omitempty"`
	PrivateIP               aws.StringValue   `json:"PrivateIp,omitempty"`
	PublicIP                aws.StringValue   `json:"PublicIp,omitempty"`
	RsaPublicKey            aws.StringValue   `json:"RsaPublicKey,omitempty"`
	RsaPublicKeyFingerprint aws.StringValue   `json:"RsaPublicKeyFingerprint,omitempty"`
	StackID                 aws.StringValue   `json:"StackId"`
}

// RegisterInstanceResult is undocumented.
type RegisterInstanceResult struct {
	InstanceID aws.StringValue `json:"InstanceId,omitempty"`
}

// RegisterRDSDBInstanceRequest is undocumented.
type RegisterRDSDBInstanceRequest struct {
	DBPassword       aws.StringValue `json:"DbPassword"`
	DBUser           aws.StringValue `json:"DbUser"`
	RDSDBInstanceARN aws.StringValue `json:"RdsDbInstanceArn"`
	StackID          aws.StringValue `json:"StackId"`
}

// RegisterVolumeRequest is undocumented.
type RegisterVolumeRequest struct {
	EC2VolumeID aws.StringValue `json:"Ec2VolumeId,omitempty"`
	StackID     aws.StringValue `json:"StackId"`
}

// RegisterVolumeResult is undocumented.
type RegisterVolumeResult struct {
	VolumeID aws.StringValue `json:"VolumeId,omitempty"`
}

// ReportedOS is undocumented.
type ReportedOS struct {
	Family  aws.StringValue `json:"Family,omitempty"`
	Name    aws.StringValue `json:"Name,omitempty"`
	Version aws.StringValue `json:"Version,omitempty"`
}

// Possible values for OpsWorks.
const (
	RootDeviceTypeEBS           = "ebs"
	RootDeviceTypeInstanceStore = "instance-store"
)

// SelfUserProfile is undocumented.
type SelfUserProfile struct {
	IAMUserARN   aws.StringValue `json:"IamUserArn,omitempty"`
	Name         aws.StringValue `json:"Name,omitempty"`
	SSHPublicKey aws.StringValue `json:"SshPublicKey,omitempty"`
	SSHUsername  aws.StringValue `json:"SshUsername,omitempty"`
}

// ServiceError is undocumented.
type ServiceError struct {
	CreatedAt      aws.StringValue `json:"CreatedAt,omitempty"`
	InstanceID     aws.StringValue `json:"InstanceId,omitempty"`
	Message        aws.StringValue `json:"Message,omitempty"`
	ServiceErrorID aws.StringValue `json:"ServiceErrorId,omitempty"`
	StackID        aws.StringValue `json:"StackId,omitempty"`
	Type           aws.StringValue `json:"Type,omitempty"`
}

// SetLoadBasedAutoScalingRequest is undocumented.
type SetLoadBasedAutoScalingRequest struct {
	DownScaling *AutoScalingThresholds `json:"DownScaling,omitempty"`
	Enable      aws.BooleanValue       `json:"Enable,omitempty"`
	LayerID     aws.StringValue        `json:"LayerId"`
	UpScaling   *AutoScalingThresholds `json:"UpScaling,omitempty"`
}

// SetPermissionRequest is undocumented.
type SetPermissionRequest struct {
	AllowSSH   aws.BooleanValue `json:"AllowSsh,omitempty"`
	AllowSudo  aws.BooleanValue `json:"AllowSudo,omitempty"`
	IAMUserARN aws.StringValue  `json:"IamUserArn"`
	Level      aws.StringValue  `json:"Level,omitempty"`
	StackID    aws.StringValue  `json:"StackId"`
}

// SetTimeBasedAutoScalingRequest is undocumented.
type SetTimeBasedAutoScalingRequest struct {
	AutoScalingSchedule *WeeklyAutoScalingSchedule `json:"AutoScalingSchedule,omitempty"`
	InstanceID          aws.StringValue            `json:"InstanceId"`
}

// ShutdownEventConfiguration is undocumented.
type ShutdownEventConfiguration struct {
	DelayUntilElbConnectionsDrained aws.BooleanValue `json:"DelayUntilElbConnectionsDrained,omitempty"`
	ExecutionTimeout                aws.IntegerValue `json:"ExecutionTimeout,omitempty"`
}

// Source is undocumented.
type Source struct {
	Password aws.StringValue `json:"Password,omitempty"`
	Revision aws.StringValue `json:"Revision,omitempty"`
	SSHKey   aws.StringValue `json:"SshKey,omitempty"`
	Type     aws.StringValue `json:"Type,omitempty"`
	URL      aws.StringValue `json:"Url,omitempty"`
	Username aws.StringValue `json:"Username,omitempty"`
}

// Possible values for OpsWorks.
const (
	SourceTypeArchive = "archive"
	SourceTypeGit     = "git"
	SourceTypeS3      = "s3"
	SourceTypeSVN     = "svn"
)

// SSLConfiguration is undocumented.
type SSLConfiguration struct {
	Certificate aws.StringValue `json:"Certificate"`
	Chain       aws.StringValue `json:"Chain,omitempty"`
	PrivateKey  aws.StringValue `json:"PrivateKey"`
}

// Stack is undocumented.
type Stack struct {
	ARN                       aws.StringValue            `json:"Arn,omitempty"`
	Attributes                map[string]string          `json:"Attributes,omitempty"`
	ChefConfiguration         *ChefConfiguration         `json:"ChefConfiguration,omitempty"`
	ConfigurationManager      *StackConfigurationManager `json:"ConfigurationManager,omitempty"`
	CreatedAt                 aws.StringValue            `json:"CreatedAt,omitempty"`
	CustomCookbooksSource     *Source                    `json:"CustomCookbooksSource,omitempty"`
	CustomJSON                aws.StringValue            `json:"CustomJson,omitempty"`
	DefaultAvailabilityZone   aws.StringValue            `json:"DefaultAvailabilityZone,omitempty"`
	DefaultInstanceProfileARN aws.StringValue            `json:"DefaultInstanceProfileArn,omitempty"`
	DefaultOS                 aws.StringValue            `json:"DefaultOs,omitempty"`
	DefaultRootDeviceType     aws.StringValue            `json:"DefaultRootDeviceType,omitempty"`
	DefaultSSHKeyName         aws.StringValue            `json:"DefaultSshKeyName,omitempty"`
	DefaultSubnetID           aws.StringValue            `json:"DefaultSubnetId,omitempty"`
	HostnameTheme             aws.StringValue            `json:"HostnameTheme,omitempty"`
	Name                      aws.StringValue            `json:"Name,omitempty"`
	Region                    aws.StringValue            `json:"Region,omitempty"`
	ServiceRoleARN            aws.StringValue            `json:"ServiceRoleArn,omitempty"`
	StackID                   aws.StringValue            `json:"StackId,omitempty"`
	UseCustomCookbooks        aws.BooleanValue           `json:"UseCustomCookbooks,omitempty"`
	UseOpsworksSecurityGroups aws.BooleanValue           `json:"UseOpsworksSecurityGroups,omitempty"`
	VPCID                     aws.StringValue            `json:"VpcId,omitempty"`
}

// Possible values for OpsWorks.
const (
	StackAttributesKeysColor = "Color"
)

// StackConfigurationManager is undocumented.
type StackConfigurationManager struct {
	Name    aws.StringValue `json:"Name,omitempty"`
	Version aws.StringValue `json:"Version,omitempty"`
}

// StackSummary is undocumented.
type StackSummary struct {
	AppsCount      aws.IntegerValue `json:"AppsCount,omitempty"`
	ARN            aws.StringValue  `json:"Arn,omitempty"`
	InstancesCount *InstancesCount  `json:"InstancesCount,omitempty"`
	LayersCount    aws.IntegerValue `json:"LayersCount,omitempty"`
	Name           aws.StringValue  `json:"Name,omitempty"`
	StackID        aws.StringValue  `json:"StackId,omitempty"`
}

// StartInstanceRequest is undocumented.
type StartInstanceRequest struct {
	InstanceID aws.StringValue `json:"InstanceId"`
}

// StartStackRequest is undocumented.
type StartStackRequest struct {
	StackID aws.StringValue `json:"StackId"`
}

// StopInstanceRequest is undocumented.
type StopInstanceRequest struct {
	InstanceID aws.StringValue `json:"InstanceId"`
}

// StopStackRequest is undocumented.
type StopStackRequest struct {
	StackID aws.StringValue `json:"StackId"`
}

// TimeBasedAutoScalingConfiguration is undocumented.
type TimeBasedAutoScalingConfiguration struct {
	AutoScalingSchedule *WeeklyAutoScalingSchedule `json:"AutoScalingSchedule,omitempty"`
	InstanceID          aws.StringValue            `json:"InstanceId,omitempty"`
}

// UnassignInstanceRequest is undocumented.
type UnassignInstanceRequest struct {
	InstanceID aws.StringValue `json:"InstanceId"`
}

// UnassignVolumeRequest is undocumented.
type UnassignVolumeRequest struct {
	VolumeID aws.StringValue `json:"VolumeId"`
}

// UpdateAppRequest is undocumented.
type UpdateAppRequest struct {
	AppID            aws.StringValue       `json:"AppId"`
	AppSource        *Source               `json:"AppSource,omitempty"`
	Attributes       map[string]string     `json:"Attributes,omitempty"`
	DataSources      []DataSource          `json:"DataSources,omitempty"`
	Description      aws.StringValue       `json:"Description,omitempty"`
	Domains          []string              `json:"Domains,omitempty"`
	EnableSSL        aws.BooleanValue      `json:"EnableSsl,omitempty"`
	Environment      []EnvironmentVariable `json:"Environment,omitempty"`
	Name             aws.StringValue       `json:"Name,omitempty"`
	SSLConfiguration *SSLConfiguration     `json:"SslConfiguration,omitempty"`
	Type             aws.StringValue       `json:"Type,omitempty"`
}

// UpdateElasticIPRequest is undocumented.
type UpdateElasticIPRequest struct {
	ElasticIP aws.StringValue `json:"ElasticIp"`
	Name      aws.StringValue `json:"Name,omitempty"`
}

// UpdateInstanceRequest is undocumented.
type UpdateInstanceRequest struct {
	AMIID                aws.StringValue  `json:"AmiId,omitempty"`
	Architecture         aws.StringValue  `json:"Architecture,omitempty"`
	AutoScalingType      aws.StringValue  `json:"AutoScalingType,omitempty"`
	EBSOptimized         aws.BooleanValue `json:"EbsOptimized,omitempty"`
	Hostname             aws.StringValue  `json:"Hostname,omitempty"`
	InstallUpdatesOnBoot aws.BooleanValue `json:"InstallUpdatesOnBoot,omitempty"`
	InstanceID           aws.StringValue  `json:"InstanceId"`
	InstanceType         aws.StringValue  `json:"InstanceType,omitempty"`
	LayerIDs             []string         `json:"LayerIds,omitempty"`
	OS                   aws.StringValue  `json:"Os,omitempty"`
	SSHKeyName           aws.StringValue  `json:"SshKeyName,omitempty"`
}

// UpdateLayerRequest is undocumented.
type UpdateLayerRequest struct {
	Attributes                  map[string]string            `json:"Attributes,omitempty"`
	AutoAssignElasticIPs        aws.BooleanValue             `json:"AutoAssignElasticIps,omitempty"`
	AutoAssignPublicIPs         aws.BooleanValue             `json:"AutoAssignPublicIps,omitempty"`
	CustomInstanceProfileARN    aws.StringValue              `json:"CustomInstanceProfileArn,omitempty"`
	CustomRecipes               *Recipes                     `json:"CustomRecipes,omitempty"`
	CustomSecurityGroupIDs      []string                     `json:"CustomSecurityGroupIds,omitempty"`
	EnableAutoHealing           aws.BooleanValue             `json:"EnableAutoHealing,omitempty"`
	InstallUpdatesOnBoot        aws.BooleanValue             `json:"InstallUpdatesOnBoot,omitempty"`
	LayerID                     aws.StringValue              `json:"LayerId"`
	LifecycleEventConfiguration *LifecycleEventConfiguration `json:"LifecycleEventConfiguration,omitempty"`
	Name                        aws.StringValue              `json:"Name,omitempty"`
	Packages                    []string                     `json:"Packages,omitempty"`
	Shortname                   aws.StringValue              `json:"Shortname,omitempty"`
	UseEBSOptimizedInstances    aws.BooleanValue             `json:"UseEbsOptimizedInstances,omitempty"`
	VolumeConfigurations        []VolumeConfiguration        `json:"VolumeConfigurations,omitempty"`
}

// UpdateMyUserProfileRequest is undocumented.
type UpdateMyUserProfileRequest struct {
	SSHPublicKey aws.StringValue `json:"SshPublicKey,omitempty"`
}

// UpdateRDSDBInstanceRequest is undocumented.
type UpdateRDSDBInstanceRequest struct {
	DBPassword       aws.StringValue `json:"DbPassword,omitempty"`
	DBUser           aws.StringValue `json:"DbUser,omitempty"`
	RDSDBInstanceARN aws.StringValue `json:"RdsDbInstanceArn"`
}

// UpdateStackRequest is undocumented.
type UpdateStackRequest struct {
	Attributes                map[string]string          `json:"Attributes,omitempty"`
	ChefConfiguration         *ChefConfiguration         `json:"ChefConfiguration,omitempty"`
	ConfigurationManager      *StackConfigurationManager `json:"ConfigurationManager,omitempty"`
	CustomCookbooksSource     *Source                    `json:"CustomCookbooksSource,omitempty"`
	CustomJSON                aws.StringValue            `json:"CustomJson,omitempty"`
	DefaultAvailabilityZone   aws.StringValue            `json:"DefaultAvailabilityZone,omitempty"`
	DefaultInstanceProfileARN aws.StringValue            `json:"DefaultInstanceProfileArn,omitempty"`
	DefaultOS                 aws.StringValue            `json:"DefaultOs,omitempty"`
	DefaultRootDeviceType     aws.StringValue            `json:"DefaultRootDeviceType,omitempty"`
	DefaultSSHKeyName         aws.StringValue            `json:"DefaultSshKeyName,omitempty"`
	DefaultSubnetID           aws.StringValue            `json:"DefaultSubnetId,omitempty"`
	HostnameTheme             aws.StringValue            `json:"HostnameTheme,omitempty"`
	Name                      aws.StringValue            `json:"Name,omitempty"`
	ServiceRoleARN            aws.StringValue            `json:"ServiceRoleArn,omitempty"`
	StackID                   aws.StringValue            `json:"StackId"`
	UseCustomCookbooks        aws.BooleanValue           `json:"UseCustomCookbooks,omitempty"`
	UseOpsworksSecurityGroups aws.BooleanValue           `json:"UseOpsworksSecurityGroups,omitempty"`
}

// UpdateUserProfileRequest is undocumented.
type UpdateUserProfileRequest struct {
	AllowSelfManagement aws.BooleanValue `json:"AllowSelfManagement,omitempty"`
	IAMUserARN          aws.StringValue  `json:"IamUserArn"`
	SSHPublicKey        aws.StringValue  `json:"SshPublicKey,omitempty"`
	SSHUsername         aws.StringValue  `json:"SshUsername,omitempty"`
}

// UpdateVolumeRequest is undocumented.
type UpdateVolumeRequest struct {
	MountPoint aws.StringValue `json:"MountPoint,omitempty"`
	Name       aws.StringValue `json:"Name,omitempty"`
	VolumeID   aws.StringValue `json:"VolumeId"`
}

// UserProfile is undocumented.
type UserProfile struct {
	AllowSelfManagement aws.BooleanValue `json:"AllowSelfManagement,omitempty"`
	IAMUserARN          aws.StringValue  `json:"IamUserArn,omitempty"`
	Name                aws.StringValue  `json:"Name,omitempty"`
	SSHPublicKey        aws.StringValue  `json:"SshPublicKey,omitempty"`
	SSHUsername         aws.StringValue  `json:"SshUsername,omitempty"`
}

// Possible values for OpsWorks.
const (
	VirtualizationTypeHVM         = "hvm"
	VirtualizationTypeParavirtual = "paravirtual"
)

// Volume is undocumented.
type Volume struct {
	AvailabilityZone aws.StringValue  `json:"AvailabilityZone,omitempty"`
	Device           aws.StringValue  `json:"Device,omitempty"`
	EC2VolumeID      aws.StringValue  `json:"Ec2VolumeId,omitempty"`
	InstanceID       aws.StringValue  `json:"InstanceId,omitempty"`
	IOPS             aws.IntegerValue `json:"Iops,omitempty"`
	MountPoint       aws.StringValue  `json:"MountPoint,omitempty"`
	Name             aws.StringValue  `json:"Name,omitempty"`
	RAIDArrayID      aws.StringValue  `json:"RaidArrayId,omitempty"`
	Region           aws.StringValue  `json:"Region,omitempty"`
	Size             aws.IntegerValue `json:"Size,omitempty"`
	Status           aws.StringValue  `json:"Status,omitempty"`
	VolumeID         aws.StringValue  `json:"VolumeId,omitempty"`
	VolumeType       aws.StringValue  `json:"VolumeType,omitempty"`
}

// VolumeConfiguration is undocumented.
type VolumeConfiguration struct {
	IOPS          aws.IntegerValue `json:"Iops,omitempty"`
	MountPoint    aws.StringValue  `json:"MountPoint"`
	NumberOfDisks aws.IntegerValue `json:"NumberOfDisks"`
	RAIDLevel     aws.IntegerValue `json:"RaidLevel,omitempty"`
	Size          aws.IntegerValue `json:"Size"`
	VolumeType    aws.StringValue  `json:"VolumeType,omitempty"`
}

// WeeklyAutoScalingSchedule is undocumented.
type WeeklyAutoScalingSchedule struct {
	Friday    map[string]string `json:"Friday,omitempty"`
	Monday    map[string]string `json:"Monday,omitempty"`
	Saturday  map[string]string `json:"Saturday,omitempty"`
	Sunday    map[string]string `json:"Sunday,omitempty"`
	Thursday  map[string]string `json:"Thursday,omitempty"`
	Tuesday   map[string]string `json:"Tuesday,omitempty"`
	Wednesday map[string]string `json:"Wednesday,omitempty"`
}

// avoid errors if the packages aren't referenced
var _ time.Time
