// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package rds provides a client for Amazon Relational Database Service.
package rds

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"encoding/xml"
	"io"
)

// RDS is a client for Amazon Relational Database Service.
type RDS struct {
	client *aws.QueryClient
}

// New returns a new RDS client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *RDS {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("rds", region)

	return &RDS{
		client: &aws.QueryClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2014-10-31",
		},
	}
}

// AddSourceIdentifierToSubscription adds a source identifier to an
// existing RDS event notification subscription.
func (c *RDS) AddSourceIdentifierToSubscription(req *AddSourceIdentifierToSubscriptionMessage) (resp *AddSourceIdentifierToSubscriptionResult, err error) {
	resp = &AddSourceIdentifierToSubscriptionResult{}
	err = c.client.Do("AddSourceIdentifierToSubscription", "POST", "/", req, resp)
	return
}

// AddTagsToResource adds metadata tags to an Amazon RDS resource. These
// tags can also be used with cost allocation reporting to track cost
// associated with Amazon RDS resources, or used in Condition statement in
// IAM policy for Amazon For an overview on tagging Amazon RDS resources,
// see Tagging Amazon RDS Resources
func (c *RDS) AddTagsToResource(req *AddTagsToResourceMessage) (err error) {
	// NRE
	err = c.client.Do("AddTagsToResource", "POST", "/", req, nil)
	return
}

// ApplyPendingMaintenanceAction applies a pending maintenance action to a
// resource.
func (c *RDS) ApplyPendingMaintenanceAction(req *ApplyPendingMaintenanceActionMessage) (resp *ApplyPendingMaintenanceActionResult, err error) {
	resp = &ApplyPendingMaintenanceActionResult{}
	err = c.client.Do("ApplyPendingMaintenanceAction", "POST", "/", req, resp)
	return
}

// AuthorizeDBSecurityGroupIngress enables ingress to a DBSecurityGroup
// using one of two forms of authorization. First, EC2 or VPC security
// groups can be added to the DBSecurityGroup if the application using the
// database is running on EC2 or VPC instances. Second, IP ranges are
// available if the application accessing your database is running on the
// Internet. Required parameters for this API are one of range,
// EC2SecurityGroupId for or (EC2SecurityGroupOwnerId and either
// EC2SecurityGroupName or EC2SecurityGroupId for non-VPC). You cannot
// authorize ingress from an EC2 security group in one Region to an Amazon
// RDS DB instance in another. You cannot authorize ingress from a VPC
// security group in one VPC to an Amazon RDS DB instance in another. For
// an overview of ranges, go to the Wikipedia Tutorial .
func (c *RDS) AuthorizeDBSecurityGroupIngress(req *AuthorizeDBSecurityGroupIngressMessage) (resp *AuthorizeDBSecurityGroupIngressResult, err error) {
	resp = &AuthorizeDBSecurityGroupIngressResult{}
	err = c.client.Do("AuthorizeDBSecurityGroupIngress", "POST", "/", req, resp)
	return
}

// CopyDBParameterGroup is undocumented.
func (c *RDS) CopyDBParameterGroup(req *CopyDBParameterGroupMessage) (resp *CopyDBParameterGroupResult, err error) {
	resp = &CopyDBParameterGroupResult{}
	err = c.client.Do("CopyDBParameterGroup", "POST", "/", req, resp)
	return
}

// CopyDBSnapshot copies the specified DBSnapshot. The source DBSnapshot
// must be in the "available" state.
func (c *RDS) CopyDBSnapshot(req *CopyDBSnapshotMessage) (resp *CopyDBSnapshotResult, err error) {
	resp = &CopyDBSnapshotResult{}
	err = c.client.Do("CopyDBSnapshot", "POST", "/", req, resp)
	return
}

// CopyOptionGroup is undocumented.
func (c *RDS) CopyOptionGroup(req *CopyOptionGroupMessage) (resp *CopyOptionGroupResult, err error) {
	resp = &CopyOptionGroupResult{}
	err = c.client.Do("CopyOptionGroup", "POST", "/", req, resp)
	return
}

// CreateDBInstance is undocumented.
func (c *RDS) CreateDBInstance(req *CreateDBInstanceMessage) (resp *CreateDBInstanceResult, err error) {
	resp = &CreateDBInstanceResult{}
	err = c.client.Do("CreateDBInstance", "POST", "/", req, resp)
	return
}

// CreateDBInstanceReadReplica creates a DB instance that acts as a Read
// Replica of a source DB instance. All Read Replica DB instances are
// created as Single-AZ deployments with backups disabled. All other DB
// instance attributes (including DB security groups and DB parameter
// groups) are inherited from the source DB instance, except as specified
// below. The source DB instance must have backup retention enabled.
func (c *RDS) CreateDBInstanceReadReplica(req *CreateDBInstanceReadReplicaMessage) (resp *CreateDBInstanceReadReplicaResult, err error) {
	resp = &CreateDBInstanceReadReplicaResult{}
	err = c.client.Do("CreateDBInstanceReadReplica", "POST", "/", req, resp)
	return
}

// CreateDBParameterGroup creates a new DB parameter group. A DB parameter
// group is initially created with the default parameters for the database
// engine used by the DB instance. To provide custom values for any of the
// parameters, you must modify the group after creating it using
// ModifyDBParameterGroup . Once you've created a DB parameter group, you
// need to associate it with your DB instance using ModifyDBInstance . When
// you associate a new DB parameter group with a running DB instance, you
// need to reboot the DB instance without failover for the new DB parameter
// group and associated settings to take effect. After you create a DB
// parameter group, you should wait at least 5 minutes before creating your
// first DB instance that uses that DB parameter group as the default
// parameter group. This allows Amazon RDS to fully complete the create
// action before the parameter group is used as the default for a new DB
// instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the
// character set for the default database defined by the
// character_set_database parameter. You can use the Parameter Groups
// option of the Amazon RDS console or the DescribeDBParameters command to
// verify that your DB parameter group has been created or modified.
func (c *RDS) CreateDBParameterGroup(req *CreateDBParameterGroupMessage) (resp *CreateDBParameterGroupResult, err error) {
	resp = &CreateDBParameterGroupResult{}
	err = c.client.Do("CreateDBParameterGroup", "POST", "/", req, resp)
	return
}

// CreateDBSecurityGroup creates a new DB security group. DB security
// groups control access to a DB instance.
func (c *RDS) CreateDBSecurityGroup(req *CreateDBSecurityGroupMessage) (resp *CreateDBSecurityGroupResult, err error) {
	resp = &CreateDBSecurityGroupResult{}
	err = c.client.Do("CreateDBSecurityGroup", "POST", "/", req, resp)
	return
}

// CreateDBSnapshot creates a DBSnapshot. The source DBInstance must be in
// "available" state.
func (c *RDS) CreateDBSnapshot(req *CreateDBSnapshotMessage) (resp *CreateDBSnapshotResult, err error) {
	resp = &CreateDBSnapshotResult{}
	err = c.client.Do("CreateDBSnapshot", "POST", "/", req, resp)
	return
}

// CreateDBSubnetGroup creates a new DB subnet group. DB subnet groups must
// contain at least one subnet in at least two AZs in the region.
func (c *RDS) CreateDBSubnetGroup(req *CreateDBSubnetGroupMessage) (resp *CreateDBSubnetGroupResult, err error) {
	resp = &CreateDBSubnetGroupResult{}
	err = c.client.Do("CreateDBSubnetGroup", "POST", "/", req, resp)
	return
}

// CreateEventSubscription creates an RDS event notification subscription.
// This action requires a topic ARN (Amazon Resource Name) created by
// either the RDS console, the SNS console, or the SNS To obtain an ARN
// with you must create a topic in Amazon SNS and subscribe to the topic.
// The ARN is displayed in the SNS console. You can specify the type of
// source (SourceType) you want to be notified of, provide a list of RDS
// sources (SourceIds) that triggers the events, and provide a list of
// event categories (EventCategories) for events you want to be notified
// of. For example, you can specify SourceType = db-instance, SourceIds =
// mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.
// If you specify both the SourceType and SourceIds, such as SourceType =
// db-instance and SourceIdentifier = myDBInstance1, you will be notified
// of all the db-instance events for the specified source. If you specify a
// SourceType but do not specify a SourceIdentifier, you will receive
// notice of the events for that source type for all your RDS sources. If
// you do not specify either the SourceType nor the SourceIdentifier, you
// will be notified of events generated from all RDS sources belonging to
// your customer account.
func (c *RDS) CreateEventSubscription(req *CreateEventSubscriptionMessage) (resp *CreateEventSubscriptionResult, err error) {
	resp = &CreateEventSubscriptionResult{}
	err = c.client.Do("CreateEventSubscription", "POST", "/", req, resp)
	return
}

// CreateOptionGroup creates a new option group. You can create up to 20
// option groups.
func (c *RDS) CreateOptionGroup(req *CreateOptionGroupMessage) (resp *CreateOptionGroupResult, err error) {
	resp = &CreateOptionGroupResult{}
	err = c.client.Do("CreateOptionGroup", "POST", "/", req, resp)
	return
}

// DeleteDBInstance the DeleteDBInstance action deletes a previously
// provisioned DB instance. A successful response from the web service
// indicates the request was received correctly. When you delete a DB
// instance, all automated backups for that instance are deleted and cannot
// be recovered. Manual DB snapshots of the DB instance to be deleted are
// not deleted. If a final DB snapshot is requested the status of the RDS
// instance will be "deleting" until the DB snapshot is created. The API
// action DescribeDBInstance is used to monitor the status of this
// operation. The action cannot be canceled or reverted once submitted.
func (c *RDS) DeleteDBInstance(req *DeleteDBInstanceMessage) (resp *DeleteDBInstanceResult, err error) {
	resp = &DeleteDBInstanceResult{}
	err = c.client.Do("DeleteDBInstance", "POST", "/", req, resp)
	return
}

// DeleteDBParameterGroup deletes a specified DBParameterGroup. The
// DBParameterGroup to be deleted cannot be associated with any DB
// instances. The specified DB parameter group cannot be associated with
// any DB instances.
func (c *RDS) DeleteDBParameterGroup(req *DeleteDBParameterGroupMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteDBParameterGroup", "POST", "/", req, nil)
	return
}

// DeleteDBSecurityGroup deletes a DB security group. The specified DB
// security group must not be associated with any DB instances.
func (c *RDS) DeleteDBSecurityGroup(req *DeleteDBSecurityGroupMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteDBSecurityGroup", "POST", "/", req, nil)
	return
}

// DeleteDBSnapshot deletes a DBSnapshot. If the snapshot is being copied,
// the copy operation is terminated. The DBSnapshot must be in the
// available state to be deleted.
func (c *RDS) DeleteDBSnapshot(req *DeleteDBSnapshotMessage) (resp *DeleteDBSnapshotResult, err error) {
	resp = &DeleteDBSnapshotResult{}
	err = c.client.Do("DeleteDBSnapshot", "POST", "/", req, resp)
	return
}

// DeleteDBSubnetGroup deletes a DB subnet group. The specified database
// subnet group must not be associated with any DB instances.
func (c *RDS) DeleteDBSubnetGroup(req *DeleteDBSubnetGroupMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteDBSubnetGroup", "POST", "/", req, nil)
	return
}

// DeleteEventSubscription is undocumented.
func (c *RDS) DeleteEventSubscription(req *DeleteEventSubscriptionMessage) (resp *DeleteEventSubscriptionResult, err error) {
	resp = &DeleteEventSubscriptionResult{}
	err = c.client.Do("DeleteEventSubscription", "POST", "/", req, resp)
	return
}

// DeleteOptionGroup is undocumented.
func (c *RDS) DeleteOptionGroup(req *DeleteOptionGroupMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteOptionGroup", "POST", "/", req, nil)
	return
}

// DescribeDBEngineVersions is undocumented.
func (c *RDS) DescribeDBEngineVersions(req *DescribeDBEngineVersionsMessage) (resp *DescribeDBEngineVersionsResult, err error) {
	resp = &DescribeDBEngineVersionsResult{}
	err = c.client.Do("DescribeDBEngineVersions", "POST", "/", req, resp)
	return
}

// DescribeDBInstances returns information about provisioned RDS instances.
// This API supports pagination.
func (c *RDS) DescribeDBInstances(req *DescribeDBInstancesMessage) (resp *DescribeDBInstancesResult, err error) {
	resp = &DescribeDBInstancesResult{}
	err = c.client.Do("DescribeDBInstances", "POST", "/", req, resp)
	return
}

// DescribeDBLogFiles returns a list of DB log files for the DB instance.
func (c *RDS) DescribeDBLogFiles(req *DescribeDBLogFilesMessage) (resp *DescribeDBLogFilesResult, err error) {
	resp = &DescribeDBLogFilesResult{}
	err = c.client.Do("DescribeDBLogFiles", "POST", "/", req, resp)
	return
}

// DescribeDBParameterGroups returns a list of DBParameterGroup
// descriptions. If a DBParameterGroupName is specified, the list will
// contain only the description of the specified DB parameter group.
func (c *RDS) DescribeDBParameterGroups(req *DescribeDBParameterGroupsMessage) (resp *DescribeDBParameterGroupsResult, err error) {
	resp = &DescribeDBParameterGroupsResult{}
	err = c.client.Do("DescribeDBParameterGroups", "POST", "/", req, resp)
	return
}

// DescribeDBParameters returns the detailed parameter list for a
// particular DB parameter group.
func (c *RDS) DescribeDBParameters(req *DescribeDBParametersMessage) (resp *DescribeDBParametersResult, err error) {
	resp = &DescribeDBParametersResult{}
	err = c.client.Do("DescribeDBParameters", "POST", "/", req, resp)
	return
}

// DescribeDBSecurityGroups returns a list of DBSecurityGroup descriptions.
// If a DBSecurityGroupName is specified, the list will contain only the
// descriptions of the specified DB security group.
func (c *RDS) DescribeDBSecurityGroups(req *DescribeDBSecurityGroupsMessage) (resp *DescribeDBSecurityGroupsResult, err error) {
	resp = &DescribeDBSecurityGroupsResult{}
	err = c.client.Do("DescribeDBSecurityGroups", "POST", "/", req, resp)
	return
}

// DescribeDBSnapshots returns information about DB snapshots. This API
// supports pagination.
func (c *RDS) DescribeDBSnapshots(req *DescribeDBSnapshotsMessage) (resp *DescribeDBSnapshotsResult, err error) {
	resp = &DescribeDBSnapshotsResult{}
	err = c.client.Do("DescribeDBSnapshots", "POST", "/", req, resp)
	return
}

// DescribeDBSubnetGroups returns a list of DBSubnetGroup descriptions. If
// a DBSubnetGroupName is specified, the list will contain only the
// descriptions of the specified DBSubnetGroup. For an overview of ranges,
// go to the Wikipedia Tutorial .
func (c *RDS) DescribeDBSubnetGroups(req *DescribeDBSubnetGroupsMessage) (resp *DescribeDBSubnetGroupsResult, err error) {
	resp = &DescribeDBSubnetGroupsResult{}
	err = c.client.Do("DescribeDBSubnetGroups", "POST", "/", req, resp)
	return
}

// DescribeEngineDefaultParameters returns the default engine and system
// parameter information for the specified database engine.
func (c *RDS) DescribeEngineDefaultParameters(req *DescribeEngineDefaultParametersMessage) (resp *DescribeEngineDefaultParametersResult, err error) {
	resp = &DescribeEngineDefaultParametersResult{}
	err = c.client.Do("DescribeEngineDefaultParameters", "POST", "/", req, resp)
	return
}

// DescribeEventCategories displays a list of categories for all event
// source types, or, if specified, for a specified source type. You can see
// a list of the event categories and source types in the Events topic in
// the Amazon RDS User Guide.
func (c *RDS) DescribeEventCategories(req *DescribeEventCategoriesMessage) (resp *DescribeEventCategoriesResult, err error) {
	resp = &DescribeEventCategoriesResult{}
	err = c.client.Do("DescribeEventCategories", "POST", "/", req, resp)
	return
}

// DescribeEventSubscriptions lists all the subscription descriptions for a
// customer account. The description for a subscription includes
// SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID,
// CreationTime, and Status. If you specify a SubscriptionName, lists the
// description for that subscription.
func (c *RDS) DescribeEventSubscriptions(req *DescribeEventSubscriptionsMessage) (resp *DescribeEventSubscriptionsResult, err error) {
	resp = &DescribeEventSubscriptionsResult{}
	err = c.client.Do("DescribeEventSubscriptions", "POST", "/", req, resp)
	return
}

// DescribeEvents returns events related to DB instances, DB security
// groups, DB snapshots, and DB parameter groups for the past 14 days.
// Events specific to a particular DB instance, DB security group, database
// snapshot, or DB parameter group can be obtained by providing the name as
// a parameter. By default, the past hour of events are returned.
func (c *RDS) DescribeEvents(req *DescribeEventsMessage) (resp *DescribeEventsResult, err error) {
	resp = &DescribeEventsResult{}
	err = c.client.Do("DescribeEvents", "POST", "/", req, resp)
	return
}

// DescribeOptionGroupOptions is undocumented.
func (c *RDS) DescribeOptionGroupOptions(req *DescribeOptionGroupOptionsMessage) (resp *DescribeOptionGroupOptionsResult, err error) {
	resp = &DescribeOptionGroupOptionsResult{}
	err = c.client.Do("DescribeOptionGroupOptions", "POST", "/", req, resp)
	return
}

// DescribeOptionGroups is undocumented.
func (c *RDS) DescribeOptionGroups(req *DescribeOptionGroupsMessage) (resp *DescribeOptionGroupsResult, err error) {
	resp = &DescribeOptionGroupsResult{}
	err = c.client.Do("DescribeOptionGroups", "POST", "/", req, resp)
	return
}

// DescribeOrderableDBInstanceOptions returns a list of orderable DB
// instance options for the specified engine.
func (c *RDS) DescribeOrderableDBInstanceOptions(req *DescribeOrderableDBInstanceOptionsMessage) (resp *DescribeOrderableDBInstanceOptionsResult, err error) {
	resp = &DescribeOrderableDBInstanceOptionsResult{}
	err = c.client.Do("DescribeOrderableDBInstanceOptions", "POST", "/", req, resp)
	return
}

// DescribePendingMaintenanceActions returns a list of resources (for
// example, DB Instances) that have at least one pending maintenance
// action.
func (c *RDS) DescribePendingMaintenanceActions(req *DescribePendingMaintenanceActionsMessage) (resp *DescribePendingMaintenanceActionsResult, err error) {
	resp = &DescribePendingMaintenanceActionsResult{}
	err = c.client.Do("DescribePendingMaintenanceActions", "POST", "/", req, resp)
	return
}

// DescribeReservedDBInstances returns information about reserved DB
// instances for this account, or about a specified reserved DB instance.
func (c *RDS) DescribeReservedDBInstances(req *DescribeReservedDBInstancesMessage) (resp *DescribeReservedDBInstancesResult, err error) {
	resp = &DescribeReservedDBInstancesResult{}
	err = c.client.Do("DescribeReservedDBInstances", "POST", "/", req, resp)
	return
}

// DescribeReservedDBInstancesOfferings is undocumented.
func (c *RDS) DescribeReservedDBInstancesOfferings(req *DescribeReservedDBInstancesOfferingsMessage) (resp *DescribeReservedDBInstancesOfferingsResult, err error) {
	resp = &DescribeReservedDBInstancesOfferingsResult{}
	err = c.client.Do("DescribeReservedDBInstancesOfferings", "POST", "/", req, resp)
	return
}

// DownloadDBLogFilePortion downloads all or a portion of the specified log
// file.
func (c *RDS) DownloadDBLogFilePortion(req *DownloadDBLogFilePortionMessage) (resp *DownloadDBLogFilePortionResult, err error) {
	resp = &DownloadDBLogFilePortionResult{}
	err = c.client.Do("DownloadDBLogFilePortion", "POST", "/", req, resp)
	return
}

// ListTagsForResource lists all tags on an Amazon RDS resource. For an
// overview on tagging an Amazon RDS resource, see Tagging Amazon RDS
// Resources
func (c *RDS) ListTagsForResource(req *ListTagsForResourceMessage) (resp *ListTagsForResourceResult, err error) {
	resp = &ListTagsForResourceResult{}
	err = c.client.Do("ListTagsForResource", "POST", "/", req, resp)
	return
}

// ModifyDBInstance modify settings for a DB instance. You can change one
// or more database configuration parameters by specifying these parameters
// and the new values in the request.
func (c *RDS) ModifyDBInstance(req *ModifyDBInstanceMessage) (resp *ModifyDBInstanceResult, err error) {
	resp = &ModifyDBInstanceResult{}
	err = c.client.Do("ModifyDBInstance", "POST", "/", req, resp)
	return
}

// ModifyDBParameterGroup modifies the parameters of a DB parameter group.
// To modify more than one parameter, submit a list of the following:
// ParameterName , ParameterValue , and ApplyMethod . A maximum of 20
// parameters can be modified in a single request. Changes to dynamic
// parameters are applied immediately. Changes to static parameters require
// a reboot without failover to the DB instance associated with the
// parameter group before the change can take effect. After you modify a DB
// parameter group, you should wait at least 5 minutes before creating your
// first DB instance that uses that DB parameter group as the default
// parameter group. This allows Amazon RDS to fully complete the modify
// action before the parameter group is used as the default for a new DB
// instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the
// character set for the default database defined by the
// character_set_database parameter. You can use the Parameter Groups
// option of the Amazon RDS console or the DescribeDBParameters command to
// verify that your DB parameter group has been created or modified.
func (c *RDS) ModifyDBParameterGroup(req *ModifyDBParameterGroupMessage) (resp *ModifyDBParameterGroupResult, err error) {
	resp = &ModifyDBParameterGroupResult{}
	err = c.client.Do("ModifyDBParameterGroup", "POST", "/", req, resp)
	return
}

// ModifyDBSubnetGroup modifies an existing DB subnet group. DB subnet
// groups must contain at least one subnet in at least two AZs in the
// region.
func (c *RDS) ModifyDBSubnetGroup(req *ModifyDBSubnetGroupMessage) (resp *ModifyDBSubnetGroupResult, err error) {
	resp = &ModifyDBSubnetGroupResult{}
	err = c.client.Do("ModifyDBSubnetGroup", "POST", "/", req, resp)
	return
}

// ModifyEventSubscription modifies an existing RDS event notification
// subscription. Note that you cannot modify the source identifiers using
// this call; to change source identifiers for a subscription, use the
// AddSourceIdentifierToSubscription and
// RemoveSourceIdentifierFromSubscription calls. You can see a list of the
// event categories for a given SourceType in the Events topic in the
// Amazon RDS User Guide or by using the DescribeEventCategories action.
func (c *RDS) ModifyEventSubscription(req *ModifyEventSubscriptionMessage) (resp *ModifyEventSubscriptionResult, err error) {
	resp = &ModifyEventSubscriptionResult{}
	err = c.client.Do("ModifyEventSubscription", "POST", "/", req, resp)
	return
}

// ModifyOptionGroup is undocumented.
func (c *RDS) ModifyOptionGroup(req *ModifyOptionGroupMessage) (resp *ModifyOptionGroupResult, err error) {
	resp = &ModifyOptionGroupResult{}
	err = c.client.Do("ModifyOptionGroup", "POST", "/", req, resp)
	return
}

// PromoteReadReplica promotes a Read Replica DB instance to a standalone
// DB instance. We recommend that you enable automated backups on your Read
// Replica before promoting the Read Replica. This ensures that no backup
// is taken during the promotion process. Once the instance is promoted to
// a primary instance, backups are taken based on your backup settings.
func (c *RDS) PromoteReadReplica(req *PromoteReadReplicaMessage) (resp *PromoteReadReplicaResult, err error) {
	resp = &PromoteReadReplicaResult{}
	err = c.client.Do("PromoteReadReplica", "POST", "/", req, resp)
	return
}

// PurchaseReservedDBInstancesOffering is undocumented.
func (c *RDS) PurchaseReservedDBInstancesOffering(req *PurchaseReservedDBInstancesOfferingMessage) (resp *PurchaseReservedDBInstancesOfferingResult, err error) {
	resp = &PurchaseReservedDBInstancesOfferingResult{}
	err = c.client.Do("PurchaseReservedDBInstancesOffering", "POST", "/", req, resp)
	return
}

// RebootDBInstance rebooting a DB instance restarts the database engine
// service. A reboot also applies to the DB instance any modifications to
// the associated DB parameter group that were pending. Rebooting a DB
// instance results in a momentary outage of the instance, during which the
// DB instance status is set to rebooting. If the RDS instance is
// configured for MultiAZ, it is possible that the reboot will be conducted
// through a failover. An Amazon RDS event is created when the reboot is
// completed. If your DB instance is deployed in multiple Availability
// Zones, you can force a failover from one AZ to the other during the
// reboot. You might force a failover to test the availability of your DB
// instance deployment or to restore operations to the original AZ after a
// failover occurs. The time required to reboot is a function of the
// specific database engine's crash recovery process. To improve the reboot
// time, we recommend that you reduce database activities as much as
// possible during the reboot process to reduce rollback activity for
// in-transit transactions.
func (c *RDS) RebootDBInstance(req *RebootDBInstanceMessage) (resp *RebootDBInstanceResult, err error) {
	resp = &RebootDBInstanceResult{}
	err = c.client.Do("RebootDBInstance", "POST", "/", req, resp)
	return
}

// RemoveSourceIdentifierFromSubscription removes a source identifier from
// an existing RDS event notification subscription.
func (c *RDS) RemoveSourceIdentifierFromSubscription(req *RemoveSourceIdentifierFromSubscriptionMessage) (resp *RemoveSourceIdentifierFromSubscriptionResult, err error) {
	resp = &RemoveSourceIdentifierFromSubscriptionResult{}
	err = c.client.Do("RemoveSourceIdentifierFromSubscription", "POST", "/", req, resp)
	return
}

// RemoveTagsFromResource removes metadata tags from an Amazon RDS
// resource. For an overview on tagging an Amazon RDS resource, see Tagging
// Amazon RDS Resources
func (c *RDS) RemoveTagsFromResource(req *RemoveTagsFromResourceMessage) (err error) {
	// NRE
	err = c.client.Do("RemoveTagsFromResource", "POST", "/", req, nil)
	return
}

// ResetDBParameterGroup modifies the parameters of a DB parameter group to
// the engine/system default value. To reset specific parameters submit a
// list of the following: ParameterName and ApplyMethod . To reset the
// entire DB parameter group, specify the DBParameterGroup name and
// ResetAllParameters parameters. When resetting the entire group, dynamic
// parameters are updated immediately and static parameters are set to
// pending-reboot to take effect on the next DB instance restart or
// RebootDBInstance request.
func (c *RDS) ResetDBParameterGroup(req *ResetDBParameterGroupMessage) (resp *ResetDBParameterGroupResult, err error) {
	resp = &ResetDBParameterGroupResult{}
	err = c.client.Do("ResetDBParameterGroup", "POST", "/", req, resp)
	return
}

// RestoreDBInstanceFromDBSnapshot creates a new DB instance from a DB
// snapshot. The target database is created from the source database
// restore point with the same configuration as the original source
// database, except that the new RDS instance is created with the default
// security group. If your intent is to replace your original DB instance
// with the new, restored DB instance, then rename your original DB
// instance before you call the RestoreDBInstanceFromDBSnapshot action. RDS
// does not allow two DB instances with the same name. Once you have
// renamed your original DB instance with a different identifier, then you
// can pass the original name of the DB instance as the
// DBInstanceIdentifier in the call to the RestoreDBInstanceFromDBSnapshot
// action. The result is that you will replace the original DB instance
// with the DB instance created from the snapshot.
func (c *RDS) RestoreDBInstanceFromDBSnapshot(req *RestoreDBInstanceFromDBSnapshotMessage) (resp *RestoreDBInstanceFromDBSnapshotResult, err error) {
	resp = &RestoreDBInstanceFromDBSnapshotResult{}
	err = c.client.Do("RestoreDBInstanceFromDBSnapshot", "POST", "/", req, resp)
	return
}

// RestoreDBInstanceToPointInTime restores a DB instance to an arbitrary
// point-in-time. Users can restore to any point in time before the
// LatestRestorableTime for up to BackupRetentionPeriod days. The target
// database is created from the source database with the same configuration
// as the original database except that the DB instance is created with the
// default DB security group.
func (c *RDS) RestoreDBInstanceToPointInTime(req *RestoreDBInstanceToPointInTimeMessage) (resp *RestoreDBInstanceToPointInTimeResult, err error) {
	resp = &RestoreDBInstanceToPointInTimeResult{}
	err = c.client.Do("RestoreDBInstanceToPointInTime", "POST", "/", req, resp)
	return
}

// RevokeDBSecurityGroupIngress revokes ingress from a DBSecurityGroup for
// previously authorized IP ranges or EC2 or VPC Security Groups. Required
// parameters for this API are one of EC2SecurityGroupId for or
// (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or
// EC2SecurityGroupId).
func (c *RDS) RevokeDBSecurityGroupIngress(req *RevokeDBSecurityGroupIngressMessage) (resp *RevokeDBSecurityGroupIngressResult, err error) {
	resp = &RevokeDBSecurityGroupIngressResult{}
	err = c.client.Do("RevokeDBSecurityGroupIngress", "POST", "/", req, resp)
	return
}

// AddSourceIdentifierToSubscriptionMessage is undocumented.
type AddSourceIdentifierToSubscriptionMessage struct {
	SourceIdentifier aws.StringValue `query:"SourceIdentifier" xml:"SourceIdentifier"`
	SubscriptionName aws.StringValue `query:"SubscriptionName" xml:"SubscriptionName"`
}

// AddSourceIdentifierToSubscriptionResult is undocumented.
type AddSourceIdentifierToSubscriptionResult struct {
	EventSubscription *EventSubscription `query:"EventSubscription" xml:"AddSourceIdentifierToSubscriptionResult>EventSubscription"`
}

// AddTagsToResourceMessage is undocumented.
type AddTagsToResourceMessage struct {
	ResourceName aws.StringValue `query:"ResourceName" xml:"ResourceName"`
	Tags         []Tag           `query:"Tags.member" xml:"Tags>Tag"`
}

// Possible values for RDS.
const (
	ApplyMethodImmediate     = "immediate"
	ApplyMethodPendingReboot = "pending-reboot"
)

// ApplyPendingMaintenanceActionMessage is undocumented.
type ApplyPendingMaintenanceActionMessage struct {
	ApplyAction        aws.StringValue `query:"ApplyAction" xml:"ApplyAction"`
	OptInType          aws.StringValue `query:"OptInType" xml:"OptInType"`
	ResourceIdentifier aws.StringValue `query:"ResourceIdentifier" xml:"ResourceIdentifier"`
}

// ApplyPendingMaintenanceActionResult is undocumented.
type ApplyPendingMaintenanceActionResult struct {
	ResourcePendingMaintenanceActions *ResourcePendingMaintenanceActions `query:"ResourcePendingMaintenanceActions" xml:"ApplyPendingMaintenanceActionResult>ResourcePendingMaintenanceActions"`
}

// AuthorizeDBSecurityGroupIngressMessage is undocumented.
type AuthorizeDBSecurityGroupIngressMessage struct {
	CIDRIP                  aws.StringValue `query:"CIDRIP" xml:"CIDRIP"`
	DBSecurityGroupName     aws.StringValue `query:"DBSecurityGroupName" xml:"DBSecurityGroupName"`
	EC2SecurityGroupID      aws.StringValue `query:"EC2SecurityGroupId" xml:"EC2SecurityGroupId"`
	EC2SecurityGroupName    aws.StringValue `query:"EC2SecurityGroupName" xml:"EC2SecurityGroupName"`
	EC2SecurityGroupOwnerID aws.StringValue `query:"EC2SecurityGroupOwnerId" xml:"EC2SecurityGroupOwnerId"`
}

// AuthorizeDBSecurityGroupIngressResult is undocumented.
type AuthorizeDBSecurityGroupIngressResult struct {
	DBSecurityGroup *DBSecurityGroup `query:"DBSecurityGroup" xml:"AuthorizeDBSecurityGroupIngressResult>DBSecurityGroup"`
}

// AvailabilityZone is undocumented.
type AvailabilityZone struct {
	Name aws.StringValue `query:"Name" xml:"Name"`
}

// CharacterSet is undocumented.
type CharacterSet struct {
	CharacterSetDescription aws.StringValue `query:"CharacterSetDescription" xml:"CharacterSetDescription"`
	CharacterSetName        aws.StringValue `query:"CharacterSetName" xml:"CharacterSetName"`
}

// CopyDBParameterGroupMessage is undocumented.
type CopyDBParameterGroupMessage struct {
	SourceDBParameterGroupIdentifier  aws.StringValue `query:"SourceDBParameterGroupIdentifier" xml:"SourceDBParameterGroupIdentifier"`
	Tags                              []Tag           `query:"Tags.member" xml:"Tags>Tag"`
	TargetDBParameterGroupDescription aws.StringValue `query:"TargetDBParameterGroupDescription" xml:"TargetDBParameterGroupDescription"`
	TargetDBParameterGroupIdentifier  aws.StringValue `query:"TargetDBParameterGroupIdentifier" xml:"TargetDBParameterGroupIdentifier"`
}

// CopyDBParameterGroupResult is undocumented.
type CopyDBParameterGroupResult struct {
	DBParameterGroup *DBParameterGroup `query:"DBParameterGroup" xml:"CopyDBParameterGroupResult>DBParameterGroup"`
}

// CopyDBSnapshotMessage is undocumented.
type CopyDBSnapshotMessage struct {
	SourceDBSnapshotIdentifier aws.StringValue `query:"SourceDBSnapshotIdentifier" xml:"SourceDBSnapshotIdentifier"`
	Tags                       []Tag           `query:"Tags.member" xml:"Tags>Tag"`
	TargetDBSnapshotIdentifier aws.StringValue `query:"TargetDBSnapshotIdentifier" xml:"TargetDBSnapshotIdentifier"`
}

// CopyDBSnapshotResult is undocumented.
type CopyDBSnapshotResult struct {
	DBSnapshot *DBSnapshot `query:"DBSnapshot" xml:"CopyDBSnapshotResult>DBSnapshot"`
}

// CopyOptionGroupMessage is undocumented.
type CopyOptionGroupMessage struct {
	SourceOptionGroupIdentifier  aws.StringValue `query:"SourceOptionGroupIdentifier" xml:"SourceOptionGroupIdentifier"`
	Tags                         []Tag           `query:"Tags.member" xml:"Tags>Tag"`
	TargetOptionGroupDescription aws.StringValue `query:"TargetOptionGroupDescription" xml:"TargetOptionGroupDescription"`
	TargetOptionGroupIdentifier  aws.StringValue `query:"TargetOptionGroupIdentifier" xml:"TargetOptionGroupIdentifier"`
}

// CopyOptionGroupResult is undocumented.
type CopyOptionGroupResult struct {
	OptionGroup *OptionGroup `query:"OptionGroup" xml:"CopyOptionGroupResult>OptionGroup"`
}

// CreateDBInstanceMessage is undocumented.
type CreateDBInstanceMessage struct {
	AllocatedStorage           aws.IntegerValue `query:"AllocatedStorage" xml:"AllocatedStorage"`
	AutoMinorVersionUpgrade    aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	AvailabilityZone           aws.StringValue  `query:"AvailabilityZone" xml:"AvailabilityZone"`
	BackupRetentionPeriod      aws.IntegerValue `query:"BackupRetentionPeriod" xml:"BackupRetentionPeriod"`
	CharacterSetName           aws.StringValue  `query:"CharacterSetName" xml:"CharacterSetName"`
	DBInstanceClass            aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	DBInstanceIdentifier       aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	DBName                     aws.StringValue  `query:"DBName" xml:"DBName"`
	DBParameterGroupName       aws.StringValue  `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	DBSecurityGroups           []string         `query:"DBSecurityGroups.member" xml:"DBSecurityGroups>DBSecurityGroupName"`
	DBSubnetGroupName          aws.StringValue  `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
	Engine                     aws.StringValue  `query:"Engine" xml:"Engine"`
	EngineVersion              aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	IOPS                       aws.IntegerValue `query:"Iops" xml:"Iops"`
	KMSKeyID                   aws.StringValue  `query:"KmsKeyId" xml:"KmsKeyId"`
	LicenseModel               aws.StringValue  `query:"LicenseModel" xml:"LicenseModel"`
	MasterUserPassword         aws.StringValue  `query:"MasterUserPassword" xml:"MasterUserPassword"`
	MasterUsername             aws.StringValue  `query:"MasterUsername" xml:"MasterUsername"`
	MultiAZ                    aws.BooleanValue `query:"MultiAZ" xml:"MultiAZ"`
	OptionGroupName            aws.StringValue  `query:"OptionGroupName" xml:"OptionGroupName"`
	Port                       aws.IntegerValue `query:"Port" xml:"Port"`
	PreferredBackupWindow      aws.StringValue  `query:"PreferredBackupWindow" xml:"PreferredBackupWindow"`
	PreferredMaintenanceWindow aws.StringValue  `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	PubliclyAccessible         aws.BooleanValue `query:"PubliclyAccessible" xml:"PubliclyAccessible"`
	StorageEncrypted           aws.BooleanValue `query:"StorageEncrypted" xml:"StorageEncrypted"`
	StorageType                aws.StringValue  `query:"StorageType" xml:"StorageType"`
	Tags                       []Tag            `query:"Tags.member" xml:"Tags>Tag"`
	TDECredentialARN           aws.StringValue  `query:"TdeCredentialArn" xml:"TdeCredentialArn"`
	TDECredentialPassword      aws.StringValue  `query:"TdeCredentialPassword" xml:"TdeCredentialPassword"`
	VPCSecurityGroupIDs        []string         `query:"VpcSecurityGroupIds.member" xml:"VpcSecurityGroupIds>VpcSecurityGroupId"`
}

// CreateDBInstanceReadReplicaMessage is undocumented.
type CreateDBInstanceReadReplicaMessage struct {
	AutoMinorVersionUpgrade    aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	AvailabilityZone           aws.StringValue  `query:"AvailabilityZone" xml:"AvailabilityZone"`
	DBInstanceClass            aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	DBInstanceIdentifier       aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	DBSubnetGroupName          aws.StringValue  `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
	IOPS                       aws.IntegerValue `query:"Iops" xml:"Iops"`
	OptionGroupName            aws.StringValue  `query:"OptionGroupName" xml:"OptionGroupName"`
	Port                       aws.IntegerValue `query:"Port" xml:"Port"`
	PubliclyAccessible         aws.BooleanValue `query:"PubliclyAccessible" xml:"PubliclyAccessible"`
	SourceDBInstanceIdentifier aws.StringValue  `query:"SourceDBInstanceIdentifier" xml:"SourceDBInstanceIdentifier"`
	StorageType                aws.StringValue  `query:"StorageType" xml:"StorageType"`
	Tags                       []Tag            `query:"Tags.member" xml:"Tags>Tag"`
}

// CreateDBInstanceReadReplicaResult is undocumented.
type CreateDBInstanceReadReplicaResult struct {
	DBInstance *DBInstance `query:"DBInstance" xml:"CreateDBInstanceReadReplicaResult>DBInstance"`
}

// CreateDBInstanceResult is undocumented.
type CreateDBInstanceResult struct {
	DBInstance *DBInstance `query:"DBInstance" xml:"CreateDBInstanceResult>DBInstance"`
}

// CreateDBParameterGroupMessage is undocumented.
type CreateDBParameterGroupMessage struct {
	DBParameterGroupFamily aws.StringValue `query:"DBParameterGroupFamily" xml:"DBParameterGroupFamily"`
	DBParameterGroupName   aws.StringValue `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	Description            aws.StringValue `query:"Description" xml:"Description"`
	Tags                   []Tag           `query:"Tags.member" xml:"Tags>Tag"`
}

// CreateDBParameterGroupResult is undocumented.
type CreateDBParameterGroupResult struct {
	DBParameterGroup *DBParameterGroup `query:"DBParameterGroup" xml:"CreateDBParameterGroupResult>DBParameterGroup"`
}

// CreateDBSecurityGroupMessage is undocumented.
type CreateDBSecurityGroupMessage struct {
	DBSecurityGroupDescription aws.StringValue `query:"DBSecurityGroupDescription" xml:"DBSecurityGroupDescription"`
	DBSecurityGroupName        aws.StringValue `query:"DBSecurityGroupName" xml:"DBSecurityGroupName"`
	Tags                       []Tag           `query:"Tags.member" xml:"Tags>Tag"`
}

// CreateDBSecurityGroupResult is undocumented.
type CreateDBSecurityGroupResult struct {
	DBSecurityGroup *DBSecurityGroup `query:"DBSecurityGroup" xml:"CreateDBSecurityGroupResult>DBSecurityGroup"`
}

// CreateDBSnapshotMessage is undocumented.
type CreateDBSnapshotMessage struct {
	DBInstanceIdentifier aws.StringValue `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	DBSnapshotIdentifier aws.StringValue `query:"DBSnapshotIdentifier" xml:"DBSnapshotIdentifier"`
	Tags                 []Tag           `query:"Tags.member" xml:"Tags>Tag"`
}

// CreateDBSnapshotResult is undocumented.
type CreateDBSnapshotResult struct {
	DBSnapshot *DBSnapshot `query:"DBSnapshot" xml:"CreateDBSnapshotResult>DBSnapshot"`
}

// CreateDBSubnetGroupMessage is undocumented.
type CreateDBSubnetGroupMessage struct {
	DBSubnetGroupDescription aws.StringValue `query:"DBSubnetGroupDescription" xml:"DBSubnetGroupDescription"`
	DBSubnetGroupName        aws.StringValue `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
	SubnetIDs                []string        `query:"SubnetIds.member" xml:"SubnetIds>SubnetIdentifier"`
	Tags                     []Tag           `query:"Tags.member" xml:"Tags>Tag"`
}

// CreateDBSubnetGroupResult is undocumented.
type CreateDBSubnetGroupResult struct {
	DBSubnetGroup *DBSubnetGroup `query:"DBSubnetGroup" xml:"CreateDBSubnetGroupResult>DBSubnetGroup"`
}

// CreateEventSubscriptionMessage is undocumented.
type CreateEventSubscriptionMessage struct {
	Enabled          aws.BooleanValue `query:"Enabled" xml:"Enabled"`
	EventCategories  []string         `query:"EventCategories.member" xml:"EventCategories>EventCategory"`
	SNSTopicARN      aws.StringValue  `query:"SnsTopicArn" xml:"SnsTopicArn"`
	SourceIDs        []string         `query:"SourceIds.member" xml:"SourceIds>SourceId"`
	SourceType       aws.StringValue  `query:"SourceType" xml:"SourceType"`
	SubscriptionName aws.StringValue  `query:"SubscriptionName" xml:"SubscriptionName"`
	Tags             []Tag            `query:"Tags.member" xml:"Tags>Tag"`
}

// CreateEventSubscriptionResult is undocumented.
type CreateEventSubscriptionResult struct {
	EventSubscription *EventSubscription `query:"EventSubscription" xml:"CreateEventSubscriptionResult>EventSubscription"`
}

// CreateOptionGroupMessage is undocumented.
type CreateOptionGroupMessage struct {
	EngineName             aws.StringValue `query:"EngineName" xml:"EngineName"`
	MajorEngineVersion     aws.StringValue `query:"MajorEngineVersion" xml:"MajorEngineVersion"`
	OptionGroupDescription aws.StringValue `query:"OptionGroupDescription" xml:"OptionGroupDescription"`
	OptionGroupName        aws.StringValue `query:"OptionGroupName" xml:"OptionGroupName"`
	Tags                   []Tag           `query:"Tags.member" xml:"Tags>Tag"`
}

// CreateOptionGroupResult is undocumented.
type CreateOptionGroupResult struct {
	OptionGroup *OptionGroup `query:"OptionGroup" xml:"CreateOptionGroupResult>OptionGroup"`
}

// DBEngineVersion is undocumented.
type DBEngineVersion struct {
	DBEngineDescription        aws.StringValue `query:"DBEngineDescription" xml:"DBEngineDescription"`
	DBEngineVersionDescription aws.StringValue `query:"DBEngineVersionDescription" xml:"DBEngineVersionDescription"`
	DBParameterGroupFamily     aws.StringValue `query:"DBParameterGroupFamily" xml:"DBParameterGroupFamily"`
	DefaultCharacterSet        *CharacterSet   `query:"DefaultCharacterSet" xml:"DefaultCharacterSet"`
	Engine                     aws.StringValue `query:"Engine" xml:"Engine"`
	EngineVersion              aws.StringValue `query:"EngineVersion" xml:"EngineVersion"`
	SupportedCharacterSets     []CharacterSet  `query:"SupportedCharacterSets.member" xml:"SupportedCharacterSets>CharacterSet"`
}

// DBEngineVersionMessage is undocumented.
type DBEngineVersionMessage struct {
	DBEngineVersions []DBEngineVersion `query:"DBEngineVersions.member" xml:"DescribeDBEngineVersionsResult>DBEngineVersions>DBEngineVersion"`
	Marker           aws.StringValue   `query:"Marker" xml:"DescribeDBEngineVersionsResult>Marker"`
}

// DBInstance is undocumented.
type DBInstance struct {
	AllocatedStorage                      aws.IntegerValue             `query:"AllocatedStorage" xml:"AllocatedStorage"`
	AutoMinorVersionUpgrade               aws.BooleanValue             `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	AvailabilityZone                      aws.StringValue              `query:"AvailabilityZone" xml:"AvailabilityZone"`
	BackupRetentionPeriod                 aws.IntegerValue             `query:"BackupRetentionPeriod" xml:"BackupRetentionPeriod"`
	CharacterSetName                      aws.StringValue              `query:"CharacterSetName" xml:"CharacterSetName"`
	DBInstanceClass                       aws.StringValue              `query:"DBInstanceClass" xml:"DBInstanceClass"`
	DBInstanceIdentifier                  aws.StringValue              `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	DBInstanceStatus                      aws.StringValue              `query:"DBInstanceStatus" xml:"DBInstanceStatus"`
	DBName                                aws.StringValue              `query:"DBName" xml:"DBName"`
	DBParameterGroups                     []DBParameterGroupStatus     `query:"DBParameterGroups.member" xml:"DBParameterGroups>DBParameterGroup"`
	DBSecurityGroups                      []DBSecurityGroupMembership  `query:"DBSecurityGroups.member" xml:"DBSecurityGroups>DBSecurityGroup"`
	DBSubnetGroup                         *DBSubnetGroup               `query:"DBSubnetGroup" xml:"DBSubnetGroup"`
	DBiResourceID                         aws.StringValue              `query:"DbiResourceId" xml:"DbiResourceId"`
	Endpoint                              *Endpoint                    `query:"Endpoint" xml:"Endpoint"`
	Engine                                aws.StringValue              `query:"Engine" xml:"Engine"`
	EngineVersion                         aws.StringValue              `query:"EngineVersion" xml:"EngineVersion"`
	InstanceCreateTime                    time.Time                    `query:"InstanceCreateTime" xml:"InstanceCreateTime"`
	IOPS                                  aws.IntegerValue             `query:"Iops" xml:"Iops"`
	KMSKeyID                              aws.StringValue              `query:"KmsKeyId" xml:"KmsKeyId"`
	LatestRestorableTime                  time.Time                    `query:"LatestRestorableTime" xml:"LatestRestorableTime"`
	LicenseModel                          aws.StringValue              `query:"LicenseModel" xml:"LicenseModel"`
	MasterUsername                        aws.StringValue              `query:"MasterUsername" xml:"MasterUsername"`
	MultiAZ                               aws.BooleanValue             `query:"MultiAZ" xml:"MultiAZ"`
	OptionGroupMemberships                []OptionGroupMembership      `query:"OptionGroupMemberships.member" xml:"OptionGroupMemberships>OptionGroupMembership"`
	PendingModifiedValues                 *PendingModifiedValues       `query:"PendingModifiedValues" xml:"PendingModifiedValues"`
	PreferredBackupWindow                 aws.StringValue              `query:"PreferredBackupWindow" xml:"PreferredBackupWindow"`
	PreferredMaintenanceWindow            aws.StringValue              `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	PubliclyAccessible                    aws.BooleanValue             `query:"PubliclyAccessible" xml:"PubliclyAccessible"`
	ReadReplicaDBInstanceIdentifiers      []string                     `query:"ReadReplicaDBInstanceIdentifiers.member" xml:"ReadReplicaDBInstanceIdentifiers>ReadReplicaDBInstanceIdentifier"`
	ReadReplicaSourceDBInstanceIdentifier aws.StringValue              `query:"ReadReplicaSourceDBInstanceIdentifier" xml:"ReadReplicaSourceDBInstanceIdentifier"`
	SecondaryAvailabilityZone             aws.StringValue              `query:"SecondaryAvailabilityZone" xml:"SecondaryAvailabilityZone"`
	StatusInfos                           []DBInstanceStatusInfo       `query:"StatusInfos.member" xml:"StatusInfos>DBInstanceStatusInfo"`
	StorageEncrypted                      aws.BooleanValue             `query:"StorageEncrypted" xml:"StorageEncrypted"`
	StorageType                           aws.StringValue              `query:"StorageType" xml:"StorageType"`
	TDECredentialARN                      aws.StringValue              `query:"TdeCredentialArn" xml:"TdeCredentialArn"`
	VPCSecurityGroups                     []VPCSecurityGroupMembership `query:"VpcSecurityGroups.member" xml:"VpcSecurityGroups>VpcSecurityGroupMembership"`
}

// DBInstanceMessage is undocumented.
type DBInstanceMessage struct {
	DBInstances []DBInstance    `query:"DBInstances.member" xml:"DescribeDBInstancesResult>DBInstances>DBInstance"`
	Marker      aws.StringValue `query:"Marker" xml:"DescribeDBInstancesResult>Marker"`
}

// DBInstanceStatusInfo is undocumented.
type DBInstanceStatusInfo struct {
	Message    aws.StringValue  `query:"Message" xml:"Message"`
	Normal     aws.BooleanValue `query:"Normal" xml:"Normal"`
	Status     aws.StringValue  `query:"Status" xml:"Status"`
	StatusType aws.StringValue  `query:"StatusType" xml:"StatusType"`
}

// DBParameterGroup is undocumented.
type DBParameterGroup struct {
	DBParameterGroupFamily aws.StringValue `query:"DBParameterGroupFamily" xml:"DBParameterGroupFamily"`
	DBParameterGroupName   aws.StringValue `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	Description            aws.StringValue `query:"Description" xml:"Description"`
}

// DBParameterGroupDetails is undocumented.
type DBParameterGroupDetails struct {
	Marker     aws.StringValue `query:"Marker" xml:"DescribeDBParametersResult>Marker"`
	Parameters []Parameter     `query:"Parameters.member" xml:"DescribeDBParametersResult>Parameters>Parameter"`
}

// DBParameterGroupNameMessage is undocumented.
type DBParameterGroupNameMessage struct {
	DBParameterGroupName aws.StringValue `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
}

// DBParameterGroupStatus is undocumented.
type DBParameterGroupStatus struct {
	DBParameterGroupName aws.StringValue `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	ParameterApplyStatus aws.StringValue `query:"ParameterApplyStatus" xml:"ParameterApplyStatus"`
}

// DBParameterGroupsMessage is undocumented.
type DBParameterGroupsMessage struct {
	DBParameterGroups []DBParameterGroup `query:"DBParameterGroups.member" xml:"DescribeDBParameterGroupsResult>DBParameterGroups>DBParameterGroup"`
	Marker            aws.StringValue    `query:"Marker" xml:"DescribeDBParameterGroupsResult>Marker"`
}

// DBSecurityGroup is undocumented.
type DBSecurityGroup struct {
	DBSecurityGroupDescription aws.StringValue    `query:"DBSecurityGroupDescription" xml:"DBSecurityGroupDescription"`
	DBSecurityGroupName        aws.StringValue    `query:"DBSecurityGroupName" xml:"DBSecurityGroupName"`
	EC2SecurityGroups          []EC2SecurityGroup `query:"EC2SecurityGroups.member" xml:"EC2SecurityGroups>EC2SecurityGroup"`
	IPRanges                   []IPRange          `query:"IPRanges.member" xml:"IPRanges>IPRange"`
	OwnerID                    aws.StringValue    `query:"OwnerId" xml:"OwnerId"`
	VPCID                      aws.StringValue    `query:"VpcId" xml:"VpcId"`
}

// DBSecurityGroupMembership is undocumented.
type DBSecurityGroupMembership struct {
	DBSecurityGroupName aws.StringValue `query:"DBSecurityGroupName" xml:"DBSecurityGroupName"`
	Status              aws.StringValue `query:"Status" xml:"Status"`
}

// DBSecurityGroupMessage is undocumented.
type DBSecurityGroupMessage struct {
	DBSecurityGroups []DBSecurityGroup `query:"DBSecurityGroups.member" xml:"DescribeDBSecurityGroupsResult>DBSecurityGroups>DBSecurityGroup"`
	Marker           aws.StringValue   `query:"Marker" xml:"DescribeDBSecurityGroupsResult>Marker"`
}

// DBSnapshot is undocumented.
type DBSnapshot struct {
	AllocatedStorage     aws.IntegerValue `query:"AllocatedStorage" xml:"AllocatedStorage"`
	AvailabilityZone     aws.StringValue  `query:"AvailabilityZone" xml:"AvailabilityZone"`
	DBInstanceIdentifier aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	DBSnapshotIdentifier aws.StringValue  `query:"DBSnapshotIdentifier" xml:"DBSnapshotIdentifier"`
	Encrypted            aws.BooleanValue `query:"Encrypted" xml:"Encrypted"`
	Engine               aws.StringValue  `query:"Engine" xml:"Engine"`
	EngineVersion        aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	InstanceCreateTime   time.Time        `query:"InstanceCreateTime" xml:"InstanceCreateTime"`
	IOPS                 aws.IntegerValue `query:"Iops" xml:"Iops"`
	KMSKeyID             aws.StringValue  `query:"KmsKeyId" xml:"KmsKeyId"`
	LicenseModel         aws.StringValue  `query:"LicenseModel" xml:"LicenseModel"`
	MasterUsername       aws.StringValue  `query:"MasterUsername" xml:"MasterUsername"`
	OptionGroupName      aws.StringValue  `query:"OptionGroupName" xml:"OptionGroupName"`
	PercentProgress      aws.IntegerValue `query:"PercentProgress" xml:"PercentProgress"`
	Port                 aws.IntegerValue `query:"Port" xml:"Port"`
	SnapshotCreateTime   time.Time        `query:"SnapshotCreateTime" xml:"SnapshotCreateTime"`
	SnapshotType         aws.StringValue  `query:"SnapshotType" xml:"SnapshotType"`
	SourceRegion         aws.StringValue  `query:"SourceRegion" xml:"SourceRegion"`
	Status               aws.StringValue  `query:"Status" xml:"Status"`
	StorageType          aws.StringValue  `query:"StorageType" xml:"StorageType"`
	TDECredentialARN     aws.StringValue  `query:"TdeCredentialArn" xml:"TdeCredentialArn"`
	VPCID                aws.StringValue  `query:"VpcId" xml:"VpcId"`
}

// DBSnapshotMessage is undocumented.
type DBSnapshotMessage struct {
	DBSnapshots []DBSnapshot    `query:"DBSnapshots.member" xml:"DescribeDBSnapshotsResult>DBSnapshots>DBSnapshot"`
	Marker      aws.StringValue `query:"Marker" xml:"DescribeDBSnapshotsResult>Marker"`
}

// DBSubnetGroup is undocumented.
type DBSubnetGroup struct {
	DBSubnetGroupDescription aws.StringValue `query:"DBSubnetGroupDescription" xml:"DBSubnetGroupDescription"`
	DBSubnetGroupName        aws.StringValue `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
	SubnetGroupStatus        aws.StringValue `query:"SubnetGroupStatus" xml:"SubnetGroupStatus"`
	Subnets                  []Subnet        `query:"Subnets.member" xml:"Subnets>Subnet"`
	VPCID                    aws.StringValue `query:"VpcId" xml:"VpcId"`
}

// DBSubnetGroupMessage is undocumented.
type DBSubnetGroupMessage struct {
	DBSubnetGroups []DBSubnetGroup `query:"DBSubnetGroups.member" xml:"DescribeDBSubnetGroupsResult>DBSubnetGroups>DBSubnetGroup"`
	Marker         aws.StringValue `query:"Marker" xml:"DescribeDBSubnetGroupsResult>Marker"`
}

// DeleteDBInstanceMessage is undocumented.
type DeleteDBInstanceMessage struct {
	DBInstanceIdentifier      aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	FinalDBSnapshotIdentifier aws.StringValue  `query:"FinalDBSnapshotIdentifier" xml:"FinalDBSnapshotIdentifier"`
	SkipFinalSnapshot         aws.BooleanValue `query:"SkipFinalSnapshot" xml:"SkipFinalSnapshot"`
}

// DeleteDBInstanceResult is undocumented.
type DeleteDBInstanceResult struct {
	DBInstance *DBInstance `query:"DBInstance" xml:"DeleteDBInstanceResult>DBInstance"`
}

// DeleteDBParameterGroupMessage is undocumented.
type DeleteDBParameterGroupMessage struct {
	DBParameterGroupName aws.StringValue `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
}

// DeleteDBSecurityGroupMessage is undocumented.
type DeleteDBSecurityGroupMessage struct {
	DBSecurityGroupName aws.StringValue `query:"DBSecurityGroupName" xml:"DBSecurityGroupName"`
}

// DeleteDBSnapshotMessage is undocumented.
type DeleteDBSnapshotMessage struct {
	DBSnapshotIdentifier aws.StringValue `query:"DBSnapshotIdentifier" xml:"DBSnapshotIdentifier"`
}

// DeleteDBSnapshotResult is undocumented.
type DeleteDBSnapshotResult struct {
	DBSnapshot *DBSnapshot `query:"DBSnapshot" xml:"DeleteDBSnapshotResult>DBSnapshot"`
}

// DeleteDBSubnetGroupMessage is undocumented.
type DeleteDBSubnetGroupMessage struct {
	DBSubnetGroupName aws.StringValue `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
}

// DeleteEventSubscriptionMessage is undocumented.
type DeleteEventSubscriptionMessage struct {
	SubscriptionName aws.StringValue `query:"SubscriptionName" xml:"SubscriptionName"`
}

// DeleteEventSubscriptionResult is undocumented.
type DeleteEventSubscriptionResult struct {
	EventSubscription *EventSubscription `query:"EventSubscription" xml:"DeleteEventSubscriptionResult>EventSubscription"`
}

// DeleteOptionGroupMessage is undocumented.
type DeleteOptionGroupMessage struct {
	OptionGroupName aws.StringValue `query:"OptionGroupName" xml:"OptionGroupName"`
}

// DescribeDBEngineVersionsMessage is undocumented.
type DescribeDBEngineVersionsMessage struct {
	DBParameterGroupFamily     aws.StringValue  `query:"DBParameterGroupFamily" xml:"DBParameterGroupFamily"`
	DefaultOnly                aws.BooleanValue `query:"DefaultOnly" xml:"DefaultOnly"`
	Engine                     aws.StringValue  `query:"Engine" xml:"Engine"`
	EngineVersion              aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	Filters                    []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	ListSupportedCharacterSets aws.BooleanValue `query:"ListSupportedCharacterSets" xml:"ListSupportedCharacterSets"`
	Marker                     aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords                 aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeDBInstancesMessage is undocumented.
type DescribeDBInstancesMessage struct {
	DBInstanceIdentifier aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	Filters              []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker               aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords           aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeDBLogFilesDetails is undocumented.
type DescribeDBLogFilesDetails struct {
	LastWritten aws.LongValue   `query:"LastWritten" xml:"LastWritten"`
	LogFileName aws.StringValue `query:"LogFileName" xml:"LogFileName"`
	Size        aws.LongValue   `query:"Size" xml:"Size"`
}

// DescribeDBLogFilesMessage is undocumented.
type DescribeDBLogFilesMessage struct {
	DBInstanceIdentifier aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	FileLastWritten      aws.LongValue    `query:"FileLastWritten" xml:"FileLastWritten"`
	FileSize             aws.LongValue    `query:"FileSize" xml:"FileSize"`
	FilenameContains     aws.StringValue  `query:"FilenameContains" xml:"FilenameContains"`
	Filters              []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker               aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords           aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeDBLogFilesResponse is undocumented.
type DescribeDBLogFilesResponse struct {
	DescribeDBLogFiles []DescribeDBLogFilesDetails `query:"DescribeDBLogFiles.member" xml:"DescribeDBLogFilesResult>DescribeDBLogFiles>DescribeDBLogFilesDetails"`
	Marker             aws.StringValue             `query:"Marker" xml:"DescribeDBLogFilesResult>Marker"`
}

// DescribeDBParameterGroupsMessage is undocumented.
type DescribeDBParameterGroupsMessage struct {
	DBParameterGroupName aws.StringValue  `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	Filters              []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker               aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords           aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeDBParametersMessage is undocumented.
type DescribeDBParametersMessage struct {
	DBParameterGroupName aws.StringValue  `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	Filters              []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker               aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords           aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	Source               aws.StringValue  `query:"Source" xml:"Source"`
}

// DescribeDBSecurityGroupsMessage is undocumented.
type DescribeDBSecurityGroupsMessage struct {
	DBSecurityGroupName aws.StringValue  `query:"DBSecurityGroupName" xml:"DBSecurityGroupName"`
	Filters             []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker              aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords          aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeDBSnapshotsMessage is undocumented.
type DescribeDBSnapshotsMessage struct {
	DBInstanceIdentifier aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	DBSnapshotIdentifier aws.StringValue  `query:"DBSnapshotIdentifier" xml:"DBSnapshotIdentifier"`
	Filters              []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker               aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords           aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	SnapshotType         aws.StringValue  `query:"SnapshotType" xml:"SnapshotType"`
}

// DescribeDBSubnetGroupsMessage is undocumented.
type DescribeDBSubnetGroupsMessage struct {
	DBSubnetGroupName aws.StringValue  `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
	Filters           []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker            aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords        aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeEngineDefaultParametersMessage is undocumented.
type DescribeEngineDefaultParametersMessage struct {
	DBParameterGroupFamily aws.StringValue  `query:"DBParameterGroupFamily" xml:"DBParameterGroupFamily"`
	Filters                []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker                 aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords             aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeEngineDefaultParametersResult is undocumented.
type DescribeEngineDefaultParametersResult struct {
	EngineDefaults *EngineDefaults `query:"EngineDefaults" xml:"DescribeEngineDefaultParametersResult>EngineDefaults"`
}

// DescribeEventCategoriesMessage is undocumented.
type DescribeEventCategoriesMessage struct {
	Filters    []Filter        `query:"Filters.member" xml:"Filters>Filter"`
	SourceType aws.StringValue `query:"SourceType" xml:"SourceType"`
}

// DescribeEventSubscriptionsMessage is undocumented.
type DescribeEventSubscriptionsMessage struct {
	Filters          []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker           aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords       aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	SubscriptionName aws.StringValue  `query:"SubscriptionName" xml:"SubscriptionName"`
}

// DescribeEventsMessage is undocumented.
type DescribeEventsMessage struct {
	Duration         aws.IntegerValue `query:"Duration" xml:"Duration"`
	EndTime          time.Time        `query:"EndTime" xml:"EndTime"`
	EventCategories  []string         `query:"EventCategories.member" xml:"EventCategories>EventCategory"`
	Filters          []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker           aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords       aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	SourceIdentifier aws.StringValue  `query:"SourceIdentifier" xml:"SourceIdentifier"`
	SourceType       aws.StringValue  `query:"SourceType" xml:"SourceType"`
	StartTime        time.Time        `query:"StartTime" xml:"StartTime"`
}

// DescribeOptionGroupOptionsMessage is undocumented.
type DescribeOptionGroupOptionsMessage struct {
	EngineName         aws.StringValue  `query:"EngineName" xml:"EngineName"`
	Filters            []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	MajorEngineVersion aws.StringValue  `query:"MajorEngineVersion" xml:"MajorEngineVersion"`
	Marker             aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords         aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeOptionGroupsMessage is undocumented.
type DescribeOptionGroupsMessage struct {
	EngineName         aws.StringValue  `query:"EngineName" xml:"EngineName"`
	Filters            []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	MajorEngineVersion aws.StringValue  `query:"MajorEngineVersion" xml:"MajorEngineVersion"`
	Marker             aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords         aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	OptionGroupName    aws.StringValue  `query:"OptionGroupName" xml:"OptionGroupName"`
}

// DescribeOrderableDBInstanceOptionsMessage is undocumented.
type DescribeOrderableDBInstanceOptionsMessage struct {
	DBInstanceClass aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	Engine          aws.StringValue  `query:"Engine" xml:"Engine"`
	EngineVersion   aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	Filters         []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	LicenseModel    aws.StringValue  `query:"LicenseModel" xml:"LicenseModel"`
	Marker          aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords      aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	VPC             aws.BooleanValue `query:"Vpc" xml:"Vpc"`
}

// DescribePendingMaintenanceActionsMessage is undocumented.
type DescribePendingMaintenanceActionsMessage struct {
	Filters            []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker             aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords         aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	ResourceIdentifier aws.StringValue  `query:"ResourceIdentifier" xml:"ResourceIdentifier"`
}

// DescribeReservedDBInstancesMessage is undocumented.
type DescribeReservedDBInstancesMessage struct {
	DBInstanceClass               aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	Duration                      aws.StringValue  `query:"Duration" xml:"Duration"`
	Filters                       []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker                        aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords                    aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	MultiAZ                       aws.BooleanValue `query:"MultiAZ" xml:"MultiAZ"`
	OfferingType                  aws.StringValue  `query:"OfferingType" xml:"OfferingType"`
	ProductDescription            aws.StringValue  `query:"ProductDescription" xml:"ProductDescription"`
	ReservedDBInstanceID          aws.StringValue  `query:"ReservedDBInstanceId" xml:"ReservedDBInstanceId"`
	ReservedDBInstancesOfferingID aws.StringValue  `query:"ReservedDBInstancesOfferingId" xml:"ReservedDBInstancesOfferingId"`
}

// DescribeReservedDBInstancesOfferingsMessage is undocumented.
type DescribeReservedDBInstancesOfferingsMessage struct {
	DBInstanceClass               aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	Duration                      aws.StringValue  `query:"Duration" xml:"Duration"`
	Filters                       []Filter         `query:"Filters.member" xml:"Filters>Filter"`
	Marker                        aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords                    aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	MultiAZ                       aws.BooleanValue `query:"MultiAZ" xml:"MultiAZ"`
	OfferingType                  aws.StringValue  `query:"OfferingType" xml:"OfferingType"`
	ProductDescription            aws.StringValue  `query:"ProductDescription" xml:"ProductDescription"`
	ReservedDBInstancesOfferingID aws.StringValue  `query:"ReservedDBInstancesOfferingId" xml:"ReservedDBInstancesOfferingId"`
}

// DownloadDBLogFilePortionDetails is undocumented.
type DownloadDBLogFilePortionDetails struct {
	AdditionalDataPending aws.BooleanValue `query:"AdditionalDataPending" xml:"DownloadDBLogFilePortionResult>AdditionalDataPending"`
	LogFileData           aws.StringValue  `query:"LogFileData" xml:"DownloadDBLogFilePortionResult>LogFileData"`
	Marker                aws.StringValue  `query:"Marker" xml:"DownloadDBLogFilePortionResult>Marker"`
}

// DownloadDBLogFilePortionMessage is undocumented.
type DownloadDBLogFilePortionMessage struct {
	DBInstanceIdentifier aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	LogFileName          aws.StringValue  `query:"LogFileName" xml:"LogFileName"`
	Marker               aws.StringValue  `query:"Marker" xml:"Marker"`
	NumberOfLines        aws.IntegerValue `query:"NumberOfLines" xml:"NumberOfLines"`
}

// EC2SecurityGroup is undocumented.
type EC2SecurityGroup struct {
	EC2SecurityGroupID      aws.StringValue `query:"EC2SecurityGroupId" xml:"EC2SecurityGroupId"`
	EC2SecurityGroupName    aws.StringValue `query:"EC2SecurityGroupName" xml:"EC2SecurityGroupName"`
	EC2SecurityGroupOwnerID aws.StringValue `query:"EC2SecurityGroupOwnerId" xml:"EC2SecurityGroupOwnerId"`
	Status                  aws.StringValue `query:"Status" xml:"Status"`
}

// Endpoint is undocumented.
type Endpoint struct {
	Address aws.StringValue  `query:"Address" xml:"Address"`
	Port    aws.IntegerValue `query:"Port" xml:"Port"`
}

// EngineDefaults is undocumented.
type EngineDefaults struct {
	DBParameterGroupFamily aws.StringValue `query:"DBParameterGroupFamily" xml:"DBParameterGroupFamily"`
	Marker                 aws.StringValue `query:"Marker" xml:"Marker"`
	Parameters             []Parameter     `query:"Parameters.member" xml:"Parameters>Parameter"`
}

// Event is undocumented.
type Event struct {
	Date             time.Time       `query:"Date" xml:"Date"`
	EventCategories  []string        `query:"EventCategories.member" xml:"EventCategories>EventCategory"`
	Message          aws.StringValue `query:"Message" xml:"Message"`
	SourceIdentifier aws.StringValue `query:"SourceIdentifier" xml:"SourceIdentifier"`
	SourceType       aws.StringValue `query:"SourceType" xml:"SourceType"`
}

// EventCategoriesMap is undocumented.
type EventCategoriesMap struct {
	EventCategories []string        `query:"EventCategories.member" xml:"EventCategories>EventCategory"`
	SourceType      aws.StringValue `query:"SourceType" xml:"SourceType"`
}

// EventCategoriesMessage is undocumented.
type EventCategoriesMessage struct {
	EventCategoriesMapList []EventCategoriesMap `query:"EventCategoriesMapList.member" xml:"DescribeEventCategoriesResult>EventCategoriesMapList>EventCategoriesMap"`
}

// EventSubscription is undocumented.
type EventSubscription struct {
	CustSubscriptionID       aws.StringValue  `query:"CustSubscriptionId" xml:"CustSubscriptionId"`
	CustomerAWSID            aws.StringValue  `query:"CustomerAwsId" xml:"CustomerAwsId"`
	Enabled                  aws.BooleanValue `query:"Enabled" xml:"Enabled"`
	EventCategoriesList      []string         `query:"EventCategoriesList.member" xml:"EventCategoriesList>EventCategory"`
	SNSTopicARN              aws.StringValue  `query:"SnsTopicArn" xml:"SnsTopicArn"`
	SourceIDsList            []string         `query:"SourceIdsList.member" xml:"SourceIdsList>SourceId"`
	SourceType               aws.StringValue  `query:"SourceType" xml:"SourceType"`
	Status                   aws.StringValue  `query:"Status" xml:"Status"`
	SubscriptionCreationTime aws.StringValue  `query:"SubscriptionCreationTime" xml:"SubscriptionCreationTime"`
}

// EventSubscriptionsMessage is undocumented.
type EventSubscriptionsMessage struct {
	EventSubscriptionsList []EventSubscription `query:"EventSubscriptionsList.member" xml:"DescribeEventSubscriptionsResult>EventSubscriptionsList>EventSubscription"`
	Marker                 aws.StringValue     `query:"Marker" xml:"DescribeEventSubscriptionsResult>Marker"`
}

// EventsMessage is undocumented.
type EventsMessage struct {
	Events []Event         `query:"Events.member" xml:"DescribeEventsResult>Events>Event"`
	Marker aws.StringValue `query:"Marker" xml:"DescribeEventsResult>Marker"`
}

// Filter is undocumented.
type Filter struct {
	Name   aws.StringValue `query:"Name" xml:"Name"`
	Values []string        `query:"Values.member" xml:"Values>Value"`
}

// IPRange is undocumented.
type IPRange struct {
	CIDRIP aws.StringValue `query:"CIDRIP" xml:"CIDRIP"`
	Status aws.StringValue `query:"Status" xml:"Status"`
}

// ListTagsForResourceMessage is undocumented.
type ListTagsForResourceMessage struct {
	Filters      []Filter        `query:"Filters.member" xml:"Filters>Filter"`
	ResourceName aws.StringValue `query:"ResourceName" xml:"ResourceName"`
}

// ModifyDBInstanceMessage is undocumented.
type ModifyDBInstanceMessage struct {
	AllocatedStorage           aws.IntegerValue `query:"AllocatedStorage" xml:"AllocatedStorage"`
	AllowMajorVersionUpgrade   aws.BooleanValue `query:"AllowMajorVersionUpgrade" xml:"AllowMajorVersionUpgrade"`
	ApplyImmediately           aws.BooleanValue `query:"ApplyImmediately" xml:"ApplyImmediately"`
	AutoMinorVersionUpgrade    aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	BackupRetentionPeriod      aws.IntegerValue `query:"BackupRetentionPeriod" xml:"BackupRetentionPeriod"`
	DBInstanceClass            aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	DBInstanceIdentifier       aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	DBParameterGroupName       aws.StringValue  `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	DBSecurityGroups           []string         `query:"DBSecurityGroups.member" xml:"DBSecurityGroups>DBSecurityGroupName"`
	EngineVersion              aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	IOPS                       aws.IntegerValue `query:"Iops" xml:"Iops"`
	MasterUserPassword         aws.StringValue  `query:"MasterUserPassword" xml:"MasterUserPassword"`
	MultiAZ                    aws.BooleanValue `query:"MultiAZ" xml:"MultiAZ"`
	NewDBInstanceIdentifier    aws.StringValue  `query:"NewDBInstanceIdentifier" xml:"NewDBInstanceIdentifier"`
	OptionGroupName            aws.StringValue  `query:"OptionGroupName" xml:"OptionGroupName"`
	PreferredBackupWindow      aws.StringValue  `query:"PreferredBackupWindow" xml:"PreferredBackupWindow"`
	PreferredMaintenanceWindow aws.StringValue  `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	StorageType                aws.StringValue  `query:"StorageType" xml:"StorageType"`
	TDECredentialARN           aws.StringValue  `query:"TdeCredentialArn" xml:"TdeCredentialArn"`
	TDECredentialPassword      aws.StringValue  `query:"TdeCredentialPassword" xml:"TdeCredentialPassword"`
	VPCSecurityGroupIDs        []string         `query:"VpcSecurityGroupIds.member" xml:"VpcSecurityGroupIds>VpcSecurityGroupId"`
}

// ModifyDBInstanceResult is undocumented.
type ModifyDBInstanceResult struct {
	DBInstance *DBInstance `query:"DBInstance" xml:"ModifyDBInstanceResult>DBInstance"`
}

// ModifyDBParameterGroupMessage is undocumented.
type ModifyDBParameterGroupMessage struct {
	DBParameterGroupName aws.StringValue `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	Parameters           []Parameter     `query:"Parameters.member" xml:"Parameters>Parameter"`
}

// ModifyDBSubnetGroupMessage is undocumented.
type ModifyDBSubnetGroupMessage struct {
	DBSubnetGroupDescription aws.StringValue `query:"DBSubnetGroupDescription" xml:"DBSubnetGroupDescription"`
	DBSubnetGroupName        aws.StringValue `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
	SubnetIDs                []string        `query:"SubnetIds.member" xml:"SubnetIds>SubnetIdentifier"`
}

// ModifyDBSubnetGroupResult is undocumented.
type ModifyDBSubnetGroupResult struct {
	DBSubnetGroup *DBSubnetGroup `query:"DBSubnetGroup" xml:"ModifyDBSubnetGroupResult>DBSubnetGroup"`
}

// ModifyEventSubscriptionMessage is undocumented.
type ModifyEventSubscriptionMessage struct {
	Enabled          aws.BooleanValue `query:"Enabled" xml:"Enabled"`
	EventCategories  []string         `query:"EventCategories.member" xml:"EventCategories>EventCategory"`
	SNSTopicARN      aws.StringValue  `query:"SnsTopicArn" xml:"SnsTopicArn"`
	SourceType       aws.StringValue  `query:"SourceType" xml:"SourceType"`
	SubscriptionName aws.StringValue  `query:"SubscriptionName" xml:"SubscriptionName"`
}

// ModifyEventSubscriptionResult is undocumented.
type ModifyEventSubscriptionResult struct {
	EventSubscription *EventSubscription `query:"EventSubscription" xml:"ModifyEventSubscriptionResult>EventSubscription"`
}

// ModifyOptionGroupMessage is undocumented.
type ModifyOptionGroupMessage struct {
	ApplyImmediately aws.BooleanValue      `query:"ApplyImmediately" xml:"ApplyImmediately"`
	OptionGroupName  aws.StringValue       `query:"OptionGroupName" xml:"OptionGroupName"`
	OptionsToInclude []OptionConfiguration `query:"OptionsToInclude.member" xml:"OptionsToInclude>OptionConfiguration"`
	OptionsToRemove  []string              `query:"OptionsToRemove.member" xml:"OptionsToRemove>member"`
}

// ModifyOptionGroupResult is undocumented.
type ModifyOptionGroupResult struct {
	OptionGroup *OptionGroup `query:"OptionGroup" xml:"ModifyOptionGroupResult>OptionGroup"`
}

// Option is undocumented.
type Option struct {
	DBSecurityGroupMemberships  []DBSecurityGroupMembership  `query:"DBSecurityGroupMemberships.member" xml:"DBSecurityGroupMemberships>DBSecurityGroup"`
	OptionDescription           aws.StringValue              `query:"OptionDescription" xml:"OptionDescription"`
	OptionName                  aws.StringValue              `query:"OptionName" xml:"OptionName"`
	OptionSettings              []OptionSetting              `query:"OptionSettings.member" xml:"OptionSettings>OptionSetting"`
	Permanent                   aws.BooleanValue             `query:"Permanent" xml:"Permanent"`
	Persistent                  aws.BooleanValue             `query:"Persistent" xml:"Persistent"`
	Port                        aws.IntegerValue             `query:"Port" xml:"Port"`
	VPCSecurityGroupMemberships []VPCSecurityGroupMembership `query:"VpcSecurityGroupMemberships.member" xml:"VpcSecurityGroupMemberships>VpcSecurityGroupMembership"`
}

// OptionConfiguration is undocumented.
type OptionConfiguration struct {
	DBSecurityGroupMemberships  []string         `query:"DBSecurityGroupMemberships.member" xml:"DBSecurityGroupMemberships>DBSecurityGroupName"`
	OptionName                  aws.StringValue  `query:"OptionName" xml:"OptionName"`
	OptionSettings              []OptionSetting  `query:"OptionSettings.member" xml:"OptionSettings>OptionSetting"`
	Port                        aws.IntegerValue `query:"Port" xml:"Port"`
	VPCSecurityGroupMemberships []string         `query:"VpcSecurityGroupMemberships.member" xml:"VpcSecurityGroupMemberships>VpcSecurityGroupId"`
}

// OptionGroup is undocumented.
type OptionGroup struct {
	AllowsVPCAndNonVPCInstanceMemberships aws.BooleanValue `query:"AllowsVpcAndNonVpcInstanceMemberships" xml:"AllowsVpcAndNonVpcInstanceMemberships"`
	EngineName                            aws.StringValue  `query:"EngineName" xml:"EngineName"`
	MajorEngineVersion                    aws.StringValue  `query:"MajorEngineVersion" xml:"MajorEngineVersion"`
	OptionGroupDescription                aws.StringValue  `query:"OptionGroupDescription" xml:"OptionGroupDescription"`
	OptionGroupName                       aws.StringValue  `query:"OptionGroupName" xml:"OptionGroupName"`
	Options                               []Option         `query:"Options.member" xml:"Options>Option"`
	VPCID                                 aws.StringValue  `query:"VpcId" xml:"VpcId"`
}

// OptionGroupMembership is undocumented.
type OptionGroupMembership struct {
	OptionGroupName aws.StringValue `query:"OptionGroupName" xml:"OptionGroupName"`
	Status          aws.StringValue `query:"Status" xml:"Status"`
}

// OptionGroupOption is undocumented.
type OptionGroupOption struct {
	DefaultPort                       aws.IntegerValue           `query:"DefaultPort" xml:"DefaultPort"`
	Description                       aws.StringValue            `query:"Description" xml:"Description"`
	EngineName                        aws.StringValue            `query:"EngineName" xml:"EngineName"`
	MajorEngineVersion                aws.StringValue            `query:"MajorEngineVersion" xml:"MajorEngineVersion"`
	MinimumRequiredMinorEngineVersion aws.StringValue            `query:"MinimumRequiredMinorEngineVersion" xml:"MinimumRequiredMinorEngineVersion"`
	Name                              aws.StringValue            `query:"Name" xml:"Name"`
	OptionGroupOptionSettings         []OptionGroupOptionSetting `query:"OptionGroupOptionSettings.member" xml:"OptionGroupOptionSettings>OptionGroupOptionSetting"`
	OptionsDependedOn                 []string                   `query:"OptionsDependedOn.member" xml:"OptionsDependedOn>OptionName"`
	Permanent                         aws.BooleanValue           `query:"Permanent" xml:"Permanent"`
	Persistent                        aws.BooleanValue           `query:"Persistent" xml:"Persistent"`
	PortRequired                      aws.BooleanValue           `query:"PortRequired" xml:"PortRequired"`
}

// OptionGroupOptionSetting is undocumented.
type OptionGroupOptionSetting struct {
	AllowedValues      aws.StringValue  `query:"AllowedValues" xml:"AllowedValues"`
	ApplyType          aws.StringValue  `query:"ApplyType" xml:"ApplyType"`
	DefaultValue       aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	IsModifiable       aws.BooleanValue `query:"IsModifiable" xml:"IsModifiable"`
	SettingDescription aws.StringValue  `query:"SettingDescription" xml:"SettingDescription"`
	SettingName        aws.StringValue  `query:"SettingName" xml:"SettingName"`
}

// OptionGroupOptionsMessage is undocumented.
type OptionGroupOptionsMessage struct {
	Marker             aws.StringValue     `query:"Marker" xml:"DescribeOptionGroupOptionsResult>Marker"`
	OptionGroupOptions []OptionGroupOption `query:"OptionGroupOptions.member" xml:"DescribeOptionGroupOptionsResult>OptionGroupOptions>OptionGroupOption"`
}

// OptionGroups is undocumented.
type OptionGroups struct {
	Marker           aws.StringValue `query:"Marker" xml:"DescribeOptionGroupsResult>Marker"`
	OptionGroupsList []OptionGroup   `query:"OptionGroupsList.member" xml:"DescribeOptionGroupsResult>OptionGroupsList>OptionGroup"`
}

// OptionSetting is undocumented.
type OptionSetting struct {
	AllowedValues aws.StringValue  `query:"AllowedValues" xml:"AllowedValues"`
	ApplyType     aws.StringValue  `query:"ApplyType" xml:"ApplyType"`
	DataType      aws.StringValue  `query:"DataType" xml:"DataType"`
	DefaultValue  aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	Description   aws.StringValue  `query:"Description" xml:"Description"`
	IsCollection  aws.BooleanValue `query:"IsCollection" xml:"IsCollection"`
	IsModifiable  aws.BooleanValue `query:"IsModifiable" xml:"IsModifiable"`
	Name          aws.StringValue  `query:"Name" xml:"Name"`
	Value         aws.StringValue  `query:"Value" xml:"Value"`
}

// OrderableDBInstanceOption is undocumented.
type OrderableDBInstanceOption struct {
	AvailabilityZones         []AvailabilityZone `query:"AvailabilityZones.member" xml:"AvailabilityZones>AvailabilityZone"`
	DBInstanceClass           aws.StringValue    `query:"DBInstanceClass" xml:"DBInstanceClass"`
	Engine                    aws.StringValue    `query:"Engine" xml:"Engine"`
	EngineVersion             aws.StringValue    `query:"EngineVersion" xml:"EngineVersion"`
	LicenseModel              aws.StringValue    `query:"LicenseModel" xml:"LicenseModel"`
	MultiAZCapable            aws.BooleanValue   `query:"MultiAZCapable" xml:"MultiAZCapable"`
	ReadReplicaCapable        aws.BooleanValue   `query:"ReadReplicaCapable" xml:"ReadReplicaCapable"`
	StorageType               aws.StringValue    `query:"StorageType" xml:"StorageType"`
	SupportsIOPS              aws.BooleanValue   `query:"SupportsIops" xml:"SupportsIops"`
	SupportsStorageEncryption aws.BooleanValue   `query:"SupportsStorageEncryption" xml:"SupportsStorageEncryption"`
	VPC                       aws.BooleanValue   `query:"Vpc" xml:"Vpc"`
}

// OrderableDBInstanceOptionsMessage is undocumented.
type OrderableDBInstanceOptionsMessage struct {
	Marker                     aws.StringValue             `query:"Marker" xml:"DescribeOrderableDBInstanceOptionsResult>Marker"`
	OrderableDBInstanceOptions []OrderableDBInstanceOption `query:"OrderableDBInstanceOptions.member" xml:"DescribeOrderableDBInstanceOptionsResult>OrderableDBInstanceOptions>OrderableDBInstanceOption"`
}

// Parameter is undocumented.
type Parameter struct {
	AllowedValues        aws.StringValue  `query:"AllowedValues" xml:"AllowedValues"`
	ApplyMethod          aws.StringValue  `query:"ApplyMethod" xml:"ApplyMethod"`
	ApplyType            aws.StringValue  `query:"ApplyType" xml:"ApplyType"`
	DataType             aws.StringValue  `query:"DataType" xml:"DataType"`
	Description          aws.StringValue  `query:"Description" xml:"Description"`
	IsModifiable         aws.BooleanValue `query:"IsModifiable" xml:"IsModifiable"`
	MinimumEngineVersion aws.StringValue  `query:"MinimumEngineVersion" xml:"MinimumEngineVersion"`
	ParameterName        aws.StringValue  `query:"ParameterName" xml:"ParameterName"`
	ParameterValue       aws.StringValue  `query:"ParameterValue" xml:"ParameterValue"`
	Source               aws.StringValue  `query:"Source" xml:"Source"`
}

// PendingMaintenanceAction is undocumented.
type PendingMaintenanceAction struct {
	Action               aws.StringValue `query:"Action" xml:"Action"`
	AutoAppliedAfterDate time.Time       `query:"AutoAppliedAfterDate" xml:"AutoAppliedAfterDate"`
	CurrentApplyDate     time.Time       `query:"CurrentApplyDate" xml:"CurrentApplyDate"`
	ForcedApplyDate      time.Time       `query:"ForcedApplyDate" xml:"ForcedApplyDate"`
	OptInStatus          aws.StringValue `query:"OptInStatus" xml:"OptInStatus"`
}

// PendingMaintenanceActionsMessage is undocumented.
type PendingMaintenanceActionsMessage struct {
	Marker                    aws.StringValue                     `query:"Marker" xml:"DescribePendingMaintenanceActionsResult>Marker"`
	PendingMaintenanceActions []ResourcePendingMaintenanceActions `query:"PendingMaintenanceActions.member" xml:"DescribePendingMaintenanceActionsResult>PendingMaintenanceActions>ResourcePendingMaintenanceActions"`
}

// PendingModifiedValues is undocumented.
type PendingModifiedValues struct {
	AllocatedStorage      aws.IntegerValue `query:"AllocatedStorage" xml:"AllocatedStorage"`
	BackupRetentionPeriod aws.IntegerValue `query:"BackupRetentionPeriod" xml:"BackupRetentionPeriod"`
	DBInstanceClass       aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	DBInstanceIdentifier  aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	EngineVersion         aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	IOPS                  aws.IntegerValue `query:"Iops" xml:"Iops"`
	MasterUserPassword    aws.StringValue  `query:"MasterUserPassword" xml:"MasterUserPassword"`
	MultiAZ               aws.BooleanValue `query:"MultiAZ" xml:"MultiAZ"`
	Port                  aws.IntegerValue `query:"Port" xml:"Port"`
	StorageType           aws.StringValue  `query:"StorageType" xml:"StorageType"`
}

// PromoteReadReplicaMessage is undocumented.
type PromoteReadReplicaMessage struct {
	BackupRetentionPeriod aws.IntegerValue `query:"BackupRetentionPeriod" xml:"BackupRetentionPeriod"`
	DBInstanceIdentifier  aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	PreferredBackupWindow aws.StringValue  `query:"PreferredBackupWindow" xml:"PreferredBackupWindow"`
}

// PromoteReadReplicaResult is undocumented.
type PromoteReadReplicaResult struct {
	DBInstance *DBInstance `query:"DBInstance" xml:"PromoteReadReplicaResult>DBInstance"`
}

// PurchaseReservedDBInstancesOfferingMessage is undocumented.
type PurchaseReservedDBInstancesOfferingMessage struct {
	DBInstanceCount               aws.IntegerValue `query:"DBInstanceCount" xml:"DBInstanceCount"`
	ReservedDBInstanceID          aws.StringValue  `query:"ReservedDBInstanceId" xml:"ReservedDBInstanceId"`
	ReservedDBInstancesOfferingID aws.StringValue  `query:"ReservedDBInstancesOfferingId" xml:"ReservedDBInstancesOfferingId"`
	Tags                          []Tag            `query:"Tags.member" xml:"Tags>Tag"`
}

// PurchaseReservedDBInstancesOfferingResult is undocumented.
type PurchaseReservedDBInstancesOfferingResult struct {
	ReservedDBInstance *ReservedDBInstance `query:"ReservedDBInstance" xml:"PurchaseReservedDBInstancesOfferingResult>ReservedDBInstance"`
}

// RebootDBInstanceMessage is undocumented.
type RebootDBInstanceMessage struct {
	DBInstanceIdentifier aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	ForceFailover        aws.BooleanValue `query:"ForceFailover" xml:"ForceFailover"`
}

// RebootDBInstanceResult is undocumented.
type RebootDBInstanceResult struct {
	DBInstance *DBInstance `query:"DBInstance" xml:"RebootDBInstanceResult>DBInstance"`
}

// RecurringCharge is undocumented.
type RecurringCharge struct {
	RecurringChargeAmount    aws.DoubleValue `query:"RecurringChargeAmount" xml:"RecurringChargeAmount"`
	RecurringChargeFrequency aws.StringValue `query:"RecurringChargeFrequency" xml:"RecurringChargeFrequency"`
}

// RemoveSourceIdentifierFromSubscriptionMessage is undocumented.
type RemoveSourceIdentifierFromSubscriptionMessage struct {
	SourceIdentifier aws.StringValue `query:"SourceIdentifier" xml:"SourceIdentifier"`
	SubscriptionName aws.StringValue `query:"SubscriptionName" xml:"SubscriptionName"`
}

// RemoveSourceIdentifierFromSubscriptionResult is undocumented.
type RemoveSourceIdentifierFromSubscriptionResult struct {
	EventSubscription *EventSubscription `query:"EventSubscription" xml:"RemoveSourceIdentifierFromSubscriptionResult>EventSubscription"`
}

// RemoveTagsFromResourceMessage is undocumented.
type RemoveTagsFromResourceMessage struct {
	ResourceName aws.StringValue `query:"ResourceName" xml:"ResourceName"`
	TagKeys      []string        `query:"TagKeys.member" xml:"TagKeys>member"`
}

// ReservedDBInstance is undocumented.
type ReservedDBInstance struct {
	CurrencyCode                  aws.StringValue   `query:"CurrencyCode" xml:"CurrencyCode"`
	DBInstanceClass               aws.StringValue   `query:"DBInstanceClass" xml:"DBInstanceClass"`
	DBInstanceCount               aws.IntegerValue  `query:"DBInstanceCount" xml:"DBInstanceCount"`
	Duration                      aws.IntegerValue  `query:"Duration" xml:"Duration"`
	FixedPrice                    aws.DoubleValue   `query:"FixedPrice" xml:"FixedPrice"`
	MultiAZ                       aws.BooleanValue  `query:"MultiAZ" xml:"MultiAZ"`
	OfferingType                  aws.StringValue   `query:"OfferingType" xml:"OfferingType"`
	ProductDescription            aws.StringValue   `query:"ProductDescription" xml:"ProductDescription"`
	RecurringCharges              []RecurringCharge `query:"RecurringCharges.member" xml:"RecurringCharges>RecurringCharge"`
	ReservedDBInstanceID          aws.StringValue   `query:"ReservedDBInstanceId" xml:"ReservedDBInstanceId"`
	ReservedDBInstancesOfferingID aws.StringValue   `query:"ReservedDBInstancesOfferingId" xml:"ReservedDBInstancesOfferingId"`
	StartTime                     time.Time         `query:"StartTime" xml:"StartTime"`
	State                         aws.StringValue   `query:"State" xml:"State"`
	UsagePrice                    aws.DoubleValue   `query:"UsagePrice" xml:"UsagePrice"`
}

// ReservedDBInstanceMessage is undocumented.
type ReservedDBInstanceMessage struct {
	Marker              aws.StringValue      `query:"Marker" xml:"DescribeReservedDBInstancesResult>Marker"`
	ReservedDBInstances []ReservedDBInstance `query:"ReservedDBInstances.member" xml:"DescribeReservedDBInstancesResult>ReservedDBInstances>ReservedDBInstance"`
}

// ReservedDBInstancesOffering is undocumented.
type ReservedDBInstancesOffering struct {
	CurrencyCode                  aws.StringValue   `query:"CurrencyCode" xml:"CurrencyCode"`
	DBInstanceClass               aws.StringValue   `query:"DBInstanceClass" xml:"DBInstanceClass"`
	Duration                      aws.IntegerValue  `query:"Duration" xml:"Duration"`
	FixedPrice                    aws.DoubleValue   `query:"FixedPrice" xml:"FixedPrice"`
	MultiAZ                       aws.BooleanValue  `query:"MultiAZ" xml:"MultiAZ"`
	OfferingType                  aws.StringValue   `query:"OfferingType" xml:"OfferingType"`
	ProductDescription            aws.StringValue   `query:"ProductDescription" xml:"ProductDescription"`
	RecurringCharges              []RecurringCharge `query:"RecurringCharges.member" xml:"RecurringCharges>RecurringCharge"`
	ReservedDBInstancesOfferingID aws.StringValue   `query:"ReservedDBInstancesOfferingId" xml:"ReservedDBInstancesOfferingId"`
	UsagePrice                    aws.DoubleValue   `query:"UsagePrice" xml:"UsagePrice"`
}

// ReservedDBInstancesOfferingMessage is undocumented.
type ReservedDBInstancesOfferingMessage struct {
	Marker                       aws.StringValue               `query:"Marker" xml:"DescribeReservedDBInstancesOfferingsResult>Marker"`
	ReservedDBInstancesOfferings []ReservedDBInstancesOffering `query:"ReservedDBInstancesOfferings.member" xml:"DescribeReservedDBInstancesOfferingsResult>ReservedDBInstancesOfferings>ReservedDBInstancesOffering"`
}

// ResetDBParameterGroupMessage is undocumented.
type ResetDBParameterGroupMessage struct {
	DBParameterGroupName aws.StringValue  `query:"DBParameterGroupName" xml:"DBParameterGroupName"`
	Parameters           []Parameter      `query:"Parameters.member" xml:"Parameters>Parameter"`
	ResetAllParameters   aws.BooleanValue `query:"ResetAllParameters" xml:"ResetAllParameters"`
}

// ResourcePendingMaintenanceActions is undocumented.
type ResourcePendingMaintenanceActions struct {
	PendingMaintenanceActionDetails []PendingMaintenanceAction `query:"PendingMaintenanceActionDetails.member" xml:"PendingMaintenanceActionDetails>PendingMaintenanceAction"`
	ResourceIdentifier              aws.StringValue            `query:"ResourceIdentifier" xml:"ResourceIdentifier"`
}

// RestoreDBInstanceFromDBSnapshotMessage is undocumented.
type RestoreDBInstanceFromDBSnapshotMessage struct {
	AutoMinorVersionUpgrade aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	AvailabilityZone        aws.StringValue  `query:"AvailabilityZone" xml:"AvailabilityZone"`
	DBInstanceClass         aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	DBInstanceIdentifier    aws.StringValue  `query:"DBInstanceIdentifier" xml:"DBInstanceIdentifier"`
	DBName                  aws.StringValue  `query:"DBName" xml:"DBName"`
	DBSnapshotIdentifier    aws.StringValue  `query:"DBSnapshotIdentifier" xml:"DBSnapshotIdentifier"`
	DBSubnetGroupName       aws.StringValue  `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
	Engine                  aws.StringValue  `query:"Engine" xml:"Engine"`
	IOPS                    aws.IntegerValue `query:"Iops" xml:"Iops"`
	LicenseModel            aws.StringValue  `query:"LicenseModel" xml:"LicenseModel"`
	MultiAZ                 aws.BooleanValue `query:"MultiAZ" xml:"MultiAZ"`
	OptionGroupName         aws.StringValue  `query:"OptionGroupName" xml:"OptionGroupName"`
	Port                    aws.IntegerValue `query:"Port" xml:"Port"`
	PubliclyAccessible      aws.BooleanValue `query:"PubliclyAccessible" xml:"PubliclyAccessible"`
	StorageType             aws.StringValue  `query:"StorageType" xml:"StorageType"`
	Tags                    []Tag            `query:"Tags.member" xml:"Tags>Tag"`
	TDECredentialARN        aws.StringValue  `query:"TdeCredentialArn" xml:"TdeCredentialArn"`
	TDECredentialPassword   aws.StringValue  `query:"TdeCredentialPassword" xml:"TdeCredentialPassword"`
}

// RestoreDBInstanceFromDBSnapshotResult is undocumented.
type RestoreDBInstanceFromDBSnapshotResult struct {
	DBInstance *DBInstance `query:"DBInstance" xml:"RestoreDBInstanceFromDBSnapshotResult>DBInstance"`
}

// RestoreDBInstanceToPointInTimeMessage is undocumented.
type RestoreDBInstanceToPointInTimeMessage struct {
	AutoMinorVersionUpgrade    aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	AvailabilityZone           aws.StringValue  `query:"AvailabilityZone" xml:"AvailabilityZone"`
	DBInstanceClass            aws.StringValue  `query:"DBInstanceClass" xml:"DBInstanceClass"`
	DBName                     aws.StringValue  `query:"DBName" xml:"DBName"`
	DBSubnetGroupName          aws.StringValue  `query:"DBSubnetGroupName" xml:"DBSubnetGroupName"`
	Engine                     aws.StringValue  `query:"Engine" xml:"Engine"`
	IOPS                       aws.IntegerValue `query:"Iops" xml:"Iops"`
	LicenseModel               aws.StringValue  `query:"LicenseModel" xml:"LicenseModel"`
	MultiAZ                    aws.BooleanValue `query:"MultiAZ" xml:"MultiAZ"`
	OptionGroupName            aws.StringValue  `query:"OptionGroupName" xml:"OptionGroupName"`
	Port                       aws.IntegerValue `query:"Port" xml:"Port"`
	PubliclyAccessible         aws.BooleanValue `query:"PubliclyAccessible" xml:"PubliclyAccessible"`
	RestoreTime                time.Time        `query:"RestoreTime" xml:"RestoreTime"`
	SourceDBInstanceIdentifier aws.StringValue  `query:"SourceDBInstanceIdentifier" xml:"SourceDBInstanceIdentifier"`
	StorageType                aws.StringValue  `query:"StorageType" xml:"StorageType"`
	Tags                       []Tag            `query:"Tags.member" xml:"Tags>Tag"`
	TargetDBInstanceIdentifier aws.StringValue  `query:"TargetDBInstanceIdentifier" xml:"TargetDBInstanceIdentifier"`
	TDECredentialARN           aws.StringValue  `query:"TdeCredentialArn" xml:"TdeCredentialArn"`
	TDECredentialPassword      aws.StringValue  `query:"TdeCredentialPassword" xml:"TdeCredentialPassword"`
	UseLatestRestorableTime    aws.BooleanValue `query:"UseLatestRestorableTime" xml:"UseLatestRestorableTime"`
}

// RestoreDBInstanceToPointInTimeResult is undocumented.
type RestoreDBInstanceToPointInTimeResult struct {
	DBInstance *DBInstance `query:"DBInstance" xml:"RestoreDBInstanceToPointInTimeResult>DBInstance"`
}

// RevokeDBSecurityGroupIngressMessage is undocumented.
type RevokeDBSecurityGroupIngressMessage struct {
	CIDRIP                  aws.StringValue `query:"CIDRIP" xml:"CIDRIP"`
	DBSecurityGroupName     aws.StringValue `query:"DBSecurityGroupName" xml:"DBSecurityGroupName"`
	EC2SecurityGroupID      aws.StringValue `query:"EC2SecurityGroupId" xml:"EC2SecurityGroupId"`
	EC2SecurityGroupName    aws.StringValue `query:"EC2SecurityGroupName" xml:"EC2SecurityGroupName"`
	EC2SecurityGroupOwnerID aws.StringValue `query:"EC2SecurityGroupOwnerId" xml:"EC2SecurityGroupOwnerId"`
}

// RevokeDBSecurityGroupIngressResult is undocumented.
type RevokeDBSecurityGroupIngressResult struct {
	DBSecurityGroup *DBSecurityGroup `query:"DBSecurityGroup" xml:"RevokeDBSecurityGroupIngressResult>DBSecurityGroup"`
}

// Possible values for RDS.
const (
	SourceTypeDBInstance       = "db-instance"
	SourceTypeDBParameterGroup = "db-parameter-group"
	SourceTypeDBSecurityGroup  = "db-security-group"
	SourceTypeDBSnapshot       = "db-snapshot"
)

// Subnet is undocumented.
type Subnet struct {
	SubnetAvailabilityZone *AvailabilityZone `query:"SubnetAvailabilityZone" xml:"SubnetAvailabilityZone"`
	SubnetIdentifier       aws.StringValue   `query:"SubnetIdentifier" xml:"SubnetIdentifier"`
	SubnetStatus           aws.StringValue   `query:"SubnetStatus" xml:"SubnetStatus"`
}

// Tag is undocumented.
type Tag struct {
	Key   aws.StringValue `query:"Key" xml:"Key"`
	Value aws.StringValue `query:"Value" xml:"Value"`
}

// TagListMessage is undocumented.
type TagListMessage struct {
	TagList []Tag `query:"TagList.member" xml:"ListTagsForResourceResult>TagList>Tag"`
}

// VPCSecurityGroupMembership is undocumented.
type VPCSecurityGroupMembership struct {
	Status             aws.StringValue `query:"Status" xml:"Status"`
	VPCSecurityGroupID aws.StringValue `query:"VpcSecurityGroupId" xml:"VpcSecurityGroupId"`
}

// DescribeDBEngineVersionsResult is a wrapper for DBEngineVersionMessage.
type DescribeDBEngineVersionsResult struct {
	DBEngineVersions []DBEngineVersion `query:"DBEngineVersions.member" xml:"DescribeDBEngineVersionsResult>DBEngineVersions>DBEngineVersion"`
	Marker           aws.StringValue   `query:"Marker" xml:"DescribeDBEngineVersionsResult>Marker"`
}

// DescribeDBInstancesResult is a wrapper for DBInstanceMessage.
type DescribeDBInstancesResult struct {
	DBInstances []DBInstance    `query:"DBInstances.member" xml:"DescribeDBInstancesResult>DBInstances>DBInstance"`
	Marker      aws.StringValue `query:"Marker" xml:"DescribeDBInstancesResult>Marker"`
}

// DescribeDBLogFilesResult is a wrapper for DescribeDBLogFilesResponse.
type DescribeDBLogFilesResult struct {
	DescribeDBLogFiles []DescribeDBLogFilesDetails `query:"DescribeDBLogFiles.member" xml:"DescribeDBLogFilesResult>DescribeDBLogFiles>DescribeDBLogFilesDetails"`
	Marker             aws.StringValue             `query:"Marker" xml:"DescribeDBLogFilesResult>Marker"`
}

// DescribeDBParameterGroupsResult is a wrapper for DBParameterGroupsMessage.
type DescribeDBParameterGroupsResult struct {
	DBParameterGroups []DBParameterGroup `query:"DBParameterGroups.member" xml:"DescribeDBParameterGroupsResult>DBParameterGroups>DBParameterGroup"`
	Marker            aws.StringValue    `query:"Marker" xml:"DescribeDBParameterGroupsResult>Marker"`
}

// DescribeDBParametersResult is a wrapper for DBParameterGroupDetails.
type DescribeDBParametersResult struct {
	Marker     aws.StringValue `query:"Marker" xml:"DescribeDBParametersResult>Marker"`
	Parameters []Parameter     `query:"Parameters.member" xml:"DescribeDBParametersResult>Parameters>Parameter"`
}

// DescribeDBSecurityGroupsResult is a wrapper for DBSecurityGroupMessage.
type DescribeDBSecurityGroupsResult struct {
	DBSecurityGroups []DBSecurityGroup `query:"DBSecurityGroups.member" xml:"DescribeDBSecurityGroupsResult>DBSecurityGroups>DBSecurityGroup"`
	Marker           aws.StringValue   `query:"Marker" xml:"DescribeDBSecurityGroupsResult>Marker"`
}

// DescribeDBSnapshotsResult is a wrapper for DBSnapshotMessage.
type DescribeDBSnapshotsResult struct {
	DBSnapshots []DBSnapshot    `query:"DBSnapshots.member" xml:"DescribeDBSnapshotsResult>DBSnapshots>DBSnapshot"`
	Marker      aws.StringValue `query:"Marker" xml:"DescribeDBSnapshotsResult>Marker"`
}

// DescribeDBSubnetGroupsResult is a wrapper for DBSubnetGroupMessage.
type DescribeDBSubnetGroupsResult struct {
	DBSubnetGroups []DBSubnetGroup `query:"DBSubnetGroups.member" xml:"DescribeDBSubnetGroupsResult>DBSubnetGroups>DBSubnetGroup"`
	Marker         aws.StringValue `query:"Marker" xml:"DescribeDBSubnetGroupsResult>Marker"`
}

// DescribeEventCategoriesResult is a wrapper for EventCategoriesMessage.
type DescribeEventCategoriesResult struct {
	EventCategoriesMapList []EventCategoriesMap `query:"EventCategoriesMapList.member" xml:"DescribeEventCategoriesResult>EventCategoriesMapList>EventCategoriesMap"`
}

// DescribeEventSubscriptionsResult is a wrapper for EventSubscriptionsMessage.
type DescribeEventSubscriptionsResult struct {
	EventSubscriptionsList []EventSubscription `query:"EventSubscriptionsList.member" xml:"DescribeEventSubscriptionsResult>EventSubscriptionsList>EventSubscription"`
	Marker                 aws.StringValue     `query:"Marker" xml:"DescribeEventSubscriptionsResult>Marker"`
}

// DescribeEventsResult is a wrapper for EventsMessage.
type DescribeEventsResult struct {
	Events []Event         `query:"Events.member" xml:"DescribeEventsResult>Events>Event"`
	Marker aws.StringValue `query:"Marker" xml:"DescribeEventsResult>Marker"`
}

// DescribeOptionGroupOptionsResult is a wrapper for OptionGroupOptionsMessage.
type DescribeOptionGroupOptionsResult struct {
	Marker             aws.StringValue     `query:"Marker" xml:"DescribeOptionGroupOptionsResult>Marker"`
	OptionGroupOptions []OptionGroupOption `query:"OptionGroupOptions.member" xml:"DescribeOptionGroupOptionsResult>OptionGroupOptions>OptionGroupOption"`
}

// DescribeOptionGroupsResult is a wrapper for OptionGroups.
type DescribeOptionGroupsResult struct {
	Marker           aws.StringValue `query:"Marker" xml:"DescribeOptionGroupsResult>Marker"`
	OptionGroupsList []OptionGroup   `query:"OptionGroupsList.member" xml:"DescribeOptionGroupsResult>OptionGroupsList>OptionGroup"`
}

// DescribeOrderableDBInstanceOptionsResult is a wrapper for OrderableDBInstanceOptionsMessage.
type DescribeOrderableDBInstanceOptionsResult struct {
	Marker                     aws.StringValue             `query:"Marker" xml:"DescribeOrderableDBInstanceOptionsResult>Marker"`
	OrderableDBInstanceOptions []OrderableDBInstanceOption `query:"OrderableDBInstanceOptions.member" xml:"DescribeOrderableDBInstanceOptionsResult>OrderableDBInstanceOptions>OrderableDBInstanceOption"`
}

// DescribePendingMaintenanceActionsResult is a wrapper for PendingMaintenanceActionsMessage.
type DescribePendingMaintenanceActionsResult struct {
	Marker                    aws.StringValue                     `query:"Marker" xml:"DescribePendingMaintenanceActionsResult>Marker"`
	PendingMaintenanceActions []ResourcePendingMaintenanceActions `query:"PendingMaintenanceActions.member" xml:"DescribePendingMaintenanceActionsResult>PendingMaintenanceActions>ResourcePendingMaintenanceActions"`
}

// DescribeReservedDBInstancesOfferingsResult is a wrapper for ReservedDBInstancesOfferingMessage.
type DescribeReservedDBInstancesOfferingsResult struct {
	Marker                       aws.StringValue               `query:"Marker" xml:"DescribeReservedDBInstancesOfferingsResult>Marker"`
	ReservedDBInstancesOfferings []ReservedDBInstancesOffering `query:"ReservedDBInstancesOfferings.member" xml:"DescribeReservedDBInstancesOfferingsResult>ReservedDBInstancesOfferings>ReservedDBInstancesOffering"`
}

// DescribeReservedDBInstancesResult is a wrapper for ReservedDBInstanceMessage.
type DescribeReservedDBInstancesResult struct {
	Marker              aws.StringValue      `query:"Marker" xml:"DescribeReservedDBInstancesResult>Marker"`
	ReservedDBInstances []ReservedDBInstance `query:"ReservedDBInstances.member" xml:"DescribeReservedDBInstancesResult>ReservedDBInstances>ReservedDBInstance"`
}

// DownloadDBLogFilePortionResult is a wrapper for DownloadDBLogFilePortionDetails.
type DownloadDBLogFilePortionResult struct {
	AdditionalDataPending aws.BooleanValue `query:"AdditionalDataPending" xml:"DownloadDBLogFilePortionResult>AdditionalDataPending"`
	LogFileData           aws.StringValue  `query:"LogFileData" xml:"DownloadDBLogFilePortionResult>LogFileData"`
	Marker                aws.StringValue  `query:"Marker" xml:"DownloadDBLogFilePortionResult>Marker"`
}

// ListTagsForResourceResult is a wrapper for TagListMessage.
type ListTagsForResourceResult struct {
	TagList []Tag `query:"TagList.member" xml:"ListTagsForResourceResult>TagList>Tag"`
}

// ModifyDBParameterGroupResult is a wrapper for DBParameterGroupNameMessage.
type ModifyDBParameterGroupResult struct {
	DBParameterGroupName aws.StringValue `query:"DBParameterGroupName" xml:"ModifyDBParameterGroupResult>DBParameterGroupName"`
}

// ResetDBParameterGroupResult is a wrapper for DBParameterGroupNameMessage.
type ResetDBParameterGroupResult struct {
	DBParameterGroupName aws.StringValue `query:"DBParameterGroupName" xml:"ResetDBParameterGroupResult>DBParameterGroupName"`
}

// avoid errors if the packages aren't referenced
var _ time.Time

var _ xml.Decoder
var _ = io.EOF
