// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package s3 provides a client for Amazon Simple Storage Service.
package s3

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"bytes"
	"encoding/xml"
	"fmt"
	"io"
	"io/ioutil"
	"net/url"
	"strconv"
	"strings"
)

// S3 is a client for Amazon Simple Storage Service.
type S3 struct {
	client *aws.RestClient
}

// New returns a new S3 client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *S3 {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("s3", region)

	return &S3{
		client: &aws.RestClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2006-03-01",
		},
	}
}

// AbortMultipartUpload aborts a multipart upload. To verify that all parts
// have been removed, so you don't get charged for the part storage, you
// should call the List Parts operation and ensure the parts list is empty.
func (c *S3) AbortMultipartUpload(req *AbortMultipartUploadRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.UploadID != nil {
		q.Set("uploadId", *req.UploadID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// CompleteMultipartUpload completes a multipart upload by assembling
// previously uploaded parts.
func (c *S3) CompleteMultipartUpload(req *CompleteMultipartUploadRequest) (resp *CompleteMultipartUploadOutput, err error) {
	resp = &CompleteMultipartUploadOutput{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.MultipartUpload != nil {
		req.MultipartUpload.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "CompleteMultipartUpload",
		}
	}

	b, err := xml.Marshal(req.MultipartUpload)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.UploadID != nil {
		q.Set("uploadId", *req.UploadID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-expiration"); s != "" {

		resp.Expiration = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-aws-kms-key-id"); s != "" {

		resp.SSEKMSKeyID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption"); s != "" {

		resp.ServerSideEncryption = &s

	}

	if s := httpResp.Header.Get("x-amz-version-id"); s != "" {

		resp.VersionID = &s

	}

	return
}

// CopyObject creates a copy of an object that is already stored in Amazon
// S3.
func (c *S3) CopyObject(req *CopyObjectRequest) (resp *CopyObjectOutput, err error) {
	resp = &CopyObjectOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ACL != nil {
		httpReq.Header.Set("x-amz-acl", *req.ACL)
	}

	if req.CacheControl != nil {
		httpReq.Header.Set("Cache-Control", *req.CacheControl)
	}

	if req.ContentDisposition != nil {
		httpReq.Header.Set("Content-Disposition", *req.ContentDisposition)
	}

	if req.ContentEncoding != nil {
		httpReq.Header.Set("Content-Encoding", *req.ContentEncoding)
	}

	if req.ContentLanguage != nil {
		httpReq.Header.Set("Content-Language", *req.ContentLanguage)
	}

	if req.ContentType != nil {
		httpReq.Header.Set("Content-Type", *req.ContentType)
	}

	if req.CopySource != nil {
		httpReq.Header.Set("x-amz-copy-source", *req.CopySource)
	}

	if req.CopySourceIfMatch != nil {
		httpReq.Header.Set("x-amz-copy-source-if-match", *req.CopySourceIfMatch)
	}

	if req.CopySourceIfModifiedSince != (time.Time{}) {
		httpReq.Header.Set("x-amz-copy-source-if-modified-since", req.CopySourceIfModifiedSince.Format(time.RFC822))
	}

	if req.CopySourceIfNoneMatch != nil {
		httpReq.Header.Set("x-amz-copy-source-if-none-match", *req.CopySourceIfNoneMatch)
	}

	if req.CopySourceIfUnmodifiedSince != (time.Time{}) {
		httpReq.Header.Set("x-amz-copy-source-if-unmodified-since", req.CopySourceIfUnmodifiedSince.Format(time.RFC822))
	}

	if req.CopySourceSSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-copy-source-server-side-encryption-customer-algorithm", *req.CopySourceSSECustomerAlgorithm)
	}

	if req.CopySourceSSECustomerKey != nil {
		httpReq.Header.Set("x-amz-copy-source-server-side-encryption-customer-key", *req.CopySourceSSECustomerKey)
	}

	if req.CopySourceSSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-copy-source-server-side-encryption-customer-key-MD5", *req.CopySourceSSECustomerKeyMD5)
	}

	if req.Expires != (time.Time{}) {
		httpReq.Header.Set("Expires", req.Expires.Format(time.RFC822))
	}

	if req.GrantFullControl != nil {
		httpReq.Header.Set("x-amz-grant-full-control", *req.GrantFullControl)
	}

	if req.GrantRead != nil {
		httpReq.Header.Set("x-amz-grant-read", *req.GrantRead)
	}

	if req.GrantReadACP != nil {
		httpReq.Header.Set("x-amz-grant-read-acp", *req.GrantReadACP)
	}

	if req.GrantWriteACP != nil {
		httpReq.Header.Set("x-amz-grant-write-acp", *req.GrantWriteACP)
	}

	for name, value := range req.Metadata {
		httpReq.Header.Set(name, value)
	}

	if req.MetadataDirective != nil {
		httpReq.Header.Set("x-amz-metadata-directive", *req.MetadataDirective)
	}

	if req.SSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-algorithm", *req.SSECustomerAlgorithm)
	}

	if req.SSECustomerKey != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key", *req.SSECustomerKey)
	}

	if req.SSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key-MD5", *req.SSECustomerKeyMD5)
	}

	if req.SSEKMSKeyID != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-aws-kms-key-id", *req.SSEKMSKeyID)
	}

	if req.ServerSideEncryption != nil {
		httpReq.Header.Set("x-amz-server-side-encryption", *req.ServerSideEncryption)
	}

	if req.StorageClass != nil {
		httpReq.Header.Set("x-amz-storage-class", *req.StorageClass)
	}

	if req.WebsiteRedirectLocation != nil {
		httpReq.Header.Set("x-amz-website-redirect-location", *req.WebsiteRedirectLocation)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-copy-source-version-id"); s != "" {

		resp.CopySourceVersionID = &s

	}

	if s := httpResp.Header.Get("x-amz-expiration"); s != "" {

		resp.Expiration = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-algorithm"); s != "" {

		resp.SSECustomerAlgorithm = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-key-MD5"); s != "" {

		resp.SSECustomerKeyMD5 = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-aws-kms-key-id"); s != "" {

		resp.SSEKMSKeyID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption"); s != "" {

		resp.ServerSideEncryption = &s

	}

	return
}

// CreateBucket is undocumented.
func (c *S3) CreateBucket(req *CreateBucketRequest) (resp *CreateBucketOutput, err error) {
	resp = &CreateBucketOutput{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.CreateBucketConfiguration != nil {
		req.CreateBucketConfiguration.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "CreateBucketConfiguration",
		}
	}

	b, err := xml.Marshal(req.CreateBucketConfiguration)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ACL != nil {
		httpReq.Header.Set("x-amz-acl", *req.ACL)
	}

	if req.GrantFullControl != nil {
		httpReq.Header.Set("x-amz-grant-full-control", *req.GrantFullControl)
	}

	if req.GrantRead != nil {
		httpReq.Header.Set("x-amz-grant-read", *req.GrantRead)
	}

	if req.GrantReadACP != nil {
		httpReq.Header.Set("x-amz-grant-read-acp", *req.GrantReadACP)
	}

	if req.GrantWrite != nil {
		httpReq.Header.Set("x-amz-grant-write", *req.GrantWrite)
	}

	if req.GrantWriteACP != nil {
		httpReq.Header.Set("x-amz-grant-write-acp", *req.GrantWriteACP)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// CreateMultipartUpload initiates a multipart upload and returns an upload
// Note: After you initiate multipart upload and upload one or more parts,
// you must either complete or abort multipart upload in order to stop
// getting charged for storage of the uploaded parts. Only after you either
// complete or abort multipart upload, Amazon S3 frees up the parts storage
// and stops charging you for the parts storage.
func (c *S3) CreateMultipartUpload(req *CreateMultipartUploadRequest) (resp *CreateMultipartUploadOutput, err error) {
	resp = &CreateMultipartUploadOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}?uploads"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ACL != nil {
		httpReq.Header.Set("x-amz-acl", *req.ACL)
	}

	if req.CacheControl != nil {
		httpReq.Header.Set("Cache-Control", *req.CacheControl)
	}

	if req.ContentDisposition != nil {
		httpReq.Header.Set("Content-Disposition", *req.ContentDisposition)
	}

	if req.ContentEncoding != nil {
		httpReq.Header.Set("Content-Encoding", *req.ContentEncoding)
	}

	if req.ContentLanguage != nil {
		httpReq.Header.Set("Content-Language", *req.ContentLanguage)
	}

	if req.ContentType != nil {
		httpReq.Header.Set("Content-Type", *req.ContentType)
	}

	if req.Expires != (time.Time{}) {
		httpReq.Header.Set("Expires", req.Expires.Format(time.RFC822))
	}

	if req.GrantFullControl != nil {
		httpReq.Header.Set("x-amz-grant-full-control", *req.GrantFullControl)
	}

	if req.GrantRead != nil {
		httpReq.Header.Set("x-amz-grant-read", *req.GrantRead)
	}

	if req.GrantReadACP != nil {
		httpReq.Header.Set("x-amz-grant-read-acp", *req.GrantReadACP)
	}

	if req.GrantWriteACP != nil {
		httpReq.Header.Set("x-amz-grant-write-acp", *req.GrantWriteACP)
	}

	for name, value := range req.Metadata {
		httpReq.Header.Set(name, value)
	}

	if req.SSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-algorithm", *req.SSECustomerAlgorithm)
	}

	if req.SSECustomerKey != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key", *req.SSECustomerKey)
	}

	if req.SSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key-MD5", *req.SSECustomerKeyMD5)
	}

	if req.SSEKMSKeyID != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-aws-kms-key-id", *req.SSEKMSKeyID)
	}

	if req.ServerSideEncryption != nil {
		httpReq.Header.Set("x-amz-server-side-encryption", *req.ServerSideEncryption)
	}

	if req.StorageClass != nil {
		httpReq.Header.Set("x-amz-storage-class", *req.StorageClass)
	}

	if req.WebsiteRedirectLocation != nil {
		httpReq.Header.Set("x-amz-website-redirect-location", *req.WebsiteRedirectLocation)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-algorithm"); s != "" {

		resp.SSECustomerAlgorithm = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-key-MD5"); s != "" {

		resp.SSECustomerKeyMD5 = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-aws-kms-key-id"); s != "" {

		resp.SSEKMSKeyID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption"); s != "" {

		resp.ServerSideEncryption = &s

	}

	return
}

// DeleteBucket deletes the bucket. All objects (including all object
// versions and Delete Markers) in the bucket must be deleted before the
// bucket itself can be deleted.
func (c *S3) DeleteBucket(req *DeleteBucketRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteBucketCORS deletes the cors configuration information set for the
// bucket.
func (c *S3) DeleteBucketCORS(req *DeleteBucketCORSRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?cors"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteBucketLifecycle deletes the lifecycle configuration from the
// bucket.
func (c *S3) DeleteBucketLifecycle(req *DeleteBucketLifecycleRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?lifecycle"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteBucketPolicy is undocumented.
func (c *S3) DeleteBucketPolicy(req *DeleteBucketPolicyRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?policy"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteBucketTagging is undocumented.
func (c *S3) DeleteBucketTagging(req *DeleteBucketTaggingRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?tagging"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteBucketWebsite this operation removes the website configuration
// from the bucket.
func (c *S3) DeleteBucketWebsite(req *DeleteBucketWebsiteRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?website"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteObject removes the null version (if there is one) of an object and
// inserts a delete marker, which becomes the latest version of the object.
// If there isn't a null version, Amazon S3 does not remove any objects.
func (c *S3) DeleteObject(req *DeleteObjectRequest) (resp *DeleteObjectOutput, err error) {
	resp = &DeleteObjectOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.VersionID != nil {
		q.Set("versionId", *req.VersionID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.MFA != nil {
		httpReq.Header.Set("x-amz-mfa", *req.MFA)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-delete-marker"); s != "" {

		var v bool
		v, err = strconv.ParseBool(s)
		if err != nil {
			return
		}
		resp.DeleteMarker = &v

	}

	if s := httpResp.Header.Get("x-amz-version-id"); s != "" {

		resp.VersionID = &s

	}

	return
}

// DeleteObjects this operation enables you to delete multiple objects from
// a bucket using a single request. You may specify up to 1000 keys.
func (c *S3) DeleteObjects(req *DeleteObjectsRequest) (resp *DeleteObjectsOutput, err error) {
	resp = &DeleteObjectsOutput{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.Delete != nil {
		req.Delete.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "Delete",
		}
	}

	b, err := xml.Marshal(req.Delete)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?delete"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.MFA != nil {
		httpReq.Header.Set("x-amz-mfa", *req.MFA)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketACL is undocumented.
func (c *S3) GetBucketACL(req *GetBucketACLRequest) (resp *GetBucketACLOutput, err error) {
	resp = &GetBucketACLOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?acl"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketCORS is undocumented.
func (c *S3) GetBucketCORS(req *GetBucketCORSRequest) (resp *GetBucketCORSOutput, err error) {
	resp = &GetBucketCORSOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?cors"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketLifecycle returns the lifecycle configuration information set
// on the bucket.
func (c *S3) GetBucketLifecycle(req *GetBucketLifecycleRequest) (resp *GetBucketLifecycleOutput, err error) {
	resp = &GetBucketLifecycleOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?lifecycle"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketLocation is undocumented.
func (c *S3) GetBucketLocation(req *GetBucketLocationRequest) (resp *GetBucketLocationOutput, err error) {
	resp = &GetBucketLocationOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?location"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketLogging returns the logging status of a bucket and the
// permissions users have to view and modify that status. To use you must
// be the bucket owner.
func (c *S3) GetBucketLogging(req *GetBucketLoggingRequest) (resp *GetBucketLoggingOutput, err error) {
	resp = &GetBucketLoggingOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?logging"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketNotification is undocumented.
func (c *S3) GetBucketNotification(req *GetBucketNotificationRequest) (resp *GetBucketNotificationOutput, err error) {
	resp = &GetBucketNotificationOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?notification"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketPolicy is undocumented.
func (c *S3) GetBucketPolicy(req *GetBucketPolicyRequest) (resp *GetBucketPolicyOutput, err error) {
	resp = &GetBucketPolicyOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?policy"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketRequestPayment returns the request payment configuration of a
// bucket.
func (c *S3) GetBucketRequestPayment(req *GetBucketRequestPaymentRequest) (resp *GetBucketRequestPaymentOutput, err error) {
	resp = &GetBucketRequestPaymentOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?requestPayment"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketTagging is undocumented.
func (c *S3) GetBucketTagging(req *GetBucketTaggingRequest) (resp *GetBucketTaggingOutput, err error) {
	resp = &GetBucketTaggingOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?tagging"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketVersioning is undocumented.
func (c *S3) GetBucketVersioning(req *GetBucketVersioningRequest) (resp *GetBucketVersioningOutput, err error) {
	resp = &GetBucketVersioningOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?versioning"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetBucketWebsite is undocumented.
func (c *S3) GetBucketWebsite(req *GetBucketWebsiteRequest) (resp *GetBucketWebsiteOutput, err error) {
	resp = &GetBucketWebsiteOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?website"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetObject is undocumented.
func (c *S3) GetObject(req *GetObjectRequest) (resp *GetObjectOutput, err error) {
	resp = &GetObjectOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.ResponseCacheControl != nil {
		q.Set("response-cache-control", *req.ResponseCacheControl)
	}

	if req.ResponseContentDisposition != nil {
		q.Set("response-content-disposition", *req.ResponseContentDisposition)
	}

	if req.ResponseContentEncoding != nil {
		q.Set("response-content-encoding", *req.ResponseContentEncoding)
	}

	if req.ResponseContentLanguage != nil {
		q.Set("response-content-language", *req.ResponseContentLanguage)
	}

	if req.ResponseContentType != nil {
		q.Set("response-content-type", *req.ResponseContentType)
	}

	if req.ResponseExpires != (time.Time{}) {
		q.Set("response-expires", req.ResponseExpires.Format(time.RFC822))
	}

	if req.VersionID != nil {
		q.Set("versionId", *req.VersionID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.IfMatch != nil {
		httpReq.Header.Set("If-Match", *req.IfMatch)
	}

	if req.IfModifiedSince != (time.Time{}) {
		httpReq.Header.Set("If-Modified-Since", req.IfModifiedSince.Format(time.RFC822))
	}

	if req.IfNoneMatch != nil {
		httpReq.Header.Set("If-None-Match", *req.IfNoneMatch)
	}

	if req.IfUnmodifiedSince != (time.Time{}) {
		httpReq.Header.Set("If-Unmodified-Since", req.IfUnmodifiedSince.Format(time.RFC822))
	}

	if req.Range != nil {
		httpReq.Header.Set("Range", *req.Range)
	}

	if req.SSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-algorithm", *req.SSECustomerAlgorithm)
	}

	if req.SSECustomerKey != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key", *req.SSECustomerKey)
	}

	if req.SSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key-MD5", *req.SSECustomerKeyMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	resp.Body = httpResp.Body

	if s := httpResp.Header.Get("accept-ranges"); s != "" {

		resp.AcceptRanges = &s

	}

	if s := httpResp.Header.Get("Cache-Control"); s != "" {

		resp.CacheControl = &s

	}

	if s := httpResp.Header.Get("Content-Disposition"); s != "" {

		resp.ContentDisposition = &s

	}

	if s := httpResp.Header.Get("Content-Encoding"); s != "" {

		resp.ContentEncoding = &s

	}

	if s := httpResp.Header.Get("Content-Language"); s != "" {

		resp.ContentLanguage = &s

	}

	if s := httpResp.Header.Get("Content-Length"); s != "" {

		var n int64
		n, err = strconv.ParseInt(s, 10, 64)

		if err != nil {
			return
		}
		resp.ContentLength = &n

	}

	if s := httpResp.Header.Get("Content-Type"); s != "" {

		resp.ContentType = &s

	}

	if s := httpResp.Header.Get("x-amz-delete-marker"); s != "" {

		var v bool
		v, err = strconv.ParseBool(s)
		if err != nil {
			return
		}
		resp.DeleteMarker = &v

	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	if s := httpResp.Header.Get("x-amz-expiration"); s != "" {

		resp.Expiration = &s

	}

	if s := httpResp.Header.Get("Expires"); s != "" {

		var t time.Time
		t, err = time.Parse(time.RFC1123, s)
		if err != nil {
			return
		}
		resp.Expires = t

	}

	if s := httpResp.Header.Get("Last-Modified"); s != "" {

		var t time.Time
		t, err = time.Parse(time.RFC1123, s)
		if err != nil {
			return
		}
		resp.LastModified = t

	}

	resp.Metadata = map[string]string{}
	for name := range httpResp.Header {
		if strings.HasPrefix(name, "X-Amz-Meta-") {
			resp.Metadata[name] = httpResp.Header.Get(name)
		}
	}

	if s := httpResp.Header.Get("x-amz-missing-meta"); s != "" {

		var n int
		n, err = strconv.Atoi(s)

		if err != nil {
			return
		}
		resp.MissingMeta = &n

	}

	if s := httpResp.Header.Get("x-amz-restore"); s != "" {

		resp.Restore = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-algorithm"); s != "" {

		resp.SSECustomerAlgorithm = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-key-MD5"); s != "" {

		resp.SSECustomerKeyMD5 = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-aws-kms-key-id"); s != "" {

		resp.SSEKMSKeyID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption"); s != "" {

		resp.ServerSideEncryption = &s

	}

	if s := httpResp.Header.Get("x-amz-version-id"); s != "" {

		resp.VersionID = &s

	}

	if s := httpResp.Header.Get("x-amz-website-redirect-location"); s != "" {

		resp.WebsiteRedirectLocation = &s

	}

	return
}

// GetObjectACL is undocumented.
func (c *S3) GetObjectACL(req *GetObjectACLRequest) (resp *GetObjectACLOutput, err error) {
	resp = &GetObjectACLOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}?acl"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.VersionID != nil {
		q.Set("versionId", *req.VersionID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetObjectTorrent is undocumented.
func (c *S3) GetObjectTorrent(req *GetObjectTorrentRequest) (resp *GetObjectTorrentOutput, err error) {
	resp = &GetObjectTorrentOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}?torrent"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	resp.Body = httpResp.Body

	return
}

// HeadBucket this operation is useful to determine if a bucket exists and
// you have permission to access it.
func (c *S3) HeadBucket(req *HeadBucketRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("HEAD", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// HeadObject the operation retrieves metadata from an object without
// returning the object itself. This operation is useful if you're only
// interested in an object's metadata. To use you must have access to the
// object.
func (c *S3) HeadObject(req *HeadObjectRequest) (resp *HeadObjectOutput, err error) {
	resp = &HeadObjectOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.VersionID != nil {
		q.Set("versionId", *req.VersionID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("HEAD", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.IfMatch != nil {
		httpReq.Header.Set("If-Match", *req.IfMatch)
	}

	if req.IfModifiedSince != (time.Time{}) {
		httpReq.Header.Set("If-Modified-Since", req.IfModifiedSince.Format(time.RFC822))
	}

	if req.IfNoneMatch != nil {
		httpReq.Header.Set("If-None-Match", *req.IfNoneMatch)
	}

	if req.IfUnmodifiedSince != (time.Time{}) {
		httpReq.Header.Set("If-Unmodified-Since", req.IfUnmodifiedSince.Format(time.RFC822))
	}

	if req.Range != nil {
		httpReq.Header.Set("Range", *req.Range)
	}

	if req.SSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-algorithm", *req.SSECustomerAlgorithm)
	}

	if req.SSECustomerKey != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key", *req.SSECustomerKey)
	}

	if req.SSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key-MD5", *req.SSECustomerKeyMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("accept-ranges"); s != "" {

		resp.AcceptRanges = &s

	}

	if s := httpResp.Header.Get("Cache-Control"); s != "" {

		resp.CacheControl = &s

	}

	if s := httpResp.Header.Get("Content-Disposition"); s != "" {

		resp.ContentDisposition = &s

	}

	if s := httpResp.Header.Get("Content-Encoding"); s != "" {

		resp.ContentEncoding = &s

	}

	if s := httpResp.Header.Get("Content-Language"); s != "" {

		resp.ContentLanguage = &s

	}

	if s := httpResp.Header.Get("Content-Length"); s != "" {

		var n int64
		n, err = strconv.ParseInt(s, 10, 64)

		if err != nil {
			return
		}
		resp.ContentLength = &n

	}

	if s := httpResp.Header.Get("Content-Type"); s != "" {

		resp.ContentType = &s

	}

	if s := httpResp.Header.Get("x-amz-delete-marker"); s != "" {

		var v bool
		v, err = strconv.ParseBool(s)
		if err != nil {
			return
		}
		resp.DeleteMarker = &v

	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	if s := httpResp.Header.Get("x-amz-expiration"); s != "" {

		resp.Expiration = &s

	}

	if s := httpResp.Header.Get("Expires"); s != "" {

		var t time.Time
		t, err = time.Parse(time.RFC1123, s)
		if err != nil {
			return
		}
		resp.Expires = t

	}

	if s := httpResp.Header.Get("Last-Modified"); s != "" {

		var t time.Time
		t, err = time.Parse(time.RFC1123, s)
		if err != nil {
			return
		}
		resp.LastModified = t

	}

	resp.Metadata = map[string]string{}
	for name := range httpResp.Header {
		if strings.HasPrefix(name, "X-Amz-Meta-") {
			resp.Metadata[name] = httpResp.Header.Get(name)
		}
	}

	if s := httpResp.Header.Get("x-amz-missing-meta"); s != "" {

		var n int
		n, err = strconv.Atoi(s)

		if err != nil {
			return
		}
		resp.MissingMeta = &n

	}

	if s := httpResp.Header.Get("x-amz-restore"); s != "" {

		resp.Restore = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-algorithm"); s != "" {

		resp.SSECustomerAlgorithm = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-key-MD5"); s != "" {

		resp.SSECustomerKeyMD5 = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-aws-kms-key-id"); s != "" {

		resp.SSEKMSKeyID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption"); s != "" {

		resp.ServerSideEncryption = &s

	}

	if s := httpResp.Header.Get("x-amz-version-id"); s != "" {

		resp.VersionID = &s

	}

	if s := httpResp.Header.Get("x-amz-website-redirect-location"); s != "" {

		resp.WebsiteRedirectLocation = &s

	}

	return
}

// ListBuckets returns a list of all buckets owned by the authenticated
// sender of the request.
func (c *S3) ListBuckets() (resp *ListBucketsOutput, err error) {
	resp = &ListBucketsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListMultipartUploads this operation lists in-progress multipart uploads.
func (c *S3) ListMultipartUploads(req *ListMultipartUploadsRequest) (resp *ListMultipartUploadsOutput, err error) {
	resp = &ListMultipartUploadsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?uploads"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if req.Delimiter != nil {
		q.Set("delimiter", *req.Delimiter)
	}

	if req.EncodingType != nil {
		q.Set("encoding-type", *req.EncodingType)
	}

	if req.KeyMarker != nil {
		q.Set("key-marker", *req.KeyMarker)
	}

	if req.MaxUploads != nil {
		q.Set("max-uploads", strconv.Itoa(*req.MaxUploads))
	}

	if req.Prefix != nil {
		q.Set("prefix", *req.Prefix)
	}

	if req.UploadIDMarker != nil {
		q.Set("upload-id-marker", *req.UploadIDMarker)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListObjectVersions returns metadata about all of the versions of objects
// in a bucket.
func (c *S3) ListObjectVersions(req *ListObjectVersionsRequest) (resp *ListObjectVersionsOutput, err error) {
	resp = &ListObjectVersionsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}?versions"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if req.Delimiter != nil {
		q.Set("delimiter", *req.Delimiter)
	}

	if req.EncodingType != nil {
		q.Set("encoding-type", *req.EncodingType)
	}

	if req.KeyMarker != nil {
		q.Set("key-marker", *req.KeyMarker)
	}

	if req.MaxKeys != nil {
		q.Set("max-keys", strconv.Itoa(*req.MaxKeys))
	}

	if req.Prefix != nil {
		q.Set("prefix", *req.Prefix)
	}

	if req.VersionIDMarker != nil {
		q.Set("version-id-marker", *req.VersionIDMarker)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListObjects returns some or all (up to 1000) of the objects in a bucket.
// You can use the request parameters as selection criteria to return a
// subset of the objects in a bucket.
func (c *S3) ListObjects(req *ListObjectsRequest) (resp *ListObjectsOutput, err error) {
	resp = &ListObjectsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if req.Delimiter != nil {
		q.Set("delimiter", *req.Delimiter)
	}

	if req.EncodingType != nil {
		q.Set("encoding-type", *req.EncodingType)
	}

	if req.Marker != nil {
		q.Set("marker", *req.Marker)
	}

	if req.MaxKeys != nil {
		q.Set("max-keys", strconv.Itoa(*req.MaxKeys))
	}

	if req.Prefix != nil {
		q.Set("prefix", *req.Prefix)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListParts lists the parts that have been uploaded for a specific
// multipart upload.
func (c *S3) ListParts(req *ListPartsRequest) (resp *ListPartsOutput, err error) {
	resp = &ListPartsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.MaxParts != nil {
		q.Set("max-parts", strconv.Itoa(*req.MaxParts))
	}

	if req.PartNumberMarker != nil {
		q.Set("part-number-marker", strconv.Itoa(*req.PartNumberMarker))
	}

	if req.UploadID != nil {
		q.Set("uploadId", *req.UploadID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// PutBucketACL sets the permissions on a bucket using access control lists
func (c *S3) PutBucketACL(req *PutBucketACLRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.AccessControlPolicy != nil {
		req.AccessControlPolicy.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "AccessControlPolicy",
		}
	}

	b, err := xml.Marshal(req.AccessControlPolicy)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?acl"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ACL != nil {
		httpReq.Header.Set("x-amz-acl", *req.ACL)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	if req.GrantFullControl != nil {
		httpReq.Header.Set("x-amz-grant-full-control", *req.GrantFullControl)
	}

	if req.GrantRead != nil {
		httpReq.Header.Set("x-amz-grant-read", *req.GrantRead)
	}

	if req.GrantReadACP != nil {
		httpReq.Header.Set("x-amz-grant-read-acp", *req.GrantReadACP)
	}

	if req.GrantWrite != nil {
		httpReq.Header.Set("x-amz-grant-write", *req.GrantWrite)
	}

	if req.GrantWriteACP != nil {
		httpReq.Header.Set("x-amz-grant-write-acp", *req.GrantWriteACP)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketCORS is undocumented.
func (c *S3) PutBucketCORS(req *PutBucketCORSRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.CORSConfiguration != nil {
		req.CORSConfiguration.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "CORSConfiguration",
		}
	}

	b, err := xml.Marshal(req.CORSConfiguration)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?cors"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketLifecycle sets lifecycle configuration for your bucket. If a
// lifecycle configuration exists, it replaces it.
func (c *S3) PutBucketLifecycle(req *PutBucketLifecycleRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.LifecycleConfiguration != nil {
		req.LifecycleConfiguration.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "LifecycleConfiguration",
		}
	}

	b, err := xml.Marshal(req.LifecycleConfiguration)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?lifecycle"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketLogging set the logging parameters for a bucket and to specify
// permissions for who can view and modify the logging parameters. To set
// the logging status of a bucket, you must be the bucket owner.
func (c *S3) PutBucketLogging(req *PutBucketLoggingRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.BucketLoggingStatus != nil {
		req.BucketLoggingStatus.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "BucketLoggingStatus",
		}
	}

	b, err := xml.Marshal(req.BucketLoggingStatus)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?logging"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketNotification enables notifications of specified events for a
// bucket.
func (c *S3) PutBucketNotification(req *PutBucketNotificationRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.NotificationConfiguration != nil {
		req.NotificationConfiguration.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "NotificationConfiguration",
		}
	}

	b, err := xml.Marshal(req.NotificationConfiguration)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?notification"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketPolicy replaces a policy on a bucket. If the bucket already has
// a policy, the one in this request completely replaces it.
func (c *S3) PutBucketPolicy(req *PutBucketPolicyRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	b, err := xml.Marshal(req.Policy)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?policy"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketRequestPayment sets the request payment configuration for a
// bucket. By default, the bucket owner pays for downloads from the bucket.
// This configuration parameter enables the bucket owner (only) to specify
// that the person requesting the download will be charged for the
// download.
func (c *S3) PutBucketRequestPayment(req *PutBucketRequestPaymentRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.RequestPaymentConfiguration != nil {
		req.RequestPaymentConfiguration.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "RequestPaymentConfiguration",
		}
	}

	b, err := xml.Marshal(req.RequestPaymentConfiguration)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?requestPayment"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketTagging is undocumented.
func (c *S3) PutBucketTagging(req *PutBucketTaggingRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.Tagging != nil {
		req.Tagging.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "Tagging",
		}
	}

	b, err := xml.Marshal(req.Tagging)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?tagging"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketVersioning sets the versioning state of an existing bucket. To
// set the versioning state, you must be the bucket owner.
func (c *S3) PutBucketVersioning(req *PutBucketVersioningRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.VersioningConfiguration != nil {
		req.VersioningConfiguration.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "VersioningConfiguration",
		}
	}

	b, err := xml.Marshal(req.VersioningConfiguration)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?versioning"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	if req.MFA != nil {
		httpReq.Header.Set("x-amz-mfa", *req.MFA)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutBucketWebsite is undocumented.
func (c *S3) PutBucketWebsite(req *PutBucketWebsiteRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.WebsiteConfiguration != nil {
		req.WebsiteConfiguration.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "WebsiteConfiguration",
		}
	}

	b, err := xml.Marshal(req.WebsiteConfiguration)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}?website"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// PutObject is undocumented.
func (c *S3) PutObject(req *PutObjectRequest) (resp *PutObjectOutput, err error) {
	resp = &PutObjectOutput{}

	var body io.Reader
	var contentType string

	body = req.Body

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ACL != nil {
		httpReq.Header.Set("x-amz-acl", *req.ACL)
	}

	if req.CacheControl != nil {
		httpReq.Header.Set("Cache-Control", *req.CacheControl)
	}

	if req.ContentDisposition != nil {
		httpReq.Header.Set("Content-Disposition", *req.ContentDisposition)
	}

	if req.ContentEncoding != nil {
		httpReq.Header.Set("Content-Encoding", *req.ContentEncoding)
	}

	if req.ContentLanguage != nil {
		httpReq.Header.Set("Content-Language", *req.ContentLanguage)
	}

	if req.ContentLength != nil {
		httpReq.ContentLength = *req.ContentLength
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	if req.ContentType != nil {
		httpReq.Header.Set("Content-Type", *req.ContentType)
	}

	if req.Expires != (time.Time{}) {
		httpReq.Header.Set("Expires", req.Expires.Format(time.RFC822))
	}

	if req.GrantFullControl != nil {
		httpReq.Header.Set("x-amz-grant-full-control", *req.GrantFullControl)
	}

	if req.GrantRead != nil {
		httpReq.Header.Set("x-amz-grant-read", *req.GrantRead)
	}

	if req.GrantReadACP != nil {
		httpReq.Header.Set("x-amz-grant-read-acp", *req.GrantReadACP)
	}

	if req.GrantWriteACP != nil {
		httpReq.Header.Set("x-amz-grant-write-acp", *req.GrantWriteACP)
	}

	for name, value := range req.Metadata {
		httpReq.Header.Set(name, value)
	}

	if req.SSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-algorithm", *req.SSECustomerAlgorithm)
	}

	if req.SSECustomerKey != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key", *req.SSECustomerKey)
	}

	if req.SSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key-MD5", *req.SSECustomerKeyMD5)
	}

	if req.SSEKMSKeyID != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-aws-kms-key-id", *req.SSEKMSKeyID)
	}

	if req.ServerSideEncryption != nil {
		httpReq.Header.Set("x-amz-server-side-encryption", *req.ServerSideEncryption)
	}

	if req.StorageClass != nil {
		httpReq.Header.Set("x-amz-storage-class", *req.StorageClass)
	}

	if req.WebsiteRedirectLocation != nil {
		httpReq.Header.Set("x-amz-website-redirect-location", *req.WebsiteRedirectLocation)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	if s := httpResp.Header.Get("x-amz-expiration"); s != "" {

		resp.Expiration = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-algorithm"); s != "" {

		resp.SSECustomerAlgorithm = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-key-MD5"); s != "" {

		resp.SSECustomerKeyMD5 = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-aws-kms-key-id"); s != "" {

		resp.SSEKMSKeyID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption"); s != "" {

		resp.ServerSideEncryption = &s

	}

	if s := httpResp.Header.Get("x-amz-version-id"); s != "" {

		resp.VersionID = &s

	}

	return
}

// PutObjectACL uses the acl subresource to set the access control list
// permissions for an object that already exists in a bucket
func (c *S3) PutObjectACL(req *PutObjectACLRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.AccessControlPolicy != nil {
		req.AccessControlPolicy.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "AccessControlPolicy",
		}
	}

	b, err := xml.Marshal(req.AccessControlPolicy)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}/{Key+}?acl"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ACL != nil {
		httpReq.Header.Set("x-amz-acl", *req.ACL)
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	if req.GrantFullControl != nil {
		httpReq.Header.Set("x-amz-grant-full-control", *req.GrantFullControl)
	}

	if req.GrantRead != nil {
		httpReq.Header.Set("x-amz-grant-read", *req.GrantRead)
	}

	if req.GrantReadACP != nil {
		httpReq.Header.Set("x-amz-grant-read-acp", *req.GrantReadACP)
	}

	if req.GrantWrite != nil {
		httpReq.Header.Set("x-amz-grant-write", *req.GrantWrite)
	}

	if req.GrantWriteACP != nil {
		httpReq.Header.Set("x-amz-grant-write-acp", *req.GrantWriteACP)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// RestoreObject restores an archived copy of an object back into Amazon S3
func (c *S3) RestoreObject(req *RestoreObjectRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.RestoreRequest != nil {
		req.RestoreRequest.XMLName = xml.Name{
			Space: "http://s3.amazonaws.com/doc/2006-03-01/",
			Local: "RestoreRequest",
		}
	}

	b, err := xml.Marshal(req.RestoreRequest)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{Bucket}/{Key+}?restore"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.VersionID != nil {
		q.Set("versionId", *req.VersionID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// UploadPart uploads a part in a multipart upload. Note: After you
// initiate multipart upload and upload one or more parts, you must either
// complete or abort multipart upload in order to stop getting charged for
// storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops
// charging you for the parts storage.
func (c *S3) UploadPart(req *UploadPartRequest) (resp *UploadPartOutput, err error) {
	resp = &UploadPartOutput{}

	var body io.Reader
	var contentType string

	body = req.Body

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.PartNumber != nil {
		q.Set("partNumber", strconv.Itoa(*req.PartNumber))
	}

	if req.UploadID != nil {
		q.Set("uploadId", *req.UploadID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ContentLength != nil {
		httpReq.ContentLength = *req.ContentLength
	}

	if req.ContentMD5 != nil {
		httpReq.Header.Set("Content-MD5", *req.ContentMD5)
	}

	if req.SSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-algorithm", *req.SSECustomerAlgorithm)
	}

	if req.SSECustomerKey != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key", *req.SSECustomerKey)
	}

	if req.SSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key-MD5", *req.SSECustomerKeyMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-algorithm"); s != "" {

		resp.SSECustomerAlgorithm = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-key-MD5"); s != "" {

		resp.SSECustomerKeyMD5 = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-aws-kms-key-id"); s != "" {

		resp.SSEKMSKeyID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption"); s != "" {

		resp.ServerSideEncryption = &s

	}

	return
}

// UploadPartCopy uploads a part by copying data from an existing object as
// data source.
func (c *S3) UploadPartCopy(req *UploadPartCopyRequest) (resp *UploadPartCopyOutput, err error) {
	resp = &UploadPartCopyOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{Bucket}/{Key+}"

	if req.Bucket != nil {
		uri = strings.Replace(uri, "{"+"Bucket"+"}", aws.EscapePath(*req.Bucket), -1)
		uri = strings.Replace(uri, "{"+"Bucket+"+"}", aws.EscapePath(*req.Bucket), -1)
	}

	if req.Key != nil {
		uri = strings.Replace(uri, "{"+"Key"+"}", aws.EscapePath(*req.Key), -1)
		uri = strings.Replace(uri, "{"+"Key+"+"}", aws.EscapePath(*req.Key), -1)
	}

	q := url.Values{}

	if req.PartNumber != nil {
		q.Set("partNumber", strconv.Itoa(*req.PartNumber))
	}

	if req.UploadID != nil {
		q.Set("uploadId", *req.UploadID)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.CopySource != nil {
		httpReq.Header.Set("x-amz-copy-source", *req.CopySource)
	}

	if req.CopySourceIfMatch != nil {
		httpReq.Header.Set("x-amz-copy-source-if-match", *req.CopySourceIfMatch)
	}

	if req.CopySourceIfModifiedSince != (time.Time{}) {
		httpReq.Header.Set("x-amz-copy-source-if-modified-since", req.CopySourceIfModifiedSince.Format(time.RFC822))
	}

	if req.CopySourceIfNoneMatch != nil {
		httpReq.Header.Set("x-amz-copy-source-if-none-match", *req.CopySourceIfNoneMatch)
	}

	if req.CopySourceIfUnmodifiedSince != (time.Time{}) {
		httpReq.Header.Set("x-amz-copy-source-if-unmodified-since", req.CopySourceIfUnmodifiedSince.Format(time.RFC822))
	}

	if req.CopySourceRange != nil {
		httpReq.Header.Set("x-amz-copy-source-range", *req.CopySourceRange)
	}

	if req.CopySourceSSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-copy-source-server-side-encryption-customer-algorithm", *req.CopySourceSSECustomerAlgorithm)
	}

	if req.CopySourceSSECustomerKey != nil {
		httpReq.Header.Set("x-amz-copy-source-server-side-encryption-customer-key", *req.CopySourceSSECustomerKey)
	}

	if req.CopySourceSSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-copy-source-server-side-encryption-customer-key-MD5", *req.CopySourceSSECustomerKeyMD5)
	}

	if req.SSECustomerAlgorithm != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-algorithm", *req.SSECustomerAlgorithm)
	}

	if req.SSECustomerKey != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key", *req.SSECustomerKey)
	}

	if req.SSECustomerKeyMD5 != nil {
		httpReq.Header.Set("x-amz-server-side-encryption-customer-key-MD5", *req.SSECustomerKeyMD5)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-copy-source-version-id"); s != "" {

		resp.CopySourceVersionID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-algorithm"); s != "" {

		resp.SSECustomerAlgorithm = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-customer-key-MD5"); s != "" {

		resp.SSECustomerKeyMD5 = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption-aws-kms-key-id"); s != "" {

		resp.SSEKMSKeyID = &s

	}

	if s := httpResp.Header.Get("x-amz-server-side-encryption"); s != "" {

		resp.ServerSideEncryption = &s

	}

	return
}

// AbortMultipartUploadRequest is undocumented.
type AbortMultipartUploadRequest struct {
	XMLName xml.Name

	Bucket   aws.StringValue `xml:"-"`
	Key      aws.StringValue `xml:"-"`
	UploadID aws.StringValue `xml:"-"`
}

func (v *AbortMultipartUploadRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// AccessControlPolicy is undocumented.
type AccessControlPolicy struct {
	XMLName xml.Name

	Grants []Grant `xml:"AccessControlList>Grant,omitempty"`
	Owner  *Owner  `xml:"Owner,omitempty"`
}

func (v *AccessControlPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Bucket is undocumented.
type Bucket struct {
	XMLName xml.Name

	CreationDate time.Time       `xml:"CreationDate"`
	Name         aws.StringValue `xml:"Name"`
}

func (v *Bucket) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	BucketCannedACLAuthenticatedRead = "authenticated-read"
	BucketCannedACLPrivate           = "private"
	BucketCannedACLPublicRead        = "public-read"
	BucketCannedACLPublicReadWrite   = "public-read-write"
)

// Possible values for S3.
const (
	BucketLocationConstraintApNortheast1 = "ap-northeast-1"
	BucketLocationConstraintApSoutheast1 = "ap-southeast-1"
	BucketLocationConstraintApSoutheast2 = "ap-southeast-2"
	BucketLocationConstraintCnNorth1     = "cn-north-1"
	BucketLocationConstraintEu           = "EU"
	BucketLocationConstraintEuCentral1   = "eu-central-1"
	BucketLocationConstraintEuWest1      = "eu-west-1"
	BucketLocationConstraintSaEast1      = "sa-east-1"
	BucketLocationConstraintUsWest1      = "us-west-1"
	BucketLocationConstraintUsWest2      = "us-west-2"
)

// BucketLoggingStatus is undocumented.
type BucketLoggingStatus struct {
	XMLName xml.Name

	LoggingEnabled *LoggingEnabled `xml:"LoggingEnabled,omitempty"`
}

func (v *BucketLoggingStatus) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	BucketLogsPermissionFullControl = "FULL_CONTROL"
	BucketLogsPermissionRead        = "READ"
	BucketLogsPermissionWrite       = "WRITE"
)

// Possible values for S3.
const (
	BucketVersioningStatusEnabled   = "Enabled"
	BucketVersioningStatusSuspended = "Suspended"
)

// CORSConfiguration is undocumented.
type CORSConfiguration struct {
	XMLName xml.Name

	CORSRules []CORSRule `xml:"CORSRule,omitempty"`
}

func (v *CORSConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CORSRule is undocumented.
type CORSRule struct {
	XMLName xml.Name

	AllowedHeaders []string         `xml:"AllowedHeader,omitempty"`
	AllowedMethods []string         `xml:"AllowedMethod,omitempty"`
	AllowedOrigins []string         `xml:"AllowedOrigin,omitempty"`
	ExposeHeaders  []string         `xml:"ExposeHeader,omitempty"`
	MaxAgeSeconds  aws.IntegerValue `xml:"MaxAgeSeconds"`
}

func (v *CORSRule) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CloudFunctionConfiguration is undocumented.
type CloudFunctionConfiguration struct {
	XMLName xml.Name

	CloudFunction  aws.StringValue `xml:"CloudFunction"`
	Event          aws.StringValue `xml:"Event"`
	Events         []string        `xml:"Event,omitempty"`
	ID             aws.StringValue `xml:"Id"`
	InvocationRole aws.StringValue `xml:"InvocationRole"`
}

func (v *CloudFunctionConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CommonPrefix is undocumented.
type CommonPrefix struct {
	XMLName xml.Name

	Prefix aws.StringValue `xml:"Prefix"`
}

func (v *CommonPrefix) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CompleteMultipartUploadOutput is undocumented.
type CompleteMultipartUploadOutput struct {
	XMLName xml.Name

	Bucket               aws.StringValue `xml:"Bucket"`
	ETag                 aws.StringValue `xml:"ETag"`
	Expiration           aws.StringValue `xml:"-"`
	Key                  aws.StringValue `xml:"Key"`
	Location             aws.StringValue `xml:"Location"`
	SSEKMSKeyID          aws.StringValue `xml:"-"`
	ServerSideEncryption aws.StringValue `xml:"-"`
	VersionID            aws.StringValue `xml:"-"`
}

func (v *CompleteMultipartUploadOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CompleteMultipartUploadRequest is undocumented.
type CompleteMultipartUploadRequest struct {
	XMLName xml.Name

	Bucket          aws.StringValue           `xml:"-"`
	Key             aws.StringValue           `xml:"-"`
	MultipartUpload *CompletedMultipartUpload `xml:"CompleteMultipartUpload,omitempty"`
	UploadID        aws.StringValue           `xml:"-"`
}

func (v *CompleteMultipartUploadRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CompletedMultipartUpload is undocumented.
type CompletedMultipartUpload struct {
	XMLName xml.Name

	Parts []CompletedPart `xml:"Part,omitempty"`
}

func (v *CompletedMultipartUpload) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CompletedPart is undocumented.
type CompletedPart struct {
	XMLName xml.Name

	ETag       aws.StringValue  `xml:"ETag"`
	PartNumber aws.IntegerValue `xml:"PartNumber"`
}

func (v *CompletedPart) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Condition is undocumented.
type Condition struct {
	XMLName xml.Name

	HTTPErrorCodeReturnedEquals aws.StringValue `xml:"HttpErrorCodeReturnedEquals"`
	KeyPrefixEquals             aws.StringValue `xml:"KeyPrefixEquals"`
}

func (v *Condition) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CopyObjectOutput is undocumented.
type CopyObjectOutput struct {
	XMLName xml.Name

	CopyObjectResult     *CopyObjectResult `xml:"CopyObjectResult,omitempty"`
	CopySourceVersionID  aws.StringValue   `xml:"-"`
	Expiration           aws.StringValue   `xml:"-"`
	SSECustomerAlgorithm aws.StringValue   `xml:"-"`
	SSECustomerKeyMD5    aws.StringValue   `xml:"-"`
	SSEKMSKeyID          aws.StringValue   `xml:"-"`
	ServerSideEncryption aws.StringValue   `xml:"-"`
}

func (v *CopyObjectOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CopyObjectRequest is undocumented.
type CopyObjectRequest struct {
	XMLName xml.Name

	ACL                            aws.StringValue   `xml:"-"`
	Bucket                         aws.StringValue   `xml:"-"`
	CacheControl                   aws.StringValue   `xml:"-"`
	ContentDisposition             aws.StringValue   `xml:"-"`
	ContentEncoding                aws.StringValue   `xml:"-"`
	ContentLanguage                aws.StringValue   `xml:"-"`
	ContentType                    aws.StringValue   `xml:"-"`
	CopySource                     aws.StringValue   `xml:"-"`
	CopySourceIfMatch              aws.StringValue   `xml:"-"`
	CopySourceIfModifiedSince      time.Time         `xml:"-"`
	CopySourceIfNoneMatch          aws.StringValue   `xml:"-"`
	CopySourceIfUnmodifiedSince    time.Time         `xml:"-"`
	CopySourceSSECustomerAlgorithm aws.StringValue   `xml:"-"`
	CopySourceSSECustomerKey       aws.StringValue   `xml:"-"`
	CopySourceSSECustomerKeyMD5    aws.StringValue   `xml:"-"`
	Expires                        time.Time         `xml:"-"`
	GrantFullControl               aws.StringValue   `xml:"-"`
	GrantRead                      aws.StringValue   `xml:"-"`
	GrantReadACP                   aws.StringValue   `xml:"-"`
	GrantWriteACP                  aws.StringValue   `xml:"-"`
	Key                            aws.StringValue   `xml:"-"`
	Metadata                       map[string]string `xml:"-"`
	MetadataDirective              aws.StringValue   `xml:"-"`
	SSECustomerAlgorithm           aws.StringValue   `xml:"-"`
	SSECustomerKey                 aws.StringValue   `xml:"-"`
	SSECustomerKeyMD5              aws.StringValue   `xml:"-"`
	SSEKMSKeyID                    aws.StringValue   `xml:"-"`
	ServerSideEncryption           aws.StringValue   `xml:"-"`
	StorageClass                   aws.StringValue   `xml:"-"`
	WebsiteRedirectLocation        aws.StringValue   `xml:"-"`
}

func (v *CopyObjectRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CopyObjectResult is undocumented.
type CopyObjectResult struct {
	XMLName xml.Name

	ETag         aws.StringValue `xml:"ETag"`
	LastModified time.Time       `xml:"LastModified"`
}

func (v *CopyObjectResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CopyPartResult is undocumented.
type CopyPartResult struct {
	XMLName xml.Name

	ETag         aws.StringValue `xml:"ETag"`
	LastModified time.Time       `xml:"LastModified"`
}

func (v *CopyPartResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateBucketConfiguration is undocumented.
type CreateBucketConfiguration struct {
	XMLName xml.Name

	LocationConstraint aws.StringValue `xml:"LocationConstraint"`
}

func (v *CreateBucketConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateBucketOutput is undocumented.
type CreateBucketOutput struct {
	XMLName xml.Name

	Location aws.StringValue `xml:"-"`
}

func (v *CreateBucketOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateBucketRequest is undocumented.
type CreateBucketRequest struct {
	XMLName xml.Name

	ACL                       aws.StringValue            `xml:"-"`
	Bucket                    aws.StringValue            `xml:"-"`
	CreateBucketConfiguration *CreateBucketConfiguration `xml:"CreateBucketConfiguration,omitempty"`
	GrantFullControl          aws.StringValue            `xml:"-"`
	GrantRead                 aws.StringValue            `xml:"-"`
	GrantReadACP              aws.StringValue            `xml:"-"`
	GrantWrite                aws.StringValue            `xml:"-"`
	GrantWriteACP             aws.StringValue            `xml:"-"`
}

func (v *CreateBucketRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateMultipartUploadOutput is undocumented.
type CreateMultipartUploadOutput struct {
	XMLName xml.Name

	Bucket               aws.StringValue `xml:"Bucket"`
	Key                  aws.StringValue `xml:"Key"`
	SSECustomerAlgorithm aws.StringValue `xml:"-"`
	SSECustomerKeyMD5    aws.StringValue `xml:"-"`
	SSEKMSKeyID          aws.StringValue `xml:"-"`
	ServerSideEncryption aws.StringValue `xml:"-"`
	UploadID             aws.StringValue `xml:"UploadId"`
}

func (v *CreateMultipartUploadOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateMultipartUploadRequest is undocumented.
type CreateMultipartUploadRequest struct {
	XMLName xml.Name

	ACL                     aws.StringValue   `xml:"-"`
	Bucket                  aws.StringValue   `xml:"-"`
	CacheControl            aws.StringValue   `xml:"-"`
	ContentDisposition      aws.StringValue   `xml:"-"`
	ContentEncoding         aws.StringValue   `xml:"-"`
	ContentLanguage         aws.StringValue   `xml:"-"`
	ContentType             aws.StringValue   `xml:"-"`
	Expires                 time.Time         `xml:"-"`
	GrantFullControl        aws.StringValue   `xml:"-"`
	GrantRead               aws.StringValue   `xml:"-"`
	GrantReadACP            aws.StringValue   `xml:"-"`
	GrantWriteACP           aws.StringValue   `xml:"-"`
	Key                     aws.StringValue   `xml:"-"`
	Metadata                map[string]string `xml:"-"`
	SSECustomerAlgorithm    aws.StringValue   `xml:"-"`
	SSECustomerKey          aws.StringValue   `xml:"-"`
	SSECustomerKeyMD5       aws.StringValue   `xml:"-"`
	SSEKMSKeyID             aws.StringValue   `xml:"-"`
	ServerSideEncryption    aws.StringValue   `xml:"-"`
	StorageClass            aws.StringValue   `xml:"-"`
	WebsiteRedirectLocation aws.StringValue   `xml:"-"`
}

func (v *CreateMultipartUploadRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Delete is undocumented.
type Delete struct {
	XMLName xml.Name

	Objects []ObjectIdentifier `xml:"Object,omitempty"`
	Quiet   aws.BooleanValue   `xml:"Quiet"`
}

func (v *Delete) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteBucketCORSRequest is undocumented.
type DeleteBucketCORSRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *DeleteBucketCORSRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteBucketLifecycleRequest is undocumented.
type DeleteBucketLifecycleRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *DeleteBucketLifecycleRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteBucketPolicyRequest is undocumented.
type DeleteBucketPolicyRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *DeleteBucketPolicyRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteBucketRequest is undocumented.
type DeleteBucketRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *DeleteBucketRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteBucketTaggingRequest is undocumented.
type DeleteBucketTaggingRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *DeleteBucketTaggingRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteBucketWebsiteRequest is undocumented.
type DeleteBucketWebsiteRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *DeleteBucketWebsiteRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteMarkerEntry is undocumented.
type DeleteMarkerEntry struct {
	XMLName xml.Name

	IsLatest     aws.BooleanValue `xml:"IsLatest"`
	Key          aws.StringValue  `xml:"Key"`
	LastModified time.Time        `xml:"LastModified"`
	Owner        *Owner           `xml:"Owner,omitempty"`
	VersionID    aws.StringValue  `xml:"VersionId"`
}

func (v *DeleteMarkerEntry) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteObjectOutput is undocumented.
type DeleteObjectOutput struct {
	XMLName xml.Name

	DeleteMarker aws.BooleanValue `xml:"-"`
	VersionID    aws.StringValue  `xml:"-"`
}

func (v *DeleteObjectOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteObjectRequest is undocumented.
type DeleteObjectRequest struct {
	XMLName xml.Name

	Bucket    aws.StringValue `xml:"-"`
	Key       aws.StringValue `xml:"-"`
	MFA       aws.StringValue `xml:"-"`
	VersionID aws.StringValue `xml:"-"`
}

func (v *DeleteObjectRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteObjectsOutput is undocumented.
type DeleteObjectsOutput struct {
	XMLName xml.Name

	Deleted []DeletedObject `xml:"Deleted,omitempty"`
	Errors  []Error         `xml:"Error,omitempty"`
}

func (v *DeleteObjectsOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteObjectsRequest is undocumented.
type DeleteObjectsRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
	Delete *Delete         `xml:"Delete,omitempty"`
	MFA    aws.StringValue `xml:"-"`
}

func (v *DeleteObjectsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeletedObject is undocumented.
type DeletedObject struct {
	XMLName xml.Name

	DeleteMarker          aws.BooleanValue `xml:"DeleteMarker"`
	DeleteMarkerVersionID aws.StringValue  `xml:"DeleteMarkerVersionId"`
	Key                   aws.StringValue  `xml:"Key"`
	VersionID             aws.StringValue  `xml:"VersionId"`
}

func (v *DeletedObject) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	EncodingTypeURL = "url"
)

// Error is undocumented.
type Error struct {
	XMLName xml.Name

	Code      aws.StringValue `xml:"Code"`
	Key       aws.StringValue `xml:"Key"`
	Message   aws.StringValue `xml:"Message"`
	VersionID aws.StringValue `xml:"VersionId"`
}

func (v *Error) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ErrorDocument is undocumented.
type ErrorDocument struct {
	XMLName xml.Name

	Key aws.StringValue `xml:"Key"`
}

func (v *ErrorDocument) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	EventS3ObjectCreatedCompleteMultipartUpload = "s3:ObjectCreated:CompleteMultipartUpload"
	EventS3ObjectCreatedCopy                    = "s3:ObjectCreated:Copy"
	EventS3ObjectCreatedPost                    = "s3:ObjectCreated:Post"
	EventS3ObjectCreatedPut                     = "s3:ObjectCreated:Put"
	EventS3ReducedRedundancyLostObject          = "s3:ReducedRedundancyLostObject"
)

// Possible values for S3.
const (
	ExpirationStatusDisabled = "Disabled"
	ExpirationStatusEnabled  = "Enabled"
)

// GetBucketACLOutput is undocumented.
type GetBucketACLOutput struct {
	XMLName xml.Name

	Grants []Grant `xml:"AccessControlList>Grant,omitempty"`
	Owner  *Owner  `xml:"Owner,omitempty"`
}

func (v *GetBucketACLOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketACLRequest is undocumented.
type GetBucketACLRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketACLRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketCORSOutput is undocumented.
type GetBucketCORSOutput struct {
	XMLName xml.Name

	CORSRules []CORSRule `xml:"CORSRule,omitempty"`
}

func (v *GetBucketCORSOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketCORSRequest is undocumented.
type GetBucketCORSRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketCORSRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketLifecycleOutput is undocumented.
type GetBucketLifecycleOutput struct {
	XMLName xml.Name

	Rules []Rule `xml:"Rule,omitempty"`
}

func (v *GetBucketLifecycleOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketLifecycleRequest is undocumented.
type GetBucketLifecycleRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketLifecycleRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketLocationOutput is undocumented.
type GetBucketLocationOutput struct {
	XMLName xml.Name

	LocationConstraint aws.StringValue `xml:"LocationConstraint"`
}

func (v *GetBucketLocationOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketLocationRequest is undocumented.
type GetBucketLocationRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketLocationRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketLoggingOutput is undocumented.
type GetBucketLoggingOutput struct {
	XMLName xml.Name

	LoggingEnabled *LoggingEnabled `xml:"LoggingEnabled,omitempty"`
}

func (v *GetBucketLoggingOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketLoggingRequest is undocumented.
type GetBucketLoggingRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketLoggingRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketNotificationOutput is undocumented.
type GetBucketNotificationOutput struct {
	XMLName xml.Name

	CloudFunctionConfiguration *CloudFunctionConfiguration `xml:"CloudFunctionConfiguration,omitempty"`
	QueueConfiguration         *QueueConfiguration         `xml:"QueueConfiguration,omitempty"`
	TopicConfiguration         *TopicConfiguration         `xml:"TopicConfiguration,omitempty"`
}

func (v *GetBucketNotificationOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketNotificationRequest is undocumented.
type GetBucketNotificationRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketNotificationRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketPolicyOutput is undocumented.
type GetBucketPolicyOutput struct {
	XMLName xml.Name

	Policy aws.StringValue `xml:"Policy"`
}

func (v *GetBucketPolicyOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketPolicyRequest is undocumented.
type GetBucketPolicyRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketPolicyRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketRequestPaymentOutput is undocumented.
type GetBucketRequestPaymentOutput struct {
	XMLName xml.Name

	Payer aws.StringValue `xml:"Payer"`
}

func (v *GetBucketRequestPaymentOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketRequestPaymentRequest is undocumented.
type GetBucketRequestPaymentRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketRequestPaymentRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketTaggingOutput is undocumented.
type GetBucketTaggingOutput struct {
	XMLName xml.Name

	TagSet []Tag `xml:"TagSet>Tag,omitempty"`
}

func (v *GetBucketTaggingOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketTaggingRequest is undocumented.
type GetBucketTaggingRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketTaggingRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketVersioningOutput is undocumented.
type GetBucketVersioningOutput struct {
	XMLName xml.Name

	MFADelete aws.StringValue `xml:"MfaDelete"`
	Status    aws.StringValue `xml:"Status"`
}

func (v *GetBucketVersioningOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketVersioningRequest is undocumented.
type GetBucketVersioningRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketVersioningRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketWebsiteOutput is undocumented.
type GetBucketWebsiteOutput struct {
	XMLName xml.Name

	ErrorDocument         *ErrorDocument         `xml:"ErrorDocument,omitempty"`
	IndexDocument         *IndexDocument         `xml:"IndexDocument,omitempty"`
	RedirectAllRequestsTo *RedirectAllRequestsTo `xml:"RedirectAllRequestsTo,omitempty"`
	RoutingRules          []RoutingRule          `xml:"RoutingRules>RoutingRule,omitempty"`
}

func (v *GetBucketWebsiteOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetBucketWebsiteRequest is undocumented.
type GetBucketWebsiteRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *GetBucketWebsiteRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetObjectACLOutput is undocumented.
type GetObjectACLOutput struct {
	XMLName xml.Name

	Grants []Grant `xml:"AccessControlList>Grant,omitempty"`
	Owner  *Owner  `xml:"Owner,omitempty"`
}

func (v *GetObjectACLOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetObjectACLRequest is undocumented.
type GetObjectACLRequest struct {
	XMLName xml.Name

	Bucket    aws.StringValue `xml:"-"`
	Key       aws.StringValue `xml:"-"`
	VersionID aws.StringValue `xml:"-"`
}

func (v *GetObjectACLRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetObjectOutput is undocumented.
type GetObjectOutput struct {
	XMLName xml.Name

	AcceptRanges            aws.StringValue   `xml:"-"`
	Body                    io.ReadCloser     `xml:"-"`
	CacheControl            aws.StringValue   `xml:"-"`
	ContentDisposition      aws.StringValue   `xml:"-"`
	ContentEncoding         aws.StringValue   `xml:"-"`
	ContentLanguage         aws.StringValue   `xml:"-"`
	ContentLength           aws.LongValue     `xml:"-"`
	ContentType             aws.StringValue   `xml:"-"`
	DeleteMarker            aws.BooleanValue  `xml:"-"`
	ETag                    aws.StringValue   `xml:"-"`
	Expiration              aws.StringValue   `xml:"-"`
	Expires                 time.Time         `xml:"-"`
	LastModified            time.Time         `xml:"-"`
	Metadata                map[string]string `xml:"-"`
	MissingMeta             aws.IntegerValue  `xml:"-"`
	Restore                 aws.StringValue   `xml:"-"`
	SSECustomerAlgorithm    aws.StringValue   `xml:"-"`
	SSECustomerKeyMD5       aws.StringValue   `xml:"-"`
	SSEKMSKeyID             aws.StringValue   `xml:"-"`
	ServerSideEncryption    aws.StringValue   `xml:"-"`
	VersionID               aws.StringValue   `xml:"-"`
	WebsiteRedirectLocation aws.StringValue   `xml:"-"`
}

func (v *GetObjectOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetObjectRequest is undocumented.
type GetObjectRequest struct {
	XMLName xml.Name

	Bucket                     aws.StringValue `xml:"-"`
	IfMatch                    aws.StringValue `xml:"-"`
	IfModifiedSince            time.Time       `xml:"-"`
	IfNoneMatch                aws.StringValue `xml:"-"`
	IfUnmodifiedSince          time.Time       `xml:"-"`
	Key                        aws.StringValue `xml:"-"`
	Range                      aws.StringValue `xml:"-"`
	ResponseCacheControl       aws.StringValue `xml:"-"`
	ResponseContentDisposition aws.StringValue `xml:"-"`
	ResponseContentEncoding    aws.StringValue `xml:"-"`
	ResponseContentLanguage    aws.StringValue `xml:"-"`
	ResponseContentType        aws.StringValue `xml:"-"`
	ResponseExpires            time.Time       `xml:"-"`
	SSECustomerAlgorithm       aws.StringValue `xml:"-"`
	SSECustomerKey             aws.StringValue `xml:"-"`
	SSECustomerKeyMD5          aws.StringValue `xml:"-"`
	VersionID                  aws.StringValue `xml:"-"`
}

func (v *GetObjectRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetObjectTorrentOutput is undocumented.
type GetObjectTorrentOutput struct {
	XMLName xml.Name

	Body io.ReadCloser `xml:"-"`
}

func (v *GetObjectTorrentOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetObjectTorrentRequest is undocumented.
type GetObjectTorrentRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
	Key    aws.StringValue `xml:"-"`
}

func (v *GetObjectTorrentRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Grant is undocumented.
type Grant struct {
	XMLName xml.Name

	Grantee    *Grantee        `xml:"Grantee,omitempty"`
	Permission aws.StringValue `xml:"Permission"`
}

func (v *Grant) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Grantee is undocumented.
type Grantee struct {
	XMLName xml.Name

	DisplayName  aws.StringValue `xml:"DisplayName"`
	EmailAddress aws.StringValue `xml:"EmailAddress"`
	ID           aws.StringValue `xml:"ID"`
	Type         aws.StringValue `xml:"Type"`
	URI          aws.StringValue `xml:"URI"`
}

func (v *Grantee) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// HeadBucketRequest is undocumented.
type HeadBucketRequest struct {
	XMLName xml.Name

	Bucket aws.StringValue `xml:"-"`
}

func (v *HeadBucketRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// HeadObjectOutput is undocumented.
type HeadObjectOutput struct {
	XMLName xml.Name

	AcceptRanges            aws.StringValue   `xml:"-"`
	CacheControl            aws.StringValue   `xml:"-"`
	ContentDisposition      aws.StringValue   `xml:"-"`
	ContentEncoding         aws.StringValue   `xml:"-"`
	ContentLanguage         aws.StringValue   `xml:"-"`
	ContentLength           aws.LongValue     `xml:"-"`
	ContentType             aws.StringValue   `xml:"-"`
	DeleteMarker            aws.BooleanValue  `xml:"-"`
	ETag                    aws.StringValue   `xml:"-"`
	Expiration              aws.StringValue   `xml:"-"`
	Expires                 time.Time         `xml:"-"`
	LastModified            time.Time         `xml:"-"`
	Metadata                map[string]string `xml:"-"`
	MissingMeta             aws.IntegerValue  `xml:"-"`
	Restore                 aws.StringValue   `xml:"-"`
	SSECustomerAlgorithm    aws.StringValue   `xml:"-"`
	SSECustomerKeyMD5       aws.StringValue   `xml:"-"`
	SSEKMSKeyID             aws.StringValue   `xml:"-"`
	ServerSideEncryption    aws.StringValue   `xml:"-"`
	VersionID               aws.StringValue   `xml:"-"`
	WebsiteRedirectLocation aws.StringValue   `xml:"-"`
}

func (v *HeadObjectOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// HeadObjectRequest is undocumented.
type HeadObjectRequest struct {
	XMLName xml.Name

	Bucket               aws.StringValue `xml:"-"`
	IfMatch              aws.StringValue `xml:"-"`
	IfModifiedSince      time.Time       `xml:"-"`
	IfNoneMatch          aws.StringValue `xml:"-"`
	IfUnmodifiedSince    time.Time       `xml:"-"`
	Key                  aws.StringValue `xml:"-"`
	Range                aws.StringValue `xml:"-"`
	SSECustomerAlgorithm aws.StringValue `xml:"-"`
	SSECustomerKey       aws.StringValue `xml:"-"`
	SSECustomerKeyMD5    aws.StringValue `xml:"-"`
	VersionID            aws.StringValue `xml:"-"`
}

func (v *HeadObjectRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// IndexDocument is undocumented.
type IndexDocument struct {
	XMLName xml.Name

	Suffix aws.StringValue `xml:"Suffix"`
}

func (v *IndexDocument) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Initiator is undocumented.
type Initiator struct {
	XMLName xml.Name

	DisplayName aws.StringValue `xml:"DisplayName"`
	ID          aws.StringValue `xml:"ID"`
}

func (v *Initiator) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// LifecycleConfiguration is undocumented.
type LifecycleConfiguration struct {
	XMLName xml.Name

	Rules []Rule `xml:"Rule,omitempty"`
}

func (v *LifecycleConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// LifecycleExpiration is undocumented.
type LifecycleExpiration struct {
	XMLName xml.Name

	Date time.Time        `xml:"Date"`
	Days aws.IntegerValue `xml:"Days"`
}

func (v *LifecycleExpiration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListBucketsOutput is undocumented.
type ListBucketsOutput struct {
	XMLName xml.Name

	Buckets []Bucket `xml:"Buckets>Bucket,omitempty"`
	Owner   *Owner   `xml:"Owner,omitempty"`
}

func (v *ListBucketsOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListMultipartUploadsOutput is undocumented.
type ListMultipartUploadsOutput struct {
	XMLName xml.Name

	Bucket             aws.StringValue   `xml:"Bucket"`
	CommonPrefixes     []CommonPrefix    `xml:"CommonPrefixes,omitempty"`
	Delimiter          aws.StringValue   `xml:"Delimiter"`
	EncodingType       aws.StringValue   `xml:"EncodingType"`
	IsTruncated        aws.BooleanValue  `xml:"IsTruncated"`
	KeyMarker          aws.StringValue   `xml:"KeyMarker"`
	MaxUploads         aws.IntegerValue  `xml:"MaxUploads"`
	NextKeyMarker      aws.StringValue   `xml:"NextKeyMarker"`
	NextUploadIDMarker aws.StringValue   `xml:"NextUploadIdMarker"`
	Prefix             aws.StringValue   `xml:"Prefix"`
	UploadIDMarker     aws.StringValue   `xml:"UploadIdMarker"`
	Uploads            []MultipartUpload `xml:"Upload,omitempty"`
}

func (v *ListMultipartUploadsOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListMultipartUploadsRequest is undocumented.
type ListMultipartUploadsRequest struct {
	XMLName xml.Name

	Bucket         aws.StringValue  `xml:"-"`
	Delimiter      aws.StringValue  `xml:"-"`
	EncodingType   aws.StringValue  `xml:"-"`
	KeyMarker      aws.StringValue  `xml:"-"`
	MaxUploads     aws.IntegerValue `xml:"-"`
	Prefix         aws.StringValue  `xml:"-"`
	UploadIDMarker aws.StringValue  `xml:"-"`
}

func (v *ListMultipartUploadsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListObjectVersionsOutput is undocumented.
type ListObjectVersionsOutput struct {
	XMLName xml.Name

	CommonPrefixes      []CommonPrefix      `xml:"CommonPrefixes,omitempty"`
	DeleteMarkers       []DeleteMarkerEntry `xml:"DeleteMarker,omitempty"`
	Delimiter           aws.StringValue     `xml:"Delimiter"`
	EncodingType        aws.StringValue     `xml:"EncodingType"`
	IsTruncated         aws.BooleanValue    `xml:"IsTruncated"`
	KeyMarker           aws.StringValue     `xml:"KeyMarker"`
	MaxKeys             aws.IntegerValue    `xml:"MaxKeys"`
	Name                aws.StringValue     `xml:"Name"`
	NextKeyMarker       aws.StringValue     `xml:"NextKeyMarker"`
	NextVersionIDMarker aws.StringValue     `xml:"NextVersionIdMarker"`
	Prefix              aws.StringValue     `xml:"Prefix"`
	VersionIDMarker     aws.StringValue     `xml:"VersionIdMarker"`
	Versions            []ObjectVersion     `xml:"Version,omitempty"`
}

func (v *ListObjectVersionsOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListObjectVersionsRequest is undocumented.
type ListObjectVersionsRequest struct {
	XMLName xml.Name

	Bucket          aws.StringValue  `xml:"-"`
	Delimiter       aws.StringValue  `xml:"-"`
	EncodingType    aws.StringValue  `xml:"-"`
	KeyMarker       aws.StringValue  `xml:"-"`
	MaxKeys         aws.IntegerValue `xml:"-"`
	Prefix          aws.StringValue  `xml:"-"`
	VersionIDMarker aws.StringValue  `xml:"-"`
}

func (v *ListObjectVersionsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListObjectsOutput is undocumented.
type ListObjectsOutput struct {
	XMLName xml.Name

	CommonPrefixes []CommonPrefix   `xml:"CommonPrefixes,omitempty"`
	Contents       []Object         `xml:"Contents,omitempty"`
	Delimiter      aws.StringValue  `xml:"Delimiter"`
	EncodingType   aws.StringValue  `xml:"EncodingType"`
	IsTruncated    aws.BooleanValue `xml:"IsTruncated"`
	Marker         aws.StringValue  `xml:"Marker"`
	MaxKeys        aws.IntegerValue `xml:"MaxKeys"`
	Name           aws.StringValue  `xml:"Name"`
	NextMarker     aws.StringValue  `xml:"NextMarker"`
	Prefix         aws.StringValue  `xml:"Prefix"`
}

func (v *ListObjectsOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListObjectsRequest is undocumented.
type ListObjectsRequest struct {
	XMLName xml.Name

	Bucket       aws.StringValue  `xml:"-"`
	Delimiter    aws.StringValue  `xml:"-"`
	EncodingType aws.StringValue  `xml:"-"`
	Marker       aws.StringValue  `xml:"-"`
	MaxKeys      aws.IntegerValue `xml:"-"`
	Prefix       aws.StringValue  `xml:"-"`
}

func (v *ListObjectsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListPartsOutput is undocumented.
type ListPartsOutput struct {
	XMLName xml.Name

	Bucket               aws.StringValue  `xml:"Bucket"`
	Initiator            *Initiator       `xml:"Initiator,omitempty"`
	IsTruncated          aws.BooleanValue `xml:"IsTruncated"`
	Key                  aws.StringValue  `xml:"Key"`
	MaxParts             aws.IntegerValue `xml:"MaxParts"`
	NextPartNumberMarker aws.IntegerValue `xml:"NextPartNumberMarker"`
	Owner                *Owner           `xml:"Owner,omitempty"`
	PartNumberMarker     aws.IntegerValue `xml:"PartNumberMarker"`
	Parts                []Part           `xml:"Part,omitempty"`
	StorageClass         aws.StringValue  `xml:"StorageClass"`
	UploadID             aws.StringValue  `xml:"UploadId"`
}

func (v *ListPartsOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListPartsRequest is undocumented.
type ListPartsRequest struct {
	XMLName xml.Name

	Bucket           aws.StringValue  `xml:"-"`
	Key              aws.StringValue  `xml:"-"`
	MaxParts         aws.IntegerValue `xml:"-"`
	PartNumberMarker aws.IntegerValue `xml:"-"`
	UploadID         aws.StringValue  `xml:"-"`
}

func (v *ListPartsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// LoggingEnabled is undocumented.
type LoggingEnabled struct {
	XMLName xml.Name

	TargetBucket aws.StringValue `xml:"TargetBucket"`
	TargetGrants []TargetGrant   `xml:"TargetGrants>Grant,omitempty"`
	TargetPrefix aws.StringValue `xml:"TargetPrefix"`
}

func (v *LoggingEnabled) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	MFADeleteDisabled = "Disabled"
	MFADeleteEnabled  = "Enabled"
)

// Possible values for S3.
const (
	MFADeleteStatusDisabled = "Disabled"
	MFADeleteStatusEnabled  = "Enabled"
)

// Possible values for S3.
const (
	MetadataDirectiveCopy    = "COPY"
	MetadataDirectiveReplace = "REPLACE"
)

// MultipartUpload is undocumented.
type MultipartUpload struct {
	XMLName xml.Name

	Initiated    time.Time       `xml:"Initiated"`
	Initiator    *Initiator      `xml:"Initiator,omitempty"`
	Key          aws.StringValue `xml:"Key"`
	Owner        *Owner          `xml:"Owner,omitempty"`
	StorageClass aws.StringValue `xml:"StorageClass"`
	UploadID     aws.StringValue `xml:"UploadId"`
}

func (v *MultipartUpload) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// NoncurrentVersionExpiration is undocumented.
type NoncurrentVersionExpiration struct {
	XMLName xml.Name

	NoncurrentDays aws.IntegerValue `xml:"NoncurrentDays"`
}

func (v *NoncurrentVersionExpiration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// NoncurrentVersionTransition is undocumented.
type NoncurrentVersionTransition struct {
	XMLName xml.Name

	NoncurrentDays aws.IntegerValue `xml:"NoncurrentDays"`
	StorageClass   aws.StringValue  `xml:"StorageClass"`
}

func (v *NoncurrentVersionTransition) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// NotificationConfiguration is undocumented.
type NotificationConfiguration struct {
	XMLName xml.Name

	CloudFunctionConfiguration *CloudFunctionConfiguration `xml:"CloudFunctionConfiguration,omitempty"`
	QueueConfiguration         *QueueConfiguration         `xml:"QueueConfiguration,omitempty"`
	TopicConfiguration         *TopicConfiguration         `xml:"TopicConfiguration,omitempty"`
}

func (v *NotificationConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Object is undocumented.
type Object struct {
	XMLName xml.Name

	ETag         aws.StringValue `xml:"ETag"`
	Key          aws.StringValue `xml:"Key"`
	LastModified time.Time       `xml:"LastModified"`
	Owner        *Owner          `xml:"Owner,omitempty"`
	Size         aws.LongValue   `xml:"Size"`
	StorageClass aws.StringValue `xml:"StorageClass"`
}

func (v *Object) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	ObjectCannedACLAuthenticatedRead      = "authenticated-read"
	ObjectCannedACLBucketOwnerFullControl = "bucket-owner-full-control"
	ObjectCannedACLBucketOwnerRead        = "bucket-owner-read"
	ObjectCannedACLPrivate                = "private"
	ObjectCannedACLPublicRead             = "public-read"
	ObjectCannedACLPublicReadWrite        = "public-read-write"
)

// ObjectIdentifier is undocumented.
type ObjectIdentifier struct {
	XMLName xml.Name

	Key       aws.StringValue `xml:"Key"`
	VersionID aws.StringValue `xml:"VersionId"`
}

func (v *ObjectIdentifier) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	ObjectStorageClassGlacier           = "GLACIER"
	ObjectStorageClassReducedRedundancy = "REDUCED_REDUNDANCY"
	ObjectStorageClassStandard          = "STANDARD"
)

// ObjectVersion is undocumented.
type ObjectVersion struct {
	XMLName xml.Name

	ETag         aws.StringValue  `xml:"ETag"`
	IsLatest     aws.BooleanValue `xml:"IsLatest"`
	Key          aws.StringValue  `xml:"Key"`
	LastModified time.Time        `xml:"LastModified"`
	Owner        *Owner           `xml:"Owner,omitempty"`
	Size         aws.LongValue    `xml:"Size"`
	StorageClass aws.StringValue  `xml:"StorageClass"`
	VersionID    aws.StringValue  `xml:"VersionId"`
}

func (v *ObjectVersion) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	ObjectVersionStorageClassStandard = "STANDARD"
)

// Owner is undocumented.
type Owner struct {
	XMLName xml.Name

	DisplayName aws.StringValue `xml:"DisplayName"`
	ID          aws.StringValue `xml:"ID"`
}

func (v *Owner) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Part is undocumented.
type Part struct {
	XMLName xml.Name

	ETag         aws.StringValue  `xml:"ETag"`
	LastModified time.Time        `xml:"LastModified"`
	PartNumber   aws.IntegerValue `xml:"PartNumber"`
	Size         aws.LongValue    `xml:"Size"`
}

func (v *Part) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	PayerBucketOwner = "BucketOwner"
	PayerRequester   = "Requester"
)

// Possible values for S3.
const (
	PermissionFullControl = "FULL_CONTROL"
	PermissionRead        = "READ"
	PermissionReadAcp     = "READ_ACP"
	PermissionWrite       = "WRITE"
	PermissionWriteAcp    = "WRITE_ACP"
)

// Possible values for S3.
const (
	ProtocolHTTP  = "http"
	ProtocolHTTPS = "https"
)

// PutBucketACLRequest is undocumented.
type PutBucketACLRequest struct {
	XMLName xml.Name

	ACL                 aws.StringValue      `xml:"-"`
	AccessControlPolicy *AccessControlPolicy `xml:"AccessControlPolicy,omitempty"`
	Bucket              aws.StringValue      `xml:"-"`
	ContentMD5          aws.StringValue      `xml:"-"`
	GrantFullControl    aws.StringValue      `xml:"-"`
	GrantRead           aws.StringValue      `xml:"-"`
	GrantReadACP        aws.StringValue      `xml:"-"`
	GrantWrite          aws.StringValue      `xml:"-"`
	GrantWriteACP       aws.StringValue      `xml:"-"`
}

func (v *PutBucketACLRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketCORSRequest is undocumented.
type PutBucketCORSRequest struct {
	XMLName xml.Name

	Bucket            aws.StringValue    `xml:"-"`
	CORSConfiguration *CORSConfiguration `xml:"CORSConfiguration,omitempty"`
	ContentMD5        aws.StringValue    `xml:"-"`
}

func (v *PutBucketCORSRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketLifecycleRequest is undocumented.
type PutBucketLifecycleRequest struct {
	XMLName xml.Name

	Bucket                 aws.StringValue         `xml:"-"`
	ContentMD5             aws.StringValue         `xml:"-"`
	LifecycleConfiguration *LifecycleConfiguration `xml:"LifecycleConfiguration,omitempty"`
}

func (v *PutBucketLifecycleRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketLoggingRequest is undocumented.
type PutBucketLoggingRequest struct {
	XMLName xml.Name

	Bucket              aws.StringValue      `xml:"-"`
	BucketLoggingStatus *BucketLoggingStatus `xml:"BucketLoggingStatus,omitempty"`
	ContentMD5          aws.StringValue      `xml:"-"`
}

func (v *PutBucketLoggingRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketNotificationRequest is undocumented.
type PutBucketNotificationRequest struct {
	XMLName xml.Name

	Bucket                    aws.StringValue            `xml:"-"`
	ContentMD5                aws.StringValue            `xml:"-"`
	NotificationConfiguration *NotificationConfiguration `xml:"NotificationConfiguration,omitempty"`
}

func (v *PutBucketNotificationRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketPolicyRequest is undocumented.
type PutBucketPolicyRequest struct {
	XMLName xml.Name

	Bucket     aws.StringValue `xml:"-"`
	ContentMD5 aws.StringValue `xml:"-"`
	Policy     aws.StringValue `xml:"Policy"`
}

func (v *PutBucketPolicyRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketRequestPaymentRequest is undocumented.
type PutBucketRequestPaymentRequest struct {
	XMLName xml.Name

	Bucket                      aws.StringValue              `xml:"-"`
	ContentMD5                  aws.StringValue              `xml:"-"`
	RequestPaymentConfiguration *RequestPaymentConfiguration `xml:"RequestPaymentConfiguration,omitempty"`
}

func (v *PutBucketRequestPaymentRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketTaggingRequest is undocumented.
type PutBucketTaggingRequest struct {
	XMLName xml.Name

	Bucket     aws.StringValue `xml:"-"`
	ContentMD5 aws.StringValue `xml:"-"`
	Tagging    *Tagging        `xml:"Tagging,omitempty"`
}

func (v *PutBucketTaggingRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketVersioningRequest is undocumented.
type PutBucketVersioningRequest struct {
	XMLName xml.Name

	Bucket                  aws.StringValue          `xml:"-"`
	ContentMD5              aws.StringValue          `xml:"-"`
	MFA                     aws.StringValue          `xml:"-"`
	VersioningConfiguration *VersioningConfiguration `xml:"VersioningConfiguration,omitempty"`
}

func (v *PutBucketVersioningRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutBucketWebsiteRequest is undocumented.
type PutBucketWebsiteRequest struct {
	XMLName xml.Name

	Bucket               aws.StringValue       `xml:"-"`
	ContentMD5           aws.StringValue       `xml:"-"`
	WebsiteConfiguration *WebsiteConfiguration `xml:"WebsiteConfiguration,omitempty"`
}

func (v *PutBucketWebsiteRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutObjectACLRequest is undocumented.
type PutObjectACLRequest struct {
	XMLName xml.Name

	ACL                 aws.StringValue      `xml:"-"`
	AccessControlPolicy *AccessControlPolicy `xml:"AccessControlPolicy,omitempty"`
	Bucket              aws.StringValue      `xml:"-"`
	ContentMD5          aws.StringValue      `xml:"-"`
	GrantFullControl    aws.StringValue      `xml:"-"`
	GrantRead           aws.StringValue      `xml:"-"`
	GrantReadACP        aws.StringValue      `xml:"-"`
	GrantWrite          aws.StringValue      `xml:"-"`
	GrantWriteACP       aws.StringValue      `xml:"-"`
	Key                 aws.StringValue      `xml:"-"`
}

func (v *PutObjectACLRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutObjectOutput is undocumented.
type PutObjectOutput struct {
	XMLName xml.Name

	ETag                 aws.StringValue `xml:"-"`
	Expiration           aws.StringValue `xml:"-"`
	SSECustomerAlgorithm aws.StringValue `xml:"-"`
	SSECustomerKeyMD5    aws.StringValue `xml:"-"`
	SSEKMSKeyID          aws.StringValue `xml:"-"`
	ServerSideEncryption aws.StringValue `xml:"-"`
	VersionID            aws.StringValue `xml:"-"`
}

func (v *PutObjectOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// PutObjectRequest is undocumented.
type PutObjectRequest struct {
	XMLName xml.Name

	ACL                     aws.StringValue   `xml:"-"`
	Body                    io.ReadCloser     `xml:"-"`
	Bucket                  aws.StringValue   `xml:"-"`
	CacheControl            aws.StringValue   `xml:"-"`
	ContentDisposition      aws.StringValue   `xml:"-"`
	ContentEncoding         aws.StringValue   `xml:"-"`
	ContentLanguage         aws.StringValue   `xml:"-"`
	ContentLength           aws.LongValue     `xml:"-"`
	ContentMD5              aws.StringValue   `xml:"-"`
	ContentType             aws.StringValue   `xml:"-"`
	Expires                 time.Time         `xml:"-"`
	GrantFullControl        aws.StringValue   `xml:"-"`
	GrantRead               aws.StringValue   `xml:"-"`
	GrantReadACP            aws.StringValue   `xml:"-"`
	GrantWriteACP           aws.StringValue   `xml:"-"`
	Key                     aws.StringValue   `xml:"-"`
	Metadata                map[string]string `xml:"-"`
	SSECustomerAlgorithm    aws.StringValue   `xml:"-"`
	SSECustomerKey          aws.StringValue   `xml:"-"`
	SSECustomerKeyMD5       aws.StringValue   `xml:"-"`
	SSEKMSKeyID             aws.StringValue   `xml:"-"`
	ServerSideEncryption    aws.StringValue   `xml:"-"`
	StorageClass            aws.StringValue   `xml:"-"`
	WebsiteRedirectLocation aws.StringValue   `xml:"-"`
}

func (v *PutObjectRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// QueueConfiguration is undocumented.
type QueueConfiguration struct {
	XMLName xml.Name

	Event  aws.StringValue `xml:"Event"`
	Events []string        `xml:"Event,omitempty"`
	ID     aws.StringValue `xml:"Id"`
	Queue  aws.StringValue `xml:"Queue"`
}

func (v *QueueConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Redirect is undocumented.
type Redirect struct {
	XMLName xml.Name

	HostName             aws.StringValue `xml:"HostName"`
	HTTPRedirectCode     aws.StringValue `xml:"HttpRedirectCode"`
	Protocol             aws.StringValue `xml:"Protocol"`
	ReplaceKeyPrefixWith aws.StringValue `xml:"ReplaceKeyPrefixWith"`
	ReplaceKeyWith       aws.StringValue `xml:"ReplaceKeyWith"`
}

func (v *Redirect) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// RedirectAllRequestsTo is undocumented.
type RedirectAllRequestsTo struct {
	XMLName xml.Name

	HostName aws.StringValue `xml:"HostName"`
	Protocol aws.StringValue `xml:"Protocol"`
}

func (v *RedirectAllRequestsTo) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// RequestPaymentConfiguration is undocumented.
type RequestPaymentConfiguration struct {
	XMLName xml.Name

	Payer aws.StringValue `xml:"Payer"`
}

func (v *RequestPaymentConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// RestoreObjectRequest is undocumented.
type RestoreObjectRequest struct {
	XMLName xml.Name

	Bucket         aws.StringValue `xml:"-"`
	Key            aws.StringValue `xml:"-"`
	RestoreRequest *RestoreRequest `xml:"RestoreRequest,omitempty"`
	VersionID      aws.StringValue `xml:"-"`
}

func (v *RestoreObjectRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// RestoreRequest is undocumented.
type RestoreRequest struct {
	XMLName xml.Name

	Days aws.IntegerValue `xml:"Days"`
}

func (v *RestoreRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// RoutingRule is undocumented.
type RoutingRule struct {
	XMLName xml.Name

	Condition *Condition `xml:"Condition,omitempty"`
	Redirect  *Redirect  `xml:"Redirect,omitempty"`
}

func (v *RoutingRule) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Rule is undocumented.
type Rule struct {
	XMLName xml.Name

	Expiration                  *LifecycleExpiration         `xml:"Expiration,omitempty"`
	ID                          aws.StringValue              `xml:"ID"`
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `xml:"NoncurrentVersionExpiration,omitempty"`
	NoncurrentVersionTransition *NoncurrentVersionTransition `xml:"NoncurrentVersionTransition,omitempty"`
	Prefix                      aws.StringValue              `xml:"Prefix"`
	Status                      aws.StringValue              `xml:"Status"`
	Transition                  *Transition                  `xml:"Transition,omitempty"`
}

func (v *Rule) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	ServerSideEncryptionAES256 = "AES256"
)

// Possible values for S3.
const (
	StorageClassReducedRedundancy = "REDUCED_REDUNDANCY"
	StorageClassStandard          = "STANDARD"
)

// Tag is undocumented.
type Tag struct {
	XMLName xml.Name

	Key   aws.StringValue `xml:"Key"`
	Value aws.StringValue `xml:"Value"`
}

func (v *Tag) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Tagging is undocumented.
type Tagging struct {
	XMLName xml.Name

	TagSet []Tag `xml:"TagSet>Tag,omitempty"`
}

func (v *Tagging) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// TargetGrant is undocumented.
type TargetGrant struct {
	XMLName xml.Name

	Grantee    *Grantee        `xml:"Grantee,omitempty"`
	Permission aws.StringValue `xml:"Permission"`
}

func (v *TargetGrant) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// TopicConfiguration is undocumented.
type TopicConfiguration struct {
	XMLName xml.Name

	Event  aws.StringValue `xml:"Event"`
	Events []string        `xml:"Event,omitempty"`
	ID     aws.StringValue `xml:"Id"`
	Topic  aws.StringValue `xml:"Topic"`
}

func (v *TopicConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Transition is undocumented.
type Transition struct {
	XMLName xml.Name

	Date         time.Time        `xml:"Date"`
	Days         aws.IntegerValue `xml:"Days"`
	StorageClass aws.StringValue  `xml:"StorageClass"`
}

func (v *Transition) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for S3.
const (
	TransitionStorageClassGlacier = "GLACIER"
)

// Possible values for S3.
const (
	TypeAmazonCustomerByEmail = "AmazonCustomerByEmail"
	TypeCanonicalUser         = "CanonicalUser"
	TypeGroup                 = "Group"
)

// UploadPartCopyOutput is undocumented.
type UploadPartCopyOutput struct {
	XMLName xml.Name

	CopyPartResult       *CopyPartResult `xml:"CopyPartResult,omitempty"`
	CopySourceVersionID  aws.StringValue `xml:"-"`
	SSECustomerAlgorithm aws.StringValue `xml:"-"`
	SSECustomerKeyMD5    aws.StringValue `xml:"-"`
	SSEKMSKeyID          aws.StringValue `xml:"-"`
	ServerSideEncryption aws.StringValue `xml:"-"`
}

func (v *UploadPartCopyOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UploadPartCopyRequest is undocumented.
type UploadPartCopyRequest struct {
	XMLName xml.Name

	Bucket                         aws.StringValue  `xml:"-"`
	CopySource                     aws.StringValue  `xml:"-"`
	CopySourceIfMatch              aws.StringValue  `xml:"-"`
	CopySourceIfModifiedSince      time.Time        `xml:"-"`
	CopySourceIfNoneMatch          aws.StringValue  `xml:"-"`
	CopySourceIfUnmodifiedSince    time.Time        `xml:"-"`
	CopySourceRange                aws.StringValue  `xml:"-"`
	CopySourceSSECustomerAlgorithm aws.StringValue  `xml:"-"`
	CopySourceSSECustomerKey       aws.StringValue  `xml:"-"`
	CopySourceSSECustomerKeyMD5    aws.StringValue  `xml:"-"`
	Key                            aws.StringValue  `xml:"-"`
	PartNumber                     aws.IntegerValue `xml:"-"`
	SSECustomerAlgorithm           aws.StringValue  `xml:"-"`
	SSECustomerKey                 aws.StringValue  `xml:"-"`
	SSECustomerKeyMD5              aws.StringValue  `xml:"-"`
	UploadID                       aws.StringValue  `xml:"-"`
}

func (v *UploadPartCopyRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UploadPartOutput is undocumented.
type UploadPartOutput struct {
	XMLName xml.Name

	ETag                 aws.StringValue `xml:"-"`
	SSECustomerAlgorithm aws.StringValue `xml:"-"`
	SSECustomerKeyMD5    aws.StringValue `xml:"-"`
	SSEKMSKeyID          aws.StringValue `xml:"-"`
	ServerSideEncryption aws.StringValue `xml:"-"`
}

func (v *UploadPartOutput) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UploadPartRequest is undocumented.
type UploadPartRequest struct {
	XMLName xml.Name

	Body                 io.ReadCloser    `xml:"-"`
	Bucket               aws.StringValue  `xml:"-"`
	ContentLength        aws.LongValue    `xml:"-"`
	ContentMD5           aws.StringValue  `xml:"-"`
	Key                  aws.StringValue  `xml:"-"`
	PartNumber           aws.IntegerValue `xml:"-"`
	SSECustomerAlgorithm aws.StringValue  `xml:"-"`
	SSECustomerKey       aws.StringValue  `xml:"-"`
	SSECustomerKeyMD5    aws.StringValue  `xml:"-"`
	UploadID             aws.StringValue  `xml:"-"`
}

func (v *UploadPartRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// VersioningConfiguration is undocumented.
type VersioningConfiguration struct {
	XMLName xml.Name

	MFADelete aws.StringValue `xml:"MfaDelete"`
	Status    aws.StringValue `xml:"Status"`
}

func (v *VersioningConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// WebsiteConfiguration is undocumented.
type WebsiteConfiguration struct {
	XMLName xml.Name

	ErrorDocument         *ErrorDocument         `xml:"ErrorDocument,omitempty"`
	IndexDocument         *IndexDocument         `xml:"IndexDocument,omitempty"`
	RedirectAllRequestsTo *RedirectAllRequestsTo `xml:"RedirectAllRequestsTo,omitempty"`
	RoutingRules          []RoutingRule          `xml:"RoutingRules>RoutingRule,omitempty"`
}

func (v *WebsiteConfiguration) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// avoid errors if the packages aren't referenced
var _ time.Time

var _ bytes.Reader
var _ url.URL
var _ fmt.Stringer
var _ strings.Reader
var _ strconv.NumError
var _ = ioutil.Discard
