// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package sns provides a client for Amazon Simple Notification Service.
package sns

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"encoding/xml"
	"io"
)

// SNS is a client for Amazon Simple Notification Service.
type SNS struct {
	client *aws.QueryClient
}

// New returns a new SNS client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *SNS {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("sns", region)

	return &SNS{
		client: &aws.QueryClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2010-03-31",
		},
	}
}

// AddPermission adds a statement to a topic's access control policy,
// granting access for the specified AWS accounts to the specified actions.
func (c *SNS) AddPermission(req *AddPermissionInput) (err error) {
	// NRE
	err = c.client.Do("AddPermission", "POST", "/", req, nil)
	return
}

// ConfirmSubscription verifies an endpoint owner's intent to receive
// messages by validating the token sent to the endpoint by an earlier
// Subscribe action. If the token is valid, the action creates a new
// subscription and returns its Amazon Resource Name This call requires an
// AWS signature only when the AuthenticateOnUnsubscribe flag is set to
// "true".
func (c *SNS) ConfirmSubscription(req *ConfirmSubscriptionInput) (resp *ConfirmSubscriptionResult, err error) {
	resp = &ConfirmSubscriptionResult{}
	err = c.client.Do("ConfirmSubscription", "POST", "/", req, resp)
	return
}

// CreatePlatformApplication creates a platform application object for one
// of the supported push notification services, such as and to which
// devices and mobile apps may register. You must specify PlatformPrincipal
// and PlatformCredential attributes when using the
// CreatePlatformApplication action. The PlatformPrincipal is received from
// the notification service. For PlatformPrincipal is certificate". For
// PlatformPrincipal is not applicable. For PlatformPrincipal is "client
// id". The PlatformCredential is also received from the notification
// service. For PlatformCredential is "private key". For PlatformCredential
// is key". For PlatformCredential is "client secret". The
// PlatformApplicationArn that is returned when using
// CreatePlatformApplication is then used as an attribute for the
// CreatePlatformEndpoint action. For more information, see Using Amazon
// SNS Mobile Push Notifications .
func (c *SNS) CreatePlatformApplication(req *CreatePlatformApplicationInput) (resp *CreatePlatformApplicationResult, err error) {
	resp = &CreatePlatformApplicationResult{}
	err = c.client.Do("CreatePlatformApplication", "POST", "/", req, resp)
	return
}

// CreatePlatformEndpoint creates an endpoint for a device and mobile app
// on one of the supported push notification services, such as GCM and
// CreatePlatformEndpoint requires the PlatformApplicationArn that is
// returned from CreatePlatformApplication . The EndpointArn that is
// returned when using CreatePlatformEndpoint can then be used by the
// Publish action to send a message to a mobile app or by the Subscribe
// action for subscription to a topic. The CreatePlatformEndpoint action is
// idempotent, so if the requester already owns an endpoint with the same
// device token and attributes, that endpoint's ARN is returned without
// creating a new endpoint. For more information, see Using Amazon SNS
// Mobile Push Notifications . When using CreatePlatformEndpoint with
// Baidu, two attributes must be provided: ChannelId and UserId. The token
// field must also contain the ChannelId. For more information, see
// Creating an Amazon SNS Endpoint for Baidu .
func (c *SNS) CreatePlatformEndpoint(req *CreatePlatformEndpointInput) (resp *CreatePlatformEndpointResult, err error) {
	resp = &CreatePlatformEndpointResult{}
	err = c.client.Do("CreatePlatformEndpoint", "POST", "/", req, resp)
	return
}

// CreateTopic creates a topic to which notifications can be published.
// Users can create at most 3000 topics. For more information, see
// http://aws.amazon.com/sns . This action is idempotent, so if the
// requester already owns a topic with the specified name, that topic's ARN
// is returned without creating a new topic.
func (c *SNS) CreateTopic(req *CreateTopicInput) (resp *CreateTopicResult, err error) {
	resp = &CreateTopicResult{}
	err = c.client.Do("CreateTopic", "POST", "/", req, resp)
	return
}

// DeleteEndpoint deletes the endpoint from Amazon This action is
// idempotent. For more information, see Using Amazon SNS Mobile Push
// Notifications .
func (c *SNS) DeleteEndpoint(req *DeleteEndpointInput) (err error) {
	// NRE
	err = c.client.Do("DeleteEndpoint", "POST", "/", req, nil)
	return
}

// DeletePlatformApplication deletes a platform application object for one
// of the supported push notification services, such as and For more
// information, see Using Amazon SNS Mobile Push Notifications .
func (c *SNS) DeletePlatformApplication(req *DeletePlatformApplicationInput) (err error) {
	// NRE
	err = c.client.Do("DeletePlatformApplication", "POST", "/", req, nil)
	return
}

// DeleteTopic deletes a topic and all its subscriptions. Deleting a topic
// might prevent some messages previously sent to the topic from being
// delivered to subscribers. This action is idempotent, so deleting a topic
// that does not exist does not result in an error.
func (c *SNS) DeleteTopic(req *DeleteTopicInput) (err error) {
	// NRE
	err = c.client.Do("DeleteTopic", "POST", "/", req, nil)
	return
}

// GetEndpointAttributes retrieves the endpoint attributes for a device on
// one of the supported push notification services, such as GCM and For
// more information, see Using Amazon SNS Mobile Push Notifications .
func (c *SNS) GetEndpointAttributes(req *GetEndpointAttributesInput) (resp *GetEndpointAttributesResult, err error) {
	resp = &GetEndpointAttributesResult{}
	err = c.client.Do("GetEndpointAttributes", "POST", "/", req, resp)
	return
}

// GetPlatformApplicationAttributes retrieves the attributes of the
// platform application object for the supported push notification
// services, such as and For more information, see Using Amazon SNS Mobile
// Push Notifications .
func (c *SNS) GetPlatformApplicationAttributes(req *GetPlatformApplicationAttributesInput) (resp *GetPlatformApplicationAttributesResult, err error) {
	resp = &GetPlatformApplicationAttributesResult{}
	err = c.client.Do("GetPlatformApplicationAttributes", "POST", "/", req, resp)
	return
}

// GetSubscriptionAttributes is undocumented.
func (c *SNS) GetSubscriptionAttributes(req *GetSubscriptionAttributesInput) (resp *GetSubscriptionAttributesResult, err error) {
	resp = &GetSubscriptionAttributesResult{}
	err = c.client.Do("GetSubscriptionAttributes", "POST", "/", req, resp)
	return
}

// GetTopicAttributes returns all of the properties of a topic. Topic
// properties returned might differ based on the authorization of the user.
func (c *SNS) GetTopicAttributes(req *GetTopicAttributesInput) (resp *GetTopicAttributesResult, err error) {
	resp = &GetTopicAttributesResult{}
	err = c.client.Do("GetTopicAttributes", "POST", "/", req, resp)
	return
}

// ListEndpointsByPlatformApplication lists the endpoints and endpoint
// attributes for devices in a supported push notification service, such as
// GCM and The results for ListEndpointsByPlatformApplication are paginated
// and return a limited list of endpoints, up to 100. If additional records
// are available after the first page results, then a NextToken string will
// be returned. To receive the next page, you call
// ListEndpointsByPlatformApplication again using the NextToken string
// received from the previous call. When there are no more records to
// return, NextToken will be null. For more information, see Using Amazon
// SNS Mobile Push Notifications .
func (c *SNS) ListEndpointsByPlatformApplication(req *ListEndpointsByPlatformApplicationInput) (resp *ListEndpointsByPlatformApplicationResult, err error) {
	resp = &ListEndpointsByPlatformApplicationResult{}
	err = c.client.Do("ListEndpointsByPlatformApplication", "POST", "/", req, resp)
	return
}

// ListPlatformApplications lists the platform application objects for the
// supported push notification services, such as and The results for
// ListPlatformApplications are paginated and return a limited list of
// applications, up to 100. If additional records are available after the
// first page results, then a NextToken string will be returned. To receive
// the next page, you call ListPlatformApplications using the NextToken
// string received from the previous call. When there are no more records
// to return, NextToken will be null. For more information, see Using
// Amazon SNS Mobile Push Notifications .
func (c *SNS) ListPlatformApplications(req *ListPlatformApplicationsInput) (resp *ListPlatformApplicationsResult, err error) {
	resp = &ListPlatformApplicationsResult{}
	err = c.client.Do("ListPlatformApplications", "POST", "/", req, resp)
	return
}

// ListSubscriptions returns a list of the requester's subscriptions. Each
// call returns a limited list of subscriptions, up to 100. If there are
// more subscriptions, a NextToken is also returned. Use the NextToken
// parameter in a new ListSubscriptions call to get further results.
func (c *SNS) ListSubscriptions(req *ListSubscriptionsInput) (resp *ListSubscriptionsResult, err error) {
	resp = &ListSubscriptionsResult{}
	err = c.client.Do("ListSubscriptions", "POST", "/", req, resp)
	return
}

// ListSubscriptionsByTopic returns a list of the subscriptions to a
// specific topic. Each call returns a limited list of subscriptions, up to
// 100. If there are more subscriptions, a NextToken is also returned. Use
// the NextToken parameter in a new ListSubscriptionsByTopic call to get
// further results.
func (c *SNS) ListSubscriptionsByTopic(req *ListSubscriptionsByTopicInput) (resp *ListSubscriptionsByTopicResult, err error) {
	resp = &ListSubscriptionsByTopicResult{}
	err = c.client.Do("ListSubscriptionsByTopic", "POST", "/", req, resp)
	return
}

// ListTopics returns a list of the requester's topics. Each call returns a
// limited list of topics, up to 100. If there are more topics, a NextToken
// is also returned. Use the NextToken parameter in a new ListTopics call
// to get further results.
func (c *SNS) ListTopics(req *ListTopicsInput) (resp *ListTopicsResult, err error) {
	resp = &ListTopicsResult{}
	err = c.client.Do("ListTopics", "POST", "/", req, resp)
	return
}

// Publish sends a message to all of a topic's subscribed endpoints. When a
// messageId is returned, the message has been saved and Amazon SNS will
// attempt to deliver it to the topic's subscribers shortly. The format of
// the outgoing message to each subscribed endpoint depends on the
// notification protocol selected. To use the Publish action for sending a
// message to a mobile endpoint, such as an app on a Kindle device or
// mobile phone, you must specify the EndpointArn. The EndpointArn is
// returned when making a call with the CreatePlatformEndpoint action. The
// second example below shows a request and response for publishing to a
// mobile endpoint.
func (c *SNS) Publish(req *PublishInput) (resp *PublishResult, err error) {
	resp = &PublishResult{}
	err = c.client.Do("Publish", "POST", "/", req, resp)
	return
}

// RemovePermission removes a statement from a topic's access control
// policy.
func (c *SNS) RemovePermission(req *RemovePermissionInput) (err error) {
	// NRE
	err = c.client.Do("RemovePermission", "POST", "/", req, nil)
	return
}

// SetEndpointAttributes sets the attributes for an endpoint for a device
// on one of the supported push notification services, such as GCM and For
// more information, see Using Amazon SNS Mobile Push Notifications .
func (c *SNS) SetEndpointAttributes(req *SetEndpointAttributesInput) (err error) {
	// NRE
	err = c.client.Do("SetEndpointAttributes", "POST", "/", req, nil)
	return
}

// SetPlatformApplicationAttributes sets the attributes of the platform
// application object for the supported push notification services, such as
// and For more information, see Using Amazon SNS Mobile Push Notifications
// .
func (c *SNS) SetPlatformApplicationAttributes(req *SetPlatformApplicationAttributesInput) (err error) {
	// NRE
	err = c.client.Do("SetPlatformApplicationAttributes", "POST", "/", req, nil)
	return
}

// SetSubscriptionAttributes allows a subscription owner to set an
// attribute of the topic to a new value.
func (c *SNS) SetSubscriptionAttributes(req *SetSubscriptionAttributesInput) (err error) {
	// NRE
	err = c.client.Do("SetSubscriptionAttributes", "POST", "/", req, nil)
	return
}

// SetTopicAttributes allows a topic owner to set an attribute of the topic
// to a new value.
func (c *SNS) SetTopicAttributes(req *SetTopicAttributesInput) (err error) {
	// NRE
	err = c.client.Do("SetTopicAttributes", "POST", "/", req, nil)
	return
}

// Subscribe prepares to subscribe an endpoint by sending the endpoint a
// confirmation message. To actually create a subscription, the endpoint
// owner must call the ConfirmSubscription action with the token from the
// confirmation message. Confirmation tokens are valid for three days.
func (c *SNS) Subscribe(req *SubscribeInput) (resp *SubscribeResult, err error) {
	resp = &SubscribeResult{}
	err = c.client.Do("Subscribe", "POST", "/", req, resp)
	return
}

// Unsubscribe deletes a subscription. If the subscription requires
// authentication for deletion, only the owner of the subscription or the
// topic's owner can unsubscribe, and an AWS signature is required. If the
// Unsubscribe call does not require authentication and the requester is
// not the subscription owner, a final cancellation message is delivered to
// the endpoint, so that the endpoint owner can easily resubscribe to the
// topic if the Unsubscribe request was unintended.
func (c *SNS) Unsubscribe(req *UnsubscribeInput) (err error) {
	// NRE
	err = c.client.Do("Unsubscribe", "POST", "/", req, nil)
	return
}

// AddPermissionInput is undocumented.
type AddPermissionInput struct {
	AWSAccountID []string        `query:"AWSAccountId.member" xml:"AWSAccountId>member"`
	ActionName   []string        `query:"ActionName.member" xml:"ActionName>member"`
	Label        aws.StringValue `query:"Label" xml:"Label"`
	TopicARN     aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

// ConfirmSubscriptionInput is undocumented.
type ConfirmSubscriptionInput struct {
	AuthenticateOnUnsubscribe aws.StringValue `query:"AuthenticateOnUnsubscribe" xml:"AuthenticateOnUnsubscribe"`
	Token                     aws.StringValue `query:"Token" xml:"Token"`
	TopicARN                  aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

// ConfirmSubscriptionResponse is undocumented.
type ConfirmSubscriptionResponse struct {
	SubscriptionARN aws.StringValue `query:"SubscriptionArn" xml:"ConfirmSubscriptionResult>SubscriptionArn"`
}

// CreateEndpointResponse is undocumented.
type CreateEndpointResponse struct {
	EndpointARN aws.StringValue `query:"EndpointArn" xml:"CreatePlatformEndpointResult>EndpointArn"`
}

// CreatePlatformApplicationInput is undocumented.
type CreatePlatformApplicationInput struct {
	Attributes MapStringToString `query:"Attributes.entry" xml:"Attributes>entry"`
	Name       aws.StringValue   `query:"Name" xml:"Name"`
	Platform   aws.StringValue   `query:"Platform" xml:"Platform"`
}

// CreatePlatformApplicationResponse is undocumented.
type CreatePlatformApplicationResponse struct {
	PlatformApplicationARN aws.StringValue `query:"PlatformApplicationArn" xml:"CreatePlatformApplicationResult>PlatformApplicationArn"`
}

// CreatePlatformEndpointInput is undocumented.
type CreatePlatformEndpointInput struct {
	Attributes             MapStringToString `query:"Attributes.entry" xml:"Attributes>entry"`
	CustomUserData         aws.StringValue   `query:"CustomUserData" xml:"CustomUserData"`
	PlatformApplicationARN aws.StringValue   `query:"PlatformApplicationArn" xml:"PlatformApplicationArn"`
	Token                  aws.StringValue   `query:"Token" xml:"Token"`
}

// CreateTopicInput is undocumented.
type CreateTopicInput struct {
	Name aws.StringValue `query:"Name" xml:"Name"`
}

// CreateTopicResponse is undocumented.
type CreateTopicResponse struct {
	TopicARN aws.StringValue `query:"TopicArn" xml:"CreateTopicResult>TopicArn"`
}

// DeleteEndpointInput is undocumented.
type DeleteEndpointInput struct {
	EndpointARN aws.StringValue `query:"EndpointArn" xml:"EndpointArn"`
}

// DeletePlatformApplicationInput is undocumented.
type DeletePlatformApplicationInput struct {
	PlatformApplicationARN aws.StringValue `query:"PlatformApplicationArn" xml:"PlatformApplicationArn"`
}

// DeleteTopicInput is undocumented.
type DeleteTopicInput struct {
	TopicARN aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

// Endpoint is undocumented.
type Endpoint struct {
	Attributes  MapStringToString `query:"Attributes.entry" xml:"Attributes>entry"`
	EndpointARN aws.StringValue   `query:"EndpointArn" xml:"EndpointArn"`
}

// GetEndpointAttributesInput is undocumented.
type GetEndpointAttributesInput struct {
	EndpointARN aws.StringValue `query:"EndpointArn" xml:"EndpointArn"`
}

// GetEndpointAttributesResponse is undocumented.
type GetEndpointAttributesResponse struct {
	Attributes MapStringToString `query:"Attributes.entry" xml:"GetEndpointAttributesResult>Attributes>entry"`
}

// GetPlatformApplicationAttributesInput is undocumented.
type GetPlatformApplicationAttributesInput struct {
	PlatformApplicationARN aws.StringValue `query:"PlatformApplicationArn" xml:"PlatformApplicationArn"`
}

// GetPlatformApplicationAttributesResponse is undocumented.
type GetPlatformApplicationAttributesResponse struct {
	Attributes MapStringToString `query:"Attributes.entry" xml:"GetPlatformApplicationAttributesResult>Attributes>entry"`
}

// GetSubscriptionAttributesInput is undocumented.
type GetSubscriptionAttributesInput struct {
	SubscriptionARN aws.StringValue `query:"SubscriptionArn" xml:"SubscriptionArn"`
}

// GetSubscriptionAttributesResponse is undocumented.
type GetSubscriptionAttributesResponse struct {
	Attributes SubscriptionAttributesMap `query:"Attributes.entry" xml:"GetSubscriptionAttributesResult>Attributes>entry"`
}

// GetTopicAttributesInput is undocumented.
type GetTopicAttributesInput struct {
	TopicARN aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

// GetTopicAttributesResponse is undocumented.
type GetTopicAttributesResponse struct {
	Attributes TopicAttributesMap `query:"Attributes.entry" xml:"GetTopicAttributesResult>Attributes>entry"`
}

// ListEndpointsByPlatformApplicationInput is undocumented.
type ListEndpointsByPlatformApplicationInput struct {
	NextToken              aws.StringValue `query:"NextToken" xml:"NextToken"`
	PlatformApplicationARN aws.StringValue `query:"PlatformApplicationArn" xml:"PlatformApplicationArn"`
}

// ListEndpointsByPlatformApplicationResponse is undocumented.
type ListEndpointsByPlatformApplicationResponse struct {
	Endpoints []Endpoint      `query:"Endpoints.member" xml:"ListEndpointsByPlatformApplicationResult>Endpoints>member"`
	NextToken aws.StringValue `query:"NextToken" xml:"ListEndpointsByPlatformApplicationResult>NextToken"`
}

// ListPlatformApplicationsInput is undocumented.
type ListPlatformApplicationsInput struct {
	NextToken aws.StringValue `query:"NextToken" xml:"NextToken"`
}

// ListPlatformApplicationsResponse is undocumented.
type ListPlatformApplicationsResponse struct {
	NextToken            aws.StringValue       `query:"NextToken" xml:"ListPlatformApplicationsResult>NextToken"`
	PlatformApplications []PlatformApplication `query:"PlatformApplications.member" xml:"ListPlatformApplicationsResult>PlatformApplications>member"`
}

// ListSubscriptionsByTopicInput is undocumented.
type ListSubscriptionsByTopicInput struct {
	NextToken aws.StringValue `query:"NextToken" xml:"NextToken"`
	TopicARN  aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

// ListSubscriptionsByTopicResponse is undocumented.
type ListSubscriptionsByTopicResponse struct {
	NextToken     aws.StringValue `query:"NextToken" xml:"ListSubscriptionsByTopicResult>NextToken"`
	Subscriptions []Subscription  `query:"Subscriptions.member" xml:"ListSubscriptionsByTopicResult>Subscriptions>member"`
}

// ListSubscriptionsInput is undocumented.
type ListSubscriptionsInput struct {
	NextToken aws.StringValue `query:"NextToken" xml:"NextToken"`
}

// ListSubscriptionsResponse is undocumented.
type ListSubscriptionsResponse struct {
	NextToken     aws.StringValue `query:"NextToken" xml:"ListSubscriptionsResult>NextToken"`
	Subscriptions []Subscription  `query:"Subscriptions.member" xml:"ListSubscriptionsResult>Subscriptions>member"`
}

// ListTopicsInput is undocumented.
type ListTopicsInput struct {
	NextToken aws.StringValue `query:"NextToken" xml:"NextToken"`
}

// ListTopicsResponse is undocumented.
type ListTopicsResponse struct {
	NextToken aws.StringValue `query:"NextToken" xml:"ListTopicsResult>NextToken"`
	Topics    []Topic         `query:"Topics.member" xml:"ListTopicsResult>Topics>member"`
}

type MapStringToString map[string]string

// UnmarshalXML implements xml.UnmarshalXML interface for map
func (m *MapStringToString) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if *m == nil {
		(*m) = make(MapStringToString)
	}
	for {
		var e struct {
			Key   string `xml:"key"`
			Value string `xml:"value"`
		}
		err := d.DecodeElement(&e, &start)
		if err != nil && err != io.EOF {
			return err
		}
		if err == io.EOF {
			break
		}
		(*m)[e.Key] = e.Value
	}
	return nil
}

type MessageAttributeMap map[string]MessageAttributeValue

// UnmarshalXML implements xml.UnmarshalXML interface for map
func (m *MessageAttributeMap) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if *m == nil {
		(*m) = make(MessageAttributeMap)
	}
	for {
		var e struct {
			Name  string                `xml:"Name"`
			Value MessageAttributeValue `xml:"Value"`
		}
		err := d.DecodeElement(&e, &start)
		if err != nil && err != io.EOF {
			return err
		}
		if err == io.EOF {
			break
		}
		(*m)[e.Name] = e.Value
	}
	return nil
}

// MessageAttributeValue is undocumented.
type MessageAttributeValue struct {
	BinaryValue []byte          `query:"BinaryValue" xml:"BinaryValue"`
	DataType    aws.StringValue `query:"DataType" xml:"DataType"`
	StringValue aws.StringValue `query:"StringValue" xml:"StringValue"`
}

// PlatformApplication is undocumented.
type PlatformApplication struct {
	Attributes             MapStringToString `query:"Attributes.entry" xml:"Attributes>entry"`
	PlatformApplicationARN aws.StringValue   `query:"PlatformApplicationArn" xml:"PlatformApplicationArn"`
}

// PublishInput is undocumented.
type PublishInput struct {
	Message           aws.StringValue     `query:"Message" xml:"Message"`
	MessageAttributes MessageAttributeMap `query:"MessageAttributes.entry" xml:"MessageAttributes>entry"`
	MessageStructure  aws.StringValue     `query:"MessageStructure" xml:"MessageStructure"`
	Subject           aws.StringValue     `query:"Subject" xml:"Subject"`
	TargetARN         aws.StringValue     `query:"TargetArn" xml:"TargetArn"`
	TopicARN          aws.StringValue     `query:"TopicArn" xml:"TopicArn"`
}

// PublishResponse is undocumented.
type PublishResponse struct {
	MessageID aws.StringValue `query:"MessageId" xml:"PublishResult>MessageId"`
}

// RemovePermissionInput is undocumented.
type RemovePermissionInput struct {
	Label    aws.StringValue `query:"Label" xml:"Label"`
	TopicARN aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

// SetEndpointAttributesInput is undocumented.
type SetEndpointAttributesInput struct {
	Attributes  MapStringToString `query:"Attributes.entry" xml:"Attributes>entry"`
	EndpointARN aws.StringValue   `query:"EndpointArn" xml:"EndpointArn"`
}

// SetPlatformApplicationAttributesInput is undocumented.
type SetPlatformApplicationAttributesInput struct {
	Attributes             MapStringToString `query:"Attributes.entry" xml:"Attributes>entry"`
	PlatformApplicationARN aws.StringValue   `query:"PlatformApplicationArn" xml:"PlatformApplicationArn"`
}

// SetSubscriptionAttributesInput is undocumented.
type SetSubscriptionAttributesInput struct {
	AttributeName   aws.StringValue `query:"AttributeName" xml:"AttributeName"`
	AttributeValue  aws.StringValue `query:"AttributeValue" xml:"AttributeValue"`
	SubscriptionARN aws.StringValue `query:"SubscriptionArn" xml:"SubscriptionArn"`
}

// SetTopicAttributesInput is undocumented.
type SetTopicAttributesInput struct {
	AttributeName  aws.StringValue `query:"AttributeName" xml:"AttributeName"`
	AttributeValue aws.StringValue `query:"AttributeValue" xml:"AttributeValue"`
	TopicARN       aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

// SubscribeInput is undocumented.
type SubscribeInput struct {
	Endpoint aws.StringValue `query:"Endpoint" xml:"Endpoint"`
	Protocol aws.StringValue `query:"Protocol" xml:"Protocol"`
	TopicARN aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

// SubscribeResponse is undocumented.
type SubscribeResponse struct {
	SubscriptionARN aws.StringValue `query:"SubscriptionArn" xml:"SubscribeResult>SubscriptionArn"`
}

// Subscription is undocumented.
type Subscription struct {
	Endpoint        aws.StringValue `query:"Endpoint" xml:"Endpoint"`
	Owner           aws.StringValue `query:"Owner" xml:"Owner"`
	Protocol        aws.StringValue `query:"Protocol" xml:"Protocol"`
	SubscriptionARN aws.StringValue `query:"SubscriptionArn" xml:"SubscriptionArn"`
	TopicARN        aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

type SubscriptionAttributesMap map[string]string

// UnmarshalXML implements xml.UnmarshalXML interface for map
func (m *SubscriptionAttributesMap) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if *m == nil {
		(*m) = make(SubscriptionAttributesMap)
	}
	for {
		var e struct {
			Key   string `xml:"key"`
			Value string `xml:"value"`
		}
		err := d.DecodeElement(&e, &start)
		if err != nil && err != io.EOF {
			return err
		}
		if err == io.EOF {
			break
		}
		(*m)[e.Key] = e.Value
	}
	return nil
}

// Topic is undocumented.
type Topic struct {
	TopicARN aws.StringValue `query:"TopicArn" xml:"TopicArn"`
}

type TopicAttributesMap map[string]string

// UnmarshalXML implements xml.UnmarshalXML interface for map
func (m *TopicAttributesMap) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if *m == nil {
		(*m) = make(TopicAttributesMap)
	}
	for {
		var e struct {
			Key   string `xml:"key"`
			Value string `xml:"value"`
		}
		err := d.DecodeElement(&e, &start)
		if err != nil && err != io.EOF {
			return err
		}
		if err == io.EOF {
			break
		}
		(*m)[e.Key] = e.Value
	}
	return nil
}

// UnsubscribeInput is undocumented.
type UnsubscribeInput struct {
	SubscriptionARN aws.StringValue `query:"SubscriptionArn" xml:"SubscriptionArn"`
}

// ConfirmSubscriptionResult is a wrapper for ConfirmSubscriptionResponse.
type ConfirmSubscriptionResult struct {
	SubscriptionARN aws.StringValue `query:"SubscriptionArn" xml:"ConfirmSubscriptionResult>SubscriptionArn"`
}

// CreatePlatformApplicationResult is a wrapper for CreatePlatformApplicationResponse.
type CreatePlatformApplicationResult struct {
	PlatformApplicationARN aws.StringValue `query:"PlatformApplicationArn" xml:"CreatePlatformApplicationResult>PlatformApplicationArn"`
}

// CreatePlatformEndpointResult is a wrapper for CreateEndpointResponse.
type CreatePlatformEndpointResult struct {
	EndpointARN aws.StringValue `query:"EndpointArn" xml:"CreatePlatformEndpointResult>EndpointArn"`
}

// CreateTopicResult is a wrapper for CreateTopicResponse.
type CreateTopicResult struct {
	TopicARN aws.StringValue `query:"TopicArn" xml:"CreateTopicResult>TopicArn"`
}

// GetEndpointAttributesResult is a wrapper for GetEndpointAttributesResponse.
type GetEndpointAttributesResult struct {
	Attributes MapStringToString `query:"Attributes.entry" xml:"GetEndpointAttributesResult>Attributes>entry"`
}

// GetPlatformApplicationAttributesResult is a wrapper for GetPlatformApplicationAttributesResponse.
type GetPlatformApplicationAttributesResult struct {
	Attributes MapStringToString `query:"Attributes.entry" xml:"GetPlatformApplicationAttributesResult>Attributes>entry"`
}

// GetSubscriptionAttributesResult is a wrapper for GetSubscriptionAttributesResponse.
type GetSubscriptionAttributesResult struct {
	Attributes SubscriptionAttributesMap `query:"Attributes.entry" xml:"GetSubscriptionAttributesResult>Attributes>entry"`
}

// GetTopicAttributesResult is a wrapper for GetTopicAttributesResponse.
type GetTopicAttributesResult struct {
	Attributes TopicAttributesMap `query:"Attributes.entry" xml:"GetTopicAttributesResult>Attributes>entry"`
}

// ListEndpointsByPlatformApplicationResult is a wrapper for ListEndpointsByPlatformApplicationResponse.
type ListEndpointsByPlatformApplicationResult struct {
	Endpoints []Endpoint      `query:"Endpoints.member" xml:"ListEndpointsByPlatformApplicationResult>Endpoints>member"`
	NextToken aws.StringValue `query:"NextToken" xml:"ListEndpointsByPlatformApplicationResult>NextToken"`
}

// ListPlatformApplicationsResult is a wrapper for ListPlatformApplicationsResponse.
type ListPlatformApplicationsResult struct {
	NextToken            aws.StringValue       `query:"NextToken" xml:"ListPlatformApplicationsResult>NextToken"`
	PlatformApplications []PlatformApplication `query:"PlatformApplications.member" xml:"ListPlatformApplicationsResult>PlatformApplications>member"`
}

// ListSubscriptionsByTopicResult is a wrapper for ListSubscriptionsByTopicResponse.
type ListSubscriptionsByTopicResult struct {
	NextToken     aws.StringValue `query:"NextToken" xml:"ListSubscriptionsByTopicResult>NextToken"`
	Subscriptions []Subscription  `query:"Subscriptions.member" xml:"ListSubscriptionsByTopicResult>Subscriptions>member"`
}

// ListSubscriptionsResult is a wrapper for ListSubscriptionsResponse.
type ListSubscriptionsResult struct {
	NextToken     aws.StringValue `query:"NextToken" xml:"ListSubscriptionsResult>NextToken"`
	Subscriptions []Subscription  `query:"Subscriptions.member" xml:"ListSubscriptionsResult>Subscriptions>member"`
}

// ListTopicsResult is a wrapper for ListTopicsResponse.
type ListTopicsResult struct {
	NextToken aws.StringValue `query:"NextToken" xml:"ListTopicsResult>NextToken"`
	Topics    []Topic         `query:"Topics.member" xml:"ListTopicsResult>Topics>member"`
}

// PublishResult is a wrapper for PublishResponse.
type PublishResult struct {
	MessageID aws.StringValue `query:"MessageId" xml:"PublishResult>MessageId"`
}

// SubscribeResult is a wrapper for SubscribeResponse.
type SubscribeResult struct {
	SubscriptionARN aws.StringValue `query:"SubscriptionArn" xml:"SubscribeResult>SubscriptionArn"`
}

// avoid errors if the packages aren't referenced
var _ time.Time

var _ xml.Decoder
var _ = io.EOF
