// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudfront provides a client for Amazon CloudFront.
package cloudfront

import (
	"net/http"
	"time"

	"github.com/getlantern/aws-sdk-go/aws"
	"github.com/getlantern/aws-sdk-go/gen/endpoints"
)

import (
	"bytes"
	"encoding/xml"
	"fmt"
	"io"
	"io/ioutil"
	"net/url"
	"strconv"
	"strings"
)

// CloudFront is a client for Amazon CloudFront.
type CloudFront struct {
	client *aws.RestClient
}

// New returns a new CloudFront client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *CloudFront {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("cloudfront", region)

	return &CloudFront{
		client: &aws.RestClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2014-10-21",
		},
	}
}

// CreateCloudFrontOriginAccessIdentity is undocumented.
func (c *CloudFront) CreateCloudFrontOriginAccessIdentity(req *CreateCloudFrontOriginAccessIdentityRequest) (resp *CreateCloudFrontOriginAccessIdentityResult, err error) {
	resp = &CreateCloudFrontOriginAccessIdentityResult{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.CloudFrontOriginAccessIdentityConfig != nil {
		req.CloudFrontOriginAccessIdentityConfig.XMLName = xml.Name{
			Space: "http://cloudfront.amazonaws.com/doc/2014-10-21/",
			Local: "CloudFrontOriginAccessIdentityConfig",
		}
	}

	b, err := xml.Marshal(req.CloudFrontOriginAccessIdentityConfig)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2014-10-21/origin-access-identity/cloudfront"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.CloudFrontOriginAccessIdentity); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// CreateDistribution is undocumented.
func (c *CloudFront) CreateDistribution(req *CreateDistributionRequest) (resp *CreateDistributionResult, err error) {
	resp = &CreateDistributionResult{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.DistributionConfig != nil {
		req.DistributionConfig.XMLName = xml.Name{
			Space: "http://cloudfront.amazonaws.com/doc/2014-10-21/",
			Local: "DistributionConfig",
		}
	}

	b, err := xml.Marshal(req.DistributionConfig)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2014-10-21/distribution"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.Distribution); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// CreateInvalidation is undocumented.
func (c *CloudFront) CreateInvalidation(req *CreateInvalidationRequest) (resp *CreateInvalidationResult, err error) {
	resp = &CreateInvalidationResult{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.InvalidationBatch != nil {
		req.InvalidationBatch.XMLName = xml.Name{
			Space: "http://cloudfront.amazonaws.com/doc/2014-10-21/",
			Local: "InvalidationBatch",
		}
	}

	b, err := xml.Marshal(req.InvalidationBatch)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2014-10-21/distribution/{DistributionId}/invalidation"

	if req.DistributionID != nil {
		uri = strings.Replace(uri, "{"+"DistributionId"+"}", aws.EscapePath(*req.DistributionID), -1)
		uri = strings.Replace(uri, "{"+"DistributionId+"+"}", aws.EscapePath(*req.DistributionID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.Invalidation); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// CreateStreamingDistribution is undocumented.
func (c *CloudFront) CreateStreamingDistribution(req *CreateStreamingDistributionRequest) (resp *CreateStreamingDistributionResult, err error) {
	resp = &CreateStreamingDistributionResult{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.StreamingDistributionConfig != nil {
		req.StreamingDistributionConfig.XMLName = xml.Name{
			Space: "http://cloudfront.amazonaws.com/doc/2014-10-21/",
			Local: "StreamingDistributionConfig",
		}
	}

	b, err := xml.Marshal(req.StreamingDistributionConfig)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2014-10-21/streaming-distribution"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.StreamingDistribution); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// DeleteCloudFrontOriginAccessIdentity is undocumented.
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentity(req *DeleteCloudFrontOriginAccessIdentityRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/origin-access-identity/cloudfront/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.IfMatch != nil {
		httpReq.Header.Set("If-Match", *req.IfMatch)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteDistribution is undocumented.
func (c *CloudFront) DeleteDistribution(req *DeleteDistributionRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/distribution/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.IfMatch != nil {
		httpReq.Header.Set("If-Match", *req.IfMatch)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteStreamingDistribution is undocumented.
func (c *CloudFront) DeleteStreamingDistribution(req *DeleteStreamingDistributionRequest) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/streaming-distribution/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.IfMatch != nil {
		httpReq.Header.Set("If-Match", *req.IfMatch)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// GetCloudFrontOriginAccessIdentity get the information about an origin
// access identity.
func (c *CloudFront) GetCloudFrontOriginAccessIdentity(req *GetCloudFrontOriginAccessIdentityRequest) (resp *GetCloudFrontOriginAccessIdentityResult, err error) {
	resp = &GetCloudFrontOriginAccessIdentityResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/origin-access-identity/cloudfront/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.CloudFrontOriginAccessIdentity); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// GetCloudFrontOriginAccessIdentityConfig get the configuration
// information about an origin access identity.
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfig(req *GetCloudFrontOriginAccessIdentityConfigRequest) (resp *GetCloudFrontOriginAccessIdentityConfigResult, err error) {
	resp = &GetCloudFrontOriginAccessIdentityConfigResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/origin-access-identity/cloudfront/{Id}/config"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.CloudFrontOriginAccessIdentityConfig); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// GetDistribution is undocumented.
func (c *CloudFront) GetDistribution(req *GetDistributionRequest) (resp *GetDistributionResult, err error) {
	resp = &GetDistributionResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/distribution/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.Distribution); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// GetDistributionConfig get the configuration information about a
// distribution.
func (c *CloudFront) GetDistributionConfig(req *GetDistributionConfigRequest) (resp *GetDistributionConfigResult, err error) {
	resp = &GetDistributionConfigResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/distribution/{Id}/config"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.DistributionConfig); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// GetInvalidation is undocumented.
func (c *CloudFront) GetInvalidation(req *GetInvalidationRequest) (resp *GetInvalidationResult, err error) {
	resp = &GetInvalidationResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/distribution/{DistributionId}/invalidation/{Id}"

	if req.DistributionID != nil {
		uri = strings.Replace(uri, "{"+"DistributionId"+"}", aws.EscapePath(*req.DistributionID), -1)
		uri = strings.Replace(uri, "{"+"DistributionId+"+"}", aws.EscapePath(*req.DistributionID), -1)
	}

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.Invalidation); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetStreamingDistribution get the information about a streaming
// distribution.
func (c *CloudFront) GetStreamingDistribution(req *GetStreamingDistributionRequest) (resp *GetStreamingDistributionResult, err error) {
	resp = &GetStreamingDistributionResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/streaming-distribution/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.StreamingDistribution); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// GetStreamingDistributionConfig get the configuration information about a
// streaming distribution.
func (c *CloudFront) GetStreamingDistributionConfig(req *GetStreamingDistributionConfigRequest) (resp *GetStreamingDistributionConfigResult, err error) {
	resp = &GetStreamingDistributionConfigResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/streaming-distribution/{Id}/config"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.StreamingDistributionConfig); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// ListCloudFrontOriginAccessIdentities is undocumented.
func (c *CloudFront) ListCloudFrontOriginAccessIdentities(req *ListCloudFrontOriginAccessIdentitiesRequest) (resp *ListCloudFrontOriginAccessIdentitiesResult, err error) {
	resp = &ListCloudFrontOriginAccessIdentitiesResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/origin-access-identity/cloudfront"

	q := url.Values{}

	if req.Marker != nil {
		q.Set("Marker", *req.Marker)
	}

	if req.MaxItems != nil {
		q.Set("MaxItems", *req.MaxItems)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.CloudFrontOriginAccessIdentityList); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListDistributions is undocumented.
func (c *CloudFront) ListDistributions(req *ListDistributionsRequest) (resp *ListDistributionsResult, err error) {
	resp = &ListDistributionsResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/distribution"

	q := url.Values{}

	if req.Marker != nil {
		q.Set("Marker", *req.Marker)
	}

	if req.MaxItems != nil {
		q.Set("MaxItems", *req.MaxItems)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.DistributionList); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListInvalidations is undocumented.
func (c *CloudFront) ListInvalidations(req *ListInvalidationsRequest) (resp *ListInvalidationsResult, err error) {
	resp = &ListInvalidationsResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/distribution/{DistributionId}/invalidation"

	if req.DistributionID != nil {
		uri = strings.Replace(uri, "{"+"DistributionId"+"}", aws.EscapePath(*req.DistributionID), -1)
		uri = strings.Replace(uri, "{"+"DistributionId+"+"}", aws.EscapePath(*req.DistributionID), -1)
	}

	q := url.Values{}

	if req.Marker != nil {
		q.Set("Marker", *req.Marker)
	}

	if req.MaxItems != nil {
		q.Set("MaxItems", *req.MaxItems)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.InvalidationList); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListStreamingDistributions is undocumented.
func (c *CloudFront) ListStreamingDistributions(req *ListStreamingDistributionsRequest) (resp *ListStreamingDistributionsResult, err error) {
	resp = &ListStreamingDistributionsResult{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2014-10-21/streaming-distribution"

	q := url.Values{}

	if req.Marker != nil {
		q.Set("Marker", *req.Marker)
	}

	if req.MaxItems != nil {
		q.Set("MaxItems", *req.MaxItems)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.StreamingDistributionList); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// UpdateCloudFrontOriginAccessIdentity is undocumented.
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentity(req *UpdateCloudFrontOriginAccessIdentityRequest) (resp *UpdateCloudFrontOriginAccessIdentityResult, err error) {
	resp = &UpdateCloudFrontOriginAccessIdentityResult{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.CloudFrontOriginAccessIdentityConfig != nil {
		req.CloudFrontOriginAccessIdentityConfig.XMLName = xml.Name{
			Space: "http://cloudfront.amazonaws.com/doc/2014-10-21/",
			Local: "CloudFrontOriginAccessIdentityConfig",
		}
	}

	b, err := xml.Marshal(req.CloudFrontOriginAccessIdentityConfig)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2014-10-21/origin-access-identity/cloudfront/{Id}/config"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.IfMatch != nil {
		httpReq.Header.Set("If-Match", *req.IfMatch)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.CloudFrontOriginAccessIdentity); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// UpdateDistribution is undocumented.
func (c *CloudFront) UpdateDistribution(req *UpdateDistributionRequest) (resp *UpdateDistributionResult, err error) {
	resp = &UpdateDistributionResult{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.DistributionConfig != nil {
		req.DistributionConfig.XMLName = xml.Name{
			Space: "http://cloudfront.amazonaws.com/doc/2014-10-21/",
			Local: "DistributionConfig",
		}
	}

	b, err := xml.Marshal(req.DistributionConfig)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2014-10-21/distribution/{Id}/config"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.IfMatch != nil {
		httpReq.Header.Set("If-Match", *req.IfMatch)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.Distribution); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// UpdateStreamingDistribution is undocumented.
func (c *CloudFront) UpdateStreamingDistribution(req *UpdateStreamingDistributionRequest) (resp *UpdateStreamingDistributionResult, err error) {
	resp = &UpdateStreamingDistributionResult{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"

	if req.StreamingDistributionConfig != nil {
		req.StreamingDistributionConfig.XMLName = xml.Name{
			Space: "http://cloudfront.amazonaws.com/doc/2014-10-21/",
			Local: "StreamingDistributionConfig",
		}
	}

	b, err := xml.Marshal(req.StreamingDistributionConfig)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2014-10-21/streaming-distribution/{Id}/config"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.IfMatch != nil {
		httpReq.Header.Set("If-Match", *req.IfMatch)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(&resp.StreamingDistribution); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("ETag"); s != "" {

		resp.ETag = &s

	}

	return
}

// ActiveTrustedSigners is undocumented.
type ActiveTrustedSigners struct {
	XMLName xml.Name

	Enabled  aws.BooleanValue `xml:"Enabled"`
	Items    []Signer         `xml:"Items>Signer,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *ActiveTrustedSigners) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Aliases is undocumented.
type Aliases struct {
	XMLName xml.Name

	Items    []string         `xml:"Items>CNAME,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *Aliases) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// AllowedMethods is undocumented.
type AllowedMethods struct {
	XMLName xml.Name

	CachedMethods *CachedMethods   `xml:"CachedMethods,omitempty"`
	Items         []string         `xml:"Items>Method,omitempty"`
	Quantity      aws.IntegerValue `xml:"Quantity"`
}

func (v *AllowedMethods) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CacheBehavior is undocumented.
type CacheBehavior struct {
	XMLName xml.Name

	AllowedMethods       *AllowedMethods  `xml:"AllowedMethods,omitempty"`
	ForwardedValues      *ForwardedValues `xml:"ForwardedValues,omitempty"`
	MinTTL               aws.LongValue    `xml:"MinTTL"`
	PathPattern          aws.StringValue  `xml:"PathPattern"`
	SmoothStreaming      aws.BooleanValue `xml:"SmoothStreaming"`
	TargetOriginID       aws.StringValue  `xml:"TargetOriginId"`
	TrustedSigners       *TrustedSigners  `xml:"TrustedSigners,omitempty"`
	ViewerProtocolPolicy aws.StringValue  `xml:"ViewerProtocolPolicy"`
}

func (v *CacheBehavior) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CacheBehaviors is undocumented.
type CacheBehaviors struct {
	XMLName xml.Name

	Items    []CacheBehavior  `xml:"Items>CacheBehavior,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *CacheBehaviors) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CachedMethods is undocumented.
type CachedMethods struct {
	XMLName xml.Name

	Items    []string         `xml:"Items>Method,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *CachedMethods) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CloudFrontOriginAccessIdentity is undocumented.
type CloudFrontOriginAccessIdentity struct {
	XMLName xml.Name

	CloudFrontOriginAccessIdentityConfig *CloudFrontOriginAccessIdentityConfig `xml:"CloudFrontOriginAccessIdentityConfig,omitempty"`
	ID                                   aws.StringValue                       `xml:"Id"`
	S3CanonicalUserID                    aws.StringValue                       `xml:"S3CanonicalUserId"`
}

func (v *CloudFrontOriginAccessIdentity) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CloudFrontOriginAccessIdentityConfig is undocumented.
type CloudFrontOriginAccessIdentityConfig struct {
	XMLName xml.Name

	CallerReference aws.StringValue `xml:"CallerReference"`
	Comment         aws.StringValue `xml:"Comment"`
}

func (v *CloudFrontOriginAccessIdentityConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CloudFrontOriginAccessIdentityList is undocumented.
type CloudFrontOriginAccessIdentityList struct {
	XMLName xml.Name

	IsTruncated aws.BooleanValue                        `xml:"IsTruncated"`
	Items       []CloudFrontOriginAccessIdentitySummary `xml:"Items>CloudFrontOriginAccessIdentitySummary,omitempty"`
	Marker      aws.StringValue                         `xml:"Marker"`
	MaxItems    aws.IntegerValue                        `xml:"MaxItems"`
	NextMarker  aws.StringValue                         `xml:"NextMarker"`
	Quantity    aws.IntegerValue                        `xml:"Quantity"`
}

func (v *CloudFrontOriginAccessIdentityList) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CloudFrontOriginAccessIdentitySummary is undocumented.
type CloudFrontOriginAccessIdentitySummary struct {
	XMLName xml.Name

	Comment           aws.StringValue `xml:"Comment"`
	ID                aws.StringValue `xml:"Id"`
	S3CanonicalUserID aws.StringValue `xml:"S3CanonicalUserId"`
}

func (v *CloudFrontOriginAccessIdentitySummary) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CookieNames is undocumented.
type CookieNames struct {
	XMLName xml.Name

	Items    []string         `xml:"Items>Name,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *CookieNames) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CookiePreference is undocumented.
type CookiePreference struct {
	XMLName xml.Name

	Forward          aws.StringValue `xml:"Forward"`
	WhitelistedNames *CookieNames    `xml:"WhitelistedNames,omitempty"`
}

func (v *CookiePreference) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateCloudFrontOriginAccessIdentityRequest is undocumented.
type CreateCloudFrontOriginAccessIdentityRequest struct {
	XMLName xml.Name

	CloudFrontOriginAccessIdentityConfig *CloudFrontOriginAccessIdentityConfig `xml:"CloudFrontOriginAccessIdentityConfig,omitempty"`
}

func (v *CreateCloudFrontOriginAccessIdentityRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateCloudFrontOriginAccessIdentityResult is undocumented.
type CreateCloudFrontOriginAccessIdentityResult struct {
	XMLName xml.Name

	CloudFrontOriginAccessIdentity *CloudFrontOriginAccessIdentity `xml:"CloudFrontOriginAccessIdentity,omitempty"`
	ETag                           aws.StringValue                 `xml:"-"`
	Location                       aws.StringValue                 `xml:"-"`
}

func (v *CreateCloudFrontOriginAccessIdentityResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateDistributionRequest is undocumented.
type CreateDistributionRequest struct {
	XMLName xml.Name

	DistributionConfig *DistributionConfig `xml:"DistributionConfig,omitempty"`
}

func (v *CreateDistributionRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateDistributionResult is undocumented.
type CreateDistributionResult struct {
	XMLName xml.Name

	Distribution *Distribution   `xml:"Distribution,omitempty"`
	ETag         aws.StringValue `xml:"-"`
	Location     aws.StringValue `xml:"-"`
}

func (v *CreateDistributionResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateInvalidationRequest is undocumented.
type CreateInvalidationRequest struct {
	XMLName xml.Name

	DistributionID    aws.StringValue    `xml:"-"`
	InvalidationBatch *InvalidationBatch `xml:"InvalidationBatch,omitempty"`
}

func (v *CreateInvalidationRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateInvalidationResult is undocumented.
type CreateInvalidationResult struct {
	XMLName xml.Name

	Invalidation *Invalidation   `xml:"Invalidation,omitempty"`
	Location     aws.StringValue `xml:"-"`
}

func (v *CreateInvalidationResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateStreamingDistributionRequest is undocumented.
type CreateStreamingDistributionRequest struct {
	XMLName xml.Name

	StreamingDistributionConfig *StreamingDistributionConfig `xml:"StreamingDistributionConfig,omitempty"`
}

func (v *CreateStreamingDistributionRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateStreamingDistributionResult is undocumented.
type CreateStreamingDistributionResult struct {
	XMLName xml.Name

	ETag                  aws.StringValue        `xml:"-"`
	Location              aws.StringValue        `xml:"-"`
	StreamingDistribution *StreamingDistribution `xml:"StreamingDistribution,omitempty"`
}

func (v *CreateStreamingDistributionResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CustomErrorResponse is undocumented.
type CustomErrorResponse struct {
	XMLName xml.Name

	ErrorCachingMinTTL aws.LongValue    `xml:"ErrorCachingMinTTL"`
	ErrorCode          aws.IntegerValue `xml:"ErrorCode"`
	ResponseCode       aws.StringValue  `xml:"ResponseCode"`
	ResponsePagePath   aws.StringValue  `xml:"ResponsePagePath"`
}

func (v *CustomErrorResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CustomErrorResponses is undocumented.
type CustomErrorResponses struct {
	XMLName xml.Name

	Items    []CustomErrorResponse `xml:"Items>CustomErrorResponse,omitempty"`
	Quantity aws.IntegerValue      `xml:"Quantity"`
}

func (v *CustomErrorResponses) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CustomOriginConfig is undocumented.
type CustomOriginConfig struct {
	XMLName xml.Name

	HTTPPort             aws.IntegerValue `xml:"HTTPPort"`
	HTTPSPort            aws.IntegerValue `xml:"HTTPSPort"`
	OriginProtocolPolicy aws.StringValue  `xml:"OriginProtocolPolicy"`
}

func (v *CustomOriginConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DefaultCacheBehavior is undocumented.
type DefaultCacheBehavior struct {
	XMLName xml.Name

	AllowedMethods       *AllowedMethods  `xml:"AllowedMethods,omitempty"`
	ForwardedValues      *ForwardedValues `xml:"ForwardedValues,omitempty"`
	MinTTL               aws.LongValue    `xml:"MinTTL"`
	SmoothStreaming      aws.BooleanValue `xml:"SmoothStreaming"`
	TargetOriginID       aws.StringValue  `xml:"TargetOriginId"`
	TrustedSigners       *TrustedSigners  `xml:"TrustedSigners,omitempty"`
	ViewerProtocolPolicy aws.StringValue  `xml:"ViewerProtocolPolicy"`
}

func (v *DefaultCacheBehavior) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteCloudFrontOriginAccessIdentityRequest is undocumented.
type DeleteCloudFrontOriginAccessIdentityRequest struct {
	XMLName xml.Name

	ID      aws.StringValue `xml:"-"`
	IfMatch aws.StringValue `xml:"-"`
}

func (v *DeleteCloudFrontOriginAccessIdentityRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteDistributionRequest is undocumented.
type DeleteDistributionRequest struct {
	XMLName xml.Name

	ID      aws.StringValue `xml:"-"`
	IfMatch aws.StringValue `xml:"-"`
}

func (v *DeleteDistributionRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteStreamingDistributionRequest is undocumented.
type DeleteStreamingDistributionRequest struct {
	XMLName xml.Name

	ID      aws.StringValue `xml:"-"`
	IfMatch aws.StringValue `xml:"-"`
}

func (v *DeleteStreamingDistributionRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Distribution is undocumented.
type Distribution struct {
	XMLName xml.Name

	ActiveTrustedSigners          *ActiveTrustedSigners `xml:"ActiveTrustedSigners,omitempty"`
	DistributionConfig            *DistributionConfig   `xml:"DistributionConfig,omitempty"`
	DomainName                    aws.StringValue       `xml:"DomainName"`
	ID                            aws.StringValue       `xml:"Id"`
	InProgressInvalidationBatches aws.IntegerValue      `xml:"InProgressInvalidationBatches"`
	LastModifiedTime              time.Time             `xml:"LastModifiedTime"`
	Status                        aws.StringValue       `xml:"Status"`
}

func (v *Distribution) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DistributionConfig is undocumented.
type DistributionConfig struct {
	XMLName xml.Name

	Aliases              *Aliases              `xml:"Aliases,omitempty"`
	CacheBehaviors       *CacheBehaviors       `xml:"CacheBehaviors,omitempty"`
	CallerReference      aws.StringValue       `xml:"CallerReference"`
	Comment              aws.StringValue       `xml:"Comment"`
	CustomErrorResponses *CustomErrorResponses `xml:"CustomErrorResponses,omitempty"`
	DefaultCacheBehavior *DefaultCacheBehavior `xml:"DefaultCacheBehavior,omitempty"`
	DefaultRootObject    aws.StringValue       `xml:"DefaultRootObject"`
	Enabled              aws.BooleanValue      `xml:"Enabled"`
	Logging              *LoggingConfig        `xml:"Logging,omitempty"`
	Origins              *Origins              `xml:"Origins,omitempty"`
	PriceClass           aws.StringValue       `xml:"PriceClass"`
	Restrictions         *Restrictions         `xml:"Restrictions,omitempty"`
	ViewerCertificate    *ViewerCertificate    `xml:"ViewerCertificate,omitempty"`
}

func (v *DistributionConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DistributionList is undocumented.
type DistributionList struct {
	XMLName xml.Name

	IsTruncated aws.BooleanValue      `xml:"IsTruncated"`
	Items       []DistributionSummary `xml:"Items>DistributionSummary,omitempty"`
	Marker      aws.StringValue       `xml:"Marker"`
	MaxItems    aws.IntegerValue      `xml:"MaxItems"`
	NextMarker  aws.StringValue       `xml:"NextMarker"`
	Quantity    aws.IntegerValue      `xml:"Quantity"`
}

func (v *DistributionList) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DistributionSummary is undocumented.
type DistributionSummary struct {
	XMLName xml.Name

	Aliases              *Aliases              `xml:"Aliases,omitempty"`
	CacheBehaviors       *CacheBehaviors       `xml:"CacheBehaviors,omitempty"`
	Comment              aws.StringValue       `xml:"Comment"`
	CustomErrorResponses *CustomErrorResponses `xml:"CustomErrorResponses,omitempty"`
	DefaultCacheBehavior *DefaultCacheBehavior `xml:"DefaultCacheBehavior,omitempty"`
	DomainName           aws.StringValue       `xml:"DomainName"`
	Enabled              aws.BooleanValue      `xml:"Enabled"`
	ID                   aws.StringValue       `xml:"Id"`
	LastModifiedTime     time.Time             `xml:"LastModifiedTime"`
	Origins              *Origins              `xml:"Origins,omitempty"`
	PriceClass           aws.StringValue       `xml:"PriceClass"`
	Restrictions         *Restrictions         `xml:"Restrictions,omitempty"`
	Status               aws.StringValue       `xml:"Status"`
	ViewerCertificate    *ViewerCertificate    `xml:"ViewerCertificate,omitempty"`
}

func (v *DistributionSummary) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ForwardedValues is undocumented.
type ForwardedValues struct {
	XMLName xml.Name

	Cookies     *CookiePreference `xml:"Cookies,omitempty"`
	Headers     *Headers          `xml:"Headers,omitempty"`
	QueryString aws.BooleanValue  `xml:"QueryString"`
}

func (v *ForwardedValues) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GeoRestriction is undocumented.
type GeoRestriction struct {
	XMLName xml.Name

	Items           []string         `xml:"Items>Location,omitempty"`
	Quantity        aws.IntegerValue `xml:"Quantity"`
	RestrictionType aws.StringValue  `xml:"RestrictionType"`
}

func (v *GeoRestriction) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for CloudFront.
const (
	GeoRestrictionTypeBlacklist = "blacklist"
	GeoRestrictionTypeNone      = "none"
	GeoRestrictionTypeWhitelist = "whitelist"
)

// GetCloudFrontOriginAccessIdentityConfigRequest is undocumented.
type GetCloudFrontOriginAccessIdentityConfigRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetCloudFrontOriginAccessIdentityConfigRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetCloudFrontOriginAccessIdentityConfigResult is undocumented.
type GetCloudFrontOriginAccessIdentityConfigResult struct {
	XMLName xml.Name

	CloudFrontOriginAccessIdentityConfig *CloudFrontOriginAccessIdentityConfig `xml:"CloudFrontOriginAccessIdentityConfig,omitempty"`
	ETag                                 aws.StringValue                       `xml:"-"`
}

func (v *GetCloudFrontOriginAccessIdentityConfigResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetCloudFrontOriginAccessIdentityRequest is undocumented.
type GetCloudFrontOriginAccessIdentityRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetCloudFrontOriginAccessIdentityRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetCloudFrontOriginAccessIdentityResult is undocumented.
type GetCloudFrontOriginAccessIdentityResult struct {
	XMLName xml.Name

	CloudFrontOriginAccessIdentity *CloudFrontOriginAccessIdentity `xml:"CloudFrontOriginAccessIdentity,omitempty"`
	ETag                           aws.StringValue                 `xml:"-"`
}

func (v *GetCloudFrontOriginAccessIdentityResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetDistributionConfigRequest is undocumented.
type GetDistributionConfigRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetDistributionConfigRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetDistributionConfigResult is undocumented.
type GetDistributionConfigResult struct {
	XMLName xml.Name

	DistributionConfig *DistributionConfig `xml:"DistributionConfig,omitempty"`
	ETag               aws.StringValue     `xml:"-"`
}

func (v *GetDistributionConfigResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetDistributionRequest is undocumented.
type GetDistributionRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetDistributionRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetDistributionResult is undocumented.
type GetDistributionResult struct {
	XMLName xml.Name

	Distribution *Distribution   `xml:"Distribution,omitempty"`
	ETag         aws.StringValue `xml:"-"`
}

func (v *GetDistributionResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetInvalidationRequest is undocumented.
type GetInvalidationRequest struct {
	XMLName xml.Name

	DistributionID aws.StringValue `xml:"-"`
	ID             aws.StringValue `xml:"-"`
}

func (v *GetInvalidationRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetInvalidationResult is undocumented.
type GetInvalidationResult struct {
	XMLName xml.Name

	Invalidation *Invalidation `xml:"Invalidation,omitempty"`
}

func (v *GetInvalidationResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetStreamingDistributionConfigRequest is undocumented.
type GetStreamingDistributionConfigRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetStreamingDistributionConfigRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetStreamingDistributionConfigResult is undocumented.
type GetStreamingDistributionConfigResult struct {
	XMLName xml.Name

	ETag                        aws.StringValue              `xml:"-"`
	StreamingDistributionConfig *StreamingDistributionConfig `xml:"StreamingDistributionConfig,omitempty"`
}

func (v *GetStreamingDistributionConfigResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetStreamingDistributionRequest is undocumented.
type GetStreamingDistributionRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetStreamingDistributionRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetStreamingDistributionResult is undocumented.
type GetStreamingDistributionResult struct {
	XMLName xml.Name

	ETag                  aws.StringValue        `xml:"-"`
	StreamingDistribution *StreamingDistribution `xml:"StreamingDistribution,omitempty"`
}

func (v *GetStreamingDistributionResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Headers is undocumented.
type Headers struct {
	XMLName xml.Name

	Items    []string         `xml:"Items>Name,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *Headers) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Invalidation is undocumented.
type Invalidation struct {
	XMLName xml.Name

	CreateTime        time.Time          `xml:"CreateTime"`
	ID                aws.StringValue    `xml:"Id"`
	InvalidationBatch *InvalidationBatch `xml:"InvalidationBatch,omitempty"`
	Status            aws.StringValue    `xml:"Status"`
}

func (v *Invalidation) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// InvalidationBatch is undocumented.
type InvalidationBatch struct {
	XMLName xml.Name

	CallerReference aws.StringValue `xml:"CallerReference"`
	Paths           *Paths          `xml:"Paths,omitempty"`
}

func (v *InvalidationBatch) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// InvalidationList is undocumented.
type InvalidationList struct {
	XMLName xml.Name

	IsTruncated aws.BooleanValue      `xml:"IsTruncated"`
	Items       []InvalidationSummary `xml:"Items>InvalidationSummary,omitempty"`
	Marker      aws.StringValue       `xml:"Marker"`
	MaxItems    aws.IntegerValue      `xml:"MaxItems"`
	NextMarker  aws.StringValue       `xml:"NextMarker"`
	Quantity    aws.IntegerValue      `xml:"Quantity"`
}

func (v *InvalidationList) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// InvalidationSummary is undocumented.
type InvalidationSummary struct {
	XMLName xml.Name

	CreateTime time.Time       `xml:"CreateTime"`
	ID         aws.StringValue `xml:"Id"`
	Status     aws.StringValue `xml:"Status"`
}

func (v *InvalidationSummary) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for CloudFront.
const (
	ItemSelectionAll       = "all"
	ItemSelectionNone      = "none"
	ItemSelectionWhitelist = "whitelist"
)

// KeyPairIDs is undocumented.
type KeyPairIDs struct {
	XMLName xml.Name

	Items    []string         `xml:"Items>KeyPairId,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *KeyPairIDs) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListCloudFrontOriginAccessIdentitiesRequest is undocumented.
type ListCloudFrontOriginAccessIdentitiesRequest struct {
	XMLName xml.Name

	Marker   aws.StringValue `xml:"-"`
	MaxItems aws.StringValue `xml:"-"`
}

func (v *ListCloudFrontOriginAccessIdentitiesRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListCloudFrontOriginAccessIdentitiesResult is undocumented.
type ListCloudFrontOriginAccessIdentitiesResult struct {
	XMLName xml.Name

	CloudFrontOriginAccessIdentityList *CloudFrontOriginAccessIdentityList `xml:"CloudFrontOriginAccessIdentityList,omitempty"`
}

func (v *ListCloudFrontOriginAccessIdentitiesResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListDistributionsRequest is undocumented.
type ListDistributionsRequest struct {
	XMLName xml.Name

	Marker   aws.StringValue `xml:"-"`
	MaxItems aws.StringValue `xml:"-"`
}

func (v *ListDistributionsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListDistributionsResult is undocumented.
type ListDistributionsResult struct {
	XMLName xml.Name

	DistributionList *DistributionList `xml:"DistributionList,omitempty"`
}

func (v *ListDistributionsResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListInvalidationsRequest is undocumented.
type ListInvalidationsRequest struct {
	XMLName xml.Name

	DistributionID aws.StringValue `xml:"-"`
	Marker         aws.StringValue `xml:"-"`
	MaxItems       aws.StringValue `xml:"-"`
}

func (v *ListInvalidationsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListInvalidationsResult is undocumented.
type ListInvalidationsResult struct {
	XMLName xml.Name

	InvalidationList *InvalidationList `xml:"InvalidationList,omitempty"`
}

func (v *ListInvalidationsResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListStreamingDistributionsRequest is undocumented.
type ListStreamingDistributionsRequest struct {
	XMLName xml.Name

	Marker   aws.StringValue `xml:"-"`
	MaxItems aws.StringValue `xml:"-"`
}

func (v *ListStreamingDistributionsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListStreamingDistributionsResult is undocumented.
type ListStreamingDistributionsResult struct {
	XMLName xml.Name

	StreamingDistributionList *StreamingDistributionList `xml:"StreamingDistributionList,omitempty"`
}

func (v *ListStreamingDistributionsResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// LoggingConfig is undocumented.
type LoggingConfig struct {
	XMLName xml.Name

	Bucket         aws.StringValue  `xml:"Bucket"`
	Enabled        aws.BooleanValue `xml:"Enabled"`
	IncludeCookies aws.BooleanValue `xml:"IncludeCookies"`
	Prefix         aws.StringValue  `xml:"Prefix"`
}

func (v *LoggingConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for CloudFront.
const (
	MethodDelete  = "DELETE"
	MethodGet     = "GET"
	MethodHead    = "HEAD"
	MethodOptions = "OPTIONS"
	MethodPatch   = "PATCH"
	MethodPost    = "POST"
	MethodPut     = "PUT"
)

// Possible values for CloudFront.
const (
	MinimumProtocolVersionSSLv3 = "SSLv3"
	MinimumProtocolVersionTLSv1 = "TLSv1"
)

// Origin is undocumented.
type Origin struct {
	XMLName xml.Name

	CustomOriginConfig *CustomOriginConfig `xml:"CustomOriginConfig,omitempty"`
	DomainName         aws.StringValue     `xml:"DomainName"`
	ID                 aws.StringValue     `xml:"Id"`
	S3OriginConfig     *S3OriginConfig     `xml:"S3OriginConfig,omitempty"`
}

func (v *Origin) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for CloudFront.
const (
	OriginProtocolPolicyHTTPOnly    = "http-only"
	OriginProtocolPolicyMatchViewer = "match-viewer"
)

// Origins is undocumented.
type Origins struct {
	XMLName xml.Name

	Items    []Origin         `xml:"Items>Origin,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *Origins) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Paths is undocumented.
type Paths struct {
	XMLName xml.Name

	Items    []string         `xml:"Items>Path,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *Paths) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for CloudFront.
const (
	PriceClassPriceClass100 = "PriceClass_100"
	PriceClassPriceClass200 = "PriceClass_200"
	PriceClassPriceClassAll = "PriceClass_All"
)

// Restrictions is undocumented.
type Restrictions struct {
	XMLName xml.Name

	GeoRestriction *GeoRestriction `xml:"GeoRestriction,omitempty"`
}

func (v *Restrictions) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// S3Origin is undocumented.
type S3Origin struct {
	XMLName xml.Name

	DomainName           aws.StringValue `xml:"DomainName"`
	OriginAccessIdentity aws.StringValue `xml:"OriginAccessIdentity"`
}

func (v *S3Origin) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// S3OriginConfig is undocumented.
type S3OriginConfig struct {
	XMLName xml.Name

	OriginAccessIdentity aws.StringValue `xml:"OriginAccessIdentity"`
}

func (v *S3OriginConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for CloudFront.
const (
	SSLSupportMethodSNIOnly = "sni-only"
	SSLSupportMethodVIP     = "vip"
)

// Signer is undocumented.
type Signer struct {
	XMLName xml.Name

	AWSAccountNumber aws.StringValue `xml:"AwsAccountNumber"`
	KeyPairIDs       *KeyPairIDs     `xml:"KeyPairIds,omitempty"`
}

func (v *Signer) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// StreamingDistribution is undocumented.
type StreamingDistribution struct {
	XMLName xml.Name

	ActiveTrustedSigners        *ActiveTrustedSigners        `xml:"ActiveTrustedSigners,omitempty"`
	DomainName                  aws.StringValue              `xml:"DomainName"`
	ID                          aws.StringValue              `xml:"Id"`
	LastModifiedTime            time.Time                    `xml:"LastModifiedTime"`
	Status                      aws.StringValue              `xml:"Status"`
	StreamingDistributionConfig *StreamingDistributionConfig `xml:"StreamingDistributionConfig,omitempty"`
}

func (v *StreamingDistribution) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// StreamingDistributionConfig is undocumented.
type StreamingDistributionConfig struct {
	XMLName xml.Name

	Aliases         *Aliases                `xml:"Aliases,omitempty"`
	CallerReference aws.StringValue         `xml:"CallerReference"`
	Comment         aws.StringValue         `xml:"Comment"`
	Enabled         aws.BooleanValue        `xml:"Enabled"`
	Logging         *StreamingLoggingConfig `xml:"Logging,omitempty"`
	PriceClass      aws.StringValue         `xml:"PriceClass"`
	S3Origin        *S3Origin               `xml:"S3Origin,omitempty"`
	TrustedSigners  *TrustedSigners         `xml:"TrustedSigners,omitempty"`
}

func (v *StreamingDistributionConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// StreamingDistributionList is undocumented.
type StreamingDistributionList struct {
	XMLName xml.Name

	IsTruncated aws.BooleanValue               `xml:"IsTruncated"`
	Items       []StreamingDistributionSummary `xml:"Items>StreamingDistributionSummary,omitempty"`
	Marker      aws.StringValue                `xml:"Marker"`
	MaxItems    aws.IntegerValue               `xml:"MaxItems"`
	NextMarker  aws.StringValue                `xml:"NextMarker"`
	Quantity    aws.IntegerValue               `xml:"Quantity"`
}

func (v *StreamingDistributionList) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// StreamingDistributionSummary is undocumented.
type StreamingDistributionSummary struct {
	XMLName xml.Name

	Aliases          *Aliases         `xml:"Aliases,omitempty"`
	Comment          aws.StringValue  `xml:"Comment"`
	DomainName       aws.StringValue  `xml:"DomainName"`
	Enabled          aws.BooleanValue `xml:"Enabled"`
	ID               aws.StringValue  `xml:"Id"`
	LastModifiedTime time.Time        `xml:"LastModifiedTime"`
	PriceClass       aws.StringValue  `xml:"PriceClass"`
	S3Origin         *S3Origin        `xml:"S3Origin,omitempty"`
	Status           aws.StringValue  `xml:"Status"`
	TrustedSigners   *TrustedSigners  `xml:"TrustedSigners,omitempty"`
}

func (v *StreamingDistributionSummary) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// StreamingLoggingConfig is undocumented.
type StreamingLoggingConfig struct {
	XMLName xml.Name

	Bucket  aws.StringValue  `xml:"Bucket"`
	Enabled aws.BooleanValue `xml:"Enabled"`
	Prefix  aws.StringValue  `xml:"Prefix"`
}

func (v *StreamingLoggingConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// TrustedSigners is undocumented.
type TrustedSigners struct {
	XMLName xml.Name

	Enabled  aws.BooleanValue `xml:"Enabled"`
	Items    []string         `xml:"Items>AwsAccountNumber,omitempty"`
	Quantity aws.IntegerValue `xml:"Quantity"`
}

func (v *TrustedSigners) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateCloudFrontOriginAccessIdentityRequest is undocumented.
type UpdateCloudFrontOriginAccessIdentityRequest struct {
	XMLName xml.Name

	CloudFrontOriginAccessIdentityConfig *CloudFrontOriginAccessIdentityConfig `xml:"CloudFrontOriginAccessIdentityConfig,omitempty"`
	ID                                   aws.StringValue                       `xml:"-"`
	IfMatch                              aws.StringValue                       `xml:"-"`
}

func (v *UpdateCloudFrontOriginAccessIdentityRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateCloudFrontOriginAccessIdentityResult is undocumented.
type UpdateCloudFrontOriginAccessIdentityResult struct {
	XMLName xml.Name

	CloudFrontOriginAccessIdentity *CloudFrontOriginAccessIdentity `xml:"CloudFrontOriginAccessIdentity,omitempty"`
	ETag                           aws.StringValue                 `xml:"-"`
}

func (v *UpdateCloudFrontOriginAccessIdentityResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateDistributionRequest is undocumented.
type UpdateDistributionRequest struct {
	XMLName xml.Name

	DistributionConfig *DistributionConfig `xml:"DistributionConfig,omitempty"`
	ID                 aws.StringValue     `xml:"-"`
	IfMatch            aws.StringValue     `xml:"-"`
}

func (v *UpdateDistributionRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateDistributionResult is undocumented.
type UpdateDistributionResult struct {
	XMLName xml.Name

	Distribution *Distribution   `xml:"Distribution,omitempty"`
	ETag         aws.StringValue `xml:"-"`
}

func (v *UpdateDistributionResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateStreamingDistributionRequest is undocumented.
type UpdateStreamingDistributionRequest struct {
	XMLName xml.Name

	ID                          aws.StringValue              `xml:"-"`
	IfMatch                     aws.StringValue              `xml:"-"`
	StreamingDistributionConfig *StreamingDistributionConfig `xml:"StreamingDistributionConfig,omitempty"`
}

func (v *UpdateStreamingDistributionRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateStreamingDistributionResult is undocumented.
type UpdateStreamingDistributionResult struct {
	XMLName xml.Name

	ETag                  aws.StringValue        `xml:"-"`
	StreamingDistribution *StreamingDistribution `xml:"StreamingDistribution,omitempty"`
}

func (v *UpdateStreamingDistributionResult) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ViewerCertificate is undocumented.
type ViewerCertificate struct {
	XMLName xml.Name

	CloudFrontDefaultCertificate aws.BooleanValue `xml:"CloudFrontDefaultCertificate"`
	IAMCertificateID             aws.StringValue  `xml:"IAMCertificateId"`
	MinimumProtocolVersion       aws.StringValue  `xml:"MinimumProtocolVersion"`
	SSLSupportMethod             aws.StringValue  `xml:"SSLSupportMethod"`
}

func (v *ViewerCertificate) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for CloudFront.
const (
	ViewerProtocolPolicyAllowAll        = "allow-all"
	ViewerProtocolPolicyHTTPSOnly       = "https-only"
	ViewerProtocolPolicyRedirectToHTTPS = "redirect-to-https"
)

// avoid errors if the packages aren't referenced
var _ time.Time

var _ bytes.Reader
var _ url.URL
var _ fmt.Stringer
var _ strings.Reader
var _ strconv.NumError
var _ = ioutil.Discard
