// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package glacier provides a client for Amazon Glacier.
package glacier

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io"
	"io/ioutil"
	"net/url"
	"strconv"
	"strings"
)

// Glacier is a client for Amazon Glacier.
type Glacier struct {
	client *aws.RestClient
}

// New returns a new Glacier client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *Glacier {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("glacier", region)

	return &Glacier{
		client: &aws.RestClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2012-06-01",
		},
	}
}

// AbortMultipartUpload this operation aborts a multipart upload identified
// by the upload After the Abort Multipart Upload request succeeds, you
// cannot upload any more parts to the multipart upload or complete the
// multipart upload. Aborting a completed upload fails. However, aborting
// an already-aborted upload will succeed, for a short time. For more
// information about uploading a part and completing a multipart upload,
// see UploadMultipartPart and CompleteMultipartUpload This operation is
// idempotent. An AWS account has full permission to perform all operations
// (actions). However, AWS Identity and Access Management users don't have
// any permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and
// underlying go to Working with Archives in Amazon Glacier and Abort
// Multipart Upload in the Amazon Glacier Developer Guide .
func (c *Glacier) AbortMultipartUpload(req *AbortMultipartUploadInput) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.UploadID != nil {
		uri = strings.Replace(uri, "{"+"uploadId"+"}", aws.EscapePath(*req.UploadID), -1)
		uri = strings.Replace(uri, "{"+"uploadId+"+"}", aws.EscapePath(*req.UploadID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// CompleteMultipartUpload you call this operation to inform Amazon Glacier
// that all the archive parts have been uploaded and that Amazon Glacier
// can now assemble the archive from the uploaded parts. After assembling
// and saving the archive to the vault, Amazon Glacier returns the URI path
// of the newly created archive resource. Using the URI path, you can then
// access the archive. After you upload an archive, you should save the
// archive ID returned to retrieve the archive at a later point. You can
// also get the vault inventory to obtain a list of archive IDs in a vault.
// For more information, see InitiateJob In the request, you must include
// the computed SHA256 tree hash of the entire archive you have uploaded.
// For information about computing a SHA256 tree hash, see Computing
// Checksums . On the server side, Amazon Glacier also constructs the
// SHA256 tree hash of the assembled archive. If the values match, Amazon
// Glacier saves the archive to the vault; otherwise, it returns an error,
// and the operation fails. The ListParts operation returns a list of parts
// uploaded for a specific multipart upload. It includes checksum
// information for each uploaded part that can be used to debug a bad
// checksum issue. Additionally, Amazon Glacier also checks for any missing
// content ranges when assembling the archive, if missing content ranges
// are found, Amazon Glacier returns an error and the operation fails.
// Complete Multipart Upload is an idempotent operation. After your first
// successful complete multipart upload, if you call the operation again
// within a short period, the operation will succeed and return the same
// archive ID. This is useful in the event you experience a network issue
// that causes an aborted connection or receive a 500 server error, in
// which case you can repeat your Complete Multipart Upload request and get
// the same archive ID without creating duplicate archives. Note, however,
// that after the multipart upload completes, you cannot call the List
// Parts operation and the multipart upload will not appear in List
// Multipart Uploads response, even if idempotent complete is possible. An
// AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management users don't have any
// permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and
// underlying go to Uploading Large Archives in Parts (Multipart Upload)
// and Complete Multipart Upload in the Amazon Glacier Developer Guide .
func (c *Glacier) CompleteMultipartUpload(req *CompleteMultipartUploadInput) (resp *ArchiveCreationOutput, err error) {
	resp = &ArchiveCreationOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.UploadID != nil {
		uri = strings.Replace(uri, "{"+"uploadId"+"}", aws.EscapePath(*req.UploadID), -1)
		uri = strings.Replace(uri, "{"+"uploadId+"+"}", aws.EscapePath(*req.UploadID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ArchiveSize != nil {
		httpReq.Header.Set("x-amz-archive-size", *req.ArchiveSize)
	}

	if req.Checksum != nil {
		httpReq.Header.Set("x-amz-sha256-tree-hash", *req.Checksum)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-archive-id"); s != "" {

		resp.ArchiveID = &s

	}

	if s := httpResp.Header.Get("x-amz-sha256-tree-hash"); s != "" {

		resp.Checksum = &s

	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// CreateVault this operation creates a new vault with the specified name.
// The name of the vault must be unique within a region for an AWS account.
// You can create up to 1,000 vaults per account. If you need to create
// more vaults, contact Amazon Glacier. You must use the following
// guidelines when naming a vault. Names can be between 1 and 255
// characters long. Allowed characters are a-z, 0-9, '_' (underscore), '-'
// (hyphen), and '.' (period). This operation is idempotent. An AWS account
// has full permission to perform all operations (actions). However, AWS
// Identity and Access Management users don't have any permissions by
// default. You must grant them explicit permission to perform specific
// actions. For more information, see Access Control Using AWS Identity and
// Access Management For conceptual information and underlying go to
// Creating a Vault in Amazon Glacier and Create Vault in the Amazon
// Glacier Developer Guide .
func (c *Glacier) CreateVault(req *CreateVaultInput) (resp *CreateVaultOutput, err error) {
	resp = &CreateVaultOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// DeleteArchive this operation deletes an archive from a vault. Subsequent
// requests to initiate a retrieval of this archive will fail. Archive
// retrievals that are in progress for this archive ID may or may not
// succeed according to the following scenarios: If the archive retrieval
// job is actively preparing the data for download when Amazon Glacier
// receives the delete archive request, the archival retrieval operation
// might fail. If the archive retrieval job has successfully prepared the
// archive for download when Amazon Glacier receives the delete archive
// request, you will be able to download the output. This operation is
// idempotent. Attempting to delete an already-deleted archive does not
// result in an error. An AWS account has full permission to perform all
// operations (actions). However, AWS Identity and Access Management users
// don't have any permissions by default. You must grant them explicit
// permission to perform specific actions. For more information, see Access
// Control Using AWS Identity and Access Management For conceptual
// information and underlying go to Deleting an Archive in Amazon Glacier
// and Delete Archive in the Amazon Glacier Developer Guide .
func (c *Glacier) DeleteArchive(req *DeleteArchiveInput) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/archives/{archiveId}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.ArchiveID != nil {
		uri = strings.Replace(uri, "{"+"archiveId"+"}", aws.EscapePath(*req.ArchiveID), -1)
		uri = strings.Replace(uri, "{"+"archiveId+"+"}", aws.EscapePath(*req.ArchiveID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteVault this operation deletes a vault. Amazon Glacier will delete a
// vault only if there are no archives in the vault as of the last
// inventory and there have been no writes to the vault since the last
// inventory. If either of these conditions is not satisfied, the vault
// deletion fails (that is, the vault is not removed) and Amazon Glacier
// returns an error. You can use DescribeVault to return the number of
// archives in a vault, and you can use Initiate a Job jobs) to initiate a
// new inventory retrieval for a vault. The inventory contains the archive
// IDs you use to delete archives using Delete Archive archive) This
// operation is idempotent. An AWS account has full permission to perform
// all operations (actions). However, AWS Identity and Access Management
// users don't have any permissions by default. You must grant them
// explicit permission to perform specific actions. For more information,
// see Access Control Using AWS Identity and Access Management For
// conceptual information and underlying go to Deleting a Vault in Amazon
// Glacier and Delete Vault in the Amazon Glacier Developer Guide .
func (c *Glacier) DeleteVault(req *DeleteVaultInput) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DeleteVaultNotifications this operation deletes the notification
// configuration set for a vault. The operation is eventually
// consistent;that is, it might take some time for Amazon Glacier to
// completely disable the notifications and you might still receive some
// notifications for a short time after you send the delete request. An AWS
// account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management users don't have any
// permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and
// underlying go to Configuring Vault Notifications in Amazon Glacier and
// Delete Vault Notification Configuration in the Amazon Glacier Developer
// Guide.
func (c *Glacier) DeleteVaultNotifications(req *DeleteVaultNotificationsInput) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/notification-configuration"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// DescribeJob this operation returns information about a job you
// previously initiated, including the job initiation date, the user who
// initiated the job, the job status code/message and the Amazon SNS topic
// to notify after Amazon Glacier completes the job. For more information
// about initiating a job, see InitiateJob . This operation enables you to
// check the status of your job. However, it is strongly recommended that
// you set up an Amazon SNS topic and specify it in your initiate job
// request so that Amazon Glacier can notify the topic after it completes
// the job. A job ID will not expire for at least 24 hours after Amazon
// Glacier completes the job. An AWS account has full permission to perform
// all operations (actions). However, AWS Identity and Access Management
// users don't have any permissions by default. You must grant them
// explicit permission to perform specific actions. For more information,
// see Access Control Using AWS Identity and Access Management For
// information about the underlying go to Working with Archives in Amazon
// Glacier in the Amazon Glacier Developer Guide .
func (c *Glacier) DescribeJob(req *DescribeJobInput) (resp *GlacierJobDescription, err error) {
	resp = &GlacierJobDescription{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/jobs/{jobId}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.JobID != nil {
		uri = strings.Replace(uri, "{"+"jobId"+"}", aws.EscapePath(*req.JobID), -1)
		uri = strings.Replace(uri, "{"+"jobId+"+"}", aws.EscapePath(*req.JobID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// DescribeVault this operation returns information about a vault,
// including the vault's Amazon Resource Name the date the vault was
// created, the number of archives it contains, and the total size of all
// the archives in the vault. The number of archives and their total size
// are as of the last inventory generation. This means that if you add or
// remove an archive from a vault, and then immediately use Describe Vault,
// the change in contents will not be immediately reflected. If you want to
// retrieve the latest inventory of the vault, use InitiateJob . Amazon
// Glacier generates vault inventories approximately daily. For more
// information, see Downloading a Vault Inventory in Amazon Glacier . An
// AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management users don't have any
// permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and
// underlying go to Retrieving Vault Metadata in Amazon Glacier and
// Describe Vault in the Amazon Glacier Developer Guide .
func (c *Glacier) DescribeVault(req *DescribeVaultInput) (resp *DescribeVaultOutput, err error) {
	resp = &DescribeVaultOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetDataRetrievalPolicy <nil>
func (c *Glacier) GetDataRetrievalPolicy(req *GetDataRetrievalPolicyInput) (resp *GetDataRetrievalPolicyOutput, err error) {
	resp = &GetDataRetrievalPolicyOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/policies/data-retrieval"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetJobOutput this operation downloads the output of the job you
// initiated using InitiateJob . Depending on the job type you specified
// when you initiated the job, the output will be either the content of an
// archive or a vault inventory. A job ID will not expire for at least 24
// hours after Amazon Glacier completes the job. That is, you can download
// the job output within the 24 hours period after Amazon Glacier completes
// the job. If the job output is large, then you can use the Range request
// header to retrieve a portion of the output. This allows you to download
// the entire output in smaller chunks of bytes. For example, suppose you
// have 1 GB of job output you want to download and you decide to download
// 128 MB chunks of data at a time, which is a total of eight Get Job
// Output requests. You use the following process to download the job
// output: Download a 128 MB chunk of output by specifying the appropriate
// byte range using the Range header. Along with the data, the response
// includes a checksum of the payload. You compute the checksum of the
// payload on the client and compare it with the checksum you received in
// the response to ensure you received all the expected data. Repeat steps
// 1 and 2 for all the eight 128 MB chunks of output data, each time
// specifying the appropriate byte range. After downloading all the parts
// of the job output, you have a list of eight checksum values. Compute the
// tree hash of these values to find the checksum of the entire output.
// Using the DescribeJob obtain job information of the job that provided
// you the output. The response includes the checksum of the entire archive
// stored in Amazon Glacier. You compare this value with the checksum you
// computed to ensure you have downloaded the entire archive content with
// no errors. An AWS account has full permission to perform all operations
// (actions). However, AWS Identity and Access Management users don't have
// any permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and the
// underlying go to Downloading a Vault Inventory , Downloading an Archive
// , and Get Job Output
func (c *Glacier) GetJobOutput(req *GetJobOutputInput) (resp *GetJobOutputOutput, err error) {
	resp = &GetJobOutputOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.JobID != nil {
		uri = strings.Replace(uri, "{"+"jobId"+"}", aws.EscapePath(*req.JobID), -1)
		uri = strings.Replace(uri, "{"+"jobId+"+"}", aws.EscapePath(*req.JobID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.Range != nil {
		httpReq.Header.Set("Range", *req.Range)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("Accept-Ranges"); s != "" {

		resp.AcceptRanges = &s

	}

	if s := httpResp.Header.Get("x-amz-archive-description"); s != "" {

		resp.ArchiveDescription = &s

	}

	if s := httpResp.Header.Get("x-amz-sha256-tree-hash"); s != "" {

		resp.Checksum = &s

	}

	if s := httpResp.Header.Get("Content-Range"); s != "" {

		resp.ContentRange = &s

	}

	if s := httpResp.Header.Get("Content-Type"); s != "" {

		resp.ContentType = &s

	}

	resp.Status = aws.Integer(httpResp.StatusCode)

	return
}

// GetVaultNotifications this operation retrieves the
// notification-configuration subresource of the specified vault. For
// information about setting a notification configuration on a vault, see
// SetVaultNotifications . If a notification configuration for a vault is
// not set, the operation returns a 404 Not Found error. For more
// information about vault notifications, see Configuring Vault
// Notifications in Amazon Glacier . An AWS account has full permission to
// perform all operations (actions). However, AWS Identity and Access
// Management users don't have any permissions by default. You must grant
// them explicit permission to perform specific actions. For more
// information, see Access Control Using AWS Identity and Access Management
// For conceptual information and underlying go to Configuring Vault
// Notifications in Amazon Glacier and Get Vault Notification Configuration
// in the Amazon Glacier Developer Guide .
func (c *Glacier) GetVaultNotifications(req *GetVaultNotificationsInput) (resp *GetVaultNotificationsOutput, err error) {
	resp = &GetVaultNotificationsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/notification-configuration"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// InitiateJob this operation initiates a job of the specified type. In
// this release, you can initiate a job to retrieve either an archive or a
// vault inventory (a list of archives in a vault). Retrieving data from
// Amazon Glacier is a two-step process: Initiate a retrieval job. After
// the job completes, download the bytes. The retrieval request is executed
// asynchronously. When you initiate a retrieval job, Amazon Glacier
// creates a job and returns a job ID in the response. When Amazon Glacier
// completes the job, you can get the job output (archive or inventory
// data). For information about getting job output, see GetJobOutput
// operation. The job must complete before you can get its output. To
// determine when a job is complete, you have the following options: Use
// Amazon SNS Notification You can specify an Amazon Simple Notification
// Service (Amazon topic to which Amazon Glacier can post a notification
// after the job is completed. You can specify an SNS topic per job
// request. The notification is sent only after Amazon Glacier completes
// the job. In addition to specifying an SNS topic per job request, you can
// configure vault notifications for a vault so that job notifications are
// always sent. For more information, see SetVaultNotifications Get job
// details You can make a DescribeJob request to obtain job status
// information while a job is in progress. However, it is more efficient to
// use an Amazon SNS notification to determine when a job is complete. The
// information you get via notification is same that you get by calling
// DescribeJob If for a specific event, you add both the notification
// configuration on the vault and also specify an SNS topic in your
// initiate job request, Amazon Glacier sends both notifications. For more
// information, see SetVaultNotifications An AWS account has full
// permission to perform all operations (actions). However, AWS Identity
// and Access Management users don't have any permissions by default. You
// must grant them explicit permission to perform specific actions. For
// more information, see Access Control Using AWS Identity and Access
// Management About the Vault Inventory Amazon Glacier prepares an
// inventory for each vault periodically, every 24 hours. When you initiate
// a job for a vault inventory, Amazon Glacier returns the last inventory
// for the vault. The inventory data you get might be up to a day or two
// days old. Also, the initiate inventory job might take some time to
// complete before you can download the vault inventory. So you do not want
// to retrieve a vault inventory for each vault operation. However, in some
// scenarios, you might find the vault inventory useful. For example, when
// you upload an archive, you can provide an archive description but not an
// archive name. Amazon Glacier provides you a unique archive ID, an opaque
// string of characters. So, you might maintain your own database that maps
// archive names to their corresponding Amazon Glacier assigned archive
// IDs. You might find the vault inventory useful in the event you need to
// reconcile information in your database with the actual vault inventory.
// Range Inventory Retrieval You can limit the number of inventory items
// retrieved by filtering on the archive creation date or by setting a
// limit. Filtering by Archive Creation Date You can retrieve inventory
// items for archives created between StartDate and EndDate by specifying
// values for these parameters in the InitiateJob request. Archives created
// on or after the StartDate and before the EndDate will be returned. If
// you only provide the StartDate without the EndDate , you will retrieve
// the inventory for all archives created on or after the StartDate . If
// you only provide the EndDate without the StartDate , you will get back
// the inventory for all archives created before the EndDate Limiting
// Inventory Items per Retrieval You can limit the number of inventory
// items returned by setting the Limit parameter in the InitiateJob
// request. The inventory job output will contain inventory items up to the
// specified Limit . If there are more inventory items available, the
// result is paginated. After a job is complete you can use the DescribeJob
// operation to get a marker that you use in a subsequent InitiateJob
// request. The marker will indicate the starting point to retrieve the
// next set of inventory items. You can page through your entire inventory
// by repeatedly making InitiateJob requests with the marker from the
// previous DescribeJob output, until you get a marker from DescribeJob
// that returns null, indicating that there are no more inventory items
// available. You can use the Limit parameter together with the date range
// parameters. About Ranged Archive Retrieval You can initiate an archive
// retrieval for the whole archive or a range of the archive. In the case
// of ranged archive retrieval, you specify a byte range to return or the
// whole archive. The range specified must be megabyte aligned, that is the
// range start value must be divisible by 1 MB and range end value plus 1
// must be divisible by 1 MB or equal the end of the archive. If the ranged
// archive retrieval is not megabyte aligned, this operation returns a 400
// response. Furthermore, to ensure you get checksum values for data you
// download using Get Job Output the range must be tree hash aligned. An
// AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management users don't have any
// permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and the
// underlying go to Initiate a Job and Downloading a Vault Inventory
func (c *Glacier) InitiateJob(req *InitiateJobInput) (resp *InitiateJobOutput, err error) {
	resp = &InitiateJobOutput{}

	var body io.Reader
	var contentType string

	contentType = "application/json"
	b, err := json.Marshal(req.JobParameters)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/jobs"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-job-id"); s != "" {

		resp.JobID = &s

	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// InitiateMultipartUpload this operation initiates a multipart upload.
// Amazon Glacier creates a multipart upload resource and returns its ID in
// the response. The multipart upload ID is used in subsequent requests to
// upload parts of an archive (see UploadMultipartPart When you initiate a
// multipart upload, you specify the part size in number of bytes. The part
// size must be a megabyte (1024 KB) multiplied by a power of 2-for
// example, 1048576 (1 2097152 (2 4194304 (4 8388608 (8 and so on. The
// minimum allowable part size is 1 MB, and the maximum is 4 Every part you
// upload to this resource (see UploadMultipartPart ), except the last one,
// must have the same size. The last one can be the same size or smaller.
// For example, suppose you want to upload a 16.2 MB file. If you initiate
// the multipart upload with a part size of 4 MB, you will upload four
// parts of 4 MB each and one part of 0.2 MB. You don't need to know the
// size of the archive when you start a multipart upload because Amazon
// Glacier does not require you to specify the overall archive size. After
// you complete the multipart upload, Amazon Glacier removes the multipart
// upload resource referenced by the ID. Amazon Glacier also removes the
// multipart upload resource if you cancel the multipart upload or it may
// be removed if there is no activity for a period of 24 hours. An AWS
// account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management users don't have any
// permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and
// underlying go to Uploading Large Archives in Parts (Multipart Upload)
// and Initiate Multipart Upload in the Amazon Glacier Developer Guide
func (c *Glacier) InitiateMultipartUpload(req *InitiateMultipartUploadInput) (resp *InitiateMultipartUploadOutput, err error) {
	resp = &InitiateMultipartUploadOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/multipart-uploads"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ArchiveDescription != nil {
		httpReq.Header.Set("x-amz-archive-description", *req.ArchiveDescription)
	}

	if req.PartSize != nil {
		httpReq.Header.Set("x-amz-part-size", *req.PartSize)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	if s := httpResp.Header.Get("x-amz-multipart-upload-id"); s != "" {

		resp.UploadID = &s

	}

	return
}

// ListJobs this operation lists jobs for a vault, including jobs that are
// in-progress and jobs that have recently finished. Amazon Glacier retains
// recently completed jobs for a period before deleting them; however, it
// eventually removes completed jobs. The output of completed jobs can be
// retrieved. Retaining completed jobs for a period of time after they have
// completed enables you to get a job output in the event you miss the job
// completion notification or your first attempt to download it fails. For
// example, suppose you start an archive retrieval job to download an
// archive. After the job completes, you start to download the archive but
// encounter a network error. In this scenario, you can retry and download
// the archive while the job exists. To retrieve an archive or retrieve a
// vault inventory from Amazon Glacier, you first initiate a job, and after
// the job completes, you download the data. For an archive retrieval, the
// output is the archive data, and for an inventory retrieval, it is the
// inventory list. The List Job operation returns a list of these jobs
// sorted by job initiation time. This List Jobs operation supports
// pagination. By default, this operation returns up to 1,000 jobs in the
// response. You should always check the response for a marker at which to
// continue the list; if there are no more items the marker is null . To
// return a list of jobs that begins at a specific job, set the marker
// request parameter to the value you obtained from a previous List Jobs
// request. You can also limit the number of jobs returned in the response
// by specifying the limit parameter in the request. Additionally, you can
// filter the jobs list returned by specifying an optional statuscode
// (InProgress, Succeeded, or Failed) and completed (true, false)
// parameter. The statuscode allows you to specify that only jobs that
// match a specified status are returned. The completed parameter allows
// you to specify that only jobs in a specific completion state are
// returned. An AWS account has full permission to perform all operations
// (actions). However, AWS Identity and Access Management users don't have
// any permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For the underlying go to List Jobs
func (c *Glacier) ListJobs(req *ListJobsInput) (resp *ListJobsOutput, err error) {
	resp = &ListJobsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/jobs"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if req.Completed != nil {
		q.Set("completed", *req.Completed)
	}

	if req.Limit != nil {
		q.Set("limit", *req.Limit)
	}

	if req.Marker != nil {
		q.Set("marker", *req.Marker)
	}

	if req.Statuscode != nil {
		q.Set("statuscode", *req.Statuscode)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListMultipartUploads this operation lists in-progress multipart uploads
// for the specified vault. An in-progress multipart upload is a multipart
// upload that has been initiated by an InitiateMultipartUpload request,
// but has not yet been completed or aborted. The list returned in the List
// Multipart Upload response has no guaranteed order. The List Multipart
// Uploads operation supports pagination. By default, this operation
// returns up to 1,000 multipart uploads in the response. You should always
// check the response for a marker at which to continue the list; if there
// are no more items the marker is null . To return a list of multipart
// uploads that begins at a specific upload, set the marker request
// parameter to the value you obtained from a previous List Multipart
// Upload request. You can also limit the number of uploads returned in the
// response by specifying the limit parameter in the request. Note the
// difference between this operation and listing parts ListParts ). The
// List Multipart Uploads operation lists all multipart uploads for a vault
// and does not require a multipart upload ID. The List Parts operation
// requires a multipart upload ID since parts are associated with a single
// upload. An AWS account has full permission to perform all operations
// (actions). However, AWS Identity and Access Management users don't have
// any permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and the
// underlying go to Working with Archives in Amazon Glacier and List
// Multipart Uploads in the Amazon Glacier Developer Guide
func (c *Glacier) ListMultipartUploads(req *ListMultipartUploadsInput) (resp *ListMultipartUploadsOutput, err error) {
	resp = &ListMultipartUploadsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/multipart-uploads"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if req.Limit != nil {
		q.Set("limit", *req.Limit)
	}

	if req.Marker != nil {
		q.Set("marker", *req.Marker)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListParts this operation lists the parts of an archive that have been
// uploaded in a specific multipart upload. You can make this request at
// any time during an in-progress multipart upload before you complete the
// upload (see CompleteMultipartUpload . List Parts returns an error for
// completed uploads. The list returned in the List Parts response is
// sorted by part range. The List Parts operation supports pagination. By
// default, this operation returns up to 1,000 uploaded parts in the
// response. You should always check the response for a marker at which to
// continue the list; if there are no more items the marker is null . To
// return a list of parts that begins at a specific part, set the marker
// request parameter to the value you obtained from a previous List Parts
// request. You can also limit the number of parts returned in the response
// by specifying the limit parameter in the request. An AWS account has
// full permission to perform all operations (actions). However, AWS
// Identity and Access Management users don't have any permissions by
// default. You must grant them explicit permission to perform specific
// actions. For more information, see Access Control Using AWS Identity and
// Access Management For conceptual information and the underlying go to
// Working with Archives in Amazon Glacier and List Parts in the Amazon
// Glacier Developer Guide
func (c *Glacier) ListParts(req *ListPartsInput) (resp *ListPartsOutput, err error) {
	resp = &ListPartsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.UploadID != nil {
		uri = strings.Replace(uri, "{"+"uploadId"+"}", aws.EscapePath(*req.UploadID), -1)
		uri = strings.Replace(uri, "{"+"uploadId+"+"}", aws.EscapePath(*req.UploadID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if req.Limit != nil {
		q.Set("limit", *req.Limit)
	}

	if req.Marker != nil {
		q.Set("marker", *req.Marker)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListVaults this operation lists all vaults owned by the calling user's
// account. The list returned in the response is ASCII-sorted by vault
// name. By default, this operation returns up to 1,000 items. If there are
// more vaults to list, the response marker field contains the vault Amazon
// Resource Name at which to continue the list with a new List Vaults
// request; otherwise, the marker field is null . To return a list of
// vaults that begins at a specific vault, set the marker request parameter
// to the vault ARN you obtained from a previous List Vaults request. You
// can also limit the number of vaults returned in the response by
// specifying the limit parameter in the request. An AWS account has full
// permission to perform all operations (actions). However, AWS Identity
// and Access Management users don't have any permissions by default. You
// must grant them explicit permission to perform specific actions. For
// more information, see Access Control Using AWS Identity and Access
// Management For conceptual information and underlying go to Retrieving
// Vault Metadata in Amazon Glacier and List Vaults in the Amazon Glacier
// Developer Guide .
func (c *Glacier) ListVaults(req *ListVaultsInput) (resp *ListVaultsOutput, err error) {
	resp = &ListVaultsOutput{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/vaults"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	q := url.Values{}

	if req.Limit != nil {
		q.Set("limit", *req.Limit)
	}

	if req.Marker != nil {
		q.Set("marker", *req.Marker)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// SetDataRetrievalPolicy <nil>
func (c *Glacier) SetDataRetrievalPolicy(req *SetDataRetrievalPolicyInput) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/{accountId}/policies/data-retrieval"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// SetVaultNotifications this operation configures notifications that will
// be sent when specific events happen to a vault. By default, you don't
// get any notifications. To configure vault notifications, send a PUT
// request to the notification-configuration subresource of the vault. The
// request should include a document that provides an Amazon SNS topic and
// specific events for which you want Amazon Glacier to send notifications
// to the topic. Amazon SNS topics must grant permission to the vault to be
// allowed to publish notifications to the topic. You can configure a vault
// to publish a notification for the following vault events:
// ArchiveRetrievalCompleted This event occurs when a job that was
// initiated for an archive retrieval is completed InitiateJob ). The
// status of the completed job can be "Succeeded" or "Failed". The
// notification sent to the SNS topic is the same output as returned from
// DescribeJob . InventoryRetrievalCompleted This event occurs when a job
// that was initiated for an inventory retrieval is completed InitiateJob
// ). The status of the completed job can be "Succeeded" or "Failed". The
// notification sent to the SNS topic is the same output as returned from
// DescribeJob . An AWS account has full permission to perform all
// operations (actions). However, AWS Identity and Access Management users
// don't have any permissions by default. You must grant them explicit
// permission to perform specific actions. For more information, see Access
// Control Using AWS Identity and Access Management For conceptual
// information and underlying go to Configuring Vault Notifications in
// Amazon Glacier and Set Vault Notification Configuration in the Amazon
// Glacier Developer Guide .
func (c *Glacier) SetVaultNotifications(req *SetVaultNotificationsInput) (err error) {
	// NRE

	var body io.Reader
	var contentType string

	contentType = "application/json"
	b, err := json.Marshal(req.VaultNotificationConfig)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/notification-configuration"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	return
}

// UploadArchive this operation adds an archive to a vault. This is a
// synchronous operation, and for a successful upload, your data is durably
// persisted. Amazon Glacier returns the archive ID in the x-amz-archive-id
// header of the response. You must use the archive ID to access your data
// in Amazon Glacier. After you upload an archive, you should save the
// archive ID returned so that you can retrieve or delete the archive
// later. Besides saving the archive ID, you can also index it and give it
// a friendly name to allow for better searching. You can also use the
// optional archive description field to specify how the archive is
// referred to in an external index of archives, such as you might create
// in Amazon DynamoDB. You can also get the vault inventory to obtain a
// list of archive IDs in a vault. For more information, see InitiateJob .
// You must provide a SHA256 tree hash of the data you are uploading. For
// information about computing a SHA256 tree hash, see Computing Checksums
// . You can optionally specify an archive description of up to 1,024
// printable characters. You can get the archive description when you
// either retrieve the archive or get the vault inventory. For more
// information, see InitiateJob . Amazon Glacier does not interpret the
// description in any way. An archive description does not need to be
// unique. You cannot use the description to retrieve or sort the archive
// list. Archives are immutable. After you upload an archive, you cannot
// edit the archive or its description. An AWS account has full permission
// to perform all operations (actions). However, AWS Identity and Access
// Management users don't have any permissions by default. You must grant
// them explicit permission to perform specific actions. For more
// information, see Access Control Using AWS Identity and Access Management
// For conceptual information and underlying go to Uploading an Archive in
// Amazon Glacier and Upload Archive in the Amazon Glacier Developer Guide
// .
func (c *Glacier) UploadArchive(req *UploadArchiveInput) (resp *ArchiveCreationOutput, err error) {
	resp = &ArchiveCreationOutput{}

	var body io.Reader
	var contentType string

	contentType = "application/json"
	b, err := json.Marshal(req.Body)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/archives"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.ArchiveDescription != nil {
		httpReq.Header.Set("x-amz-archive-description", *req.ArchiveDescription)
	}

	if req.Checksum != nil {
		httpReq.Header.Set("x-amz-sha256-tree-hash", *req.Checksum)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-archive-id"); s != "" {

		resp.ArchiveID = &s

	}

	if s := httpResp.Header.Get("x-amz-sha256-tree-hash"); s != "" {

		resp.Checksum = &s

	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// UploadMultipartPart this operation uploads a part of an archive. You can
// upload archive parts in any order. You can also upload them in parallel.
// You can upload up to 10,000 parts for a multipart upload. Amazon Glacier
// rejects your upload part request if any of the following conditions is
// true: SHA256 tree hash does not match To ensure that part data is not
// corrupted in transmission, you compute a SHA256 tree hash of the part
// and include it in your request. Upon receiving the part data, Amazon
// Glacier also computes a SHA256 tree hash. If these hash values don't
// match, the operation fails. For information about computing a SHA256
// tree hash, see Computing Checksums Part size does not match The size of
// each part except the last must match the size specified in the
// corresponding InitiateMultipartUpload request. The size of the last part
// must be the same size as, or smaller than, the specified size. If you
// upload a part whose size is smaller than the part size you specified in
// your initiate multipart upload request and that part is not the last
// part, then the upload part request will succeed. However, the subsequent
// Complete Multipart Upload request will fail. Range does not align The
// byte range value in the request does not align with the part size
// specified in the corresponding initiate request. For example, if you
// specify a part size of 4194304 bytes (4 then 0 to 4194303 bytes (4 MB -
// 1) and 4194304 (4 MB) to 8388607 (8 MB - 1) are valid part ranges.
// However, if you set a range value of 2 MB to 6 MB, the range does not
// align with the part size and the upload will fail. This operation is
// idempotent. If you upload the same part multiple times, the data
// included in the most recent request overwrites the previously uploaded
// data. An AWS account has full permission to perform all operations
// (actions). However, AWS Identity and Access Management users don't have
// any permissions by default. You must grant them explicit permission to
// perform specific actions. For more information, see Access Control Using
// AWS Identity and Access Management For conceptual information and
// underlying go to Uploading Large Archives in Parts (Multipart Upload)
// and Upload Part in the Amazon Glacier Developer Guide
func (c *Glacier) UploadMultipartPart(req *UploadMultipartPartInput) (resp *UploadMultipartPartOutput, err error) {
	resp = &UploadMultipartPartOutput{}

	var body io.Reader
	var contentType string

	contentType = "application/json"
	b, err := json.Marshal(req.Body)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}"

	if req.AccountID != nil {
		uri = strings.Replace(uri, "{"+"accountId"+"}", aws.EscapePath(*req.AccountID), -1)
		uri = strings.Replace(uri, "{"+"accountId+"+"}", aws.EscapePath(*req.AccountID), -1)
	}

	if req.UploadID != nil {
		uri = strings.Replace(uri, "{"+"uploadId"+"}", aws.EscapePath(*req.UploadID), -1)
		uri = strings.Replace(uri, "{"+"uploadId+"+"}", aws.EscapePath(*req.UploadID), -1)
	}

	if req.VaultName != nil {
		uri = strings.Replace(uri, "{"+"vaultName"+"}", aws.EscapePath(*req.VaultName), -1)
		uri = strings.Replace(uri, "{"+"vaultName+"+"}", aws.EscapePath(*req.VaultName), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("PUT", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	if req.Checksum != nil {
		httpReq.Header.Set("x-amz-sha256-tree-hash", *req.Checksum)
	}

	if req.Range != nil {
		httpReq.Header.Set("Content-Range", *req.Range)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()

	if e := json.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("x-amz-sha256-tree-hash"); s != "" {

		resp.Checksum = &s

	}

	return
}

// AbortMultipartUploadInput is undocumented.
type AbortMultipartUploadInput struct {
	AccountID aws.StringValue `json:"-"`
	UploadID  aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// Possible values for Glacier.
const (
	ActionCodeArchiveRetrieval   = "ArchiveRetrieval"
	ActionCodeInventoryRetrieval = "InventoryRetrieval"
)

// ArchiveCreationOutput is undocumented.
type ArchiveCreationOutput struct {
	ArchiveID aws.StringValue `json:"-"`
	Checksum  aws.StringValue `json:"-"`
	Location  aws.StringValue `json:"-"`
}

// CompleteMultipartUploadInput is undocumented.
type CompleteMultipartUploadInput struct {
	AccountID   aws.StringValue `json:"-"`
	ArchiveSize aws.StringValue `json:"-"`
	Checksum    aws.StringValue `json:"-"`
	UploadID    aws.StringValue `json:"-"`
	VaultName   aws.StringValue `json:"-"`
}

// CreateVaultInput is undocumented.
type CreateVaultInput struct {
	AccountID aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// CreateVaultOutput is undocumented.
type CreateVaultOutput struct {
	Location aws.StringValue `json:"-"`
}

// DataRetrievalPolicy is undocumented.
type DataRetrievalPolicy struct {
	Rules []DataRetrievalRule `json:"Rules,omitempty"`
}

// DataRetrievalRule is undocumented.
type DataRetrievalRule struct {
	BytesPerHour aws.LongValue   `json:"BytesPerHour,omitempty"`
	Strategy     aws.StringValue `json:"Strategy,omitempty"`
}

// DeleteArchiveInput is undocumented.
type DeleteArchiveInput struct {
	AccountID aws.StringValue `json:"-"`
	ArchiveID aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// DeleteVaultInput is undocumented.
type DeleteVaultInput struct {
	AccountID aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// DeleteVaultNotificationsInput is undocumented.
type DeleteVaultNotificationsInput struct {
	AccountID aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// DescribeJobInput is undocumented.
type DescribeJobInput struct {
	AccountID aws.StringValue `json:"-"`
	JobID     aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// DescribeVaultInput is undocumented.
type DescribeVaultInput struct {
	AccountID aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// DescribeVaultOutput is undocumented.
type DescribeVaultOutput struct {
	CreationDate      aws.StringValue `json:"CreationDate,omitempty"`
	LastInventoryDate aws.StringValue `json:"LastInventoryDate,omitempty"`
	NumberOfArchives  aws.LongValue   `json:"NumberOfArchives,omitempty"`
	SizeInBytes       aws.LongValue   `json:"SizeInBytes,omitempty"`
	VaultARN          aws.StringValue `json:"VaultARN,omitempty"`
	VaultName         aws.StringValue `json:"VaultName,omitempty"`
}

// GetDataRetrievalPolicyInput is undocumented.
type GetDataRetrievalPolicyInput struct {
	AccountID aws.StringValue `json:"-"`
}

// GetDataRetrievalPolicyOutput is undocumented.
type GetDataRetrievalPolicyOutput struct {
	Policy *DataRetrievalPolicy `json:"Policy,omitempty"`
}

// GetJobOutputInput is undocumented.
type GetJobOutputInput struct {
	AccountID aws.StringValue `json:"-"`
	JobID     aws.StringValue `json:"-"`
	Range     aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// GetJobOutputOutput is undocumented.
type GetJobOutputOutput struct {
	AcceptRanges       aws.StringValue  `json:"-"`
	ArchiveDescription aws.StringValue  `json:"-"`
	Body               []byte           `json:"body,omitempty"`
	Checksum           aws.StringValue  `json:"-"`
	ContentRange       aws.StringValue  `json:"-"`
	ContentType        aws.StringValue  `json:"-"`
	Status             aws.IntegerValue `json:"-"`
}

// GetVaultNotificationsInput is undocumented.
type GetVaultNotificationsInput struct {
	AccountID aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// GetVaultNotificationsOutput is undocumented.
type GetVaultNotificationsOutput struct {
	VaultNotificationConfig *VaultNotificationConfig `json:"vaultNotificationConfig,omitempty"`
}

// GlacierJobDescription is undocumented.
type GlacierJobDescription struct {
	Action                       aws.StringValue                   `json:"Action,omitempty"`
	ArchiveID                    aws.StringValue                   `json:"ArchiveId,omitempty"`
	ArchiveSHA256TreeHash        aws.StringValue                   `json:"ArchiveSHA256TreeHash,omitempty"`
	ArchiveSizeInBytes           aws.LongValue                     `json:"ArchiveSizeInBytes,omitempty"`
	Completed                    aws.BooleanValue                  `json:"Completed,omitempty"`
	CompletionDate               aws.StringValue                   `json:"CompletionDate,omitempty"`
	CreationDate                 aws.StringValue                   `json:"CreationDate,omitempty"`
	InventoryRetrievalParameters *InventoryRetrievalJobDescription `json:"InventoryRetrievalParameters,omitempty"`
	InventorySizeInBytes         aws.LongValue                     `json:"InventorySizeInBytes,omitempty"`
	JobDescription               aws.StringValue                   `json:"JobDescription,omitempty"`
	JobID                        aws.StringValue                   `json:"JobId,omitempty"`
	RetrievalByteRange           aws.StringValue                   `json:"RetrievalByteRange,omitempty"`
	SHA256TreeHash               aws.StringValue                   `json:"SHA256TreeHash,omitempty"`
	SNSTopic                     aws.StringValue                   `json:"SNSTopic,omitempty"`
	StatusCode                   aws.StringValue                   `json:"StatusCode,omitempty"`
	StatusMessage                aws.StringValue                   `json:"StatusMessage,omitempty"`
	VaultARN                     aws.StringValue                   `json:"VaultARN,omitempty"`
}

// InitiateJobInput is undocumented.
type InitiateJobInput struct {
	AccountID     aws.StringValue `json:"-"`
	JobParameters *JobParameters  `json:"jobParameters,omitempty"`
	VaultName     aws.StringValue `json:"-"`
}

// InitiateJobOutput is undocumented.
type InitiateJobOutput struct {
	JobID    aws.StringValue `json:"-"`
	Location aws.StringValue `json:"-"`
}

// InitiateMultipartUploadInput is undocumented.
type InitiateMultipartUploadInput struct {
	AccountID          aws.StringValue `json:"-"`
	ArchiveDescription aws.StringValue `json:"-"`
	PartSize           aws.StringValue `json:"-"`
	VaultName          aws.StringValue `json:"-"`
}

// InitiateMultipartUploadOutput is undocumented.
type InitiateMultipartUploadOutput struct {
	Location aws.StringValue `json:"-"`
	UploadID aws.StringValue `json:"-"`
}

// InventoryRetrievalJobDescription is undocumented.
type InventoryRetrievalJobDescription struct {
	EndDate   aws.StringValue `json:"EndDate,omitempty"`
	Format    aws.StringValue `json:"Format,omitempty"`
	Limit     aws.StringValue `json:"Limit,omitempty"`
	Marker    aws.StringValue `json:"Marker,omitempty"`
	StartDate aws.StringValue `json:"StartDate,omitempty"`
}

// InventoryRetrievalJobInput is undocumented.
type InventoryRetrievalJobInput struct {
	EndDate   aws.StringValue `json:"EndDate,omitempty"`
	Limit     aws.StringValue `json:"Limit,omitempty"`
	Marker    aws.StringValue `json:"Marker,omitempty"`
	StartDate aws.StringValue `json:"StartDate,omitempty"`
}

// JobParameters is undocumented.
type JobParameters struct {
	ArchiveID                    aws.StringValue             `json:"ArchiveId,omitempty"`
	Description                  aws.StringValue             `json:"Description,omitempty"`
	Format                       aws.StringValue             `json:"Format,omitempty"`
	InventoryRetrievalParameters *InventoryRetrievalJobInput `json:"InventoryRetrievalParameters,omitempty"`
	RetrievalByteRange           aws.StringValue             `json:"RetrievalByteRange,omitempty"`
	SNSTopic                     aws.StringValue             `json:"SNSTopic,omitempty"`
	Type                         aws.StringValue             `json:"Type,omitempty"`
}

// ListJobsInput is undocumented.
type ListJobsInput struct {
	AccountID  aws.StringValue `json:"-"`
	Completed  aws.StringValue `json:"-"`
	Limit      aws.StringValue `json:"-"`
	Marker     aws.StringValue `json:"-"`
	Statuscode aws.StringValue `json:"-"`
	VaultName  aws.StringValue `json:"-"`
}

// ListJobsOutput is undocumented.
type ListJobsOutput struct {
	JobList []GlacierJobDescription `json:"JobList,omitempty"`
	Marker  aws.StringValue         `json:"Marker,omitempty"`
}

// ListMultipartUploadsInput is undocumented.
type ListMultipartUploadsInput struct {
	AccountID aws.StringValue `json:"-"`
	Limit     aws.StringValue `json:"-"`
	Marker    aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// ListMultipartUploadsOutput is undocumented.
type ListMultipartUploadsOutput struct {
	Marker      aws.StringValue     `json:"Marker,omitempty"`
	UploadsList []UploadListElement `json:"UploadsList,omitempty"`
}

// ListPartsInput is undocumented.
type ListPartsInput struct {
	AccountID aws.StringValue `json:"-"`
	Limit     aws.StringValue `json:"-"`
	Marker    aws.StringValue `json:"-"`
	UploadID  aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// ListPartsOutput is undocumented.
type ListPartsOutput struct {
	ArchiveDescription aws.StringValue   `json:"ArchiveDescription,omitempty"`
	CreationDate       aws.StringValue   `json:"CreationDate,omitempty"`
	Marker             aws.StringValue   `json:"Marker,omitempty"`
	MultipartUploadID  aws.StringValue   `json:"MultipartUploadId,omitempty"`
	PartSizeInBytes    aws.LongValue     `json:"PartSizeInBytes,omitempty"`
	Parts              []PartListElement `json:"Parts,omitempty"`
	VaultARN           aws.StringValue   `json:"VaultARN,omitempty"`
}

// ListVaultsInput is undocumented.
type ListVaultsInput struct {
	AccountID aws.StringValue `json:"-"`
	Limit     aws.StringValue `json:"-"`
	Marker    aws.StringValue `json:"-"`
}

// ListVaultsOutput is undocumented.
type ListVaultsOutput struct {
	Marker    aws.StringValue       `json:"Marker,omitempty"`
	VaultList []DescribeVaultOutput `json:"VaultList,omitempty"`
}

// PartListElement is undocumented.
type PartListElement struct {
	RangeInBytes   aws.StringValue `json:"RangeInBytes,omitempty"`
	SHA256TreeHash aws.StringValue `json:"SHA256TreeHash,omitempty"`
}

// SetDataRetrievalPolicyInput is undocumented.
type SetDataRetrievalPolicyInput struct {
	Policy    *DataRetrievalPolicy `json:"Policy,omitempty"`
	AccountID aws.StringValue      `json:"-"`
}

// SetVaultNotificationsInput is undocumented.
type SetVaultNotificationsInput struct {
	AccountID               aws.StringValue          `json:"-"`
	VaultName               aws.StringValue          `json:"-"`
	VaultNotificationConfig *VaultNotificationConfig `json:"vaultNotificationConfig,omitempty"`
}

// Possible values for Glacier.
const (
	StatusCodeFailed     = "Failed"
	StatusCodeInProgress = "InProgress"
	StatusCodeSucceeded  = "Succeeded"
)

// UploadArchiveInput is undocumented.
type UploadArchiveInput struct {
	AccountID          aws.StringValue `json:"-"`
	ArchiveDescription aws.StringValue `json:"-"`
	Body               []byte          `json:"body,omitempty"`
	Checksum           aws.StringValue `json:"-"`
	VaultName          aws.StringValue `json:"-"`
}

// UploadListElement is undocumented.
type UploadListElement struct {
	ArchiveDescription aws.StringValue `json:"ArchiveDescription,omitempty"`
	CreationDate       aws.StringValue `json:"CreationDate,omitempty"`
	MultipartUploadID  aws.StringValue `json:"MultipartUploadId,omitempty"`
	PartSizeInBytes    aws.LongValue   `json:"PartSizeInBytes,omitempty"`
	VaultARN           aws.StringValue `json:"VaultARN,omitempty"`
}

// UploadMultipartPartInput is undocumented.
type UploadMultipartPartInput struct {
	AccountID aws.StringValue `json:"-"`
	Body      []byte          `json:"body,omitempty"`
	Checksum  aws.StringValue `json:"-"`
	Range     aws.StringValue `json:"-"`
	UploadID  aws.StringValue `json:"-"`
	VaultName aws.StringValue `json:"-"`
}

// UploadMultipartPartOutput is undocumented.
type UploadMultipartPartOutput struct {
	Checksum aws.StringValue `json:"-"`
}

// VaultNotificationConfig is undocumented.
type VaultNotificationConfig struct {
	Events   []string        `json:"Events,omitempty"`
	SNSTopic aws.StringValue `json:"SNSTopic,omitempty"`
}

// avoid errors if the packages aren't referenced
var _ time.Time

var _ bytes.Reader
var _ url.URL
var _ fmt.Stringer
var _ strings.Reader
var _ strconv.NumError
var _ = ioutil.Discard
var _ json.RawMessage
