// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package route53 provides a client for Amazon Route 53.
package route53

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"bytes"
	"encoding/xml"
	"fmt"
	"io"
	"io/ioutil"
	"net/url"
	"strconv"
	"strings"
)

// Route53 is a client for Amazon Route 53.
type Route53 struct {
	client *aws.RestClient
}

// New returns a new Route53 client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *Route53 {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("route53", region)

	return &Route53{
		client: &aws.RestClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2013-04-01",
		},
	}
}

// AssociateVPCWithHostedZone this action associates a VPC with an hosted
// zone. To associate a VPC with an hosted zone, send a request to the
// 2013-04-01/hostedzone/ hosted zone /associatevpc resource. The request
// body must include an XML document with a
// AssociateVPCWithHostedZoneRequest element. The response returns the
// AssociateVPCWithHostedZoneResponse element that contains ChangeInfo for
// you to track the progress of the AssociateVPCWithHostedZoneRequest you
// made. See GetChange operation for how to track the progress of your
// change.
func (c *Route53) AssociateVPCWithHostedZone(req *AssociateVPCWithHostedZoneRequest) (resp *AssociateVPCWithHostedZoneResponse, err error) {
	resp = &AssociateVPCWithHostedZoneResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "AssociateVPCWithHostedZoneRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/hostedzone/{Id}/associatevpc"

	if req.HostedZoneID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.HostedZoneID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.HostedZoneID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ChangeResourceRecordSets use this action to create or change your
// authoritative DNS information. To use this action, send a request to the
// 2013-04-01/hostedzone/ hosted Zone /rrset resource. The request body
// must include an XML document with a ChangeResourceRecordSetsRequest
// element. Changes are a list of change items and are considered
// transactional. For more information on transactional changes, also known
// as change batches, see Creating, Changing, and Deleting Resource Record
// Sets Using the Route 53 in the Amazon Route 53 Developer Guide Due to
// the nature of transactional changes, you cannot delete the same resource
// record set more than once in a single change batch. If you attempt to
// delete the same change batch more than once, Route 53 returns an
// InvalidChangeBatch error. In response to a ChangeResourceRecordSets
// request, your DNS data is changed on all Route 53 DNS servers.
// Initially, the status of a change is . This means the change has not yet
// propagated to all the authoritative Route 53 DNS servers. When the
// change is propagated to all hosts, the change returns a status of Note
// the following limitations on a ChangeResourceRecordSets request: - A
// request cannot contain more than 100 Change elements. - A request cannot
// contain more than 1000 ResourceRecord elements. The sum of the number of
// characters (including spaces) in all Value elements in a request cannot
// exceed 32,000 characters.
func (c *Route53) ChangeResourceRecordSets(req *ChangeResourceRecordSetsRequest) (resp *ChangeResourceRecordSetsResponse, err error) {
	resp = &ChangeResourceRecordSetsResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "ChangeResourceRecordSetsRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/hostedzone/{Id}/rrset/"

	if req.HostedZoneID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.HostedZoneID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.HostedZoneID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ChangeTagsForResource <nil>
func (c *Route53) ChangeTagsForResource(req *ChangeTagsForResourceRequest) (resp *ChangeTagsForResourceResponse, err error) {
	resp = &ChangeTagsForResourceResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "ChangeTagsForResourceRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/tags/{ResourceType}/{ResourceId}"

	if req.ResourceID != nil {
		uri = strings.Replace(uri, "{"+"ResourceId"+"}", aws.EscapePath(*req.ResourceID), -1)
		uri = strings.Replace(uri, "{"+"ResourceId+"+"}", aws.EscapePath(*req.ResourceID), -1)
	}

	if req.ResourceType != nil {
		uri = strings.Replace(uri, "{"+"ResourceType"+"}", aws.EscapePath(*req.ResourceType), -1)
		uri = strings.Replace(uri, "{"+"ResourceType+"+"}", aws.EscapePath(*req.ResourceType), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// CreateHealthCheck this action creates a new health check. To create a
// new health check, send a request to the 2013-04-01/healthcheck resource.
// The request body must include an XML document with a
// CreateHealthCheckRequest element. The response returns the
// CreateHealthCheckResponse element that contains metadata about the
// health check.
func (c *Route53) CreateHealthCheck(req *CreateHealthCheckRequest) (resp *CreateHealthCheckResponse, err error) {
	resp = &CreateHealthCheckResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "CreateHealthCheckRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/healthcheck"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// CreateHostedZone this action creates a new hosted zone. To create a new
// hosted zone, send a request to the 2013-04-01/hostedzone resource. The
// request body must include an XML document with a CreateHostedZoneRequest
// element. The response returns the CreateHostedZoneResponse element that
// contains metadata about the hosted zone. Route 53 automatically creates
// a default SOA record and four NS records for the zone. The NS records in
// the hosted zone are the name servers you give your registrar to delegate
// your domain to. For more information about SOA and NS records, see NS
// and SOA Records that Route 53 Creates for a Hosted Zone in the Amazon
// Route 53 Developer Guide When you create a zone, its initial status is .
// This means that it is not yet available on all DNS servers. The status
// of the zone changes to when the NS and SOA records are available on all
// Route 53 DNS servers. When trying to create a hosted zone using a
// reusable delegation set, you could specify an optional DelegationSetId,
// and Route53 would assign those 4 NS records for the zone, instead of
// alloting a new one.
func (c *Route53) CreateHostedZone(req *CreateHostedZoneRequest) (resp *CreateHostedZoneResponse, err error) {
	resp = &CreateHostedZoneResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "CreateHostedZoneRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/hostedzone"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// CreateReusableDelegationSet this action creates a reusable
// delegationSet. To create a new reusable delegationSet, send a request to
// the 2013-04-01/delegationset resource. The request body must include an
// XML document with a CreateReusableDelegationSetRequest element. The
// response returns the CreateReusableDelegationSetResponse element that
// contains metadata about the delegationSet. If the optional parameter
// HostedZoneId is specified, it marks the delegationSet associated with
// that particular hosted zone as reusable.
func (c *Route53) CreateReusableDelegationSet(req *CreateReusableDelegationSetRequest) (resp *CreateReusableDelegationSetResponse, err error) {
	resp = &CreateReusableDelegationSetResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "CreateReusableDelegationSetRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/delegationset"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	if s := httpResp.Header.Get("Location"); s != "" {

		resp.Location = &s

	}

	return
}

// DeleteHealthCheck this action deletes a health check. To delete a health
// check, send a request to the 2013-04-01/healthcheck/ health check
// resource. You can delete a health check only if there are no resource
// record sets associated with this health check. If resource record sets
// are associated with this health check, you must disassociate them before
// you can delete your health check. If you try to delete a health check
// that is associated with resource record sets, Route 53 will deny your
// request with a HealthCheckInUse error. For information about
// disassociating the records from your health check, see
// ChangeResourceRecordSets
func (c *Route53) DeleteHealthCheck(req *DeleteHealthCheckRequest) (resp *DeleteHealthCheckResponse, err error) {
	resp = &DeleteHealthCheckResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/healthcheck/{HealthCheckId}"

	if req.HealthCheckID != nil {
		uri = strings.Replace(uri, "{"+"HealthCheckId"+"}", aws.EscapePath(*req.HealthCheckID), -1)
		uri = strings.Replace(uri, "{"+"HealthCheckId+"+"}", aws.EscapePath(*req.HealthCheckID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// DeleteHostedZone this action deletes a hosted zone. To delete a hosted
// zone, send a request to the 2013-04-01/hostedzone/ hosted zone resource.
// For more information about deleting a hosted zone, see Deleting a Hosted
// Zone in the Amazon Route 53 Developer Guide You can delete a hosted zone
// only if there are no resource record sets other than the default SOA
// record and NS resource record sets. If your hosted zone contains other
// resource record sets, you must delete them before you can delete your
// hosted zone. If you try to delete a hosted zone that contains other
// resource record sets, Route 53 will deny your request with a
// HostedZoneNotEmpty error. For information about deleting records from
// your hosted zone, see ChangeResourceRecordSets
func (c *Route53) DeleteHostedZone(req *DeleteHostedZoneRequest) (resp *DeleteHostedZoneResponse, err error) {
	resp = &DeleteHostedZoneResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/hostedzone/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// DeleteReusableDelegationSet this action deletes a reusable delegation
// set. To delete a reusable delegation set, send a request to the
// 2013-04-01/delegationset/ delegation set resource. You can delete a
// reusable delegation set only if there are no associated hosted zones. If
// your reusable delegation set contains associated hosted zones, you must
// delete them before you can delete your reusable delegation set. If you
// try to delete a reusable delegation set that contains associated hosted
// zones, Route 53 will deny your request with a DelegationSetInUse error.
func (c *Route53) DeleteReusableDelegationSet(req *DeleteReusableDelegationSetRequest) (resp *DeleteReusableDelegationSetResponse, err error) {
	resp = &DeleteReusableDelegationSetResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/delegationset/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("DELETE", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// DisassociateVPCFromHostedZone this action disassociates a VPC from an
// hosted zone. To disassociate a VPC to a hosted zone, send a request to
// the 2013-04-01/hostedzone/ hosted zone /disassociatevpc resource. The
// request body must include an XML document with a
// DisassociateVPCFromHostedZoneRequest element. The response returns the
// DisassociateVPCFromHostedZoneResponse element that contains ChangeInfo
// for you to track the progress of the
// DisassociateVPCFromHostedZoneRequest you made. See GetChange operation
// for how to track the progress of your change.
func (c *Route53) DisassociateVPCFromHostedZone(req *DisassociateVPCFromHostedZoneRequest) (resp *DisassociateVPCFromHostedZoneResponse, err error) {
	resp = &DisassociateVPCFromHostedZoneResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "DisassociateVPCFromHostedZoneRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/hostedzone/{Id}/disassociatevpc"

	if req.HostedZoneID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.HostedZoneID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.HostedZoneID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetChange this action returns the current status of a change batch
// request. The status is one of the following values: - indicates that the
// changes in this request have not replicated to all Route 53 DNS servers.
// This is the initial status of all change batch requests. - indicates
// that the changes have replicated to all Amazon Route 53 DNS servers.
func (c *Route53) GetChange(req *GetChangeRequest) (resp *GetChangeResponse, err error) {
	resp = &GetChangeResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/change/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetCheckerIPRanges to retrieve a list of the IP ranges used by Amazon
// Route 53 health checkers to check the health of your resources, send a
// request to the 2013-04-01/checkeripranges resource. You can use these IP
// addresses to configure router and firewall rules to allow health
// checkers to check the health of your resources.
func (c *Route53) GetCheckerIPRanges(req *GetCheckerIPRangesRequest) (resp *GetCheckerIPRangesResponse, err error) {
	resp = &GetCheckerIPRangesResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/checkeripranges"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetGeoLocation to retrieve a single geo location, send a request to the
// 2013-04-01/geolocation resource with one of these options: continentcode
// | countrycode | countrycode and subdivisioncode.
func (c *Route53) GetGeoLocation(req *GetGeoLocationRequest) (resp *GetGeoLocationResponse, err error) {
	resp = &GetGeoLocationResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/geolocation"

	q := url.Values{}

	if req.ContinentCode != nil {
		q.Set("continentcode", *req.ContinentCode)
	}

	if req.CountryCode != nil {
		q.Set("countrycode", *req.CountryCode)
	}

	if req.SubdivisionCode != nil {
		q.Set("subdivisioncode", *req.SubdivisionCode)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetHealthCheck to retrieve the health check, send a request to the
// 2013-04-01/healthcheck/ health check resource.
func (c *Route53) GetHealthCheck(req *GetHealthCheckRequest) (resp *GetHealthCheckResponse, err error) {
	resp = &GetHealthCheckResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/healthcheck/{HealthCheckId}"

	if req.HealthCheckID != nil {
		uri = strings.Replace(uri, "{"+"HealthCheckId"+"}", aws.EscapePath(*req.HealthCheckID), -1)
		uri = strings.Replace(uri, "{"+"HealthCheckId+"+"}", aws.EscapePath(*req.HealthCheckID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetHealthCheckCount to retrieve a count of all your health checks, send
// a request to the 2013-04-01/healthcheckcount resource.
func (c *Route53) GetHealthCheckCount(req *GetHealthCheckCountRequest) (resp *GetHealthCheckCountResponse, err error) {
	resp = &GetHealthCheckCountResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/healthcheckcount"

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetHealthCheckLastFailureReason if you want to learn why a health check
// is currently failing or why it failed most recently (if at all), you can
// get the failure reason for the most recent failure. Send a request to
// the 2013-04-01/healthcheck/ health check /lastfailurereason resource.
func (c *Route53) GetHealthCheckLastFailureReason(req *GetHealthCheckLastFailureReasonRequest) (resp *GetHealthCheckLastFailureReasonResponse, err error) {
	resp = &GetHealthCheckLastFailureReasonResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason"

	if req.HealthCheckID != nil {
		uri = strings.Replace(uri, "{"+"HealthCheckId"+"}", aws.EscapePath(*req.HealthCheckID), -1)
		uri = strings.Replace(uri, "{"+"HealthCheckId+"+"}", aws.EscapePath(*req.HealthCheckID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetHealthCheckStatus to retrieve the health check status, send a request
// to the 2013-04-01/healthcheck/ health check /status resource. You can
// use this call to get a health check's current status.
func (c *Route53) GetHealthCheckStatus(req *GetHealthCheckStatusRequest) (resp *GetHealthCheckStatusResponse, err error) {
	resp = &GetHealthCheckStatusResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/healthcheck/{HealthCheckId}/status"

	if req.HealthCheckID != nil {
		uri = strings.Replace(uri, "{"+"HealthCheckId"+"}", aws.EscapePath(*req.HealthCheckID), -1)
		uri = strings.Replace(uri, "{"+"HealthCheckId+"+"}", aws.EscapePath(*req.HealthCheckID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetHostedZone to retrieve the delegation set for a hosted zone, send a
// request to the 2013-04-01/hostedzone/ hosted zone resource. The
// delegation set is the four Route 53 name servers that were assigned to
// the hosted zone when you created it.
func (c *Route53) GetHostedZone(req *GetHostedZoneRequest) (resp *GetHostedZoneResponse, err error) {
	resp = &GetHostedZoneResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/hostedzone/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// GetReusableDelegationSet to retrieve the reusable delegation set, send a
// request to the 2013-04-01/delegationset/ delegation set resource.
func (c *Route53) GetReusableDelegationSet(req *GetReusableDelegationSetRequest) (resp *GetReusableDelegationSetResponse, err error) {
	resp = &GetReusableDelegationSetResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/delegationset/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListGeoLocations to retrieve a list of supported geo locations, send a
// request to the 2013-04-01/geolocations resource. The response to this
// request includes a GeoLocationDetailsList element with zero, one, or
// multiple GeoLocationDetails child elements. The list is sorted by
// country code, and then subdivision code, followed by continents at the
// end of the list. By default, the list of geo locations is displayed on a
// single page. You can control the length of the page that is displayed by
// using the MaxItems parameter. If the list is truncated, IsTruncated will
// be set to true and a combination of NextContinentCode, NextCountryCode,
// NextSubdivisionCode will be populated. You can pass these as parameters
// to StartContinentCode, StartCountryCode, StartSubdivisionCode to control
// the geo location that the list begins with.
func (c *Route53) ListGeoLocations(req *ListGeoLocationsRequest) (resp *ListGeoLocationsResponse, err error) {
	resp = &ListGeoLocationsResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/geolocations"

	q := url.Values{}

	if req.MaxItems != nil {
		q.Set("maxitems", *req.MaxItems)
	}

	if req.StartContinentCode != nil {
		q.Set("startcontinentcode", *req.StartContinentCode)
	}

	if req.StartCountryCode != nil {
		q.Set("startcountrycode", *req.StartCountryCode)
	}

	if req.StartSubdivisionCode != nil {
		q.Set("startsubdivisioncode", *req.StartSubdivisionCode)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListHealthChecks to retrieve a list of your health checks, send a
// request to the 2013-04-01/healthcheck resource. The response to this
// request includes a HealthChecks element with zero, one, or multiple
// HealthCheck child elements. By default, the list of health checks is
// displayed on a single page. You can control the length of the page that
// is displayed by using the MaxItems parameter. You can use the Marker
// parameter to control the health check that the list begins with. Amazon
// Route 53 returns a maximum of 100 items. If you set MaxItems to a value
// greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListHealthChecks(req *ListHealthChecksRequest) (resp *ListHealthChecksResponse, err error) {
	resp = &ListHealthChecksResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/healthcheck"

	q := url.Values{}

	if req.Marker != nil {
		q.Set("marker", *req.Marker)
	}

	if req.MaxItems != nil {
		q.Set("maxitems", *req.MaxItems)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListHostedZones to retrieve a list of your hosted zones, send a request
// to the 2013-04-01/hostedzone resource. The response to this request
// includes a HostedZones element with zero, one, or multiple HostedZone
// child elements. By default, the list of hosted zones is displayed on a
// single page. You can control the length of the page that is displayed by
// using the MaxItems parameter. You can use the Marker parameter to
// control the hosted zone that the list begins with. Amazon Route 53
// returns a maximum of 100 items. If you set MaxItems to a value greater
// than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListHostedZones(req *ListHostedZonesRequest) (resp *ListHostedZonesResponse, err error) {
	resp = &ListHostedZonesResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/hostedzone"

	q := url.Values{}

	if req.DelegationSetID != nil {
		q.Set("delegationsetid", *req.DelegationSetID)
	}

	if req.Marker != nil {
		q.Set("marker", *req.Marker)
	}

	if req.MaxItems != nil {
		q.Set("maxitems", *req.MaxItems)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListResourceRecordSets imagine all the resource record sets in a zone
// listed out in front of you. Imagine them sorted lexicographically first
// by DNS name (with the labels reversed, like "com.amazon.www" for
// example), and secondarily, lexicographically by record type. This
// operation retrieves at most MaxItems resource record sets from this
// list, in order, starting at a position specified by the Name and Type
// arguments: If both Name and Type are omitted, this means start the
// results at the first in the HostedZone. If Name is specified but Type is
// omitted, this means start the results at the first in the list whose
// name is greater than or equal to Name. If both Name and Type are
// specified, this means start the results at the first in the list whose
// name is greater than or equal to Name and whose type is greater than or
// equal to Type. It is an error to specify the Type but not the Name. Use
// ListResourceRecordSets to retrieve a single known record set by
// specifying the record set's name and type, and setting MaxItems = 1 To
// retrieve all the records in a HostedZone, first pause any processes
// making calls to ChangeResourceRecordSets. Initially call
// ListResourceRecordSets without a Name and Type to get the first page of
// record sets. For subsequent calls, set Name and Type to the NextName and
// NextType values returned by the previous response. In the presence of
// concurrent ChangeResourceRecordSets calls, there is no consistency of
// results across calls to ListResourceRecordSets. The only way to get a
// consistent multi-page snapshot of all RRSETs in a zone is to stop making
// changes while pagination is in progress. However, the results from
// ListResourceRecordSets are consistent within a page. If MakeChange calls
// are taking place concurrently, the result of each one will either be
// completely visible in your results or not at all. You will not see
// partial changes, or changes that do not ultimately succeed. (This
// follows from the fact that MakeChange is atomic) The results from
// ListResourceRecordSets are strongly consistent with
// ChangeResourceRecordSets. To be precise, if a single process makes a
// call to ChangeResourceRecordSets and receives a successful response, the
// effects of that change will be visible in a subsequent call to
// ListResourceRecordSets by that process.
func (c *Route53) ListResourceRecordSets(req *ListResourceRecordSetsRequest) (resp *ListResourceRecordSetsResponse, err error) {
	resp = &ListResourceRecordSetsResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/hostedzone/{Id}/rrset"

	if req.HostedZoneID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.HostedZoneID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.HostedZoneID), -1)
	}

	q := url.Values{}

	if req.MaxItems != nil {
		q.Set("maxitems", *req.MaxItems)
	}

	if req.StartRecordIdentifier != nil {
		q.Set("identifier", *req.StartRecordIdentifier)
	}

	if req.StartRecordName != nil {
		q.Set("name", *req.StartRecordName)
	}

	if req.StartRecordType != nil {
		q.Set("type", *req.StartRecordType)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListReusableDelegationSets to retrieve a list of your reusable
// delegation sets, send a request to the 2013-04-01/delegationset
// resource. The response to this request includes a DelegationSets element
// with zero, one, or multiple DelegationSet child elements. By default,
// the list of delegation sets is displayed on a single page. You can
// control the length of the page that is displayed by using the MaxItems
// parameter. You can use the Marker parameter to control the delegation
// set that the list begins with. Amazon Route 53 returns a maximum of 100
// items. If you set MaxItems to a value greater than 100, Amazon Route 53
// returns only the first 100.
func (c *Route53) ListReusableDelegationSets(req *ListReusableDelegationSetsRequest) (resp *ListReusableDelegationSetsResponse, err error) {
	resp = &ListReusableDelegationSetsResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/delegationset"

	q := url.Values{}

	if req.Marker != nil {
		q.Set("marker", *req.Marker)
	}

	if req.MaxItems != nil {
		q.Set("maxitems", *req.MaxItems)
	}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListTagsForResource <nil>
func (c *Route53) ListTagsForResource(req *ListTagsForResourceRequest) (resp *ListTagsForResourceResponse, err error) {
	resp = &ListTagsForResourceResponse{}

	var body io.Reader
	var contentType string

	uri := c.client.Endpoint + "/2013-04-01/tags/{ResourceType}/{ResourceId}"

	if req.ResourceID != nil {
		uri = strings.Replace(uri, "{"+"ResourceId"+"}", aws.EscapePath(*req.ResourceID), -1)
		uri = strings.Replace(uri, "{"+"ResourceId+"+"}", aws.EscapePath(*req.ResourceID), -1)
	}

	if req.ResourceType != nil {
		uri = strings.Replace(uri, "{"+"ResourceType"+"}", aws.EscapePath(*req.ResourceType), -1)
		uri = strings.Replace(uri, "{"+"ResourceType+"+"}", aws.EscapePath(*req.ResourceType), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("GET", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// ListTagsForResources <nil>
func (c *Route53) ListTagsForResources(req *ListTagsForResourcesRequest) (resp *ListTagsForResourcesResponse, err error) {
	resp = &ListTagsForResourcesResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "ListTagsForResourcesRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/tags/{ResourceType}"

	if req.ResourceType != nil {
		uri = strings.Replace(uri, "{"+"ResourceType"+"}", aws.EscapePath(*req.ResourceType), -1)
		uri = strings.Replace(uri, "{"+"ResourceType+"+"}", aws.EscapePath(*req.ResourceType), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// UpdateHealthCheck this action updates an existing health check. To
// update a health check, send a request to the 2013-04-01/healthcheck/
// health check resource. The request body must include an XML document
// with an UpdateHealthCheckRequest element. The response returns an
// UpdateHealthCheckResponse element, which contains metadata about the
// health check.
func (c *Route53) UpdateHealthCheck(req *UpdateHealthCheckRequest) (resp *UpdateHealthCheckResponse, err error) {
	resp = &UpdateHealthCheckResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "UpdateHealthCheckRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/healthcheck/{HealthCheckId}"

	if req.HealthCheckID != nil {
		uri = strings.Replace(uri, "{"+"HealthCheckId"+"}", aws.EscapePath(*req.HealthCheckID), -1)
		uri = strings.Replace(uri, "{"+"HealthCheckId+"+"}", aws.EscapePath(*req.HealthCheckID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// UpdateHostedZoneComment to update the hosted zone comment, send a
// request to the 2013-04-01/hostedzone/ hosted zone resource. The request
// body must include an XML document with a UpdateHostedZoneCommentRequest
// element. The response to this request includes the modified HostedZone
// element. The comment can have a maximum length of 256 characters.
func (c *Route53) UpdateHostedZoneComment(req *UpdateHostedZoneCommentRequest) (resp *UpdateHostedZoneCommentResponse, err error) {
	resp = &UpdateHostedZoneCommentResponse{}

	var body io.Reader
	var contentType string

	contentType = "application/xml"
	req.XMLName = xml.Name{
		Space: "https://route53.amazonaws.com/doc/2013-04-01/",
		Local: "UpdateHostedZoneCommentRequest",
	}
	b, err := xml.Marshal(req)
	if err != nil {
		return
	}
	body = bytes.NewReader(b)

	uri := c.client.Endpoint + "/2013-04-01/hostedzone/{Id}"

	if req.ID != nil {
		uri = strings.Replace(uri, "{"+"Id"+"}", aws.EscapePath(*req.ID), -1)
		uri = strings.Replace(uri, "{"+"Id+"+"}", aws.EscapePath(*req.ID), -1)
	}

	q := url.Values{}

	if len(q) > 0 {
		uri += "?" + q.Encode()
	}

	httpReq, err := http.NewRequest("POST", uri, body)
	if err != nil {
		return
	}

	if contentType != "" {
		httpReq.Header.Set("Content-Type", contentType)
	}

	httpResp, err := c.client.Do(httpReq)
	if err != nil {
		return
	}

	defer httpResp.Body.Close()
	if e := xml.NewDecoder(httpResp.Body).Decode(resp); e != nil && e != io.EOF {
		err = e
		return
	}

	return
}

// AliasTarget is undocumented.
type AliasTarget struct {
	XMLName xml.Name

	DNSName              aws.StringValue  `xml:"DNSName"`
	EvaluateTargetHealth aws.BooleanValue `xml:"EvaluateTargetHealth"`
	HostedZoneID         aws.StringValue  `xml:"HostedZoneId"`
}

func (v *AliasTarget) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// AssociateVPCWithHostedZoneRequest is undocumented.
type AssociateVPCWithHostedZoneRequest struct {
	XMLName xml.Name

	Comment      aws.StringValue `xml:"Comment"`
	HostedZoneID aws.StringValue `xml:"-"`
	VPC          *VPC            `xml:"VPC,omitempty"`
}

func (v *AssociateVPCWithHostedZoneRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// AssociateVPCWithHostedZoneResponse is undocumented.
type AssociateVPCWithHostedZoneResponse struct {
	XMLName xml.Name

	ChangeInfo *ChangeInfo `xml:"ChangeInfo,omitempty"`
}

func (v *AssociateVPCWithHostedZoneResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Change is undocumented.
type Change struct {
	XMLName xml.Name

	Action            aws.StringValue    `xml:"Action"`
	ResourceRecordSet *ResourceRecordSet `xml:"ResourceRecordSet,omitempty"`
}

func (v *Change) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for Route53.
const (
	ChangeActionCreate = "CREATE"
	ChangeActionDelete = "DELETE"
	ChangeActionUpsert = "UPSERT"
)

// ChangeBatch is undocumented.
type ChangeBatch struct {
	XMLName xml.Name

	Changes []Change        `xml:"Changes>Change,omitempty"`
	Comment aws.StringValue `xml:"Comment"`
}

func (v *ChangeBatch) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ChangeInfo is undocumented.
type ChangeInfo struct {
	XMLName xml.Name

	Comment     aws.StringValue `xml:"Comment"`
	ID          aws.StringValue `xml:"Id"`
	Status      aws.StringValue `xml:"Status"`
	SubmittedAt time.Time       `xml:"SubmittedAt"`
}

func (v *ChangeInfo) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ChangeResourceRecordSetsRequest is undocumented.
type ChangeResourceRecordSetsRequest struct {
	XMLName xml.Name

	ChangeBatch  *ChangeBatch    `xml:"ChangeBatch,omitempty"`
	HostedZoneID aws.StringValue `xml:"-"`
}

func (v *ChangeResourceRecordSetsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ChangeResourceRecordSetsResponse is undocumented.
type ChangeResourceRecordSetsResponse struct {
	XMLName xml.Name

	ChangeInfo *ChangeInfo `xml:"ChangeInfo,omitempty"`
}

func (v *ChangeResourceRecordSetsResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for Route53.
const (
	ChangeStatusInsync  = "INSYNC"
	ChangeStatusPending = "PENDING"
)

// ChangeTagsForResourceRequest is undocumented.
type ChangeTagsForResourceRequest struct {
	XMLName xml.Name

	AddTags       []Tag           `xml:"AddTags>Tag,omitempty"`
	RemoveTagKeys []string        `xml:"RemoveTagKeys>Key,omitempty"`
	ResourceID    aws.StringValue `xml:"-"`
	ResourceType  aws.StringValue `xml:"-"`
}

func (v *ChangeTagsForResourceRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ChangeTagsForResourceResponse is undocumented.
type ChangeTagsForResourceResponse struct {
	XMLName xml.Name
}

func (v *ChangeTagsForResourceResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateHealthCheckRequest is undocumented.
type CreateHealthCheckRequest struct {
	XMLName xml.Name

	CallerReference   aws.StringValue    `xml:"CallerReference"`
	HealthCheckConfig *HealthCheckConfig `xml:"HealthCheckConfig,omitempty"`
}

func (v *CreateHealthCheckRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateHealthCheckResponse is undocumented.
type CreateHealthCheckResponse struct {
	XMLName xml.Name

	HealthCheck *HealthCheck    `xml:"HealthCheck,omitempty"`
	Location    aws.StringValue `xml:"-"`
}

func (v *CreateHealthCheckResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateHostedZoneRequest is undocumented.
type CreateHostedZoneRequest struct {
	XMLName xml.Name

	CallerReference  aws.StringValue   `xml:"CallerReference"`
	DelegationSetID  aws.StringValue   `xml:"DelegationSetId"`
	HostedZoneConfig *HostedZoneConfig `xml:"HostedZoneConfig,omitempty"`
	Name             aws.StringValue   `xml:"Name"`
	VPC              *VPC              `xml:"VPC,omitempty"`
}

func (v *CreateHostedZoneRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateHostedZoneResponse is undocumented.
type CreateHostedZoneResponse struct {
	XMLName xml.Name

	ChangeInfo    *ChangeInfo     `xml:"ChangeInfo,omitempty"`
	DelegationSet *DelegationSet  `xml:"DelegationSet,omitempty"`
	HostedZone    *HostedZone     `xml:"HostedZone,omitempty"`
	Location      aws.StringValue `xml:"-"`
	VPC           *VPC            `xml:"VPC,omitempty"`
}

func (v *CreateHostedZoneResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateReusableDelegationSetRequest is undocumented.
type CreateReusableDelegationSetRequest struct {
	XMLName xml.Name

	CallerReference aws.StringValue `xml:"CallerReference"`
	HostedZoneID    aws.StringValue `xml:"HostedZoneId"`
}

func (v *CreateReusableDelegationSetRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// CreateReusableDelegationSetResponse is undocumented.
type CreateReusableDelegationSetResponse struct {
	XMLName xml.Name

	DelegationSet *DelegationSet  `xml:"DelegationSet,omitempty"`
	Location      aws.StringValue `xml:"-"`
}

func (v *CreateReusableDelegationSetResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DelegationSet is undocumented.
type DelegationSet struct {
	XMLName xml.Name

	CallerReference aws.StringValue `xml:"CallerReference"`
	ID              aws.StringValue `xml:"Id"`
	NameServers     []string        `xml:"NameServers>NameServer,omitempty"`
}

func (v *DelegationSet) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteHealthCheckRequest is undocumented.
type DeleteHealthCheckRequest struct {
	XMLName xml.Name

	HealthCheckID aws.StringValue `xml:"-"`
}

func (v *DeleteHealthCheckRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteHealthCheckResponse is undocumented.
type DeleteHealthCheckResponse struct {
	XMLName xml.Name
}

func (v *DeleteHealthCheckResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteHostedZoneRequest is undocumented.
type DeleteHostedZoneRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *DeleteHostedZoneRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteHostedZoneResponse is undocumented.
type DeleteHostedZoneResponse struct {
	XMLName xml.Name

	ChangeInfo *ChangeInfo `xml:"ChangeInfo,omitempty"`
}

func (v *DeleteHostedZoneResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteReusableDelegationSetRequest is undocumented.
type DeleteReusableDelegationSetRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *DeleteReusableDelegationSetRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DeleteReusableDelegationSetResponse is undocumented.
type DeleteReusableDelegationSetResponse struct {
	XMLName xml.Name
}

func (v *DeleteReusableDelegationSetResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DisassociateVPCFromHostedZoneRequest is undocumented.
type DisassociateVPCFromHostedZoneRequest struct {
	XMLName xml.Name

	Comment      aws.StringValue `xml:"Comment"`
	HostedZoneID aws.StringValue `xml:"-"`
	VPC          *VPC            `xml:"VPC,omitempty"`
}

func (v *DisassociateVPCFromHostedZoneRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// DisassociateVPCFromHostedZoneResponse is undocumented.
type DisassociateVPCFromHostedZoneResponse struct {
	XMLName xml.Name

	ChangeInfo *ChangeInfo `xml:"ChangeInfo,omitempty"`
}

func (v *DisassociateVPCFromHostedZoneResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GeoLocation is undocumented.
type GeoLocation struct {
	XMLName xml.Name

	ContinentCode   aws.StringValue `xml:"ContinentCode"`
	CountryCode     aws.StringValue `xml:"CountryCode"`
	SubdivisionCode aws.StringValue `xml:"SubdivisionCode"`
}

func (v *GeoLocation) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GeoLocationDetails is undocumented.
type GeoLocationDetails struct {
	XMLName xml.Name

	ContinentCode   aws.StringValue `xml:"ContinentCode"`
	ContinentName   aws.StringValue `xml:"ContinentName"`
	CountryCode     aws.StringValue `xml:"CountryCode"`
	CountryName     aws.StringValue `xml:"CountryName"`
	SubdivisionCode aws.StringValue `xml:"SubdivisionCode"`
	SubdivisionName aws.StringValue `xml:"SubdivisionName"`
}

func (v *GeoLocationDetails) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetChangeRequest is undocumented.
type GetChangeRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetChangeRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetChangeResponse is undocumented.
type GetChangeResponse struct {
	XMLName xml.Name

	ChangeInfo *ChangeInfo `xml:"ChangeInfo,omitempty"`
}

func (v *GetChangeResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetCheckerIPRangesRequest is undocumented.
type GetCheckerIPRangesRequest struct {
	XMLName xml.Name
}

func (v *GetCheckerIPRangesRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetCheckerIPRangesResponse is undocumented.
type GetCheckerIPRangesResponse struct {
	XMLName xml.Name

	CheckerIPRanges []string `xml:"CheckerIpRanges,omitempty"`
}

func (v *GetCheckerIPRangesResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetGeoLocationRequest is undocumented.
type GetGeoLocationRequest struct {
	XMLName xml.Name

	ContinentCode   aws.StringValue `xml:"-"`
	CountryCode     aws.StringValue `xml:"-"`
	SubdivisionCode aws.StringValue `xml:"-"`
}

func (v *GetGeoLocationRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetGeoLocationResponse is undocumented.
type GetGeoLocationResponse struct {
	XMLName xml.Name

	GeoLocationDetails *GeoLocationDetails `xml:"GeoLocationDetails,omitempty"`
}

func (v *GetGeoLocationResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHealthCheckCountRequest is undocumented.
type GetHealthCheckCountRequest struct {
	XMLName xml.Name
}

func (v *GetHealthCheckCountRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHealthCheckCountResponse is undocumented.
type GetHealthCheckCountResponse struct {
	XMLName xml.Name

	HealthCheckCount aws.LongValue `xml:"HealthCheckCount"`
}

func (v *GetHealthCheckCountResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHealthCheckLastFailureReasonRequest is undocumented.
type GetHealthCheckLastFailureReasonRequest struct {
	XMLName xml.Name

	HealthCheckID aws.StringValue `xml:"-"`
}

func (v *GetHealthCheckLastFailureReasonRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHealthCheckLastFailureReasonResponse is undocumented.
type GetHealthCheckLastFailureReasonResponse struct {
	XMLName xml.Name

	HealthCheckObservations []HealthCheckObservation `xml:"HealthCheckObservations>HealthCheckObservation,omitempty"`
}

func (v *GetHealthCheckLastFailureReasonResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHealthCheckRequest is undocumented.
type GetHealthCheckRequest struct {
	XMLName xml.Name

	HealthCheckID aws.StringValue `xml:"-"`
}

func (v *GetHealthCheckRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHealthCheckResponse is undocumented.
type GetHealthCheckResponse struct {
	XMLName xml.Name

	HealthCheck *HealthCheck `xml:"HealthCheck,omitempty"`
}

func (v *GetHealthCheckResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHealthCheckStatusRequest is undocumented.
type GetHealthCheckStatusRequest struct {
	XMLName xml.Name

	HealthCheckID aws.StringValue `xml:"-"`
}

func (v *GetHealthCheckStatusRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHealthCheckStatusResponse is undocumented.
type GetHealthCheckStatusResponse struct {
	XMLName xml.Name

	HealthCheckObservations []HealthCheckObservation `xml:"HealthCheckObservations>HealthCheckObservation,omitempty"`
}

func (v *GetHealthCheckStatusResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHostedZoneRequest is undocumented.
type GetHostedZoneRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetHostedZoneRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetHostedZoneResponse is undocumented.
type GetHostedZoneResponse struct {
	XMLName xml.Name

	DelegationSet *DelegationSet `xml:"DelegationSet,omitempty"`
	HostedZone    *HostedZone    `xml:"HostedZone,omitempty"`
	VPCs          []VPC          `xml:"VPCs>VPC,omitempty"`
}

func (v *GetHostedZoneResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetReusableDelegationSetRequest is undocumented.
type GetReusableDelegationSetRequest struct {
	XMLName xml.Name

	ID aws.StringValue `xml:"-"`
}

func (v *GetReusableDelegationSetRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// GetReusableDelegationSetResponse is undocumented.
type GetReusableDelegationSetResponse struct {
	XMLName xml.Name

	DelegationSet *DelegationSet `xml:"DelegationSet,omitempty"`
}

func (v *GetReusableDelegationSetResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// HealthCheck is undocumented.
type HealthCheck struct {
	XMLName xml.Name

	CallerReference    aws.StringValue    `xml:"CallerReference"`
	HealthCheckConfig  *HealthCheckConfig `xml:"HealthCheckConfig,omitempty"`
	HealthCheckVersion aws.LongValue      `xml:"HealthCheckVersion"`
	ID                 aws.StringValue    `xml:"Id"`
}

func (v *HealthCheck) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// HealthCheckConfig is undocumented.
type HealthCheckConfig struct {
	XMLName xml.Name

	FailureThreshold         aws.IntegerValue `xml:"FailureThreshold"`
	FullyQualifiedDomainName aws.StringValue  `xml:"FullyQualifiedDomainName"`
	IPAddress                aws.StringValue  `xml:"IPAddress"`
	Port                     aws.IntegerValue `xml:"Port"`
	RequestInterval          aws.IntegerValue `xml:"RequestInterval"`
	ResourcePath             aws.StringValue  `xml:"ResourcePath"`
	SearchString             aws.StringValue  `xml:"SearchString"`
	Type                     aws.StringValue  `xml:"Type"`
}

func (v *HealthCheckConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// HealthCheckObservation is undocumented.
type HealthCheckObservation struct {
	XMLName xml.Name

	IPAddress    aws.StringValue `xml:"IPAddress"`
	StatusReport *StatusReport   `xml:"StatusReport,omitempty"`
}

func (v *HealthCheckObservation) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for Route53.
const (
	HealthCheckTypeHTTP          = "HTTP"
	HealthCheckTypeHTTPS         = "HTTPS"
	HealthCheckTypeHTTPSStrMatch = "HTTPS_STR_MATCH"
	HealthCheckTypeHTTPStrMatch  = "HTTP_STR_MATCH"
	HealthCheckTypeTCP           = "TCP"
)

// HostedZone is undocumented.
type HostedZone struct {
	XMLName xml.Name

	CallerReference        aws.StringValue   `xml:"CallerReference"`
	Config                 *HostedZoneConfig `xml:"Config,omitempty"`
	ID                     aws.StringValue   `xml:"Id"`
	Name                   aws.StringValue   `xml:"Name"`
	ResourceRecordSetCount aws.LongValue     `xml:"ResourceRecordSetCount"`
}

func (v *HostedZone) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// HostedZoneConfig is undocumented.
type HostedZoneConfig struct {
	XMLName xml.Name

	Comment     aws.StringValue  `xml:"Comment"`
	PrivateZone aws.BooleanValue `xml:"PrivateZone"`
}

func (v *HostedZoneConfig) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListGeoLocationsRequest is undocumented.
type ListGeoLocationsRequest struct {
	XMLName xml.Name

	MaxItems             aws.StringValue `xml:"-"`
	StartContinentCode   aws.StringValue `xml:"-"`
	StartCountryCode     aws.StringValue `xml:"-"`
	StartSubdivisionCode aws.StringValue `xml:"-"`
}

func (v *ListGeoLocationsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListGeoLocationsResponse is undocumented.
type ListGeoLocationsResponse struct {
	XMLName xml.Name

	GeoLocationDetailsList []GeoLocationDetails `xml:"GeoLocationDetailsList>GeoLocationDetails,omitempty"`
	IsTruncated            aws.BooleanValue     `xml:"IsTruncated"`
	MaxItems               aws.StringValue      `xml:"MaxItems"`
	NextContinentCode      aws.StringValue      `xml:"NextContinentCode"`
	NextCountryCode        aws.StringValue      `xml:"NextCountryCode"`
	NextSubdivisionCode    aws.StringValue      `xml:"NextSubdivisionCode"`
}

func (v *ListGeoLocationsResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListHealthChecksRequest is undocumented.
type ListHealthChecksRequest struct {
	XMLName xml.Name

	Marker   aws.StringValue `xml:"-"`
	MaxItems aws.StringValue `xml:"-"`
}

func (v *ListHealthChecksRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListHealthChecksResponse is undocumented.
type ListHealthChecksResponse struct {
	XMLName xml.Name

	HealthChecks []HealthCheck    `xml:"HealthChecks>HealthCheck,omitempty"`
	IsTruncated  aws.BooleanValue `xml:"IsTruncated"`
	Marker       aws.StringValue  `xml:"Marker"`
	MaxItems     aws.StringValue  `xml:"MaxItems"`
	NextMarker   aws.StringValue  `xml:"NextMarker"`
}

func (v *ListHealthChecksResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListHostedZonesRequest is undocumented.
type ListHostedZonesRequest struct {
	XMLName xml.Name

	DelegationSetID aws.StringValue `xml:"-"`
	Marker          aws.StringValue `xml:"-"`
	MaxItems        aws.StringValue `xml:"-"`
}

func (v *ListHostedZonesRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListHostedZonesResponse is undocumented.
type ListHostedZonesResponse struct {
	XMLName xml.Name

	HostedZones []HostedZone     `xml:"HostedZones>HostedZone,omitempty"`
	IsTruncated aws.BooleanValue `xml:"IsTruncated"`
	Marker      aws.StringValue  `xml:"Marker"`
	MaxItems    aws.StringValue  `xml:"MaxItems"`
	NextMarker  aws.StringValue  `xml:"NextMarker"`
}

func (v *ListHostedZonesResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListResourceRecordSetsRequest is undocumented.
type ListResourceRecordSetsRequest struct {
	XMLName xml.Name

	HostedZoneID          aws.StringValue `xml:"-"`
	MaxItems              aws.StringValue `xml:"-"`
	StartRecordIdentifier aws.StringValue `xml:"-"`
	StartRecordName       aws.StringValue `xml:"-"`
	StartRecordType       aws.StringValue `xml:"-"`
}

func (v *ListResourceRecordSetsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListResourceRecordSetsResponse is undocumented.
type ListResourceRecordSetsResponse struct {
	XMLName xml.Name

	IsTruncated          aws.BooleanValue    `xml:"IsTruncated"`
	MaxItems             aws.StringValue     `xml:"MaxItems"`
	NextRecordIdentifier aws.StringValue     `xml:"NextRecordIdentifier"`
	NextRecordName       aws.StringValue     `xml:"NextRecordName"`
	NextRecordType       aws.StringValue     `xml:"NextRecordType"`
	ResourceRecordSets   []ResourceRecordSet `xml:"ResourceRecordSets>ResourceRecordSet,omitempty"`
}

func (v *ListResourceRecordSetsResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListReusableDelegationSetsRequest is undocumented.
type ListReusableDelegationSetsRequest struct {
	XMLName xml.Name

	Marker   aws.StringValue `xml:"-"`
	MaxItems aws.StringValue `xml:"-"`
}

func (v *ListReusableDelegationSetsRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListReusableDelegationSetsResponse is undocumented.
type ListReusableDelegationSetsResponse struct {
	XMLName xml.Name

	DelegationSets []DelegationSet  `xml:"DelegationSets>DelegationSet,omitempty"`
	IsTruncated    aws.BooleanValue `xml:"IsTruncated"`
	Marker         aws.StringValue  `xml:"Marker"`
	MaxItems       aws.StringValue  `xml:"MaxItems"`
	NextMarker     aws.StringValue  `xml:"NextMarker"`
}

func (v *ListReusableDelegationSetsResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListTagsForResourceRequest is undocumented.
type ListTagsForResourceRequest struct {
	XMLName xml.Name

	ResourceID   aws.StringValue `xml:"-"`
	ResourceType aws.StringValue `xml:"-"`
}

func (v *ListTagsForResourceRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListTagsForResourceResponse is undocumented.
type ListTagsForResourceResponse struct {
	XMLName xml.Name

	ResourceTagSet *ResourceTagSet `xml:"ResourceTagSet,omitempty"`
}

func (v *ListTagsForResourceResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListTagsForResourcesRequest is undocumented.
type ListTagsForResourcesRequest struct {
	XMLName xml.Name

	ResourceIDs  []string        `xml:"ResourceIds>ResourceId,omitempty"`
	ResourceType aws.StringValue `xml:"-"`
}

func (v *ListTagsForResourcesRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ListTagsForResourcesResponse is undocumented.
type ListTagsForResourcesResponse struct {
	XMLName xml.Name

	ResourceTagSets []ResourceTagSet `xml:"ResourceTagSets>ResourceTagSet,omitempty"`
}

func (v *ListTagsForResourcesResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for Route53.
const (
	RRTypeA     = "A"
	RRTypeAaaa  = "AAAA"
	RRTypeCname = "CNAME"
	RRTypeMx    = "MX"
	RRTypeNs    = "NS"
	RRTypePtr   = "PTR"
	RRTypeSoa   = "SOA"
	RRTypeSpf   = "SPF"
	RRTypeSrv   = "SRV"
	RRTypeTxt   = "TXT"
)

// ResourceRecord is undocumented.
type ResourceRecord struct {
	XMLName xml.Name

	Value aws.StringValue `xml:"Value"`
}

func (v *ResourceRecord) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// ResourceRecordSet is undocumented.
type ResourceRecordSet struct {
	XMLName xml.Name

	AliasTarget     *AliasTarget     `xml:"AliasTarget,omitempty"`
	Failover        aws.StringValue  `xml:"Failover"`
	GeoLocation     *GeoLocation     `xml:"GeoLocation,omitempty"`
	HealthCheckID   aws.StringValue  `xml:"HealthCheckId"`
	Name            aws.StringValue  `xml:"Name"`
	Region          aws.StringValue  `xml:"Region"`
	ResourceRecords []ResourceRecord `xml:"ResourceRecords>ResourceRecord,omitempty"`
	SetIdentifier   aws.StringValue  `xml:"SetIdentifier"`
	TTL             aws.LongValue    `xml:"TTL"`
	Type            aws.StringValue  `xml:"Type"`
	Weight          aws.LongValue    `xml:"Weight"`
}

func (v *ResourceRecordSet) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for Route53.
const (
	ResourceRecordSetFailoverPrimary   = "PRIMARY"
	ResourceRecordSetFailoverSecondary = "SECONDARY"
)

// Possible values for Route53.
const (
	ResourceRecordSetRegionApNortheast1 = "ap-northeast-1"
	ResourceRecordSetRegionApSoutheast1 = "ap-southeast-1"
	ResourceRecordSetRegionApSoutheast2 = "ap-southeast-2"
	ResourceRecordSetRegionCnNorth1     = "cn-north-1"
	ResourceRecordSetRegionEuCentral1   = "eu-central-1"
	ResourceRecordSetRegionEuWest1      = "eu-west-1"
	ResourceRecordSetRegionSaEast1      = "sa-east-1"
	ResourceRecordSetRegionUsEast1      = "us-east-1"
	ResourceRecordSetRegionUsWest1      = "us-west-1"
	ResourceRecordSetRegionUsWest2      = "us-west-2"
)

// ResourceTagSet is undocumented.
type ResourceTagSet struct {
	XMLName xml.Name

	ResourceID   aws.StringValue `xml:"ResourceId"`
	ResourceType aws.StringValue `xml:"ResourceType"`
	Tags         []Tag           `xml:"Tags>Tag,omitempty"`
}

func (v *ResourceTagSet) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// StatusReport is undocumented.
type StatusReport struct {
	XMLName xml.Name

	CheckedTime time.Time       `xml:"CheckedTime"`
	Status      aws.StringValue `xml:"Status"`
}

func (v *StatusReport) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Tag is undocumented.
type Tag struct {
	XMLName xml.Name

	Key   aws.StringValue `xml:"Key"`
	Value aws.StringValue `xml:"Value"`
}

func (v *Tag) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for Route53.
const (
	TagResourceTypeHealthcheck = "healthcheck"
	TagResourceTypeHostedzone  = "hostedzone"
)

// UpdateHealthCheckRequest is undocumented.
type UpdateHealthCheckRequest struct {
	XMLName xml.Name

	FailureThreshold         aws.IntegerValue `xml:"FailureThreshold"`
	FullyQualifiedDomainName aws.StringValue  `xml:"FullyQualifiedDomainName"`
	HealthCheckID            aws.StringValue  `xml:"-"`
	HealthCheckVersion       aws.LongValue    `xml:"HealthCheckVersion"`
	IPAddress                aws.StringValue  `xml:"IPAddress"`
	Port                     aws.IntegerValue `xml:"Port"`
	ResourcePath             aws.StringValue  `xml:"ResourcePath"`
	SearchString             aws.StringValue  `xml:"SearchString"`
}

func (v *UpdateHealthCheckRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateHealthCheckResponse is undocumented.
type UpdateHealthCheckResponse struct {
	XMLName xml.Name

	HealthCheck *HealthCheck `xml:"HealthCheck,omitempty"`
}

func (v *UpdateHealthCheckResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateHostedZoneCommentRequest is undocumented.
type UpdateHostedZoneCommentRequest struct {
	XMLName xml.Name

	Comment aws.StringValue `xml:"Comment"`
	ID      aws.StringValue `xml:"-"`
}

func (v *UpdateHostedZoneCommentRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// UpdateHostedZoneCommentResponse is undocumented.
type UpdateHostedZoneCommentResponse struct {
	XMLName xml.Name

	HostedZone *HostedZone `xml:"HostedZone,omitempty"`
}

func (v *UpdateHostedZoneCommentResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// VPC is undocumented.
type VPC struct {
	XMLName xml.Name

	VPCID     aws.StringValue `xml:"VPCId"`
	VPCRegion aws.StringValue `xml:"VPCRegion"`
}

func (v *VPC) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	return aws.MarshalXML(v, e, start)
}

// Possible values for Route53.
const (
	VPCRegionApNortheast1 = "ap-northeast-1"
	VPCRegionApSoutheast1 = "ap-southeast-1"
	VPCRegionApSoutheast2 = "ap-southeast-2"
	VPCRegionCnNorth1     = "cn-north-1"
	VPCRegionEuCentral1   = "eu-central-1"
	VPCRegionEuWest1      = "eu-west-1"
	VPCRegionSaEast1      = "sa-east-1"
	VPCRegionUsEast1      = "us-east-1"
	VPCRegionUsWest1      = "us-west-1"
	VPCRegionUsWest2      = "us-west-2"
)

// avoid errors if the packages aren't referenced
var _ time.Time

var _ bytes.Reader
var _ url.URL
var _ fmt.Stringer
var _ strings.Reader
var _ strconv.NumError
var _ = ioutil.Discard
