/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	edgefsrookiov1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSMBs implements SMBInterface
type FakeSMBs struct {
	Fake *FakeEdgefsV1
	ns   string
}

var smbsResource = schema.GroupVersionResource{Group: "edgefs.rook.io", Version: "v1", Resource: "smbs"}

var smbsKind = schema.GroupVersionKind{Group: "edgefs.rook.io", Version: "v1", Kind: "SMB"}

// Get takes name of the sMB, and returns the corresponding sMB object, and an error if there is any.
func (c *FakeSMBs) Get(ctx context.Context, name string, options v1.GetOptions) (result *edgefsrookiov1.SMB, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(smbsResource, c.ns, name), &edgefsrookiov1.SMB{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.SMB), err
}

// List takes label and field selectors, and returns the list of SMBs that match those selectors.
func (c *FakeSMBs) List(ctx context.Context, opts v1.ListOptions) (result *edgefsrookiov1.SMBList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(smbsResource, smbsKind, c.ns, opts), &edgefsrookiov1.SMBList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &edgefsrookiov1.SMBList{ListMeta: obj.(*edgefsrookiov1.SMBList).ListMeta}
	for _, item := range obj.(*edgefsrookiov1.SMBList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested sMBs.
func (c *FakeSMBs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(smbsResource, c.ns, opts))

}

// Create takes the representation of a sMB and creates it.  Returns the server's representation of the sMB, and an error, if there is any.
func (c *FakeSMBs) Create(ctx context.Context, sMB *edgefsrookiov1.SMB, opts v1.CreateOptions) (result *edgefsrookiov1.SMB, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(smbsResource, c.ns, sMB), &edgefsrookiov1.SMB{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.SMB), err
}

// Update takes the representation of a sMB and updates it. Returns the server's representation of the sMB, and an error, if there is any.
func (c *FakeSMBs) Update(ctx context.Context, sMB *edgefsrookiov1.SMB, opts v1.UpdateOptions) (result *edgefsrookiov1.SMB, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(smbsResource, c.ns, sMB), &edgefsrookiov1.SMB{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.SMB), err
}

// Delete takes name of the sMB and deletes it. Returns an error if one occurs.
func (c *FakeSMBs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(smbsResource, c.ns, name), &edgefsrookiov1.SMB{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSMBs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(smbsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &edgefsrookiov1.SMBList{})
	return err
}

// Patch applies the patch and returns the patched sMB.
func (c *FakeSMBs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *edgefsrookiov1.SMB, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(smbsResource, c.ns, name, pt, data, subresources...), &edgefsrookiov1.SMB{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.SMB), err
}
