/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.TypeComponentImpl;
import com.sun.tools.jdi.ValueContainer;

public class FieldImpl
extends TypeComponentImpl
implements Field,
ValueContainer {
    FieldImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, long ref, String name, String signature, String genericSignature, int modifiers) {
        super(vm, declaringType, ref, name, signature, genericSignature, modifiers);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FieldImpl) {
            FieldImpl other = (FieldImpl)obj;
            return this.declaringType().equals(other.declaringType()) && this.ref() == other.ref() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this.ref();
    }

    @Override
    public int compareTo(Field field) {
        ReferenceTypeImpl declaringType = (ReferenceTypeImpl)this.declaringType();
        int rc = declaringType.compareTo(field.declaringType());
        if (rc == 0) {
            rc = declaringType.indexOf(this) - declaringType.indexOf(field);
        }
        return rc;
    }

    @Override
    public Type type() throws ClassNotLoadedException {
        return this.findType(this.signature());
    }

    @Override
    public Type findType(String signature) throws ClassNotLoadedException {
        ReferenceTypeImpl enclosing = (ReferenceTypeImpl)this.declaringType();
        return enclosing.findType(signature);
    }

    @Override
    public String typeName() {
        JNITypeParser parser = new JNITypeParser(this.signature());
        return parser.typeName();
    }

    @Override
    public boolean isTransient() {
        return this.isModifierSet(128);
    }

    @Override
    public boolean isVolatile() {
        return this.isModifierSet(64);
    }

    @Override
    public boolean isEnumConstant() {
        return this.isModifierSet(16384);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.declaringType().name());
        sb.append('.');
        sb.append(this.name());
        return sb.toString();
    }
}

