/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidModuleException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;

class JDWPException
extends Exception {
    private static final long serialVersionUID = -6321344442751299874L;
    short errorCode;

    JDWPException(short errorCode) {
        this.errorCode = errorCode;
    }

    short errorCode() {
        return this.errorCode;
    }

    RuntimeException toJDIException() {
        switch (this.errorCode) {
            case 20: {
                return new ObjectCollectedException();
            }
            case 42: {
                return new InvalidModuleException();
            }
            case 112: {
                return new VMDisconnectedException();
            }
            case 110: {
                return new VMOutOfMemoryException();
            }
            case 22: {
                return new ClassNotPreparedException();
            }
            case 30: 
            case 33: {
                return new InvalidStackFrameException();
            }
            case 99: {
                return new UnsupportedOperationException();
            }
            case 503: 
            case 504: {
                return new IndexOutOfBoundsException();
            }
            case 34: {
                return new InconsistentDebugInfoException();
            }
            case 10: {
                return new IllegalThreadStateException();
            }
        }
        return new InternalException("Unexpected JDWP Error: " + this.errorCode, this.errorCode);
    }
}

