/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.formats.html.AbstractExecutableMemberWriter;
import jdk.javadoc.internal.doclets.formats.html.SectionName;
import jdk.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.ConstructorWriter;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.MemberSummaryWriter;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class ConstructorWriterImpl
extends AbstractExecutableMemberWriter
implements ConstructorWriter,
MemberSummaryWriter {
    private boolean foundNonPubConstructor = false;

    public ConstructorWriterImpl(SubWriterHolderWriter writer, TypeElement typeElement) {
        super(writer, typeElement);
        VisibleMemberMap visibleMemberMap = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.CONSTRUCTORS, this.configuration);
        SortedSet<Element> constructors = visibleMemberMap.getMembersFor(typeElement);
        for (Element constructor : constructors) {
            if (!this.utils.isProtected(constructor) && !this.utils.isPrivate(constructor)) continue;
            this.setFoundNonPubConstructor(true);
        }
    }

    public ConstructorWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    @Override
    public Content getMemberSummaryHeader(TypeElement typeElement, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_CONSTRUCTOR_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, typeElement, memberTree);
        return memberTree;
    }

    @Override
    public void addMemberTree(Content memberSummaryTree, Content memberTree) {
        this.writer.addMemberTree(memberSummaryTree, memberTree);
    }

    @Override
    public Content getConstructorDetailsTreeHeader(TypeElement typeElement, Content memberDetailsTree) {
        memberDetailsTree.addContent(HtmlConstants.START_OF_CONSTRUCTOR_DETAILS);
        Content constructorDetailsTree = this.writer.getMemberTreeHeader();
        constructorDetailsTree.addContent(this.writer.getMarkerAnchor(SectionName.CONSTRUCTOR_DETAIL));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.DETAILS_HEADING, this.writer.constructorDetailsLabel);
        constructorDetailsTree.addContent(heading);
        return constructorDetailsTree;
    }

    @Override
    public Content getConstructorDocTreeHeader(ExecutableElement constructor, Content constructorDetailsTree) {
        String erasureAnchor = this.getErasureAnchor(constructor);
        if (erasureAnchor != null) {
            constructorDetailsTree.addContent(this.writer.getMarkerAnchor(erasureAnchor));
        }
        constructorDetailsTree.addContent(this.writer.getMarkerAnchor(this.writer.getAnchor(constructor)));
        Content constructorDocTree = this.writer.getMemberTreeHeader();
        HtmlTree heading = new HtmlTree(HtmlConstants.MEMBER_HEADING);
        ((Content)heading).addContent(this.name(constructor));
        constructorDocTree.addContent(heading);
        return constructorDocTree;
    }

    @Override
    public Content getSignature(ExecutableElement constructor) {
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.writer.addAnnotationInfo(constructor, (Content)pre);
        int annotationLength = ((Content)pre).charCount();
        this.addModifiers(constructor, pre);
        if (this.configuration.linksource) {
            StringContent constructorName = new StringContent(this.name(constructor));
            this.writer.addSrcLink(constructor, constructorName, pre);
        } else {
            this.addName(this.name(constructor), pre);
        }
        int indent = ((Content)pre).charCount() - annotationLength;
        this.addParameters(constructor, pre, indent);
        this.addExceptions(constructor, pre, indent);
        return pre;
    }

    @Override
    public void setSummaryColumnStyle(HtmlTree tdTree) {
        if (this.foundNonPubConstructor) {
            tdTree.addStyle(HtmlStyle.colLast);
        } else {
            tdTree.addStyle(HtmlStyle.colOne);
        }
    }

    @Override
    public void addDeprecated(ExecutableElement constructor, Content constructorDocTree) {
        this.addDeprecatedInfo(constructor, constructorDocTree);
    }

    @Override
    public void addComments(ExecutableElement constructor, Content constructorDocTree) {
        this.addComment(constructor, constructorDocTree);
    }

    @Override
    public void addTags(ExecutableElement constructor, Content constructorDocTree) {
        this.writer.addTagsInfo(constructor, constructorDocTree);
    }

    @Override
    public Content getConstructorDetails(Content constructorDetailsTree) {
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            HtmlTree htmlTree = HtmlTree.SECTION(this.getMemberTree(constructorDetailsTree));
            return htmlTree;
        }
        return this.getMemberTree(constructorDetailsTree);
    }

    @Override
    public Content getConstructorDoc(Content constructorDocTree, boolean isLastContent) {
        return this.getMemberTree(constructorDocTree, isLastContent);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void setFoundNonPubConstructor(boolean foundNonPubConstructor) {
        this.foundNonPubConstructor = foundNonPubConstructor;
    }

    @Override
    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Constructor_Summary"));
        memberTree.addContent(label);
    }

    @Override
    public String getTableSummary() {
        return this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Constructor_Summary"), this.configuration.getText("doclet.constructors"));
    }

    @Override
    public Content getCaption() {
        return this.configuration.getResource("doclet.Constructors");
    }

    @Override
    public List<String> getSummaryTableHeader(Element member) {
        ArrayList<String> header = new ArrayList<String>();
        if (this.foundNonPubConstructor) {
            header.add(this.configuration.getText("doclet.Modifier"));
        }
        header.add(this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Constructor"), this.configuration.getText("doclet.Description")));
        return header;
    }

    @Override
    public void addSummaryAnchor(TypeElement typeElement, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor(SectionName.CONSTRUCTOR_SUMMARY));
    }

    @Override
    public void addInheritedSummaryAnchor(TypeElement typeElement, Content inheritedTree) {
    }

    @Override
    public void addInheritedSummaryLabel(TypeElement typeElement, Content inheritedTree) {
    }

    @Override
    protected Content getNavSummaryLink(TypeElement typeElement, boolean link) {
        if (link) {
            return this.writer.getHyperLink(SectionName.CONSTRUCTOR_SUMMARY, this.writer.getResource("doclet.navConstructor"));
        }
        return this.writer.getResource("doclet.navConstructor");
    }

    @Override
    protected void addNavDetailLink(boolean link, Content liNav) {
        if (link) {
            liNav.addContent(this.writer.getHyperLink(SectionName.CONSTRUCTOR_DETAIL, this.writer.getResource("doclet.navConstructor")));
        } else {
            liNav.addContent(this.writer.getResource("doclet.navConstructor"));
        }
    }

    @Override
    protected void addSummaryType(Element member, Content tdSummaryType) {
        if (this.foundNonPubConstructor) {
            HtmlTree code = new HtmlTree(HtmlTag.CODE);
            if (this.utils.isProtected(member)) {
                ((Content)code).addContent("protected ");
            } else if (this.utils.isPrivate(member)) {
                ((Content)code).addContent("private ");
            } else if (this.utils.isPublic(member)) {
                ((Content)code).addContent(this.writer.getSpace());
            } else {
                ((Content)code).addContent(this.configuration.getText("doclet.Package_private"));
            }
            tdSummaryType.addContent(code);
        }
    }
}

