/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlAttr;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class FrameOutputWriter
extends HtmlDocletWriter {
    int noOfPackages;

    public FrameOutputWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        this.noOfPackages = configuration.packages.size();
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPath.empty;
        try {
            filename = DocPaths.INDEX;
            FrameOutputWriter framegen = new FrameOutputWriter(configuration, filename);
            framegen.generateFrameFile();
            framegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void generateFrameFile() throws IOException {
        Content frame = this.getFrameDetails();
        HtmlTree body = new HtmlTree(HtmlTag.BODY);
        body.addAttr(HtmlAttr.ONLOAD, "loadFrames()");
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            HtmlTree main = HtmlTree.MAIN(frame);
            body.addContent(main);
        } else {
            body.addContent(frame);
        }
        if (this.configuration.windowtitle.length() > 0) {
            this.printFramesDocument(this.configuration.windowtitle, this.configuration, body);
        } else {
            this.printFramesDocument(this.configuration.getText("doclet.Generated_Docs_Untitled"), this.configuration, body);
        }
    }

    protected Content getFrameDetails() {
        HtmlTree leftContainerDiv = new HtmlTree(HtmlTag.DIV);
        HtmlTree rightContainerDiv = new HtmlTree(HtmlTag.DIV);
        leftContainerDiv.addStyle(HtmlStyle.leftContainer);
        rightContainerDiv.addStyle(HtmlStyle.rightContainer);
        if (this.noOfPackages <= 1) {
            this.addAllClassesFrameTag(leftContainerDiv);
        } else if (this.noOfPackages > 1) {
            this.addAllPackagesFrameTag(leftContainerDiv);
            this.addAllClassesFrameTag(leftContainerDiv);
        }
        this.addClassFrameTag(rightContainerDiv);
        HtmlTree mainContainer = HtmlTree.DIV(HtmlStyle.mainContainer, leftContainerDiv);
        mainContainer.addContent(rightContainerDiv);
        return mainContainer;
    }

    private void addAllPackagesFrameTag(Content contentTree) {
        HtmlTree frame = HtmlTree.IFRAME(DocPaths.OVERVIEW_FRAME.getPath(), "packageListFrame", this.configuration.getText("doclet.All_Packages"));
        HtmlTree leftTop = HtmlTree.DIV(HtmlStyle.leftTop, frame);
        contentTree.addContent(leftTop);
    }

    private void addAllClassesFrameTag(Content contentTree) {
        HtmlTree frame = HtmlTree.IFRAME(DocPaths.ALLCLASSES_FRAME.getPath(), "packageFrame", this.configuration.getText("doclet.All_classes_and_interfaces"));
        HtmlTree leftBottom = HtmlTree.DIV(HtmlStyle.leftBottom, frame);
        contentTree.addContent(leftBottom);
    }

    private void addClassFrameTag(Content contentTree) {
        HtmlTree frame = HtmlTree.IFRAME(this.configuration.topFile.getPath(), "classFrame", this.configuration.getText("doclet.Package_class_and_interface_descriptions"));
        frame.addStyle(HtmlStyle.rightIframe);
        contentTree.addContent(frame);
    }
}

