/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import jdk.javadoc.internal.doclets.toolkit.util.links.LinkInfo;

public class LinkInfoImpl
extends LinkInfo {
    public final ConfigurationImpl configuration;
    public Kind context = Kind.DEFAULT;
    public String where = "";
    public String styleName = "";
    public String target = "";
    public final Utils utils;

    public LinkInfoImpl(ConfigurationImpl configuration, Kind context, ExecutableElement ee) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.executableElement = ee;
        this.setContext(context);
    }

    @Override
    protected Content newContent() {
        return new ContentBuilder();
    }

    public LinkInfoImpl(ConfigurationImpl configuration, Kind context, TypeElement typeElement) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.typeElement = typeElement;
        this.setContext(context);
    }

    public LinkInfoImpl(ConfigurationImpl configuration, Kind context, TypeMirror type) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.type = type;
        this.setContext(context);
    }

    public LinkInfoImpl label(CharSequence label) {
        this.label = new StringContent(label);
        return this;
    }

    public LinkInfoImpl label(Content label) {
        this.label = label;
        return this;
    }

    public LinkInfoImpl strong(boolean strong) {
        this.isStrong = strong;
        return this;
    }

    public LinkInfoImpl styleName(String styleName) {
        this.styleName = styleName;
        return this;
    }

    public LinkInfoImpl target(String target) {
        this.target = target;
        return this;
    }

    public LinkInfoImpl varargs(boolean varargs) {
        this.isVarArg = varargs;
        return this;
    }

    public LinkInfoImpl where(String where) {
        this.where = where;
        return this;
    }

    public Kind getContext() {
        return this.context;
    }

    public final void setContext(Kind c) {
        switch (c) {
            case ALL_CLASSES_FRAME: 
            case PACKAGE_FRAME: 
            case IMPLEMENTED_CLASSES: 
            case SUBCLASSES: 
            case EXECUTABLE_ELEMENT_COPY: 
            case VARIABLE_ELEMENT_COPY: 
            case PROPERTY_COPY: 
            case CLASS_USE_HEADER: {
                this.includeTypeInClassLinkLabel = false;
                break;
            }
            case ANNOTATION: {
                this.excludeTypeParameterLinks = true;
                this.excludeTypeBounds = true;
                break;
            }
            case IMPLEMENTED_INTERFACES: 
            case SUPER_INTERFACES: 
            case SUBINTERFACES: 
            case CLASS_TREE_PARENT: 
            case TREE: 
            case CLASS_SIGNATURE_PARENT_NAME: {
                this.excludeTypeParameterLinks = true;
                this.excludeTypeBounds = true;
                this.includeTypeInClassLinkLabel = false;
                this.includeTypeAsSepLink = true;
                break;
            }
            case PACKAGE: 
            case CLASS_USE: 
            case CLASS_HEADER: 
            case CLASS_SIGNATURE: 
            case RECEIVER_TYPE: {
                this.excludeTypeParameterLinks = true;
                this.includeTypeAsSepLink = true;
                this.includeTypeInClassLinkLabel = false;
                break;
            }
            case MEMBER_TYPE_PARAMS: {
                this.includeTypeAsSepLink = true;
                this.includeTypeInClassLinkLabel = false;
                break;
            }
            case RETURN_TYPE: 
            case SUMMARY_RETURN_TYPE: {
                this.excludeTypeBounds = true;
                break;
            }
            case EXECUTABLE_MEMBER_PARAM: {
                this.excludeTypeBounds = true;
            }
        }
        this.context = c;
        if (this.type != null && this.utils.isTypeVariable(this.type) && this.utils.isExecutableElement(this.utils.asTypeElement(this.type).getEnclosingElement())) {
            this.excludeTypeParameterLinks = true;
        }
    }

    @Override
    public boolean isLinkable() {
        return this.configuration.utils.isLinkable(this.typeElement);
    }

    @Override
    public String toString() {
        return "LinkInfoImpl{context=" + (Object)((Object)this.context) + ", where=" + this.where + ", styleName=" + this.styleName + ", target=" + this.target + super.toString() + '}';
    }

    public static enum Kind {
        DEFAULT,
        ALL_CLASSES_FRAME,
        CLASS,
        MEMBER,
        CLASS_USE,
        INDEX,
        CONSTANT_SUMMARY,
        SERIALIZED_FORM,
        SERIAL_MEMBER,
        PACKAGE,
        SEE_TAG,
        VALUE_TAG,
        TREE,
        PACKAGE_FRAME,
        CLASS_HEADER,
        CLASS_SIGNATURE,
        RETURN_TYPE,
        SUMMARY_RETURN_TYPE,
        EXECUTABLE_MEMBER_PARAM,
        SUPER_INTERFACES,
        IMPLEMENTED_INTERFACES,
        IMPLEMENTED_CLASSES,
        SUBINTERFACES,
        SUBCLASSES,
        CLASS_SIGNATURE_PARENT_NAME,
        EXECUTABLE_ELEMENT_COPY,
        METHOD_SPECIFIED_BY,
        METHOD_OVERRIDES,
        ANNOTATION,
        VARIABLE_ELEMENT_COPY,
        CLASS_TREE_PARENT,
        MEMBER_TYPE_PARAMS,
        CLASS_USE_HEADER,
        PROPERTY_COPY,
        RECEIVER_TYPE;

    }
}

