/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.builders;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jdk.javadoc.internal.doclets.toolkit.ConstantsSummaryWriter;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.XMLNode;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class ConstantsSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "ConstantSummary";
    public static final int MAX_CONSTANT_VALUE_INDEX_LENGTH = 2;
    protected final ConstantsSummaryWriter writer;
    protected final Set<TypeElement> typeElementsWithConstFields;
    protected final Set<PackageElement> printedPackageHeaders;
    private PackageElement currentPackage;
    private TypeElement currentClass;
    private Content contentTree;
    private boolean first = true;

    private ConstantsSummaryBuilder(AbstractBuilder.Context context, ConstantsSummaryWriter writer) {
        super(context);
        this.writer = writer;
        this.typeElementsWithConstFields = new HashSet<TypeElement>();
        this.printedPackageHeaders = new TreeSet<Element>(this.utils.makePackageComparator());
    }

    public static ConstantsSummaryBuilder getInstance(AbstractBuilder.Context context, ConstantsSummaryWriter writer) {
        return new ConstantsSummaryBuilder(context, writer);
    }

    @Override
    public void build() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildConstantSummary(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.writer.getHeader();
        this.buildChildren(node, contentTree);
        this.writer.addFooter(contentTree);
        this.writer.printDocument(contentTree);
        this.writer.close();
    }

    public void buildContents(XMLNode node, Content contentTree) {
        Content contentListTree = this.writer.getContentsHeader();
        this.printedPackageHeaders.clear();
        for (PackageElement pkg : this.configuration.packages) {
            if (!this.hasConstantField(pkg) || this.hasPrintedPackageIndex(pkg)) continue;
            this.writer.addLinkToPackageContent(pkg, this.printedPackageHeaders, contentListTree);
        }
        this.writer.addContentsList(contentTree, contentListTree);
    }

    public void buildConstantSummaries(XMLNode node, Content contentTree) {
        this.printedPackageHeaders.clear();
        Content summariesTree = this.writer.getConstantSummaries();
        for (PackageElement aPackage : this.configuration.packages) {
            if (!this.hasConstantField(aPackage)) continue;
            this.currentPackage = aPackage;
            this.buildChildren(node, summariesTree);
            this.first = false;
        }
        this.writer.addConstantSummaries(contentTree, summariesTree);
    }

    public void buildPackageHeader(XMLNode node, Content summariesTree) {
        String parsedPackageName = this.utils.parsePackageName(this.currentPackage);
        PackageElement p = this.utils.elementUtils.getPackageElement(parsedPackageName);
        if (!this.printedPackageHeaders.contains(p)) {
            this.writer.addPackageName(this.currentPackage, summariesTree, this.first);
            this.printedPackageHeaders.add(p);
        }
    }

    public void buildClassConstantSummary(XMLNode node, Content summariesTree) {
        SortedSet<TypeElement> classes = !this.currentPackage.isUnnamed() ? this.utils.getAllClasses(this.currentPackage) : this.configuration.typeElementCatalog.allUnnamedClasses();
        Content classConstantTree = this.writer.getClassConstantHeader();
        for (TypeElement te : classes) {
            if (!this.typeElementsWithConstFields.contains(te) || !this.utils.isIncluded(te)) continue;
            this.currentClass = te;
            this.buildChildren(node, classConstantTree);
        }
        this.writer.addClassConstant(summariesTree, classConstantTree);
    }

    public void buildConstantMembers(XMLNode node, Content classConstantTree) {
        new ConstantFieldBuilder(this.currentClass).buildMembersSummary(node, classConstantTree);
    }

    private boolean hasConstantField(PackageElement pkg) {
        SortedSet<TypeElement> classes = !pkg.isUnnamed() ? this.utils.getAllClasses(pkg) : this.configuration.typeElementCatalog.allUnnamedClasses();
        boolean found = false;
        for (TypeElement te : classes) {
            if (!this.utils.isIncluded(te) || !this.hasConstantField(te)) continue;
            found = true;
        }
        return found;
    }

    private boolean hasConstantField(TypeElement typeElement) {
        VisibleMemberMap visibleMemberMapFields = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.FIELDS, this.configuration);
        SortedSet<Element> fields = visibleMemberMapFields.getLeafClassMembers();
        for (Element f : fields) {
            VariableElement field = (VariableElement)f;
            if (field.getConstantValue() == null) continue;
            this.typeElementsWithConstFields.add(typeElement);
            return true;
        }
        return false;
    }

    private boolean hasPrintedPackageIndex(PackageElement pkg) {
        for (PackageElement printedPkg : this.printedPackageHeaders) {
            if (!this.utils.getPackageName(pkg).startsWith(this.utils.parsePackageName(printedPkg))) continue;
            return true;
        }
        return false;
    }

    private class ConstantFieldBuilder {
        protected VisibleMemberMap visibleMemberMapFields = null;
        protected VisibleMemberMap visibleMemberMapEnumConst = null;
        protected TypeElement typeElement;

        public ConstantFieldBuilder(TypeElement typeElement) {
            this.typeElement = typeElement;
            this.visibleMemberMapFields = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.FIELDS, ConstantsSummaryBuilder.this.configuration);
            this.visibleMemberMapEnumConst = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.ENUM_CONSTANTS, ConstantsSummaryBuilder.this.configuration);
        }

        protected void buildMembersSummary(XMLNode node, Content classConstantTree) {
            SortedSet<VariableElement> members = this.members();
            if (!members.isEmpty()) {
                ConstantsSummaryBuilder.this.writer.addConstantMembers(this.typeElement, members, classConstantTree);
            }
        }

        protected SortedSet<VariableElement> members() {
            SortedSet<Element> list = this.visibleMemberMapFields.getLeafClassMembers();
            list.addAll(this.visibleMemberMapEnumConst.getLeafClassMembers());
            TreeSet<Element> inclList = new TreeSet<Element>(ConstantsSummaryBuilder.this.utils.makeGeneralPurposeComparator());
            for (Element element : list) {
                VariableElement member = (VariableElement)element;
                if (member.getConstantValue() == null) continue;
                inclList.add(member);
            }
            return inclList;
        }
    }
}

