/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.builders;

import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.toolkit.ConstructorWriter;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractMemberBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.XMLNode;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class ConstructorBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "ConstructorDetails";
    private ExecutableElement constructor;
    private final TypeElement typeElement;
    private final VisibleMemberMap visibleMemberMap;
    private final ConstructorWriter writer;
    private final SortedSet<Element> constructors;

    private ConstructorBuilder(AbstractBuilder.Context context, TypeElement typeElement, ConstructorWriter writer) {
        super(context);
        this.typeElement = typeElement;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.CONSTRUCTORS, this.configuration);
        this.constructors = this.visibleMemberMap.getMembersFor(typeElement);
        for (Element ctor : this.constructors) {
            if (!this.utils.isProtected(ctor) && !this.utils.isPrivate(ctor)) continue;
            writer.setFoundNonPubConstructor(true);
        }
    }

    public static ConstructorBuilder getInstance(AbstractBuilder.Context context, TypeElement typeElement, ConstructorWriter writer) {
        return new ConstructorBuilder(context, typeElement, writer);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean hasMembersToDocument() {
        return !this.constructors.isEmpty();
    }

    public SortedSet<Element> members(TypeElement typeElement) {
        return this.visibleMemberMap.getMembersFor(typeElement);
    }

    public ConstructorWriter getWriter() {
        return this.writer;
    }

    public void buildConstructorDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.constructors.size();
        if (size > 0) {
            Content constructorDetailsTree = this.writer.getConstructorDetailsTreeHeader(this.typeElement, memberDetailsTree);
            for (Element ctor : this.constructors) {
                this.constructor = (ExecutableElement)ctor;
                Content constructorDocTree = this.writer.getConstructorDocTreeHeader(this.constructor, constructorDetailsTree);
                this.buildChildren(node, constructorDocTree);
                constructorDetailsTree.addContent(this.writer.getConstructorDoc(constructorDocTree, this.constructors.last().equals(this.constructor)));
            }
            memberDetailsTree.addContent(this.writer.getConstructorDetails(constructorDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content constructorDocTree) {
        constructorDocTree.addContent(this.writer.getSignature(this.constructor));
    }

    public void buildDeprecationInfo(XMLNode node, Content constructorDocTree) {
        this.writer.addDeprecated(this.constructor, constructorDocTree);
    }

    public void buildConstructorComments(XMLNode node, Content constructorDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments(this.constructor, constructorDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content constructorDocTree) {
        this.writer.addTags(this.constructor, constructorDocTree);
    }
}

