/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.jshell.ClassTracker;
import jdk.jshell.DeclarationSnippet;
import jdk.jshell.Diag;
import jdk.jshell.DiagList;
import jdk.jshell.JShell;
import jdk.jshell.MethodSnippet;
import jdk.jshell.OuterWrap;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.TaskFactory;
import jdk.jshell.TreeDissector;
import jdk.jshell.Util;
import jdk.jshell.Wrap;

final class Unit {
    private final JShell state;
    private final Snippet si;
    private final Snippet siOld;
    private final boolean isDependency;
    private final boolean isNew;
    private final Snippet causalSnippet;
    private final DiagList generatedDiagnostics;
    private int seq;
    private int seqInitial;
    private Wrap activeGuts;
    private Snippet.Status status;
    private Snippet.Status prevStatus;
    private boolean signatureChanged;
    private DiagList compilationDiagnostics;
    private DiagList recompilationDiagnostics = null;
    private List<String> unresolved;
    private SnippetEvent replaceOldEvent;
    private List<SnippetEvent> secondaryEvents;
    private boolean isAttemptingCorral;
    private List<ClassTracker.ClassInfo> toRedefine;
    private boolean dependenciesNeeded;

    Unit(JShell state, Snippet si, Snippet causalSnippet, DiagList generatedDiagnostics) {
        this.state = state;
        this.si = si;
        this.isDependency = causalSnippet != null;
        this.siOld = this.isDependency ? si : state.maps.getSnippet(si.key());
        this.isNew = this.siOld == null;
        this.causalSnippet = causalSnippet;
        this.generatedDiagnostics = generatedDiagnostics;
        this.seqInitial = this.seq = this.isNew ? 0 : this.siOld.sequenceNumber();
        this.prevStatus = this.isNew || this.isDependency ? si.status() : this.siOld.status();
        si.setSequenceNumber(this.seq);
    }

    Unit(JShell state, Snippet si) {
        this.state = state;
        this.si = si;
        this.siOld = null;
        this.isDependency = false;
        this.isNew = false;
        this.causalSnippet = null;
        this.generatedDiagnostics = new DiagList();
        this.prevStatus = si.status();
        si.setDropped();
        this.status = si.status();
    }

    public int hashCode() {
        return this.si.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Unit ? this.si.equals(((Unit)o).si) : false;
    }

    Snippet snippet() {
        return this.si;
    }

    boolean isDependency() {
        return this.isDependency;
    }

    boolean isNew() {
        return this.isNew;
    }

    boolean isRedundant() {
        return !this.isNew && !this.isDependency() && !this.si.isExecutable() && this.prevStatus.isDefined && this.siOld.source().equals(this.si.source());
    }

    void initialize(Collection<Unit> working) {
        this.isAttemptingCorral = false;
        this.dependenciesNeeded = false;
        this.toRedefine = null;
        this.activeGuts = this.si.guts();
        this.markOldDeclarationOverwritten();
        this.setWrap(working, working);
    }

    void setWrap(Collection<Unit> except, Collection<Unit> plus) {
        this.si.setOuterWrap(this.isImport() ? OuterWrap.wrapImport(this.si.source(), this.activeGuts) : this.state.eval.wrapInClass(this.si, except.stream().map(u -> u.snippet().key()).collect(Collectors.toSet()), this.activeGuts, plus.stream().map(u -> u.snippet()).filter(sn -> sn != this.si).collect(Collectors.toList())));
    }

    void setDiagnostics(TaskFactory.AnalyzeTask ct2) {
        this.setDiagnostics(ct2.getDiagnostics().ofUnit(this));
    }

    void setDiagnostics(DiagList diags) {
        this.compilationDiagnostics = diags;
        UnresolvedExtractor ue = new UnresolvedExtractor(diags);
        this.unresolved = ue.unresolved();
        this.state.debug(1, "++setCompilationInfo() %s\n%s\n-- diags: %s\n", this.si, this.si.outerWrap().wrapped(), diags);
    }

    private boolean isRecoverable() {
        return this.compilationDiagnostics.hasErrors() && this.si instanceof DeclarationSnippet && (this.isDependency() || this.si.subKind() != Snippet.SubKind.VAR_DECLARATION_WITH_INITIALIZER_SUBKIND && this.compilationDiagnostics.hasResolutionErrorsAndNoOthers());
    }

    boolean corralIfNeeded(Collection<Unit> working) {
        if (this.isRecoverable() && this.si.corralled() != null) {
            this.activeGuts = this.si.corralled();
            this.setWrap(working, working);
            this.isAttemptingCorral = true;
            return true;
        }
        this.isAttemptingCorral = false;
        return false;
    }

    void setCorralledDiagnostics(TaskFactory.AnalyzeTask cct) {
        this.recompilationDiagnostics = cct.getDiagnostics().ofUnit(this);
        this.state.debug(1, "++recomp %s\n%s\n-- diags: %s\n", this.si, this.si.outerWrap().wrapped(), this.recompilationDiagnostics);
    }

    boolean smashingErrorDiagnostics(TaskFactory.CompileTask ct2) {
        DiagList dl;
        if (this.isDefined() && (dl = ct2.getDiagnostics().ofUnit(this)).hasErrors()) {
            this.setDiagnostics(dl);
            this.status = Snippet.Status.RECOVERABLE_NOT_DEFINED;
            this.state.debug(1, "++smashingErrorDiagnostics %s\n%s\n-- diags: %s\n", this.si, this.si.outerWrap().wrapped(), dl);
            return true;
        }
        return false;
    }

    void setStatus(TaskFactory.AnalyzeTask at) {
        this.status = !this.compilationDiagnostics.hasErrors() ? Snippet.Status.VALID : (this.isRecoverable() ? (this.isAttemptingCorral && !this.recompilationDiagnostics.hasErrors() ? Snippet.Status.RECOVERABLE_DEFINED : Snippet.Status.RECOVERABLE_NOT_DEFINED) : Snippet.Status.REJECTED);
        this.checkForOverwrite(at);
        this.state.debug(1, "setStatus() %s - status: %s\n", new Object[]{this.si, this.status});
    }

    boolean isDefined() {
        return this.status.isDefined;
    }

    Stream<ClassTracker.ClassInfo> classesToLoad(List<ClassTracker.ClassInfo> cil) {
        this.toRedefine = new ArrayList<ClassTracker.ClassInfo>();
        ArrayList toLoad = new ArrayList();
        if (this.status.isDefined && !this.isImport()) {
            cil.stream().forEach(ci -> {
                if (!ci.isLoaded()) {
                    if (ci.getReferenceTypeOrNull() == null) {
                        toLoad.add(ci);
                        ci.setLoaded();
                        this.dependenciesNeeded = true;
                    } else {
                        this.toRedefine.add((ClassTracker.ClassInfo)ci);
                    }
                }
            });
        }
        return toLoad.stream();
    }

    boolean doRedefines() {
        if (this.toRedefine.isEmpty()) {
            return true;
        }
        Map<ReferenceType, byte[]> mp = this.toRedefine.stream().collect(Collectors.toMap(ci -> ci.getReferenceTypeOrNull(), ci -> ci.getBytes()));
        if (this.state.executionControl().commandRedefine(mp)) {
            this.toRedefine.stream().forEach(ci -> ci.setLoaded());
            return true;
        }
        return false;
    }

    void markForReplacement() {
        this.si.setSequenceNumber(++this.seq);
    }

    private boolean isImport() {
        return this.si.kind() == Snippet.Kind.IMPORT;
    }

    private boolean sigChanged() {
        return this.status.isDefined != this.prevStatus.isDefined || this.seq != this.seqInitial && this.status.isDefined || this.signatureChanged;
    }

    Stream<Unit> effectedDependents() {
        return this.sigChanged() || this.dependenciesNeeded || this.status == Snippet.Status.RECOVERABLE_NOT_DEFINED ? this.dependents() : Stream.empty();
    }

    Stream<Unit> dependents() {
        return this.state.maps.getDependents(this.si).stream().filter(xsi -> xsi != this.si && xsi.status().isActive).map(xsi -> new Unit(this.state, (Snippet)xsi, this.si, new DiagList()));
    }

    void finish() {
        this.recordCompilation();
        this.state.maps.installSnippet(this.si);
    }

    private void markOldDeclarationOverwritten() {
        if (this.si != this.siOld && this.siOld != null && this.siOld.status().isActive) {
            this.replaceOldEvent = new SnippetEvent(this.siOld, this.siOld.status(), Snippet.Status.OVERWRITTEN, false, this.si, null, null);
            this.siOld.setOverwritten();
        }
    }

    private DiagList computeDiagnostics() {
        DiagList diagnostics = new DiagList();
        DiagList diags = this.compilationDiagnostics;
        if (this.status == Snippet.Status.RECOVERABLE_DEFINED || this.status == Snippet.Status.RECOVERABLE_NOT_DEFINED) {
            UnresolvedExtractor ue = new UnresolvedExtractor(diags);
            diagnostics.addAll(ue.otherAll());
        } else {
            this.unresolved = Collections.emptyList();
            diagnostics.addAll(diags);
        }
        diagnostics.addAll(this.generatedDiagnostics);
        return diagnostics;
    }

    private void recordCompilation() {
        this.state.maps.mapDependencies(this.si);
        DiagList diags = this.computeDiagnostics();
        this.si.setCompilationStatus(this.status, this.unresolved, diags);
        this.state.debug(1, "recordCompilation: %s -- status %s, unresolved %s\n", new Object[]{this.si, this.status, this.unresolved});
    }

    private void checkForOverwrite(TaskFactory.AnalyzeTask at) {
        this.secondaryEvents = new ArrayList<SnippetEvent>();
        if (this.replaceOldEvent != null) {
            this.secondaryEvents.add(this.replaceOldEvent);
        }
        if (this.si.kind() == Snippet.Kind.METHOD && this.status.isDefined) {
            MethodSnippet msi = (MethodSnippet)this.si;
            String oqpt = msi.qualifiedParameterTypes();
            String nqpt = this.computeQualifiedParameterTypes(at, msi);
            if (!nqpt.equals(oqpt)) {
                msi.setQualifiedParamaterTypes(nqpt);
                Snippet.Status overwrittenStatus = this.overwriteMatchingMethod(msi);
                if (overwrittenStatus != null) {
                    this.prevStatus = overwrittenStatus;
                    this.signatureChanged = true;
                }
            }
        }
    }

    private Snippet.Status overwriteMatchingMethod(MethodSnippet msi) {
        String qpt = msi.qualifiedParameterTypes();
        Snippet.Status overwrittenStatus = null;
        for (MethodSnippet sn : this.state.methods()) {
            if (sn == null || sn == msi || !sn.status().isActive || !sn.name().equals(msi.name()) || !qpt.equals(sn.qualifiedParameterTypes())) continue;
            overwrittenStatus = sn.status();
            SnippetEvent se = new SnippetEvent(sn, overwrittenStatus, Snippet.Status.OVERWRITTEN, false, msi, null, null);
            sn.setOverwritten();
            this.secondaryEvents.add(se);
            this.state.debug(16, "Overwrite event #%d -- key: %s before: %s status: %s sig: %b cause: %s\n", new Object[]{this.secondaryEvents.size(), se.snippet(), se.previousStatus(), se.status(), se.isSignatureChange(), se.causeSnippet()});
        }
        return overwrittenStatus;
    }

    private String computeQualifiedParameterTypes(TaskFactory.AnalyzeTask at, MethodSnippet msi) {
        String rawSig = TreeDissector.createBySnippet(at, msi).typeOfMethod();
        String signature = Util.expunge(rawSig);
        int paren = signature.lastIndexOf(41);
        return paren >= 0 ? signature.substring(0, paren + 1) : msi.parameterTypes();
    }

    SnippetEvent event(String value, Exception exception) {
        boolean wasSignatureChanged = this.sigChanged();
        this.state.debug(16, "Snippet: %s id: %s before: %s status: %s sig: %b cause: %s\n", new Object[]{this.si, this.si.id(), this.prevStatus, this.si.status(), wasSignatureChanged, this.causalSnippet});
        return new SnippetEvent(this.si, this.prevStatus, this.si.status(), wasSignatureChanged, this.causalSnippet, value, exception);
    }

    List<SnippetEvent> secondaryEvents() {
        return this.secondaryEvents;
    }

    public String toString() {
        return "Unit(" + this.si.name() + ")";
    }

    private static class UnresolvedExtractor {
        private static final String RESOLVE_ERROR_SYMBOL = "symbol:";
        private static final String RESOLVE_ERROR_LOCATION = "location:";
        private final Set<String> unresolved = new LinkedHashSet<String>();
        private final DiagList otherErrors = new DiagList();
        private final DiagList otherAll = new DiagList();

        UnresolvedExtractor(DiagList diags) {
            for (Diag diag : diags) {
                if (diag.isError()) {
                    String m;
                    int symPos;
                    if (diag.isResolutionError() && (symPos = (m = diag.getMessage(Util.PARSED_LOCALE)).indexOf(RESOLVE_ERROR_SYMBOL)) >= 0) {
                        int symLoc = (m = m.substring(symPos + RESOLVE_ERROR_SYMBOL.length())).indexOf(RESOLVE_ERROR_LOCATION);
                        if (symLoc >= 0) {
                            m = m.substring(0, symLoc);
                        }
                        m = m.trim();
                        this.unresolved.add(m);
                        continue;
                    }
                    this.otherErrors.add(diag);
                }
                this.otherAll.add(diag);
            }
        }

        DiagList otherCorralledErrors() {
            return this.otherErrors;
        }

        DiagList otherAll() {
            return this.otherAll;
        }

        List<String> unresolved() {
            return new ArrayList<String>(this.unresolved);
        }
    }
}

