/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.attribute;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.attribute.AnnotationAppender;
import org.objectweb.asm.FieldVisitor;

public interface FieldAttributeAppender {
    public void apply(FieldVisitor var1, FieldDescription var2);

    public static class Compound
    implements FieldAttributeAppender {
        private final FieldAttributeAppender[] fieldAttributeAppender;

        public Compound(FieldAttributeAppender ... fieldAttributeAppender) {
            this.fieldAttributeAppender = fieldAttributeAppender;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription) {
            for (FieldAttributeAppender fieldAttributeAppender : this.fieldAttributeAppender) {
                fieldAttributeAppender.apply(fieldVisitor, fieldDescription);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.fieldAttributeAppender, ((Compound)other).fieldAttributeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.fieldAttributeAppender);
        }

        public String toString() {
            return "FieldAttributeAppender.Compound{fieldAttributeAppender=" + Arrays.toString(this.fieldAttributeAppender) + '}';
        }
    }

    public static class ForField
    implements FieldAttributeAppender,
    Factory {
        private final FieldDescription fieldDescription;
        private final AnnotationAppender.ValueFilter valueFilter;

        public ForField(Field field, AnnotationAppender.ValueFilter valueFilter) {
            this(new FieldDescription.ForLoadedField(field), valueFilter);
        }

        public ForField(FieldDescription fieldDescription, AnnotationAppender.ValueFilter valueFilter) {
            this.fieldDescription = fieldDescription;
            this.valueFilter = valueFilter;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnField(fieldVisitor), this.valueFilter);
            for (AnnotationDescription annotation : this.fieldDescription.getDeclaredAnnotations()) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }

        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldDescription.equals(((ForField)other).fieldDescription) && this.valueFilter.equals(((ForField)other).valueFilter);
        }

        public int hashCode() {
            return this.fieldDescription.hashCode() + 31 * this.valueFilter.hashCode();
        }

        public String toString() {
            return "FieldAttributeAppender.ForField{fieldDescription=" + this.fieldDescription + ", valueFilter=" + this.valueFilter + '}';
        }
    }

    public static class ForAnnotation
    implements FieldAttributeAppender,
    Factory {
        private final List<? extends AnnotationDescription> annotations;
        private final AnnotationAppender.ValueFilter valueFilter;

        public ForAnnotation(List<? extends AnnotationDescription> annotations, AnnotationAppender.ValueFilter valueFilter) {
            this.annotations = annotations;
            this.valueFilter = valueFilter;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnField(fieldVisitor), this.valueFilter);
            for (AnnotationDescription annotationDescription : this.annotations) {
                annotationAppender.append(annotationDescription, AnnotationAppender.AnnotationVisibility.of(annotationDescription));
            }
        }

        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotations.equals(((ForAnnotation)other).annotations) && this.valueFilter.equals(((ForAnnotation)other).valueFilter);
        }

        public int hashCode() {
            return this.annotations.hashCode() + 31 * this.valueFilter.hashCode();
        }

        public String toString() {
            return "FieldAttributeAppender.ForAnnotation{annotations=" + this.annotations + "valueFilter=" + this.valueFilter + '}';
        }
    }

    public static interface Factory {
        public FieldAttributeAppender make(TypeDescription var1);

        public static class Compound
        implements Factory {
            private final Factory[] factory;

            public Compound(Factory ... factory) {
                this.factory = factory;
            }

            @Override
            public FieldAttributeAppender make(TypeDescription typeDescription) {
                FieldAttributeAppender[] fieldAttributeAppender = new FieldAttributeAppender[this.factory.length];
                int index = 0;
                for (Factory factory : this.factory) {
                    fieldAttributeAppender[index++] = factory.make(typeDescription);
                }
                return new net.bytebuddy.implementation.attribute.FieldAttributeAppender$Compound(fieldAttributeAppender);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.factory, ((Compound)other).factory);
            }

            public int hashCode() {
                return Arrays.hashCode(this.factory);
            }

            public String toString() {
                return "FieldAttributeAppender.Factory.Compound{factory=" + Arrays.toString(this.factory) + '}';
            }
        }
    }

    public static enum NoOp implements FieldAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription) {
        }

        public String toString() {
            return "FieldAttributeAppender.NoOp." + this.name();
        }
    }
}

