/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.turbine.options.TurbineOptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;

public class TurbineOptionsParser {
    private static final Splitter ARG_SPLITTER = Splitter.on((CharMatcher)CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults();
    private static final Splitter CLASSPATH_SPLITTER = Splitter.on((char)':').trimResults().omitEmptyStrings();

    public static TurbineOptions parse(Iterable<String> args) throws IOException {
        TurbineOptions.Builder builder = TurbineOptions.builder();
        TurbineOptionsParser.parse(builder, args);
        return builder.build();
    }

    public static void parse(TurbineOptions.Builder builder, Iterable<String> args) throws IOException {
        ArrayDeque<String> argumentDeque = new ArrayDeque<String>();
        TurbineOptionsParser.expandParamsFiles(argumentDeque, args);
        TurbineOptionsParser.parse(builder, argumentDeque);
    }

    private static void expandParamsFiles(Deque<String> argumentDeque, Iterable<String> args) throws IOException {
        for (String arg : args) {
            if (arg.isEmpty()) continue;
            if (arg.startsWith("@") && !arg.startsWith("@@")) {
                Path paramsPath = Paths.get(arg.substring(1), new String[0]);
                TurbineOptionsParser.expandParamsFiles(argumentDeque, ARG_SPLITTER.split((CharSequence)new String(Files.readAllBytes(paramsPath), StandardCharsets.UTF_8)));
                continue;
            }
            argumentDeque.addLast(arg);
        }
    }

    private static void parse(TurbineOptions.Builder builder, Deque<String> argumentDeque) {
        block34: while (!argumentDeque.isEmpty()) {
            String next;
            switch (next = argumentDeque.pollFirst()) {
                case "--output": {
                    builder.setOutput(TurbineOptionsParser.readOne(argumentDeque));
                    continue block34;
                }
                case "--source_jars": {
                    builder.setSourceJars((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block34;
                }
                case "--temp_dir": {
                    builder.setTempDir(TurbineOptionsParser.readOne(argumentDeque));
                    continue block34;
                }
                case "--processors": {
                    builder.addProcessors((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block34;
                }
                case "--processorpath": {
                    builder.addProcessorPathEntries((Iterable<String>)TurbineOptionsParser.splitClasspath(TurbineOptionsParser.readList(argumentDeque)));
                    continue block34;
                }
                case "--classpath": {
                    builder.addClassPathEntries((Iterable<String>)TurbineOptionsParser.splitClasspath(TurbineOptionsParser.readList(argumentDeque)));
                    continue block34;
                }
                case "--bootclasspath": {
                    builder.addBootClassPathEntries((Iterable<String>)TurbineOptionsParser.splitClasspath(TurbineOptionsParser.readList(argumentDeque)));
                    continue block34;
                }
                case "--javacopts": {
                    builder.addAllJavacOpts((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block34;
                }
                case "--sources": {
                    builder.addSources((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block34;
                }
                case "--output_deps": {
                    builder.setOutputDeps(TurbineOptionsParser.readOne(argumentDeque));
                    continue block34;
                }
                case "--direct_dependency": {
                    String jar = TurbineOptionsParser.readOne(argumentDeque);
                    String target = TurbineOptionsParser.readOne(argumentDeque);
                    builder.addDirectJarToTarget(jar, target);
                    continue block34;
                }
                case "--indirect_dependency": {
                    String jar = TurbineOptionsParser.readOne(argumentDeque);
                    String target = TurbineOptionsParser.readOne(argumentDeque);
                    builder.addIndirectJarToTarget(jar, target);
                    continue block34;
                }
                case "--deps_artifacts": {
                    builder.addAllDepsArtifacts((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block34;
                }
                case "--target_label": {
                    builder.setTargetLabel(TurbineOptionsParser.readOne(argumentDeque));
                    continue block34;
                }
                case "--rule_kind": {
                    builder.setRuleKind(TurbineOptionsParser.readOne(argumentDeque));
                    continue block34;
                }
            }
            if (!next.isEmpty() || argumentDeque.isEmpty()) continue;
            throw new IllegalArgumentException("unknown option: " + next);
        }
    }

    @Nullable
    private static String readOne(Deque<String> argumentDeque) {
        if (argumentDeque.isEmpty() || argumentDeque.peekFirst().startsWith("-")) {
            return null;
        }
        return argumentDeque.pollFirst();
    }

    private static ImmutableList<String> readList(Deque<String> argumentDeque) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!argumentDeque.isEmpty() && !argumentDeque.peekFirst().startsWith("--")) {
            result.add((Object)argumentDeque.pollFirst());
        }
        return result.build();
    }

    private static ImmutableList<String> splitClasspath(Iterable<String> paths) {
        ImmutableList.Builder classpath = ImmutableList.builder();
        for (String path : paths) {
            classpath.addAll(CLASSPATH_SPLITTER.split((CharSequence)path));
        }
        return classpath.build();
    }
}

