/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.BugPatternValidator;
import com.google.errorprone.ValidationException;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.Tree;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;

public class BugCheckerInfo
implements Serializable {
    private final Class<? extends BugChecker> checker;
    private final String canonicalName;
    private final ImmutableSet<String> allNames;
    private final String message;
    private final BugPattern.SeverityLevel defaultSeverity;
    private final String linkUrl;
    private final BugPattern.Suppressibility suppressibility;
    private final Set<Class<? extends Annotation>> customSuppressionAnnotations;
    private static final String URL_FORMAT = "http://errorprone.info/bugpattern/%s";

    public static BugCheckerInfo create(Class<? extends BugChecker> checker) {
        BugPattern pattern = (BugPattern)Preconditions.checkNotNull((Object)checker.getAnnotation(BugPattern.class), (Object)"BugCheckers must be annotated with @BugPattern");
        try {
            BugPatternValidator.validate((BugPattern)pattern);
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e);
        }
        return new BugCheckerInfo(checker, pattern);
    }

    private BugCheckerInfo(Class<? extends BugChecker> checker, BugPattern pattern) {
        this.checker = checker;
        this.canonicalName = pattern.name();
        this.allNames = ImmutableSet.builder().add((Object)this.canonicalName).add((Object[])pattern.altNames()).build();
        this.message = pattern.summary();
        this.defaultSeverity = pattern.severity();
        this.linkUrl = BugCheckerInfo.createLinkUrl(pattern);
        this.suppressibility = pattern.suppressibility();
        this.customSuppressionAnnotations = this.suppressibility == BugPattern.Suppressibility.CUSTOM_ANNOTATION ? new HashSet<Class>(Arrays.asList(pattern.customSuppressionAnnotations())) : Collections.emptySet();
    }

    private static String createLinkUrl(BugPattern pattern) {
        switch (pattern.linkType()) {
            case AUTOGENERATED: {
                return String.format(URL_FORMAT, pattern.name());
            }
            case CUSTOM: {
                if (pattern.link().isEmpty()) {
                    throw new IllegalStateException("If linkType element of @BugPattern is CUSTOM, a link element must also be provided.");
                }
                return pattern.link();
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected value for linkType element of @BugPattern: " + pattern.linkType());
    }

    @CheckReturnValue
    public static Description.Builder buildDescriptionFromChecker(Tree node, BugChecker checker) {
        return Description.builder((Tree)Preconditions.checkNotNull((Object)node), checker.canonicalName(), checker.linkUrl(), checker.defaultSeverity(), checker.message());
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public Set<String> allNames() {
        return this.allNames;
    }

    public String message() {
        return this.message;
    }

    public BugPattern.SeverityLevel defaultSeverity() {
        return this.defaultSeverity;
    }

    public BugPattern.SeverityLevel severity(Map<String, BugPattern.SeverityLevel> severities) {
        return (BugPattern.SeverityLevel)MoreObjects.firstNonNull((Object)severities.get(this.canonicalName), (Object)this.defaultSeverity);
    }

    public String linkUrl() {
        return this.linkUrl;
    }

    public BugPattern.Suppressibility suppressibility() {
        return this.suppressibility;
    }

    public Set<Class<? extends Annotation>> customSuppressionAnnotations() {
        return this.customSuppressionAnnotations;
    }

    public Class<? extends BugChecker> checkerClass() {
        return this.checker;
    }

    public int hashCode() {
        return this.checker.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BugCheckerInfo)) {
            return false;
        }
        return this.checker.equals(((BugCheckerInfo)o).checker);
    }

    public String toString() {
        return this.canonicalName;
    }
}

