/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.AutoValue_ErrorProneOptions_PatchingOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ErrorProneOptions {
    private static final String CUSTOM_ENABLEMENT_PREFIX = "-Xep:";
    private static final String PATCH_FILE_PREFIX = "-XepPatch:";
    private static final String ERRORS_AS_WARNINGS_FLAG = "-XepAllErrorsAsWarnings";
    private static final String ENABLE_ALL_CHECKS = "-XepAllDisabledChecksAsWarnings";
    private static final String IGNORE_UNKNOWN_CHECKS_FLAG = "-XepIgnoreUnknownCheckNames";
    private static final String DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG = "-XepDisableWarningsInGeneratedCode";
    private final ImmutableList<String> remainingArgs;
    private final ImmutableMap<String, Severity> severityMap;
    private final boolean ignoreUnknownChecks;
    private final boolean disableWarningsInGeneratedCode;
    private final boolean dropErrorsToWarnings;
    private final boolean enableAllChecks;
    private final PatchingOptions patchingOptions;
    private static final ErrorProneOptions EMPTY = new Builder().build((ImmutableList<String>)ImmutableList.of());

    public static int isSupportedOption(String option) {
        boolean isSupported = option.startsWith(CUSTOM_ENABLEMENT_PREFIX) || option.startsWith(PATCH_FILE_PREFIX) || option.equals(IGNORE_UNKNOWN_CHECKS_FLAG) || option.equals(DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG) || option.equals(ERRORS_AS_WARNINGS_FLAG) || option.equals(ENABLE_ALL_CHECKS);
        return isSupported ? 0 : -1;
    }

    public boolean isEnableAllChecks() {
        return this.enableAllChecks;
    }

    public boolean isDropErrorsToWarnings() {
        return this.dropErrorsToWarnings;
    }

    private ErrorProneOptions(ImmutableMap<String, Severity> severityMap, ImmutableList<String> remainingArgs, boolean ignoreUnknownChecks, boolean disableWarningsInGeneratedCode, boolean dropErrorsToWarnings, boolean enableAllChecks, PatchingOptions patchingOptions) {
        this.severityMap = severityMap;
        this.remainingArgs = remainingArgs;
        this.ignoreUnknownChecks = ignoreUnknownChecks;
        this.disableWarningsInGeneratedCode = disableWarningsInGeneratedCode;
        this.dropErrorsToWarnings = dropErrorsToWarnings;
        this.enableAllChecks = enableAllChecks;
        this.patchingOptions = patchingOptions;
    }

    public String[] getRemainingArgs() {
        return (String[])this.remainingArgs.toArray((Object[])new String[this.remainingArgs.size()]);
    }

    public ImmutableMap<String, Severity> getSeverityMap() {
        return this.severityMap;
    }

    public boolean ignoreUnknownChecks() {
        return this.ignoreUnknownChecks;
    }

    public boolean disableWarningsInGeneratedCode() {
        return this.disableWarningsInGeneratedCode;
    }

    public PatchingOptions patchingOptions() {
        return this.patchingOptions;
    }

    public static ErrorProneOptions empty() {
        return EMPTY;
    }

    public static ErrorProneOptions processArgs(Iterable<String> args) {
        Preconditions.checkNotNull(args);
        ImmutableList.Builder outputArgs = ImmutableList.builder();
        Builder builder = new Builder();
        Iterator<String> iterator = args.iterator();
        block12: while (iterator.hasNext()) {
            String arg;
            switch (arg = iterator.next()) {
                case "-XepIgnoreUnknownCheckNames": {
                    builder.setIgnoreUnknownChecks(true);
                    continue block12;
                }
                case "-XepDisableWarningsInGeneratedCode": {
                    builder.setDisableWarningsInGeneratedCode(true);
                    continue block12;
                }
                case "-XepAllErrorsAsWarnings": {
                    builder.setDropWarningsToErrors(true);
                    continue block12;
                }
                case "-XepAllDisabledChecksAsWarnings": {
                    builder.setEnableAllChecks(true);
                    continue block12;
                }
            }
            if (arg.startsWith(CUSTOM_ENABLEMENT_PREFIX)) {
                ErrorProneOptions.parseCustomFlagIntoOptionsBuilder(builder, arg);
                continue;
            }
            if (arg.startsWith(PATCH_FILE_PREFIX)) {
                ErrorProneOptions.parsePatchArgIntoBuilder(builder, arg);
                continue;
            }
            outputArgs.add((Object)arg);
        }
        return builder.build((ImmutableList<String>)outputArgs.build());
    }

    private static void parsePatchArgIntoBuilder(Builder builder, String arg) {
        String remaining = arg.substring(PATCH_FILE_PREFIX.length());
        if (remaining.equals("IN_PLACE")) {
            builder.setPatchingOptions(PatchingOptions.doInPlace());
        } else {
            if (remaining.isEmpty()) {
                throw new InvalidCommandLineOptionException("invalid flag: " + arg);
            }
            builder.setPatchingOptions(PatchingOptions.baseDirectory(remaining));
        }
    }

    private static void parseCustomFlagIntoOptionsBuilder(Builder builder, String arg) {
        Severity severity;
        String remaining = arg.substring(CUSTOM_ENABLEMENT_PREFIX.length());
        String[] parts = remaining.split(":");
        if (parts.length > 2 || parts[0].isEmpty()) {
            throw new InvalidCommandLineOptionException("invalid flag: " + arg);
        }
        String checkName = parts[0];
        if (parts.length == 1) {
            severity = Severity.DEFAULT;
        } else {
            try {
                severity = Severity.valueOf(parts[1]);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidCommandLineOptionException("invalid flag: " + arg);
            }
        }
        builder.putSeverity(checkName, severity);
    }

    public static ErrorProneOptions processArgs(String[] args) {
        Preconditions.checkNotNull((Object)args);
        return ErrorProneOptions.processArgs(Arrays.asList(args));
    }

    private static class Builder {
        private boolean ignoreUnknownChecks = false;
        private boolean disableWarningsInGeneratedCode = false;
        private boolean dropWarningsToErrors = false;
        private boolean enableAllChecks = false;
        private Map<String, Severity> severityMap = new HashMap<String, Severity>();
        private PatchingOptions patchingOptions = PatchingOptions.nope();

        private Builder() {
        }

        public void setIgnoreUnknownChecks(boolean ignoreUnknownChecks) {
            this.ignoreUnknownChecks = ignoreUnknownChecks;
        }

        public void setDisableWarningsInGeneratedCode(boolean disableWarningsInGeneratedCode) {
            this.disableWarningsInGeneratedCode = disableWarningsInGeneratedCode;
        }

        public void setDropWarningsToErrors(boolean dropWarningsToErrors) {
            this.dropWarningsToErrors = dropWarningsToErrors;
        }

        public void putSeverity(String checkName, Severity severity) {
            this.severityMap.put(checkName, severity);
        }

        public void setEnableAllChecks(boolean enableAllChecks) {
            this.enableAllChecks = enableAllChecks;
        }

        public void setPatchingOptions(PatchingOptions patchingOptions) {
            this.patchingOptions = patchingOptions;
        }

        public ErrorProneOptions build(ImmutableList<String> outputArgs) {
            return new ErrorProneOptions(ImmutableMap.copyOf(this.severityMap), outputArgs, this.ignoreUnknownChecks, this.disableWarningsInGeneratedCode, this.dropWarningsToErrors, this.enableAllChecks, this.patchingOptions);
        }
    }

    static abstract class PatchingOptions {
        PatchingOptions() {
        }

        abstract boolean doRefactor();

        abstract boolean inPlace();

        abstract String baseDirectory();

        static PatchingOptions nope() {
            return new AutoValue_ErrorProneOptions_PatchingOptions(false, false, "");
        }

        static PatchingOptions doInPlace() {
            return new AutoValue_ErrorProneOptions_PatchingOptions(true, true, "");
        }

        static PatchingOptions baseDirectory(String baseDirectory) {
            return new AutoValue_ErrorProneOptions_PatchingOptions(true, false, baseDirectory);
        }
    }

    public static enum Severity {
        DEFAULT,
        OFF,
        WARN,
        ERROR;

    }
}

