/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.matchers.AnnotationDoesNotHaveArgument;
import com.google.errorprone.matchers.AnnotationHasArgumentWithValue;
import com.google.errorprone.matchers.AnnotationMatcher;
import com.google.errorprone.matchers.AnnotationType;
import com.google.errorprone.matchers.Asserts;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.CompoundAssignment;
import com.google.errorprone.matchers.ConstructorOfClass;
import com.google.errorprone.matchers.Contains;
import com.google.errorprone.matchers.DescendantOf;
import com.google.errorprone.matchers.Enclosing;
import com.google.errorprone.matchers.HasArguments;
import com.google.errorprone.matchers.HasIdentifier;
import com.google.errorprone.matchers.InstanceMethod;
import com.google.errorprone.matchers.IsLastStatementInBlock;
import com.google.errorprone.matchers.IsSameType;
import com.google.errorprone.matchers.IsSubtypeOf;
import com.google.errorprone.matchers.IsSymbol;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.MethodHasParameters;
import com.google.errorprone.matchers.MethodInvocation;
import com.google.errorprone.matchers.MethodInvocationArgument;
import com.google.errorprone.matchers.MethodInvocationMethodSelect;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.matchers.NextStatement;
import com.google.errorprone.matchers.NullnessMatcher;
import com.google.errorprone.matchers.ParentNode;
import com.google.errorprone.matchers.Returns;
import com.google.errorprone.matchers.StringLiteral;
import com.google.errorprone.matchers.Throws;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

public class Matchers {
    private Matchers() {
    }

    public static <T extends Tree> Matcher<T> anything() {
        return new Matcher<T>(){

            @Override
            public boolean matches(T t, VisitorState state) {
                return true;
            }
        };
    }

    public static <T extends Tree> Matcher<T> nothing() {
        return new Matcher<T>(){

            @Override
            public boolean matches(T t, VisitorState state) {
                return false;
            }
        };
    }

    public static <T extends Tree> Matcher<T> not(final Matcher<T> matcher) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T t, VisitorState state) {
                return !matcher.matches(t, state);
            }
        };
    }

    @SafeVarargs
    public static <T extends Tree> Matcher<T> allOf(final Matcher<? super T> ... matchers) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T t, VisitorState state) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(t, state)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T extends Tree> Matcher<T> anyOf(final Iterable<? extends Matcher<? super T>> matchers) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T t, VisitorState state) {
                for (Matcher matcher : matchers) {
                    if (!matcher.matches(t, state)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public static <T extends Tree> Matcher<T> anyOf(Matcher<? super T> ... matchers) {
        return Matchers.anyOf(Arrays.asList(matchers));
    }

    public static <T extends Tree> Matcher<T> isInstance(final Class<?> klass) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T t, VisitorState state) {
                return klass.isInstance(t);
            }
        };
    }

    public static <T extends Tree> Matcher<T> kindIs(final Tree.Kind kind) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T tree, VisitorState state) {
                return tree.getKind() == kind;
            }
        };
    }

    public static <T extends Tree> Matcher<T> isSame(final Tree t) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T tree, VisitorState state) {
                return tree == t;
            }
        };
    }

    public static MethodMatchers.StaticMethodMatcher staticMethod() {
        return MethodMatchers.staticMethod();
    }

    public static MethodMatchers.InstanceMethodMatcher instanceMethod() {
        return MethodMatchers.instanceMethod();
    }

    public static MethodMatchers.AnyMethodMatcher anyMethod() {
        return MethodMatchers.anyMethod();
    }

    public static MethodMatchers.ConstructorMatcher constructor() {
        return MethodMatchers.constructor();
    }

    @Deprecated
    public static InstanceMethod instanceMethod(Matcher<? super ExpressionTree> receiverMatcher, String methodName) {
        return new InstanceMethod(receiverMatcher, methodName);
    }

    public static Matcher<ExpressionTree> isInstanceField() {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                Symbol symbol = ASTHelpers.getSymbol(expressionTree);
                return symbol != null && symbol.getKind() == ElementKind.FIELD && !symbol.isStatic();
            }
        };
    }

    public static Matcher<ExpressionTree> isVariable() {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                Symbol symbol = ASTHelpers.getSymbol(expressionTree);
                if (symbol == null) {
                    return false;
                }
                return symbol.getKind() == ElementKind.LOCAL_VARIABLE || symbol.getKind() == ElementKind.PARAMETER;
            }
        };
    }

    public static CompoundAssignment compoundAssignment(Tree.Kind operator, Matcher<ExpressionTree> leftOperandMatcher, Matcher<ExpressionTree> rightOperandMatcher) {
        HashSet<Tree.Kind> operators = new HashSet<Tree.Kind>(1);
        operators.add(operator);
        return new CompoundAssignment(operators, leftOperandMatcher, rightOperandMatcher);
    }

    public static CompoundAssignment compoundAssignment(Set<Tree.Kind> operators, Matcher<ExpressionTree> receiverMatcher, Matcher<ExpressionTree> expressionMatcher) {
        return new CompoundAssignment(operators, receiverMatcher, expressionMatcher);
    }

    public static Matcher<? super MethodInvocationTree> receiverSameAsArgument(final int argNum) {
        return new Matcher<MethodInvocationTree>(){

            @Override
            public boolean matches(MethodInvocationTree t, VisitorState state) {
                List<? extends ExpressionTree> args = t.getArguments();
                if (args.size() <= argNum) {
                    return false;
                }
                ExpressionTree arg = args.get(argNum);
                JCTree.JCExpression methodSelect = (JCTree.JCExpression)t.getMethodSelect();
                if (methodSelect instanceof JCTree.JCFieldAccess) {
                    JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)methodSelect;
                    return ASTHelpers.sameVariable(fieldAccess.getExpression(), arg);
                }
                if (methodSelect instanceof JCTree.JCIdent) {
                    return "this".equals(arg.toString());
                }
                return false;
            }
        };
    }

    public static Matcher<MethodInvocationTree> receiverOfInvocation(final Matcher<ExpressionTree> expressionTreeMatcher) {
        return new Matcher<MethodInvocationTree>(){

            @Override
            public boolean matches(MethodInvocationTree methodInvocationTree, VisitorState state) {
                return expressionTreeMatcher.matches(ASTHelpers.getReceiver(methodInvocationTree), state);
            }
        };
    }

    public static <T extends Tree> MultiMatcher<T, AnnotationTree> annotations(ChildMultiMatcher.MatchType matchType, Matcher<AnnotationTree> annotationMatcher) {
        return new AnnotationMatcher(matchType, annotationMatcher);
    }

    public static MultiMatcher<ClassTree, MethodTree> constructor(ChildMultiMatcher.MatchType matchType, Matcher<MethodTree> constructorMatcher) {
        return new ConstructorOfClass(matchType, constructorMatcher);
    }

    public static Matcher<MethodInvocationTree> methodSelect(Matcher<ExpressionTree> methodSelectMatcher) {
        return new MethodInvocationMethodSelect(methodSelectMatcher);
    }

    public static Matcher<MethodInvocationTree> argument(int position, Matcher<ExpressionTree> argumentMatcher) {
        return new MethodInvocationArgument(position, argumentMatcher);
    }

    public static MultiMatcher<MethodInvocationTree, ExpressionTree> hasArguments(ChildMultiMatcher.MatchType matchType, Matcher<ExpressionTree> argumentMatcher) {
        return new HasArguments(matchType, argumentMatcher);
    }

    public static Matcher<ExpressionTree> methodInvocation(Matcher<ExpressionTree> methodSelectMatcher, ChildMultiMatcher.MatchType matchType, Matcher<ExpressionTree> methodArgumentMatcher) {
        return new MethodInvocation(methodSelectMatcher, matchType, methodArgumentMatcher);
    }

    public static Matcher<ExpressionTree> methodInvocation(final Matcher<ExpressionTree> methodSelectMatcher) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                if (!(expressionTree instanceof MethodInvocationTree)) {
                    return false;
                }
                MethodInvocationTree tree = (MethodInvocationTree)expressionTree;
                return methodSelectMatcher.matches(tree.getMethodSelect(), state);
            }
        };
    }

    public static Matcher<MethodInvocationTree> argumentCount(final int argumentCount) {
        return new Matcher<MethodInvocationTree>(){

            @Override
            public boolean matches(MethodInvocationTree t, VisitorState state) {
                return t.getArguments().size() == argumentCount;
            }
        };
    }

    public static Matcher<Tree> parentNode(Matcher<? extends Tree> treeMatcher) {
        Matcher<Tree> matcher = treeMatcher;
        return new ParentNode(matcher);
    }

    public static <T extends Tree> Matcher<T> isSubtypeOf(String typeStr) {
        return new IsSubtypeOf(typeStr);
    }

    public static <T extends Tree> Matcher<T> isSubtypeOf(Supplier<Type> type) {
        return new IsSubtypeOf(type);
    }

    public static <T extends Tree> Matcher<T> isSubtypeOf(Class<?> clazz) {
        return new IsSubtypeOf(Suppliers.typeFromClass(clazz));
    }

    public static <T extends Tree> Matcher<T> isSameType(Supplier<Type> type) {
        return new IsSameType(type);
    }

    public static <T extends Tree> Matcher<T> isSameType(String typeString) {
        return new IsSameType(typeString);
    }

    public static <T extends Tree> Matcher<T> isSameType(Class<?> clazz) {
        return new IsSameType(Suppliers.typeFromClass(clazz));
    }

    public static <T extends Tree> Matcher<T> isArrayType() {
        return new Matcher<T>(){

            @Override
            public boolean matches(Tree t, VisitorState state) {
                return state.getTypes().isArray(((JCTree)t).type);
            }
        };
    }

    public static <T extends Tree> Matcher<T> isPrimitiveArrayType() {
        return new Matcher<T>(){

            @Override
            public boolean matches(Tree t, VisitorState state) {
                Type type = ((JCTree)t).type;
                return state.getTypes().isArray(type) && state.getTypes().elemtype(type).isPrimitive();
            }
        };
    }

    public static <T extends Tree> Matcher<T> isPrimitiveType() {
        return new Matcher<T>(){

            @Override
            public boolean matches(Tree t, VisitorState state) {
                return ((JCTree)t).type.isPrimitive();
            }
        };
    }

    public static <T extends Tree> Matcher<T> isPrimitiveOrBoxedPrimitiveType() {
        return new Matcher<T>(){

            @Override
            public boolean matches(Tree t, VisitorState state) {
                return state.getTypes().unboxedTypeOrType(((JCTree)t).type).isPrimitive();
            }
        };
    }

    public static <T extends Tree> Enclosing.Block<T> enclosingBlock(Matcher<BlockTree> matcher) {
        return new Enclosing.Block(matcher);
    }

    public static <T extends Tree> Enclosing.Class<T> enclosingClass(Matcher<ClassTree> matcher) {
        return new Enclosing.Class(matcher);
    }

    public static <T extends Tree> Enclosing.Method<T> enclosingMethod(Matcher<MethodTree> matcher) {
        return new Enclosing.Method(matcher);
    }

    public static <T extends Tree> Matcher<Tree> enclosingNode(final Matcher<T> matcher) {
        return new Matcher<Tree>(){

            @Override
            public boolean matches(Tree t, VisitorState state) {
                for (TreePath path = state.getPath().getParentPath(); path != null; path = path.getParentPath()) {
                    Tree node = path.getLeaf();
                    if (!matcher.matches(node, state = state.withPath(path))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T extends StatementTree> NextStatement<T> nextStatement(Matcher<StatementTree> matcher) {
        return new NextStatement(matcher);
    }

    public static Matcher<StatementTree> isLastStatementInBlock() {
        return new IsLastStatementInBlock<StatementTree>();
    }

    public static Matcher<ExpressionTree> nonNullLiteral() {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree tree, VisitorState state) {
                switch (tree.getKind()) {
                    case MEMBER_SELECT: {
                        return ((MemberSelectTree)tree).getIdentifier().contentEquals("class");
                    }
                    case INT_LITERAL: 
                    case LONG_LITERAL: 
                    case FLOAT_LITERAL: 
                    case DOUBLE_LITERAL: 
                    case BOOLEAN_LITERAL: 
                    case CHAR_LITERAL: 
                    case STRING_LITERAL: {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Matcher<ExpressionTree> stringLiteral(String value) {
        return new StringLiteral(value);
    }

    public static Matcher<ExpressionTree> stringLiteral(Pattern pattern) {
        return new StringLiteral(pattern);
    }

    public static Matcher<ExpressionTree> booleanLiteral(final boolean value) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                if (expressionTree.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                    return value == (Boolean)((LiteralTree)expressionTree).getValue();
                }
                return false;
            }
        };
    }

    public static Matcher<ExpressionTree> booleanConstant(final boolean value) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                Symbol symbol;
                if (expressionTree instanceof JCTree.JCFieldAccess && (symbol = ASTHelpers.getSymbol(expressionTree)).isStatic() && state.getTypes().unboxedTypeOrType(symbol.type).getTag() == TypeTag.BOOLEAN) {
                    return value && symbol.getSimpleName().contentEquals("TRUE") || symbol.getSimpleName().contentEquals("FALSE");
                }
                return false;
            }
        };
    }

    public static Matcher<ExpressionTree> ignoreParens(final Matcher<ExpressionTree> innerMatcher) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                return innerMatcher.matches((ExpressionTree)((Object)TreeInfo.skipParens((JCTree)((Object)expressionTree))), state);
            }
        };
    }

    public static Matcher<ExpressionTree> intLiteral(final int value) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                if (expressionTree.getKind() == Tree.Kind.INT_LITERAL) {
                    return ((Integer)((LiteralTree)expressionTree).getValue()).equals(value);
                }
                return false;
            }
        };
    }

    public static Matcher<ExpressionTree> classLiteral(final Matcher<? super ExpressionTree> classMatcher) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
                    MemberSelectTree select = (MemberSelectTree)expressionTree;
                    return select.getIdentifier().contentEquals("class") && classMatcher.matches(select.getExpression(), state);
                }
                return false;
            }
        };
    }

    public static Matcher<AnnotationTree> hasArgumentWithValue(String argumentName, Matcher<ExpressionTree> valueMatcher) {
        return new AnnotationHasArgumentWithValue(argumentName, valueMatcher);
    }

    public static Matcher<AnnotationTree> doesNotHaveArgument(String argumentName) {
        return new AnnotationDoesNotHaveArgument(argumentName);
    }

    public static Matcher<AnnotationTree> isType(String annotationClassName) {
        return new AnnotationType(annotationClassName);
    }

    public static Matcher<? super MethodInvocationTree> sameArgument(final int index1, final int index2) {
        return new Matcher<MethodInvocationTree>(){

            @Override
            public boolean matches(MethodInvocationTree methodInvocationTree, VisitorState state) {
                List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
                return ASTHelpers.sameVariable(args.get(index1), args.get(index2));
            }
        };
    }

    public static <T extends Tree> Matcher<T> hasAnnotation(final String annotationClass) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T tree, VisitorState state) {
                return ASTHelpers.hasAnnotation(ASTHelpers.getSymbol(tree), annotationClass, state);
            }
        };
    }

    public static <T extends Tree> Matcher<T> hasAnnotation(final Class<? extends Annotation> inputClass) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T tree, VisitorState state) {
                return ASTHelpers.hasAnnotation(ASTHelpers.getSymbol(tree), (Class<? extends Annotation>)inputClass, state);
            }
        };
    }

    public static Matcher<MethodTree> hasAnnotationOnAnyOverriddenMethod(final String annotationClass) {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree tree, VisitorState state) {
                Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol(tree);
                if (methodSym == null) {
                    return false;
                }
                if (ASTHelpers.hasAnnotation((Symbol)methodSym, annotationClass, state)) {
                    return true;
                }
                for (Symbol.MethodSymbol method : ASTHelpers.findSuperMethods(methodSym, state.getTypes())) {
                    if (!ASTHelpers.hasAnnotation((Symbol)method, annotationClass, state)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Matcher<ExpressionTree> methodReturnsNonNull() {
        return Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("java.lang.Object").named("toString"), Matchers.instanceMethod().onExactClass("java.lang.String"), Matchers.staticMethod().onClass("java.lang.String"), Matchers.instanceMethod().onExactClass("java.util.StringTokenizer").named("nextToken"));
    }

    public static Matcher<MethodTree> methodReturns(final Matcher<? super Tree> returnTypeMatcher) {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree methodTree, VisitorState state) {
                Tree returnTree = methodTree.getReturnType();
                if (returnTree == null) {
                    return false;
                }
                return returnTypeMatcher.matches(returnTree, state);
            }
        };
    }

    public static Matcher<MethodTree> methodReturns(Supplier<Type> returnType) {
        return Matchers.methodReturns(Matchers.isSameType(returnType));
    }

    public static Matcher<MethodTree> methodReturnsNonPrimitiveType() {
        return Matchers.methodReturns(Matchers.not(Matchers.isPrimitiveType()));
    }

    public static Matcher<MethodTree> methodIsNamed(final String methodName) {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree methodTree, VisitorState state) {
                return methodTree.getName().contentEquals(methodName);
            }
        };
    }

    public static Matcher<MethodTree> methodNameStartsWith(final String prefix) {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree methodTree, VisitorState state) {
                return methodTree.getName().toString().startsWith(prefix);
            }
        };
    }

    public static Matcher<MethodTree> methodWithClassAndName(final String className, final String methodName) {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree methodTree, VisitorState state) {
                return ((Symbol)ASTHelpers.getSymbol(methodTree).getEnclosingElement()).getQualifiedName().contentEquals(className) && methodTree.getName().contentEquals(methodName);
            }
        };
    }

    @SafeVarargs
    public static Matcher<MethodTree> methodHasParameters(final Matcher<VariableTree> ... variableMatcher) {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree methodTree, VisitorState state) {
                if (methodTree.getParameters().size() != variableMatcher.length) {
                    return false;
                }
                int paramIndex = 0;
                for (Matcher eachVariableMatcher : variableMatcher) {
                    if (eachVariableMatcher.matches((Tree)methodTree.getParameters().get(paramIndex++), state)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static MultiMatcher<MethodTree, VariableTree> methodHasParameters(ChildMultiMatcher.MatchType matchType, Matcher<VariableTree> parameterMatcher) {
        return new MethodHasParameters(matchType, parameterMatcher);
    }

    public static Matcher<MethodTree> methodHasVisibility(MethodVisibility.Visibility visibility) {
        return new MethodVisibility(visibility);
    }

    public static Matcher<MethodTree> methodIsConstructor() {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree methodTree, VisitorState state) {
                return ASTHelpers.getSymbol(methodTree).isConstructor();
            }
        };
    }

    public static Matcher<MethodTree> constructorOfClass(final String className) {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree methodTree, VisitorState state) {
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(methodTree);
                return ((Symbol)symbol).getEnclosingElement().getQualifiedName().contentEquals(className) && symbol.isConstructor();
            }
        };
    }

    public static Matcher<ClassTree> hasMethod(final Matcher<MethodTree> methodMatcher) {
        return new Matcher<ClassTree>(){

            @Override
            public boolean matches(ClassTree t, VisitorState state) {
                for (Tree tree : t.getMembers()) {
                    if (!(tree instanceof MethodTree) || !methodMatcher.matches((MethodTree)tree, state)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Matcher<VariableTree> variableType(final Matcher<Tree> treeMatcher) {
        return new Matcher<VariableTree>(){

            @Override
            public boolean matches(VariableTree variableTree, VisitorState state) {
                return treeMatcher.matches(variableTree.getType(), state);
            }
        };
    }

    public static Matcher<VariableTree> variableInitializer(final Matcher<ExpressionTree> expressionTreeMatcher) {
        return new Matcher<VariableTree>(){

            @Override
            public boolean matches(VariableTree variableTree, VisitorState state) {
                ExpressionTree initializer = variableTree.getInitializer();
                return initializer == null ? false : expressionTreeMatcher.matches(initializer, state);
            }
        };
    }

    public static Matcher<VariableTree> isField() {
        return new Matcher<VariableTree>(){

            @Override
            public boolean matches(VariableTree variableTree, VisitorState state) {
                Symbol.VarSymbol element = ASTHelpers.getSymbol(variableTree);
                return element.getKind() == ElementKind.FIELD;
            }
        };
    }

    public static Matcher<ClassTree> nestingKind(final NestingKind kind) {
        return new Matcher<ClassTree>(){

            @Override
            public boolean matches(ClassTree classTree, VisitorState state) {
                Symbol.ClassSymbol sym = ASTHelpers.getSymbol(classTree);
                return sym.getNestingKind() == kind;
            }
        };
    }

    public static Matcher<ExpressionTree> isDescendantOfMethod(String fullClassName, String methodName) {
        return new DescendantOf(fullClassName, methodName);
    }

    public static Matcher<BinaryTree> binaryTree(final Matcher<ExpressionTree> matcher1, final Matcher<ExpressionTree> matcher2) {
        return new Matcher<BinaryTree>(){

            @Override
            public boolean matches(BinaryTree t, VisitorState state) {
                return null != ASTHelpers.matchBinaryTree(t, Arrays.asList(matcher1, matcher2), state);
            }
        };
    }

    public static Matcher<Tree> hasIdentifier(Matcher<IdentifierTree> nodeMatcher) {
        return new HasIdentifier(nodeMatcher);
    }

    public static Matcher<ExpressionTree> selectedIsInstance() {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expr, VisitorState state) {
                if (!(expr instanceof JCTree.JCFieldAccess)) {
                    return false;
                }
                JCTree.JCExpression selected = ((JCTree.JCFieldAccess)expr).getExpression();
                if (selected instanceof JCTree.JCNewClass) {
                    return true;
                }
                Symbol sym = ASTHelpers.getSymbol(selected);
                return sym instanceof Symbol.VarSymbol;
            }
        };
    }

    public static <T extends Tree> Matcher<T> hasModifier(final Modifier modifier) {
        return new Matcher<T>(){

            @Override
            public boolean matches(T tree, VisitorState state) {
                Symbol sym = ASTHelpers.getSymbol(tree);
                return sym != null && sym.getModifiers().contains((Object)modifier);
            }
        };
    }

    public static Matcher<ExpressionTree> staticFieldAccess() {
        return Matchers.allOf(Matchers.isStatic(), Matchers.isSymbol(Symbol.VarSymbol.class));
    }

    public static <T extends Tree> Matcher<T> isStatic() {
        return new Matcher<T>(){

            @Override
            public boolean matches(Tree tree, VisitorState state) {
                Symbol sym = ASTHelpers.getSymbol(tree);
                return sym != null && sym.isStatic();
            }
        };
    }

    public static Matcher<StatementTree> throwStatement(Matcher<? super ExpressionTree> thrownMatcher) {
        return new Throws(thrownMatcher);
    }

    public static Matcher<StatementTree> returnStatement(Matcher<? super ExpressionTree> returnedMatcher) {
        return new Returns(returnedMatcher);
    }

    public static Matcher<StatementTree> assertStatement(Matcher<ExpressionTree> conditionMatcher) {
        return new Asserts(conditionMatcher);
    }

    public static Matcher<StatementTree> continueStatement() {
        return new Matcher<StatementTree>(){

            @Override
            public boolean matches(StatementTree statementTree, VisitorState state) {
                return statementTree instanceof ContinueTree;
            }
        };
    }

    public static Matcher<StatementTree> expressionStatement(final Matcher<ExpressionTree> matcher) {
        return new Matcher<StatementTree>(){

            @Override
            public boolean matches(StatementTree statementTree, VisitorState state) {
                return statementTree instanceof ExpressionStatementTree && matcher.matches(((ExpressionStatementTree)statementTree).getExpression(), state);
            }
        };
    }

    static Matcher<Tree> isSymbol(Class<? extends Symbol> symbolClass) {
        return new IsSymbol(symbolClass);
    }

    public static <T extends Tree> Matcher<Tree> toType(final Class<T> type, final Matcher<? super T> matcher) {
        return new Matcher<Tree>(){

            @Override
            public boolean matches(Tree tree, VisitorState state) {
                return type.isInstance(tree) && matcher.matches((Tree)type.cast(tree), state);
            }
        };
    }

    public static final <T extends Tree> Matcher<T> inSynchronized() {
        return new Matcher<T>(){

            @Override
            public boolean matches(T tree, VisitorState state) {
                SynchronizedTree synchronizedTree = ASTHelpers.findEnclosingNode(state.getPath(), SynchronizedTree.class);
                if (synchronizedTree != null) {
                    return true;
                }
                MethodTree methodTree = ASTHelpers.findEnclosingNode(state.getPath(), MethodTree.class);
                return methodTree != null && methodTree.getModifiers().getFlags().contains((Object)Modifier.SYNCHRONIZED);
            }
        };
    }

    public static Matcher<ExpressionTree> sameVariable(final ExpressionTree expr) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree tree, VisitorState state) {
                return ASTHelpers.sameVariable(tree, expr);
            }
        };
    }

    public static Matcher<ExpressionTree> isNonNull() {
        return new NullnessMatcher(Nullness.NONNULL);
    }

    public static Matcher<ExpressionTree> isNull() {
        return new NullnessMatcher(Nullness.NULL);
    }

    public static Matcher<EnhancedForLoopTree> enhancedForLoop(final Matcher<VariableTree> variableMatcher, final Matcher<ExpressionTree> expressionMatcher, final Matcher<StatementTree> statementMatcher) {
        return new Matcher<EnhancedForLoopTree>(){

            @Override
            public boolean matches(EnhancedForLoopTree t, VisitorState state) {
                return variableMatcher.matches(t.getVariable(), state) && expressionMatcher.matches(t.getExpression(), state) && statementMatcher.matches(t.getStatement(), state);
            }
        };
    }

    public static <T extends Tree> Matcher<T> inLoop() {
        return new Matcher<T>(){

            @Override
            public boolean matches(Tree tree, VisitorState state) {
                TreePath path;
                Tree node = path.getLeaf();
                for (path = state.getPath().getParentPath(); path != null; path = path.getParentPath()) {
                    switch (node.getKind()) {
                        case METHOD: 
                        case CLASS: {
                            return false;
                        }
                        case WHILE_LOOP: 
                        case FOR_LOOP: 
                        case ENHANCED_FOR_LOOP: 
                        case DO_WHILE_LOOP: {
                            return true;
                        }
                    }
                    node = path.getLeaf();
                }
                return false;
            }
        };
    }

    public static Matcher<AssignmentTree> assignment(final Matcher<ExpressionTree> variableMatcher, final Matcher<? super ExpressionTree> expressionMatcher) {
        return new Matcher<AssignmentTree>(){

            @Override
            public boolean matches(AssignmentTree t, VisitorState state) {
                return variableMatcher.matches(t.getVariable(), state) && expressionMatcher.matches(t.getExpression(), state);
            }
        };
    }

    public static Matcher<TypeCastTree> typeCast(final Matcher<Tree> typeMatcher, final Matcher<ExpressionTree> expressionMatcher) {
        return new Matcher<TypeCastTree>(){

            @Override
            public boolean matches(TypeCastTree t, VisitorState state) {
                return typeMatcher.matches(t.getType(), state) && expressionMatcher.matches(t.getExpression(), state);
            }
        };
    }

    public static Matcher<AssertTree> assertionWithCondition(final Matcher<ExpressionTree> conditionMatcher) {
        return new Matcher<AssertTree>(){

            @Override
            public boolean matches(AssertTree tree, VisitorState state) {
                return conditionMatcher.matches(tree.getCondition(), state);
            }
        };
    }

    public static Matcher<Tree> contains(Matcher<Tree> treeMatcher) {
        return new Contains(treeMatcher);
    }

    public static Matcher<MethodTree> methodHasArity(final int arity) {
        return new Matcher<MethodTree>(){

            @Override
            public boolean matches(MethodTree methodTree, VisitorState state) {
                return methodTree.getParameters().size() == arity;
            }
        };
    }
}

