/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

public final class FindIdentifiers {
    public static Symbol findIdent(String name, VisitorState state) {
        Type.ClassType enclosingClass = ASTHelpers.getType((ClassTree)state.findEnclosing(ClassTree.class));
        if (enclosingClass == null || enclosingClass.tsym == null) {
            return null;
        }
        Env<AttrContext> env = Enter.instance(state.context).getClassEnv(enclosingClass.tsym);
        MethodTree enclosingMethod = (MethodTree)state.findEnclosing(MethodTree.class);
        if (enclosingMethod != null) {
            env = MemberEnter.instance(state.context).getMethodEnv((JCTree.JCMethodDecl)enclosingMethod, env);
        }
        try {
            Method method = Resolve.class.getDeclaredMethod("findIdent", Env.class, Name.class, Kinds.KindSelector.class);
            method.setAccessible(true);
            Symbol result = (Symbol)method.invoke((Object)Resolve.instance(state.context), env, state.getName(name), Kinds.KindSelector.VAR);
            return result.exists() ? result : null;
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    public static LinkedHashSet<Symbol.VarSymbol> findAllIdents(VisitorState state) {
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        Tree prev = state.getPath().getLeaf();
        for (Tree curr : state.getPath().getParentPath()) {
            switch (curr.getKind()) {
                case BLOCK: {
                    StatementTree statementTree;
                    Iterator<Tree> iterator = ((BlockTree)curr).getStatements().iterator();
                    while (iterator.hasNext() && !(statementTree = (StatementTree)iterator.next()).equals(prev)) {
                        FindIdentifiers.addIfVariable(statementTree, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    }
                    break;
                }
                case METHOD: {
                    for (VariableTree variableTree : ((MethodTree)curr).getParameters()) {
                        result.add((Object)ASTHelpers.getSymbol(variableTree));
                    }
                    break;
                }
                case CATCH: {
                    result.add((Object)ASTHelpers.getSymbol(((CatchTree)curr).getParameter()));
                    break;
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    for (Tree tree : ((ClassTree)curr).getMembers()) {
                        if (tree.equals(prev)) break;
                        FindIdentifiers.addIfVariable(tree, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    }
                    Type classType = ASTHelpers.getType(curr);
                    List list = state.getTypes().closure((Type)classType).tail;
                    for (Type type : list) {
                        Scope.WriteableScope scope = type.tsym.members();
                        ImmutableList.Builder builder = new ImmutableList.Builder();
                        for (Symbol var2 : scope.getSymbols(Symbol.VarSymbol.class::isInstance)) {
                            builder.add((Object)((Symbol.VarSymbol)var2));
                        }
                        result.addAll((Iterable)builder.build().reverse());
                    }
                    break;
                }
                case FOR_LOOP: {
                    FindIdentifiers.addAllIfVariable(((ForLoopTree)curr).getInitializer(), (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    result.add((Object)ASTHelpers.getSymbol(((EnhancedForLoopTree)curr).getVariable()));
                    break;
                }
                case TRY: {
                    TryTree tryTree = (TryTree)curr;
                    boolean inResources = false;
                    for (Tree tree : tryTree.getResources()) {
                        if (!tree.equals(prev)) continue;
                        inResources = true;
                        break;
                    }
                    if (inResources) {
                        for (Tree tree : tryTree.getResources()) {
                            if (tree.equals(prev)) break;
                            FindIdentifiers.addIfVariable(tree, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                        }
                        break;
                    }
                    if (!tryTree.getBlock().equals(prev)) break;
                    FindIdentifiers.addAllIfVariable(tryTree.getResources(), (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    break;
                }
                case COMPILATION_UNIT: {
                    for (ImportTree importTree : ((CompilationUnitTree)curr).getImports()) {
                        if (!importTree.isStatic() || importTree.getQualifiedIdentifier().getKind() != Tree.Kind.MEMBER_SELECT) continue;
                        MemberSelectTree memberSelectTree = (MemberSelectTree)importTree.getQualifiedIdentifier();
                        Scope.CompoundScope scope = state.getTypes().membersClosure(ASTHelpers.getType(memberSelectTree.getExpression()), false);
                        for (Symbol var3 : scope.getSymbols(sym -> sym instanceof Symbol.VarSymbol && sym.getSimpleName().equals(memberSelectTree.getIdentifier()))) {
                            result.add((Object)((Symbol.VarSymbol)var3));
                        }
                    }
                    break;
                }
            }
            prev = curr;
        }
        return result.build().stream().filter(var -> FindIdentifiers.isVisible(var, state.getPath())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean isVisible(Symbol.VarSymbol var, TreePath path) {
        switch (var.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: {
                java.util.List enclosingClasses = StreamSupport.stream(path.spliterator(), false).filter(tree -> tree instanceof ClassTree).map(ClassTree.class::cast).map(ASTHelpers::getSymbol).collect(Collectors.toCollection(ArrayList::new));
                if (!var.isStatic()) {
                    if (FindIdentifiers.inStaticContext(path)) {
                        return false;
                    }
                    if (FindIdentifiers.lowerThan(path, (curr, unused) -> curr instanceof ClassTree && ASTHelpers.getSymbol((ClassTree)curr).isStatic(), (curr, unused) -> curr instanceof ClassTree && ASTHelpers.getSymbol((ClassTree)curr).equals(var.owner))) {
                        return false;
                    }
                }
                if (enclosingClasses.contains(ASTHelpers.enclosingClass(var))) {
                    return true;
                }
                Symbol.PackageSymbol enclosingPackage = ((JCTree.JCCompilationUnit)path.getCompilationUnit()).packge;
                Set<Modifier> modifiers = var.getModifiers();
                if (Objects.equals(enclosingPackage, ASTHelpers.enclosingPackage(var))) {
                    return !modifiers.contains((Object)Modifier.PRIVATE);
                }
                return modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED);
            }
            case PARAMETER: 
            case LOCAL_VARIABLE: {
                return !FindIdentifiers.lowerThan(path, (curr, parent) -> curr.getKind() == Tree.Kind.LAMBDA_EXPRESSION || curr.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)curr).getClassBody() != null || curr.getKind() == Tree.Kind.CLASS && parent.getKind() == Tree.Kind.BLOCK, (curr, unused) -> Objects.equals(var.owner, ASTHelpers.getSymbol(curr))) || (var.flags() & 0x20000000010L) != 0L;
            }
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected variable type: " + (Object)((Object)var.getKind()));
    }

    private static boolean inStaticContext(TreePath path) {
        Tree prev = path.getLeaf();
        path = path.getParentPath();
        Symbol.ClassSymbol enclosingClass = ASTHelpers.getSymbol(ASTHelpers.findEnclosingNode(path, ClassTree.class));
        Symbol.ClassSymbol directSuperClass = (Symbol.ClassSymbol)enclosingClass.getSuperclass().tsym;
        for (Tree tree : path) {
            switch (tree.getKind()) {
                case METHOD: {
                    return ASTHelpers.getSymbol(tree).isStatic();
                }
                case BLOCK: {
                    if (!((BlockTree)tree).isStatic()) break;
                    return true;
                }
                case VARIABLE: {
                    VariableTree variableTree = (VariableTree)tree;
                    Symbol.VarSymbol variableSym = ASTHelpers.getSymbol(variableTree);
                    if (variableSym.getKind() != ElementKind.FIELD) break;
                    return Objects.equals(variableTree.getInitializer(), prev) && variableSym.isStatic();
                }
                case METHOD_INVOCATION: {
                    Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
                    if (!methodSym.isConstructor() || !Objects.equals(methodSym.owner, enclosingClass) && !Objects.equals(methodSym.owner, directSuperClass)) break;
                    return true;
                }
            }
            prev = tree;
        }
        return false;
    }

    private static void addIfVariable(Tree tree, ImmutableSet.Builder<Symbol.VarSymbol> setBuilder) {
        if (tree.getKind() == Tree.Kind.VARIABLE) {
            setBuilder.add((Object)ASTHelpers.getSymbol((VariableTree)tree));
        }
    }

    private static void addAllIfVariable(java.util.List<? extends Tree> list, ImmutableSet.Builder<Symbol.VarSymbol> setBuilder) {
        for (Tree tree : list) {
            FindIdentifiers.addIfVariable(tree, setBuilder);
        }
    }

    private static boolean lowerThan(TreePath path, BiPredicate<Tree, Tree> predicate1, BiPredicate<Tree, Tree> predicate2) {
        int index1 = -1;
        int index2 = -1;
        int count = 0;
        path = path.getParentPath();
        while (path != null) {
            Tree curr = path.getLeaf();
            TreePath parentPath = path.getParentPath();
            if (index1 < 0 && predicate1.test(curr, parentPath == null ? null : parentPath.getLeaf())) {
                index1 = count;
            }
            if (index2 < 0 && predicate2.test(curr, parentPath == null ? null : parentPath.getLeaf())) {
                index2 = count;
            }
            if (index1 >= 0 && index2 >= 0) break;
            path = parentPath;
            ++count;
        }
        return index1 >= 0 && index1 < index2;
    }

    private FindIdentifiers() {
    }
}

