---
layout: contribute
title: Bazel Users
---

# Corporate users of Bazel

## [Ascend.io](https://ascend.io)

Ascend is a Palo Alto startup that offers solutions for large data sets
analysis. Their motto is _Big data is hard. We make it easy_.

## [Beeswax](https://www.beeswax.com/) (_in their own words_)

"_Beeswax is a New York based startup that provides real time bidding as
service. Bazel powers their Jenkins based continuous integration and deployment
framework. Beeswax loves Bazel because it is blazingly fast, correct and well
supported across many languages and platforms._"

## [Braintree](https://www.braintreepayments.com)

Braintree, a PayPal subsidiary, develops payment solutions for websites and
applications. They use Bazel for parts of their internal build and Paul Gross
even posted a [nice piece about how their switch to
Bazel went](https://www.pgrs.net/2015/09/01/migrating-from-gradle-to-bazel/).

## [Databricks](https://databricks.com)

Databricks provides cloud-based integrated workspaces based on Apache Spark™.

## [Interaxon](https://www.choosemuse.com/)

InteraXon is a thought-controlled computing firm that creates hardware and
software platforms to convert brainwaves into digital signals.

## [Improbable.io](https://improbable.io/)

Improbable.io develops SpatialOS, a distributed operating system that enables
creating huge simulations inhabited by millions of complex entities.

## [Makani](https://www.google.com/makani)

Makani, now a Google subsidiary, develops energy kites and uses
Bazel to build their software (including their embedded C++ software).

## [Peloton Technology](http://www.peloton-tech.com)

Peloton Technology is an automated vehicle technology company that tackles
truck accidents and fuel use. They use Bazel to _enable reliable builds for
automotive safety systems_.

## [Stripe](https://stripe.com)

Stripe provides mobile payment solutions.  They are the main maintainers of the
[Bazel Scala rules](https://github.com/bazelbuild/rules_scala).

# Open-source projects using Bazel

If you'd like your project listed here, please
[let us know](mailto:kchodorow@google.com?subject=My project uses Bazel)!

## [CallBuilder](https://github.com/google/CallBuilder)

A Java code generator that allows you to create a builder by writing one
function.

## [Copybara](https://github.com/google/copybara)

Copybara is a tool for transforming and moving code between repositories.

## [Deepmind Lab](https://github.com/deepmind/lab)

A customisable 3D platform for agent-based AI research.

## [Error Prone](https://github.com/google/error-prone)

Catches common Java mistakes as compile-time errors. (Migration to Bazel is
in progress.)

## [FFruit](https://gitlab.com/perezd/ffruit/)

FFruit is a free & open source Android application to the popular service
[Falling Fruit](https://fallingfruit.org).

## [Gerrit Code Review](https://gerritcodereview.com)

Gerrit is a code review and project management tool for Git based projects.

## [Gitiles](https://gerrit.googlesource.com/gitiles/)

Gitiles is a simple repository browser for Git repositories, built on JGit.

## [GRPC](http://www.grpc.io)

A language-and-platform-neutral remote procedure call system. (Bazel is a
supported, although not primary, build system.)

## [Gulava](http://www.github.com/google/gulava/)

A Java code generator that lets you write Prolog-style predicates and use them
seamlessly from normal Java code.

## [Heron](http://twitter.github.io/heron/)

Heron is a realtime, distributed, fault-tolerant stream processing engine
from Twitter.

## [Jsonnet](http://google.github.io/jsonnet/doc/)

An elegant, formally-specified config generation language for JSON. (Bazel is a
supported build system.)

## [Kythe](https://github.com/google/kythe)

An ecosystem for building tools that work with code.

## [Nomulus](https://github.com/google/nomulus)

Top-level domain name registry service on Google App Engine.

## [PetitParser for Java](https://github.com/petitparser/java-petitparser)

Grammars for programming languages are traditionally specified statically. They
are hard to compose and reuse due to ambiguities that inevitably arise.
PetitParser combines ideas from scannnerless parsing, parser combinators,
parsing expression grammars and packrat parsers to model grammars and parsers
as objects that can be reconfigured dynamically.

## [TensorFlow](http://tensorflow.org)

An open source software library for machine intelligence.

## [Trunk](https://github.com/mzhaom/trunk)

A collection of C++/Java opensource projects with BUILD files so they
can be built with Bazel with out of box support for protobuf and
grpc (maybe thrift).

## [Turbo Santa](https://github.com/turbo-santa/turbo-santa-common)

A platform-independent GameBoy emulator.

## [Wycheproof](https://github.com/google/wycheproof)

Project Wycheproof tests crypto libraries against known attacks.

## [XIOSim](https://github.com/s-kanev/XIOSim)

XIOSim is a detailed user-mode microarchitectural simulator for the x86 architecture.

