/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.NonceGenerator;
import org.eclipse.jgit.transport.PushCertificate;

public class HMACSHA1NonceGenerator
implements NonceGenerator {
    private Mac mac;
    private static final String HEX = "0123456789ABCDEF";

    public HMACSHA1NonceGenerator(String seed) throws IllegalStateException {
        try {
            byte[] keyBytes = seed.getBytes("ISO-8859-1");
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            this.mac = Mac.getInstance("HmacSHA1");
            this.mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized String createNonce(Repository repo, long timestamp) throws IllegalStateException {
        byte[] rawHmac;
        String path;
        if (repo instanceof DfsRepository) {
            path = ((DfsRepository)repo).getDescription().getRepositoryName();
        } else if (repo.getDirectory() != null) {
            path = repo.getDirectory().getPath();
        } else {
            throw new IllegalStateException();
        }
        String input = path + ":" + String.valueOf(timestamp);
        try {
            rawHmac = this.mac.doFinal(input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return Long.toString(timestamp) + "-" + HMACSHA1NonceGenerator.toHex(rawHmac);
    }

    @Override
    public PushCertificate.NonceStatus verify(String received, String sent, Repository db, boolean allowSlop, int slop) {
        long advertisedStamp;
        long signedStamp;
        if (received.isEmpty()) {
            return PushCertificate.NonceStatus.MISSING;
        }
        if (sent.isEmpty()) {
            return PushCertificate.NonceStatus.UNSOLICITED;
        }
        if (received.equals(sent)) {
            return PushCertificate.NonceStatus.OK;
        }
        if (!allowSlop) {
            return PushCertificate.NonceStatus.BAD;
        }
        int idxSent = sent.indexOf(45);
        int idxRecv = received.indexOf(45);
        if (idxSent == -1 || idxRecv == -1) {
            return PushCertificate.NonceStatus.BAD;
        }
        try {
            signedStamp = Long.parseLong(received.substring(0, idxRecv));
            advertisedStamp = Long.parseLong(sent.substring(0, idxSent));
        }
        catch (Exception e) {
            return PushCertificate.NonceStatus.BAD;
        }
        String expect = this.createNonce(db, signedStamp);
        if (!expect.equals(received)) {
            return PushCertificate.NonceStatus.BAD;
        }
        long nonceStampSlop = Math.abs(advertisedStamp - signedStamp);
        if (nonceStampSlop <= (long)slop) {
            return PushCertificate.NonceStatus.OK;
        }
        return PushCertificate.NonceStatus.SLOP;
    }

    private static String toHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            builder.append(HEX.charAt((b & 0xF0) >> 4));
            builder.append(HEX.charAt(b & 0xF));
        }
        return builder.toString();
    }
}

