/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEntry;
import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.nio.serialization.Data;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.cache.Cache;

public abstract class AbstractClusterWideIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private static final int FETCH_SIZE = 100;
    protected ICache<K, V> cache;
    protected CacheKeyIteratorResult result;
    protected final int partitionCount;
    protected int partitionIndex = -1;
    protected int lastTableIndex;
    protected final int fetchSize;
    protected int index;
    protected int currentIndex = -1;

    public AbstractClusterWideIterator(ICache<K, V> cache, int partitionCount) {
        this.cache = cache;
        this.partitionCount = partitionCount;
        this.fetchSize = 100;
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        if (this.result != null && this.index < this.result.getCount()) {
            return true;
        }
        return this.advance();
    }

    @Override
    public Cache.Entry<K, V> next() {
        while (this.hasNext()) {
            this.currentIndex = this.index++;
            Data keyData = this.result.getKey(this.currentIndex);
            Object key = this.toObject(keyData);
            Object value = this.cache.get(key);
            if (value == null) continue;
            return new CacheEntry(key, value);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.ensureOpen();
        if (this.result == null || this.currentIndex < 0) {
            throw new IllegalStateException("Iterator.next() must be called before remove()!");
        }
        Data keyData = this.result.getKey(this.currentIndex);
        Object key = this.toObject(keyData);
        this.cache.remove(key);
        this.currentIndex = -1;
    }

    protected boolean advance() {
        while (this.partitionIndex < this.getPartitionCount()) {
            if (this.result == null || this.result.getCount() < this.fetchSize || this.lastTableIndex < 0) {
                ++this.partitionIndex;
                this.lastTableIndex = Integer.MAX_VALUE;
                this.result = null;
                if (this.partitionIndex == this.getPartitionCount()) {
                    return false;
                }
            }
            this.result = this.fetch();
            if (this.result == null || this.result.getCount() <= 0) continue;
            this.index = 0;
            this.lastTableIndex = this.result.getTableIndex();
            return true;
        }
        return false;
    }

    protected void ensureOpen() {
        if (this.cache.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    protected int getPartitionCount() {
        return this.partitionCount;
    }

    protected abstract CacheKeyIteratorResult fetch();

    protected abstract Data toData(Object var1);

    protected abstract <T> T toObject(Object var1);
}

