/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.util.DataSink;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessFileDataSink
implements DataSink {
    private final RandomAccessFile mFile;
    private final FileChannel mFileChannel;
    private long mPosition;

    public RandomAccessFileDataSink(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, 0L);
    }

    public RandomAccessFileDataSink(RandomAccessFile randomAccessFile, long l) {
        if (randomAccessFile == null) {
            throw new NullPointerException("file == null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("startPosition: " + l);
        }
        this.mFile = randomAccessFile;
        this.mFileChannel = randomAccessFile.getChannel();
        this.mPosition = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        RandomAccessFile randomAccessFile = this.mFile;
        synchronized (randomAccessFile) {
            this.mFile.seek(this.mPosition);
            this.mFile.write(byArray, n, n2);
            this.mPosition += (long)n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n == 0) {
            return;
        }
        RandomAccessFile randomAccessFile = this.mFile;
        synchronized (randomAccessFile) {
            this.mFile.seek(this.mPosition);
            while (byteBuffer.hasRemaining()) {
                this.mFileChannel.write(byteBuffer);
            }
            this.mPosition += (long)n;
        }
    }
}

