/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    IDataObject iDataObject;
    COMObject iDropTarget;
    int refCount;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static /* synthetic */ Class class$0;

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.createCOMInterfaces();
        this.AddRef();
        if (COM.CoLockObjectExternal(this.iDropTarget.getAddress(), true, true) != 0) {
            DND.error(2001);
        }
        if (COM.RegisterDragDrop(control.handle, this.iDropTarget.getAddress()) != 0) {
            DND.error(2001);
        }
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    void createCOMInterfaces() {
        boolean bl = C.PTR_SIZEOF == 4;
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[3] = bl ? 5 : 4;
        nArray[4] = bl ? 4 : 3;
        nArray[6] = bl ? 5 : 4;
        this.iDropTarget = new COMObject(nArray){

            public long method0(long[] lArray) {
                return DropTarget.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return DropTarget.this.AddRef();
            }

            public long method2(long[] lArray) {
                return DropTarget.this.Release();
            }

            public long method3(long[] lArray) {
                if (lArray.length == 5) {
                    return DropTarget.this.DragEnter(lArray[0], (int)lArray[1], (int)lArray[2], (int)lArray[3], lArray[4]);
                }
                return DropTarget.this.DragEnter_64(lArray[0], (int)lArray[1], lArray[2], lArray[3]);
            }

            public long method4(long[] lArray) {
                if (lArray.length == 4) {
                    return DropTarget.this.DragOver((int)lArray[0], (int)lArray[1], (int)lArray[2], lArray[3]);
                }
                return DropTarget.this.DragOver_64((int)lArray[0], lArray[1], lArray[2]);
            }

            public long method5(long[] lArray) {
                return DropTarget.this.DragLeave();
            }

            public long method6(long[] lArray) {
                if (lArray.length == 5) {
                    return DropTarget.this.Drop(lArray[0], (int)lArray[1], (int)lArray[2], (int)lArray[3], lArray[4]);
                }
                return DropTarget.this.Drop_64(lArray[0], (int)lArray[1], lArray[2], lArray[3]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.iDropTarget != null) {
            this.iDropTarget.dispose();
        }
        this.iDropTarget = null;
    }

    int DragEnter_64(long l, int n, long l2, long l3) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l2}, 8);
        return this.DragEnter(l, n, pOINT.x, pOINT.y, l3);
    }

    int DragEnter(long l, int n, int n2, int n3, long l2) {
        this.selectedDataType = null;
        this.selectedOperation = 0;
        if (this.iDataObject != null) {
            this.iDataObject.Release();
        }
        this.iDataObject = null;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, l, n, n2, n3, l2)) {
            OS.MoveMemory(l2, new int[1], 4);
            return 1;
        }
        this.iDataObject = new IDataObject(l);
        this.iDataObject.AddRef();
        int n4 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.notifyListeners(2002, dNDEvent);
        this.refresh();
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n4 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        int n5 = 0;
        while (n5 < transferDataArray.length) {
            if (TransferData.sameType(transferDataArray[n5], dNDEvent.dataType)) {
                this.selectedDataType = transferDataArray[n5];
                break;
            }
            ++n5;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n4 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(l2, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    int DragLeave() {
        this.keyOperation = -1;
        if (this.iDataObject == null) {
            return 1;
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        this.refresh();
        this.iDataObject.Release();
        this.iDataObject = null;
        return 0;
    }

    int DragOver_64(int n, long l, long l2) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l}, 8);
        return this.DragOver(n, pOINT.x, pOINT.y, l2);
    }

    int DragOver(int n, int n2, int n3, long l) {
        if (this.iDataObject == null) {
            return 1;
        }
        int n4 = this.keyOperation;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, this.iDataObject.getAddress(), n, n2, n3, l)) {
            this.keyOperation = -1;
            OS.MoveMemory(l, new int[1], 4);
            return 1;
        }
        int n5 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (this.keyOperation == n4) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.notifyListeners(dNDEvent.type, dNDEvent);
        this.refresh();
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n5 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        int n6 = 0;
        while (n6 < transferDataArray.length) {
            if (TransferData.sameType(transferDataArray[n6], dNDEvent.dataType)) {
                this.selectedDataType = transferDataArray[n6];
                break;
            }
            ++n6;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n5 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(l, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    int Drop_64(long l, int n, long l2, long l3) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l2}, 8);
        return this.Drop(l, n, pOINT.x, pOINT.y, l3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int Drop(long l, int n, int n2, int n3, long l2) {
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(n2, n3);
        }
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        this.refresh();
        dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, l, n, n2, n3, l2)) {
            this.keyOperation = -1;
            OS.MoveMemory(l2, new int[1], 4);
            return 1;
        }
        this.keyOperation = -1;
        int n4 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.notifyListeners(2007, dNDEvent);
        this.refresh();
        this.selectedDataType = null;
        int n5 = 0;
        while (n5 < transferDataArray.length) {
            if (TransferData.sameType(transferDataArray[n5], dNDEvent.dataType)) {
                this.selectedDataType = transferDataArray[n5];
                break;
            }
            ++n5;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n4 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            OS.MoveMemory(l2, new int[1], 4);
            return 0;
        }
        Object object = null;
        int n6 = 0;
        while (n6 < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[n6];
            if (transfer != null && transfer.isSupportedType(this.selectedDataType)) {
                object = transfer.nativeToJava(this.selectedDataType);
                break;
            }
            ++n6;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.data = object;
        OS.ImageList_DragShowNolock(false);
        try {
            this.notifyListeners(2006, dNDEvent);
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            OS.ImageList_DragShowNolock(true);
            throw throwable;
        }
        {
            Object var12_13 = null;
        }
        OS.ImageList_DragShowNolock(true);
        this.refresh();
        this.selectedOperation = 0;
        if ((n4 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(l2, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listenerArray = this.getListeners(2002);
        int n = listenerArray.length;
        DropTargetListener[] dropTargetListenerArray = new DropTargetListener[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Listener listener = listenerArray[n3];
            if (listener instanceof DNDListener) {
                dropTargetListenerArray[n2] = (DropTargetListener)((DNDListener)listener).getEventListener();
                ++n2;
            }
            ++n3;
        }
        if (n2 == n) {
            return dropTargetListenerArray;
        }
        DropTargetListener[] dropTargetListenerArray2 = new DropTargetListener[n2];
        System.arraycopy(dropTargetListenerArray, 0, dropTargetListenerArray2, 0, n2);
        return dropTargetListenerArray2;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState(int n) {
        boolean bl;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = bl = (n & 0x20) != 0;
        if (bl) {
            if (bl2 || bl3) {
                return 16;
            }
            return 4;
        }
        if (bl2 && bl3) {
            return 4;
        }
        if (bl2) {
            return 1;
        }
        if (bl3) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        COM.RevokeDragDrop(this.control.handle);
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control = null;
        COM.CoLockObjectExternal(this.iDropTarget.getAddress(), false, true);
        this.Release();
        if (this.iDataObject != null) {
            this.iDataObject.Release();
        }
        this.iDataObject = null;
        if (COM.FreeUnusedLibraries) {
            COM.CoFreeUnusedLibraries();
        }
    }

    int opToOs(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    int osToOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDropTarget)) {
            COM.MoveMemory(l2, new long[]{this.iDropTarget.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(l2, new long[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    void refresh() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        long l = this.control.handle;
        RECT rECT = new RECT();
        if (OS.GetUpdateRect(l, rECT, false)) {
            OS.ImageList_DragShowNolock(false);
            OS.RedrawWindow(l, rECT, 0L, 257);
            OS.ImageList_DragShowNolock(true);
        }
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setEventData(DNDEvent dNDEvent, long l, int n, int n2, int n3, long l2) {
        IDataObject iDataObject;
        TransferData[] transferDataArray;
        int n4;
        int[] nArray;
        block22: {
            block21: {
                if (l == 0L || l2 == 0L) {
                    return false;
                }
                int n5 = this.getStyle();
                nArray = new int[1];
                OS.MoveMemory(nArray, l2, 4);
                nArray[0] = this.osToOp(nArray[0]) & n5;
                if (nArray[0] == 0) {
                    return false;
                }
                this.keyOperation = n4 = this.getOperationFromKeyState(n);
                if (n4 == 16) {
                    if ((n5 & 0x10) == 0) {
                        n4 = (nArray[0] & 2) != 0 ? 2 : 0;
                    }
                } else if ((n4 & nArray[0]) == 0) {
                    n4 = 0;
                }
                transferDataArray = new TransferData[]{};
                iDataObject = new IDataObject(l);
                iDataObject.AddRef();
                try {
                    long[] lArray = new long[1];
                    if (iDataObject.EnumFormatEtc(1, lArray) != 0) {
                        Object var27_13 = null;
                        break block21;
                    }
                    IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(lArray[0]);
                    try {
                        long l3 = OS.GlobalAlloc(64, FORMATETC.sizeof);
                        try {
                            int[] nArray2 = new int[1];
                            iEnumFORMATETC.Reset();
                            block9: while (iEnumFORMATETC.Next(1, l3, nArray2) == 0 && nArray2[0] == 1) {
                                TransferData transferData = new TransferData();
                                transferData.formatetc = new FORMATETC();
                                COM.MoveMemory(transferData.formatetc, l3, FORMATETC.sizeof);
                                transferData.type = transferData.formatetc.cfFormat;
                                transferData.pIDataObject = l;
                                int n6 = 0;
                                while (n6 < this.transferAgents.length) {
                                    Transfer transfer = this.transferAgents[n6];
                                    if (transfer != null && transfer.isSupportedType(transferData)) {
                                        TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + 1];
                                        System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                                        transferDataArray2[transferDataArray.length] = transferData;
                                        transferDataArray = transferDataArray2;
                                        continue block9;
                                    }
                                    ++n6;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var23_24 = null;
                            OS.GlobalFree(l3);
                            throw throwable;
                        }
                        {
                            Object var23_25 = null;
                            OS.GlobalFree(l3);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var25_27 = null;
                        iEnumFORMATETC.Release();
                        throw throwable;
                    }
                    {
                        Object var25_28 = null;
                        iEnumFORMATETC.Release();
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    Object var27_14 = null;
                    iDataObject.Release();
                    throw throwable;
                }
            }
            iDataObject.Release();
            return false;
        }
        Object var27_15 = null;
        iDataObject.Release();
        if (transferDataArray.length == 0) {
            return false;
        }
        dNDEvent.widget = this;
        dNDEvent.x = n2;
        dNDEvent.y = n3;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(n2, n3);
        }
        dNDEvent.operations = nArray[0];
        dNDEvent.detail = n4;
        return true;
    }

    public void setTransfer(Transfer[] transferArray) {
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
    }
}

