# .NET Core November 2017 Update - Released 11/14/2017

.NET Core 1.0.8, 1.1.5 and SDK 1.1.5 are available for download and usage in your environment.

## Downloads

* [.NET Core 1.0.8](https://github.com/dotnet/core/blob/master/release-notes/download-archives/1.0.8.md)
* [.NET Core 1.1.5](https://github.com/dotnet/core/blob/master/release-notes/download-archives/1.1.5.md)

After installing the .NET Core SDK 1.1.5, the following command will show that you're running version `1.1.5` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created [dotnet/core #????](https://github.com/dotnet/core/issues/???) for your questions and comments.

## Azure AppServices

Deployment of the November 2017 Update on Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carefully staged across regions over a period of time. Availability will begin in the West US 2 region today and gradually expand to all regions over the next few days.

## November Update Highlights

### Security Advisories

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 1.1.5 images.

## Fixes in the November 2017 Update

### 1.0.8

## CoreCLR

* [`[54f1cf6]`](https://github.com/dotnet/coreclr/commit/54f1cf6) Port to 1.0.0 - Fix passing struct with four floats in registers via reflection (#14392)
* [`[0ddcf7e]`](https://github.com/dotnet/coreclr/commit/0ddcf7e) Fix resource lookup recursion issue (#13948)
* [`[254df57]`](https://github.com/dotnet/coreclr/commit/254df57) Remove FreeBSD 10.1/OpenSuSE 13.2 and Fedora 23 (#13634)

## CoreFX

* [`[686812c]`](https://github.com/dotnet/corefx/commit/686812c) rel/1.0.0: Fix ECDsa ExportParameters segfault (#24458)
* [`[88f43c3]`](https://github.com/dotnet/corefx/commit/88f43c3) Remove EOL'd OS's openSuSE 13.2 and Fedora 23 have been EOL'd and are no longer usable/upgradeable in CI. (#23621)
* [`[ec5640f]`](https://github.com/dotnet/corefx/commit/ec5640f) Fix handling of flock in FileStream on Unix (#23235)
* [`[e13c1b0]`](https://github.com/dotnet/corefx/commit/e13c1b0) Packaging updates to service X509Certificates
* [`[47d95a6]`](https://github.com/dotnet/corefx/commit/47d95a6) Simplify X509Chain building with OpenSSL
* [`[a077f83]`](https://github.com/dotnet/corefx/commit/a077f83) add apfs introduced by OSX 10.13
* [`[3af071c]`](https://github.com/dotnet/corefx/commit/3af071c) Prevent crash when Openssl's PKCS12_parse function fails.

### 1.1.5

## CoreCLR

* [`[2820bd8]`](https://github.com/dotnet/coreclr/commit/2820bd8) Convert literals to hex literals in k-nucleotide-9
* [`[2278610]`](https://github.com/dotnet/coreclr/commit/2278610) Fix resource lookup recursion issue (#13945)
* [`[ad68ca9]`](https://github.com/dotnet/coreclr/commit/ad68ca9) Remove EOL openSuSE 42.1 (#13691)
* [`[0cb88b8]`](https://github.com/dotnet/coreclr/commit/0cb88b8) Remove FreeBSD 10.1/OpenSuSE 13.2 and Fedora 23 (#13635)
* [`[0ac7078]`](https://github.com/dotnet/coreclr/commit/0ac7078) Port of https://github.com/dotnet/coreclr/pull/12795 to release/1.1.0 (#12942)

## CoreFX

* [`[aff7844]`](https://github.com/dotnet/corefx/commit/aff7844) Fix ECDsa ExportParameters segfault
* [`[617d183]`](https://github.com/dotnet/corefx/commit/617d183) Remove EOL openSuSE 42.1 (#23682)
* [`[3d76b76]`](https://github.com/dotnet/corefx/commit/3d76b76) Update CoreClr, CoreFx to servicing-25629-01, servicing-25629-01, respectively
* [`[374c767]`](https://github.com/dotnet/corefx/commit/374c767) Remove EOL'd OS's openSuSE 13.2 and Fedora 23 (#23622)
* [`[144bfd9]`](https://github.com/dotnet/corefx/commit/144bfd9) Packaging updates to service X509Certificates
* [`[3a3dda9]`](https://github.com/dotnet/corefx/commit/3a3dda9) Simplify X509Chain building with OpenSSL
* [`[710d628]`](https://github.com/dotnet/corefx/commit/710d628) Put System.Net.Http for servicing.
* [`[3d2debc]`](https://github.com/dotnet/corefx/commit/3d2debc) add apfs introduced in osx 10.13
