use crate as pg_sys;
#[cfg(any(feature = "pg12", feature = "pg13", feature = "pg14"))]
use crate::NullableDatum;
use crate::{Datum, PgNode};
#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") { 7 - (index % 8) } else { index % 8 };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") { 7 - (index % 8) } else { index % 8 };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index =
                    if cfg!(target_endian = "big") { bit_width as usize - 1 - i } else { i };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") { bit_width as usize - 1 - i } else { i };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const PG_DIAG_SEVERITY: u8 = 83u8;
pub const PG_DIAG_SEVERITY_NONLOCALIZED: u8 = 86u8;
pub const PG_DIAG_SQLSTATE: u8 = 67u8;
pub const PG_DIAG_MESSAGE_PRIMARY: u8 = 77u8;
pub const PG_DIAG_MESSAGE_DETAIL: u8 = 68u8;
pub const PG_DIAG_MESSAGE_HINT: u8 = 72u8;
pub const PG_DIAG_STATEMENT_POSITION: u8 = 80u8;
pub const PG_DIAG_INTERNAL_POSITION: u8 = 112u8;
pub const PG_DIAG_INTERNAL_QUERY: u8 = 113u8;
pub const PG_DIAG_CONTEXT: u8 = 87u8;
pub const PG_DIAG_SCHEMA_NAME: u8 = 115u8;
pub const PG_DIAG_TABLE_NAME: u8 = 116u8;
pub const PG_DIAG_COLUMN_NAME: u8 = 99u8;
pub const PG_DIAG_DATATYPE_NAME: u8 = 100u8;
pub const PG_DIAG_CONSTRAINT_NAME: u8 = 110u8;
pub const PG_DIAG_SOURCE_FILE: u8 = 70u8;
pub const PG_DIAG_SOURCE_LINE: u8 = 76u8;
pub const PG_DIAG_SOURCE_FUNCTION: u8 = 82u8;
pub const ALIGNOF_DOUBLE: u32 = 8;
pub const ALIGNOF_INT: u32 = 4;
pub const ALIGNOF_LONG: u32 = 8;
pub const ALIGNOF_PG_INT128_TYPE: u32 = 16;
pub const ALIGNOF_SHORT: u32 = 2;
pub const BLCKSZ: u32 = 8192;
pub const CONFIGURE_ARGS : & [u8 ; 106usize] = b" '--prefix=/home/atelier/.pgx/13.8/pgx-install' '--with-pgport=28813' '--enable-debug' '--enable-cassert'\0" ;
pub const DEF_PGPORT: u32 = 28813;
pub const DEF_PGPORT_STR: &[u8; 6usize] = b"28813\0";
pub const ENABLE_THREAD_SAFETY: u32 = 1;
pub const HAVE_APPEND_HISTORY: u32 = 1;
pub const HAVE_ATOMICS: u32 = 1;
pub const HAVE_BACKTRACE_SYMBOLS: u32 = 1;
pub const HAVE_CLOCK_GETTIME: u32 = 1;
pub const HAVE_COMPUTED_GOTO: u32 = 1;
pub const HAVE_DECL_FDATASYNC: u32 = 1;
pub const HAVE_DECL_F_FULLFSYNC: u32 = 0;
pub const HAVE_DECL_POSIX_FADVISE: u32 = 1;
pub const HAVE_DECL_RTLD_GLOBAL: u32 = 1;
pub const HAVE_DECL_RTLD_NOW: u32 = 1;
pub const HAVE_DECL_STRLCAT: u32 = 0;
pub const HAVE_DECL_STRLCPY: u32 = 0;
pub const HAVE_DECL_STRNLEN: u32 = 1;
pub const HAVE_DECL_STRTOLL: u32 = 1;
pub const HAVE_DECL_STRTOULL: u32 = 1;
pub const HAVE_DLOPEN: u32 = 1;
pub const HAVE_EXECINFO_H: u32 = 1;
pub const HAVE_EXPLICIT_BZERO: u32 = 1;
pub const HAVE_FDATASYNC: u32 = 1;
pub const HAVE_FSEEKO: u32 = 1;
pub const HAVE_FUNCNAME__FUNC: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT64_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_CHAR_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT64_CAS: u32 = 1;
pub const HAVE_GETADDRINFO: u32 = 1;
pub const HAVE_GETHOSTBYNAME_R: u32 = 1;
pub const HAVE_GETIFADDRS: u32 = 1;
pub const HAVE_GETOPT: u32 = 1;
pub const HAVE_GETOPT_H: u32 = 1;
pub const HAVE_GETOPT_LONG: u32 = 1;
pub const HAVE_GETPWUID_R: u32 = 1;
pub const HAVE_GETRLIMIT: u32 = 1;
pub const HAVE_GETRUSAGE: u32 = 1;
pub const HAVE_HISTORY_TRUNCATE_FILE: u32 = 1;
pub const HAVE_IFADDRS_H: u32 = 1;
pub const HAVE_INET_ATON: u32 = 1;
pub const HAVE_INTTYPES_H: u32 = 1;
pub const HAVE_INT_OPTERR: u32 = 1;
pub const HAVE_INT_TIMEZONE: u32 = 1;
pub const HAVE_IPV6: u32 = 1;
pub const HAVE_LANGINFO_H: u32 = 1;
pub const HAVE_LIBM: u32 = 1;
pub const HAVE_LIBREADLINE: u32 = 1;
pub const HAVE_LIBZ: u32 = 1;
pub const HAVE_LINK: u32 = 1;
pub const HAVE_LOCALE_T: u32 = 1;
pub const HAVE_LONG_INT_64: u32 = 1;
pub const HAVE_MEMORY_H: u32 = 1;
pub const HAVE_MKDTEMP: u32 = 1;
pub const HAVE_NETINET_TCP_H: u32 = 1;
pub const HAVE_NET_IF_H: u32 = 1;
pub const HAVE_POLL: u32 = 1;
pub const HAVE_POLL_H: u32 = 1;
pub const HAVE_POSIX_FADVISE: u32 = 1;
pub const HAVE_POSIX_FALLOCATE: u32 = 1;
pub const HAVE_PPOLL: u32 = 1;
pub const HAVE_PREAD: u32 = 1;
pub const HAVE_PTHREAD: u32 = 1;
pub const HAVE_PTHREAD_PRIO_INHERIT: u32 = 1;
pub const HAVE_PWRITE: u32 = 1;
pub const HAVE_RANDOM: u32 = 1;
pub const HAVE_READLINE_HISTORY_H: u32 = 1;
pub const HAVE_READLINE_READLINE_H: u32 = 1;
pub const HAVE_READLINK: u32 = 1;
pub const HAVE_RL_COMPLETION_APPEND_CHARACTER: u32 = 1;
pub const HAVE_RL_COMPLETION_MATCHES: u32 = 1;
pub const HAVE_RL_COMPLETION_SUPPRESS_QUOTE: u32 = 1;
pub const HAVE_RL_FILENAME_COMPLETION_FUNCTION: u32 = 1;
pub const HAVE_RL_FILENAME_QUOTE_CHARACTERS: u32 = 1;
pub const HAVE_RL_FILENAME_QUOTING_FUNCTION: u32 = 1;
pub const HAVE_RL_RESET_SCREEN_SIZE: u32 = 1;
pub const HAVE_SETENV: u32 = 1;
pub const HAVE_SETSID: u32 = 1;
pub const HAVE_SHM_OPEN: u32 = 1;
pub const HAVE_SPINLOCKS: u32 = 1;
pub const HAVE_SRANDOM: u32 = 1;
pub const HAVE_STDBOOL_H: u32 = 1;
pub const HAVE_STDINT_H: u32 = 1;
pub const HAVE_STDLIB_H: u32 = 1;
pub const HAVE_STRCHRNUL: u32 = 1;
pub const HAVE_STRERROR_R: u32 = 1;
pub const HAVE_STRINGS_H: u32 = 1;
pub const HAVE_STRING_H: u32 = 1;
pub const HAVE_STRNLEN: u32 = 1;
pub const HAVE_STRSIGNAL: u32 = 1;
pub const HAVE_STRTOF: u32 = 1;
pub const HAVE_STRTOLL: u32 = 1;
pub const HAVE_STRTOULL: u32 = 1;
pub const HAVE_STRUCT_ADDRINFO: u32 = 1;
pub const HAVE_STRUCT_OPTION: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE_SS_FAMILY: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_UN: u32 = 1;
pub const HAVE_STRUCT_TM_TM_ZONE: u32 = 1;
pub const HAVE_SYMLINK: u32 = 1;
pub const HAVE_SYNC_FILE_RANGE: u32 = 1;
pub const HAVE_SYSLOG: u32 = 1;
pub const HAVE_SYS_EPOLL_H: u32 = 1;
pub const HAVE_SYS_IPC_H: u32 = 1;
pub const HAVE_SYS_PRCTL_H: u32 = 1;
pub const HAVE_SYS_RESOURCE_H: u32 = 1;
pub const HAVE_SYS_SELECT_H: u32 = 1;
pub const HAVE_SYS_SEM_H: u32 = 1;
pub const HAVE_SYS_SHM_H: u32 = 1;
pub const HAVE_SYS_STAT_H: u32 = 1;
pub const HAVE_SYS_TYPES_H: u32 = 1;
pub const HAVE_SYS_UN_H: u32 = 1;
pub const HAVE_TERMIOS_H: u32 = 1;
pub const HAVE_TYPEOF: u32 = 1;
pub const HAVE_UNISTD_H: u32 = 1;
pub const HAVE_UNSETENV: u32 = 1;
pub const HAVE_USELOCALE: u32 = 1;
pub const HAVE_WCTYPE_H: u32 = 1;
pub const HAVE_X86_64_POPCNTQ: u32 = 1;
pub const HAVE__BOOL: u32 = 1;
pub const HAVE__BUILTIN_BSWAP16: u32 = 1;
pub const HAVE__BUILTIN_BSWAP32: u32 = 1;
pub const HAVE__BUILTIN_BSWAP64: u32 = 1;
pub const HAVE__BUILTIN_CLZ: u32 = 1;
pub const HAVE__BUILTIN_CONSTANT_P: u32 = 1;
pub const HAVE__BUILTIN_CTZ: u32 = 1;
pub const HAVE__BUILTIN_FRAME_ADDRESS: u32 = 1;
pub const HAVE__BUILTIN_OP_OVERFLOW: u32 = 1;
pub const HAVE__BUILTIN_POPCOUNT: u32 = 1;
pub const HAVE__BUILTIN_TYPES_COMPATIBLE_P: u32 = 1;
pub const HAVE__BUILTIN_UNREACHABLE: u32 = 1;
pub const HAVE__GET_CPUID: u32 = 1;
pub const HAVE__STATIC_ASSERT: u32 = 1;
pub const INT64_MODIFIER: &[u8; 2usize] = b"l\0";
pub const MAXIMUM_ALIGNOF: u32 = 8;
pub const MEMSET_LOOP_LIMIT: u32 = 1024;
pub const PACKAGE_BUGREPORT: &[u8; 32usize] = b"pgsql-bugs@lists.postgresql.org\0";
pub const PACKAGE_NAME: &[u8; 11usize] = b"PostgreSQL\0";
pub const PACKAGE_STRING: &[u8; 16usize] = b"PostgreSQL 13.8\0";
pub const PACKAGE_TARNAME: &[u8; 11usize] = b"postgresql\0";
pub const PACKAGE_URL: &[u8; 28usize] = b"https://www.postgresql.org/\0";
pub const PACKAGE_VERSION: &[u8; 5usize] = b"13.8\0";
pub const PG_KRB_SRVNAM: &[u8; 9usize] = b"postgres\0";
pub const PG_MAJORVERSION: &[u8; 3usize] = b"13\0";
pub const PG_MAJORVERSION_NUM: u32 = 13;
pub const PG_MINORVERSION_NUM: u32 = 8;
pub const PG_USE_STDBOOL: u32 = 1;
pub const PG_VERSION: &[u8; 5usize] = b"13.8\0";
pub const PG_VERSION_NUM: u32 = 130008;
pub const PG_VERSION_STR: &[u8; 77usize] =
    b"PostgreSQL 13.8 on x86_64-pc-linux-gnu, compiled by gcc (GCC) 12.2.0, 64-bit\0";
pub const RELSEG_SIZE: u32 = 131072;
pub const SIZEOF_BOOL: u32 = 1;
pub const SIZEOF_LONG: u32 = 8;
pub const SIZEOF_OFF_T: u32 = 8;
pub const SIZEOF_SIZE_T: u32 = 8;
pub const SIZEOF_VOID_P: u32 = 8;
pub const STDC_HEADERS: u32 = 1;
pub const USE_ASSERT_CHECKING: u32 = 1;
pub const USE_DEV_URANDOM: u32 = 1;
pub const USE_SSE42_CRC32C_WITH_RUNTIME_CHECK: u32 = 1;
pub const USE_SYSV_SHARED_MEMORY: u32 = 1;
pub const USE_UNNAMED_POSIX_SEMAPHORES: u32 = 1;
pub const XLOG_BLCKSZ: u32 = 8192;
pub const DEFAULT_XLOG_SEG_SIZE: u32 = 16777216;
pub const NAMEDATALEN: u32 = 64;
pub const FUNC_MAX_ARGS: u32 = 100;
pub const INDEX_MAX_KEYS: u32 = 32;
pub const PARTITION_MAX_KEYS: u32 = 32;
pub const USE_FLOAT8_BYVAL: u32 = 1;
pub const NUM_SPINLOCK_SEMAPHORES: u32 = 128;
pub const NUM_ATOMICS_SEMAPHORES: u32 = 64;
pub const MAXPGPATH: u32 = 1024;
pub const PG_SOMAXCONN: u32 = 10000;
pub const BITS_PER_BYTE: u32 = 8;
pub const ALIGNOF_BUFFER: u32 = 32;
pub const HAVE_WORKING_LINK: u32 = 1;
pub const DEFAULT_BACKEND_FLUSH_AFTER: u32 = 0;
pub const DEFAULT_BGWRITER_FLUSH_AFTER: u32 = 64;
pub const DEFAULT_CHECKPOINT_FLUSH_AFTER: u32 = 32;
pub const WRITEBACK_MAX_PENDING_FLUSHES: u32 = 256;
pub const DEFAULT_PGSOCKET_DIR: &[u8; 5usize] = b"/tmp\0";
pub const DEFAULT_EVENT_SOURCE: &[u8; 11usize] = b"PostgreSQL\0";
pub const PG_CACHE_LINE_SIZE: u32 = 128;
pub const TRACE_SORT: u32 = 1;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const __have_pthread_attr_t: u32 = 1;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const HAVE_PG_ATTRIBUTE_NORETURN: u32 = 1;
pub const INT64_FORMAT: &[u8; 4usize] = b"%ld\0";
pub const UINT64_FORMAT: &[u8; 4usize] = b"%lu\0";
pub const HAVE_INT128: u32 = 1;
pub const PG_INT8_MIN: i32 = -128;
pub const PG_INT8_MAX: u32 = 127;
pub const PG_UINT8_MAX: u32 = 255;
pub const PG_INT16_MIN: i32 = -32768;
pub const PG_INT16_MAX: u32 = 32767;
pub const PG_UINT16_MAX: u32 = 65535;
pub const PG_INT32_MIN: i32 = -2147483648;
pub const PG_INT32_MAX: u32 = 2147483647;
pub const PG_UINT32_MAX: u32 = 4294967295;
pub const FLOAT8PASSBYVAL: u32 = 1;
pub const MAXDIM: u32 = 6;
pub const HAVE_UNIX_SOCKETS: u32 = 1;
pub const HIGHBIT: u32 = 128;
pub const ESCAPE_STRING_SYNTAX: u8 = 69u8;
pub const STATUS_OK: u32 = 0;
pub const STATUS_ERROR: i32 = -1;
pub const STATUS_EOF: i32 = -2;
pub const STATUS_WAITING: u32 = 2;
pub const PG_BINARY: u32 = 0;
pub const PG_BINARY_A: &[u8; 2usize] = b"a\0";
pub const PG_BINARY_R: &[u8; 2usize] = b"r\0";
pub const PG_BINARY_W: &[u8; 2usize] = b"w\0";
pub const PGINVALID_SOCKET: i32 = -1;
pub const PG_BACKEND_VERSIONSTR: &[u8; 28usize] = b"postgres (PostgreSQL) 13.8\n\0";
pub const EXE: &[u8; 1usize] = b"\0";
pub const DEVNULL: &[u8; 10usize] = b"/dev/null\0";
pub const USE_REPL_SNPRINTF: u32 = 1;
pub const PG_STRERROR_R_BUFLEN: u32 = 256;
pub const PG_IOLBF: u32 = 1;
pub const DEBUG5: u32 = 10;
pub const DEBUG4: u32 = 11;
pub const DEBUG3: u32 = 12;
pub const DEBUG2: u32 = 13;
pub const DEBUG1: u32 = 14;
pub const LOG: u32 = 15;
pub const LOG_SERVER_ONLY: u32 = 16;
pub const COMMERROR: u32 = 16;
pub const INFO: u32 = 17;
pub const NOTICE: u32 = 18;
pub const WARNING: u32 = 19;
pub const ERROR: u32 = 20;
pub const FATAL: u32 = 21;
pub const PANIC: u32 = 22;
pub const LOG_DESTINATION_STDERR: u32 = 1;
pub const LOG_DESTINATION_SYSLOG: u32 = 2;
pub const LOG_DESTINATION_EVENTLOG: u32 = 4;
pub const LOG_DESTINATION_CSVLOG: u32 = 8;
pub const MCXT_ALLOC_HUGE: u32 = 1;
pub const MCXT_ALLOC_NO_OOM: u32 = 2;
pub const MCXT_ALLOC_ZERO: u32 = 4;
pub const VARATT_SHORT_MAX: u32 = 127;
pub const FIELDNO_NULLABLE_DATUM_DATUM: u32 = 0;
pub const FIELDNO_NULLABLE_DATUM_ISNULL: u32 = 1;
pub const SIZEOF_DATUM: u32 = 8;
pub const InvalidAttrNumber: u32 = 0;
pub const MaxAttrNumber: u32 = 32767;
pub const AttributeRelationId: u32 = 1249;
pub const AttributeRelation_Rowtype_Id: u32 = 75;
pub const Anum_pg_attribute_attrelid: u32 = 1;
pub const Anum_pg_attribute_attname: u32 = 2;
pub const Anum_pg_attribute_atttypid: u32 = 3;
pub const Anum_pg_attribute_attstattarget: u32 = 4;
pub const Anum_pg_attribute_attlen: u32 = 5;
pub const Anum_pg_attribute_attnum: u32 = 6;
pub const Anum_pg_attribute_attndims: u32 = 7;
pub const Anum_pg_attribute_attcacheoff: u32 = 8;
pub const Anum_pg_attribute_atttypmod: u32 = 9;
pub const Anum_pg_attribute_attbyval: u32 = 10;
pub const Anum_pg_attribute_attstorage: u32 = 11;
pub const Anum_pg_attribute_attalign: u32 = 12;
pub const Anum_pg_attribute_attnotnull: u32 = 13;
pub const Anum_pg_attribute_atthasdef: u32 = 14;
pub const Anum_pg_attribute_atthasmissing: u32 = 15;
pub const Anum_pg_attribute_attidentity: u32 = 16;
pub const Anum_pg_attribute_attgenerated: u32 = 17;
pub const Anum_pg_attribute_attisdropped: u32 = 18;
pub const Anum_pg_attribute_attislocal: u32 = 19;
pub const Anum_pg_attribute_attinhcount: u32 = 20;
pub const Anum_pg_attribute_attcollation: u32 = 21;
pub const Anum_pg_attribute_attacl: u32 = 22;
pub const Anum_pg_attribute_attoptions: u32 = 23;
pub const Anum_pg_attribute_attfdwoptions: u32 = 24;
pub const Anum_pg_attribute_attmissingval: u32 = 25;
pub const Natts_pg_attribute: u32 = 25;
pub const ATTRIBUTE_IDENTITY_ALWAYS: u8 = 97u8;
pub const ATTRIBUTE_IDENTITY_BY_DEFAULT: u8 = 100u8;
pub const ATTRIBUTE_GENERATED_STORED: u8 = 115u8;
pub const AGGSPLITOP_COMBINE: u32 = 1;
pub const AGGSPLITOP_SKIPFINAL: u32 = 2;
pub const AGGSPLITOP_SERIALIZE: u32 = 4;
pub const AGGSPLITOP_DESERIALIZE: u32 = 8;
pub const LP_UNUSED: u32 = 0;
pub const LP_NORMAL: u32 = 1;
pub const LP_REDIRECT: u32 = 2;
pub const LP_DEAD: u32 = 3;
pub const SpecTokenOffsetNumber: u32 = 65534;
pub const MovedPartitionsOffsetNumber: u32 = 65533;
pub const FIELDNO_HEAPTUPLEDATA_DATA: u32 = 3;
pub const InvalidXLogRecPtr: u32 = 0;
pub const PG_O_DIRECT: u32 = 0;
pub const OPEN_SYNC_FLAG: u32 = 1052672;
pub const OPEN_DATASYNC_FLAG: u32 = 4096;
pub const FirstGenbkiObjectId: u32 = 10000;
pub const FirstBootstrapObjectId: u32 = 12000;
pub const FirstNormalObjectId: u32 = 16384;
pub const TypeRelationId: u32 = 1247;
pub const TypeRelation_Rowtype_Id: u32 = 71;
pub const Anum_pg_type_oid: u32 = 1;
pub const Anum_pg_type_typname: u32 = 2;
pub const Anum_pg_type_typnamespace: u32 = 3;
pub const Anum_pg_type_typowner: u32 = 4;
pub const Anum_pg_type_typlen: u32 = 5;
pub const Anum_pg_type_typbyval: u32 = 6;
pub const Anum_pg_type_typtype: u32 = 7;
pub const Anum_pg_type_typcategory: u32 = 8;
pub const Anum_pg_type_typispreferred: u32 = 9;
pub const Anum_pg_type_typisdefined: u32 = 10;
pub const Anum_pg_type_typdelim: u32 = 11;
pub const Anum_pg_type_typrelid: u32 = 12;
pub const Anum_pg_type_typelem: u32 = 13;
pub const Anum_pg_type_typarray: u32 = 14;
pub const Anum_pg_type_typinput: u32 = 15;
pub const Anum_pg_type_typoutput: u32 = 16;
pub const Anum_pg_type_typreceive: u32 = 17;
pub const Anum_pg_type_typsend: u32 = 18;
pub const Anum_pg_type_typmodin: u32 = 19;
pub const Anum_pg_type_typmodout: u32 = 20;
pub const Anum_pg_type_typanalyze: u32 = 21;
pub const Anum_pg_type_typalign: u32 = 22;
pub const Anum_pg_type_typstorage: u32 = 23;
pub const Anum_pg_type_typnotnull: u32 = 24;
pub const Anum_pg_type_typbasetype: u32 = 25;
pub const Anum_pg_type_typtypmod: u32 = 26;
pub const Anum_pg_type_typndims: u32 = 27;
pub const Anum_pg_type_typcollation: u32 = 28;
pub const Anum_pg_type_typdefaultbin: u32 = 29;
pub const Anum_pg_type_typdefault: u32 = 30;
pub const Anum_pg_type_typacl: u32 = 31;
pub const Natts_pg_type: u32 = 31;
pub const TYPTYPE_BASE: u8 = 98u8;
pub const TYPTYPE_COMPOSITE: u8 = 99u8;
pub const TYPTYPE_DOMAIN: u8 = 100u8;
pub const TYPTYPE_ENUM: u8 = 101u8;
pub const TYPTYPE_PSEUDO: u8 = 112u8;
pub const TYPTYPE_RANGE: u8 = 114u8;
pub const TYPCATEGORY_INVALID: u8 = 0u8;
pub const TYPCATEGORY_ARRAY: u8 = 65u8;
pub const TYPCATEGORY_BOOLEAN: u8 = 66u8;
pub const TYPCATEGORY_COMPOSITE: u8 = 67u8;
pub const TYPCATEGORY_DATETIME: u8 = 68u8;
pub const TYPCATEGORY_ENUM: u8 = 69u8;
pub const TYPCATEGORY_GEOMETRIC: u8 = 71u8;
pub const TYPCATEGORY_NETWORK: u8 = 73u8;
pub const TYPCATEGORY_NUMERIC: u8 = 78u8;
pub const TYPCATEGORY_PSEUDOTYPE: u8 = 80u8;
pub const TYPCATEGORY_RANGE: u8 = 82u8;
pub const TYPCATEGORY_STRING: u8 = 83u8;
pub const TYPCATEGORY_TIMESPAN: u8 = 84u8;
pub const TYPCATEGORY_USER: u8 = 85u8;
pub const TYPCATEGORY_BITSTRING: u8 = 86u8;
pub const TYPCATEGORY_UNKNOWN: u8 = 88u8;
pub const TYPALIGN_CHAR: u8 = 99u8;
pub const TYPALIGN_SHORT: u8 = 115u8;
pub const TYPALIGN_INT: u8 = 105u8;
pub const TYPALIGN_DOUBLE: u8 = 100u8;
pub const TYPSTORAGE_PLAIN: u8 = 112u8;
pub const TYPSTORAGE_EXTERNAL: u8 = 101u8;
pub const TYPSTORAGE_EXTENDED: u8 = 120u8;
pub const TYPSTORAGE_MAIN: u8 = 109u8;
pub const BOOLOID: u32 = 16;
pub const BYTEAOID: u32 = 17;
pub const CHAROID: u32 = 18;
pub const NAMEOID: u32 = 19;
pub const INT8OID: u32 = 20;
pub const INT2OID: u32 = 21;
pub const INT2VECTOROID: u32 = 22;
pub const INT4OID: u32 = 23;
pub const REGPROCOID: u32 = 24;
pub const TEXTOID: u32 = 25;
pub const OIDOID: u32 = 26;
pub const TIDOID: u32 = 27;
pub const XIDOID: u32 = 28;
pub const CIDOID: u32 = 29;
pub const OIDVECTOROID: u32 = 30;
pub const JSONOID: u32 = 114;
pub const XMLOID: u32 = 142;
pub const PGNODETREEOID: u32 = 194;
pub const PGNDISTINCTOID: u32 = 3361;
pub const PGDEPENDENCIESOID: u32 = 3402;
pub const PGMCVLISTOID: u32 = 5017;
pub const PGDDLCOMMANDOID: u32 = 32;
pub const XID8OID: u32 = 5069;
pub const POINTOID: u32 = 600;
pub const LSEGOID: u32 = 601;
pub const PATHOID: u32 = 602;
pub const BOXOID: u32 = 603;
pub const POLYGONOID: u32 = 604;
pub const LINEOID: u32 = 628;
pub const FLOAT4OID: u32 = 700;
pub const FLOAT8OID: u32 = 701;
pub const UNKNOWNOID: u32 = 705;
pub const CIRCLEOID: u32 = 718;
pub const CASHOID: u32 = 790;
pub const MACADDROID: u32 = 829;
pub const INETOID: u32 = 869;
pub const CIDROID: u32 = 650;
pub const MACADDR8OID: u32 = 774;
pub const ACLITEMOID: u32 = 1033;
pub const BPCHAROID: u32 = 1042;
pub const VARCHAROID: u32 = 1043;
pub const DATEOID: u32 = 1082;
pub const TIMEOID: u32 = 1083;
pub const TIMESTAMPOID: u32 = 1114;
pub const TIMESTAMPTZOID: u32 = 1184;
pub const INTERVALOID: u32 = 1186;
pub const TIMETZOID: u32 = 1266;
pub const BITOID: u32 = 1560;
pub const VARBITOID: u32 = 1562;
pub const NUMERICOID: u32 = 1700;
pub const REFCURSOROID: u32 = 1790;
pub const REGPROCEDUREOID: u32 = 2202;
pub const REGOPEROID: u32 = 2203;
pub const REGOPERATOROID: u32 = 2204;
pub const REGCLASSOID: u32 = 2205;
pub const REGCOLLATIONOID: u32 = 4191;
pub const REGTYPEOID: u32 = 2206;
pub const REGROLEOID: u32 = 4096;
pub const REGNAMESPACEOID: u32 = 4089;
pub const UUIDOID: u32 = 2950;
pub const LSNOID: u32 = 3220;
pub const TSVECTOROID: u32 = 3614;
pub const GTSVECTOROID: u32 = 3642;
pub const TSQUERYOID: u32 = 3615;
pub const REGCONFIGOID: u32 = 3734;
pub const REGDICTIONARYOID: u32 = 3769;
pub const JSONBOID: u32 = 3802;
pub const JSONPATHOID: u32 = 4072;
pub const TXID_SNAPSHOTOID: u32 = 2970;
pub const PG_SNAPSHOTOID: u32 = 5038;
pub const INT4RANGEOID: u32 = 3904;
pub const NUMRANGEOID: u32 = 3906;
pub const TSRANGEOID: u32 = 3908;
pub const TSTZRANGEOID: u32 = 3910;
pub const DATERANGEOID: u32 = 3912;
pub const INT8RANGEOID: u32 = 3926;
pub const RECORDOID: u32 = 2249;
pub const RECORDARRAYOID: u32 = 2287;
pub const CSTRINGOID: u32 = 2275;
pub const ANYOID: u32 = 2276;
pub const ANYARRAYOID: u32 = 2277;
pub const VOIDOID: u32 = 2278;
pub const TRIGGEROID: u32 = 2279;
pub const EVTTRIGGEROID: u32 = 3838;
pub const LANGUAGE_HANDLEROID: u32 = 2280;
pub const INTERNALOID: u32 = 2281;
pub const ANYELEMENTOID: u32 = 2283;
pub const ANYNONARRAYOID: u32 = 2776;
pub const ANYENUMOID: u32 = 3500;
pub const FDW_HANDLEROID: u32 = 3115;
pub const INDEX_AM_HANDLEROID: u32 = 325;
pub const TSM_HANDLEROID: u32 = 3310;
pub const TABLE_AM_HANDLEROID: u32 = 269;
pub const ANYRANGEOID: u32 = 3831;
pub const ANYCOMPATIBLEOID: u32 = 5077;
pub const ANYCOMPATIBLEARRAYOID: u32 = 5078;
pub const ANYCOMPATIBLENONARRAYOID: u32 = 5079;
pub const ANYCOMPATIBLERANGEOID: u32 = 5080;
pub const BOOLARRAYOID: u32 = 1000;
pub const BYTEAARRAYOID: u32 = 1001;
pub const CHARARRAYOID: u32 = 1002;
pub const NAMEARRAYOID: u32 = 1003;
pub const INT8ARRAYOID: u32 = 1016;
pub const INT2ARRAYOID: u32 = 1005;
pub const INT2VECTORARRAYOID: u32 = 1006;
pub const INT4ARRAYOID: u32 = 1007;
pub const REGPROCARRAYOID: u32 = 1008;
pub const TEXTARRAYOID: u32 = 1009;
pub const OIDARRAYOID: u32 = 1028;
pub const TIDARRAYOID: u32 = 1010;
pub const XIDARRAYOID: u32 = 1011;
pub const CIDARRAYOID: u32 = 1012;
pub const OIDVECTORARRAYOID: u32 = 1013;
pub const JSONARRAYOID: u32 = 199;
pub const XMLARRAYOID: u32 = 143;
pub const XID8ARRAYOID: u32 = 271;
pub const POINTARRAYOID: u32 = 1017;
pub const LSEGARRAYOID: u32 = 1018;
pub const PATHARRAYOID: u32 = 1019;
pub const BOXARRAYOID: u32 = 1020;
pub const POLYGONARRAYOID: u32 = 1027;
pub const LINEARRAYOID: u32 = 629;
pub const FLOAT4ARRAYOID: u32 = 1021;
pub const FLOAT8ARRAYOID: u32 = 1022;
pub const CIRCLEARRAYOID: u32 = 719;
pub const MONEYARRAYOID: u32 = 791;
pub const MACADDRARRAYOID: u32 = 1040;
pub const INETARRAYOID: u32 = 1041;
pub const CIDRARRAYOID: u32 = 651;
pub const MACADDR8ARRAYOID: u32 = 775;
pub const ACLITEMARRAYOID: u32 = 1034;
pub const BPCHARARRAYOID: u32 = 1014;
pub const VARCHARARRAYOID: u32 = 1015;
pub const DATEARRAYOID: u32 = 1182;
pub const TIMEARRAYOID: u32 = 1183;
pub const TIMESTAMPARRAYOID: u32 = 1115;
pub const TIMESTAMPTZARRAYOID: u32 = 1185;
pub const INTERVALARRAYOID: u32 = 1187;
pub const TIMETZARRAYOID: u32 = 1270;
pub const BITARRAYOID: u32 = 1561;
pub const VARBITARRAYOID: u32 = 1563;
pub const NUMERICARRAYOID: u32 = 1231;
pub const REFCURSORARRAYOID: u32 = 2201;
pub const REGPROCEDUREARRAYOID: u32 = 2207;
pub const REGOPERARRAYOID: u32 = 2208;
pub const REGOPERATORARRAYOID: u32 = 2209;
pub const REGCLASSARRAYOID: u32 = 2210;
pub const REGCOLLATIONARRAYOID: u32 = 4192;
pub const REGTYPEARRAYOID: u32 = 2211;
pub const REGROLEARRAYOID: u32 = 4097;
pub const REGNAMESPACEARRAYOID: u32 = 4090;
pub const UUIDARRAYOID: u32 = 2951;
pub const PG_LSNARRAYOID: u32 = 3221;
pub const TSVECTORARRAYOID: u32 = 3643;
pub const GTSVECTORARRAYOID: u32 = 3644;
pub const TSQUERYARRAYOID: u32 = 3645;
pub const REGCONFIGARRAYOID: u32 = 3735;
pub const REGDICTIONARYARRAYOID: u32 = 3770;
pub const JSONBARRAYOID: u32 = 3807;
pub const JSONPATHARRAYOID: u32 = 4073;
pub const TXID_SNAPSHOTARRAYOID: u32 = 2949;
pub const PG_SNAPSHOTARRAYOID: u32 = 5039;
pub const INT4RANGEARRAYOID: u32 = 3905;
pub const NUMRANGEARRAYOID: u32 = 3907;
pub const TSRANGEARRAYOID: u32 = 3909;
pub const TSTZRANGEARRAYOID: u32 = 3911;
pub const DATERANGEARRAYOID: u32 = 3913;
pub const INT8RANGEARRAYOID: u32 = 3927;
pub const CSTRINGARRAYOID: u32 = 1263;
pub const PD_HAS_FREE_LINES: u32 = 1;
pub const PD_PAGE_FULL: u32 = 2;
pub const PD_ALL_VISIBLE: u32 = 4;
pub const PD_VALID_FLAG_BITS: u32 = 7;
pub const PG_PAGE_LAYOUT_VERSION: u32 = 4;
pub const PG_DATA_CHECKSUM_VERSION: u32 = 1;
pub const PAI_OVERWRITE: u32 = 1;
pub const PAI_IS_HEAP: u32 = 2;
pub const PIV_LOG_WARNING: u32 = 1;
pub const PIV_REPORT_STAT: u32 = 2;
pub const MaxTupleAttributeNumber: u32 = 1664;
pub const MaxHeapAttributeNumber: u32 = 1600;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK2: u32 = 2;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK: u32 = 3;
pub const FIELDNO_HEAPTUPLEHEADERDATA_HOFF: u32 = 4;
pub const FIELDNO_HEAPTUPLEHEADERDATA_BITS: u32 = 5;
pub const HEAP_HASNULL: u32 = 1;
pub const HEAP_HASVARWIDTH: u32 = 2;
pub const HEAP_HASEXTERNAL: u32 = 4;
pub const HEAP_HASOID_OLD: u32 = 8;
pub const HEAP_XMAX_KEYSHR_LOCK: u32 = 16;
pub const HEAP_COMBOCID: u32 = 32;
pub const HEAP_XMAX_EXCL_LOCK: u32 = 64;
pub const HEAP_XMAX_LOCK_ONLY: u32 = 128;
pub const HEAP_XMAX_SHR_LOCK: u32 = 80;
pub const HEAP_LOCK_MASK: u32 = 80;
pub const HEAP_XMIN_COMMITTED: u32 = 256;
pub const HEAP_XMIN_INVALID: u32 = 512;
pub const HEAP_XMIN_FROZEN: u32 = 768;
pub const HEAP_XMAX_COMMITTED: u32 = 1024;
pub const HEAP_XMAX_INVALID: u32 = 2048;
pub const HEAP_XMAX_IS_MULTI: u32 = 4096;
pub const HEAP_UPDATED: u32 = 8192;
pub const HEAP_MOVED_OFF: u32 = 16384;
pub const HEAP_MOVED_IN: u32 = 32768;
pub const HEAP_MOVED: u32 = 49152;
pub const HEAP_XACT_MASK: u32 = 65520;
pub const HEAP_XMAX_BITS: u32 = 7376;
pub const HEAP_NATTS_MASK: u32 = 2047;
pub const HEAP_KEYS_UPDATED: u32 = 8192;
pub const HEAP_HOT_UPDATED: u32 = 16384;
pub const HEAP_ONLY_TUPLE: u32 = 32768;
pub const HEAP2_XACT_MASK: u32 = 57344;
pub const HEAP_TUPLE_HAS_MATCH: u32 = 32768;
pub const MaxAttrSize: u32 = 10485760;
pub const SelfItemPointerAttributeNumber: i32 = -1;
pub const MinTransactionIdAttributeNumber: i32 = -2;
pub const MinCommandIdAttributeNumber: i32 = -3;
pub const MaxTransactionIdAttributeNumber: i32 = -4;
pub const MaxCommandIdAttributeNumber: i32 = -5;
pub const TableOidAttributeNumber: i32 = -6;
pub const FirstLowInvalidHeapAttributeNumber: i32 = -7;
pub const InvalidBuffer: u32 = 0;
pub const TTS_FLAG_EMPTY: u32 = 2;
pub const TTS_FLAG_SHOULDFREE: u32 = 4;
pub const TTS_FLAG_SLOW: u32 = 8;
pub const TTS_FLAG_FIXED: u32 = 16;
pub const FIELDNO_TUPLETABLESLOT_FLAGS: u32 = 1;
pub const FIELDNO_TUPLETABLESLOT_NVALID: u32 = 2;
pub const FIELDNO_TUPLETABLESLOT_TUPLEDESCRIPTOR: u32 = 4;
pub const FIELDNO_TUPLETABLESLOT_VALUES: u32 = 5;
pub const FIELDNO_TUPLETABLESLOT_ISNULL: u32 = 6;
pub const FIELDNO_HEAPTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_HEAPTUPLETABLESLOT_OFF: u32 = 2;
pub const FIELDNO_MINIMALTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_MINIMALTUPLETABLESLOT_OFF: u32 = 4;
pub const BITS_PER_BITMAPWORD: u32 = 64;
pub const PG_INSTR_CLOCK: u32 = 1;
pub const FIELDNO_FUNCTIONCALLINFODATA_ISNULL: u32 = 4;
pub const FIELDNO_FUNCTIONCALLINFODATA_ARGS: u32 = 6;
pub const PG_MAGIC_FUNCTION_NAME_STRING: &[u8; 14usize] = b"Pg_magic_func\0";
pub const AGG_CONTEXT_AGGREGATE: u32 = 1;
pub const AGG_CONTEXT_WINDOW: u32 = 2;
pub const PARAM_FLAG_CONST: u32 = 1;
pub const BTLessStrategyNumber: u32 = 1;
pub const BTLessEqualStrategyNumber: u32 = 2;
pub const BTEqualStrategyNumber: u32 = 3;
pub const BTGreaterEqualStrategyNumber: u32 = 4;
pub const BTGreaterStrategyNumber: u32 = 5;
pub const BTMaxStrategyNumber: u32 = 5;
pub const HTEqualStrategyNumber: u32 = 1;
pub const HTMaxStrategyNumber: u32 = 1;
pub const RTLeftStrategyNumber: u32 = 1;
pub const RTOverLeftStrategyNumber: u32 = 2;
pub const RTOverlapStrategyNumber: u32 = 3;
pub const RTOverRightStrategyNumber: u32 = 4;
pub const RTRightStrategyNumber: u32 = 5;
pub const RTSameStrategyNumber: u32 = 6;
pub const RTContainsStrategyNumber: u32 = 7;
pub const RTContainedByStrategyNumber: u32 = 8;
pub const RTOverBelowStrategyNumber: u32 = 9;
pub const RTBelowStrategyNumber: u32 = 10;
pub const RTAboveStrategyNumber: u32 = 11;
pub const RTOverAboveStrategyNumber: u32 = 12;
pub const RTOldContainsStrategyNumber: u32 = 13;
pub const RTOldContainedByStrategyNumber: u32 = 14;
pub const RTKNNSearchStrategyNumber: u32 = 15;
pub const RTContainsElemStrategyNumber: u32 = 16;
pub const RTAdjacentStrategyNumber: u32 = 17;
pub const RTEqualStrategyNumber: u32 = 18;
pub const RTNotEqualStrategyNumber: u32 = 19;
pub const RTLessStrategyNumber: u32 = 20;
pub const RTLessEqualStrategyNumber: u32 = 21;
pub const RTGreaterStrategyNumber: u32 = 22;
pub const RTGreaterEqualStrategyNumber: u32 = 23;
pub const RTSubStrategyNumber: u32 = 24;
pub const RTSubEqualStrategyNumber: u32 = 25;
pub const RTSuperStrategyNumber: u32 = 26;
pub const RTSuperEqualStrategyNumber: u32 = 27;
pub const RTPrefixStrategyNumber: u32 = 28;
pub const RTMaxStrategyNumber: u32 = 28;
pub const INNER_VAR: u32 = 65000;
pub const OUTER_VAR: u32 = 65001;
pub const INDEX_VAR: u32 = 65002;
pub const PRS2_OLD_VARNO: u32 = 1;
pub const PRS2_NEW_VARNO: u32 = 2;
pub const DSM_IMPL_POSIX: u32 = 1;
pub const DSM_IMPL_SYSV: u32 = 2;
pub const DSM_IMPL_WINDOWS: u32 = 3;
pub const DSM_IMPL_MMAP: u32 = 4;
pub const DEFAULT_DYNAMIC_SHARED_MEMORY_TYPE: u32 = 1;
pub const PG_DYNSHMEM_DIR: &[u8; 12usize] = b"pg_dynshmem\0";
pub const PG_DYNSHMEM_MMAP_FILE_PREFIX: &[u8; 6usize] = b"mmap.\0";
pub const DSM_CREATE_NULL_IF_MAXSEGMENTS: u32 = 1;
pub const DSM_HANDLE_INVALID: u32 = 0;
pub const SIZEOF_DSA_POINTER: u32 = 8;
pub const DSA_POINTER_FORMAT: &[u8; 7usize] = b"%016lx\0";
pub const DSA_ALLOC_HUGE: u32 = 1;
pub const DSA_ALLOC_NO_OOM: u32 = 2;
pub const DSA_ALLOC_ZERO: u32 = 4;
pub const DEFAULT_SPINS_PER_DELAY: u32 = 100;
pub const HASH_PARTITION: u32 = 1;
pub const HASH_SEGMENT: u32 = 2;
pub const HASH_DIRSIZE: u32 = 4;
pub const HASH_FFACTOR: u32 = 8;
pub const HASH_ELEM: u32 = 16;
pub const HASH_BLOBS: u32 = 32;
pub const HASH_FUNCTION: u32 = 64;
pub const HASH_COMPARE: u32 = 128;
pub const HASH_KEYCOPY: u32 = 256;
pub const HASH_ALLOC: u32 = 512;
pub const HASH_CONTEXT: u32 = 1024;
pub const HASH_SHARED_MEM: u32 = 2048;
pub const HASH_ATTACH: u32 = 4096;
pub const HASH_FIXED_SIZE: u32 = 8192;
pub const NO_MAX_DSIZE: i32 = -1;
pub const PG_TEMP_FILES_DIR: &[u8; 10usize] = b"pgsql_tmp\0";
pub const PG_TEMP_FILE_PREFIX: &[u8; 10usize] = b"pgsql_tmp\0";
pub const SHARED_TUPLESTORE_SINGLE_PASS: u32 = 1;
pub const MAX_TIMESTAMP_PRECISION: u32 = 6;
pub const MAX_INTERVAL_PRECISION: u32 = 6;
pub const TS_PREC_INV: f64 = 1000000.0;
pub const DAYS_PER_YEAR: f64 = 365.25;
pub const MONTHS_PER_YEAR: u32 = 12;
pub const DAYS_PER_MONTH: u32 = 30;
pub const HOURS_PER_DAY: u32 = 24;
pub const SECS_PER_YEAR: u32 = 31557600;
pub const SECS_PER_DAY: u32 = 86400;
pub const SECS_PER_HOUR: u32 = 3600;
pub const SECS_PER_MINUTE: u32 = 60;
pub const MINS_PER_HOUR: u32 = 60;
pub const MAX_TZDISP_HOUR: u32 = 15;
pub const TZDISP_LIMIT: u32 = 57600;
pub const JULIAN_MINYEAR: i32 = -4713;
pub const JULIAN_MINMONTH: u32 = 11;
pub const JULIAN_MINDAY: u32 = 24;
pub const JULIAN_MAXYEAR: u32 = 5874898;
pub const JULIAN_MAXMONTH: u32 = 6;
pub const JULIAN_MAXDAY: u32 = 3;
pub const UNIX_EPOCH_JDATE: u32 = 2440588;
pub const POSTGRES_EPOCH_JDATE: u32 = 2451545;
pub const DATETIME_MIN_JULIAN: u32 = 0;
pub const DATE_END_JULIAN: u32 = 2147483494;
pub const TIMESTAMP_END_JULIAN: u32 = 109203528;
pub const RELCACHE_INIT_FILENAME: &[u8; 17usize] = b"pg_internal.init\0";
pub const INDEX_SIZE_MASK: u32 = 8191;
pub const INDEX_AM_RESERVED_BIT: u32 = 8192;
pub const INDEX_VAR_MASK: u32 = 16384;
pub const INDEX_NULL_MASK: u32 = 32768;
pub const NUM_TUPLESORTMETHODS: u32 = 4;
pub const EEO_FLAG_IS_QUAL: u32 = 1;
pub const FIELDNO_EXPRSTATE_RESNULL: u32 = 2;
pub const FIELDNO_EXPRSTATE_RESVALUE: u32 = 3;
pub const FIELDNO_EXPRSTATE_RESULTSLOT: u32 = 4;
pub const FIELDNO_EXPRSTATE_PARENT: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_SCANTUPLE: u32 = 1;
pub const FIELDNO_EXPRCONTEXT_INNERTUPLE: u32 = 2;
pub const FIELDNO_EXPRCONTEXT_OUTERTUPLE: u32 = 3;
pub const FIELDNO_EXPRCONTEXT_AGGVALUES: u32 = 8;
pub const FIELDNO_EXPRCONTEXT_AGGNULLS: u32 = 9;
pub const FIELDNO_EXPRCONTEXT_CASEDATUM: u32 = 10;
pub const FIELDNO_EXPRCONTEXT_CASENULL: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_DOMAINDATUM: u32 = 12;
pub const FIELDNO_EXPRCONTEXT_DOMAINNULL: u32 = 13;
pub const FIELDNO_AGGSTATE_CURAGGCONTEXT: u32 = 14;
pub const FIELDNO_AGGSTATE_CURPERTRANS: u32 = 16;
pub const FIELDNO_AGGSTATE_CURRENT_SET: u32 = 20;
pub const FIELDNO_AGGSTATE_ALL_PERGROUPS: u32 = 53;
pub const COMPLETION_TAG_BUFSIZE: u32 = 64;
pub const ACL_INSERT: u32 = 1;
pub const ACL_SELECT: u32 = 2;
pub const ACL_UPDATE: u32 = 4;
pub const ACL_DELETE: u32 = 8;
pub const ACL_TRUNCATE: u32 = 16;
pub const ACL_REFERENCES: u32 = 32;
pub const ACL_TRIGGER: u32 = 64;
pub const ACL_EXECUTE: u32 = 128;
pub const ACL_USAGE: u32 = 256;
pub const ACL_CREATE: u32 = 512;
pub const ACL_CREATE_TEMP: u32 = 1024;
pub const ACL_CONNECT: u32 = 2048;
pub const N_ACL_RIGHTS: u32 = 12;
pub const ACL_NO_RIGHTS: u32 = 0;
pub const ACL_SELECT_FOR_UPDATE: u32 = 4;
pub const FRAMEOPTION_NONDEFAULT: u32 = 1;
pub const FRAMEOPTION_RANGE: u32 = 2;
pub const FRAMEOPTION_ROWS: u32 = 4;
pub const FRAMEOPTION_GROUPS: u32 = 8;
pub const FRAMEOPTION_BETWEEN: u32 = 16;
pub const FRAMEOPTION_START_UNBOUNDED_PRECEDING: u32 = 32;
pub const FRAMEOPTION_END_UNBOUNDED_PRECEDING: u32 = 64;
pub const FRAMEOPTION_START_UNBOUNDED_FOLLOWING: u32 = 128;
pub const FRAMEOPTION_END_UNBOUNDED_FOLLOWING: u32 = 256;
pub const FRAMEOPTION_START_CURRENT_ROW: u32 = 512;
pub const FRAMEOPTION_END_CURRENT_ROW: u32 = 1024;
pub const FRAMEOPTION_START_OFFSET_PRECEDING: u32 = 2048;
pub const FRAMEOPTION_END_OFFSET_PRECEDING: u32 = 4096;
pub const FRAMEOPTION_START_OFFSET_FOLLOWING: u32 = 8192;
pub const FRAMEOPTION_END_OFFSET_FOLLOWING: u32 = 16384;
pub const FRAMEOPTION_EXCLUDE_CURRENT_ROW: u32 = 32768;
pub const FRAMEOPTION_EXCLUDE_GROUP: u32 = 65536;
pub const FRAMEOPTION_EXCLUDE_TIES: u32 = 131072;
pub const FRAMEOPTION_START_OFFSET: u32 = 10240;
pub const FRAMEOPTION_END_OFFSET: u32 = 20480;
pub const FRAMEOPTION_EXCLUSION: u32 = 229376;
pub const FRAMEOPTION_DEFAULTS: u32 = 1058;
pub const PARTITION_STRATEGY_HASH: u8 = 104u8;
pub const PARTITION_STRATEGY_LIST: u8 = 108u8;
pub const PARTITION_STRATEGY_RANGE: u8 = 114u8;
pub const FKCONSTR_ACTION_NOACTION: u8 = 97u8;
pub const FKCONSTR_ACTION_RESTRICT: u8 = 114u8;
pub const FKCONSTR_ACTION_CASCADE: u8 = 99u8;
pub const FKCONSTR_ACTION_SETNULL: u8 = 110u8;
pub const FKCONSTR_ACTION_SETDEFAULT: u8 = 100u8;
pub const FKCONSTR_MATCH_FULL: u8 = 102u8;
pub const FKCONSTR_MATCH_PARTIAL: u8 = 112u8;
pub const FKCONSTR_MATCH_SIMPLE: u8 = 115u8;
pub const OPCLASS_ITEM_OPERATOR: u32 = 1;
pub const OPCLASS_ITEM_FUNCTION: u32 = 2;
pub const OPCLASS_ITEM_STORAGETYPE: u32 = 3;
pub const CURSOR_OPT_BINARY: u32 = 1;
pub const CURSOR_OPT_SCROLL: u32 = 2;
pub const CURSOR_OPT_NO_SCROLL: u32 = 4;
pub const CURSOR_OPT_INSENSITIVE: u32 = 8;
pub const CURSOR_OPT_HOLD: u32 = 16;
pub const CURSOR_OPT_FAST_PLAN: u32 = 32;
pub const CURSOR_OPT_GENERIC_PLAN: u32 = 64;
pub const CURSOR_OPT_CUSTOM_PLAN: u32 = 128;
pub const CURSOR_OPT_PARALLEL_OK: u32 = 256;
pub const REINDEXOPT_VERBOSE: u32 = 1;
pub const REINDEXOPT_REPORT_PROGRESS: u32 = 2;
pub const MaxAllocHugeSize: u32 = 0;
pub const ALLOCSET_DEFAULT_MINSIZE: u32 = 0;
pub const ALLOCSET_DEFAULT_INITSIZE: u32 = 8192;
pub const ALLOCSET_DEFAULT_MAXSIZE: u32 = 8388608;
pub const ALLOCSET_SMALL_MINSIZE: u32 = 0;
pub const ALLOCSET_SMALL_INITSIZE: u32 = 1024;
pub const ALLOCSET_SMALL_MAXSIZE: u32 = 8192;
pub const ALLOCSET_SEPARATE_THRESHOLD: u32 = 8192;
pub const SLAB_DEFAULT_BLOCK_SIZE: u32 = 8192;
pub const SLAB_LARGE_BLOCK_SIZE: u32 = 8388608;
pub const EXEC_FLAG_EXPLAIN_ONLY: u32 = 1;
pub const EXEC_FLAG_REWIND: u32 = 2;
pub const EXEC_FLAG_BACKWARD: u32 = 4;
pub const EXEC_FLAG_MARK: u32 = 8;
pub const EXEC_FLAG_SKIP_TRIGGERS: u32 = 16;
pub const EXEC_FLAG_WITH_NO_DATA: u32 = 32;
pub const SIGINT: u32 = 2;
pub const SIGILL: u32 = 4;
pub const SIGABRT: u32 = 6;
pub const SIGFPE: u32 = 8;
pub const SIGSEGV: u32 = 11;
pub const SIGTERM: u32 = 15;
pub const SIGHUP: u32 = 1;
pub const SIGQUIT: u32 = 3;
pub const SIGTRAP: u32 = 5;
pub const SIGKILL: u32 = 9;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGIOT: u32 = 6;
pub const SIGSTKFLT: u32 = 16;
pub const SIGPWR: u32 = 30;
pub const SIGBUS: u32 = 7;
pub const SIGSYS: u32 = 31;
pub const SIGURG: u32 = 23;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGCONT: u32 = 18;
pub const SIGCHLD: u32 = 17;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGPOLL: u32 = 29;
pub const SIGXFSZ: u32 = 25;
pub const SIGXCPU: u32 = 24;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGUSR1: u32 = 10;
pub const SIGUSR2: u32 = 12;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGCLD: u32 = 17;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const SIGSTKSZ: u32 = 8192;
pub const TZ_STRLEN_MAX: u32 = 255;
pub const InvalidPid: i32 = -1;
pub const USE_POSTGRES_DATES: u32 = 0;
pub const USE_ISO_DATES: u32 = 1;
pub const USE_SQL_DATES: u32 = 2;
pub const USE_GERMAN_DATES: u32 = 3;
pub const USE_XSD_DATES: u32 = 4;
pub const DATEORDER_YMD: u32 = 0;
pub const DATEORDER_DMY: u32 = 1;
pub const DATEORDER_MDY: u32 = 2;
pub const INTSTYLE_POSTGRES: u32 = 0;
pub const INTSTYLE_POSTGRES_VERBOSE: u32 = 1;
pub const INTSTYLE_SQL_STANDARD: u32 = 2;
pub const INTSTYLE_ISO_8601: u32 = 3;
pub const MAXTZLEN: u32 = 10;
pub const SECURITY_LOCAL_USERID_CHANGE: u32 = 1;
pub const SECURITY_RESTRICTED_OPERATION: u32 = 2;
pub const SECURITY_NOFORCE_RLS: u32 = 4;
pub const SM_DATABASE: u32 = 64;
pub const SM_USER: u32 = 32;
pub const SM_DATABASE_USER: u32 = 97;
pub const SM_OPTIONS: u32 = 64;
pub const SM_UNUSED: u32 = 64;
pub const SM_TTY: u32 = 64;
pub const MAX_STARTUP_PACKET_LENGTH: u32 = 10000;
pub const AUTH_REQ_OK: u32 = 0;
pub const AUTH_REQ_KRB4: u32 = 1;
pub const AUTH_REQ_KRB5: u32 = 2;
pub const AUTH_REQ_PASSWORD: u32 = 3;
pub const AUTH_REQ_CRYPT: u32 = 4;
pub const AUTH_REQ_MD5: u32 = 5;
pub const AUTH_REQ_SCM_CREDS: u32 = 6;
pub const AUTH_REQ_GSS: u32 = 7;
pub const AUTH_REQ_GSS_CONT: u32 = 8;
pub const AUTH_REQ_SSPI: u32 = 9;
pub const AUTH_REQ_SASL: u32 = 10;
pub const AUTH_REQ_SASL_CONT: u32 = 11;
pub const AUTH_REQ_SASL_FIN: u32 = 12;
pub const MIN_XFN_CHARS: u32 = 16;
pub const MAX_XFN_CHARS: u32 = 40;
pub const VALID_XFN_CHARS: &[u8; 40usize] = b"0123456789ABCDEF.history.backup.partial\0";
pub const CATALOG_VERSION_NO: u32 = 202007201;
pub const OIDCHARS: u32 = 10;
pub const FORKNAMECHARS: u32 = 4;
pub const InvalidBackendId: i32 = -1;
pub const XLR_INFO_MASK: u32 = 15;
pub const XLR_RMGR_INFO_MASK: u32 = 240;
pub const XLR_SPECIAL_REL_UPDATE: u32 = 1;
pub const XLR_CHECK_CONSISTENCY: u32 = 2;
pub const BKPIMAGE_HAS_HOLE: u32 = 1;
pub const BKPIMAGE_IS_COMPRESSED: u32 = 2;
pub const BKPIMAGE_APPLY: u32 = 4;
pub const BKPBLOCK_FORK_MASK: u32 = 15;
pub const BKPBLOCK_FLAG_MASK: u32 = 240;
pub const BKPBLOCK_HAS_IMAGE: u32 = 16;
pub const BKPBLOCK_HAS_DATA: u32 = 32;
pub const BKPBLOCK_WILL_INIT: u32 = 64;
pub const BKPBLOCK_SAME_REL: u32 = 128;
pub const XLR_MAX_BLOCK_ID: u32 = 32;
pub const XLR_BLOCK_ID_DATA_SHORT: u32 = 255;
pub const XLR_BLOCK_ID_DATA_LONG: u32 = 254;
pub const XLR_BLOCK_ID_ORIGIN: u32 = 253;
pub const TRANSACTION_STATUS_IN_PROGRESS: u32 = 0;
pub const TRANSACTION_STATUS_COMMITTED: u32 = 1;
pub const TRANSACTION_STATUS_ABORTED: u32 = 2;
pub const TRANSACTION_STATUS_SUB_COMMITTED: u32 = 3;
pub const CLOG_ZEROPAGE: u32 = 0;
pub const CLOG_TRUNCATE: u32 = 16;
pub const WL_LATCH_SET: u32 = 1;
pub const WL_SOCKET_READABLE: u32 = 2;
pub const WL_SOCKET_WRITEABLE: u32 = 4;
pub const WL_TIMEOUT: u32 = 8;
pub const WL_POSTMASTER_DEATH: u32 = 16;
pub const WL_EXIT_ON_PM_DEATH: u32 = 32;
pub const WL_SOCKET_CONNECTED: u32 = 4;
pub const WL_SOCKET_MASK: u32 = 6;
pub const NoLock: u32 = 0;
pub const AccessShareLock: u32 = 1;
pub const RowShareLock: u32 = 2;
pub const RowExclusiveLock: u32 = 3;
pub const ShareUpdateExclusiveLock: u32 = 4;
pub const ShareLock: u32 = 5;
pub const ShareRowExclusiveLock: u32 = 6;
pub const ExclusiveLock: u32 = 7;
pub const AccessExclusiveLock: u32 = 8;
pub const MaxLockMode: u32 = 8;
pub const LWLOCK_PADDED_SIZE: u32 = 128;
pub const NUM_INDIVIDUAL_LWLOCKS: u32 = 48;
pub const NUM_BUFFER_PARTITIONS: u32 = 128;
pub const LOG2_NUM_LOCK_PARTITIONS: u32 = 4;
pub const NUM_LOCK_PARTITIONS: u32 = 16;
pub const LOG2_NUM_PREDICATELOCK_PARTITIONS: u32 = 4;
pub const NUM_PREDICATELOCK_PARTITIONS: u32 = 16;
pub const BUFFER_MAPPING_LWLOCK_OFFSET: u32 = 48;
pub const LOCK_MANAGER_LWLOCK_OFFSET: u32 = 176;
pub const PREDICATELOCK_MANAGER_LWLOCK_OFFSET: u32 = 192;
pub const NUM_FIXED_LWLOCKS: u32 = 208;
pub const SHMEM_INDEX_KEYSIZE: u32 = 48;
pub const SHMEM_INDEX_SIZE: u32 = 64;
pub const InvalidLocalTransactionId: u32 = 0;
pub const MAX_LOCKMODES: u32 = 10;
pub const DEFAULT_LOCKMETHOD: u32 = 1;
pub const USER_LOCKMETHOD: u32 = 2;
pub const PGPROC_MAX_CACHED_SUBXIDS: u32 = 64;
pub const PROC_IS_AUTOVACUUM: u32 = 1;
pub const PROC_IN_VACUUM: u32 = 2;
pub const PROC_IN_ANALYZE: u32 = 4;
pub const PROC_VACUUM_FOR_WRAPAROUND: u32 = 8;
pub const PROC_IN_LOGICAL_DECODING: u32 = 16;
pub const PROC_RESERVED: u32 = 32;
pub const PROC_VACUUM_STATE_MASK: u32 = 14;
pub const PROC_XMIN_FLAGS: u32 = 2;
pub const FP_LOCK_SLOTS_PER_BACKEND: u32 = 16;
pub const INVALID_PGPROCNO: u32 = 2147483647;
pub const DELAY_CHKPT_START: u32 = 1;
pub const DELAY_CHKPT_COMPLETE: u32 = 2;
pub const NUM_AUXILIARY_PROCS: u32 = 4;
pub const PGSTAT_STAT_PERMANENT_DIRECTORY: &[u8; 8usize] = b"pg_stat\0";
pub const PGSTAT_STAT_PERMANENT_FILENAME: &[u8; 20usize] = b"pg_stat/global.stat\0";
pub const PGSTAT_STAT_PERMANENT_TMPFILE: &[u8; 19usize] = b"pg_stat/global.tmp\0";
pub const PG_STAT_TMP_DIR: &[u8; 12usize] = b"pg_stat_tmp\0";
pub const PGSTAT_MAX_MSG_SIZE: u32 = 1000;
pub const PGSTAT_FILE_FORMAT_ID: u32 = 27638941;
pub const PG_WAIT_LWLOCK: u32 = 16777216;
pub const PG_WAIT_LOCK: u32 = 50331648;
pub const PG_WAIT_BUFFER_PIN: u32 = 67108864;
pub const PG_WAIT_ACTIVITY: u32 = 83886080;
pub const PG_WAIT_CLIENT: u32 = 100663296;
pub const PG_WAIT_EXTENSION: u32 = 117440512;
pub const PG_WAIT_IPC: u32 = 134217728;
pub const PG_WAIT_TIMEOUT: u32 = 150994944;
pub const PG_WAIT_IO: u32 = 167772160;
pub const PGSTAT_NUM_PROGRESS_PARAM: u32 = 20;
pub const SK_ISNULL: u32 = 1;
pub const SK_UNARY: u32 = 2;
pub const SK_ROW_HEADER: u32 = 4;
pub const SK_ROW_MEMBER: u32 = 8;
pub const SK_ROW_END: u32 = 16;
pub const SK_SEARCHARRAY: u32 = 32;
pub const SK_SEARCHNULL: u32 = 64;
pub const SK_SEARCHNOTNULL: u32 = 128;
pub const SK_ORDER_BY: u32 = 256;
pub const GIN_COMPARE_PROC: u32 = 1;
pub const GIN_EXTRACTVALUE_PROC: u32 = 2;
pub const GIN_EXTRACTQUERY_PROC: u32 = 3;
pub const GIN_CONSISTENT_PROC: u32 = 4;
pub const GIN_COMPARE_PARTIAL_PROC: u32 = 5;
pub const GIN_TRICONSISTENT_PROC: u32 = 6;
pub const GIN_OPTIONS_PROC: u32 = 7;
pub const GINNProcs: u32 = 7;
pub const GIN_SEARCH_MODE_DEFAULT: u32 = 0;
pub const GIN_SEARCH_MODE_INCLUDE_EMPTY: u32 = 1;
pub const GIN_SEARCH_MODE_ALL: u32 = 2;
pub const GIN_SEARCH_MODE_EVERYTHING: u32 = 3;
pub const GIN_FALSE: u32 = 0;
pub const GIN_TRUE: u32 = 1;
pub const GIN_MAYBE: u32 = 2;
pub const XLR_NORMAL_MAX_BLOCK_ID: u32 = 4;
pub const XLR_NORMAL_RDATAS: u32 = 20;
pub const REGBUF_FORCE_IMAGE: u32 = 1;
pub const REGBUF_NO_IMAGE: u32 = 2;
pub const REGBUF_WILL_INIT: u32 = 6;
pub const REGBUF_STANDARD: u32 = 8;
pub const REGBUF_KEEP_DATA: u32 = 16;
pub const SYNC_METHOD_FSYNC: u32 = 0;
pub const SYNC_METHOD_FDATASYNC: u32 = 1;
pub const SYNC_METHOD_OPEN: u32 = 2;
pub const SYNC_METHOD_FSYNC_WRITETHROUGH: u32 = 3;
pub const SYNC_METHOD_OPEN_DSYNC: u32 = 4;
pub const CHECKPOINT_IS_SHUTDOWN: u32 = 1;
pub const CHECKPOINT_END_OF_RECOVERY: u32 = 2;
pub const CHECKPOINT_IMMEDIATE: u32 = 4;
pub const CHECKPOINT_FORCE: u32 = 8;
pub const CHECKPOINT_FLUSH_ALL: u32 = 16;
pub const CHECKPOINT_WAIT: u32 = 32;
pub const CHECKPOINT_REQUESTED: u32 = 64;
pub const CHECKPOINT_CAUSE_XLOG: u32 = 128;
pub const CHECKPOINT_CAUSE_TIME: u32 = 256;
pub const XLOG_INCLUDE_ORIGIN: u32 = 1;
pub const XLOG_MARK_UNIMPORTANT: u32 = 2;
pub const RECOVERY_SIGNAL_FILE: &[u8; 16usize] = b"recovery.signal\0";
pub const STANDBY_SIGNAL_FILE: &[u8; 15usize] = b"standby.signal\0";
pub const BACKUP_LABEL_FILE: &[u8; 13usize] = b"backup_label\0";
pub const BACKUP_LABEL_OLD: &[u8; 17usize] = b"backup_label.old\0";
pub const TABLESPACE_MAP: &[u8; 15usize] = b"tablespace_map\0";
pub const TABLESPACE_MAP_OLD: &[u8; 19usize] = b"tablespace_map.old\0";
pub const PROMOTE_SIGNAL_FILE: &[u8; 8usize] = b"promote\0";
pub const FALLBACK_PROMOTE_SIGNAL_FILE: &[u8; 17usize] = b"fallback_promote\0";
pub const GIST_CONSISTENT_PROC: u32 = 1;
pub const GIST_UNION_PROC: u32 = 2;
pub const GIST_COMPRESS_PROC: u32 = 3;
pub const GIST_DECOMPRESS_PROC: u32 = 4;
pub const GIST_PENALTY_PROC: u32 = 5;
pub const GIST_PICKSPLIT_PROC: u32 = 6;
pub const GIST_EQUAL_PROC: u32 = 7;
pub const GIST_DISTANCE_PROC: u32 = 8;
pub const GIST_FETCH_PROC: u32 = 9;
pub const GIST_OPTIONS_PROC: u32 = 10;
pub const GISTNProcs: u32 = 10;
pub const F_LEAF: u32 = 1;
pub const F_DELETED: u32 = 2;
pub const F_TUPLES_DELETED: u32 = 4;
pub const F_FOLLOW_RIGHT: u32 = 8;
pub const F_HAS_GARBAGE: u32 = 16;
pub const GIST_PAGE_ID: u32 = 65409;
pub const EOH_HEADER_MAGIC: i32 = -1;
pub const EA_MAGIC: u32 = 689375833;
pub const PG_AUTOCONF_FILENAME: &[u8; 21usize] = b"postgresql.auto.conf\0";
pub const GUC_QUALIFIER_SEPARATOR: u8 = 46u8;
pub const GUC_LIST_INPUT: u32 = 1;
pub const GUC_LIST_QUOTE: u32 = 2;
pub const GUC_NO_SHOW_ALL: u32 = 4;
pub const GUC_NO_RESET_ALL: u32 = 8;
pub const GUC_REPORT: u32 = 16;
pub const GUC_NOT_IN_SAMPLE: u32 = 32;
pub const GUC_DISALLOW_IN_FILE: u32 = 64;
pub const GUC_CUSTOM_PLACEHOLDER: u32 = 128;
pub const GUC_SUPERUSER_ONLY: u32 = 256;
pub const GUC_IS_NAME: u32 = 512;
pub const GUC_NOT_WHILE_SEC_REST: u32 = 1024;
pub const GUC_DISALLOW_IN_AUTO_FILE: u32 = 2048;
pub const GUC_UNIT_KB: u32 = 4096;
pub const GUC_UNIT_BLOCKS: u32 = 8192;
pub const GUC_UNIT_XBLOCKS: u32 = 12288;
pub const GUC_UNIT_MB: u32 = 16384;
pub const GUC_UNIT_BYTE: u32 = 32768;
pub const GUC_UNIT_MEMORY: u32 = 61440;
pub const GUC_UNIT_MS: u32 = 65536;
pub const GUC_UNIT_S: u32 = 131072;
pub const GUC_UNIT_MIN: u32 = 196608;
pub const GUC_UNIT_TIME: u32 = 983040;
pub const GUC_EXPLAIN: u32 = 1048576;
pub const GUC_UNIT: u32 = 1044480;
pub const RelationRelationId: u32 = 1259;
pub const RelationRelation_Rowtype_Id: u32 = 83;
pub const Anum_pg_class_oid: u32 = 1;
pub const Anum_pg_class_relname: u32 = 2;
pub const Anum_pg_class_relnamespace: u32 = 3;
pub const Anum_pg_class_reltype: u32 = 4;
pub const Anum_pg_class_reloftype: u32 = 5;
pub const Anum_pg_class_relowner: u32 = 6;
pub const Anum_pg_class_relam: u32 = 7;
pub const Anum_pg_class_relfilenode: u32 = 8;
pub const Anum_pg_class_reltablespace: u32 = 9;
pub const Anum_pg_class_relpages: u32 = 10;
pub const Anum_pg_class_reltuples: u32 = 11;
pub const Anum_pg_class_relallvisible: u32 = 12;
pub const Anum_pg_class_reltoastrelid: u32 = 13;
pub const Anum_pg_class_relhasindex: u32 = 14;
pub const Anum_pg_class_relisshared: u32 = 15;
pub const Anum_pg_class_relpersistence: u32 = 16;
pub const Anum_pg_class_relkind: u32 = 17;
pub const Anum_pg_class_relnatts: u32 = 18;
pub const Anum_pg_class_relchecks: u32 = 19;
pub const Anum_pg_class_relhasrules: u32 = 20;
pub const Anum_pg_class_relhastriggers: u32 = 21;
pub const Anum_pg_class_relhassubclass: u32 = 22;
pub const Anum_pg_class_relrowsecurity: u32 = 23;
pub const Anum_pg_class_relforcerowsecurity: u32 = 24;
pub const Anum_pg_class_relispopulated: u32 = 25;
pub const Anum_pg_class_relreplident: u32 = 26;
pub const Anum_pg_class_relispartition: u32 = 27;
pub const Anum_pg_class_relrewrite: u32 = 28;
pub const Anum_pg_class_relfrozenxid: u32 = 29;
pub const Anum_pg_class_relminmxid: u32 = 30;
pub const Anum_pg_class_relacl: u32 = 31;
pub const Anum_pg_class_reloptions: u32 = 32;
pub const Anum_pg_class_relpartbound: u32 = 33;
pub const Natts_pg_class: u32 = 33;
pub const RELKIND_RELATION: u8 = 114u8;
pub const RELKIND_INDEX: u8 = 105u8;
pub const RELKIND_SEQUENCE: u8 = 83u8;
pub const RELKIND_TOASTVALUE: u8 = 116u8;
pub const RELKIND_VIEW: u8 = 118u8;
pub const RELKIND_MATVIEW: u8 = 109u8;
pub const RELKIND_COMPOSITE_TYPE: u8 = 99u8;
pub const RELKIND_FOREIGN_TABLE: u8 = 102u8;
pub const RELKIND_PARTITIONED_TABLE: u8 = 112u8;
pub const RELKIND_PARTITIONED_INDEX: u8 = 73u8;
pub const RELPERSISTENCE_PERMANENT: u8 = 112u8;
pub const RELPERSISTENCE_UNLOGGED: u8 = 117u8;
pub const RELPERSISTENCE_TEMP: u8 = 116u8;
pub const REPLICA_IDENTITY_DEFAULT: u8 = 100u8;
pub const REPLICA_IDENTITY_NOTHING: u8 = 110u8;
pub const REPLICA_IDENTITY_FULL: u8 = 102u8;
pub const REPLICA_IDENTITY_INDEX: u8 = 105u8;
pub const IndexRelationId: u32 = 2610;
pub const Anum_pg_index_indexrelid: u32 = 1;
pub const Anum_pg_index_indrelid: u32 = 2;
pub const Anum_pg_index_indnatts: u32 = 3;
pub const Anum_pg_index_indnkeyatts: u32 = 4;
pub const Anum_pg_index_indisunique: u32 = 5;
pub const Anum_pg_index_indisprimary: u32 = 6;
pub const Anum_pg_index_indisexclusion: u32 = 7;
pub const Anum_pg_index_indimmediate: u32 = 8;
pub const Anum_pg_index_indisclustered: u32 = 9;
pub const Anum_pg_index_indisvalid: u32 = 10;
pub const Anum_pg_index_indcheckxmin: u32 = 11;
pub const Anum_pg_index_indisready: u32 = 12;
pub const Anum_pg_index_indislive: u32 = 13;
pub const Anum_pg_index_indisreplident: u32 = 14;
pub const Anum_pg_index_indkey: u32 = 15;
pub const Anum_pg_index_indcollation: u32 = 16;
pub const Anum_pg_index_indclass: u32 = 17;
pub const Anum_pg_index_indoption: u32 = 18;
pub const Anum_pg_index_indexprs: u32 = 19;
pub const Anum_pg_index_indpred: u32 = 20;
pub const Natts_pg_index: u32 = 20;
pub const INDOPTION_DESC: u32 = 1;
pub const INDOPTION_NULLS_FIRST: u32 = 2;
pub const PublicationRelationId: u32 = 6104;
pub const Anum_pg_publication_oid: u32 = 1;
pub const Anum_pg_publication_pubname: u32 = 2;
pub const Anum_pg_publication_pubowner: u32 = 3;
pub const Anum_pg_publication_puballtables: u32 = 4;
pub const Anum_pg_publication_pubinsert: u32 = 5;
pub const Anum_pg_publication_pubupdate: u32 = 6;
pub const Anum_pg_publication_pubdelete: u32 = 7;
pub const Anum_pg_publication_pubtruncate: u32 = 8;
pub const Anum_pg_publication_pubviaroot: u32 = 9;
pub const Natts_pg_publication: u32 = 9;
pub const HEAP_MIN_FILLFACTOR: u32 = 10;
pub const HEAP_DEFAULT_FILLFACTOR: u32 = 100;
pub const DEFAULT_TABLE_ACCESS_METHOD: &[u8; 5usize] = b"heap\0";
pub const TABLE_INSERT_SKIP_FSM: u32 = 2;
pub const TABLE_INSERT_FROZEN: u32 = 4;
pub const TABLE_INSERT_NO_LOGICAL: u32 = 8;
pub const TUPLE_LOCK_FLAG_LOCK_UPDATE_IN_PROGRESS: u32 = 1;
pub const TUPLE_LOCK_FLAG_FIND_LAST_VERSION: u32 = 2;
pub const HEAP_INSERT_SKIP_FSM: u32 = 2;
pub const HEAP_INSERT_FROZEN: u32 = 4;
pub const HEAP_INSERT_NO_LOGICAL: u32 = 8;
pub const HEAP_INSERT_SPECULATIVE: u32 = 16;
pub const SHAREDINVALCATALOG_ID: i32 = -1;
pub const SHAREDINVALRELCACHE_ID: i32 = -2;
pub const SHAREDINVALSMGR_ID: i32 = -3;
pub const SHAREDINVALRELMAP_ID: i32 = -4;
pub const SHAREDINVALSNAPSHOT_ID: i32 = -5;
pub const INTERVAL_FULL_RANGE: u32 = 32767;
pub const INTERVAL_RANGE_MASK: u32 = 32767;
pub const INTERVAL_FULL_PRECISION: u32 = 65535;
pub const INTERVAL_PRECISION_MASK: u32 = 65535;
pub const DAGO: &[u8; 4usize] = b"ago\0";
pub const DCURRENT: &[u8; 8usize] = b"current\0";
pub const EPOCH: &[u8; 6usize] = b"epoch\0";
pub const INVALID: &[u8; 8usize] = b"invalid\0";
pub const EARLY: &[u8; 10usize] = b"-infinity\0";
pub const LATE: &[u8; 9usize] = b"infinity\0";
pub const NOW: &[u8; 4usize] = b"now\0";
pub const TODAY: &[u8; 6usize] = b"today\0";
pub const TOMORROW: &[u8; 9usize] = b"tomorrow\0";
pub const YESTERDAY: &[u8; 10usize] = b"yesterday\0";
pub const ZULU: &[u8; 5usize] = b"zulu\0";
pub const DMICROSEC: &[u8; 8usize] = b"usecond\0";
pub const DMILLISEC: &[u8; 8usize] = b"msecond\0";
pub const DSECOND: &[u8; 7usize] = b"second\0";
pub const DMINUTE: &[u8; 7usize] = b"minute\0";
pub const DHOUR: &[u8; 5usize] = b"hour\0";
pub const DDAY: &[u8; 4usize] = b"day\0";
pub const DWEEK: &[u8; 5usize] = b"week\0";
pub const DMONTH: &[u8; 6usize] = b"month\0";
pub const DQUARTER: &[u8; 8usize] = b"quarter\0";
pub const DYEAR: &[u8; 5usize] = b"year\0";
pub const DDECADE: &[u8; 7usize] = b"decade\0";
pub const DCENTURY: &[u8; 8usize] = b"century\0";
pub const DMILLENNIUM: &[u8; 11usize] = b"millennium\0";
pub const DA_D: &[u8; 3usize] = b"ad\0";
pub const DB_C: &[u8; 3usize] = b"bc\0";
pub const DTIMEZONE: &[u8; 9usize] = b"timezone\0";
pub const AM: u32 = 0;
pub const PM: u32 = 1;
pub const HR24: u32 = 2;
pub const AD: u32 = 0;
pub const BC: u32 = 1;
pub const RESERV: u32 = 0;
pub const MONTH: u32 = 1;
pub const YEAR: u32 = 2;
pub const DAY: u32 = 3;
pub const JULIAN: u32 = 4;
pub const TZ: u32 = 5;
pub const DTZ: u32 = 6;
pub const DYNTZ: u32 = 7;
pub const IGNORE_DTF: u32 = 8;
pub const AMPM: u32 = 9;
pub const HOUR: u32 = 10;
pub const MINUTE: u32 = 11;
pub const SECOND: u32 = 12;
pub const MILLISECOND: u32 = 13;
pub const MICROSECOND: u32 = 14;
pub const DOY: u32 = 15;
pub const DOW: u32 = 16;
pub const UNITS: u32 = 17;
pub const ADBC: u32 = 18;
pub const AGO: u32 = 19;
pub const ABS_BEFORE: u32 = 20;
pub const ABS_AFTER: u32 = 21;
pub const ISODATE: u32 = 22;
pub const ISOTIME: u32 = 23;
pub const WEEK: u32 = 24;
pub const DECADE: u32 = 25;
pub const CENTURY: u32 = 26;
pub const MILLENNIUM: u32 = 27;
pub const DTZMOD: u32 = 28;
pub const UNKNOWN_FIELD: u32 = 31;
pub const DTK_NUMBER: u32 = 0;
pub const DTK_STRING: u32 = 1;
pub const DTK_DATE: u32 = 2;
pub const DTK_TIME: u32 = 3;
pub const DTK_TZ: u32 = 4;
pub const DTK_AGO: u32 = 5;
pub const DTK_SPECIAL: u32 = 6;
pub const DTK_EARLY: u32 = 9;
pub const DTK_LATE: u32 = 10;
pub const DTK_EPOCH: u32 = 11;
pub const DTK_NOW: u32 = 12;
pub const DTK_YESTERDAY: u32 = 13;
pub const DTK_TODAY: u32 = 14;
pub const DTK_TOMORROW: u32 = 15;
pub const DTK_ZULU: u32 = 16;
pub const DTK_DELTA: u32 = 17;
pub const DTK_SECOND: u32 = 18;
pub const DTK_MINUTE: u32 = 19;
pub const DTK_HOUR: u32 = 20;
pub const DTK_DAY: u32 = 21;
pub const DTK_WEEK: u32 = 22;
pub const DTK_MONTH: u32 = 23;
pub const DTK_QUARTER: u32 = 24;
pub const DTK_YEAR: u32 = 25;
pub const DTK_DECADE: u32 = 26;
pub const DTK_CENTURY: u32 = 27;
pub const DTK_MILLENNIUM: u32 = 28;
pub const DTK_MILLISEC: u32 = 29;
pub const DTK_MICROSEC: u32 = 30;
pub const DTK_JULIAN: u32 = 31;
pub const DTK_DOW: u32 = 32;
pub const DTK_DOY: u32 = 33;
pub const DTK_TZ_HOUR: u32 = 34;
pub const DTK_TZ_MINUTE: u32 = 35;
pub const DTK_ISOYEAR: u32 = 36;
pub const DTK_ISODOW: u32 = 37;
pub const MAXDATELEN: u32 = 128;
pub const MAXDATEFIELDS: u32 = 25;
pub const TOKMAXLEN: u32 = 10;
pub const DTERR_BAD_FORMAT: i32 = -1;
pub const DTERR_FIELD_OVERFLOW: i32 = -2;
pub const DTERR_MD_FIELD_OVERFLOW: i32 = -3;
pub const DTERR_INTERVAL_OVERFLOW: i32 = -4;
pub const DTERR_TZDISP_OVERFLOW: i32 = -5;
pub const GIDSIZE: u32 = 200;
pub const XACT_READ_UNCOMMITTED: u32 = 0;
pub const XACT_READ_COMMITTED: u32 = 1;
pub const XACT_REPEATABLE_READ: u32 = 2;
pub const XACT_SERIALIZABLE: u32 = 3;
pub const XACT_FLAGS_ACCESSEDTEMPNAMESPACE: u32 = 1;
pub const XACT_FLAGS_ACQUIREDACCESSEXCLUSIVELOCK: u32 = 2;
pub const XACT_FLAGS_NEEDIMMEDIATECOMMIT: u32 = 4;
pub const XLOG_XACT_COMMIT: u32 = 0;
pub const XLOG_XACT_PREPARE: u32 = 16;
pub const XLOG_XACT_ABORT: u32 = 32;
pub const XLOG_XACT_COMMIT_PREPARED: u32 = 48;
pub const XLOG_XACT_ABORT_PREPARED: u32 = 64;
pub const XLOG_XACT_ASSIGNMENT: u32 = 80;
pub const XLOG_XACT_OPMASK: u32 = 112;
pub const XLOG_XACT_HAS_INFO: u32 = 128;
pub const XACT_XINFO_HAS_DBINFO: u32 = 1;
pub const XACT_XINFO_HAS_SUBXACTS: u32 = 2;
pub const XACT_XINFO_HAS_RELFILENODES: u32 = 4;
pub const XACT_XINFO_HAS_INVALS: u32 = 8;
pub const XACT_XINFO_HAS_TWOPHASE: u32 = 16;
pub const XACT_XINFO_HAS_ORIGIN: u32 = 32;
pub const XACT_XINFO_HAS_AE_LOCKS: u32 = 64;
pub const XACT_XINFO_HAS_GID: u32 = 128;
pub const XACT_COMPLETION_APPLY_FEEDBACK: u32 = 536870912;
pub const XACT_COMPLETION_UPDATE_RELCACHE_FILE: u32 = 1073741824;
pub const XACT_COMPLETION_FORCE_SYNC_COMMIT: u32 = 2147483648;
pub const PERFORM_DELETION_INTERNAL: u32 = 1;
pub const PERFORM_DELETION_CONCURRENTLY: u32 = 2;
pub const PERFORM_DELETION_QUIETLY: u32 = 4;
pub const PERFORM_DELETION_SKIP_ORIGINAL: u32 = 8;
pub const PERFORM_DELETION_SKIP_EXTENSIONS: u32 = 16;
pub const PERFORM_DELETION_CONCURRENT_LOCK: u32 = 32;
pub const DEFAULT_INDEX_TYPE: &[u8; 6usize] = b"btree\0";
pub const INDEX_CREATE_IS_PRIMARY: u32 = 1;
pub const INDEX_CREATE_ADD_CONSTRAINT: u32 = 2;
pub const INDEX_CREATE_SKIP_BUILD: u32 = 4;
pub const INDEX_CREATE_CONCURRENT: u32 = 8;
pub const INDEX_CREATE_IF_NOT_EXISTS: u32 = 16;
pub const INDEX_CREATE_PARTITIONED: u32 = 32;
pub const INDEX_CREATE_INVALID: u32 = 64;
pub const INDEX_CONSTR_CREATE_MARK_AS_PRIMARY: u32 = 1;
pub const INDEX_CONSTR_CREATE_DEFERRABLE: u32 = 2;
pub const INDEX_CONSTR_CREATE_INIT_DEFERRED: u32 = 4;
pub const INDEX_CONSTR_CREATE_UPDATE_INDEX: u32 = 8;
pub const INDEX_CONSTR_CREATE_REMOVE_OLD_DEPS: u32 = 16;
pub const REINDEX_REL_PROCESS_TOAST: u32 = 1;
pub const REINDEX_REL_SUPPRESS_INDEX_USE: u32 = 2;
pub const REINDEX_REL_CHECK_CONSTRAINTS: u32 = 4;
pub const REINDEX_REL_FORCE_INDEXES_UNLOGGED: u32 = 8;
pub const REINDEX_REL_FORCE_INDEXES_PERMANENT: u32 = 16;
pub const AuthIdRelationId: u32 = 1260;
pub const AuthIdRelation_Rowtype_Id: u32 = 2842;
pub const Anum_pg_authid_oid: u32 = 1;
pub const Anum_pg_authid_rolname: u32 = 2;
pub const Anum_pg_authid_rolsuper: u32 = 3;
pub const Anum_pg_authid_rolinherit: u32 = 4;
pub const Anum_pg_authid_rolcreaterole: u32 = 5;
pub const Anum_pg_authid_rolcreatedb: u32 = 6;
pub const Anum_pg_authid_rolcanlogin: u32 = 7;
pub const Anum_pg_authid_rolreplication: u32 = 8;
pub const Anum_pg_authid_rolbypassrls: u32 = 9;
pub const Anum_pg_authid_rolconnlimit: u32 = 10;
pub const Anum_pg_authid_rolpassword: u32 = 11;
pub const Anum_pg_authid_rolvaliduntil: u32 = 12;
pub const Natts_pg_authid: u32 = 12;
pub const BOOTSTRAP_SUPERUSERID: u32 = 10;
pub const DEFAULT_ROLE_MONITOR: u32 = 3373;
pub const DEFAULT_ROLE_READ_ALL_SETTINGS: u32 = 3374;
pub const DEFAULT_ROLE_READ_ALL_STATS: u32 = 3375;
pub const DEFAULT_ROLE_STAT_SCAN_TABLES: u32 = 3377;
pub const DEFAULT_ROLE_READ_SERVER_FILES: u32 = 4569;
pub const DEFAULT_ROLE_WRITE_SERVER_FILES: u32 = 4570;
pub const DEFAULT_ROLE_EXECUTE_SERVER_PROGRAM: u32 = 4571;
pub const DEFAULT_ROLE_SIGNAL_BACKENDID: u32 = 4200;
pub const EnumRelationId: u32 = 3501;
pub const Anum_pg_enum_oid: u32 = 1;
pub const Anum_pg_enum_enumtypid: u32 = 2;
pub const Anum_pg_enum_enumsortorder: u32 = 3;
pub const Anum_pg_enum_enumlabel: u32 = 4;
pub const Natts_pg_enum: u32 = 4;
pub const OperatorRelationId: u32 = 2617;
pub const Anum_pg_operator_oid: u32 = 1;
pub const Anum_pg_operator_oprname: u32 = 2;
pub const Anum_pg_operator_oprnamespace: u32 = 3;
pub const Anum_pg_operator_oprowner: u32 = 4;
pub const Anum_pg_operator_oprkind: u32 = 5;
pub const Anum_pg_operator_oprcanmerge: u32 = 6;
pub const Anum_pg_operator_oprcanhash: u32 = 7;
pub const Anum_pg_operator_oprleft: u32 = 8;
pub const Anum_pg_operator_oprright: u32 = 9;
pub const Anum_pg_operator_oprresult: u32 = 10;
pub const Anum_pg_operator_oprcom: u32 = 11;
pub const Anum_pg_operator_oprnegate: u32 = 12;
pub const Anum_pg_operator_oprcode: u32 = 13;
pub const Anum_pg_operator_oprrest: u32 = 14;
pub const Anum_pg_operator_oprjoin: u32 = 15;
pub const Natts_pg_operator: u32 = 15;
pub const BooleanNotEqualOperator: u32 = 85;
pub const BooleanEqualOperator: u32 = 91;
pub const Int4EqualOperator: u32 = 96;
pub const Int4LessOperator: u32 = 97;
pub const TextEqualOperator: u32 = 98;
pub const NameEqualTextOperator: u32 = 254;
pub const NameLessTextOperator: u32 = 255;
pub const NameGreaterEqualTextOperator: u32 = 257;
pub const TIDEqualOperator: u32 = 387;
pub const TIDLessOperator: u32 = 2799;
pub const Int8LessOperator: u32 = 412;
pub const OID_NAME_REGEXEQ_OP: u32 = 639;
pub const OID_TEXT_REGEXEQ_OP: u32 = 641;
pub const TextLessOperator: u32 = 664;
pub const TextGreaterEqualOperator: u32 = 667;
pub const Float8LessOperator: u32 = 672;
pub const BpcharEqualOperator: u32 = 1054;
pub const OID_BPCHAR_REGEXEQ_OP: u32 = 1055;
pub const BpcharLessOperator: u32 = 1058;
pub const BpcharGreaterEqualOperator: u32 = 1061;
pub const ARRAY_EQ_OP: u32 = 1070;
pub const ARRAY_LT_OP: u32 = 1072;
pub const ARRAY_GT_OP: u32 = 1073;
pub const OID_NAME_LIKE_OP: u32 = 1207;
pub const OID_TEXT_LIKE_OP: u32 = 1209;
pub const OID_BPCHAR_LIKE_OP: u32 = 1211;
pub const OID_NAME_ICREGEXEQ_OP: u32 = 1226;
pub const OID_TEXT_ICREGEXEQ_OP: u32 = 1228;
pub const OID_BPCHAR_ICREGEXEQ_OP: u32 = 1234;
pub const OID_INET_SUB_OP: u32 = 931;
pub const OID_INET_SUBEQ_OP: u32 = 932;
pub const OID_INET_SUP_OP: u32 = 933;
pub const OID_INET_SUPEQ_OP: u32 = 934;
pub const OID_INET_OVERLAP_OP: u32 = 3552;
pub const OID_NAME_ICLIKE_OP: u32 = 1625;
pub const OID_TEXT_ICLIKE_OP: u32 = 1627;
pub const OID_BPCHAR_ICLIKE_OP: u32 = 1629;
pub const ByteaEqualOperator: u32 = 1955;
pub const ByteaLessOperator: u32 = 1957;
pub const ByteaGreaterEqualOperator: u32 = 1960;
pub const OID_BYTEA_LIKE_OP: u32 = 2016;
pub const TextPatternLessOperator: u32 = 2314;
pub const TextPatternGreaterEqualOperator: u32 = 2317;
pub const BpcharPatternLessOperator: u32 = 2326;
pub const BpcharPatternGreaterEqualOperator: u32 = 2329;
pub const OID_ARRAY_OVERLAP_OP: u32 = 2750;
pub const OID_ARRAY_CONTAINS_OP: u32 = 2751;
pub const OID_ARRAY_CONTAINED_OP: u32 = 2752;
pub const RECORD_EQ_OP: u32 = 2988;
pub const RECORD_LT_OP: u32 = 2990;
pub const RECORD_GT_OP: u32 = 2991;
pub const OID_RANGE_LESS_OP: u32 = 3884;
pub const OID_RANGE_LESS_EQUAL_OP: u32 = 3885;
pub const OID_RANGE_GREATER_EQUAL_OP: u32 = 3886;
pub const OID_RANGE_GREATER_OP: u32 = 3887;
pub const OID_RANGE_OVERLAP_OP: u32 = 3888;
pub const OID_RANGE_CONTAINS_ELEM_OP: u32 = 3889;
pub const OID_RANGE_CONTAINS_OP: u32 = 3890;
pub const OID_RANGE_ELEM_CONTAINED_OP: u32 = 3891;
pub const OID_RANGE_CONTAINED_OP: u32 = 3892;
pub const OID_RANGE_LEFT_OP: u32 = 3893;
pub const OID_RANGE_RIGHT_OP: u32 = 3894;
pub const OID_RANGE_OVERLAPS_LEFT_OP: u32 = 3895;
pub const OID_RANGE_OVERLAPS_RIGHT_OP: u32 = 3896;
pub const ProcedureRelationId: u32 = 1255;
pub const ProcedureRelation_Rowtype_Id: u32 = 81;
pub const Anum_pg_proc_oid: u32 = 1;
pub const Anum_pg_proc_proname: u32 = 2;
pub const Anum_pg_proc_pronamespace: u32 = 3;
pub const Anum_pg_proc_proowner: u32 = 4;
pub const Anum_pg_proc_prolang: u32 = 5;
pub const Anum_pg_proc_procost: u32 = 6;
pub const Anum_pg_proc_prorows: u32 = 7;
pub const Anum_pg_proc_provariadic: u32 = 8;
pub const Anum_pg_proc_prosupport: u32 = 9;
pub const Anum_pg_proc_prokind: u32 = 10;
pub const Anum_pg_proc_prosecdef: u32 = 11;
pub const Anum_pg_proc_proleakproof: u32 = 12;
pub const Anum_pg_proc_proisstrict: u32 = 13;
pub const Anum_pg_proc_proretset: u32 = 14;
pub const Anum_pg_proc_provolatile: u32 = 15;
pub const Anum_pg_proc_proparallel: u32 = 16;
pub const Anum_pg_proc_pronargs: u32 = 17;
pub const Anum_pg_proc_pronargdefaults: u32 = 18;
pub const Anum_pg_proc_prorettype: u32 = 19;
pub const Anum_pg_proc_proargtypes: u32 = 20;
pub const Anum_pg_proc_proallargtypes: u32 = 21;
pub const Anum_pg_proc_proargmodes: u32 = 22;
pub const Anum_pg_proc_proargnames: u32 = 23;
pub const Anum_pg_proc_proargdefaults: u32 = 24;
pub const Anum_pg_proc_protrftypes: u32 = 25;
pub const Anum_pg_proc_prosrc: u32 = 26;
pub const Anum_pg_proc_probin: u32 = 27;
pub const Anum_pg_proc_proconfig: u32 = 28;
pub const Anum_pg_proc_proacl: u32 = 29;
pub const Natts_pg_proc: u32 = 29;
pub const PROKIND_FUNCTION: u8 = 102u8;
pub const PROKIND_AGGREGATE: u8 = 97u8;
pub const PROKIND_WINDOW: u8 = 119u8;
pub const PROKIND_PROCEDURE: u8 = 112u8;
pub const PROVOLATILE_IMMUTABLE: u8 = 105u8;
pub const PROVOLATILE_STABLE: u8 = 115u8;
pub const PROVOLATILE_VOLATILE: u8 = 118u8;
pub const PROPARALLEL_SAFE: u8 = 115u8;
pub const PROPARALLEL_RESTRICTED: u8 = 114u8;
pub const PROPARALLEL_UNSAFE: u8 = 117u8;
pub const PROARGMODE_IN: u8 = 105u8;
pub const PROARGMODE_OUT: u8 = 111u8;
pub const PROARGMODE_INOUT: u8 = 98u8;
pub const PROARGMODE_VARIADIC: u8 = 118u8;
pub const PROARGMODE_TABLE: u8 = 116u8;
pub const HEAP_TABLE_AM_HANDLER_OID: u32 = 3;
pub const TriggerRelationId: u32 = 2620;
pub const Anum_pg_trigger_oid: u32 = 1;
pub const Anum_pg_trigger_tgrelid: u32 = 2;
pub const Anum_pg_trigger_tgparentid: u32 = 3;
pub const Anum_pg_trigger_tgname: u32 = 4;
pub const Anum_pg_trigger_tgfoid: u32 = 5;
pub const Anum_pg_trigger_tgtype: u32 = 6;
pub const Anum_pg_trigger_tgenabled: u32 = 7;
pub const Anum_pg_trigger_tgisinternal: u32 = 8;
pub const Anum_pg_trigger_tgconstrrelid: u32 = 9;
pub const Anum_pg_trigger_tgconstrindid: u32 = 10;
pub const Anum_pg_trigger_tgconstraint: u32 = 11;
pub const Anum_pg_trigger_tgdeferrable: u32 = 12;
pub const Anum_pg_trigger_tginitdeferred: u32 = 13;
pub const Anum_pg_trigger_tgnargs: u32 = 14;
pub const Anum_pg_trigger_tgattr: u32 = 15;
pub const Anum_pg_trigger_tgargs: u32 = 16;
pub const Anum_pg_trigger_tgqual: u32 = 17;
pub const Anum_pg_trigger_tgoldtable: u32 = 18;
pub const Anum_pg_trigger_tgnewtable: u32 = 19;
pub const Natts_pg_trigger: u32 = 19;
pub const TRIGGER_TYPE_ROW: u32 = 1;
pub const TRIGGER_TYPE_BEFORE: u32 = 2;
pub const TRIGGER_TYPE_INSERT: u32 = 4;
pub const TRIGGER_TYPE_DELETE: u32 = 8;
pub const TRIGGER_TYPE_UPDATE: u32 = 16;
pub const TRIGGER_TYPE_TRUNCATE: u32 = 32;
pub const TRIGGER_TYPE_INSTEAD: u32 = 64;
pub const TRIGGER_TYPE_LEVEL_MASK: u32 = 1;
pub const TRIGGER_TYPE_STATEMENT: u32 = 0;
pub const TRIGGER_TYPE_TIMING_MASK: u32 = 66;
pub const TRIGGER_TYPE_AFTER: u32 = 0;
pub const TRIGGER_TYPE_EVENT_MASK: u32 = 60;
pub const EventTriggerRelationId: u32 = 3466;
pub const Anum_pg_event_trigger_oid: u32 = 1;
pub const Anum_pg_event_trigger_evtname: u32 = 2;
pub const Anum_pg_event_trigger_evtevent: u32 = 3;
pub const Anum_pg_event_trigger_evtowner: u32 = 4;
pub const Anum_pg_event_trigger_evtfoid: u32 = 5;
pub const Anum_pg_event_trigger_evtenabled: u32 = 6;
pub const Anum_pg_event_trigger_evttags: u32 = 7;
pub const Natts_pg_event_trigger: u32 = 7;
pub const AT_REWRITE_ALTER_PERSISTENCE: u32 = 1;
pub const AT_REWRITE_DEFAULT_VAL: u32 = 2;
pub const AT_REWRITE_COLUMN_REWRITE: u32 = 4;
pub const TRIGGER_EVENT_INSERT: u32 = 0;
pub const TRIGGER_EVENT_DELETE: u32 = 1;
pub const TRIGGER_EVENT_UPDATE: u32 = 2;
pub const TRIGGER_EVENT_TRUNCATE: u32 = 3;
pub const TRIGGER_EVENT_OPMASK: u32 = 3;
pub const TRIGGER_EVENT_ROW: u32 = 4;
pub const TRIGGER_EVENT_BEFORE: u32 = 8;
pub const TRIGGER_EVENT_AFTER: u32 = 0;
pub const TRIGGER_EVENT_INSTEAD: u32 = 16;
pub const TRIGGER_EVENT_TIMINGMASK: u32 = 24;
pub const AFTER_TRIGGER_DEFERRABLE: u32 = 32;
pub const AFTER_TRIGGER_INITDEFERRED: u32 = 64;
pub const SESSION_REPLICATION_ROLE_ORIGIN: u32 = 0;
pub const SESSION_REPLICATION_ROLE_REPLICA: u32 = 1;
pub const SESSION_REPLICATION_ROLE_LOCAL: u32 = 2;
pub const TRIGGER_FIRES_ON_ORIGIN: u8 = 79u8;
pub const TRIGGER_FIRES_ALWAYS: u8 = 65u8;
pub const TRIGGER_FIRES_ON_REPLICA: u8 = 82u8;
pub const TRIGGER_DISABLED: u8 = 68u8;
pub const RI_TRIGGER_PK: u32 = 1;
pub const RI_TRIGGER_FK: u32 = 2;
pub const RI_TRIGGER_NONE: u32 = 0;
pub const StatisticRelationId: u32 = 2619;
pub const Anum_pg_statistic_starelid: u32 = 1;
pub const Anum_pg_statistic_staattnum: u32 = 2;
pub const Anum_pg_statistic_stainherit: u32 = 3;
pub const Anum_pg_statistic_stanullfrac: u32 = 4;
pub const Anum_pg_statistic_stawidth: u32 = 5;
pub const Anum_pg_statistic_stadistinct: u32 = 6;
pub const Anum_pg_statistic_stakind1: u32 = 7;
pub const Anum_pg_statistic_stakind2: u32 = 8;
pub const Anum_pg_statistic_stakind3: u32 = 9;
pub const Anum_pg_statistic_stakind4: u32 = 10;
pub const Anum_pg_statistic_stakind5: u32 = 11;
pub const Anum_pg_statistic_staop1: u32 = 12;
pub const Anum_pg_statistic_staop2: u32 = 13;
pub const Anum_pg_statistic_staop3: u32 = 14;
pub const Anum_pg_statistic_staop4: u32 = 15;
pub const Anum_pg_statistic_staop5: u32 = 16;
pub const Anum_pg_statistic_stacoll1: u32 = 17;
pub const Anum_pg_statistic_stacoll2: u32 = 18;
pub const Anum_pg_statistic_stacoll3: u32 = 19;
pub const Anum_pg_statistic_stacoll4: u32 = 20;
pub const Anum_pg_statistic_stacoll5: u32 = 21;
pub const Anum_pg_statistic_stanumbers1: u32 = 22;
pub const Anum_pg_statistic_stanumbers2: u32 = 23;
pub const Anum_pg_statistic_stanumbers3: u32 = 24;
pub const Anum_pg_statistic_stanumbers4: u32 = 25;
pub const Anum_pg_statistic_stanumbers5: u32 = 26;
pub const Anum_pg_statistic_stavalues1: u32 = 27;
pub const Anum_pg_statistic_stavalues2: u32 = 28;
pub const Anum_pg_statistic_stavalues3: u32 = 29;
pub const Anum_pg_statistic_stavalues4: u32 = 30;
pub const Anum_pg_statistic_stavalues5: u32 = 31;
pub const Natts_pg_statistic: u32 = 31;
pub const STATISTIC_KIND_MCV: u32 = 1;
pub const STATISTIC_KIND_HISTOGRAM: u32 = 2;
pub const STATISTIC_KIND_CORRELATION: u32 = 3;
pub const STATISTIC_KIND_MCELEM: u32 = 4;
pub const STATISTIC_KIND_DECHIST: u32 = 5;
pub const STATISTIC_KIND_RANGE_LENGTH_HISTOGRAM: u32 = 6;
pub const STATISTIC_KIND_BOUNDS_HISTOGRAM: u32 = 7;
pub const STATISTIC_NUM_SLOTS: u32 = 5;
pub const VACUUM_OPTION_NO_PARALLEL: u32 = 0;
pub const VACUUM_OPTION_PARALLEL_BULKDEL: u32 = 1;
pub const VACUUM_OPTION_PARALLEL_COND_CLEANUP: u32 = 2;
pub const VACUUM_OPTION_PARALLEL_CLEANUP: u32 = 4;
pub const VACUUM_OPTION_MAX_VALID_VALUE: u32 = 7;
pub const CACHEDPLANSOURCE_MAGIC: u32 = 195726186;
pub const CACHEDPLAN_MAGIC: u32 = 953717834;
pub const CACHEDEXPR_MAGIC: u32 = 838275847;
pub const SPI_ERROR_CONNECT: i32 = -1;
pub const SPI_ERROR_COPY: i32 = -2;
pub const SPI_ERROR_OPUNKNOWN: i32 = -3;
pub const SPI_ERROR_UNCONNECTED: i32 = -4;
pub const SPI_ERROR_CURSOR: i32 = -5;
pub const SPI_ERROR_ARGUMENT: i32 = -6;
pub const SPI_ERROR_PARAM: i32 = -7;
pub const SPI_ERROR_TRANSACTION: i32 = -8;
pub const SPI_ERROR_NOATTRIBUTE: i32 = -9;
pub const SPI_ERROR_NOOUTFUNC: i32 = -10;
pub const SPI_ERROR_TYPUNKNOWN: i32 = -11;
pub const SPI_ERROR_REL_DUPLICATE: i32 = -12;
pub const SPI_ERROR_REL_NOT_FOUND: i32 = -13;
pub const SPI_OK_CONNECT: u32 = 1;
pub const SPI_OK_FINISH: u32 = 2;
pub const SPI_OK_FETCH: u32 = 3;
pub const SPI_OK_UTILITY: u32 = 4;
pub const SPI_OK_SELECT: u32 = 5;
pub const SPI_OK_SELINTO: u32 = 6;
pub const SPI_OK_INSERT: u32 = 7;
pub const SPI_OK_DELETE: u32 = 8;
pub const SPI_OK_UPDATE: u32 = 9;
pub const SPI_OK_CURSOR: u32 = 10;
pub const SPI_OK_INSERT_RETURNING: u32 = 11;
pub const SPI_OK_DELETE_RETURNING: u32 = 12;
pub const SPI_OK_UPDATE_RETURNING: u32 = 13;
pub const SPI_OK_REWRITTEN: u32 = 14;
pub const SPI_OK_REL_REGISTER: u32 = 15;
pub const SPI_OK_REL_UNREGISTER: u32 = 16;
pub const SPI_OK_TD_REGISTER: u32 = 17;
pub const SPI_OPT_NONATOMIC: u32 = 1;
pub const BGWORKER_SHMEM_ACCESS: u32 = 1;
pub const BGWORKER_BACKEND_DATABASE_CONNECTION: u32 = 2;
pub const BGWORKER_CLASS_PARALLEL: u32 = 16;
pub const BGW_DEFAULT_RESTART_INTERVAL: u32 = 60;
pub const BGW_NEVER_RESTART: i32 = -1;
pub const BGW_MAXLEN: u32 = 96;
pub const BGW_EXTRALEN: u32 = 128;
pub const BGWORKER_BYPASS_ALLOWCONN: u32 = 1;
pub const HAVE_PLANNERINFO_TYPEDEF: u32 = 1;
pub const HAVE_INDEXOPTINFO_TYPEDEF: u32 = 1;
pub const HAVE_SPECIALJOININFO_TYPEDEF: u32 = 1;
pub const GROUPING_CAN_USE_SORT: u32 = 1;
pub const GROUPING_CAN_USE_HASH: u32 = 2;
pub const GROUPING_CAN_PARTIAL_AGG: u32 = 4;
pub const FSV_MISSING_OK: u32 = 1;
pub const FDW_MISSING_OK: u32 = 1;
pub const MAX_MULTIBYTE_CHAR_LEN: u32 = 4;
pub const SS2: u32 = 142;
pub const SS3: u32 = 143;
pub const LC_ISO8859_1: u32 = 129;
pub const LC_ISO8859_2: u32 = 130;
pub const LC_ISO8859_3: u32 = 131;
pub const LC_ISO8859_4: u32 = 132;
pub const LC_TIS620: u32 = 133;
pub const LC_ISO8859_7: u32 = 134;
pub const LC_ISO8859_6: u32 = 135;
pub const LC_ISO8859_8: u32 = 136;
pub const LC_JISX0201K: u32 = 137;
pub const LC_JISX0201R: u32 = 138;
pub const LC_KOI8_R: u32 = 139;
pub const LC_ISO8859_5: u32 = 140;
pub const LC_ISO8859_9: u32 = 141;
pub const LC_ISO8859_15: u32 = 142;
pub const LC_JISX0208_1978: u32 = 144;
pub const LC_GB2312_80: u32 = 145;
pub const LC_JISX0208: u32 = 146;
pub const LC_KS5601: u32 = 147;
pub const LC_JISX0212: u32 = 148;
pub const LC_CNS11643_1: u32 = 149;
pub const LC_CNS11643_2: u32 = 150;
pub const LC_JISX0213_1: u32 = 151;
pub const LC_BIG5_1: u32 = 152;
pub const LC_BIG5_2: u32 = 153;
pub const LCPRV1_A: u32 = 154;
pub const LCPRV1_B: u32 = 155;
pub const LCPRV2_A: u32 = 156;
pub const LCPRV2_B: u32 = 157;
pub const LC_SISHENG: u32 = 160;
pub const LC_IPA: u32 = 161;
pub const LC_VISCII_LOWER: u32 = 162;
pub const LC_VISCII_UPPER: u32 = 163;
pub const LC_ARABIC_DIGIT: u32 = 164;
pub const LC_ARABIC_1_COLUMN: u32 = 165;
pub const LC_ASCII_RIGHT_TO_LEFT: u32 = 166;
pub const LC_LAO: u32 = 167;
pub const LC_ARABIC_2_COLUMN: u32 = 168;
pub const LC_INDIAN_1_COLUMN: u32 = 240;
pub const LC_TIBETAN_1_COLUMN: u32 = 241;
pub const LC_UNICODE_SUBSET_2: u32 = 242;
pub const LC_UNICODE_SUBSET_3: u32 = 243;
pub const LC_UNICODE_SUBSET: u32 = 244;
pub const LC_ETHIOPIC: u32 = 245;
pub const LC_CNS11643_3: u32 = 246;
pub const LC_CNS11643_4: u32 = 247;
pub const LC_CNS11643_5: u32 = 248;
pub const LC_CNS11643_6: u32 = 249;
pub const LC_CNS11643_7: u32 = 250;
pub const LC_INDIAN_2_COLUMN: u32 = 251;
pub const LC_TIBETAN: u32 = 252;
pub const MAX_CONVERSION_GROWTH: u32 = 4;
pub const MAX_UNICODE_EQUIVALENT_STRING: u32 = 16;
pub const EXTNODENAME_MAX_LEN: u32 = 64;
pub const CUSTOMPATH_SUPPORT_BACKWARD_SCAN: u32 = 1;
pub const CUSTOMPATH_SUPPORT_MARK_RESTORE: u32 = 2;
pub const QTW_IGNORE_RT_SUBQUERIES: u32 = 1;
pub const QTW_IGNORE_CTE_SUBQUERIES: u32 = 2;
pub const QTW_IGNORE_RC_SUBQUERIES: u32 = 3;
pub const QTW_IGNORE_JOINALIASES: u32 = 4;
pub const QTW_IGNORE_RANGE_TABLE: u32 = 8;
pub const QTW_EXAMINE_RTES_BEFORE: u32 = 16;
pub const QTW_EXAMINE_RTES_AFTER: u32 = 32;
pub const QTW_DONT_COPY_QUERY: u32 = 64;
pub const QTW_EXAMINE_SORTGROUP: u32 = 128;
pub const DEFAULT_SEQ_PAGE_COST: f64 = 1.0;
pub const DEFAULT_RANDOM_PAGE_COST: f64 = 4.0;
pub const DEFAULT_CPU_TUPLE_COST: f64 = 0.01;
pub const DEFAULT_CPU_INDEX_TUPLE_COST: f64 = 0.005;
pub const DEFAULT_CPU_OPERATOR_COST: f64 = 0.0025;
pub const DEFAULT_PARALLEL_TUPLE_COST: f64 = 0.1;
pub const DEFAULT_PARALLEL_SETUP_COST: f64 = 1000.0;
pub const DEFAULT_EFFECTIVE_CACHE_SIZE: u32 = 524288;
pub const PVC_INCLUDE_AGGREGATES: u32 = 1;
pub const PVC_RECURSE_AGGREGATES: u32 = 2;
pub const PVC_INCLUDE_WINDOWFUNCS: u32 = 4;
pub const PVC_RECURSE_WINDOWFUNCS: u32 = 8;
pub const PVC_INCLUDE_PLACEHOLDERS: u32 = 16;
pub const PVC_RECURSE_PLACEHOLDERS: u32 = 32;
pub const DEFAULT_CURSOR_TUPLE_FRACTION: f64 = 0.1;
pub const RBTXN_HAS_CATALOG_CHANGES: u32 = 1;
pub const RBTXN_IS_SUBXACT: u32 = 2;
pub const RBTXN_IS_SERIALIZED: u32 = 4;
pub const OLD_SNAPSHOT_PADDING_ENTRIES: u32 = 10;
pub const MAX_IO_CONCURRENCY: u32 = 1000;
pub const BUFFER_LOCK_UNLOCK: u32 = 0;
pub const BUFFER_LOCK_SHARE: u32 = 1;
pub const BUFFER_LOCK_EXCLUSIVE: u32 = 2;
pub const XLOG_STANDBY_LOCK: u32 = 0;
pub const XLOG_RUNNING_XACTS: u32 = 16;
pub const XLOG_INVALIDATIONS: u32 = 32;
pub const PROCARRAY_VACUUM_FLAG: u32 = 2;
pub const PROCARRAY_ANALYZE_FLAG: u32 = 4;
pub const PROCARRAY_LOGICAL_DECODING_FLAG: u32 = 16;
pub const PROCARRAY_SLOTS_XMIN: u32 = 32;
pub const PROCARRAY_PROC_FLAGS_MASK: u32 = 22;
pub const PROCARRAY_FLAGS_DEFAULT: u32 = 16;
pub const PROCARRAY_FLAGS_VACUUM: u32 = 18;
pub const PROCARRAY_FLAGS_ANALYZE: u32 = 20;
pub const PROCARRAY_FLAGS_VACUUM_ANALYZE: u32 = 22;
pub const STACK_DEPTH_SLOP: u32 = 524288;
pub const COMMAND_OK_IN_READ_ONLY_TXN: u32 = 1;
pub const COMMAND_OK_IN_PARALLEL_MODE: u32 = 2;
pub const COMMAND_OK_IN_RECOVERY: u32 = 4;
pub const COMMAND_IS_STRICTLY_READ_ONLY: u32 = 7;
pub const COMMAND_IS_NOT_READ_ONLY: u32 = 0;
pub const MAXSTRLEN: u32 = 2047;
pub const MAXSTRPOS: u32 = 1048575;
pub const MAXENTRYPOS: u32 = 16384;
pub const MAXNUMPOS: u32 = 256;
pub const QI_VAL: u32 = 1;
pub const QI_OPR: u32 = 2;
pub const QI_VALSTOP: u32 = 3;
pub const OP_NOT: u32 = 1;
pub const OP_AND: u32 = 2;
pub const OP_OR: u32 = 3;
pub const OP_PHRASE: u32 = 4;
pub const OP_COUNT: u32 = 4;
pub const TSL_ADDPOS: u32 = 1;
pub const TSL_PREFIX: u32 = 2;
pub const TSL_FILTER: u32 = 4;
pub const P_TSV_OPR_IS_DELIM: u32 = 1;
pub const P_TSV_IS_TSQUERY: u32 = 2;
pub const P_TSV_IS_WEB: u32 = 4;
pub const P_TSQ_PLAIN: u32 = 1;
pub const P_TSQ_WEB: u32 = 2;
pub const TS_EXEC_EMPTY: u32 = 0;
pub const TS_EXEC_SKIP_NOT: u32 = 1;
pub const TS_EXEC_PHRASE_NO_POS: u32 = 2;
pub const TSearchStrategyNumber: u32 = 1;
pub const TSearchWithClassStrategyNumber: u32 = 2;
pub const QTN_NEEDFREE: u32 = 1;
pub const QTN_NOCHANGE: u32 = 2;
pub const QTN_WORDFREE: u32 = 4;
pub const MAXINT8LEN: u32 = 20;
pub const FORMAT_TYPE_TYPEMOD_GIVEN: u32 = 1;
pub const FORMAT_TYPE_ALLOW_INVALID: u32 = 2;
pub const FORMAT_TYPE_FORCE_QUALIFY: u32 = 4;
pub const MAX_TIME_PRECISION: u32 = 6;
pub const RADIANS_PER_DEGREE: f64 = 0.017453292519943295;
pub const NUMERIC_MAX_PRECISION: u32 = 1000;
pub const NUMERIC_MAX_DISPLAY_SCALE: u32 = 1000;
pub const NUMERIC_MIN_DISPLAY_SCALE: u32 = 0;
pub const NUMERIC_MAX_RESULT_SCALE: u32 = 2000;
pub const NUMERIC_MIN_SIG_DIGITS: u32 = 16;
pub const JsonbContainsStrategyNumber: u32 = 7;
pub const JsonbExistsStrategyNumber: u32 = 9;
pub const JsonbExistsAnyStrategyNumber: u32 = 10;
pub const JsonbExistsAllStrategyNumber: u32 = 11;
pub const JsonbJsonpathExistsStrategyNumber: u32 = 15;
pub const JsonbJsonpathPredicateStrategyNumber: u32 = 16;
pub const JGINFLAG_KEY: u32 = 1;
pub const JGINFLAG_NULL: u32 = 2;
pub const JGINFLAG_BOOL: u32 = 3;
pub const JGINFLAG_NUM: u32 = 4;
pub const JGINFLAG_STR: u32 = 5;
pub const JGINFLAG_HASHED: u32 = 16;
pub const JGIN_MAXLENGTH: u32 = 125;
pub const JENTRY_OFFLENMASK: u32 = 268435455;
pub const JENTRY_TYPEMASK: u32 = 1879048192;
pub const JENTRY_HAS_OFF: u32 = 2147483648;
pub const JENTRY_ISSTRING: u32 = 0;
pub const JENTRY_ISNUMERIC: u32 = 268435456;
pub const JENTRY_ISBOOL_FALSE: u32 = 536870912;
pub const JENTRY_ISBOOL_TRUE: u32 = 805306368;
pub const JENTRY_ISNULL: u32 = 1073741824;
pub const JENTRY_ISCONTAINER: u32 = 1342177280;
pub const JB_OFFSET_STRIDE: u32 = 32;
pub const JB_CMASK: u32 = 268435455;
pub const JB_FSCALAR: u32 = 268435456;
pub const JB_FOBJECT: u32 = 536870912;
pub const JB_FARRAY: u32 = 1073741824;
pub const ATTSTATSSLOT_VALUES: u32 = 1;
pub const ATTSTATSSLOT_NUMBERS: u32 = 2;
pub const DEFAULT_EQ_SEL: f64 = 0.005;
pub const DEFAULT_INEQ_SEL: f64 = 0.3333333333333333;
pub const DEFAULT_RANGE_INEQ_SEL: f64 = 0.005;
pub const DEFAULT_MATCH_SEL: f64 = 0.005;
pub const DEFAULT_MATCHING_SEL: f64 = 0.01;
pub const DEFAULT_NUM_DISTINCT: u32 = 200;
pub const DEFAULT_UNK_SEL: f64 = 0.005;
pub const DEFAULT_NOT_UNK_SEL: f64 = 0.995;
pub const TYPECACHE_EQ_OPR: u32 = 1;
pub const TYPECACHE_LT_OPR: u32 = 2;
pub const TYPECACHE_GT_OPR: u32 = 4;
pub const TYPECACHE_CMP_PROC: u32 = 8;
pub const TYPECACHE_HASH_PROC: u32 = 16;
pub const TYPECACHE_EQ_OPR_FINFO: u32 = 32;
pub const TYPECACHE_CMP_PROC_FINFO: u32 = 64;
pub const TYPECACHE_HASH_PROC_FINFO: u32 = 128;
pub const TYPECACHE_TUPDESC: u32 = 256;
pub const TYPECACHE_BTREE_OPFAMILY: u32 = 512;
pub const TYPECACHE_HASH_OPFAMILY: u32 = 1024;
pub const TYPECACHE_RANGE_INFO: u32 = 2048;
pub const TYPECACHE_DOMAIN_BASE_INFO: u32 = 4096;
pub const TYPECACHE_DOMAIN_CONSTR_INFO: u32 = 8192;
pub const TYPECACHE_HASH_EXTENDED_PROC: u32 = 16384;
pub const TYPECACHE_HASH_EXTENDED_PROC_FINFO: u32 = 32768;
pub const RANGE_EMPTY: u32 = 1;
pub const RANGE_LB_INC: u32 = 2;
pub const RANGE_UB_INC: u32 = 4;
pub const RANGE_LB_INF: u32 = 8;
pub const RANGE_UB_INF: u32 = 16;
pub const RANGE_LB_NULL: u32 = 32;
pub const RANGE_UB_NULL: u32 = 64;
pub const RANGE_CONTAIN_EMPTY: u32 = 128;
pub const RANGESTRAT_BEFORE: u32 = 1;
pub const RANGESTRAT_OVERLEFT: u32 = 2;
pub const RANGESTRAT_OVERLAPS: u32 = 3;
pub const RANGESTRAT_OVERRIGHT: u32 = 4;
pub const RANGESTRAT_AFTER: u32 = 5;
pub const RANGESTRAT_ADJACENT: u32 = 6;
pub const RANGESTRAT_CONTAINS: u32 = 7;
pub const RANGESTRAT_CONTAINED_BY: u32 = 8;
pub const RANGESTRAT_CONTAINS_ELEM: u32 = 16;
pub const RANGESTRAT_EQ: u32 = 18;
pub type Oid = ::std::os::raw::c_uint;
pub type pg_int64 = ::std::os::raw::c_long;
pub type va_list = __builtin_va_list;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
pub type __time_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type off_t = __off_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __atomic_wide_counter {
    pub __value64: ::std::os::raw::c_ulonglong,
    pub __value32: __atomic_wide_counter__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __atomic_wide_counter__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
impl Default for __atomic_wide_counter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
impl Default for __pthread_mutex_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __wseq: __atomic_wide_counter,
    pub __g1_start: __atomic_wide_counter,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
impl Default for __pthread_cond_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_mutexattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_condattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_attr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_mutex_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
impl Default for pthread_cond_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_rwlock_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_rwlockattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_barrier_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_barrierattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Pointer = *mut ::std::os::raw::c_char;
pub type int8 = ::std::os::raw::c_schar;
pub type int16 = ::std::os::raw::c_short;
pub type int32 = ::std::os::raw::c_int;
pub type uint8 = ::std::os::raw::c_uchar;
pub type uint16 = ::std::os::raw::c_ushort;
pub type uint32 = ::std::os::raw::c_uint;
pub type bits8 = uint8;
pub type bits16 = uint16;
pub type bits32 = uint32;
pub type int64 = ::std::os::raw::c_long;
pub type uint64 = ::std::os::raw::c_ulong;
pub type int128 = i128;
pub type uint128 = u128;
pub type Size = usize;
pub type Index = ::std::os::raw::c_uint;
pub type Offset = ::std::os::raw::c_int;
pub type float4 = f32;
pub type float8 = f64;
pub type regproc = Oid;
pub type RegProcedure = regproc;
pub type TransactionId = uint32;
pub type LocalTransactionId = uint32;
pub type SubTransactionId = uint32;
pub type MultiXactId = TransactionId;
pub type MultiXactOffset = uint32;
pub type CommandId = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IntArray {
    pub indx: [::std::os::raw::c_int; 6usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varlena {
    pub vl_len_: [::std::os::raw::c_char; 4usize],
    pub vl_dat: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type bytea = varlena;
pub type text = varlena;
pub type BpChar = varlena;
pub type VarChar = varlena;
#[repr(C)]
#[derive(Debug, Default)]
pub struct int2vector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<int16>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct oidvector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<Oid>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nameData {
    pub data: [::std::os::raw::c_char; 64usize],
}
impl Default for nameData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type NameData = nameData;
pub type Name = *mut NameData;
pub unsafe fn ExceptionalCondition(
    arg_conditionName: *const ::std::os::raw::c_char,
    arg_errorType: *const ::std::os::raw::c_char,
    arg_fileName: *const ::std::os::raw::c_char,
    arg_lineNumber: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExceptionalCondition(
                arg_conditionName: *const ::std::os::raw::c_char,
                arg_errorType: *const ::std::os::raw::c_char,
                arg_fileName: *const ::std::os::raw::c_char,
                arg_lineNumber: ::std::os::raw::c_int,
            );
        }
        ExceptionalCondition(arg_conditionName, arg_errorType, arg_fileName, arg_lineNumber)
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedXLogBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedXLogBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type socklen_t = __socklen_t;
pub type sa_family_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_family: sa_family_t,
    pub __ss_padding: [::std::os::raw::c_char; 118usize],
    pub __ss_align: ::std::os::raw::c_ulong,
}
impl Default for sockaddr_storage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hostent {
    pub h_name: *mut ::std::os::raw::c_char,
    pub h_aliases: *mut *mut ::std::os::raw::c_char,
    pub h_addrtype: ::std::os::raw::c_int,
    pub h_length: ::std::os::raw::c_int,
    pub h_addr_list: *mut *mut ::std::os::raw::c_char,
}
impl Default for hostent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct passwd {
    pub pw_name: *mut ::std::os::raw::c_char,
    pub pw_passwd: *mut ::std::os::raw::c_char,
    pub pw_uid: __uid_t,
    pub pw_gid: __gid_t,
    pub pw_gecos: *mut ::std::os::raw::c_char,
    pub pw_dir: *mut ::std::os::raw::c_char,
    pub pw_shell: *mut ::std::os::raw::c_char,
}
impl Default for passwd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pgsocket = ::std::os::raw::c_int;
pub unsafe fn pg_set_noblock(arg_sock: pgsocket) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_set_noblock(arg_sock: pgsocket) -> bool;
        }
        pg_set_noblock(arg_sock)
    })
}
pub unsafe fn pg_set_block(arg_sock: pgsocket) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_set_block(arg_sock: pgsocket) -> bool;
        }
        pg_set_block(arg_sock)
    })
}
pub unsafe fn has_drive_prefix(arg_filename: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn has_drive_prefix(arg_filename: *const ::std::os::raw::c_char) -> bool;
        }
        has_drive_prefix(arg_filename)
    })
}
pub unsafe fn first_dir_separator(
    arg_filename: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn first_dir_separator(
                arg_filename: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        first_dir_separator(arg_filename)
    })
}
pub unsafe fn last_dir_separator(
    arg_filename: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn last_dir_separator(
                arg_filename: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        last_dir_separator(arg_filename)
    })
}
pub unsafe fn first_path_var_separator(
    arg_pathlist: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn first_path_var_separator(
                arg_pathlist: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        first_path_var_separator(arg_pathlist)
    })
}
pub unsafe fn join_path_components(
    arg_ret_path: *mut ::std::os::raw::c_char,
    arg_head: *const ::std::os::raw::c_char,
    arg_tail: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn join_path_components(
                arg_ret_path: *mut ::std::os::raw::c_char,
                arg_head: *const ::std::os::raw::c_char,
                arg_tail: *const ::std::os::raw::c_char,
            );
        }
        join_path_components(arg_ret_path, arg_head, arg_tail)
    })
}
pub unsafe fn canonicalize_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn canonicalize_path(arg_path: *mut ::std::os::raw::c_char);
        }
        canonicalize_path(arg_path)
    })
}
pub unsafe fn make_native_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn make_native_path(arg_path: *mut ::std::os::raw::c_char);
        }
        make_native_path(arg_path)
    })
}
pub unsafe fn cleanup_path(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cleanup_path(arg_path: *mut ::std::os::raw::c_char);
        }
        cleanup_path(arg_path)
    })
}
pub unsafe fn path_contains_parent_reference(arg_path: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_contains_parent_reference(arg_path: *const ::std::os::raw::c_char) -> bool;
        }
        path_contains_parent_reference(arg_path)
    })
}
pub unsafe fn path_is_relative_and_below_cwd(arg_path: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_is_relative_and_below_cwd(arg_path: *const ::std::os::raw::c_char) -> bool;
        }
        path_is_relative_and_below_cwd(arg_path)
    })
}
pub unsafe fn path_is_prefix_of_path(
    arg_path1: *const ::std::os::raw::c_char,
    arg_path2: *const ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn path_is_prefix_of_path(
                arg_path1: *const ::std::os::raw::c_char,
                arg_path2: *const ::std::os::raw::c_char,
            ) -> bool;
        }
        path_is_prefix_of_path(arg_path1, arg_path2)
    })
}
pub unsafe fn make_absolute_path(
    arg_path: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn make_absolute_path(
                arg_path: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        make_absolute_path(arg_path)
    })
}
pub unsafe fn get_progname(
    arg_argv0: *const ::std::os::raw::c_char,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_progname(
                arg_argv0: *const ::std::os::raw::c_char,
            ) -> *const ::std::os::raw::c_char;
        }
        get_progname(arg_argv0)
    })
}
pub unsafe fn get_share_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_share_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_share_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_etc_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_etc_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_etc_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_include_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_include_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_include_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_pkginclude_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_pkginclude_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_pkginclude_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_includeserver_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_includeserver_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_includeserver_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_lib_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_lib_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_lib_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_pkglib_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_pkglib_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_pkglib_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_locale_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_locale_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_locale_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_doc_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_doc_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_doc_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_html_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_html_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_html_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_man_path(
    arg_my_exec_path: *const ::std::os::raw::c_char,
    arg_ret_path: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_man_path(
                arg_my_exec_path: *const ::std::os::raw::c_char,
                arg_ret_path: *mut ::std::os::raw::c_char,
            );
        }
        get_man_path(arg_my_exec_path, arg_ret_path)
    })
}
pub unsafe fn get_home_path(arg_ret_path: *mut ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_home_path(arg_ret_path: *mut ::std::os::raw::c_char) -> bool;
        }
        get_home_path(arg_ret_path)
    })
}
pub unsafe fn get_parent_directory(arg_path: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_parent_directory(arg_path: *mut ::std::os::raw::c_char);
        }
        get_parent_directory(arg_path)
    })
}
pub unsafe fn pgfnames(
    arg_path: *const ::std::os::raw::c_char,
) -> *mut *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgfnames(
                arg_path: *const ::std::os::raw::c_char,
            ) -> *mut *mut ::std::os::raw::c_char;
        }
        pgfnames(arg_path)
    })
}
pub unsafe fn pgfnames_cleanup(arg_filenames: *mut *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgfnames_cleanup(arg_filenames: *mut *mut ::std::os::raw::c_char);
        }
        pgfnames_cleanup(arg_filenames)
    })
}
pub unsafe fn set_pglocale_pgservice(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_app: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_pglocale_pgservice(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_app: *const ::std::os::raw::c_char,
            );
        }
        set_pglocale_pgservice(arg_argv0, arg_app)
    })
}
pub unsafe fn find_my_exec(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_retpath: *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_my_exec(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_retpath: *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        find_my_exec(arg_argv0, arg_retpath)
    })
}
pub unsafe fn find_other_exec(
    arg_argv0: *const ::std::os::raw::c_char,
    arg_target: *const ::std::os::raw::c_char,
    arg_versionstr: *const ::std::os::raw::c_char,
    arg_retpath: *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_other_exec(
                arg_argv0: *const ::std::os::raw::c_char,
                arg_target: *const ::std::os::raw::c_char,
                arg_versionstr: *const ::std::os::raw::c_char,
                arg_retpath: *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        find_other_exec(arg_argv0, arg_target, arg_versionstr, arg_retpath)
    })
}
pub unsafe fn pipe_read_line(
    arg_cmd: *mut ::std::os::raw::c_char,
    arg_line: *mut ::std::os::raw::c_char,
    arg_maxsize: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pipe_read_line(
                arg_cmd: *mut ::std::os::raw::c_char,
                arg_line: *mut ::std::os::raw::c_char,
                arg_maxsize: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        pipe_read_line(arg_cmd, arg_line, arg_maxsize)
    })
}
pub unsafe fn pg_usleep(arg_microsec: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_usleep(arg_microsec: ::std::os::raw::c_long);
        }
        pg_usleep(arg_microsec)
    })
}
pub unsafe fn pg_strcasecmp(
    arg_s1: *const ::std::os::raw::c_char,
    arg_s2: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strcasecmp(
                arg_s1: *const ::std::os::raw::c_char,
                arg_s2: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_strcasecmp(arg_s1, arg_s2)
    })
}
pub unsafe fn pg_strncasecmp(
    arg_s1: *const ::std::os::raw::c_char,
    arg_s2: *const ::std::os::raw::c_char,
    arg_n: usize,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strncasecmp(
                arg_s1: *const ::std::os::raw::c_char,
                arg_s2: *const ::std::os::raw::c_char,
                arg_n: usize,
            ) -> ::std::os::raw::c_int;
        }
        pg_strncasecmp(arg_s1, arg_s2, arg_n)
    })
}
pub unsafe fn pg_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_toupper(arg_ch)
    })
}
pub unsafe fn pg_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_tolower(arg_ch)
    })
}
pub unsafe fn pg_ascii_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_ascii_toupper(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_ascii_toupper(arg_ch)
    })
}
pub unsafe fn pg_ascii_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_ascii_tolower(arg_ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
        }
        pg_ascii_tolower(arg_ch)
    })
}
pub unsafe fn pg_snprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_count: usize,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_snprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_count: usize,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_snprintf(arg_str_, arg_count, arg_fmt)
    })
}
pub unsafe fn pg_sprintf(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_sprintf(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_sprintf(arg_str_, arg_fmt)
    })
}
pub unsafe fn pg_fprintf(
    arg_stream: *mut FILE,
    arg_fmt: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fprintf(
                arg_stream: *mut FILE,
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        pg_fprintf(arg_stream, arg_fmt)
    })
}
pub unsafe fn pg_printf(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_printf(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        pg_printf(arg_fmt)
    })
}
pub unsafe fn pg_strfromd(
    arg_str_: *mut ::std::os::raw::c_char,
    arg_count: usize,
    arg_precision: ::std::os::raw::c_int,
    arg_value: f64,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strfromd(
                arg_str_: *mut ::std::os::raw::c_char,
                arg_count: usize,
                arg_precision: ::std::os::raw::c_int,
                arg_value: f64,
            ) -> ::std::os::raw::c_int;
        }
        pg_strfromd(arg_str_, arg_count, arg_precision, arg_value)
    })
}
pub unsafe fn pg_strerror(arg_errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strerror(arg_errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
        }
        pg_strerror(arg_errnum)
    })
}
pub unsafe fn pg_strerror_r(
    arg_errnum: ::std::os::raw::c_int,
    arg_buf: *mut ::std::os::raw::c_char,
    arg_buflen: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strerror_r(
                arg_errnum: ::std::os::raw::c_int,
                arg_buf: *mut ::std::os::raw::c_char,
                arg_buflen: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        pg_strerror_r(arg_errnum, arg_buf, arg_buflen)
    })
}
pub unsafe fn pg_strsignal(arg_signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strsignal(arg_signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
        }
        pg_strsignal(arg_signum)
    })
}
pub unsafe fn simple_prompt(
    arg_prompt: *const ::std::os::raw::c_char,
    arg_destination: *mut ::std::os::raw::c_char,
    arg_destlen: usize,
    arg_echo: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn simple_prompt(
                arg_prompt: *const ::std::os::raw::c_char,
                arg_destination: *mut ::std::os::raw::c_char,
                arg_destlen: usize,
                arg_echo: bool,
            );
        }
        simple_prompt(arg_prompt, arg_destination, arg_destlen, arg_echo)
    })
}
pub unsafe fn pclose_check(arg_stream: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pclose_check(arg_stream: *mut FILE) -> ::std::os::raw::c_int;
        }
        pclose_check(arg_stream)
    })
}
pub unsafe fn rmtree(arg_path: *const ::std::os::raw::c_char, arg_rmtopdir: bool) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn rmtree(arg_path: *const ::std::os::raw::c_char, arg_rmtopdir: bool) -> bool;
        }
        rmtree(arg_path, arg_rmtopdir)
    })
}
pub unsafe fn pg_erand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> f64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_erand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> f64;
        }
        pg_erand48(arg_xseed)
    })
}
pub unsafe fn pg_lrand48() -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_lrand48() -> ::std::os::raw::c_long;
        }
        pg_lrand48()
    })
}
pub unsafe fn pg_jrand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_jrand48(arg_xseed: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
        }
        pg_jrand48(arg_xseed)
    })
}
pub unsafe fn pg_srand48(arg_seed: ::std::os::raw::c_long) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_srand48(arg_seed: ::std::os::raw::c_long);
        }
        pg_srand48(arg_seed)
    })
}
pub unsafe fn fls(arg_mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fls(arg_mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        fls(arg_mask)
    })
}
pub unsafe fn getpeereid(
    arg_sock: ::std::os::raw::c_int,
    arg_uid: *mut uid_t,
    arg_gid: *mut gid_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getpeereid(
                arg_sock: ::std::os::raw::c_int,
                arg_uid: *mut uid_t,
                arg_gid: *mut gid_t,
            ) -> ::std::os::raw::c_int;
        }
        getpeereid(arg_sock, arg_uid, arg_gid)
    })
}
pub unsafe fn strlcat(
    arg_dst: *mut ::std::os::raw::c_char,
    arg_src: *const ::std::os::raw::c_char,
    arg_siz: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strlcat(
                arg_dst: *mut ::std::os::raw::c_char,
                arg_src: *const ::std::os::raw::c_char,
                arg_siz: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_ulong;
        }
        strlcat(arg_dst, arg_src, arg_siz)
    })
}
pub unsafe fn strlcpy(
    arg_dst: *mut ::std::os::raw::c_char,
    arg_src: *const ::std::os::raw::c_char,
    arg_siz: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_ulong {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn strlcpy(
                arg_dst: *mut ::std::os::raw::c_char,
                arg_src: *const ::std::os::raw::c_char,
                arg_siz: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_ulong;
        }
        strlcpy(arg_dst, arg_src, arg_siz)
    })
}
pub unsafe fn pg_qsort(
    arg_base: *mut ::std::os::raw::c_void,
    arg_nel: usize,
    arg_elsize: usize,
    arg_cmp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_qsort(
                arg_base: *mut ::std::os::raw::c_void,
                arg_nel: usize,
                arg_elsize: usize,
                arg_cmp: ::std::option::Option<
                    unsafe extern "C" fn(
                        arg1: *const ::std::os::raw::c_void,
                        arg2: *const ::std::os::raw::c_void,
                    ) -> ::std::os::raw::c_int,
                >,
            );
        }
        pg_qsort(arg_base, arg_nel, arg_elsize, arg_cmp)
    })
}
pub unsafe fn pg_qsort_strcmp(
    arg_a: *const ::std::os::raw::c_void,
    arg_b: *const ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_qsort_strcmp(
                arg_a: *const ::std::os::raw::c_void,
                arg_b: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        pg_qsort_strcmp(arg_a, arg_b)
    })
}
pub type qsort_arg_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub unsafe fn qsort_arg(
    arg_base: *mut ::std::os::raw::c_void,
    arg_nel: usize,
    arg_elsize: usize,
    arg_cmp: qsort_arg_comparator,
    arg_arg: *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn qsort_arg(
                arg_base: *mut ::std::os::raw::c_void,
                arg_nel: usize,
                arg_elsize: usize,
                arg_cmp: qsort_arg_comparator,
                arg_arg: *mut ::std::os::raw::c_void,
            );
        }
        qsort_arg(arg_base, arg_nel, arg_elsize, arg_cmp, arg_arg)
    })
}
pub unsafe fn pg_get_encoding_from_locale(
    arg_ctype: *const ::std::os::raw::c_char,
    arg_write_message: bool,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_get_encoding_from_locale(
                arg_ctype: *const ::std::os::raw::c_char,
                arg_write_message: bool,
            ) -> ::std::os::raw::c_int;
        }
        pg_get_encoding_from_locale(arg_ctype, arg_write_message)
    })
}
pub unsafe fn pg_inet_net_ntop(
    arg_af: ::std::os::raw::c_int,
    arg_src: *const ::std::os::raw::c_void,
    arg_bits: ::std::os::raw::c_int,
    arg_dst: *mut ::std::os::raw::c_char,
    arg_size: usize,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_inet_net_ntop(
                arg_af: ::std::os::raw::c_int,
                arg_src: *const ::std::os::raw::c_void,
                arg_bits: ::std::os::raw::c_int,
                arg_dst: *mut ::std::os::raw::c_char,
                arg_size: usize,
            ) -> *mut ::std::os::raw::c_char;
        }
        pg_inet_net_ntop(arg_af, arg_src, arg_bits, arg_dst, arg_size)
    })
}
pub unsafe fn pg_strong_random(arg_buf: *mut ::std::os::raw::c_void, arg_len: usize) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strong_random(arg_buf: *mut ::std::os::raw::c_void, arg_len: usize) -> bool;
        }
        pg_strong_random(arg_buf, arg_len)
    })
}
pub unsafe fn pg_check_dir(arg_dir: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_check_dir(arg_dir: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        pg_check_dir(arg_dir)
    })
}
pub unsafe fn pg_mkdir_p(
    arg_path: *mut ::std::os::raw::c_char,
    arg_omode: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_mkdir_p(
                arg_path: *mut ::std::os::raw::c_char,
                arg_omode: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        pg_mkdir_p(arg_path, arg_omode)
    })
}
pub type pqsigfunc = ::std::option::Option<unsafe extern "C" fn(signo: ::std::os::raw::c_int)>;
pub unsafe fn pqsignal(arg_signo: ::std::os::raw::c_int, arg_func: pqsigfunc) -> pqsigfunc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pqsignal(arg_signo: ::std::os::raw::c_int, arg_func: pqsigfunc) -> pqsigfunc;
        }
        pqsignal(arg_signo, arg_func)
    })
}
pub unsafe fn escape_single_quotes_ascii(
    arg_src: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn escape_single_quotes_ascii(
                arg_src: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        escape_single_quotes_ascii(arg_src)
    })
}
pub unsafe fn wait_result_to_str(
    arg_exit_status: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_to_str(
                arg_exit_status: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        wait_result_to_str(arg_exit_status)
    })
}
pub unsafe fn wait_result_is_signal(
    arg_exit_status: ::std::os::raw::c_int,
    arg_signum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_is_signal(
                arg_exit_status: ::std::os::raw::c_int,
                arg_signum: ::std::os::raw::c_int,
            ) -> bool;
        }
        wait_result_is_signal(arg_exit_status, arg_signum)
    })
}
pub unsafe fn wait_result_is_any_signal(
    arg_exit_status: ::std::os::raw::c_int,
    arg_include_command_not_found: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn wait_result_is_any_signal(
                arg_exit_status: ::std::os::raw::c_int,
                arg_include_command_not_found: bool,
            ) -> bool;
        }
        wait_result_is_any_signal(arg_exit_status, arg_include_command_not_found)
    })
}
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
pub unsafe fn errstart(
    arg_elevel: ::std::os::raw::c_int,
    arg_domain: *const ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errstart(
                arg_elevel: ::std::os::raw::c_int,
                arg_domain: *const ::std::os::raw::c_char,
            ) -> bool;
        }
        errstart(arg_elevel, arg_domain)
    })
}
pub unsafe fn errfinish(
    arg_filename: *const ::std::os::raw::c_char,
    arg_lineno: ::std::os::raw::c_int,
    arg_funcname: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errfinish(
                arg_filename: *const ::std::os::raw::c_char,
                arg_lineno: ::std::os::raw::c_int,
                arg_funcname: *const ::std::os::raw::c_char,
            );
        }
        errfinish(arg_filename, arg_lineno, arg_funcname)
    })
}
pub unsafe fn errcode(arg_sqlerrcode: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode(arg_sqlerrcode: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        errcode(arg_sqlerrcode)
    })
}
pub unsafe fn errcode_for_file_access() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode_for_file_access() -> ::std::os::raw::c_int;
        }
        errcode_for_file_access()
    })
}
pub unsafe fn errcode_for_socket_access() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcode_for_socket_access() -> ::std::os::raw::c_int;
        }
        errcode_for_socket_access()
    })
}
pub unsafe fn errmsg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errmsg(arg_fmt)
    })
}
pub unsafe fn errmsg_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errmsg_internal(arg_fmt)
    })
}
pub unsafe fn errmsg_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errmsg_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errmsg_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errdetail(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail(arg_fmt)
    })
}
pub unsafe fn errdetail_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_internal(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail_internal(arg_fmt)
    })
}
pub unsafe fn errdetail_log(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_log(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errdetail_log(arg_fmt)
    })
}
pub unsafe fn errdetail_log_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_log_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errdetail_log_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errdetail_plural(
    arg_fmt_singular: *const ::std::os::raw::c_char,
    arg_fmt_plural: *const ::std::os::raw::c_char,
    arg_n: ::std::os::raw::c_ulong,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errdetail_plural(
                arg_fmt_singular: *const ::std::os::raw::c_char,
                arg_fmt_plural: *const ::std::os::raw::c_char,
                arg_n: ::std::os::raw::c_ulong,
            ) -> ::std::os::raw::c_int;
        }
        errdetail_plural(arg_fmt_singular, arg_fmt_plural, arg_n)
    })
}
pub unsafe fn errhint(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhint(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errhint(arg_fmt)
    })
}
pub unsafe fn set_errcontext_domain(
    arg_domain: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_errcontext_domain(
                arg_domain: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        set_errcontext_domain(arg_domain)
    })
}
pub unsafe fn errcontext_msg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errcontext_msg(arg_fmt: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errcontext_msg(arg_fmt)
    })
}
pub unsafe fn errhidestmt(arg_hide_stmt: bool) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhidestmt(arg_hide_stmt: bool) -> ::std::os::raw::c_int;
        }
        errhidestmt(arg_hide_stmt)
    })
}
pub unsafe fn errhidecontext(arg_hide_ctx: bool) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errhidecontext(arg_hide_ctx: bool) -> ::std::os::raw::c_int;
        }
        errhidecontext(arg_hide_ctx)
    })
}
pub unsafe fn errbacktrace() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errbacktrace() -> ::std::os::raw::c_int;
        }
        errbacktrace()
    })
}
pub unsafe fn errfunction(arg_funcname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errfunction(arg_funcname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        errfunction(arg_funcname)
    })
}
pub unsafe fn errposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        errposition(arg_cursorpos)
    })
}
pub unsafe fn internalerrposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn internalerrposition(arg_cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        internalerrposition(arg_cursorpos)
    })
}
pub unsafe fn internalerrquery(arg_query: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn internalerrquery(arg_query: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        internalerrquery(arg_query)
    })
}
pub unsafe fn err_generic_string(
    arg_field: ::std::os::raw::c_int,
    arg_str_: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn err_generic_string(
                arg_field: ::std::os::raw::c_int,
                arg_str_: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        err_generic_string(arg_field, arg_str_)
    })
}
pub unsafe fn geterrcode() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn geterrcode() -> ::std::os::raw::c_int;
        }
        geterrcode()
    })
}
pub unsafe fn geterrposition() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn geterrposition() -> ::std::os::raw::c_int;
        }
        geterrposition()
    })
}
pub unsafe fn getinternalerrposition() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getinternalerrposition() -> ::std::os::raw::c_int;
        }
        getinternalerrposition()
    })
}
pub unsafe fn pre_format_elog_string(
    arg_errnumber: ::std::os::raw::c_int,
    arg_domain: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pre_format_elog_string(
                arg_errnumber: ::std::os::raw::c_int,
                arg_domain: *const ::std::os::raw::c_char,
            );
        }
        pre_format_elog_string(arg_errnumber, arg_domain)
    })
}
pub unsafe fn format_elog_string(
    arg_fmt: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn format_elog_string(
                arg_fmt: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        format_elog_string(arg_fmt)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorContextCallback {
    pub previous: *mut ErrorContextCallback,
    pub callback: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
    pub arg: *mut ::std::os::raw::c_void,
}
impl Default for ErrorContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut error_context_stack: *mut ErrorContextCallback;
}
extern "C" {
    pub static mut PG_exception_stack: *mut sigjmp_buf;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorData {
    pub elevel: ::std::os::raw::c_int,
    pub output_to_server: bool,
    pub output_to_client: bool,
    pub show_funcname: bool,
    pub hide_stmt: bool,
    pub hide_ctx: bool,
    pub filename: *const ::std::os::raw::c_char,
    pub lineno: ::std::os::raw::c_int,
    pub funcname: *const ::std::os::raw::c_char,
    pub domain: *const ::std::os::raw::c_char,
    pub context_domain: *const ::std::os::raw::c_char,
    pub sqlerrcode: ::std::os::raw::c_int,
    pub message: *mut ::std::os::raw::c_char,
    pub detail: *mut ::std::os::raw::c_char,
    pub detail_log: *mut ::std::os::raw::c_char,
    pub hint: *mut ::std::os::raw::c_char,
    pub context: *mut ::std::os::raw::c_char,
    pub backtrace: *mut ::std::os::raw::c_char,
    pub message_id: *const ::std::os::raw::c_char,
    pub schema_name: *mut ::std::os::raw::c_char,
    pub table_name: *mut ::std::os::raw::c_char,
    pub column_name: *mut ::std::os::raw::c_char,
    pub datatype_name: *mut ::std::os::raw::c_char,
    pub constraint_name: *mut ::std::os::raw::c_char,
    pub cursorpos: ::std::os::raw::c_int,
    pub internalpos: ::std::os::raw::c_int,
    pub internalquery: *mut ::std::os::raw::c_char,
    pub saved_errno: ::std::os::raw::c_int,
    pub assoc_context: *mut MemoryContextData,
}
impl Default for ErrorData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn EmitErrorReport() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EmitErrorReport();
        }
        EmitErrorReport()
    })
}
pub unsafe fn CopyErrorData() -> *mut ErrorData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CopyErrorData() -> *mut ErrorData;
        }
        CopyErrorData()
    })
}
pub unsafe fn FreeErrorData(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeErrorData(arg_edata: *mut ErrorData);
        }
        FreeErrorData(arg_edata)
    })
}
pub unsafe fn FlushErrorState() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FlushErrorState();
        }
        FlushErrorState()
    })
}
pub unsafe fn ReThrowError(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReThrowError(arg_edata: *mut ErrorData);
        }
        ReThrowError(arg_edata)
    })
}
pub unsafe fn ThrowErrorData(arg_edata: *mut ErrorData) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ThrowErrorData(arg_edata: *mut ErrorData);
        }
        ThrowErrorData(arg_edata)
    })
}
pub unsafe fn GetErrorContextStack() -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetErrorContextStack() -> *mut ::std::os::raw::c_char;
        }
        GetErrorContextStack()
    })
}
pub type emit_log_hook_type = ::std::option::Option<unsafe extern "C" fn(edata: *mut ErrorData)>;
extern "C" {
    pub static mut emit_log_hook: emit_log_hook_type;
}
pub const PGErrorVerbosity_PGERROR_TERSE: PGErrorVerbosity = 0;
pub const PGErrorVerbosity_PGERROR_DEFAULT: PGErrorVerbosity = 1;
pub const PGErrorVerbosity_PGERROR_VERBOSE: PGErrorVerbosity = 2;
pub type PGErrorVerbosity = ::std::os::raw::c_uint;
extern "C" {
    pub static mut Log_error_verbosity: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut Log_line_prefix: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut Log_destination: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut Log_destination_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut syslog_sequence_numbers: bool;
}
extern "C" {
    pub static mut syslog_split_messages: bool;
}
pub unsafe fn DebugFileOpen() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DebugFileOpen();
        }
        DebugFileOpen()
    })
}
pub unsafe fn unpack_sql_state(
    arg_sql_state: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unpack_sql_state(
                arg_sql_state: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        unpack_sql_state(arg_sql_state)
    })
}
pub unsafe fn in_error_recursion_trouble() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn in_error_recursion_trouble() -> bool;
        }
        in_error_recursion_trouble()
    })
}
pub unsafe fn set_syslog_parameters(
    arg_ident: *const ::std::os::raw::c_char,
    arg_facility: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_syslog_parameters(
                arg_ident: *const ::std::os::raw::c_char,
                arg_facility: ::std::os::raw::c_int,
            );
        }
        set_syslog_parameters(arg_ident, arg_facility)
    })
}
pub unsafe fn write_stderr(arg_fmt: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn write_stderr(arg_fmt: *const ::std::os::raw::c_char);
        }
        write_stderr(arg_fmt)
    })
}
pub type MemoryContext = *mut MemoryContextData;
pub type MemoryContextCallbackFunction =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextCallback {
    pub func: MemoryContextCallbackFunction,
    pub arg: *mut ::std::os::raw::c_void,
    pub next: *mut MemoryContextCallback,
}
impl Default for MemoryContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut CurrentMemoryContext: MemoryContext;
}
pub unsafe fn MemoryContextAlloc(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAlloc(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAlloc(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocZero(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocZero(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocZero(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocZeroAligned(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocZeroAligned(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocZeroAligned(arg_context, arg_size)
    })
}
pub unsafe fn MemoryContextAllocExtended(
    arg_context: MemoryContext,
    arg_size: Size,
    arg_flags: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocExtended(
                arg_context: MemoryContext,
                arg_size: Size,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocExtended(arg_context, arg_size, arg_flags)
    })
}
pub unsafe fn palloc(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        palloc(arg_size)
    })
}
pub unsafe fn palloc0(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc0(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        palloc0(arg_size)
    })
}
pub unsafe fn palloc_extended(
    arg_size: Size,
    arg_flags: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn palloc_extended(
                arg_size: Size,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void;
        }
        palloc_extended(arg_size, arg_flags)
    })
}
pub unsafe fn repalloc(
    arg_pointer: *mut ::std::os::raw::c_void,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn repalloc(
                arg_pointer: *mut ::std::os::raw::c_void,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        repalloc(arg_pointer, arg_size)
    })
}
pub unsafe fn pfree(arg_pointer: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pfree(arg_pointer: *mut ::std::os::raw::c_void);
        }
        pfree(arg_pointer)
    })
}
pub unsafe fn MemoryContextAllocHuge(
    arg_context: MemoryContext,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllocHuge(
                arg_context: MemoryContext,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        MemoryContextAllocHuge(arg_context, arg_size)
    })
}
pub unsafe fn repalloc_huge(
    arg_pointer: *mut ::std::os::raw::c_void,
    arg_size: Size,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn repalloc_huge(
                arg_pointer: *mut ::std::os::raw::c_void,
                arg_size: Size,
            ) -> *mut ::std::os::raw::c_void;
        }
        repalloc_huge(arg_pointer, arg_size)
    })
}
pub unsafe fn MemoryContextRegisterResetCallback(
    arg_context: MemoryContext,
    arg_cb: *mut MemoryContextCallback,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextRegisterResetCallback(
                arg_context: MemoryContext,
                arg_cb: *mut MemoryContextCallback,
            );
        }
        MemoryContextRegisterResetCallback(arg_context, arg_cb)
    })
}
pub unsafe fn MemoryContextStrdup(
    arg_context: MemoryContext,
    arg_string: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextStrdup(
                arg_context: MemoryContext,
                arg_string: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        MemoryContextStrdup(arg_context, arg_string)
    })
}
pub unsafe fn pstrdup(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pstrdup(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        pstrdup(arg_in_)
    })
}
pub unsafe fn pnstrdup(
    arg_in_: *const ::std::os::raw::c_char,
    arg_len: Size,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pnstrdup(
                arg_in_: *const ::std::os::raw::c_char,
                arg_len: Size,
            ) -> *mut ::std::os::raw::c_char;
        }
        pnstrdup(arg_in_, arg_len)
    })
}
pub unsafe fn pchomp(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pchomp(arg_in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        pchomp(arg_in_)
    })
}
pub unsafe fn psprintf(arg_fmt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn psprintf(arg_fmt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
        }
        psprintf(arg_fmt)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct varatt_external {
    pub va_rawsize: int32,
    pub va_extsize: int32,
    pub va_valueid: Oid,
    pub va_toastrelid: Oid,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_indirect {
    pub pointer: *mut varlena,
}
impl Default for varatt_indirect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_expanded {
    pub eohptr: *mut ExpandedObjectHeader,
}
impl Default for varatt_expanded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const vartag_external_VARTAG_INDIRECT: vartag_external = 1;
pub const vartag_external_VARTAG_EXPANDED_RO: vartag_external = 2;
pub const vartag_external_VARTAG_EXPANDED_RW: vartag_external = 3;
pub const vartag_external_VARTAG_ONDISK: vartag_external = 18;
pub type vartag_external = ::std::os::raw::c_uint;
#[repr(C)]
pub struct varattrib_4b {
    pub va_4byte: __BindgenUnionField<varattrib_4b__bindgen_ty_1>,
    pub va_compressed: __BindgenUnionField<varattrib_4b__bindgen_ty_2>,
    pub bindgen_union_field: [u32; 2usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_1 {
    pub va_header: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_2 {
    pub va_header: uint32,
    pub va_rawsize: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for varattrib_4b {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b {
    pub va_header: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b_e {
    pub va_header: uint8,
    pub va_tag: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type AttrNumber = int16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_attribute {
    pub attrelid: Oid,
    pub attname: NameData,
    pub atttypid: Oid,
    pub attstattarget: int32,
    pub attlen: int16,
    pub attnum: int16,
    pub attndims: int32,
    pub attcacheoff: int32,
    pub atttypmod: int32,
    pub attbyval: bool,
    pub attstorage: ::std::os::raw::c_char,
    pub attalign: ::std::os::raw::c_char,
    pub attnotnull: bool,
    pub atthasdef: bool,
    pub atthasmissing: bool,
    pub attidentity: ::std::os::raw::c_char,
    pub attgenerated: ::std::os::raw::c_char,
    pub attisdropped: bool,
    pub attislocal: bool,
    pub attinhcount: int32,
    pub attcollation: Oid,
}
impl Default for FormData_pg_attribute {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_attribute = *mut FormData_pg_attribute;
pub const NodeTag_T_Invalid: NodeTag = 0;
pub const NodeTag_T_IndexInfo: NodeTag = 1;
pub const NodeTag_T_ExprContext: NodeTag = 2;
pub const NodeTag_T_ProjectionInfo: NodeTag = 3;
pub const NodeTag_T_JunkFilter: NodeTag = 4;
pub const NodeTag_T_OnConflictSetState: NodeTag = 5;
pub const NodeTag_T_ResultRelInfo: NodeTag = 6;
pub const NodeTag_T_EState: NodeTag = 7;
pub const NodeTag_T_TupleTableSlot: NodeTag = 8;
pub const NodeTag_T_Plan: NodeTag = 9;
pub const NodeTag_T_Result: NodeTag = 10;
pub const NodeTag_T_ProjectSet: NodeTag = 11;
pub const NodeTag_T_ModifyTable: NodeTag = 12;
pub const NodeTag_T_Append: NodeTag = 13;
pub const NodeTag_T_MergeAppend: NodeTag = 14;
pub const NodeTag_T_RecursiveUnion: NodeTag = 15;
pub const NodeTag_T_BitmapAnd: NodeTag = 16;
pub const NodeTag_T_BitmapOr: NodeTag = 17;
pub const NodeTag_T_Scan: NodeTag = 18;
pub const NodeTag_T_SeqScan: NodeTag = 19;
pub const NodeTag_T_SampleScan: NodeTag = 20;
pub const NodeTag_T_IndexScan: NodeTag = 21;
pub const NodeTag_T_IndexOnlyScan: NodeTag = 22;
pub const NodeTag_T_BitmapIndexScan: NodeTag = 23;
pub const NodeTag_T_BitmapHeapScan: NodeTag = 24;
pub const NodeTag_T_TidScan: NodeTag = 25;
pub const NodeTag_T_SubqueryScan: NodeTag = 26;
pub const NodeTag_T_FunctionScan: NodeTag = 27;
pub const NodeTag_T_ValuesScan: NodeTag = 28;
pub const NodeTag_T_TableFuncScan: NodeTag = 29;
pub const NodeTag_T_CteScan: NodeTag = 30;
pub const NodeTag_T_NamedTuplestoreScan: NodeTag = 31;
pub const NodeTag_T_WorkTableScan: NodeTag = 32;
pub const NodeTag_T_ForeignScan: NodeTag = 33;
pub const NodeTag_T_CustomScan: NodeTag = 34;
pub const NodeTag_T_Join: NodeTag = 35;
pub const NodeTag_T_NestLoop: NodeTag = 36;
pub const NodeTag_T_MergeJoin: NodeTag = 37;
pub const NodeTag_T_HashJoin: NodeTag = 38;
pub const NodeTag_T_Material: NodeTag = 39;
pub const NodeTag_T_Sort: NodeTag = 40;
pub const NodeTag_T_IncrementalSort: NodeTag = 41;
pub const NodeTag_T_Group: NodeTag = 42;
pub const NodeTag_T_Agg: NodeTag = 43;
pub const NodeTag_T_WindowAgg: NodeTag = 44;
pub const NodeTag_T_Unique: NodeTag = 45;
pub const NodeTag_T_Gather: NodeTag = 46;
pub const NodeTag_T_GatherMerge: NodeTag = 47;
pub const NodeTag_T_Hash: NodeTag = 48;
pub const NodeTag_T_SetOp: NodeTag = 49;
pub const NodeTag_T_LockRows: NodeTag = 50;
pub const NodeTag_T_Limit: NodeTag = 51;
pub const NodeTag_T_NestLoopParam: NodeTag = 52;
pub const NodeTag_T_PlanRowMark: NodeTag = 53;
pub const NodeTag_T_PartitionPruneInfo: NodeTag = 54;
pub const NodeTag_T_PartitionedRelPruneInfo: NodeTag = 55;
pub const NodeTag_T_PartitionPruneStepOp: NodeTag = 56;
pub const NodeTag_T_PartitionPruneStepCombine: NodeTag = 57;
pub const NodeTag_T_PlanInvalItem: NodeTag = 58;
pub const NodeTag_T_PlanState: NodeTag = 59;
pub const NodeTag_T_ResultState: NodeTag = 60;
pub const NodeTag_T_ProjectSetState: NodeTag = 61;
pub const NodeTag_T_ModifyTableState: NodeTag = 62;
pub const NodeTag_T_AppendState: NodeTag = 63;
pub const NodeTag_T_MergeAppendState: NodeTag = 64;
pub const NodeTag_T_RecursiveUnionState: NodeTag = 65;
pub const NodeTag_T_BitmapAndState: NodeTag = 66;
pub const NodeTag_T_BitmapOrState: NodeTag = 67;
pub const NodeTag_T_ScanState: NodeTag = 68;
pub const NodeTag_T_SeqScanState: NodeTag = 69;
pub const NodeTag_T_SampleScanState: NodeTag = 70;
pub const NodeTag_T_IndexScanState: NodeTag = 71;
pub const NodeTag_T_IndexOnlyScanState: NodeTag = 72;
pub const NodeTag_T_BitmapIndexScanState: NodeTag = 73;
pub const NodeTag_T_BitmapHeapScanState: NodeTag = 74;
pub const NodeTag_T_TidScanState: NodeTag = 75;
pub const NodeTag_T_SubqueryScanState: NodeTag = 76;
pub const NodeTag_T_FunctionScanState: NodeTag = 77;
pub const NodeTag_T_TableFuncScanState: NodeTag = 78;
pub const NodeTag_T_ValuesScanState: NodeTag = 79;
pub const NodeTag_T_CteScanState: NodeTag = 80;
pub const NodeTag_T_NamedTuplestoreScanState: NodeTag = 81;
pub const NodeTag_T_WorkTableScanState: NodeTag = 82;
pub const NodeTag_T_ForeignScanState: NodeTag = 83;
pub const NodeTag_T_CustomScanState: NodeTag = 84;
pub const NodeTag_T_JoinState: NodeTag = 85;
pub const NodeTag_T_NestLoopState: NodeTag = 86;
pub const NodeTag_T_MergeJoinState: NodeTag = 87;
pub const NodeTag_T_HashJoinState: NodeTag = 88;
pub const NodeTag_T_MaterialState: NodeTag = 89;
pub const NodeTag_T_SortState: NodeTag = 90;
pub const NodeTag_T_IncrementalSortState: NodeTag = 91;
pub const NodeTag_T_GroupState: NodeTag = 92;
pub const NodeTag_T_AggState: NodeTag = 93;
pub const NodeTag_T_WindowAggState: NodeTag = 94;
pub const NodeTag_T_UniqueState: NodeTag = 95;
pub const NodeTag_T_GatherState: NodeTag = 96;
pub const NodeTag_T_GatherMergeState: NodeTag = 97;
pub const NodeTag_T_HashState: NodeTag = 98;
pub const NodeTag_T_SetOpState: NodeTag = 99;
pub const NodeTag_T_LockRowsState: NodeTag = 100;
pub const NodeTag_T_LimitState: NodeTag = 101;
pub const NodeTag_T_Alias: NodeTag = 102;
pub const NodeTag_T_RangeVar: NodeTag = 103;
pub const NodeTag_T_TableFunc: NodeTag = 104;
pub const NodeTag_T_Expr: NodeTag = 105;
pub const NodeTag_T_Var: NodeTag = 106;
pub const NodeTag_T_Const: NodeTag = 107;
pub const NodeTag_T_Param: NodeTag = 108;
pub const NodeTag_T_Aggref: NodeTag = 109;
pub const NodeTag_T_GroupingFunc: NodeTag = 110;
pub const NodeTag_T_WindowFunc: NodeTag = 111;
pub const NodeTag_T_SubscriptingRef: NodeTag = 112;
pub const NodeTag_T_FuncExpr: NodeTag = 113;
pub const NodeTag_T_NamedArgExpr: NodeTag = 114;
pub const NodeTag_T_OpExpr: NodeTag = 115;
pub const NodeTag_T_DistinctExpr: NodeTag = 116;
pub const NodeTag_T_NullIfExpr: NodeTag = 117;
pub const NodeTag_T_ScalarArrayOpExpr: NodeTag = 118;
pub const NodeTag_T_BoolExpr: NodeTag = 119;
pub const NodeTag_T_SubLink: NodeTag = 120;
pub const NodeTag_T_SubPlan: NodeTag = 121;
pub const NodeTag_T_AlternativeSubPlan: NodeTag = 122;
pub const NodeTag_T_FieldSelect: NodeTag = 123;
pub const NodeTag_T_FieldStore: NodeTag = 124;
pub const NodeTag_T_RelabelType: NodeTag = 125;
pub const NodeTag_T_CoerceViaIO: NodeTag = 126;
pub const NodeTag_T_ArrayCoerceExpr: NodeTag = 127;
pub const NodeTag_T_ConvertRowtypeExpr: NodeTag = 128;
pub const NodeTag_T_CollateExpr: NodeTag = 129;
pub const NodeTag_T_CaseExpr: NodeTag = 130;
pub const NodeTag_T_CaseWhen: NodeTag = 131;
pub const NodeTag_T_CaseTestExpr: NodeTag = 132;
pub const NodeTag_T_ArrayExpr: NodeTag = 133;
pub const NodeTag_T_RowExpr: NodeTag = 134;
pub const NodeTag_T_RowCompareExpr: NodeTag = 135;
pub const NodeTag_T_CoalesceExpr: NodeTag = 136;
pub const NodeTag_T_MinMaxExpr: NodeTag = 137;
pub const NodeTag_T_SQLValueFunction: NodeTag = 138;
pub const NodeTag_T_XmlExpr: NodeTag = 139;
pub const NodeTag_T_NullTest: NodeTag = 140;
pub const NodeTag_T_BooleanTest: NodeTag = 141;
pub const NodeTag_T_CoerceToDomain: NodeTag = 142;
pub const NodeTag_T_CoerceToDomainValue: NodeTag = 143;
pub const NodeTag_T_SetToDefault: NodeTag = 144;
pub const NodeTag_T_CurrentOfExpr: NodeTag = 145;
pub const NodeTag_T_NextValueExpr: NodeTag = 146;
pub const NodeTag_T_InferenceElem: NodeTag = 147;
pub const NodeTag_T_TargetEntry: NodeTag = 148;
pub const NodeTag_T_RangeTblRef: NodeTag = 149;
pub const NodeTag_T_JoinExpr: NodeTag = 150;
pub const NodeTag_T_FromExpr: NodeTag = 151;
pub const NodeTag_T_OnConflictExpr: NodeTag = 152;
pub const NodeTag_T_IntoClause: NodeTag = 153;
pub const NodeTag_T_ExprState: NodeTag = 154;
pub const NodeTag_T_AggrefExprState: NodeTag = 155;
pub const NodeTag_T_WindowFuncExprState: NodeTag = 156;
pub const NodeTag_T_SetExprState: NodeTag = 157;
pub const NodeTag_T_SubPlanState: NodeTag = 158;
pub const NodeTag_T_AlternativeSubPlanState: NodeTag = 159;
pub const NodeTag_T_DomainConstraintState: NodeTag = 160;
pub const NodeTag_T_PlannerInfo: NodeTag = 161;
pub const NodeTag_T_PlannerGlobal: NodeTag = 162;
pub const NodeTag_T_RelOptInfo: NodeTag = 163;
pub const NodeTag_T_IndexOptInfo: NodeTag = 164;
pub const NodeTag_T_ForeignKeyOptInfo: NodeTag = 165;
pub const NodeTag_T_ParamPathInfo: NodeTag = 166;
pub const NodeTag_T_Path: NodeTag = 167;
pub const NodeTag_T_IndexPath: NodeTag = 168;
pub const NodeTag_T_BitmapHeapPath: NodeTag = 169;
pub const NodeTag_T_BitmapAndPath: NodeTag = 170;
pub const NodeTag_T_BitmapOrPath: NodeTag = 171;
pub const NodeTag_T_TidPath: NodeTag = 172;
pub const NodeTag_T_SubqueryScanPath: NodeTag = 173;
pub const NodeTag_T_ForeignPath: NodeTag = 174;
pub const NodeTag_T_CustomPath: NodeTag = 175;
pub const NodeTag_T_NestPath: NodeTag = 176;
pub const NodeTag_T_MergePath: NodeTag = 177;
pub const NodeTag_T_HashPath: NodeTag = 178;
pub const NodeTag_T_AppendPath: NodeTag = 179;
pub const NodeTag_T_MergeAppendPath: NodeTag = 180;
pub const NodeTag_T_GroupResultPath: NodeTag = 181;
pub const NodeTag_T_MaterialPath: NodeTag = 182;
pub const NodeTag_T_UniquePath: NodeTag = 183;
pub const NodeTag_T_GatherPath: NodeTag = 184;
pub const NodeTag_T_GatherMergePath: NodeTag = 185;
pub const NodeTag_T_ProjectionPath: NodeTag = 186;
pub const NodeTag_T_ProjectSetPath: NodeTag = 187;
pub const NodeTag_T_SortPath: NodeTag = 188;
pub const NodeTag_T_IncrementalSortPath: NodeTag = 189;
pub const NodeTag_T_GroupPath: NodeTag = 190;
pub const NodeTag_T_UpperUniquePath: NodeTag = 191;
pub const NodeTag_T_AggPath: NodeTag = 192;
pub const NodeTag_T_GroupingSetsPath: NodeTag = 193;
pub const NodeTag_T_MinMaxAggPath: NodeTag = 194;
pub const NodeTag_T_WindowAggPath: NodeTag = 195;
pub const NodeTag_T_SetOpPath: NodeTag = 196;
pub const NodeTag_T_RecursiveUnionPath: NodeTag = 197;
pub const NodeTag_T_LockRowsPath: NodeTag = 198;
pub const NodeTag_T_ModifyTablePath: NodeTag = 199;
pub const NodeTag_T_LimitPath: NodeTag = 200;
pub const NodeTag_T_EquivalenceClass: NodeTag = 201;
pub const NodeTag_T_EquivalenceMember: NodeTag = 202;
pub const NodeTag_T_PathKey: NodeTag = 203;
pub const NodeTag_T_PathTarget: NodeTag = 204;
pub const NodeTag_T_RestrictInfo: NodeTag = 205;
pub const NodeTag_T_IndexClause: NodeTag = 206;
pub const NodeTag_T_PlaceHolderVar: NodeTag = 207;
pub const NodeTag_T_SpecialJoinInfo: NodeTag = 208;
pub const NodeTag_T_AppendRelInfo: NodeTag = 209;
pub const NodeTag_T_PlaceHolderInfo: NodeTag = 210;
pub const NodeTag_T_MinMaxAggInfo: NodeTag = 211;
pub const NodeTag_T_PlannerParamItem: NodeTag = 212;
pub const NodeTag_T_RollupData: NodeTag = 213;
pub const NodeTag_T_GroupingSetData: NodeTag = 214;
pub const NodeTag_T_StatisticExtInfo: NodeTag = 215;
pub const NodeTag_T_MemoryContext: NodeTag = 216;
pub const NodeTag_T_AllocSetContext: NodeTag = 217;
pub const NodeTag_T_SlabContext: NodeTag = 218;
pub const NodeTag_T_GenerationContext: NodeTag = 219;
pub const NodeTag_T_Value: NodeTag = 220;
pub const NodeTag_T_Integer: NodeTag = 221;
pub const NodeTag_T_Float: NodeTag = 222;
pub const NodeTag_T_String: NodeTag = 223;
pub const NodeTag_T_BitString: NodeTag = 224;
pub const NodeTag_T_Null: NodeTag = 225;
pub const NodeTag_T_List: NodeTag = 226;
pub const NodeTag_T_IntList: NodeTag = 227;
pub const NodeTag_T_OidList: NodeTag = 228;
pub const NodeTag_T_ExtensibleNode: NodeTag = 229;
pub const NodeTag_T_RawStmt: NodeTag = 230;
pub const NodeTag_T_Query: NodeTag = 231;
pub const NodeTag_T_PlannedStmt: NodeTag = 232;
pub const NodeTag_T_InsertStmt: NodeTag = 233;
pub const NodeTag_T_DeleteStmt: NodeTag = 234;
pub const NodeTag_T_UpdateStmt: NodeTag = 235;
pub const NodeTag_T_SelectStmt: NodeTag = 236;
pub const NodeTag_T_AlterTableStmt: NodeTag = 237;
pub const NodeTag_T_AlterTableCmd: NodeTag = 238;
pub const NodeTag_T_AlterDomainStmt: NodeTag = 239;
pub const NodeTag_T_SetOperationStmt: NodeTag = 240;
pub const NodeTag_T_GrantStmt: NodeTag = 241;
pub const NodeTag_T_GrantRoleStmt: NodeTag = 242;
pub const NodeTag_T_AlterDefaultPrivilegesStmt: NodeTag = 243;
pub const NodeTag_T_ClosePortalStmt: NodeTag = 244;
pub const NodeTag_T_ClusterStmt: NodeTag = 245;
pub const NodeTag_T_CopyStmt: NodeTag = 246;
pub const NodeTag_T_CreateStmt: NodeTag = 247;
pub const NodeTag_T_DefineStmt: NodeTag = 248;
pub const NodeTag_T_DropStmt: NodeTag = 249;
pub const NodeTag_T_TruncateStmt: NodeTag = 250;
pub const NodeTag_T_CommentStmt: NodeTag = 251;
pub const NodeTag_T_FetchStmt: NodeTag = 252;
pub const NodeTag_T_IndexStmt: NodeTag = 253;
pub const NodeTag_T_CreateFunctionStmt: NodeTag = 254;
pub const NodeTag_T_AlterFunctionStmt: NodeTag = 255;
pub const NodeTag_T_DoStmt: NodeTag = 256;
pub const NodeTag_T_RenameStmt: NodeTag = 257;
pub const NodeTag_T_RuleStmt: NodeTag = 258;
pub const NodeTag_T_NotifyStmt: NodeTag = 259;
pub const NodeTag_T_ListenStmt: NodeTag = 260;
pub const NodeTag_T_UnlistenStmt: NodeTag = 261;
pub const NodeTag_T_TransactionStmt: NodeTag = 262;
pub const NodeTag_T_ViewStmt: NodeTag = 263;
pub const NodeTag_T_LoadStmt: NodeTag = 264;
pub const NodeTag_T_CreateDomainStmt: NodeTag = 265;
pub const NodeTag_T_CreatedbStmt: NodeTag = 266;
pub const NodeTag_T_DropdbStmt: NodeTag = 267;
pub const NodeTag_T_VacuumStmt: NodeTag = 268;
pub const NodeTag_T_ExplainStmt: NodeTag = 269;
pub const NodeTag_T_CreateTableAsStmt: NodeTag = 270;
pub const NodeTag_T_CreateSeqStmt: NodeTag = 271;
pub const NodeTag_T_AlterSeqStmt: NodeTag = 272;
pub const NodeTag_T_VariableSetStmt: NodeTag = 273;
pub const NodeTag_T_VariableShowStmt: NodeTag = 274;
pub const NodeTag_T_DiscardStmt: NodeTag = 275;
pub const NodeTag_T_CreateTrigStmt: NodeTag = 276;
pub const NodeTag_T_CreatePLangStmt: NodeTag = 277;
pub const NodeTag_T_CreateRoleStmt: NodeTag = 278;
pub const NodeTag_T_AlterRoleStmt: NodeTag = 279;
pub const NodeTag_T_DropRoleStmt: NodeTag = 280;
pub const NodeTag_T_LockStmt: NodeTag = 281;
pub const NodeTag_T_ConstraintsSetStmt: NodeTag = 282;
pub const NodeTag_T_ReindexStmt: NodeTag = 283;
pub const NodeTag_T_CheckPointStmt: NodeTag = 284;
pub const NodeTag_T_CreateSchemaStmt: NodeTag = 285;
pub const NodeTag_T_AlterDatabaseStmt: NodeTag = 286;
pub const NodeTag_T_AlterDatabaseSetStmt: NodeTag = 287;
pub const NodeTag_T_AlterRoleSetStmt: NodeTag = 288;
pub const NodeTag_T_CreateConversionStmt: NodeTag = 289;
pub const NodeTag_T_CreateCastStmt: NodeTag = 290;
pub const NodeTag_T_CreateOpClassStmt: NodeTag = 291;
pub const NodeTag_T_CreateOpFamilyStmt: NodeTag = 292;
pub const NodeTag_T_AlterOpFamilyStmt: NodeTag = 293;
pub const NodeTag_T_PrepareStmt: NodeTag = 294;
pub const NodeTag_T_ExecuteStmt: NodeTag = 295;
pub const NodeTag_T_DeallocateStmt: NodeTag = 296;
pub const NodeTag_T_DeclareCursorStmt: NodeTag = 297;
pub const NodeTag_T_CreateTableSpaceStmt: NodeTag = 298;
pub const NodeTag_T_DropTableSpaceStmt: NodeTag = 299;
pub const NodeTag_T_AlterObjectDependsStmt: NodeTag = 300;
pub const NodeTag_T_AlterObjectSchemaStmt: NodeTag = 301;
pub const NodeTag_T_AlterOwnerStmt: NodeTag = 302;
pub const NodeTag_T_AlterOperatorStmt: NodeTag = 303;
pub const NodeTag_T_AlterTypeStmt: NodeTag = 304;
pub const NodeTag_T_DropOwnedStmt: NodeTag = 305;
pub const NodeTag_T_ReassignOwnedStmt: NodeTag = 306;
pub const NodeTag_T_CompositeTypeStmt: NodeTag = 307;
pub const NodeTag_T_CreateEnumStmt: NodeTag = 308;
pub const NodeTag_T_CreateRangeStmt: NodeTag = 309;
pub const NodeTag_T_AlterEnumStmt: NodeTag = 310;
pub const NodeTag_T_AlterTSDictionaryStmt: NodeTag = 311;
pub const NodeTag_T_AlterTSConfigurationStmt: NodeTag = 312;
pub const NodeTag_T_CreateFdwStmt: NodeTag = 313;
pub const NodeTag_T_AlterFdwStmt: NodeTag = 314;
pub const NodeTag_T_CreateForeignServerStmt: NodeTag = 315;
pub const NodeTag_T_AlterForeignServerStmt: NodeTag = 316;
pub const NodeTag_T_CreateUserMappingStmt: NodeTag = 317;
pub const NodeTag_T_AlterUserMappingStmt: NodeTag = 318;
pub const NodeTag_T_DropUserMappingStmt: NodeTag = 319;
pub const NodeTag_T_AlterTableSpaceOptionsStmt: NodeTag = 320;
pub const NodeTag_T_AlterTableMoveAllStmt: NodeTag = 321;
pub const NodeTag_T_SecLabelStmt: NodeTag = 322;
pub const NodeTag_T_CreateForeignTableStmt: NodeTag = 323;
pub const NodeTag_T_ImportForeignSchemaStmt: NodeTag = 324;
pub const NodeTag_T_CreateExtensionStmt: NodeTag = 325;
pub const NodeTag_T_AlterExtensionStmt: NodeTag = 326;
pub const NodeTag_T_AlterExtensionContentsStmt: NodeTag = 327;
pub const NodeTag_T_CreateEventTrigStmt: NodeTag = 328;
pub const NodeTag_T_AlterEventTrigStmt: NodeTag = 329;
pub const NodeTag_T_RefreshMatViewStmt: NodeTag = 330;
pub const NodeTag_T_ReplicaIdentityStmt: NodeTag = 331;
pub const NodeTag_T_AlterSystemStmt: NodeTag = 332;
pub const NodeTag_T_CreatePolicyStmt: NodeTag = 333;
pub const NodeTag_T_AlterPolicyStmt: NodeTag = 334;
pub const NodeTag_T_CreateTransformStmt: NodeTag = 335;
pub const NodeTag_T_CreateAmStmt: NodeTag = 336;
pub const NodeTag_T_CreatePublicationStmt: NodeTag = 337;
pub const NodeTag_T_AlterPublicationStmt: NodeTag = 338;
pub const NodeTag_T_CreateSubscriptionStmt: NodeTag = 339;
pub const NodeTag_T_AlterSubscriptionStmt: NodeTag = 340;
pub const NodeTag_T_DropSubscriptionStmt: NodeTag = 341;
pub const NodeTag_T_CreateStatsStmt: NodeTag = 342;
pub const NodeTag_T_AlterCollationStmt: NodeTag = 343;
pub const NodeTag_T_CallStmt: NodeTag = 344;
pub const NodeTag_T_AlterStatsStmt: NodeTag = 345;
pub const NodeTag_T_A_Expr: NodeTag = 346;
pub const NodeTag_T_ColumnRef: NodeTag = 347;
pub const NodeTag_T_ParamRef: NodeTag = 348;
pub const NodeTag_T_A_Const: NodeTag = 349;
pub const NodeTag_T_FuncCall: NodeTag = 350;
pub const NodeTag_T_A_Star: NodeTag = 351;
pub const NodeTag_T_A_Indices: NodeTag = 352;
pub const NodeTag_T_A_Indirection: NodeTag = 353;
pub const NodeTag_T_A_ArrayExpr: NodeTag = 354;
pub const NodeTag_T_ResTarget: NodeTag = 355;
pub const NodeTag_T_MultiAssignRef: NodeTag = 356;
pub const NodeTag_T_TypeCast: NodeTag = 357;
pub const NodeTag_T_CollateClause: NodeTag = 358;
pub const NodeTag_T_SortBy: NodeTag = 359;
pub const NodeTag_T_WindowDef: NodeTag = 360;
pub const NodeTag_T_RangeSubselect: NodeTag = 361;
pub const NodeTag_T_RangeFunction: NodeTag = 362;
pub const NodeTag_T_RangeTableSample: NodeTag = 363;
pub const NodeTag_T_RangeTableFunc: NodeTag = 364;
pub const NodeTag_T_RangeTableFuncCol: NodeTag = 365;
pub const NodeTag_T_TypeName: NodeTag = 366;
pub const NodeTag_T_ColumnDef: NodeTag = 367;
pub const NodeTag_T_IndexElem: NodeTag = 368;
pub const NodeTag_T_Constraint: NodeTag = 369;
pub const NodeTag_T_DefElem: NodeTag = 370;
pub const NodeTag_T_RangeTblEntry: NodeTag = 371;
pub const NodeTag_T_RangeTblFunction: NodeTag = 372;
pub const NodeTag_T_TableSampleClause: NodeTag = 373;
pub const NodeTag_T_WithCheckOption: NodeTag = 374;
pub const NodeTag_T_SortGroupClause: NodeTag = 375;
pub const NodeTag_T_GroupingSet: NodeTag = 376;
pub const NodeTag_T_WindowClause: NodeTag = 377;
pub const NodeTag_T_ObjectWithArgs: NodeTag = 378;
pub const NodeTag_T_AccessPriv: NodeTag = 379;
pub const NodeTag_T_CreateOpClassItem: NodeTag = 380;
pub const NodeTag_T_TableLikeClause: NodeTag = 381;
pub const NodeTag_T_FunctionParameter: NodeTag = 382;
pub const NodeTag_T_LockingClause: NodeTag = 383;
pub const NodeTag_T_RowMarkClause: NodeTag = 384;
pub const NodeTag_T_XmlSerialize: NodeTag = 385;
pub const NodeTag_T_WithClause: NodeTag = 386;
pub const NodeTag_T_InferClause: NodeTag = 387;
pub const NodeTag_T_OnConflictClause: NodeTag = 388;
pub const NodeTag_T_CommonTableExpr: NodeTag = 389;
pub const NodeTag_T_RoleSpec: NodeTag = 390;
pub const NodeTag_T_TriggerTransition: NodeTag = 391;
pub const NodeTag_T_PartitionElem: NodeTag = 392;
pub const NodeTag_T_PartitionSpec: NodeTag = 393;
pub const NodeTag_T_PartitionBoundSpec: NodeTag = 394;
pub const NodeTag_T_PartitionRangeDatum: NodeTag = 395;
pub const NodeTag_T_PartitionCmd: NodeTag = 396;
pub const NodeTag_T_VacuumRelation: NodeTag = 397;
pub const NodeTag_T_IdentifySystemCmd: NodeTag = 398;
pub const NodeTag_T_BaseBackupCmd: NodeTag = 399;
pub const NodeTag_T_CreateReplicationSlotCmd: NodeTag = 400;
pub const NodeTag_T_DropReplicationSlotCmd: NodeTag = 401;
pub const NodeTag_T_StartReplicationCmd: NodeTag = 402;
pub const NodeTag_T_TimeLineHistoryCmd: NodeTag = 403;
pub const NodeTag_T_SQLCmd: NodeTag = 404;
pub const NodeTag_T_TriggerData: NodeTag = 405;
pub const NodeTag_T_EventTriggerData: NodeTag = 406;
pub const NodeTag_T_ReturnSetInfo: NodeTag = 407;
pub const NodeTag_T_WindowObjectData: NodeTag = 408;
pub const NodeTag_T_TIDBitmap: NodeTag = 409;
pub const NodeTag_T_InlineCodeBlock: NodeTag = 410;
pub const NodeTag_T_FdwRoutine: NodeTag = 411;
pub const NodeTag_T_IndexAmRoutine: NodeTag = 412;
pub const NodeTag_T_TableAmRoutine: NodeTag = 413;
pub const NodeTag_T_TsmRoutine: NodeTag = 414;
pub const NodeTag_T_ForeignKeyCacheInfo: NodeTag = 415;
pub const NodeTag_T_CallContext: NodeTag = 416;
pub const NodeTag_T_SupportRequestSimplify: NodeTag = 417;
pub const NodeTag_T_SupportRequestSelectivity: NodeTag = 418;
pub const NodeTag_T_SupportRequestCost: NodeTag = 419;
pub const NodeTag_T_SupportRequestRows: NodeTag = 420;
pub const NodeTag_T_SupportRequestIndexCondition: NodeTag = 421;
pub type NodeTag = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Node {
    pub type_: NodeTag,
}
impl Default for Node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn outNode(arg_str_: *mut StringInfoData, arg_obj: *const ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outNode(arg_str_: *mut StringInfoData, arg_obj: *const ::std::os::raw::c_void);
        }
        outNode(arg_str_, arg_obj)
    })
}
pub unsafe fn outToken(arg_str_: *mut StringInfoData, arg_s: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outToken(arg_str_: *mut StringInfoData, arg_s: *const ::std::os::raw::c_char);
        }
        outToken(arg_str_, arg_s)
    })
}
pub unsafe fn outBitmapset(arg_str_: *mut StringInfoData, arg_bms: *const Bitmapset) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outBitmapset(arg_str_: *mut StringInfoData, arg_bms: *const Bitmapset);
        }
        outBitmapset(arg_str_, arg_bms)
    })
}
pub unsafe fn outDatum(
    arg_str_: *mut StringInfoData,
    arg_value: usize,
    arg_typlen: ::std::os::raw::c_int,
    arg_typbyval: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn outDatum(
                arg_str_: *mut StringInfoData,
                arg_value: usize,
                arg_typlen: ::std::os::raw::c_int,
                arg_typbyval: bool,
            );
        }
        outDatum(arg_str_, arg_value, arg_typlen, arg_typbyval)
    })
}
pub unsafe fn nodeToString(arg_obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nodeToString(arg_obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char;
        }
        nodeToString(arg_obj)
    })
}
pub unsafe fn bmsToString(arg_bms: *const Bitmapset) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bmsToString(arg_bms: *const Bitmapset) -> *mut ::std::os::raw::c_char;
        }
        bmsToString(arg_bms)
    })
}
pub unsafe fn stringToNode(arg_str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn stringToNode(arg_str_: *const ::std::os::raw::c_char)
                -> *mut ::std::os::raw::c_void;
        }
        stringToNode(arg_str_)
    })
}
pub unsafe fn readBitmapset() -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readBitmapset() -> *mut Bitmapset;
        }
        readBitmapset()
    })
}
pub unsafe fn readDatum(arg_typbyval: bool) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readDatum(arg_typbyval: bool) -> usize;
        }
        readDatum(arg_typbyval)
    })
}
pub unsafe fn readBoolCols(arg_numCols: ::std::os::raw::c_int) -> *mut bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readBoolCols(arg_numCols: ::std::os::raw::c_int) -> *mut bool;
        }
        readBoolCols(arg_numCols)
    })
}
pub unsafe fn readIntCols(arg_numCols: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readIntCols(arg_numCols: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_int;
        }
        readIntCols(arg_numCols)
    })
}
pub unsafe fn readOidCols(arg_numCols: ::std::os::raw::c_int) -> *mut Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readOidCols(arg_numCols: ::std::os::raw::c_int) -> *mut Oid;
        }
        readOidCols(arg_numCols)
    })
}
pub unsafe fn readAttrNumberCols(arg_numCols: ::std::os::raw::c_int) -> *mut int16 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn readAttrNumberCols(arg_numCols: ::std::os::raw::c_int) -> *mut int16;
        }
        readAttrNumberCols(arg_numCols)
    })
}
pub unsafe fn copyObjectImpl(
    arg_obj: *const ::std::os::raw::c_void,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copyObjectImpl(
                arg_obj: *const ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void;
        }
        copyObjectImpl(arg_obj)
    })
}
pub unsafe fn equal(
    arg_a: *const ::std::os::raw::c_void,
    arg_b: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn equal(
                arg_a: *const ::std::os::raw::c_void,
                arg_b: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        equal(arg_a, arg_b)
    })
}
pub type Selectivity = f64;
pub type Cost = f64;
pub const CmdType_CMD_UNKNOWN: CmdType = 0;
pub const CmdType_CMD_SELECT: CmdType = 1;
pub const CmdType_CMD_UPDATE: CmdType = 2;
pub const CmdType_CMD_INSERT: CmdType = 3;
pub const CmdType_CMD_DELETE: CmdType = 4;
pub const CmdType_CMD_UTILITY: CmdType = 5;
pub const CmdType_CMD_NOTHING: CmdType = 6;
pub type CmdType = ::std::os::raw::c_uint;
pub const JoinType_JOIN_INNER: JoinType = 0;
pub const JoinType_JOIN_LEFT: JoinType = 1;
pub const JoinType_JOIN_FULL: JoinType = 2;
pub const JoinType_JOIN_RIGHT: JoinType = 3;
pub const JoinType_JOIN_SEMI: JoinType = 4;
pub const JoinType_JOIN_ANTI: JoinType = 5;
pub const JoinType_JOIN_UNIQUE_OUTER: JoinType = 6;
pub const JoinType_JOIN_UNIQUE_INNER: JoinType = 7;
pub type JoinType = ::std::os::raw::c_uint;
pub const AggStrategy_AGG_PLAIN: AggStrategy = 0;
pub const AggStrategy_AGG_SORTED: AggStrategy = 1;
pub const AggStrategy_AGG_HASHED: AggStrategy = 2;
pub const AggStrategy_AGG_MIXED: AggStrategy = 3;
pub type AggStrategy = ::std::os::raw::c_uint;
pub const AggSplit_AGGSPLIT_SIMPLE: AggSplit = 0;
pub const AggSplit_AGGSPLIT_INITIAL_SERIAL: AggSplit = 6;
pub const AggSplit_AGGSPLIT_FINAL_DESERIAL: AggSplit = 9;
pub type AggSplit = ::std::os::raw::c_uint;
pub const SetOpCmd_SETOPCMD_INTERSECT: SetOpCmd = 0;
pub const SetOpCmd_SETOPCMD_INTERSECT_ALL: SetOpCmd = 1;
pub const SetOpCmd_SETOPCMD_EXCEPT: SetOpCmd = 2;
pub const SetOpCmd_SETOPCMD_EXCEPT_ALL: SetOpCmd = 3;
pub type SetOpCmd = ::std::os::raw::c_uint;
pub const SetOpStrategy_SETOP_SORTED: SetOpStrategy = 0;
pub const SetOpStrategy_SETOP_HASHED: SetOpStrategy = 1;
pub type SetOpStrategy = ::std::os::raw::c_uint;
pub const OnConflictAction_ONCONFLICT_NONE: OnConflictAction = 0;
pub const OnConflictAction_ONCONFLICT_NOTHING: OnConflictAction = 1;
pub const OnConflictAction_ONCONFLICT_UPDATE: OnConflictAction = 2;
pub type OnConflictAction = ::std::os::raw::c_uint;
pub const LimitOption_LIMIT_OPTION_COUNT: LimitOption = 0;
pub const LimitOption_LIMIT_OPTION_WITH_TIES: LimitOption = 1;
pub const LimitOption_LIMIT_OPTION_DEFAULT: LimitOption = 2;
pub type LimitOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union ListCell {
    pub ptr_value: *mut ::std::os::raw::c_void,
    pub int_value: ::std::os::raw::c_int,
    pub oid_value: Oid,
}
impl Default for ListCell {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct List {
    pub type_: NodeTag,
    pub length: ::std::os::raw::c_int,
    pub max_length: ::std::os::raw::c_int,
    pub elements: *mut ListCell,
    pub initial_elements: __IncompleteArrayField<ListCell>,
}
impl Default for List {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForEachState {
    pub l: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForEachState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForBothState {
    pub l1: *const List,
    pub l2: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForBothState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForBothCellState {
    pub l1: *const List,
    pub l2: *const List,
    pub i1: ::std::os::raw::c_int,
    pub i2: ::std::os::raw::c_int,
}
impl Default for ForBothCellState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForThreeState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForThreeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForFourState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub l4: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForFourState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForFiveState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub l4: *const List,
    pub l5: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForFiveState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn list_make1_impl(arg_t: NodeTag, arg_datum1: ListCell) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make1_impl(arg_t: NodeTag, arg_datum1: ListCell) -> *mut List;
        }
        list_make1_impl(arg_t, arg_datum1)
    })
}
pub unsafe fn list_make2_impl(
    arg_t: NodeTag,
    arg_datum1: ListCell,
    arg_datum2: ListCell,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make2_impl(
                arg_t: NodeTag,
                arg_datum1: ListCell,
                arg_datum2: ListCell,
            ) -> *mut List;
        }
        list_make2_impl(arg_t, arg_datum1, arg_datum2)
    })
}
pub unsafe fn list_make3_impl(
    arg_t: NodeTag,
    arg_datum1: ListCell,
    arg_datum2: ListCell,
    arg_datum3: ListCell,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make3_impl(
                arg_t: NodeTag,
                arg_datum1: ListCell,
                arg_datum2: ListCell,
                arg_datum3: ListCell,
            ) -> *mut List;
        }
        list_make3_impl(arg_t, arg_datum1, arg_datum2, arg_datum3)
    })
}
pub unsafe fn list_make4_impl(
    arg_t: NodeTag,
    arg_datum1: ListCell,
    arg_datum2: ListCell,
    arg_datum3: ListCell,
    arg_datum4: ListCell,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_make4_impl(
                arg_t: NodeTag,
                arg_datum1: ListCell,
                arg_datum2: ListCell,
                arg_datum3: ListCell,
                arg_datum4: ListCell,
            ) -> *mut List;
        }
        list_make4_impl(arg_t, arg_datum1, arg_datum2, arg_datum3, arg_datum4)
    })
}
pub unsafe fn lappend(arg_list: *mut List, arg_datum: *mut ::std::os::raw::c_void) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend(arg_list: *mut List, arg_datum: *mut ::std::os::raw::c_void) -> *mut List;
        }
        lappend(arg_list, arg_datum)
    })
}
pub unsafe fn lappend_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List;
        }
        lappend_int(arg_list, arg_datum)
    })
}
pub unsafe fn lappend_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lappend_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        lappend_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_insert_nth(
    arg_list: *mut List,
    arg_pos: ::std::os::raw::c_int,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_insert_nth(
                arg_list: *mut List,
                arg_pos: ::std::os::raw::c_int,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_insert_nth(arg_list, arg_pos, arg_datum)
    })
}
pub unsafe fn list_insert_nth_int(
    arg_list: *mut List,
    arg_pos: ::std::os::raw::c_int,
    arg_datum: ::std::os::raw::c_int,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_insert_nth_int(
                arg_list: *mut List,
                arg_pos: ::std::os::raw::c_int,
                arg_datum: ::std::os::raw::c_int,
            ) -> *mut List;
        }
        list_insert_nth_int(arg_list, arg_pos, arg_datum)
    })
}
pub unsafe fn list_insert_nth_oid(
    arg_list: *mut List,
    arg_pos: ::std::os::raw::c_int,
    arg_datum: Oid,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_insert_nth_oid(
                arg_list: *mut List,
                arg_pos: ::std::os::raw::c_int,
                arg_datum: Oid,
            ) -> *mut List;
        }
        list_insert_nth_oid(arg_list, arg_pos, arg_datum)
    })
}
pub unsafe fn lcons(arg_datum: *mut ::std::os::raw::c_void, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons(arg_datum: *mut ::std::os::raw::c_void, arg_list: *mut List) -> *mut List;
        }
        lcons(arg_datum, arg_list)
    })
}
pub unsafe fn lcons_int(arg_datum: ::std::os::raw::c_int, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons_int(arg_datum: ::std::os::raw::c_int, arg_list: *mut List) -> *mut List;
        }
        lcons_int(arg_datum, arg_list)
    })
}
pub unsafe fn lcons_oid(arg_datum: Oid, arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lcons_oid(arg_datum: Oid, arg_list: *mut List) -> *mut List;
        }
        lcons_oid(arg_datum, arg_list)
    })
}
pub unsafe fn list_concat(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_copy(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_copy(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_concat_copy(arg_list1, arg_list2)
    })
}
pub unsafe fn list_truncate(arg_list: *mut List, arg_new_size: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_truncate(arg_list: *mut List, arg_new_size: ::std::os::raw::c_int)
                -> *mut List;
        }
        list_truncate(arg_list, arg_new_size)
    })
}
pub unsafe fn list_member(arg_list: *const List, arg_datum: *const ::std::os::raw::c_void) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member(arg_list: *const List, arg_datum: *const ::std::os::raw::c_void)
                -> bool;
        }
        list_member(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_ptr(
    arg_list: *const List,
    arg_datum: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_ptr(
                arg_list: *const List,
                arg_datum: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        list_member_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_int(arg_list: *const List, arg_datum: ::std::os::raw::c_int) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_int(arg_list: *const List, arg_datum: ::std::os::raw::c_int) -> bool;
        }
        list_member_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_member_oid(arg_list: *const List, arg_datum: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_member_oid(arg_list: *const List, arg_datum: Oid) -> bool;
        }
        list_member_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_delete(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_ptr(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_ptr(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_delete_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_int(arg_list: *mut List, arg_datum: ::std::os::raw::c_int) -> *mut List;
        }
        list_delete_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        list_delete_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_delete_first(arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_first(arg_list: *mut List) -> *mut List;
        }
        list_delete_first(arg_list)
    })
}
pub unsafe fn list_delete_last(arg_list: *mut List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_last(arg_list: *mut List) -> *mut List;
        }
        list_delete_last(arg_list)
    })
}
pub unsafe fn list_delete_first_n(arg_list: *mut List, arg_n: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_first_n(arg_list: *mut List, arg_n: ::std::os::raw::c_int) -> *mut List;
        }
        list_delete_first_n(arg_list, arg_n)
    })
}
pub unsafe fn list_delete_nth_cell(arg_list: *mut List, arg_n: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_nth_cell(arg_list: *mut List, arg_n: ::std::os::raw::c_int)
                -> *mut List;
        }
        list_delete_nth_cell(arg_list, arg_n)
    })
}
pub unsafe fn list_delete_cell(arg_list: *mut List, arg_cell: *mut ListCell) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_delete_cell(arg_list: *mut List, arg_cell: *mut ListCell) -> *mut List;
        }
        list_delete_cell(arg_list, arg_cell)
    })
}
pub unsafe fn list_union(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_union_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_union_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_union_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_intersection(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_intersection(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_intersection(arg_list1, arg_list2)
    })
}
pub unsafe fn list_intersection_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_intersection_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_intersection_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_ptr(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_int(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_int(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_difference_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_difference_oid(arg_list1: *const List, arg_list2: *const List) -> *mut List;
        }
        list_difference_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_append_unique(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_append_unique(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_ptr(
    arg_list: *mut List,
    arg_datum: *mut ::std::os::raw::c_void,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_ptr(
                arg_list: *mut List,
                arg_datum: *mut ::std::os::raw::c_void,
            ) -> *mut List;
        }
        list_append_unique_ptr(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_int(
    arg_list: *mut List,
    arg_datum: ::std::os::raw::c_int,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_int(
                arg_list: *mut List,
                arg_datum: ::std::os::raw::c_int,
            ) -> *mut List;
        }
        list_append_unique_int(arg_list, arg_datum)
    })
}
pub unsafe fn list_append_unique_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_append_unique_oid(arg_list: *mut List, arg_datum: Oid) -> *mut List;
        }
        list_append_unique_oid(arg_list, arg_datum)
    })
}
pub unsafe fn list_concat_unique(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat_unique(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_ptr(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_ptr(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat_unique_ptr(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_int(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_int(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat_unique_int(arg_list1, arg_list2)
    })
}
pub unsafe fn list_concat_unique_oid(arg_list1: *mut List, arg_list2: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_concat_unique_oid(arg_list1: *mut List, arg_list2: *const List) -> *mut List;
        }
        list_concat_unique_oid(arg_list1, arg_list2)
    })
}
pub unsafe fn list_deduplicate_oid(arg_list: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_deduplicate_oid(arg_list: *mut List);
        }
        list_deduplicate_oid(arg_list)
    })
}
pub unsafe fn list_free(arg_list: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_free(arg_list: *mut List);
        }
        list_free(arg_list)
    })
}
pub unsafe fn list_free_deep(arg_list: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_free_deep(arg_list: *mut List);
        }
        list_free_deep(arg_list)
    })
}
pub unsafe fn list_copy(arg_list: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_copy(arg_list: *const List) -> *mut List;
        }
        list_copy(arg_list)
    })
}
pub unsafe fn list_copy_tail(arg_list: *const List, arg_nskip: ::std::os::raw::c_int) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_copy_tail(arg_list: *const List, arg_nskip: ::std::os::raw::c_int)
                -> *mut List;
        }
        list_copy_tail(arg_list, arg_nskip)
    })
}
pub unsafe fn list_copy_deep(arg_oldlist: *const List) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_copy_deep(arg_oldlist: *const List) -> *mut List;
        }
        list_copy_deep(arg_oldlist)
    })
}
pub type list_sort_comparator = ::std::option::Option<
    unsafe extern "C" fn(a: *const ListCell, b: *const ListCell) -> ::std::os::raw::c_int,
>;
pub unsafe fn list_sort(arg_list: *mut List, arg_cmp: list_sort_comparator) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_sort(arg_list: *mut List, arg_cmp: list_sort_comparator);
        }
        list_sort(arg_list, arg_cmp)
    })
}
pub unsafe fn list_oid_cmp(
    arg_p1: *const ListCell,
    arg_p2: *const ListCell,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn list_oid_cmp(
                arg_p1: *const ListCell,
                arg_p2: *const ListCell,
            ) -> ::std::os::raw::c_int;
        }
        list_oid_cmp(arg_p1, arg_p2)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrDefault {
    pub adnum: AttrNumber,
    pub adbin: *mut ::std::os::raw::c_char,
}
impl Default for AttrDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstrCheck {
    pub ccname: *mut ::std::os::raw::c_char,
    pub ccbin: *mut ::std::os::raw::c_char,
    pub ccvalid: bool,
    pub ccnoinherit: bool,
}
impl Default for ConstrCheck {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConstr {
    pub defval: *mut AttrDefault,
    pub check: *mut ConstrCheck,
    pub missing: *mut AttrMissing,
    pub num_defval: uint16,
    pub num_check: uint16,
    pub has_not_null: bool,
    pub has_generated_stored: bool,
}
impl Default for TupleConstr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct TupleDescData {
    pub natts: ::std::os::raw::c_int,
    pub tdtypeid: Oid,
    pub tdtypmod: int32,
    pub tdrefcount: ::std::os::raw::c_int,
    pub constr: *mut TupleConstr,
    pub attrs: __IncompleteArrayField<FormData_pg_attribute>,
}
impl Default for TupleDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleDesc = *mut TupleDescData;
pub unsafe fn CreateTemplateTupleDesc(arg_natts: ::std::os::raw::c_int) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTemplateTupleDesc(arg_natts: ::std::os::raw::c_int) -> TupleDesc;
        }
        CreateTemplateTupleDesc(arg_natts)
    })
}
pub unsafe fn CreateTupleDesc(
    arg_natts: ::std::os::raw::c_int,
    arg_attrs: *mut Form_pg_attribute,
) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDesc(
                arg_natts: ::std::os::raw::c_int,
                arg_attrs: *mut Form_pg_attribute,
            ) -> TupleDesc;
        }
        CreateTupleDesc(arg_natts, arg_attrs)
    })
}
pub unsafe fn CreateTupleDescCopy(arg_tupdesc: TupleDesc) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDescCopy(arg_tupdesc: TupleDesc) -> TupleDesc;
        }
        CreateTupleDescCopy(arg_tupdesc)
    })
}
pub unsafe fn CreateTupleDescCopyConstr(arg_tupdesc: TupleDesc) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateTupleDescCopyConstr(arg_tupdesc: TupleDesc) -> TupleDesc;
        }
        CreateTupleDescCopyConstr(arg_tupdesc)
    })
}
pub unsafe fn TupleDescCopy(arg_dst: TupleDesc, arg_src: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescCopy(arg_dst: TupleDesc, arg_src: TupleDesc);
        }
        TupleDescCopy(arg_dst, arg_src)
    })
}
pub unsafe fn TupleDescCopyEntry(
    arg_dst: TupleDesc,
    arg_dstAttno: AttrNumber,
    arg_src: TupleDesc,
    arg_srcAttno: AttrNumber,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescCopyEntry(
                arg_dst: TupleDesc,
                arg_dstAttno: AttrNumber,
                arg_src: TupleDesc,
                arg_srcAttno: AttrNumber,
            );
        }
        TupleDescCopyEntry(arg_dst, arg_dstAttno, arg_src, arg_srcAttno)
    })
}
pub unsafe fn FreeTupleDesc(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeTupleDesc(arg_tupdesc: TupleDesc);
        }
        FreeTupleDesc(arg_tupdesc)
    })
}
pub unsafe fn IncrTupleDescRefCount(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn IncrTupleDescRefCount(arg_tupdesc: TupleDesc);
        }
        IncrTupleDescRefCount(arg_tupdesc)
    })
}
pub unsafe fn DecrTupleDescRefCount(arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DecrTupleDescRefCount(arg_tupdesc: TupleDesc);
        }
        DecrTupleDescRefCount(arg_tupdesc)
    })
}
pub unsafe fn equalTupleDescs(arg_tupdesc1: TupleDesc, arg_tupdesc2: TupleDesc) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn equalTupleDescs(arg_tupdesc1: TupleDesc, arg_tupdesc2: TupleDesc) -> bool;
        }
        equalTupleDescs(arg_tupdesc1, arg_tupdesc2)
    })
}
pub unsafe fn hashTupleDesc(arg_tupdesc: TupleDesc) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hashTupleDesc(arg_tupdesc: TupleDesc) -> uint32;
        }
        hashTupleDesc(arg_tupdesc)
    })
}
pub unsafe fn TupleDescInitEntry(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_attributeName: *const ::std::os::raw::c_char,
    arg_oidtypeid: Oid,
    arg_typmod: int32,
    arg_attdim: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitEntry(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_attributeName: *const ::std::os::raw::c_char,
                arg_oidtypeid: Oid,
                arg_typmod: int32,
                arg_attdim: ::std::os::raw::c_int,
            );
        }
        TupleDescInitEntry(
            arg_desc,
            arg_attributeNumber,
            arg_attributeName,
            arg_oidtypeid,
            arg_typmod,
            arg_attdim,
        )
    })
}
pub unsafe fn TupleDescInitBuiltinEntry(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_attributeName: *const ::std::os::raw::c_char,
    arg_oidtypeid: Oid,
    arg_typmod: int32,
    arg_attdim: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitBuiltinEntry(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_attributeName: *const ::std::os::raw::c_char,
                arg_oidtypeid: Oid,
                arg_typmod: int32,
                arg_attdim: ::std::os::raw::c_int,
            );
        }
        TupleDescInitBuiltinEntry(
            arg_desc,
            arg_attributeNumber,
            arg_attributeName,
            arg_oidtypeid,
            arg_typmod,
            arg_attdim,
        )
    })
}
pub unsafe fn TupleDescInitEntryCollation(
    arg_desc: TupleDesc,
    arg_attributeNumber: AttrNumber,
    arg_collationid: Oid,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescInitEntryCollation(
                arg_desc: TupleDesc,
                arg_attributeNumber: AttrNumber,
                arg_collationid: Oid,
            );
        }
        TupleDescInitEntryCollation(arg_desc, arg_attributeNumber, arg_collationid)
    })
}
pub unsafe fn BuildDescForRelation(arg_schema: *mut List) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildDescForRelation(arg_schema: *mut List) -> TupleDesc;
        }
        BuildDescForRelation(arg_schema)
    })
}
pub unsafe fn BuildDescFromLists(
    arg_names: *mut List,
    arg_types: *mut List,
    arg_typmods: *mut List,
    arg_collations: *mut List,
) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildDescFromLists(
                arg_names: *mut List,
                arg_types: *mut List,
                arg_typmods: *mut List,
                arg_collations: *mut List,
            ) -> TupleDesc;
        }
        BuildDescFromLists(arg_names, arg_types, arg_typmods, arg_collations)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrMap {
    pub attnums: *mut AttrNumber,
    pub maplen: ::std::os::raw::c_int,
}
impl Default for AttrMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn make_attrmap(arg_maplen: ::std::os::raw::c_int) -> *mut AttrMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn make_attrmap(arg_maplen: ::std::os::raw::c_int) -> *mut AttrMap;
        }
        make_attrmap(arg_maplen)
    })
}
pub unsafe fn free_attrmap(arg_map: *mut AttrMap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn free_attrmap(arg_map: *mut AttrMap);
        }
        free_attrmap(arg_map)
    })
}
pub unsafe fn build_attrmap_by_name(arg_indesc: TupleDesc, arg_outdesc: TupleDesc) -> *mut AttrMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn build_attrmap_by_name(arg_indesc: TupleDesc, arg_outdesc: TupleDesc)
                -> *mut AttrMap;
        }
        build_attrmap_by_name(arg_indesc, arg_outdesc)
    })
}
pub unsafe fn build_attrmap_by_name_if_req(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
) -> *mut AttrMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn build_attrmap_by_name_if_req(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
            ) -> *mut AttrMap;
        }
        build_attrmap_by_name_if_req(arg_indesc, arg_outdesc)
    })
}
pub unsafe fn build_attrmap_by_position(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
    arg_msg: *const ::std::os::raw::c_char,
) -> *mut AttrMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn build_attrmap_by_position(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
                arg_msg: *const ::std::os::raw::c_char,
            ) -> *mut AttrMap;
        }
        build_attrmap_by_position(arg_indesc, arg_outdesc, arg_msg)
    })
}
pub type BlockNumber = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockIdData {
    pub bi_hi: uint16,
    pub bi_lo: uint16,
}
pub type BlockId = *mut BlockIdData;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemIdData {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl ItemIdData {
    #[inline]
    pub fn lp_off(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_off(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_flags(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_lp_flags(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_len(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_len(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lp_off: ::std::os::raw::c_uint,
        lp_flags: ::std::os::raw::c_uint,
        lp_len: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 15u8, {
            let lp_off: u32 = unsafe { ::std::mem::transmute(lp_off) };
            lp_off as u64
        });
        __bindgen_bitfield_unit.set(15usize, 2u8, {
            let lp_flags: u32 = unsafe { ::std::mem::transmute(lp_flags) };
            lp_flags as u64
        });
        __bindgen_bitfield_unit.set(17usize, 15u8, {
            let lp_len: u32 = unsafe { ::std::mem::transmute(lp_len) };
            lp_len as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type ItemId = *mut ItemIdData;
pub type ItemOffset = uint16;
pub type ItemLength = uint16;
pub type OffsetNumber = uint16;
#[repr(C, packed(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemPointerData {
    pub ip_blkid: BlockIdData,
    pub ip_posid: OffsetNumber,
}
pub type ItemPointer = *mut ItemPointerData;
pub unsafe fn ItemPointerEquals(arg_pointer1: ItemPointer, arg_pointer2: ItemPointer) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ItemPointerEquals(arg_pointer1: ItemPointer, arg_pointer2: ItemPointer) -> bool;
        }
        ItemPointerEquals(arg_pointer1, arg_pointer2)
    })
}
pub unsafe fn ItemPointerCompare(arg_arg1: ItemPointer, arg_arg2: ItemPointer) -> int32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ItemPointerCompare(arg_arg1: ItemPointer, arg_arg2: ItemPointer) -> int32;
        }
        ItemPointerCompare(arg_arg1, arg_arg2)
    })
}
pub type HeapTupleHeader = *mut HeapTupleHeaderData;
pub type MinimalTuple = *mut MinimalTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleData {
    pub t_len: uint32,
    pub t_self: ItemPointerData,
    pub t_tableOid: Oid,
    pub t_data: HeapTupleHeader,
}
impl Default for HeapTupleData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HeapTuple = *mut HeapTupleData;
pub unsafe fn HeapTupleHeaderGetCmin(arg_tup: HeapTupleHeader) -> CommandId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderGetCmin(arg_tup: HeapTupleHeader) -> CommandId;
        }
        HeapTupleHeaderGetCmin(arg_tup)
    })
}
pub unsafe fn HeapTupleHeaderGetCmax(arg_tup: HeapTupleHeader) -> CommandId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderGetCmax(arg_tup: HeapTupleHeader) -> CommandId;
        }
        HeapTupleHeaderGetCmax(arg_tup)
    })
}
pub unsafe fn HeapTupleHeaderAdjustCmax(
    arg_tup: HeapTupleHeader,
    arg_cmax: *mut CommandId,
    arg_iscombo: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderAdjustCmax(
                arg_tup: HeapTupleHeader,
                arg_cmax: *mut CommandId,
                arg_iscombo: *mut bool,
            );
        }
        HeapTupleHeaderAdjustCmax(arg_tup, arg_cmax, arg_iscombo)
    })
}
pub unsafe fn HeapTupleGetUpdateXid(arg_tuple: HeapTupleHeader) -> TransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleGetUpdateXid(arg_tuple: HeapTupleHeader) -> TransactionId;
        }
        HeapTupleGetUpdateXid(arg_tuple)
    })
}
pub type XLogRecPtr = uint64;
pub type XLogSegNo = uint64;
pub type TimeLineID = uint32;
pub type RepOriginId = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct FullTransactionId {
    pub value: uint64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VariableCacheData {
    pub nextOid: Oid,
    pub oidCount: uint32,
    pub nextFullXid: FullTransactionId,
    pub oldestXid: TransactionId,
    pub xidVacLimit: TransactionId,
    pub xidWarnLimit: TransactionId,
    pub xidStopLimit: TransactionId,
    pub xidWrapLimit: TransactionId,
    pub oldestXidDB: Oid,
    pub oldestCommitTsXid: TransactionId,
    pub newestCommitTsXid: TransactionId,
    pub latestCompletedXid: TransactionId,
    pub oldestClogXid: TransactionId,
}
pub type VariableCache = *mut VariableCacheData;
pub unsafe fn TransactionStartedDuringRecovery() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionStartedDuringRecovery() -> bool;
        }
        TransactionStartedDuringRecovery()
    })
}
extern "C" {
    pub static mut ShmemVariableCache: VariableCache;
}
pub unsafe fn TransactionIdDidCommit(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdDidCommit(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdDidCommit(arg_transactionId)
    })
}
pub unsafe fn TransactionIdDidAbort(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdDidAbort(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdDidAbort(arg_transactionId)
    })
}
pub unsafe fn TransactionIdIsKnownCompleted(arg_transactionId: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdIsKnownCompleted(arg_transactionId: TransactionId) -> bool;
        }
        TransactionIdIsKnownCompleted(arg_transactionId)
    })
}
pub unsafe fn TransactionIdCommitTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdCommitTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
            );
        }
        TransactionIdCommitTree(arg_xid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdAsyncCommitTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
    arg_lsn: XLogRecPtr,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdAsyncCommitTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
                arg_lsn: XLogRecPtr,
            );
        }
        TransactionIdAsyncCommitTree(arg_xid, arg_nxids, arg_xids, arg_lsn)
    })
}
pub unsafe fn TransactionIdAbortTree(
    arg_xid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *mut TransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdAbortTree(
                arg_xid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *mut TransactionId,
            );
        }
        TransactionIdAbortTree(arg_xid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdPrecedes(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdPrecedes(arg_id1: TransactionId, arg_id2: TransactionId) -> bool;
        }
        TransactionIdPrecedes(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdPrecedesOrEquals(
    arg_id1: TransactionId,
    arg_id2: TransactionId,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdPrecedesOrEquals(
                arg_id1: TransactionId,
                arg_id2: TransactionId,
            ) -> bool;
        }
        TransactionIdPrecedesOrEquals(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdFollows(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdFollows(arg_id1: TransactionId, arg_id2: TransactionId) -> bool;
        }
        TransactionIdFollows(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdFollowsOrEquals(arg_id1: TransactionId, arg_id2: TransactionId) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdFollowsOrEquals(arg_id1: TransactionId, arg_id2: TransactionId)
                -> bool;
        }
        TransactionIdFollowsOrEquals(arg_id1, arg_id2)
    })
}
pub unsafe fn TransactionIdLatest(
    arg_mainxid: TransactionId,
    arg_nxids: ::std::os::raw::c_int,
    arg_xids: *const TransactionId,
) -> TransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdLatest(
                arg_mainxid: TransactionId,
                arg_nxids: ::std::os::raw::c_int,
                arg_xids: *const TransactionId,
            ) -> TransactionId;
        }
        TransactionIdLatest(arg_mainxid, arg_nxids, arg_xids)
    })
}
pub unsafe fn TransactionIdGetCommitLSN(arg_xid: TransactionId) -> XLogRecPtr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdGetCommitLSN(arg_xid: TransactionId) -> XLogRecPtr;
        }
        TransactionIdGetCommitLSN(arg_xid)
    })
}
pub unsafe fn GetNewTransactionId(arg_isSubXact: bool) -> FullTransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNewTransactionId(arg_isSubXact: bool) -> FullTransactionId;
        }
        GetNewTransactionId(arg_isSubXact)
    })
}
pub unsafe fn AdvanceNextFullTransactionIdPastXid(arg_xid: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AdvanceNextFullTransactionIdPastXid(arg_xid: TransactionId);
        }
        AdvanceNextFullTransactionIdPastXid(arg_xid)
    })
}
pub unsafe fn ReadNextFullTransactionId() -> FullTransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadNextFullTransactionId() -> FullTransactionId;
        }
        ReadNextFullTransactionId()
    })
}
pub unsafe fn SetTransactionIdLimit(
    arg_oldest_datfrozenxid: TransactionId,
    arg_oldest_datoid: Oid,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetTransactionIdLimit(
                arg_oldest_datfrozenxid: TransactionId,
                arg_oldest_datoid: Oid,
            );
        }
        SetTransactionIdLimit(arg_oldest_datfrozenxid, arg_oldest_datoid)
    })
}
pub unsafe fn AdvanceOldestClogXid(arg_oldest_datfrozenxid: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AdvanceOldestClogXid(arg_oldest_datfrozenxid: TransactionId);
        }
        AdvanceOldestClogXid(arg_oldest_datfrozenxid)
    })
}
pub unsafe fn ForceTransactionIdLimitUpdate() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ForceTransactionIdLimitUpdate() -> bool;
        }
        ForceTransactionIdLimitUpdate()
    })
}
pub unsafe fn GetNewObjectId() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNewObjectId() -> Oid;
        }
        GetNewObjectId()
    })
}
pub type Item = Pointer;
pub type Page = Pointer;
pub type LocationIndex = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PageXLogRecPtr {
    pub xlogid: uint32,
    pub xrecoff: uint32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct PageHeaderData {
    pub pd_lsn: PageXLogRecPtr,
    pub pd_checksum: uint16,
    pub pd_flags: uint16,
    pub pd_lower: LocationIndex,
    pub pd_upper: LocationIndex,
    pub pd_special: LocationIndex,
    pub pd_pagesize_version: uint16,
    pub pd_prune_xid: TransactionId,
    pub pd_linp: __IncompleteArrayField<ItemIdData>,
}
pub type PageHeader = *mut PageHeaderData;
pub unsafe fn PageInit(arg_page: Page, arg_pageSize: Size, arg_specialSize: Size) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageInit(arg_page: Page, arg_pageSize: Size, arg_specialSize: Size);
        }
        PageInit(arg_page, arg_pageSize, arg_specialSize)
    })
}
pub unsafe fn PageIsVerified(arg_page: Page, arg_blkno: BlockNumber) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIsVerified(arg_page: Page, arg_blkno: BlockNumber) -> bool;
        }
        PageIsVerified(arg_page, arg_blkno)
    })
}
pub unsafe fn PageIsVerifiedExtended(
    arg_page: Page,
    arg_blkno: BlockNumber,
    arg_flags: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIsVerifiedExtended(
                arg_page: Page,
                arg_blkno: BlockNumber,
                arg_flags: ::std::os::raw::c_int,
            ) -> bool;
        }
        PageIsVerifiedExtended(arg_page, arg_blkno, arg_flags)
    })
}
pub unsafe fn PageAddItemExtended(
    arg_page: Page,
    arg_item: Item,
    arg_size: Size,
    arg_offsetNumber: OffsetNumber,
    arg_flags: ::std::os::raw::c_int,
) -> OffsetNumber {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageAddItemExtended(
                arg_page: Page,
                arg_item: Item,
                arg_size: Size,
                arg_offsetNumber: OffsetNumber,
                arg_flags: ::std::os::raw::c_int,
            ) -> OffsetNumber;
        }
        PageAddItemExtended(arg_page, arg_item, arg_size, arg_offsetNumber, arg_flags)
    })
}
pub unsafe fn PageGetTempPage(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPage(arg_page: Page) -> Page;
        }
        PageGetTempPage(arg_page)
    })
}
pub unsafe fn PageGetTempPageCopy(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPageCopy(arg_page: Page) -> Page;
        }
        PageGetTempPageCopy(arg_page)
    })
}
pub unsafe fn PageGetTempPageCopySpecial(arg_page: Page) -> Page {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetTempPageCopySpecial(arg_page: Page) -> Page;
        }
        PageGetTempPageCopySpecial(arg_page)
    })
}
pub unsafe fn PageRestoreTempPage(arg_tempPage: Page, arg_oldPage: Page) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageRestoreTempPage(arg_tempPage: Page, arg_oldPage: Page);
        }
        PageRestoreTempPage(arg_tempPage, arg_oldPage)
    })
}
pub unsafe fn PageRepairFragmentation(arg_page: Page) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageRepairFragmentation(arg_page: Page);
        }
        PageRepairFragmentation(arg_page)
    })
}
pub unsafe fn PageGetFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetFreeSpace(arg_page: Page) -> Size;
        }
        PageGetFreeSpace(arg_page)
    })
}
pub unsafe fn PageGetFreeSpaceForMultipleTuples(
    arg_page: Page,
    arg_ntups: ::std::os::raw::c_int,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetFreeSpaceForMultipleTuples(
                arg_page: Page,
                arg_ntups: ::std::os::raw::c_int,
            ) -> Size;
        }
        PageGetFreeSpaceForMultipleTuples(arg_page, arg_ntups)
    })
}
pub unsafe fn PageGetExactFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetExactFreeSpace(arg_page: Page) -> Size;
        }
        PageGetExactFreeSpace(arg_page)
    })
}
pub unsafe fn PageGetHeapFreeSpace(arg_page: Page) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageGetHeapFreeSpace(arg_page: Page) -> Size;
        }
        PageGetHeapFreeSpace(arg_page)
    })
}
pub unsafe fn PageIndexTupleDelete(arg_page: Page, arg_offset: OffsetNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleDelete(arg_page: Page, arg_offset: OffsetNumber);
        }
        PageIndexTupleDelete(arg_page, arg_offset)
    })
}
pub unsafe fn PageIndexMultiDelete(
    arg_page: Page,
    arg_itemnos: *mut OffsetNumber,
    arg_nitems: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexMultiDelete(
                arg_page: Page,
                arg_itemnos: *mut OffsetNumber,
                arg_nitems: ::std::os::raw::c_int,
            );
        }
        PageIndexMultiDelete(arg_page, arg_itemnos, arg_nitems)
    })
}
pub unsafe fn PageIndexTupleDeleteNoCompact(arg_page: Page, arg_offset: OffsetNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleDeleteNoCompact(arg_page: Page, arg_offset: OffsetNumber);
        }
        PageIndexTupleDeleteNoCompact(arg_page, arg_offset)
    })
}
pub unsafe fn PageIndexTupleOverwrite(
    arg_page: Page,
    arg_offnum: OffsetNumber,
    arg_newtup: Item,
    arg_newsize: Size,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageIndexTupleOverwrite(
                arg_page: Page,
                arg_offnum: OffsetNumber,
                arg_newtup: Item,
                arg_newsize: Size,
            ) -> bool;
        }
        PageIndexTupleOverwrite(arg_page, arg_offnum, arg_newtup, arg_newsize)
    })
}
pub unsafe fn PageSetChecksumCopy(
    arg_page: Page,
    arg_blkno: BlockNumber,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageSetChecksumCopy(
                arg_page: Page,
                arg_blkno: BlockNumber,
            ) -> *mut ::std::os::raw::c_char;
        }
        PageSetChecksumCopy(arg_page, arg_blkno)
    })
}
pub unsafe fn PageSetChecksumInplace(arg_page: Page, arg_blkno: BlockNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PageSetChecksumInplace(arg_page: Page, arg_blkno: BlockNumber);
        }
        PageSetChecksumInplace(arg_page, arg_blkno)
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct HeapTupleFields {
    pub t_xmin: TransactionId,
    pub t_xmax: TransactionId,
    pub t_field3: HeapTupleFields__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleFields__bindgen_ty_1 {
    pub t_cid: CommandId,
    pub t_xvac: TransactionId,
}
impl Default for HeapTupleFields__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleFields {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct DatumTupleFields {
    pub datum_len_: int32,
    pub datum_typmod: int32,
    pub datum_typeid: Oid,
}
#[repr(C)]
pub struct HeapTupleHeaderData {
    pub t_choice: HeapTupleHeaderData__bindgen_ty_1,
    pub t_ctid: ItemPointerData,
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleHeaderData__bindgen_ty_1 {
    pub t_heap: HeapTupleFields,
    pub t_datum: DatumTupleFields,
}
impl Default for HeapTupleHeaderData__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleHeaderData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct MinimalTupleData {
    pub t_len: uint32,
    pub mt_padding: [::std::os::raw::c_char; 6usize],
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
pub unsafe fn heap_compute_data_size(
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_compute_data_size(
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> Size;
        }
        heap_compute_data_size(arg_tupleDesc, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_fill_tuple(
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
    arg_data: *mut ::std::os::raw::c_char,
    arg_data_size: Size,
    arg_infomask: *mut uint16,
    arg_bit: *mut bits8,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_fill_tuple(
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
                arg_data: *mut ::std::os::raw::c_char,
                arg_data_size: Size,
                arg_infomask: *mut uint16,
                arg_bit: *mut bits8,
            );
        }
        heap_fill_tuple(
            arg_tupleDesc,
            arg_values,
            arg_isnull,
            arg_data,
            arg_data_size,
            arg_infomask,
            arg_bit,
        )
    })
}
pub unsafe fn heap_attisnull(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_attisnull(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
            ) -> bool;
        }
        heap_attisnull(arg_tup, arg_attnum, arg_tupleDesc)
    })
}
pub unsafe fn nocachegetattr(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_att: TupleDesc,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nocachegetattr(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_att: TupleDesc,
            ) -> Datum;
        }
        nocachegetattr(arg_tup, arg_attnum, arg_att)
    })
}
pub unsafe fn heap_getsysattr(
    arg_tup: HeapTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
    arg_isnull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_getsysattr(
                arg_tup: HeapTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
                arg_isnull: *mut bool,
            ) -> Datum;
        }
        heap_getsysattr(arg_tup, arg_attnum, arg_tupleDesc, arg_isnull)
    })
}
pub unsafe fn getmissingattr(
    arg_tupleDesc: TupleDesc,
    arg_attnum: ::std::os::raw::c_int,
    arg_isnull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn getmissingattr(
                arg_tupleDesc: TupleDesc,
                arg_attnum: ::std::os::raw::c_int,
                arg_isnull: *mut bool,
            ) -> Datum;
        }
        getmissingattr(arg_tupleDesc, arg_attnum, arg_isnull)
    })
}
pub unsafe fn heap_copytuple(arg_tuple: HeapTuple) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copytuple(arg_tuple: HeapTuple) -> HeapTuple;
        }
        heap_copytuple(arg_tuple)
    })
}
pub unsafe fn heap_copytuple_with_tuple(arg_src: HeapTuple, arg_dest: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copytuple_with_tuple(arg_src: HeapTuple, arg_dest: HeapTuple);
        }
        heap_copytuple_with_tuple(arg_src, arg_dest)
    })
}
pub unsafe fn heap_copy_tuple_as_datum(arg_tuple: HeapTuple, arg_tupleDesc: TupleDesc) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copy_tuple_as_datum(arg_tuple: HeapTuple, arg_tupleDesc: TupleDesc) -> Datum;
        }
        heap_copy_tuple_as_datum(arg_tuple, arg_tupleDesc)
    })
}
pub unsafe fn heap_form_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_form_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> HeapTuple;
        }
        heap_form_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_modify_tuple(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_replValues: *mut Datum,
    arg_replIsnull: *mut bool,
    arg_doReplace: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_modify_tuple(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_replValues: *mut Datum,
                arg_replIsnull: *mut bool,
                arg_doReplace: *mut bool,
            ) -> HeapTuple;
        }
        heap_modify_tuple(arg_tuple, arg_tupleDesc, arg_replValues, arg_replIsnull, arg_doReplace)
    })
}
pub unsafe fn heap_modify_tuple_by_cols(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_nCols: ::std::os::raw::c_int,
    arg_replCols: *mut ::std::os::raw::c_int,
    arg_replValues: *mut Datum,
    arg_replIsnull: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_modify_tuple_by_cols(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_nCols: ::std::os::raw::c_int,
                arg_replCols: *mut ::std::os::raw::c_int,
                arg_replValues: *mut Datum,
                arg_replIsnull: *mut bool,
            ) -> HeapTuple;
        }
        heap_modify_tuple_by_cols(
            arg_tuple,
            arg_tupleDesc,
            arg_nCols,
            arg_replCols,
            arg_replValues,
            arg_replIsnull,
        )
    })
}
pub unsafe fn heap_deform_tuple(
    arg_tuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_deform_tuple(
                arg_tuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        heap_deform_tuple(arg_tuple, arg_tupleDesc, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_freetuple(arg_htup: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_freetuple(arg_htup: HeapTuple);
        }
        heap_freetuple(arg_htup)
    })
}
pub unsafe fn heap_form_minimal_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_form_minimal_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> MinimalTuple;
        }
        heap_form_minimal_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn heap_free_minimal_tuple(arg_mtup: MinimalTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_free_minimal_tuple(arg_mtup: MinimalTuple);
        }
        heap_free_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn heap_copy_minimal_tuple(arg_mtup: MinimalTuple) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_copy_minimal_tuple(arg_mtup: MinimalTuple) -> MinimalTuple;
        }
        heap_copy_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn heap_tuple_from_minimal_tuple(arg_mtup: MinimalTuple) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_tuple_from_minimal_tuple(arg_mtup: MinimalTuple) -> HeapTuple;
        }
        heap_tuple_from_minimal_tuple(arg_mtup)
    })
}
pub unsafe fn minimal_tuple_from_heap_tuple(arg_htup: HeapTuple) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn minimal_tuple_from_heap_tuple(arg_htup: HeapTuple) -> MinimalTuple;
        }
        minimal_tuple_from_heap_tuple(arg_htup)
    })
}
pub unsafe fn heap_expand_tuple(arg_sourceTuple: HeapTuple, arg_tupleDesc: TupleDesc) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn heap_expand_tuple(arg_sourceTuple: HeapTuple, arg_tupleDesc: TupleDesc)
                -> HeapTuple;
        }
        heap_expand_tuple(arg_sourceTuple, arg_tupleDesc)
    })
}
pub unsafe fn minimal_expand_tuple(
    arg_sourceTuple: HeapTuple,
    arg_tupleDesc: TupleDesc,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn minimal_expand_tuple(
                arg_sourceTuple: HeapTuple,
                arg_tupleDesc: TupleDesc,
            ) -> MinimalTuple;
        }
        minimal_expand_tuple(arg_sourceTuple, arg_tupleDesc)
    })
}
pub type Buffer = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferAccessStrategyData {
    _unused: [u8; 0],
}
pub type BufferAccessStrategy = *mut BufferAccessStrategyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleTableSlot {
    pub type_: NodeTag,
    pub tts_flags: uint16,
    pub tts_nvalid: AttrNumber,
    pub tts_ops: *const TupleTableSlotOps,
    pub tts_tupleDescriptor: TupleDesc,
    pub tts_values: *mut Datum,
    pub tts_isnull: *mut bool,
    pub tts_mcxt: MemoryContext,
    pub tts_tid: ItemPointerData,
    pub tts_tableOid: Oid,
}
impl Default for TupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TupleTableSlotOps {
    pub base_slot_size: usize,
    pub init: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub release: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub clear: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub getsomeattrs: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, natts: ::std::os::raw::c_int),
    >,
    pub getsysattr: ::std::option::Option<
        unsafe extern "C" fn(
            slot: *mut TupleTableSlot,
            attnum: ::std::os::raw::c_int,
            isnull: *mut bool,
        ) -> Datum,
    >,
    pub materialize: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub copyslot: ::std::option::Option<
        unsafe extern "C" fn(dstslot: *mut TupleTableSlot, srcslot: *mut TupleTableSlot),
    >,
    pub get_heap_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub get_minimal_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> MinimalTuple>,
    pub copy_heap_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub copy_minimal_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> MinimalTuple>,
}
extern "C" {
    pub static TTSOpsVirtual: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsHeapTuple: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsMinimalTuple: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsBufferHeapTuple: TupleTableSlotOps;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VirtualTupleTableSlot {
    pub base: TupleTableSlot,
    pub data: *mut ::std::os::raw::c_char,
}
impl Default for VirtualTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub off: uint32,
    pub tupdata: HeapTupleData,
}
impl Default for HeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferHeapTupleTableSlot {
    pub base: HeapTupleTableSlot,
    pub buffer: Buffer,
}
impl Default for BufferHeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinimalTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub mintuple: MinimalTuple,
    pub minhdr: HeapTupleData,
    pub off: uint32,
}
impl Default for MinimalTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn MakeTupleTableSlot(
    arg_tupleDesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakeTupleTableSlot(
                arg_tupleDesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        MakeTupleTableSlot(arg_tupleDesc, arg_tts_ops)
    })
}
pub unsafe fn ExecAllocTableSlot(
    arg_tupleTable: *mut *mut List,
    arg_desc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecAllocTableSlot(
                arg_tupleTable: *mut *mut List,
                arg_desc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        ExecAllocTableSlot(arg_tupleTable, arg_desc, arg_tts_ops)
    })
}
pub unsafe fn ExecResetTupleTable(arg_tupleTable: *mut List, arg_shouldFree: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecResetTupleTable(arg_tupleTable: *mut List, arg_shouldFree: bool);
        }
        ExecResetTupleTable(arg_tupleTable, arg_shouldFree)
    })
}
pub unsafe fn MakeSingleTupleTableSlot(
    arg_tupdesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakeSingleTupleTableSlot(
                arg_tupdesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        MakeSingleTupleTableSlot(arg_tupdesc, arg_tts_ops)
    })
}
pub unsafe fn ExecDropSingleTupleTableSlot(arg_slot: *mut TupleTableSlot) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecDropSingleTupleTableSlot(arg_slot: *mut TupleTableSlot);
        }
        ExecDropSingleTupleTableSlot(arg_slot)
    })
}
pub unsafe fn ExecSetSlotDescriptor(arg_slot: *mut TupleTableSlot, arg_tupdesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSetSlotDescriptor(arg_slot: *mut TupleTableSlot, arg_tupdesc: TupleDesc);
        }
        ExecSetSlotDescriptor(arg_slot, arg_tupdesc)
    })
}
pub unsafe fn ExecStoreHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreHeapTuple(arg_tuple, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecForceStoreHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecForceStoreHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            );
        }
        ExecForceStoreHeapTuple(arg_tuple, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecStoreBufferHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_buffer: Buffer,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreBufferHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_buffer: Buffer,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreBufferHeapTuple(arg_tuple, arg_slot, arg_buffer)
    })
}
pub unsafe fn ExecStorePinnedBufferHeapTuple(
    arg_tuple: HeapTuple,
    arg_slot: *mut TupleTableSlot,
    arg_buffer: Buffer,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStorePinnedBufferHeapTuple(
                arg_tuple: HeapTuple,
                arg_slot: *mut TupleTableSlot,
                arg_buffer: Buffer,
            ) -> *mut TupleTableSlot;
        }
        ExecStorePinnedBufferHeapTuple(arg_tuple, arg_slot, arg_buffer)
    })
}
pub unsafe fn ExecStoreMinimalTuple(
    arg_mtup: MinimalTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreMinimalTuple(
                arg_mtup: MinimalTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            ) -> *mut TupleTableSlot;
        }
        ExecStoreMinimalTuple(arg_mtup, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecForceStoreMinimalTuple(
    arg_mtup: MinimalTuple,
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecForceStoreMinimalTuple(
                arg_mtup: MinimalTuple,
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: bool,
            );
        }
        ExecForceStoreMinimalTuple(arg_mtup, arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecStoreVirtualTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreVirtualTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
        }
        ExecStoreVirtualTuple(arg_slot)
    })
}
pub unsafe fn ExecStoreAllNullTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreAllNullTuple(arg_slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
        }
        ExecStoreAllNullTuple(arg_slot)
    })
}
pub unsafe fn ExecStoreHeapTupleDatum(arg_data: Datum, arg_slot: *mut TupleTableSlot) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecStoreHeapTupleDatum(arg_data: Datum, arg_slot: *mut TupleTableSlot);
        }
        ExecStoreHeapTupleDatum(arg_data, arg_slot)
    })
}
pub unsafe fn ExecFetchSlotHeapTuple(
    arg_slot: *mut TupleTableSlot,
    arg_materialize: bool,
    arg_shouldFree: *mut bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotHeapTuple(
                arg_slot: *mut TupleTableSlot,
                arg_materialize: bool,
                arg_shouldFree: *mut bool,
            ) -> HeapTuple;
        }
        ExecFetchSlotHeapTuple(arg_slot, arg_materialize, arg_shouldFree)
    })
}
pub unsafe fn ExecFetchSlotMinimalTuple(
    arg_slot: *mut TupleTableSlot,
    arg_shouldFree: *mut bool,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotMinimalTuple(
                arg_slot: *mut TupleTableSlot,
                arg_shouldFree: *mut bool,
            ) -> MinimalTuple;
        }
        ExecFetchSlotMinimalTuple(arg_slot, arg_shouldFree)
    })
}
pub unsafe fn ExecFetchSlotHeapTupleDatum(arg_slot: *mut TupleTableSlot) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFetchSlotHeapTupleDatum(arg_slot: *mut TupleTableSlot) -> Datum;
        }
        ExecFetchSlotHeapTupleDatum(arg_slot)
    })
}
pub unsafe fn slot_getmissingattrs(
    arg_slot: *mut TupleTableSlot,
    arg_startAttNum: ::std::os::raw::c_int,
    arg_lastAttNum: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn slot_getmissingattrs(
                arg_slot: *mut TupleTableSlot,
                arg_startAttNum: ::std::os::raw::c_int,
                arg_lastAttNum: ::std::os::raw::c_int,
            );
        }
        slot_getmissingattrs(arg_slot, arg_startAttNum, arg_lastAttNum)
    })
}
pub unsafe fn slot_getsomeattrs_int(
    arg_slot: *mut TupleTableSlot,
    arg_attnum: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn slot_getsomeattrs_int(
                arg_slot: *mut TupleTableSlot,
                arg_attnum: ::std::os::raw::c_int,
            );
        }
        slot_getsomeattrs_int(arg_slot, arg_attnum)
    })
}
pub type bitmapword = uint64;
pub type signedbitmapword = int64;
#[repr(C)]
#[derive(Debug, Default)]
pub struct Bitmapset {
    pub nwords: ::std::os::raw::c_int,
    pub words: __IncompleteArrayField<bitmapword>,
}
pub const BMS_Comparison_BMS_EQUAL: BMS_Comparison = 0;
pub const BMS_Comparison_BMS_SUBSET1: BMS_Comparison = 1;
pub const BMS_Comparison_BMS_SUBSET2: BMS_Comparison = 2;
pub const BMS_Comparison_BMS_DIFFERENT: BMS_Comparison = 3;
pub type BMS_Comparison = ::std::os::raw::c_uint;
pub const BMS_Membership_BMS_EMPTY_SET: BMS_Membership = 0;
pub const BMS_Membership_BMS_SINGLETON: BMS_Membership = 1;
pub const BMS_Membership_BMS_MULTIPLE: BMS_Membership = 2;
pub type BMS_Membership = ::std::os::raw::c_uint;
pub unsafe fn bms_copy(arg_a: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_copy(arg_a: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_copy(arg_a)
    })
}
pub unsafe fn bms_equal(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_equal(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_equal(arg_a, arg_b)
    })
}
pub unsafe fn bms_compare(
    arg_a: *const Bitmapset,
    arg_b: *const Bitmapset,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_compare(
                arg_a: *const Bitmapset,
                arg_b: *const Bitmapset,
            ) -> ::std::os::raw::c_int;
        }
        bms_compare(arg_a, arg_b)
    })
}
pub unsafe fn bms_make_singleton(arg_x: ::std::os::raw::c_int) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_make_singleton(arg_x: ::std::os::raw::c_int) -> *mut Bitmapset;
        }
        bms_make_singleton(arg_x)
    })
}
pub unsafe fn bms_free(arg_a: *mut Bitmapset) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_free(arg_a: *mut Bitmapset);
        }
        bms_free(arg_a)
    })
}
pub unsafe fn bms_union(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_union(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_union(arg_a, arg_b)
    })
}
pub unsafe fn bms_intersect(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_intersect(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_intersect(arg_a, arg_b)
    })
}
pub unsafe fn bms_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_difference(arg_a, arg_b)
    })
}
pub unsafe fn bms_is_subset(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_subset(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_is_subset(arg_a, arg_b)
    })
}
pub unsafe fn bms_subset_compare(
    arg_a: *const Bitmapset,
    arg_b: *const Bitmapset,
) -> BMS_Comparison {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_subset_compare(
                arg_a: *const Bitmapset,
                arg_b: *const Bitmapset,
            ) -> BMS_Comparison;
        }
        bms_subset_compare(arg_a, arg_b)
    })
}
pub unsafe fn bms_is_member(arg_x: ::std::os::raw::c_int, arg_a: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_member(arg_x: ::std::os::raw::c_int, arg_a: *const Bitmapset) -> bool;
        }
        bms_is_member(arg_x, arg_a)
    })
}
pub unsafe fn bms_member_index(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_member_index(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_member_index(arg_a, arg_x)
    })
}
pub unsafe fn bms_overlap(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_overlap(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_overlap(arg_a, arg_b)
    })
}
pub unsafe fn bms_overlap_list(arg_a: *const Bitmapset, arg_b: *const List) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_overlap_list(arg_a: *const Bitmapset, arg_b: *const List) -> bool;
        }
        bms_overlap_list(arg_a, arg_b)
    })
}
pub unsafe fn bms_nonempty_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_nonempty_difference(arg_a: *const Bitmapset, arg_b: *const Bitmapset) -> bool;
        }
        bms_nonempty_difference(arg_a, arg_b)
    })
}
pub unsafe fn bms_singleton_member(arg_a: *const Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_singleton_member(arg_a: *const Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_singleton_member(arg_a)
    })
}
pub unsafe fn bms_get_singleton_member(
    arg_a: *const Bitmapset,
    arg_member: *mut ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_get_singleton_member(
                arg_a: *const Bitmapset,
                arg_member: *mut ::std::os::raw::c_int,
            ) -> bool;
        }
        bms_get_singleton_member(arg_a, arg_member)
    })
}
pub unsafe fn bms_num_members(arg_a: *const Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_num_members(arg_a: *const Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_num_members(arg_a)
    })
}
pub unsafe fn bms_membership(arg_a: *const Bitmapset) -> BMS_Membership {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_membership(arg_a: *const Bitmapset) -> BMS_Membership;
        }
        bms_membership(arg_a)
    })
}
pub unsafe fn bms_is_empty(arg_a: *const Bitmapset) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_is_empty(arg_a: *const Bitmapset) -> bool;
        }
        bms_is_empty(arg_a)
    })
}
pub unsafe fn bms_add_member(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_member(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_add_member(arg_a, arg_x)
    })
}
pub unsafe fn bms_del_member(
    arg_a: *mut Bitmapset,
    arg_x: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_del_member(
                arg_a: *mut Bitmapset,
                arg_x: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_del_member(arg_a, arg_x)
    })
}
pub unsafe fn bms_add_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_add_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_add_range(
    arg_a: *mut Bitmapset,
    arg_lower: ::std::os::raw::c_int,
    arg_upper: ::std::os::raw::c_int,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_add_range(
                arg_a: *mut Bitmapset,
                arg_lower: ::std::os::raw::c_int,
                arg_upper: ::std::os::raw::c_int,
            ) -> *mut Bitmapset;
        }
        bms_add_range(arg_a, arg_lower, arg_upper)
    })
}
pub unsafe fn bms_int_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_int_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_int_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_del_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_del_members(arg_a: *mut Bitmapset, arg_b: *const Bitmapset) -> *mut Bitmapset;
        }
        bms_del_members(arg_a, arg_b)
    })
}
pub unsafe fn bms_join(arg_a: *mut Bitmapset, arg_b: *mut Bitmapset) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_join(arg_a: *mut Bitmapset, arg_b: *mut Bitmapset) -> *mut Bitmapset;
        }
        bms_join(arg_a, arg_b)
    })
}
pub unsafe fn bms_first_member(arg_a: *mut Bitmapset) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_first_member(arg_a: *mut Bitmapset) -> ::std::os::raw::c_int;
        }
        bms_first_member(arg_a)
    })
}
pub unsafe fn bms_next_member(
    arg_a: *const Bitmapset,
    arg_prevbit: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_next_member(
                arg_a: *const Bitmapset,
                arg_prevbit: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_next_member(arg_a, arg_prevbit)
    })
}
pub unsafe fn bms_prev_member(
    arg_a: *const Bitmapset,
    arg_prevbit: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_prev_member(
                arg_a: *const Bitmapset,
                arg_prevbit: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        bms_prev_member(arg_a, arg_prevbit)
    })
}
pub unsafe fn bms_hash_value(arg_a: *const Bitmapset) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bms_hash_value(arg_a: *const Bitmapset) -> uint32;
        }
        bms_hash_value(arg_a)
    })
}
pub unsafe fn bitmap_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bitmap_hash(arg_key: *const ::std::os::raw::c_void, arg_keysize: Size) -> uint32;
        }
        bitmap_hash(arg_key, arg_keysize)
    })
}
pub unsafe fn bitmap_match(
    arg_key1: *const ::std::os::raw::c_void,
    arg_key2: *const ::std::os::raw::c_void,
    arg_keysize: Size,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn bitmap_match(
                arg_key1: *const ::std::os::raw::c_void,
                arg_key2: *const ::std::os::raw::c_void,
                arg_keysize: Size,
            ) -> ::std::os::raw::c_int;
        }
        bitmap_match(arg_key1, arg_key2, arg_keysize)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConversionMap {
    pub indesc: TupleDesc,
    pub outdesc: TupleDesc,
    pub attrMap: *mut AttrMap,
    pub invalues: *mut Datum,
    pub inisnull: *mut bool,
    pub outvalues: *mut Datum,
    pub outisnull: *mut bool,
}
impl Default for TupleConversionMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn convert_tuples_by_position(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
    arg_msg: *const ::std::os::raw::c_char,
) -> *mut TupleConversionMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn convert_tuples_by_position(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
                arg_msg: *const ::std::os::raw::c_char,
            ) -> *mut TupleConversionMap;
        }
        convert_tuples_by_position(arg_indesc, arg_outdesc, arg_msg)
    })
}
pub unsafe fn convert_tuples_by_name(
    arg_indesc: TupleDesc,
    arg_outdesc: TupleDesc,
) -> *mut TupleConversionMap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn convert_tuples_by_name(
                arg_indesc: TupleDesc,
                arg_outdesc: TupleDesc,
            ) -> *mut TupleConversionMap;
        }
        convert_tuples_by_name(arg_indesc, arg_outdesc)
    })
}
pub unsafe fn execute_attr_map_tuple(
    arg_tuple: HeapTuple,
    arg_map: *mut TupleConversionMap,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_tuple(
                arg_tuple: HeapTuple,
                arg_map: *mut TupleConversionMap,
            ) -> HeapTuple;
        }
        execute_attr_map_tuple(arg_tuple, arg_map)
    })
}
pub unsafe fn execute_attr_map_slot(
    arg_attrMap: *mut AttrMap,
    arg_in_slot: *mut TupleTableSlot,
    arg_out_slot: *mut TupleTableSlot,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_slot(
                arg_attrMap: *mut AttrMap,
                arg_in_slot: *mut TupleTableSlot,
                arg_out_slot: *mut TupleTableSlot,
            ) -> *mut TupleTableSlot;
        }
        execute_attr_map_slot(arg_attrMap, arg_in_slot, arg_out_slot)
    })
}
pub unsafe fn execute_attr_map_cols(
    arg_attrMap: *mut AttrMap,
    arg_inbitmap: *mut Bitmapset,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execute_attr_map_cols(
                arg_attrMap: *mut AttrMap,
                arg_inbitmap: *mut Bitmapset,
            ) -> *mut Bitmapset;
        }
        execute_attr_map_cols(arg_attrMap, arg_inbitmap)
    })
}
pub unsafe fn free_conversion_map(arg_map: *mut TupleConversionMap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn free_conversion_map(arg_map: *mut TupleConversionMap);
        }
        free_conversion_map(arg_map)
    })
}
pub type instr_time = timespec;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BufferUsage {
    pub shared_blks_hit: ::std::os::raw::c_long,
    pub shared_blks_read: ::std::os::raw::c_long,
    pub shared_blks_dirtied: ::std::os::raw::c_long,
    pub shared_blks_written: ::std::os::raw::c_long,
    pub local_blks_hit: ::std::os::raw::c_long,
    pub local_blks_read: ::std::os::raw::c_long,
    pub local_blks_dirtied: ::std::os::raw::c_long,
    pub local_blks_written: ::std::os::raw::c_long,
    pub temp_blks_read: ::std::os::raw::c_long,
    pub temp_blks_written: ::std::os::raw::c_long,
    pub blk_read_time: instr_time,
    pub blk_write_time: instr_time,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WalUsage {
    pub wal_records: ::std::os::raw::c_long,
    pub wal_fpi: ::std::os::raw::c_long,
    pub wal_bytes: uint64,
}
pub const InstrumentOption_INSTRUMENT_TIMER: InstrumentOption = 1;
pub const InstrumentOption_INSTRUMENT_BUFFERS: InstrumentOption = 2;
pub const InstrumentOption_INSTRUMENT_ROWS: InstrumentOption = 4;
pub const InstrumentOption_INSTRUMENT_WAL: InstrumentOption = 8;
pub const InstrumentOption_INSTRUMENT_ALL: InstrumentOption = 2147483647;
pub type InstrumentOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Instrumentation {
    pub need_timer: bool,
    pub need_bufusage: bool,
    pub need_walusage: bool,
    pub running: bool,
    pub starttime: instr_time,
    pub counter: instr_time,
    pub firsttuple: f64,
    pub tuplecount: f64,
    pub bufusage_start: BufferUsage,
    pub walusage_start: WalUsage,
    pub startup: f64,
    pub total: f64,
    pub ntuples: f64,
    pub ntuples2: f64,
    pub nloops: f64,
    pub nfiltered1: f64,
    pub nfiltered2: f64,
    pub bufusage: BufferUsage,
    pub walusage: WalUsage,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct WorkerInstrumentation {
    pub num_workers: ::std::os::raw::c_int,
    pub instrument: __IncompleteArrayField<Instrumentation>,
}
extern "C" {
    pub static mut pgBufferUsage: BufferUsage;
}
extern "C" {
    pub static mut pgWalUsage: WalUsage;
}
pub unsafe fn InstrAlloc(
    arg_n: ::std::os::raw::c_int,
    arg_instrument_options: ::std::os::raw::c_int,
) -> *mut Instrumentation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAlloc(
                arg_n: ::std::os::raw::c_int,
                arg_instrument_options: ::std::os::raw::c_int,
            ) -> *mut Instrumentation;
        }
        InstrAlloc(arg_n, arg_instrument_options)
    })
}
pub unsafe fn InstrInit(
    arg_instr: *mut Instrumentation,
    arg_instrument_options: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrInit(
                arg_instr: *mut Instrumentation,
                arg_instrument_options: ::std::os::raw::c_int,
            );
        }
        InstrInit(arg_instr, arg_instrument_options)
    })
}
pub unsafe fn InstrStartNode(arg_instr: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStartNode(arg_instr: *mut Instrumentation);
        }
        InstrStartNode(arg_instr)
    })
}
pub unsafe fn InstrStopNode(arg_instr: *mut Instrumentation, arg_nTuples: f64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStopNode(arg_instr: *mut Instrumentation, arg_nTuples: f64);
        }
        InstrStopNode(arg_instr, arg_nTuples)
    })
}
pub unsafe fn InstrEndLoop(arg_instr: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrEndLoop(arg_instr: *mut Instrumentation);
        }
        InstrEndLoop(arg_instr)
    })
}
pub unsafe fn InstrAggNode(arg_dst: *mut Instrumentation, arg_add: *mut Instrumentation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAggNode(arg_dst: *mut Instrumentation, arg_add: *mut Instrumentation);
        }
        InstrAggNode(arg_dst, arg_add)
    })
}
pub unsafe fn InstrStartParallelQuery() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrStartParallelQuery();
        }
        InstrStartParallelQuery()
    })
}
pub unsafe fn InstrEndParallelQuery(arg_bufusage: *mut BufferUsage, arg_walusage: *mut WalUsage) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrEndParallelQuery(arg_bufusage: *mut BufferUsage, arg_walusage: *mut WalUsage);
        }
        InstrEndParallelQuery(arg_bufusage, arg_walusage)
    })
}
pub unsafe fn InstrAccumParallelQuery(arg_bufusage: *mut BufferUsage, arg_walusage: *mut WalUsage) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InstrAccumParallelQuery(arg_bufusage: *mut BufferUsage, arg_walusage: *mut WalUsage);
        }
        InstrAccumParallelQuery(arg_bufusage, arg_walusage)
    })
}
pub unsafe fn BufferUsageAccumDiff(
    arg_dst: *mut BufferUsage,
    arg_add: *const BufferUsage,
    arg_sub: *const BufferUsage,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BufferUsageAccumDiff(
                arg_dst: *mut BufferUsage,
                arg_add: *const BufferUsage,
                arg_sub: *const BufferUsage,
            );
        }
        BufferUsageAccumDiff(arg_dst, arg_add, arg_sub)
    })
}
pub unsafe fn WalUsageAccumDiff(
    arg_dst: *mut WalUsage,
    arg_add: *const WalUsage,
    arg_sub: *const WalUsage,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn WalUsageAccumDiff(
                arg_dst: *mut WalUsage,
                arg_add: *const WalUsage,
                arg_sub: *const WalUsage,
            );
        }
        WalUsageAccumDiff(arg_dst, arg_add, arg_sub)
    })
}
pub type fmNodePtr = *mut Node;
pub type fmAggrefPtr = *mut Aggref;
pub type fmExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
pub type fmStringInfo = *mut StringInfoData;
pub type FunctionCallInfo = *mut FunctionCallInfoBaseData;
pub type PGFunction =
    ::std::option::Option<unsafe extern "C" fn(fcinfo: FunctionCallInfo) -> Datum>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FmgrInfo {
    pub fn_addr: PGFunction,
    pub fn_oid: Oid,
    pub fn_nargs: ::std::os::raw::c_short,
    pub fn_strict: bool,
    pub fn_retset: bool,
    pub fn_stats: ::std::os::raw::c_uchar,
    pub fn_extra: *mut ::std::os::raw::c_void,
    pub fn_mcxt: MemoryContext,
    pub fn_expr: fmNodePtr,
}
impl Default for FmgrInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct FunctionCallInfoBaseData {
    pub flinfo: *mut FmgrInfo,
    pub context: fmNodePtr,
    pub resultinfo: fmNodePtr,
    pub fncollation: Oid,
    pub isnull: bool,
    pub nargs: ::std::os::raw::c_short,
    pub args: __IncompleteArrayField<NullableDatum>,
}
impl Default for FunctionCallInfoBaseData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn fmgr_info(arg_functionId: Oid, arg_finfo: *mut FmgrInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info(arg_functionId: Oid, arg_finfo: *mut FmgrInfo);
        }
        fmgr_info(arg_functionId, arg_finfo)
    })
}
pub unsafe fn fmgr_info_cxt(
    arg_functionId: Oid,
    arg_finfo: *mut FmgrInfo,
    arg_mcxt: MemoryContext,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info_cxt(
                arg_functionId: Oid,
                arg_finfo: *mut FmgrInfo,
                arg_mcxt: MemoryContext,
            );
        }
        fmgr_info_cxt(arg_functionId, arg_finfo, arg_mcxt)
    })
}
pub unsafe fn fmgr_info_copy(
    arg_dstinfo: *mut FmgrInfo,
    arg_srcinfo: *mut FmgrInfo,
    arg_destcxt: MemoryContext,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_info_copy(
                arg_dstinfo: *mut FmgrInfo,
                arg_srcinfo: *mut FmgrInfo,
                arg_destcxt: MemoryContext,
            );
        }
        fmgr_info_copy(arg_dstinfo, arg_srcinfo, arg_destcxt)
    })
}
pub unsafe fn fmgr_symbol(
    arg_functionId: Oid,
    arg_mod_: *mut *mut ::std::os::raw::c_char,
    arg_fn_: *mut *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_symbol(
                arg_functionId: Oid,
                arg_mod_: *mut *mut ::std::os::raw::c_char,
                arg_fn_: *mut *mut ::std::os::raw::c_char,
            );
        }
        fmgr_symbol(arg_functionId, arg_mod_, arg_fn_)
    })
}
pub unsafe fn pg_detoast_datum(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum(arg_datum)
    })
}
pub unsafe fn pg_detoast_datum_copy(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_copy(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum_copy(arg_datum)
    })
}
pub unsafe fn pg_detoast_datum_slice(
    arg_datum: *mut varlena,
    arg_first: int32,
    arg_count: int32,
) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_slice(
                arg_datum: *mut varlena,
                arg_first: int32,
                arg_count: int32,
            ) -> *mut varlena;
        }
        pg_detoast_datum_slice(arg_datum, arg_first, arg_count)
    })
}
pub unsafe fn pg_detoast_datum_packed(arg_datum: *mut varlena) -> *mut varlena {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_detoast_datum_packed(arg_datum: *mut varlena) -> *mut varlena;
        }
        pg_detoast_datum_packed(arg_datum)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_finfo_record {
    pub api_version: ::std::os::raw::c_int,
}
pub type PGFInfoFunction = ::std::option::Option<unsafe extern "C" fn() -> *const Pg_finfo_record>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_magic_struct {
    pub len: ::std::os::raw::c_int,
    pub version: ::std::os::raw::c_int,
    pub funcmaxargs: ::std::os::raw::c_int,
    pub indexmaxkeys: ::std::os::raw::c_int,
    pub namedatalen: ::std::os::raw::c_int,
    pub float8byval: ::std::os::raw::c_int,
}
pub type PGModuleMagicFunction =
    ::std::option::Option<unsafe extern "C" fn() -> *const Pg_magic_struct>;
pub unsafe fn DirectFunctionCall1Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall1Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        DirectFunctionCall1Coll(arg_func, arg_collation, arg_arg1)
    })
}
pub unsafe fn DirectFunctionCall2Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall2Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        DirectFunctionCall2Coll(arg_func, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn DirectFunctionCall3Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall3Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        DirectFunctionCall3Coll(arg_func, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn DirectFunctionCall4Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall4Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        DirectFunctionCall4Coll(arg_func, arg_collation, arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn DirectFunctionCall5Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall5Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        DirectFunctionCall5Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn DirectFunctionCall6Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall6Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        DirectFunctionCall6Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn DirectFunctionCall7Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall7Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        DirectFunctionCall7Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn DirectFunctionCall8Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall8Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        DirectFunctionCall8Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn DirectFunctionCall9Coll(
    arg_func: PGFunction,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DirectFunctionCall9Coll(
                arg_func: PGFunction,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        DirectFunctionCall9Coll(
            arg_func,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn CallerFInfoFunctionCall1(
    arg_func: PGFunction,
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CallerFInfoFunctionCall1(
                arg_func: PGFunction,
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        CallerFInfoFunctionCall1(arg_func, arg_flinfo, arg_collation, arg_arg1)
    })
}
pub unsafe fn CallerFInfoFunctionCall2(
    arg_func: PGFunction,
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CallerFInfoFunctionCall2(
                arg_func: PGFunction,
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        CallerFInfoFunctionCall2(arg_func, arg_flinfo, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn FunctionCall0Coll(arg_flinfo: *mut FmgrInfo, arg_collation: Oid) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall0Coll(arg_flinfo: *mut FmgrInfo, arg_collation: Oid) -> Datum;
        }
        FunctionCall0Coll(arg_flinfo, arg_collation)
    })
}
pub unsafe fn FunctionCall1Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall1Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        FunctionCall1Coll(arg_flinfo, arg_collation, arg_arg1)
    })
}
pub unsafe fn FunctionCall2Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall2Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        FunctionCall2Coll(arg_flinfo, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn FunctionCall3Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall3Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        FunctionCall3Coll(arg_flinfo, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn FunctionCall4Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall4Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        FunctionCall4Coll(arg_flinfo, arg_collation, arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn FunctionCall5Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall5Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        FunctionCall5Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn FunctionCall6Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall6Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        FunctionCall6Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn FunctionCall7Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall7Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        FunctionCall7Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn FunctionCall8Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall8Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        FunctionCall8Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn FunctionCall9Coll(
    arg_flinfo: *mut FmgrInfo,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FunctionCall9Coll(
                arg_flinfo: *mut FmgrInfo,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        FunctionCall9Coll(
            arg_flinfo,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn OidFunctionCall0Coll(arg_functionId: Oid, arg_collation: Oid) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall0Coll(arg_functionId: Oid, arg_collation: Oid) -> Datum;
        }
        OidFunctionCall0Coll(arg_functionId, arg_collation)
    })
}
pub unsafe fn OidFunctionCall1Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall1Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
            ) -> Datum;
        }
        OidFunctionCall1Coll(arg_functionId, arg_collation, arg_arg1)
    })
}
pub unsafe fn OidFunctionCall2Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall2Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
            ) -> Datum;
        }
        OidFunctionCall2Coll(arg_functionId, arg_collation, arg_arg1, arg_arg2)
    })
}
pub unsafe fn OidFunctionCall3Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall3Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
            ) -> Datum;
        }
        OidFunctionCall3Coll(arg_functionId, arg_collation, arg_arg1, arg_arg2, arg_arg3)
    })
}
pub unsafe fn OidFunctionCall4Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall4Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
            ) -> Datum;
        }
        OidFunctionCall4Coll(arg_functionId, arg_collation, arg_arg1, arg_arg2, arg_arg3, arg_arg4)
    })
}
pub unsafe fn OidFunctionCall5Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall5Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
            ) -> Datum;
        }
        OidFunctionCall5Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
        )
    })
}
pub unsafe fn OidFunctionCall6Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall6Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
            ) -> Datum;
        }
        OidFunctionCall6Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
        )
    })
}
pub unsafe fn OidFunctionCall7Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall7Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
            ) -> Datum;
        }
        OidFunctionCall7Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
        )
    })
}
pub unsafe fn OidFunctionCall8Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall8Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
            ) -> Datum;
        }
        OidFunctionCall8Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
        )
    })
}
pub unsafe fn OidFunctionCall9Coll(
    arg_functionId: Oid,
    arg_collation: Oid,
    arg_arg1: Datum,
    arg_arg2: Datum,
    arg_arg3: Datum,
    arg_arg4: Datum,
    arg_arg5: Datum,
    arg_arg6: Datum,
    arg_arg7: Datum,
    arg_arg8: Datum,
    arg_arg9: Datum,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidFunctionCall9Coll(
                arg_functionId: Oid,
                arg_collation: Oid,
                arg_arg1: Datum,
                arg_arg2: Datum,
                arg_arg3: Datum,
                arg_arg4: Datum,
                arg_arg5: Datum,
                arg_arg6: Datum,
                arg_arg7: Datum,
                arg_arg8: Datum,
                arg_arg9: Datum,
            ) -> Datum;
        }
        OidFunctionCall9Coll(
            arg_functionId,
            arg_collation,
            arg_arg1,
            arg_arg2,
            arg_arg3,
            arg_arg4,
            arg_arg5,
            arg_arg6,
            arg_arg7,
            arg_arg8,
            arg_arg9,
        )
    })
}
pub unsafe fn InputFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_str_: *mut ::std::os::raw::c_char,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InputFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_str_: *mut ::std::os::raw::c_char,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        InputFunctionCall(arg_flinfo, arg_str_, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OidInputFunctionCall(
    arg_functionId: Oid,
    arg_str_: *mut ::std::os::raw::c_char,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidInputFunctionCall(
                arg_functionId: Oid,
                arg_str_: *mut ::std::os::raw::c_char,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        OidInputFunctionCall(arg_functionId, arg_str_, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OutputFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_val: Datum,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OutputFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_val: Datum,
            ) -> *mut ::std::os::raw::c_char;
        }
        OutputFunctionCall(arg_flinfo, arg_val)
    })
}
pub unsafe fn OidOutputFunctionCall(
    arg_functionId: Oid,
    arg_val: Datum,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidOutputFunctionCall(
                arg_functionId: Oid,
                arg_val: Datum,
            ) -> *mut ::std::os::raw::c_char;
        }
        OidOutputFunctionCall(arg_functionId, arg_val)
    })
}
pub unsafe fn ReceiveFunctionCall(
    arg_flinfo: *mut FmgrInfo,
    arg_buf: fmStringInfo,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReceiveFunctionCall(
                arg_flinfo: *mut FmgrInfo,
                arg_buf: fmStringInfo,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        ReceiveFunctionCall(arg_flinfo, arg_buf, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn OidReceiveFunctionCall(
    arg_functionId: Oid,
    arg_buf: fmStringInfo,
    arg_typioparam: Oid,
    arg_typmod: int32,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidReceiveFunctionCall(
                arg_functionId: Oid,
                arg_buf: fmStringInfo,
                arg_typioparam: Oid,
                arg_typmod: int32,
            ) -> Datum;
        }
        OidReceiveFunctionCall(arg_functionId, arg_buf, arg_typioparam, arg_typmod)
    })
}
pub unsafe fn SendFunctionCall(arg_flinfo: *mut FmgrInfo, arg_val: Datum) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SendFunctionCall(arg_flinfo: *mut FmgrInfo, arg_val: Datum) -> *mut bytea;
        }
        SendFunctionCall(arg_flinfo, arg_val)
    })
}
pub unsafe fn OidSendFunctionCall(arg_functionId: Oid, arg_val: Datum) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OidSendFunctionCall(arg_functionId: Oid, arg_val: Datum) -> *mut bytea;
        }
        OidSendFunctionCall(arg_functionId, arg_val)
    })
}
pub unsafe fn fetch_finfo_record(
    arg_filehandle: *mut ::std::os::raw::c_void,
    arg_funcname: *const ::std::os::raw::c_char,
) -> *const Pg_finfo_record {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fetch_finfo_record(
                arg_filehandle: *mut ::std::os::raw::c_void,
                arg_funcname: *const ::std::os::raw::c_char,
            ) -> *const Pg_finfo_record;
        }
        fetch_finfo_record(arg_filehandle, arg_funcname)
    })
}
pub unsafe fn clear_external_function_hash(arg_filehandle: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clear_external_function_hash(arg_filehandle: *mut ::std::os::raw::c_void);
        }
        clear_external_function_hash(arg_filehandle)
    })
}
pub unsafe fn fmgr_internal_function(arg_proname: *const ::std::os::raw::c_char) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fmgr_internal_function(arg_proname: *const ::std::os::raw::c_char) -> Oid;
        }
        fmgr_internal_function(arg_proname)
    })
}
pub unsafe fn get_fn_expr_rettype(arg_flinfo: *mut FmgrInfo) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_rettype(arg_flinfo: *mut FmgrInfo) -> Oid;
        }
        get_fn_expr_rettype(arg_flinfo)
    })
}
pub unsafe fn get_fn_expr_argtype(
    arg_flinfo: *mut FmgrInfo,
    arg_argnum: ::std::os::raw::c_int,
) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_argtype(
                arg_flinfo: *mut FmgrInfo,
                arg_argnum: ::std::os::raw::c_int,
            ) -> Oid;
        }
        get_fn_expr_argtype(arg_flinfo, arg_argnum)
    })
}
pub unsafe fn get_call_expr_argtype(arg_expr: fmNodePtr, arg_argnum: ::std::os::raw::c_int) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_call_expr_argtype(arg_expr: fmNodePtr, arg_argnum: ::std::os::raw::c_int)
                -> Oid;
        }
        get_call_expr_argtype(arg_expr, arg_argnum)
    })
}
pub unsafe fn get_fn_expr_arg_stable(
    arg_flinfo: *mut FmgrInfo,
    arg_argnum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_arg_stable(
                arg_flinfo: *mut FmgrInfo,
                arg_argnum: ::std::os::raw::c_int,
            ) -> bool;
        }
        get_fn_expr_arg_stable(arg_flinfo, arg_argnum)
    })
}
pub unsafe fn get_call_expr_arg_stable(
    arg_expr: fmNodePtr,
    arg_argnum: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_call_expr_arg_stable(
                arg_expr: fmNodePtr,
                arg_argnum: ::std::os::raw::c_int,
            ) -> bool;
        }
        get_call_expr_arg_stable(arg_expr, arg_argnum)
    })
}
pub unsafe fn get_fn_expr_variadic(arg_flinfo: *mut FmgrInfo) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_expr_variadic(arg_flinfo: *mut FmgrInfo) -> bool;
        }
        get_fn_expr_variadic(arg_flinfo)
    })
}
pub unsafe fn get_fn_opclass_options(arg_flinfo: *mut FmgrInfo) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_fn_opclass_options(arg_flinfo: *mut FmgrInfo) -> *mut bytea;
        }
        get_fn_opclass_options(arg_flinfo)
    })
}
pub unsafe fn has_fn_opclass_options(arg_flinfo: *mut FmgrInfo) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn has_fn_opclass_options(arg_flinfo: *mut FmgrInfo) -> bool;
        }
        has_fn_opclass_options(arg_flinfo)
    })
}
pub unsafe fn set_fn_opclass_options(arg_flinfo: *mut FmgrInfo, arg_options: *mut bytea) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_fn_opclass_options(arg_flinfo: *mut FmgrInfo, arg_options: *mut bytea);
        }
        set_fn_opclass_options(arg_flinfo, arg_options)
    })
}
pub unsafe fn CheckFunctionValidatorAccess(arg_validatorOid: Oid, arg_functionOid: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CheckFunctionValidatorAccess(arg_validatorOid: Oid, arg_functionOid: Oid) -> bool;
        }
        CheckFunctionValidatorAccess(arg_validatorOid, arg_functionOid)
    })
}
extern "C" {
    pub static mut Dynamic_library_path: *mut ::std::os::raw::c_char;
}
pub unsafe fn load_external_function(
    arg_filename: *const ::std::os::raw::c_char,
    arg_funcname: *const ::std::os::raw::c_char,
    arg_signalNotFound: bool,
    arg_filehandle: *mut *mut ::std::os::raw::c_void,
) -> PGFunction {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn load_external_function(
                arg_filename: *const ::std::os::raw::c_char,
                arg_funcname: *const ::std::os::raw::c_char,
                arg_signalNotFound: bool,
                arg_filehandle: *mut *mut ::std::os::raw::c_void,
            ) -> PGFunction;
        }
        load_external_function(arg_filename, arg_funcname, arg_signalNotFound, arg_filehandle)
    })
}
pub unsafe fn lookup_external_function(
    arg_filehandle: *mut ::std::os::raw::c_void,
    arg_funcname: *const ::std::os::raw::c_char,
) -> PGFunction {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lookup_external_function(
                arg_filehandle: *mut ::std::os::raw::c_void,
                arg_funcname: *const ::std::os::raw::c_char,
            ) -> PGFunction;
        }
        lookup_external_function(arg_filehandle, arg_funcname)
    })
}
pub unsafe fn load_file(arg_filename: *const ::std::os::raw::c_char, arg_restricted: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn load_file(arg_filename: *const ::std::os::raw::c_char, arg_restricted: bool);
        }
        load_file(arg_filename, arg_restricted)
    })
}
pub unsafe fn find_rendezvous_variable(
    arg_varName: *const ::std::os::raw::c_char,
) -> *mut *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_rendezvous_variable(
                arg_varName: *const ::std::os::raw::c_char,
            ) -> *mut *mut ::std::os::raw::c_void;
        }
        find_rendezvous_variable(arg_varName)
    })
}
pub unsafe fn EstimateLibraryStateSpace() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EstimateLibraryStateSpace() -> Size;
        }
        EstimateLibraryStateSpace()
    })
}
pub unsafe fn SerializeLibraryState(
    arg_maxsize: Size,
    arg_start_address: *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SerializeLibraryState(
                arg_maxsize: Size,
                arg_start_address: *mut ::std::os::raw::c_char,
            );
        }
        SerializeLibraryState(arg_maxsize, arg_start_address)
    })
}
pub unsafe fn RestoreLibraryState(arg_start_address: *mut ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RestoreLibraryState(arg_start_address: *mut ::std::os::raw::c_char);
        }
        RestoreLibraryState(arg_start_address)
    })
}
pub unsafe fn AggCheckCallContext(
    arg_fcinfo: FunctionCallInfo,
    arg_aggcontext: *mut MemoryContext,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggCheckCallContext(
                arg_fcinfo: FunctionCallInfo,
                arg_aggcontext: *mut MemoryContext,
            ) -> ::std::os::raw::c_int;
        }
        AggCheckCallContext(arg_fcinfo, arg_aggcontext)
    })
}
pub unsafe fn AggGetAggref(arg_fcinfo: FunctionCallInfo) -> fmAggrefPtr {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggGetAggref(arg_fcinfo: FunctionCallInfo) -> fmAggrefPtr;
        }
        AggGetAggref(arg_fcinfo)
    })
}
pub unsafe fn AggGetTempMemoryContext(arg_fcinfo: FunctionCallInfo) -> MemoryContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggGetTempMemoryContext(arg_fcinfo: FunctionCallInfo) -> MemoryContext;
        }
        AggGetTempMemoryContext(arg_fcinfo)
    })
}
pub unsafe fn AggStateIsShared(arg_fcinfo: FunctionCallInfo) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggStateIsShared(arg_fcinfo: FunctionCallInfo) -> bool;
        }
        AggStateIsShared(arg_fcinfo)
    })
}
pub unsafe fn AggRegisterCallback(
    arg_fcinfo: FunctionCallInfo,
    arg_func: fmExprContextCallbackFunction,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AggRegisterCallback(
                arg_fcinfo: FunctionCallInfo,
                arg_func: fmExprContextCallbackFunction,
                arg_arg: Datum,
            );
        }
        AggRegisterCallback(arg_fcinfo, arg_func, arg_arg)
    })
}
pub const FmgrHookEventType_FHET_START: FmgrHookEventType = 0;
pub const FmgrHookEventType_FHET_END: FmgrHookEventType = 1;
pub const FmgrHookEventType_FHET_ABORT: FmgrHookEventType = 2;
pub type FmgrHookEventType = ::std::os::raw::c_uint;
pub type needs_fmgr_hook_type = ::std::option::Option<unsafe extern "C" fn(fn_oid: Oid) -> bool>;
pub type fmgr_hook_type = ::std::option::Option<
    unsafe extern "C" fn(event: FmgrHookEventType, flinfo: *mut FmgrInfo, arg: *mut Datum),
>;
extern "C" {
    pub static mut needs_fmgr_hook: needs_fmgr_hook_type;
}
extern "C" {
    pub static mut fmgr_hook: fmgr_hook_type;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StringInfoData {
    pub data: *mut ::std::os::raw::c_char,
    pub len: ::std::os::raw::c_int,
    pub maxlen: ::std::os::raw::c_int,
    pub cursor: ::std::os::raw::c_int,
}
impl Default for StringInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type StringInfo = *mut StringInfoData;
pub unsafe fn makeStringInfo() -> StringInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeStringInfo() -> StringInfo;
        }
        makeStringInfo()
    })
}
pub unsafe fn initStringInfo(arg_str_: StringInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn initStringInfo(arg_str_: StringInfo);
        }
        initStringInfo(arg_str_)
    })
}
pub unsafe fn resetStringInfo(arg_str_: StringInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn resetStringInfo(arg_str_: StringInfo);
        }
        resetStringInfo(arg_str_)
    })
}
pub unsafe fn appendStringInfo(arg_str_: StringInfo, arg_fmt: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfo(arg_str_: StringInfo, arg_fmt: *const ::std::os::raw::c_char);
        }
        appendStringInfo(arg_str_, arg_fmt)
    })
}
pub unsafe fn appendStringInfoString(arg_str_: StringInfo, arg_s: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoString(arg_str_: StringInfo, arg_s: *const ::std::os::raw::c_char);
        }
        appendStringInfoString(arg_str_, arg_s)
    })
}
pub unsafe fn appendStringInfoChar(arg_str_: StringInfo, arg_ch: ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoChar(arg_str_: StringInfo, arg_ch: ::std::os::raw::c_char);
        }
        appendStringInfoChar(arg_str_, arg_ch)
    })
}
pub unsafe fn appendStringInfoSpaces(arg_str_: StringInfo, arg_count: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendStringInfoSpaces(arg_str_: StringInfo, arg_count: ::std::os::raw::c_int);
        }
        appendStringInfoSpaces(arg_str_, arg_count)
    })
}
pub unsafe fn appendBinaryStringInfo(
    arg_str_: StringInfo,
    arg_data: *const ::std::os::raw::c_char,
    arg_datalen: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendBinaryStringInfo(
                arg_str_: StringInfo,
                arg_data: *const ::std::os::raw::c_char,
                arg_datalen: ::std::os::raw::c_int,
            );
        }
        appendBinaryStringInfo(arg_str_, arg_data, arg_datalen)
    })
}
pub unsafe fn appendBinaryStringInfoNT(
    arg_str_: StringInfo,
    arg_data: *const ::std::os::raw::c_char,
    arg_datalen: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn appendBinaryStringInfoNT(
                arg_str_: StringInfo,
                arg_data: *const ::std::os::raw::c_char,
                arg_datalen: ::std::os::raw::c_int,
            );
        }
        appendBinaryStringInfoNT(arg_str_, arg_data, arg_datalen)
    })
}
pub unsafe fn enlargeStringInfo(arg_str_: StringInfo, arg_needed: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn enlargeStringInfo(arg_str_: StringInfo, arg_needed: ::std::os::raw::c_int);
        }
        enlargeStringInfo(arg_str_, arg_needed)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap_node {
    pub first_child: *mut pairingheap_node,
    pub next_sibling: *mut pairingheap_node,
    pub prev_or_parent: *mut pairingheap_node,
}
impl Default for pairingheap_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pairingheap_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const pairingheap_node,
        b: *const pairingheap_node,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap {
    pub ph_compare: pairingheap_comparator,
    pub ph_arg: *mut ::std::os::raw::c_void,
    pub ph_root: *mut pairingheap_node,
}
impl Default for pairingheap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn pairingheap_allocate(
    arg_compare: pairingheap_comparator,
    arg_arg: *mut ::std::os::raw::c_void,
) -> *mut pairingheap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_allocate(
                arg_compare: pairingheap_comparator,
                arg_arg: *mut ::std::os::raw::c_void,
            ) -> *mut pairingheap;
        }
        pairingheap_allocate(arg_compare, arg_arg)
    })
}
pub unsafe fn pairingheap_free(arg_heap: *mut pairingheap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_free(arg_heap: *mut pairingheap);
        }
        pairingheap_free(arg_heap)
    })
}
pub unsafe fn pairingheap_add(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_add(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node);
        }
        pairingheap_add(arg_heap, arg_node)
    })
}
pub unsafe fn pairingheap_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node;
        }
        pairingheap_first(arg_heap)
    })
}
pub unsafe fn pairingheap_remove_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_remove_first(arg_heap: *mut pairingheap) -> *mut pairingheap_node;
        }
        pairingheap_remove_first(arg_heap)
    })
}
pub unsafe fn pairingheap_remove(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pairingheap_remove(arg_heap: *mut pairingheap, arg_node: *mut pairingheap_node);
        }
        pairingheap_remove(arg_heap, arg_node)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamExternData {
    pub value: Datum,
    pub isnull: bool,
    pub pflags: uint16,
    pub ptype: Oid,
}
impl Default for ParamExternData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ParamListInfo = *mut ParamListInfoData;
pub type ParamFetchHook = ::std::option::Option<
    unsafe extern "C" fn(
        params: ParamListInfo,
        paramid: ::std::os::raw::c_int,
        speculative: bool,
        workspace: *mut ParamExternData,
    ) -> *mut ParamExternData,
>;
pub type ParamCompileHook = ::std::option::Option<
    unsafe extern "C" fn(
        params: ParamListInfo,
        param: *mut Param,
        state: *mut ExprState,
        resv: *mut Datum,
        resnull: *mut bool,
    ),
>;
pub type ParserSetupHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, arg: *mut ::std::os::raw::c_void),
>;
#[repr(C)]
#[derive(Debug)]
pub struct ParamListInfoData {
    pub paramFetch: ParamFetchHook,
    pub paramFetchArg: *mut ::std::os::raw::c_void,
    pub paramCompile: ParamCompileHook,
    pub paramCompileArg: *mut ::std::os::raw::c_void,
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::std::os::raw::c_void,
    pub paramValuesStr: *mut ::std::os::raw::c_char,
    pub numParams: ::std::os::raw::c_int,
    pub params: __IncompleteArrayField<ParamExternData>,
}
impl Default for ParamListInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamExecData {
    pub execPlan: *mut ::std::os::raw::c_void,
    pub value: Datum,
    pub isnull: bool,
}
impl Default for ParamExecData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamsErrorCbData {
    pub portalName: *const ::std::os::raw::c_char,
    pub params: ParamListInfo,
}
impl Default for ParamsErrorCbData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn makeParamList(arg_numParams: ::std::os::raw::c_int) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeParamList(arg_numParams: ::std::os::raw::c_int) -> ParamListInfo;
        }
        makeParamList(arg_numParams)
    })
}
pub unsafe fn copyParamList(arg_from: ParamListInfo) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn copyParamList(arg_from: ParamListInfo) -> ParamListInfo;
        }
        copyParamList(arg_from)
    })
}
pub unsafe fn EstimateParamListSpace(arg_paramLI: ParamListInfo) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EstimateParamListSpace(arg_paramLI: ParamListInfo) -> Size;
        }
        EstimateParamListSpace(arg_paramLI)
    })
}
pub unsafe fn SerializeParamList(
    arg_paramLI: ParamListInfo,
    arg_start_address: *mut *mut ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SerializeParamList(
                arg_paramLI: ParamListInfo,
                arg_start_address: *mut *mut ::std::os::raw::c_char,
            );
        }
        SerializeParamList(arg_paramLI, arg_start_address)
    })
}
pub unsafe fn RestoreParamList(
    arg_start_address: *mut *mut ::std::os::raw::c_char,
) -> ParamListInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RestoreParamList(
                arg_start_address: *mut *mut ::std::os::raw::c_char,
            ) -> ParamListInfo;
        }
        RestoreParamList(arg_start_address)
    })
}
pub unsafe fn BuildParamLogString(
    arg_params: ParamListInfo,
    arg_paramTextValues: *mut *mut ::std::os::raw::c_char,
    arg_valueLen: ::std::os::raw::c_int,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildParamLogString(
                arg_params: ParamListInfo,
                arg_paramTextValues: *mut *mut ::std::os::raw::c_char,
                arg_valueLen: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_char;
        }
        BuildParamLogString(arg_params, arg_paramTextValues, arg_valueLen)
    })
}
pub unsafe fn ParamsErrorCallback(arg_arg: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ParamsErrorCallback(arg_arg: *mut ::std::os::raw::c_void);
        }
        ParamsErrorCallback(arg_arg)
    })
}
pub const ScanDirection_BackwardScanDirection: ScanDirection = -1;
pub const ScanDirection_NoMovementScanDirection: ScanDirection = 0;
pub const ScanDirection_ForwardScanDirection: ScanDirection = 1;
pub type ScanDirection = ::std::os::raw::c_int;
pub type StrategyNumber = uint16;
pub const LockClauseStrength_LCS_NONE: LockClauseStrength = 0;
pub const LockClauseStrength_LCS_FORKEYSHARE: LockClauseStrength = 1;
pub const LockClauseStrength_LCS_FORSHARE: LockClauseStrength = 2;
pub const LockClauseStrength_LCS_FORNOKEYUPDATE: LockClauseStrength = 3;
pub const LockClauseStrength_LCS_FORUPDATE: LockClauseStrength = 4;
pub type LockClauseStrength = ::std::os::raw::c_uint;
pub const LockWaitPolicy_LockWaitBlock: LockWaitPolicy = 0;
pub const LockWaitPolicy_LockWaitSkip: LockWaitPolicy = 1;
pub const LockWaitPolicy_LockWaitError: LockWaitPolicy = 2;
pub type LockWaitPolicy = ::std::os::raw::c_uint;
pub const LockTupleMode_LockTupleKeyShare: LockTupleMode = 0;
pub const LockTupleMode_LockTupleShare: LockTupleMode = 1;
pub const LockTupleMode_LockTupleNoKeyExclusive: LockTupleMode = 2;
pub const LockTupleMode_LockTupleExclusive: LockTupleMode = 3;
pub type LockTupleMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Alias {
    pub type_: NodeTag,
    pub aliasname: *mut ::std::os::raw::c_char,
    pub colnames: *mut List,
}
impl Default for Alias {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const OnCommitAction_ONCOMMIT_NOOP: OnCommitAction = 0;
pub const OnCommitAction_ONCOMMIT_PRESERVE_ROWS: OnCommitAction = 1;
pub const OnCommitAction_ONCOMMIT_DELETE_ROWS: OnCommitAction = 2;
pub const OnCommitAction_ONCOMMIT_DROP: OnCommitAction = 3;
pub type OnCommitAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeVar {
    pub type_: NodeTag,
    pub catalogname: *mut ::std::os::raw::c_char,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub relname: *mut ::std::os::raw::c_char,
    pub inh: bool,
    pub relpersistence: ::std::os::raw::c_char,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeVar {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFunc {
    pub type_: NodeTag,
    pub ns_uris: *mut List,
    pub ns_names: *mut List,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub colnames: *mut List,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub notnulls: *mut Bitmapset,
    pub ordinalitycol: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for TableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IntoClause {
    pub type_: NodeTag,
    pub rel: *mut RangeVar,
    pub colNames: *mut List,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub onCommit: OnCommitAction,
    pub tableSpaceName: *mut ::std::os::raw::c_char,
    pub viewQuery: *mut Node,
    pub skipData: bool,
}
impl Default for IntoClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Expr {
    pub type_: NodeTag,
}
impl Default for Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Var {
    pub xpr: Expr,
    pub varno: Index,
    pub varattno: AttrNumber,
    pub vartype: Oid,
    pub vartypmod: int32,
    pub varcollid: Oid,
    pub varlevelsup: Index,
    pub varnosyn: Index,
    pub varattnosyn: AttrNumber,
    pub location: ::std::os::raw::c_int,
}
impl Default for Var {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Const {
    pub xpr: Expr,
    pub consttype: Oid,
    pub consttypmod: int32,
    pub constcollid: Oid,
    pub constlen: ::std::os::raw::c_int,
    pub constvalue: Datum,
    pub constisnull: bool,
    pub constbyval: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ParamKind_PARAM_EXTERN: ParamKind = 0;
pub const ParamKind_PARAM_EXEC: ParamKind = 1;
pub const ParamKind_PARAM_SUBLINK: ParamKind = 2;
pub const ParamKind_PARAM_MULTIEXPR: ParamKind = 3;
pub type ParamKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Param {
    pub xpr: Expr,
    pub paramkind: ParamKind,
    pub paramid: ::std::os::raw::c_int,
    pub paramtype: Oid,
    pub paramtypmod: int32,
    pub paramcollid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for Param {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Aggref {
    pub xpr: Expr,
    pub aggfnoid: Oid,
    pub aggtype: Oid,
    pub aggcollid: Oid,
    pub inputcollid: Oid,
    pub aggtranstype: Oid,
    pub aggargtypes: *mut List,
    pub aggdirectargs: *mut List,
    pub args: *mut List,
    pub aggorder: *mut List,
    pub aggdistinct: *mut List,
    pub aggfilter: *mut Expr,
    pub aggstar: bool,
    pub aggvariadic: bool,
    pub aggkind: ::std::os::raw::c_char,
    pub agglevelsup: Index,
    pub aggsplit: AggSplit,
    pub location: ::std::os::raw::c_int,
}
impl Default for Aggref {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingFunc {
    pub xpr: Expr,
    pub args: *mut List,
    pub refs: *mut List,
    pub cols: *mut List,
    pub agglevelsup: Index,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFunc {
    pub xpr: Expr,
    pub winfnoid: Oid,
    pub wintype: Oid,
    pub wincollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub aggfilter: *mut Expr,
    pub winref: Index,
    pub winstar: bool,
    pub winagg: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubscriptingRef {
    pub xpr: Expr,
    pub refcontainertype: Oid,
    pub refelemtype: Oid,
    pub reftypmod: int32,
    pub refcollid: Oid,
    pub refupperindexpr: *mut List,
    pub reflowerindexpr: *mut List,
    pub refexpr: *mut Expr,
    pub refassgnexpr: *mut Expr,
}
impl Default for SubscriptingRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CoercionContext_COERCION_IMPLICIT: CoercionContext = 0;
pub const CoercionContext_COERCION_ASSIGNMENT: CoercionContext = 1;
pub const CoercionContext_COERCION_EXPLICIT: CoercionContext = 2;
pub type CoercionContext = ::std::os::raw::c_uint;
pub const CoercionForm_COERCE_EXPLICIT_CALL: CoercionForm = 0;
pub const CoercionForm_COERCE_EXPLICIT_CAST: CoercionForm = 1;
pub const CoercionForm_COERCE_IMPLICIT_CAST: CoercionForm = 2;
pub type CoercionForm = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncExpr {
    pub xpr: Expr,
    pub funcid: Oid,
    pub funcresulttype: Oid,
    pub funcretset: bool,
    pub funcvariadic: bool,
    pub funcformat: CoercionForm,
    pub funccollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedArgExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub name: *mut ::std::os::raw::c_char,
    pub argnumber: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for NamedArgExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub opresulttype: Oid,
    pub opretset: bool,
    pub opcollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for OpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type DistinctExpr = OpExpr;
pub type NullIfExpr = OpExpr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScalarArrayOpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub useOr: bool,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ScalarArrayOpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolExprType_AND_EXPR: BoolExprType = 0;
pub const BoolExprType_OR_EXPR: BoolExprType = 1;
pub const BoolExprType_NOT_EXPR: BoolExprType = 2;
pub type BoolExprType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoolExpr {
    pub xpr: Expr,
    pub boolop: BoolExprType,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for BoolExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SubLinkType_EXISTS_SUBLINK: SubLinkType = 0;
pub const SubLinkType_ALL_SUBLINK: SubLinkType = 1;
pub const SubLinkType_ANY_SUBLINK: SubLinkType = 2;
pub const SubLinkType_ROWCOMPARE_SUBLINK: SubLinkType = 3;
pub const SubLinkType_EXPR_SUBLINK: SubLinkType = 4;
pub const SubLinkType_MULTIEXPR_SUBLINK: SubLinkType = 5;
pub const SubLinkType_ARRAY_SUBLINK: SubLinkType = 6;
pub const SubLinkType_CTE_SUBLINK: SubLinkType = 7;
pub type SubLinkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubLink {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub subLinkId: ::std::os::raw::c_int,
    pub testexpr: *mut Node,
    pub operName: *mut List,
    pub subselect: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for SubLink {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlan {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub testexpr: *mut Node,
    pub paramIds: *mut List,
    pub plan_id: ::std::os::raw::c_int,
    pub plan_name: *mut ::std::os::raw::c_char,
    pub firstColType: Oid,
    pub firstColTypmod: int32,
    pub firstColCollation: Oid,
    pub useHashTable: bool,
    pub unknownEqFalse: bool,
    pub parallel_safe: bool,
    pub setParam: *mut List,
    pub parParam: *mut List,
    pub args: *mut List,
    pub startup_cost: Cost,
    pub per_call_cost: Cost,
}
impl Default for SubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlan {
    pub xpr: Expr,
    pub subplans: *mut List,
}
impl Default for AlternativeSubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldSelect {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub fieldnum: AttrNumber,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
}
impl Default for FieldSelect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldStore {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub newvals: *mut List,
    pub fieldnums: *mut List,
    pub resulttype: Oid,
}
impl Default for FieldStore {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelabelType {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub relabelformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for RelabelType {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceViaIO {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceViaIO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayCoerceExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub elemexpr: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayCoerceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConvertRowtypeExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub convertformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ConvertRowtypeExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub collOid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseExpr {
    pub xpr: Expr,
    pub casetype: Oid,
    pub casecollid: Oid,
    pub arg: *mut Expr,
    pub args: *mut List,
    pub defresult: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseWhen {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub result: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseWhen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseTestExpr {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
}
impl Default for CaseTestExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayExpr {
    pub xpr: Expr,
    pub array_typeid: Oid,
    pub array_collid: Oid,
    pub element_typeid: Oid,
    pub elements: *mut List,
    pub multidims: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowExpr {
    pub xpr: Expr,
    pub args: *mut List,
    pub row_typeid: Oid,
    pub row_format: CoercionForm,
    pub colnames: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for RowExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowCompareType_ROWCOMPARE_LT: RowCompareType = 1;
pub const RowCompareType_ROWCOMPARE_LE: RowCompareType = 2;
pub const RowCompareType_ROWCOMPARE_EQ: RowCompareType = 3;
pub const RowCompareType_ROWCOMPARE_GE: RowCompareType = 4;
pub const RowCompareType_ROWCOMPARE_GT: RowCompareType = 5;
pub const RowCompareType_ROWCOMPARE_NE: RowCompareType = 6;
pub type RowCompareType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowCompareExpr {
    pub xpr: Expr,
    pub rctype: RowCompareType,
    pub opnos: *mut List,
    pub opfamilies: *mut List,
    pub inputcollids: *mut List,
    pub largs: *mut List,
    pub rargs: *mut List,
}
impl Default for RowCompareExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoalesceExpr {
    pub xpr: Expr,
    pub coalescetype: Oid,
    pub coalescecollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoalesceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MinMaxOp_IS_GREATEST: MinMaxOp = 0;
pub const MinMaxOp_IS_LEAST: MinMaxOp = 1;
pub type MinMaxOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinMaxExpr {
    pub xpr: Expr,
    pub minmaxtype: Oid,
    pub minmaxcollid: Oid,
    pub inputcollid: Oid,
    pub op: MinMaxOp,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for MinMaxExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SQLValueFunctionOp_SVFOP_CURRENT_DATE: SQLValueFunctionOp = 0;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME: SQLValueFunctionOp = 1;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME_N: SQLValueFunctionOp = 2;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP: SQLValueFunctionOp = 3;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP_N: SQLValueFunctionOp = 4;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME: SQLValueFunctionOp = 5;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME_N: SQLValueFunctionOp = 6;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP: SQLValueFunctionOp = 7;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP_N: SQLValueFunctionOp = 8;
pub const SQLValueFunctionOp_SVFOP_CURRENT_ROLE: SQLValueFunctionOp = 9;
pub const SQLValueFunctionOp_SVFOP_CURRENT_USER: SQLValueFunctionOp = 10;
pub const SQLValueFunctionOp_SVFOP_USER: SQLValueFunctionOp = 11;
pub const SQLValueFunctionOp_SVFOP_SESSION_USER: SQLValueFunctionOp = 12;
pub const SQLValueFunctionOp_SVFOP_CURRENT_CATALOG: SQLValueFunctionOp = 13;
pub const SQLValueFunctionOp_SVFOP_CURRENT_SCHEMA: SQLValueFunctionOp = 14;
pub type SQLValueFunctionOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SQLValueFunction {
    pub xpr: Expr,
    pub op: SQLValueFunctionOp,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for SQLValueFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const XmlExprOp_IS_XMLCONCAT: XmlExprOp = 0;
pub const XmlExprOp_IS_XMLELEMENT: XmlExprOp = 1;
pub const XmlExprOp_IS_XMLFOREST: XmlExprOp = 2;
pub const XmlExprOp_IS_XMLPARSE: XmlExprOp = 3;
pub const XmlExprOp_IS_XMLPI: XmlExprOp = 4;
pub const XmlExprOp_IS_XMLROOT: XmlExprOp = 5;
pub const XmlExprOp_IS_XMLSERIALIZE: XmlExprOp = 6;
pub const XmlExprOp_IS_DOCUMENT: XmlExprOp = 7;
pub type XmlExprOp = ::std::os::raw::c_uint;
pub const XmlOptionType_XMLOPTION_DOCUMENT: XmlOptionType = 0;
pub const XmlOptionType_XMLOPTION_CONTENT: XmlOptionType = 1;
pub type XmlOptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlExpr {
    pub xpr: Expr,
    pub op: XmlExprOp,
    pub name: *mut ::std::os::raw::c_char,
    pub named_args: *mut List,
    pub arg_names: *mut List,
    pub args: *mut List,
    pub xmloption: XmlOptionType,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const NullTestType_IS_NULL: NullTestType = 0;
pub const NullTestType_IS_NOT_NULL: NullTestType = 1;
pub type NullTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NullTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub nulltesttype: NullTestType,
    pub argisrow: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for NullTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolTestType_IS_TRUE: BoolTestType = 0;
pub const BoolTestType_IS_NOT_TRUE: BoolTestType = 1;
pub const BoolTestType_IS_FALSE: BoolTestType = 2;
pub const BoolTestType_IS_NOT_FALSE: BoolTestType = 3;
pub const BoolTestType_IS_UNKNOWN: BoolTestType = 4;
pub const BoolTestType_IS_NOT_UNKNOWN: BoolTestType = 5;
pub type BoolTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BooleanTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub booltesttype: BoolTestType,
    pub location: ::std::os::raw::c_int,
}
impl Default for BooleanTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomain {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coercionformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomain {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomainValue {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomainValue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetToDefault {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for SetToDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CurrentOfExpr {
    pub xpr: Expr,
    pub cvarno: Index,
    pub cursor_name: *mut ::std::os::raw::c_char,
    pub cursor_param: ::std::os::raw::c_int,
}
impl Default for CurrentOfExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NextValueExpr {
    pub xpr: Expr,
    pub seqid: Oid,
    pub typeId: Oid,
}
impl Default for NextValueExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferenceElem {
    pub xpr: Expr,
    pub expr: *mut Node,
    pub infercollid: Oid,
    pub inferopclass: Oid,
}
impl Default for InferenceElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TargetEntry {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub resno: AttrNumber,
    pub resname: *mut ::std::os::raw::c_char,
    pub ressortgroupref: Index,
    pub resorigtbl: Oid,
    pub resorigcol: AttrNumber,
    pub resjunk: bool,
}
impl Default for TargetEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblRef {
    pub type_: NodeTag,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for RangeTblRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinExpr {
    pub type_: NodeTag,
    pub jointype: JoinType,
    pub isNatural: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub usingClause: *mut List,
    pub quals: *mut Node,
    pub alias: *mut Alias,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for JoinExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FromExpr {
    pub type_: NodeTag,
    pub fromlist: *mut List,
    pub quals: *mut Node,
}
impl Default for FromExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictExpr {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub arbiterElems: *mut List,
    pub arbiterWhere: *mut Node,
    pub constraint: Oid,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelIndex: ::std::os::raw::c_int,
    pub exclRelTlist: *mut List,
}
impl Default for OnConflictExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannedStmt {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub queryId: uint64,
    pub hasReturning: bool,
    pub hasModifyingCTE: bool,
    pub canSetTag: bool,
    pub transientPlan: bool,
    pub dependsOnRole: bool,
    pub parallelModeNeeded: bool,
    pub jitFlags: ::std::os::raw::c_int,
    pub planTree: *mut Plan,
    pub rtable: *mut List,
    pub resultRelations: *mut List,
    pub rootResultRelations: *mut List,
    pub appendRelations: *mut List,
    pub subplans: *mut List,
    pub rewindPlanIDs: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub paramExecTypes: *mut List,
    pub utilityStmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for PlannedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Plan {
    pub type_: NodeTag,
    pub startup_cost: Cost,
    pub total_cost: Cost,
    pub plan_rows: f64,
    pub plan_width: ::std::os::raw::c_int,
    pub parallel_aware: bool,
    pub parallel_safe: bool,
    pub plan_node_id: ::std::os::raw::c_int,
    pub targetlist: *mut List,
    pub qual: *mut List,
    pub lefttree: *mut Plan,
    pub righttree: *mut Plan,
    pub initPlan: *mut List,
    pub extParam: *mut Bitmapset,
    pub allParam: *mut Bitmapset,
}
impl Default for Plan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Result {
    pub plan: Plan,
    pub resconstantqual: *mut Node,
}
impl Default for Result {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSet {
    pub plan: Plan,
}
impl Default for ProjectSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTable {
    pub plan: Plan,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub nominalRelation: Index,
    pub rootRelation: Index,
    pub partColsUpdated: bool,
    pub resultRelations: *mut List,
    pub resultRelIndex: ::std::os::raw::c_int,
    pub rootResultRelIndex: ::std::os::raw::c_int,
    pub plans: *mut List,
    pub withCheckOptionLists: *mut List,
    pub returningLists: *mut List,
    pub fdwPrivLists: *mut List,
    pub fdwDirectModifyPlans: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
    pub onConflictAction: OnConflictAction,
    pub arbiterIndexes: *mut List,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelRTI: Index,
    pub exclRelTlist: *mut List,
}
impl Default for ModifyTable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Append {
    pub plan: Plan,
    pub apprelids: *mut Bitmapset,
    pub appendplans: *mut List,
    pub first_partial_plan: ::std::os::raw::c_int,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for Append {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppend {
    pub plan: Plan,
    pub apprelids: *mut Bitmapset,
    pub mergeplans: *mut List,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for MergeAppend {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnion {
    pub plan: Plan,
    pub wtParam: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for RecursiveUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAnd {
    pub plan: Plan,
    pub bitmapplans: *mut List,
}
impl Default for BitmapAnd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOr {
    pub plan: Plan,
    pub isshared: bool,
    pub bitmapplans: *mut List,
}
impl Default for BitmapOr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Scan {
    pub plan: Plan,
    pub scanrelid: Index,
}
impl Default for Scan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SeqScan = Scan;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScan {
    pub scan: Scan,
    pub tablesample: *mut TableSampleClause,
}
impl Default for SampleScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
    pub indexorderby: *mut List,
    pub indexorderbyorig: *mut List,
    pub indexorderbyops: *mut List,
    pub indexorderdir: ScanDirection,
}
impl Default for IndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexorderby: *mut List,
    pub indextlist: *mut List,
    pub indexorderdir: ScanDirection,
    pub recheckqual: *mut List,
}
impl Default for IndexOnlyScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub isshared: bool,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
}
impl Default for BitmapIndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScan {
    pub scan: Scan,
    pub bitmapqualorig: *mut List,
}
impl Default for BitmapHeapScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScan {
    pub scan: Scan,
    pub tidquals: *mut List,
}
impl Default for TidScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScan {
    pub scan: Scan,
    pub subplan: *mut Plan,
}
impl Default for SubqueryScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScan {
    pub scan: Scan,
    pub functions: *mut List,
    pub funcordinality: bool,
}
impl Default for FunctionScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScan {
    pub scan: Scan,
    pub values_lists: *mut List,
}
impl Default for ValuesScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScan {
    pub scan: Scan,
    pub tablefunc: *mut TableFunc,
}
impl Default for TableFuncScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScan {
    pub scan: Scan,
    pub ctePlanId: ::std::os::raw::c_int,
    pub cteParam: ::std::os::raw::c_int,
}
impl Default for CteScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScan {
    pub scan: Scan,
    pub enrname: *mut ::std::os::raw::c_char,
}
impl Default for NamedTuplestoreScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScan {
    pub scan: Scan,
    pub wtParam: ::std::os::raw::c_int,
}
impl Default for WorkTableScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScan {
    pub scan: Scan,
    pub operation: CmdType,
    pub fs_server: Oid,
    pub fdw_exprs: *mut List,
    pub fdw_private: *mut List,
    pub fdw_scan_tlist: *mut List,
    pub fdw_recheck_quals: *mut List,
    pub fs_relids: *mut Bitmapset,
    pub fsSystemCol: bool,
}
impl Default for ForeignScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScan {
    pub scan: Scan,
    pub flags: uint32,
    pub custom_plans: *mut List,
    pub custom_exprs: *mut List,
    pub custom_private: *mut List,
    pub custom_scan_tlist: *mut List,
    pub custom_relids: *mut Bitmapset,
    pub methods: *const CustomScanMethods,
}
impl Default for CustomScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Join {
    pub plan: Plan,
    pub jointype: JoinType,
    pub inner_unique: bool,
    pub joinqual: *mut List,
}
impl Default for Join {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoop {
    pub join: Join,
    pub nestParams: *mut List,
}
impl Default for NestLoop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopParam {
    pub type_: NodeTag,
    pub paramno: ::std::os::raw::c_int,
    pub paramval: *mut Var,
}
impl Default for NestLoopParam {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoin {
    pub join: Join,
    pub skip_mark_restore: bool,
    pub mergeclauses: *mut List,
    pub mergeFamilies: *mut Oid,
    pub mergeCollations: *mut Oid,
    pub mergeStrategies: *mut ::std::os::raw::c_int,
    pub mergeNullsFirst: *mut bool,
}
impl Default for MergeJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoin {
    pub join: Join,
    pub hashclauses: *mut List,
    pub hashoperators: *mut List,
    pub hashcollations: *mut List,
    pub hashkeys: *mut List,
}
impl Default for HashJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Material {
    pub plan: Plan,
}
impl Default for Material {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sort {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
}
impl Default for Sort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSort {
    pub sort: Sort,
    pub nPresortedCols: ::std::os::raw::c_int,
}
impl Default for IncrementalSort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Group {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
}
impl Default for Group {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Agg {
    pub plan: Plan,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
    pub transitionSpace: uint64,
    pub aggParams: *mut Bitmapset,
    pub groupingSets: *mut List,
    pub chain: *mut List,
}
impl Default for Agg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAgg {
    pub plan: Plan,
    pub winref: Index,
    pub partNumCols: ::std::os::raw::c_int,
    pub partColIdx: *mut AttrNumber,
    pub partOperators: *mut Oid,
    pub partCollations: *mut Oid,
    pub ordNumCols: ::std::os::raw::c_int,
    pub ordColIdx: *mut AttrNumber,
    pub ordOperators: *mut Oid,
    pub ordCollations: *mut Oid,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
}
impl Default for WindowAgg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Unique {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Unique {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Gather {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub single_copy: bool,
    pub invisible: bool,
    pub initParam: *mut Bitmapset,
}
impl Default for Gather {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMerge {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub initParam: *mut Bitmapset,
}
impl Default for GatherMerge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Hash {
    pub plan: Plan,
    pub hashkeys: *mut List,
    pub skewTable: Oid,
    pub skewColumn: AttrNumber,
    pub skewInherit: bool,
    pub rows_total: f64,
}
impl Default for Hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOp {
    pub plan: Plan,
    pub cmd: SetOpCmd,
    pub strategy: SetOpStrategy,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub flagColIdx: AttrNumber,
    pub firstFlag: ::std::os::raw::c_int,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for SetOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRows {
    pub plan: Plan,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
}
impl Default for LockRows {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Limit {
    pub plan: Plan,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption,
    pub uniqNumCols: ::std::os::raw::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Limit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowMarkType_ROW_MARK_EXCLUSIVE: RowMarkType = 0;
pub const RowMarkType_ROW_MARK_NOKEYEXCLUSIVE: RowMarkType = 1;
pub const RowMarkType_ROW_MARK_SHARE: RowMarkType = 2;
pub const RowMarkType_ROW_MARK_KEYSHARE: RowMarkType = 3;
pub const RowMarkType_ROW_MARK_REFERENCE: RowMarkType = 4;
pub const RowMarkType_ROW_MARK_COPY: RowMarkType = 5;
pub type RowMarkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanRowMark {
    pub type_: NodeTag,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub allMarkTypes: ::std::os::raw::c_int,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub isParent: bool,
}
impl Default for PlanRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneInfo {
    pub type_: NodeTag,
    pub prune_infos: *mut List,
    pub other_subplans: *mut Bitmapset,
}
impl Default for PartitionPruneInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionedRelPruneInfo {
    pub type_: NodeTag,
    pub rtindex: Index,
    pub present_parts: *mut Bitmapset,
    pub nparts: ::std::os::raw::c_int,
    pub subplan_map: *mut ::std::os::raw::c_int,
    pub subpart_map: *mut ::std::os::raw::c_int,
    pub relid_map: *mut Oid,
    pub initial_pruning_steps: *mut List,
    pub exec_pruning_steps: *mut List,
    pub execparamids: *mut Bitmapset,
}
impl Default for PartitionedRelPruneInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStep {
    pub type_: NodeTag,
    pub step_id: ::std::os::raw::c_int,
}
impl Default for PartitionPruneStep {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepOp {
    pub step: PartitionPruneStep,
    pub opstrategy: StrategyNumber,
    pub exprs: *mut List,
    pub cmpfns: *mut List,
    pub nullkeys: *mut Bitmapset,
}
impl Default for PartitionPruneStepOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionPruneCombineOp_PARTPRUNE_COMBINE_UNION: PartitionPruneCombineOp = 0;
pub const PartitionPruneCombineOp_PARTPRUNE_COMBINE_INTERSECT: PartitionPruneCombineOp = 1;
pub type PartitionPruneCombineOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepCombine {
    pub step: PartitionPruneStep,
    pub combineOp: PartitionPruneCombineOp,
    pub source_stepids: *mut List,
}
impl Default for PartitionPruneStepCombine {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanInvalItem {
    pub type_: NodeTag,
    pub cacheId: ::std::os::raw::c_int,
    pub hashValue: uint32,
}
impl Default for PlanInvalItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_flag {
    pub value: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint32 {
    pub value: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint64 {
    pub value: uint64,
}
extern "C" {
    pub static mut dynamic_shared_memory_type: ::std::os::raw::c_int;
}
pub type dsm_handle = uint32;
pub const dsm_op_DSM_OP_CREATE: dsm_op = 0;
pub const dsm_op_DSM_OP_ATTACH: dsm_op = 1;
pub const dsm_op_DSM_OP_DETACH: dsm_op = 2;
pub const dsm_op_DSM_OP_DESTROY: dsm_op = 3;
pub type dsm_op = ::std::os::raw::c_uint;
pub unsafe fn dsm_impl_op(
    arg_op: dsm_op,
    arg_handle: dsm_handle,
    arg_request_size: Size,
    arg_impl_private: *mut *mut ::std::os::raw::c_void,
    arg_mapped_address: *mut *mut ::std::os::raw::c_void,
    arg_mapped_size: *mut Size,
    arg_elevel: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_op(
                arg_op: dsm_op,
                arg_handle: dsm_handle,
                arg_request_size: Size,
                arg_impl_private: *mut *mut ::std::os::raw::c_void,
                arg_mapped_address: *mut *mut ::std::os::raw::c_void,
                arg_mapped_size: *mut Size,
                arg_elevel: ::std::os::raw::c_int,
            ) -> bool;
        }
        dsm_impl_op(
            arg_op,
            arg_handle,
            arg_request_size,
            arg_impl_private,
            arg_mapped_address,
            arg_mapped_size,
            arg_elevel,
        )
    })
}
pub unsafe fn dsm_impl_pin_segment(
    arg_handle: dsm_handle,
    arg_impl_private: *mut ::std::os::raw::c_void,
    arg_impl_private_pm_handle: *mut *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_pin_segment(
                arg_handle: dsm_handle,
                arg_impl_private: *mut ::std::os::raw::c_void,
                arg_impl_private_pm_handle: *mut *mut ::std::os::raw::c_void,
            );
        }
        dsm_impl_pin_segment(arg_handle, arg_impl_private, arg_impl_private_pm_handle)
    })
}
pub unsafe fn dsm_impl_unpin_segment(
    arg_handle: dsm_handle,
    arg_impl_private: *mut *mut ::std::os::raw::c_void,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_impl_unpin_segment(
                arg_handle: dsm_handle,
                arg_impl_private: *mut *mut ::std::os::raw::c_void,
            );
        }
        dsm_impl_unpin_segment(arg_handle, arg_impl_private)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsm_segment {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGShmemHeader {
    _unused: [u8; 0],
}
pub unsafe fn dsm_cleanup_using_control_segment(arg_old_control_handle: dsm_handle) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_cleanup_using_control_segment(arg_old_control_handle: dsm_handle);
        }
        dsm_cleanup_using_control_segment(arg_old_control_handle)
    })
}
pub unsafe fn dsm_postmaster_startup(arg_arg1: *mut PGShmemHeader) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_postmaster_startup(arg_arg1: *mut PGShmemHeader);
        }
        dsm_postmaster_startup(arg_arg1)
    })
}
pub unsafe fn dsm_backend_shutdown() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_backend_shutdown();
        }
        dsm_backend_shutdown()
    })
}
pub unsafe fn dsm_detach_all() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_detach_all();
        }
        dsm_detach_all()
    })
}
pub unsafe fn dsm_create(arg_size: Size, arg_flags: ::std::os::raw::c_int) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_create(arg_size: Size, arg_flags: ::std::os::raw::c_int) -> *mut dsm_segment;
        }
        dsm_create(arg_size, arg_flags)
    })
}
pub unsafe fn dsm_attach(arg_h: dsm_handle) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_attach(arg_h: dsm_handle) -> *mut dsm_segment;
        }
        dsm_attach(arg_h)
    })
}
pub unsafe fn dsm_detach(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_detach(arg_seg: *mut dsm_segment);
        }
        dsm_detach(arg_seg)
    })
}
pub unsafe fn dsm_pin_mapping(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_pin_mapping(arg_seg: *mut dsm_segment);
        }
        dsm_pin_mapping(arg_seg)
    })
}
pub unsafe fn dsm_unpin_mapping(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_unpin_mapping(arg_seg: *mut dsm_segment);
        }
        dsm_unpin_mapping(arg_seg)
    })
}
pub unsafe fn dsm_pin_segment(arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_pin_segment(arg_seg: *mut dsm_segment);
        }
        dsm_pin_segment(arg_seg)
    })
}
pub unsafe fn dsm_unpin_segment(arg_h: dsm_handle) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_unpin_segment(arg_h: dsm_handle);
        }
        dsm_unpin_segment(arg_h)
    })
}
pub unsafe fn dsm_find_mapping(arg_h: dsm_handle) -> *mut dsm_segment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_find_mapping(arg_h: dsm_handle) -> *mut dsm_segment;
        }
        dsm_find_mapping(arg_h)
    })
}
pub unsafe fn dsm_segment_address(arg_seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_address(arg_seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void;
        }
        dsm_segment_address(arg_seg)
    })
}
pub unsafe fn dsm_segment_map_length(arg_seg: *mut dsm_segment) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_map_length(arg_seg: *mut dsm_segment) -> Size;
        }
        dsm_segment_map_length(arg_seg)
    })
}
pub unsafe fn dsm_segment_handle(arg_seg: *mut dsm_segment) -> dsm_handle {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsm_segment_handle(arg_seg: *mut dsm_segment) -> dsm_handle;
        }
        dsm_segment_handle(arg_seg)
    })
}
pub type on_dsm_detach_callback =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut dsm_segment, arg: Datum)>;
pub unsafe fn on_dsm_detach(
    arg_seg: *mut dsm_segment,
    arg_function: on_dsm_detach_callback,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn on_dsm_detach(
                arg_seg: *mut dsm_segment,
                arg_function: on_dsm_detach_callback,
                arg_arg: Datum,
            );
        }
        on_dsm_detach(arg_seg, arg_function, arg_arg)
    })
}
pub unsafe fn cancel_on_dsm_detach(
    arg_seg: *mut dsm_segment,
    arg_function: on_dsm_detach_callback,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn cancel_on_dsm_detach(
                arg_seg: *mut dsm_segment,
                arg_function: on_dsm_detach_callback,
                arg_arg: Datum,
            );
        }
        cancel_on_dsm_detach(arg_seg, arg_function, arg_arg)
    })
}
pub unsafe fn reset_on_dsm_detach() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn reset_on_dsm_detach();
        }
        reset_on_dsm_detach()
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsa_area {
    _unused: [u8; 0],
}
pub type dsa_pointer = uint64;
pub type dsa_pointer_atomic = pg_atomic_uint64;
pub type dsa_handle = dsm_handle;
pub unsafe fn dsa_create(arg_tranche_id: ::std::os::raw::c_int) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_create(arg_tranche_id: ::std::os::raw::c_int) -> *mut dsa_area;
        }
        dsa_create(arg_tranche_id)
    })
}
pub unsafe fn dsa_create_in_place(
    arg_place: *mut ::std::os::raw::c_void,
    arg_size: usize,
    arg_tranche_id: ::std::os::raw::c_int,
    arg_segment: *mut dsm_segment,
) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_create_in_place(
                arg_place: *mut ::std::os::raw::c_void,
                arg_size: usize,
                arg_tranche_id: ::std::os::raw::c_int,
                arg_segment: *mut dsm_segment,
            ) -> *mut dsa_area;
        }
        dsa_create_in_place(arg_place, arg_size, arg_tranche_id, arg_segment)
    })
}
pub unsafe fn dsa_attach(arg_handle: dsa_handle) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_attach(arg_handle: dsa_handle) -> *mut dsa_area;
        }
        dsa_attach(arg_handle)
    })
}
pub unsafe fn dsa_attach_in_place(
    arg_place: *mut ::std::os::raw::c_void,
    arg_segment: *mut dsm_segment,
) -> *mut dsa_area {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_attach_in_place(
                arg_place: *mut ::std::os::raw::c_void,
                arg_segment: *mut dsm_segment,
            ) -> *mut dsa_area;
        }
        dsa_attach_in_place(arg_place, arg_segment)
    })
}
pub unsafe fn dsa_release_in_place(arg_place: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_release_in_place(arg_place: *mut ::std::os::raw::c_void);
        }
        dsa_release_in_place(arg_place)
    })
}
pub unsafe fn dsa_on_dsm_detach_release_in_place(arg_arg1: *mut dsm_segment, arg_arg2: Datum) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_on_dsm_detach_release_in_place(arg_arg1: *mut dsm_segment, arg_arg2: Datum);
        }
        dsa_on_dsm_detach_release_in_place(arg_arg1, arg_arg2)
    })
}
pub unsafe fn dsa_on_shmem_exit_release_in_place(arg_arg1: ::std::os::raw::c_int, arg_arg2: Datum) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_on_shmem_exit_release_in_place(arg_arg1: ::std::os::raw::c_int, arg_arg2: Datum);
        }
        dsa_on_shmem_exit_release_in_place(arg_arg1, arg_arg2)
    })
}
pub unsafe fn dsa_pin_mapping(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_pin_mapping(arg_area: *mut dsa_area);
        }
        dsa_pin_mapping(arg_area)
    })
}
pub unsafe fn dsa_detach(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_detach(arg_area: *mut dsa_area);
        }
        dsa_detach(arg_area)
    })
}
pub unsafe fn dsa_pin(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_pin(arg_area: *mut dsa_area);
        }
        dsa_pin(arg_area)
    })
}
pub unsafe fn dsa_unpin(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_unpin(arg_area: *mut dsa_area);
        }
        dsa_unpin(arg_area)
    })
}
pub unsafe fn dsa_set_size_limit(arg_area: *mut dsa_area, arg_limit: usize) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_set_size_limit(arg_area: *mut dsa_area, arg_limit: usize);
        }
        dsa_set_size_limit(arg_area, arg_limit)
    })
}
pub unsafe fn dsa_minimum_size() -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_minimum_size() -> usize;
        }
        dsa_minimum_size()
    })
}
pub unsafe fn dsa_get_handle(arg_area: *mut dsa_area) -> dsa_handle {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_get_handle(arg_area: *mut dsa_area) -> dsa_handle;
        }
        dsa_get_handle(arg_area)
    })
}
pub unsafe fn dsa_allocate_extended(
    arg_area: *mut dsa_area,
    arg_size: usize,
    arg_flags: ::std::os::raw::c_int,
) -> dsa_pointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_allocate_extended(
                arg_area: *mut dsa_area,
                arg_size: usize,
                arg_flags: ::std::os::raw::c_int,
            ) -> dsa_pointer;
        }
        dsa_allocate_extended(arg_area, arg_size, arg_flags)
    })
}
pub unsafe fn dsa_free(arg_area: *mut dsa_area, arg_dp: dsa_pointer) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_free(arg_area: *mut dsa_area, arg_dp: dsa_pointer);
        }
        dsa_free(arg_area, arg_dp)
    })
}
pub unsafe fn dsa_get_address(
    arg_area: *mut dsa_area,
    arg_dp: dsa_pointer,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_get_address(
                arg_area: *mut dsa_area,
                arg_dp: dsa_pointer,
            ) -> *mut ::std::os::raw::c_void;
        }
        dsa_get_address(arg_area, arg_dp)
    })
}
pub unsafe fn dsa_trim(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_trim(arg_area: *mut dsa_area);
        }
        dsa_trim(arg_area)
    })
}
pub unsafe fn dsa_dump(arg_area: *mut dsa_area) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn dsa_dump(arg_area: *mut dsa_area);
        }
        dsa_dump(arg_area)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TIDBitmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMSharedIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TBMIterateResult {
    pub blockno: BlockNumber,
    pub ntuples: ::std::os::raw::c_int,
    pub recheck: bool,
    pub offsets: __IncompleteArrayField<OffsetNumber>,
}
pub unsafe fn tbm_create(
    arg_maxbytes: ::std::os::raw::c_long,
    arg_dsa: *mut dsa_area,
) -> *mut TIDBitmap {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_create(
                arg_maxbytes: ::std::os::raw::c_long,
                arg_dsa: *mut dsa_area,
            ) -> *mut TIDBitmap;
        }
        tbm_create(arg_maxbytes, arg_dsa)
    })
}
pub unsafe fn tbm_free(arg_tbm: *mut TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_free(arg_tbm: *mut TIDBitmap);
        }
        tbm_free(arg_tbm)
    })
}
pub unsafe fn tbm_free_shared_area(arg_dsa: *mut dsa_area, arg_dp: dsa_pointer) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_free_shared_area(arg_dsa: *mut dsa_area, arg_dp: dsa_pointer);
        }
        tbm_free_shared_area(arg_dsa, arg_dp)
    })
}
pub unsafe fn tbm_add_tuples(
    arg_tbm: *mut TIDBitmap,
    arg_tids: ItemPointer,
    arg_ntids: ::std::os::raw::c_int,
    arg_recheck: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_add_tuples(
                arg_tbm: *mut TIDBitmap,
                arg_tids: ItemPointer,
                arg_ntids: ::std::os::raw::c_int,
                arg_recheck: bool,
            );
        }
        tbm_add_tuples(arg_tbm, arg_tids, arg_ntids, arg_recheck)
    })
}
pub unsafe fn tbm_add_page(arg_tbm: *mut TIDBitmap, arg_pageno: BlockNumber) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_add_page(arg_tbm: *mut TIDBitmap, arg_pageno: BlockNumber);
        }
        tbm_add_page(arg_tbm, arg_pageno)
    })
}
pub unsafe fn tbm_union(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_union(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap);
        }
        tbm_union(arg_a, arg_b)
    })
}
pub unsafe fn tbm_intersect(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_intersect(arg_a: *mut TIDBitmap, arg_b: *const TIDBitmap);
        }
        tbm_intersect(arg_a, arg_b)
    })
}
pub unsafe fn tbm_is_empty(arg_tbm: *const TIDBitmap) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_is_empty(arg_tbm: *const TIDBitmap) -> bool;
        }
        tbm_is_empty(arg_tbm)
    })
}
pub unsafe fn tbm_begin_iterate(arg_tbm: *mut TIDBitmap) -> *mut TBMIterator {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_begin_iterate(arg_tbm: *mut TIDBitmap) -> *mut TBMIterator;
        }
        tbm_begin_iterate(arg_tbm)
    })
}
pub unsafe fn tbm_prepare_shared_iterate(arg_tbm: *mut TIDBitmap) -> dsa_pointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_prepare_shared_iterate(arg_tbm: *mut TIDBitmap) -> dsa_pointer;
        }
        tbm_prepare_shared_iterate(arg_tbm)
    })
}
pub unsafe fn tbm_iterate(arg_iterator: *mut TBMIterator) -> *mut TBMIterateResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_iterate(arg_iterator: *mut TBMIterator) -> *mut TBMIterateResult;
        }
        tbm_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_shared_iterate(arg_iterator: *mut TBMSharedIterator) -> *mut TBMIterateResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_shared_iterate(arg_iterator: *mut TBMSharedIterator) -> *mut TBMIterateResult;
        }
        tbm_shared_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_end_iterate(arg_iterator: *mut TBMIterator) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_end_iterate(arg_iterator: *mut TBMIterator);
        }
        tbm_end_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_end_shared_iterate(arg_iterator: *mut TBMSharedIterator) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_end_shared_iterate(arg_iterator: *mut TBMSharedIterator);
        }
        tbm_end_shared_iterate(arg_iterator)
    })
}
pub unsafe fn tbm_attach_shared_iterate(
    arg_dsa: *mut dsa_area,
    arg_dp: dsa_pointer,
) -> *mut TBMSharedIterator {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_attach_shared_iterate(
                arg_dsa: *mut dsa_area,
                arg_dp: dsa_pointer,
            ) -> *mut TBMSharedIterator;
        }
        tbm_attach_shared_iterate(arg_dsa, arg_dp)
    })
}
pub unsafe fn tbm_calculate_entries(arg_maxbytes: f64) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tbm_calculate_entries(arg_maxbytes: f64) -> ::std::os::raw::c_long;
        }
        tbm_calculate_entries(arg_maxbytes)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundInfoData {
    _unused: [u8; 0],
}
pub type PartitionBoundInfo = *mut PartitionBoundInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionKeyData {
    _unused: [u8; 0],
}
pub type PartitionKey = *mut PartitionKeyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDescData {
    _unused: [u8; 0],
}
pub type PartitionDesc = *mut PartitionDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDirectoryData {
    _unused: [u8; 0],
}
pub type PartitionDirectory = *mut PartitionDirectoryData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_node {
    pub next: ::std::os::raw::c_int,
    pub prev: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_head {
    pub head: ::std::os::raw::c_int,
    pub tail: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_mutable_iter {
    pub cur: ::std::os::raw::c_int,
    pub next: ::std::os::raw::c_int,
}
pub type slock_t = ::std::os::raw::c_uchar;
extern "C" {
    pub static mut dummy_spinlock: slock_t;
}
pub unsafe fn s_lock(
    arg_lock: *mut slock_t,
    arg_file: *const ::std::os::raw::c_char,
    arg_line: ::std::os::raw::c_int,
    arg_func: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn s_lock(
                arg_lock: *mut slock_t,
                arg_file: *const ::std::os::raw::c_char,
                arg_line: ::std::os::raw::c_int,
                arg_func: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        s_lock(arg_lock, arg_file, arg_line, arg_func)
    })
}
pub unsafe fn set_spins_per_delay(arg_shared_spins_per_delay: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_spins_per_delay(arg_shared_spins_per_delay: ::std::os::raw::c_int);
        }
        set_spins_per_delay(arg_shared_spins_per_delay)
    })
}
pub unsafe fn update_spins_per_delay(
    arg_shared_spins_per_delay: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn update_spins_per_delay(
                arg_shared_spins_per_delay: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        update_spins_per_delay(arg_shared_spins_per_delay)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpinDelayStatus {
    pub spins: ::std::os::raw::c_int,
    pub delays: ::std::os::raw::c_int,
    pub cur_delay: ::std::os::raw::c_int,
    pub file: *const ::std::os::raw::c_char,
    pub line: ::std::os::raw::c_int,
    pub func: *const ::std::os::raw::c_char,
}
impl Default for SpinDelayStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn perform_spin_delay(arg_status: *mut SpinDelayStatus) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn perform_spin_delay(arg_status: *mut SpinDelayStatus);
        }
        perform_spin_delay(arg_status)
    })
}
pub unsafe fn finish_spin_delay(arg_status: *mut SpinDelayStatus) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn finish_spin_delay(arg_status: *mut SpinDelayStatus);
        }
        finish_spin_delay(arg_status)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ConditionVariable {
    pub mutex: slock_t,
    pub wakeup: proclist_head,
}
pub unsafe fn ConditionVariableInit(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableInit(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableInit(arg_cv)
    })
}
pub unsafe fn ConditionVariableSleep(arg_cv: *mut ConditionVariable, arg_wait_event_info: uint32) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableSleep(arg_cv: *mut ConditionVariable, arg_wait_event_info: uint32);
        }
        ConditionVariableSleep(arg_cv, arg_wait_event_info)
    })
}
pub unsafe fn ConditionVariableTimedSleep(
    arg_cv: *mut ConditionVariable,
    arg_timeout: ::std::os::raw::c_long,
    arg_wait_event_info: uint32,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableTimedSleep(
                arg_cv: *mut ConditionVariable,
                arg_timeout: ::std::os::raw::c_long,
                arg_wait_event_info: uint32,
            ) -> bool;
        }
        ConditionVariableTimedSleep(arg_cv, arg_timeout, arg_wait_event_info)
    })
}
pub unsafe fn ConditionVariableCancelSleep() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableCancelSleep();
        }
        ConditionVariableCancelSleep()
    })
}
pub unsafe fn ConditionVariablePrepareToSleep(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariablePrepareToSleep(arg_cv: *mut ConditionVariable);
        }
        ConditionVariablePrepareToSleep(arg_cv)
    })
}
pub unsafe fn ConditionVariableSignal(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableSignal(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableSignal(arg_cv)
    })
}
pub unsafe fn ConditionVariableBroadcast(arg_cv: *mut ConditionVariable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ConditionVariableBroadcast(arg_cv: *mut ConditionVariable);
        }
        ConditionVariableBroadcast(arg_cv)
    })
}
pub type HashValueFunc = ::std::option::Option<
    unsafe extern "C" fn(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32,
>;
pub type HashCompareFunc = ::std::option::Option<
    unsafe extern "C" fn(
        key1: *const ::std::os::raw::c_void,
        key2: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> ::std::os::raw::c_int,
>;
pub type HashCopyFunc = ::std::option::Option<
    unsafe extern "C" fn(
        dest: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type HashAllocFunc =
    ::std::option::Option<unsafe extern "C" fn(request: Size) -> *mut ::std::os::raw::c_void>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHELEMENT {
    pub link: *mut HASHELEMENT,
    pub hashvalue: uint32,
}
impl Default for HASHELEMENT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHHDR {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTAB {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHCTL {
    pub num_partitions: ::std::os::raw::c_long,
    pub ssize: ::std::os::raw::c_long,
    pub dsize: ::std::os::raw::c_long,
    pub max_dsize: ::std::os::raw::c_long,
    pub ffactor: ::std::os::raw::c_long,
    pub keysize: Size,
    pub entrysize: Size,
    pub hash: HashValueFunc,
    pub match_: HashCompareFunc,
    pub keycopy: HashCopyFunc,
    pub alloc: HashAllocFunc,
    pub hcxt: MemoryContext,
    pub hctl: *mut HASHHDR,
}
impl Default for HASHCTL {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const HASHACTION_HASH_FIND: HASHACTION = 0;
pub const HASHACTION_HASH_ENTER: HASHACTION = 1;
pub const HASHACTION_HASH_REMOVE: HASHACTION = 2;
pub const HASHACTION_HASH_ENTER_NULL: HASHACTION = 3;
pub type HASHACTION = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASH_SEQ_STATUS {
    pub hashp: *mut HTAB,
    pub curBucket: uint32,
    pub curEntry: *mut HASHELEMENT,
}
impl Default for HASH_SEQ_STATUS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn hash_create(
    arg_tabname: *const ::std::os::raw::c_char,
    arg_nelem: ::std::os::raw::c_long,
    arg_info: *mut HASHCTL,
    arg_flags: ::std::os::raw::c_int,
) -> *mut HTAB {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_create(
                arg_tabname: *const ::std::os::raw::c_char,
                arg_nelem: ::std::os::raw::c_long,
                arg_info: *mut HASHCTL,
                arg_flags: ::std::os::raw::c_int,
            ) -> *mut HTAB;
        }
        hash_create(arg_tabname, arg_nelem, arg_info, arg_flags)
    })
}
pub unsafe fn hash_destroy(arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_destroy(arg_hashp: *mut HTAB);
        }
        hash_destroy(arg_hashp)
    })
}
pub unsafe fn hash_stats(arg_where_: *const ::std::os::raw::c_char, arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_stats(arg_where_: *const ::std::os::raw::c_char, arg_hashp: *mut HTAB);
        }
        hash_stats(arg_where_, arg_hashp)
    })
}
pub unsafe fn hash_search(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
    arg_action: HASHACTION,
    arg_foundPtr: *mut bool,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_search(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
                arg_action: HASHACTION,
                arg_foundPtr: *mut bool,
            ) -> *mut ::std::os::raw::c_void;
        }
        hash_search(arg_hashp, arg_keyPtr, arg_action, arg_foundPtr)
    })
}
pub unsafe fn get_hash_value(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_hash_value(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
            ) -> uint32;
        }
        get_hash_value(arg_hashp, arg_keyPtr)
    })
}
pub unsafe fn hash_search_with_hash_value(
    arg_hashp: *mut HTAB,
    arg_keyPtr: *const ::std::os::raw::c_void,
    arg_hashvalue: uint32,
    arg_action: HASHACTION,
    arg_foundPtr: *mut bool,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_search_with_hash_value(
                arg_hashp: *mut HTAB,
                arg_keyPtr: *const ::std::os::raw::c_void,
                arg_hashvalue: uint32,
                arg_action: HASHACTION,
                arg_foundPtr: *mut bool,
            ) -> *mut ::std::os::raw::c_void;
        }
        hash_search_with_hash_value(arg_hashp, arg_keyPtr, arg_hashvalue, arg_action, arg_foundPtr)
    })
}
pub unsafe fn hash_update_hash_key(
    arg_hashp: *mut HTAB,
    arg_existingEntry: *mut ::std::os::raw::c_void,
    arg_newKeyPtr: *const ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_update_hash_key(
                arg_hashp: *mut HTAB,
                arg_existingEntry: *mut ::std::os::raw::c_void,
                arg_newKeyPtr: *const ::std::os::raw::c_void,
            ) -> bool;
        }
        hash_update_hash_key(arg_hashp, arg_existingEntry, arg_newKeyPtr)
    })
}
pub unsafe fn hash_get_num_entries(arg_hashp: *mut HTAB) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_get_num_entries(arg_hashp: *mut HTAB) -> ::std::os::raw::c_long;
        }
        hash_get_num_entries(arg_hashp)
    })
}
pub unsafe fn hash_seq_init(arg_status: *mut HASH_SEQ_STATUS, arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_init(arg_status: *mut HASH_SEQ_STATUS, arg_hashp: *mut HTAB);
        }
        hash_seq_init(arg_status, arg_hashp)
    })
}
pub unsafe fn hash_seq_search(arg_status: *mut HASH_SEQ_STATUS) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_search(arg_status: *mut HASH_SEQ_STATUS) -> *mut ::std::os::raw::c_void;
        }
        hash_seq_search(arg_status)
    })
}
pub unsafe fn hash_seq_term(arg_status: *mut HASH_SEQ_STATUS) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_seq_term(arg_status: *mut HASH_SEQ_STATUS);
        }
        hash_seq_term(arg_status)
    })
}
pub unsafe fn hash_freeze(arg_hashp: *mut HTAB) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_freeze(arg_hashp: *mut HTAB);
        }
        hash_freeze(arg_hashp)
    })
}
pub unsafe fn hash_estimate_size(
    arg_num_entries: ::std::os::raw::c_long,
    arg_entrysize: Size,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_estimate_size(
                arg_num_entries: ::std::os::raw::c_long,
                arg_entrysize: Size,
            ) -> Size;
        }
        hash_estimate_size(arg_num_entries, arg_entrysize)
    })
}
pub unsafe fn hash_select_dirsize(
    arg_num_entries: ::std::os::raw::c_long,
) -> ::std::os::raw::c_long {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_select_dirsize(
                arg_num_entries: ::std::os::raw::c_long,
            ) -> ::std::os::raw::c_long;
        }
        hash_select_dirsize(arg_num_entries)
    })
}
pub unsafe fn hash_get_shared_size(
    arg_info: *mut HASHCTL,
    arg_flags: ::std::os::raw::c_int,
) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn hash_get_shared_size(
                arg_info: *mut HASHCTL,
                arg_flags: ::std::os::raw::c_int,
            ) -> Size;
        }
        hash_get_shared_size(arg_info, arg_flags)
    })
}
pub unsafe fn AtEOXact_HashTables(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_HashTables(arg_isCommit: bool);
        }
        AtEOXact_HashTables(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_HashTables(arg_isCommit: bool, arg_nestDepth: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_HashTables(arg_isCommit: bool, arg_nestDepth: ::std::os::raw::c_int);
        }
        AtEOSubXact_HashTables(arg_isCommit, arg_nestDepth)
    })
}
pub const EphemeralNameRelationType_ENR_NAMED_TUPLESTORE: EphemeralNameRelationType = 0;
pub type EphemeralNameRelationType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationMetadataData {
    pub name: *mut ::std::os::raw::c_char,
    pub reliddesc: Oid,
    pub tupdesc: TupleDesc,
    pub enrtype: EphemeralNameRelationType,
    pub enrtuples: f64,
}
impl Default for EphemeralNamedRelationMetadataData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelationMetadata = *mut EphemeralNamedRelationMetadataData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationData {
    pub md: EphemeralNamedRelationMetadataData,
    pub reldata: *mut ::std::os::raw::c_void,
}
impl Default for EphemeralNamedRelationData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelation = *mut EphemeralNamedRelationData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryEnvironment {
    _unused: [u8; 0],
}
pub unsafe fn create_queryEnv() -> *mut QueryEnvironment {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn create_queryEnv() -> *mut QueryEnvironment;
        }
        create_queryEnv()
    })
}
pub unsafe fn get_visible_ENR_metadata(
    arg_queryEnv: *mut QueryEnvironment,
    arg_refname: *const ::std::os::raw::c_char,
) -> EphemeralNamedRelationMetadata {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_visible_ENR_metadata(
                arg_queryEnv: *mut QueryEnvironment,
                arg_refname: *const ::std::os::raw::c_char,
            ) -> EphemeralNamedRelationMetadata;
        }
        get_visible_ENR_metadata(arg_queryEnv, arg_refname)
    })
}
pub unsafe fn register_ENR(arg_queryEnv: *mut QueryEnvironment, arg_enr: EphemeralNamedRelation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn register_ENR(arg_queryEnv: *mut QueryEnvironment, arg_enr: EphemeralNamedRelation);
        }
        register_ENR(arg_queryEnv, arg_enr)
    })
}
pub unsafe fn unregister_ENR(
    arg_queryEnv: *mut QueryEnvironment,
    arg_name: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn unregister_ENR(
                arg_queryEnv: *mut QueryEnvironment,
                arg_name: *const ::std::os::raw::c_char,
            );
        }
        unregister_ENR(arg_queryEnv, arg_name)
    })
}
pub unsafe fn get_ENR(
    arg_queryEnv: *mut QueryEnvironment,
    arg_name: *const ::std::os::raw::c_char,
) -> EphemeralNamedRelation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_ENR(
                arg_queryEnv: *mut QueryEnvironment,
                arg_name: *const ::std::os::raw::c_char,
            ) -> EphemeralNamedRelation;
        }
        get_ENR(arg_queryEnv, arg_name)
    })
}
pub unsafe fn ENRMetadataGetTupDesc(arg_enrmd: EphemeralNamedRelationMetadata) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ENRMetadataGetTupDesc(arg_enrmd: EphemeralNamedRelationMetadata) -> TupleDesc;
        }
        ENRMetadataGetTupDesc(arg_enrmd)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Trigger {
    pub tgoid: Oid,
    pub tgname: *mut ::std::os::raw::c_char,
    pub tgfoid: Oid,
    pub tgtype: int16,
    pub tgenabled: ::std::os::raw::c_char,
    pub tgisinternal: bool,
    pub tgisclone: bool,
    pub tgconstrrelid: Oid,
    pub tgconstrindid: Oid,
    pub tgconstraint: Oid,
    pub tgdeferrable: bool,
    pub tginitdeferred: bool,
    pub tgnargs: int16,
    pub tgnattr: int16,
    pub tgattr: *mut int16,
    pub tgargs: *mut *mut ::std::os::raw::c_char,
    pub tgqual: *mut ::std::os::raw::c_char,
    pub tgoldtable: *mut ::std::os::raw::c_char,
    pub tgnewtable: *mut ::std::os::raw::c_char,
}
impl Default for Trigger {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerDesc {
    pub triggers: *mut Trigger,
    pub numtriggers: ::std::os::raw::c_int,
    pub trig_insert_before_row: bool,
    pub trig_insert_after_row: bool,
    pub trig_insert_instead_row: bool,
    pub trig_insert_before_statement: bool,
    pub trig_insert_after_statement: bool,
    pub trig_update_before_row: bool,
    pub trig_update_after_row: bool,
    pub trig_update_instead_row: bool,
    pub trig_update_before_statement: bool,
    pub trig_update_after_statement: bool,
    pub trig_delete_before_row: bool,
    pub trig_delete_after_row: bool,
    pub trig_delete_instead_row: bool,
    pub trig_delete_before_statement: bool,
    pub trig_delete_after_statement: bool,
    pub trig_truncate_before_statement: bool,
    pub trig_truncate_after_statement: bool,
    pub trig_insert_new_table: bool,
    pub trig_update_old_table: bool,
    pub trig_update_new_table: bool,
    pub trig_delete_old_table: bool,
}
impl Default for TriggerDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dirent {
    pub d_ino: __ino_t,
    pub d_off: __off_t,
    pub d_reclen: ::std::os::raw::c_ushort,
    pub d_type: ::std::os::raw::c_uchar,
    pub d_name: [::std::os::raw::c_char; 256usize],
}
impl Default for dirent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __dirstream {
    _unused: [u8; 0],
}
pub type DIR = __dirstream;
pub type File = ::std::os::raw::c_int;
extern "C" {
    pub static mut max_files_per_process: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut data_sync_retry: bool;
}
extern "C" {
    pub static mut max_safe_fds: ::std::os::raw::c_int;
}
pub unsafe fn PathNameOpenFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> File;
        }
        PathNameOpenFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn PathNameOpenFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> File;
        }
        PathNameOpenFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn OpenTemporaryFile(arg_interXact: bool) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTemporaryFile(arg_interXact: bool) -> File;
        }
        OpenTemporaryFile(arg_interXact)
    })
}
pub unsafe fn FileClose(arg_file: File) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileClose(arg_file: File);
        }
        FileClose(arg_file)
    })
}
pub unsafe fn FilePrefetch(
    arg_file: File,
    arg_offset: off_t,
    arg_amount: ::std::os::raw::c_int,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FilePrefetch(
                arg_file: File,
                arg_offset: off_t,
                arg_amount: ::std::os::raw::c_int,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FilePrefetch(arg_file, arg_offset, arg_amount, arg_wait_event_info)
    })
}
pub unsafe fn FileRead(
    arg_file: File,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_amount: ::std::os::raw::c_int,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileRead(
                arg_file: File,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_amount: ::std::os::raw::c_int,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileRead(arg_file, arg_buffer, arg_amount, arg_offset, arg_wait_event_info)
    })
}
pub unsafe fn FileWrite(
    arg_file: File,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_amount: ::std::os::raw::c_int,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileWrite(
                arg_file: File,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_amount: ::std::os::raw::c_int,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileWrite(arg_file, arg_buffer, arg_amount, arg_offset, arg_wait_event_info)
    })
}
pub unsafe fn FileSync(arg_file: File, arg_wait_event_info: uint32) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileSync(arg_file: File, arg_wait_event_info: uint32) -> ::std::os::raw::c_int;
        }
        FileSync(arg_file, arg_wait_event_info)
    })
}
pub unsafe fn FileSize(arg_file: File) -> off_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileSize(arg_file: File) -> off_t;
        }
        FileSize(arg_file)
    })
}
pub unsafe fn FileTruncate(
    arg_file: File,
    arg_offset: off_t,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileTruncate(
                arg_file: File,
                arg_offset: off_t,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        FileTruncate(arg_file, arg_offset, arg_wait_event_info)
    })
}
pub unsafe fn FileWriteback(
    arg_file: File,
    arg_offset: off_t,
    arg_nbytes: off_t,
    arg_wait_event_info: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileWriteback(
                arg_file: File,
                arg_offset: off_t,
                arg_nbytes: off_t,
                arg_wait_event_info: uint32,
            );
        }
        FileWriteback(arg_file, arg_offset, arg_nbytes, arg_wait_event_info)
    })
}
pub unsafe fn FilePathName(arg_file: File) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FilePathName(arg_file: File) -> *mut ::std::os::raw::c_char;
        }
        FilePathName(arg_file)
    })
}
pub unsafe fn FileGetRawDesc(arg_file: File) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawDesc(arg_file: File) -> ::std::os::raw::c_int;
        }
        FileGetRawDesc(arg_file)
    })
}
pub unsafe fn FileGetRawFlags(arg_file: File) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawFlags(arg_file: File) -> ::std::os::raw::c_int;
        }
        FileGetRawFlags(arg_file)
    })
}
pub unsafe fn FileGetRawMode(arg_file: File) -> mode_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FileGetRawMode(arg_file: File) -> mode_t;
        }
        FileGetRawMode(arg_file)
    })
}
pub unsafe fn PathNameCreateTemporaryFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameCreateTemporaryFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> File;
        }
        PathNameCreateTemporaryFile(arg_name, arg_error_on_failure)
    })
}
pub unsafe fn PathNameOpenTemporaryFile(arg_name: *const ::std::os::raw::c_char) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameOpenTemporaryFile(arg_name: *const ::std::os::raw::c_char) -> File;
        }
        PathNameOpenTemporaryFile(arg_name)
    })
}
pub unsafe fn PathNameDeleteTemporaryFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameDeleteTemporaryFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> bool;
        }
        PathNameDeleteTemporaryFile(arg_name, arg_error_on_failure)
    })
}
pub unsafe fn PathNameCreateTemporaryDir(
    arg_base: *const ::std::os::raw::c_char,
    arg_name: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameCreateTemporaryDir(
                arg_base: *const ::std::os::raw::c_char,
                arg_name: *const ::std::os::raw::c_char,
            );
        }
        PathNameCreateTemporaryDir(arg_base, arg_name)
    })
}
pub unsafe fn PathNameDeleteTemporaryDir(arg_name: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PathNameDeleteTemporaryDir(arg_name: *const ::std::os::raw::c_char);
        }
        PathNameDeleteTemporaryDir(arg_name)
    })
}
pub unsafe fn TempTablespacePath(arg_path: *mut ::std::os::raw::c_char, arg_tablespace: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TempTablespacePath(arg_path: *mut ::std::os::raw::c_char, arg_tablespace: Oid);
        }
        TempTablespacePath(arg_path, arg_tablespace)
    })
}
pub unsafe fn AllocateFile(
    arg_name: *const ::std::os::raw::c_char,
    arg_mode: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AllocateFile(
                arg_name: *const ::std::os::raw::c_char,
                arg_mode: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        AllocateFile(arg_name, arg_mode)
    })
}
pub unsafe fn FreeFile(arg_file: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeFile(arg_file: *mut FILE) -> ::std::os::raw::c_int;
        }
        FreeFile(arg_file)
    })
}
pub unsafe fn OpenPipeStream(
    arg_command: *const ::std::os::raw::c_char,
    arg_mode: *const ::std::os::raw::c_char,
) -> *mut FILE {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenPipeStream(
                arg_command: *const ::std::os::raw::c_char,
                arg_mode: *const ::std::os::raw::c_char,
            ) -> *mut FILE;
        }
        OpenPipeStream(arg_command, arg_mode)
    })
}
pub unsafe fn ClosePipeStream(arg_file: *mut FILE) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ClosePipeStream(arg_file: *mut FILE) -> ::std::os::raw::c_int;
        }
        ClosePipeStream(arg_file)
    })
}
pub unsafe fn AllocateDir(arg_dirname: *const ::std::os::raw::c_char) -> *mut DIR {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AllocateDir(arg_dirname: *const ::std::os::raw::c_char) -> *mut DIR;
        }
        AllocateDir(arg_dirname)
    })
}
pub unsafe fn ReadDir(
    arg_dir: *mut DIR,
    arg_dirname: *const ::std::os::raw::c_char,
) -> *mut dirent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadDir(
                arg_dir: *mut DIR,
                arg_dirname: *const ::std::os::raw::c_char,
            ) -> *mut dirent;
        }
        ReadDir(arg_dir, arg_dirname)
    })
}
pub unsafe fn ReadDirExtended(
    arg_dir: *mut DIR,
    arg_dirname: *const ::std::os::raw::c_char,
    arg_elevel: ::std::os::raw::c_int,
) -> *mut dirent {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadDirExtended(
                arg_dir: *mut DIR,
                arg_dirname: *const ::std::os::raw::c_char,
                arg_elevel: ::std::os::raw::c_int,
            ) -> *mut dirent;
        }
        ReadDirExtended(arg_dir, arg_dirname, arg_elevel)
    })
}
pub unsafe fn FreeDir(arg_dir: *mut DIR) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeDir(arg_dir: *mut DIR) -> ::std::os::raw::c_int;
        }
        FreeDir(arg_dir)
    })
}
pub unsafe fn OpenTransientFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTransientFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        OpenTransientFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn OpenTransientFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OpenTransientFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> ::std::os::raw::c_int;
        }
        OpenTransientFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn CloseTransientFile(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CloseTransientFile(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        CloseTransientFile(arg_fd)
    })
}
pub unsafe fn BasicOpenFile(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BasicOpenFile(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        BasicOpenFile(arg_fileName, arg_fileFlags)
    })
}
pub unsafe fn BasicOpenFilePerm(
    arg_fileName: *const ::std::os::raw::c_char,
    arg_fileFlags: ::std::os::raw::c_int,
    arg_fileMode: mode_t,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BasicOpenFilePerm(
                arg_fileName: *const ::std::os::raw::c_char,
                arg_fileFlags: ::std::os::raw::c_int,
                arg_fileMode: mode_t,
            ) -> ::std::os::raw::c_int;
        }
        BasicOpenFilePerm(arg_fileName, arg_fileFlags, arg_fileMode)
    })
}
pub unsafe fn AcquireExternalFD() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AcquireExternalFD() -> bool;
        }
        AcquireExternalFD()
    })
}
pub unsafe fn ReserveExternalFD() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReserveExternalFD();
        }
        ReserveExternalFD()
    })
}
pub unsafe fn ReleaseExternalFD() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReleaseExternalFD();
        }
        ReleaseExternalFD()
    })
}
pub unsafe fn MakePGDirectory(
    arg_directoryName: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakePGDirectory(
                arg_directoryName: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        MakePGDirectory(arg_directoryName)
    })
}
pub unsafe fn InitFileAccess() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitFileAccess();
        }
        InitFileAccess()
    })
}
pub unsafe fn set_max_safe_fds() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_max_safe_fds();
        }
        set_max_safe_fds()
    })
}
pub unsafe fn closeAllVfds() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn closeAllVfds();
        }
        closeAllVfds()
    })
}
pub unsafe fn SetTempTablespaces(arg_tableSpaces: *mut Oid, arg_numSpaces: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetTempTablespaces(arg_tableSpaces: *mut Oid, arg_numSpaces: ::std::os::raw::c_int);
        }
        SetTempTablespaces(arg_tableSpaces, arg_numSpaces)
    })
}
pub unsafe fn TempTablespacesAreSet() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TempTablespacesAreSet() -> bool;
        }
        TempTablespacesAreSet()
    })
}
pub unsafe fn GetTempTablespaces(
    arg_tableSpaces: *mut Oid,
    arg_numSpaces: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetTempTablespaces(
                arg_tableSpaces: *mut Oid,
                arg_numSpaces: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        GetTempTablespaces(arg_tableSpaces, arg_numSpaces)
    })
}
pub unsafe fn GetNextTempTableSpace() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNextTempTableSpace() -> Oid;
        }
        GetNextTempTableSpace()
    })
}
pub unsafe fn AtEOXact_Files(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_Files(arg_isCommit: bool);
        }
        AtEOXact_Files(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_Files(
    arg_isCommit: bool,
    arg_mySubid: SubTransactionId,
    arg_parentSubid: SubTransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_Files(
                arg_isCommit: bool,
                arg_mySubid: SubTransactionId,
                arg_parentSubid: SubTransactionId,
            );
        }
        AtEOSubXact_Files(arg_isCommit, arg_mySubid, arg_parentSubid)
    })
}
pub unsafe fn RemovePgTempFiles() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RemovePgTempFiles();
        }
        RemovePgTempFiles()
    })
}
pub unsafe fn RemovePgTempFilesInDir(
    arg_tmpdirname: *const ::std::os::raw::c_char,
    arg_missing_ok: bool,
    arg_unlink_all: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RemovePgTempFilesInDir(
                arg_tmpdirname: *const ::std::os::raw::c_char,
                arg_missing_ok: bool,
                arg_unlink_all: bool,
            );
        }
        RemovePgTempFilesInDir(arg_tmpdirname, arg_missing_ok, arg_unlink_all)
    })
}
pub unsafe fn looks_like_temp_rel_name(arg_name: *const ::std::os::raw::c_char) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn looks_like_temp_rel_name(arg_name: *const ::std::os::raw::c_char) -> bool;
        }
        looks_like_temp_rel_name(arg_name)
    })
}
pub unsafe fn pg_fsync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync(arg_fd)
    })
}
pub unsafe fn pg_fsync_no_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync_no_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync_no_writethrough(arg_fd)
    })
}
pub unsafe fn pg_fsync_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fsync_writethrough(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fsync_writethrough(arg_fd)
    })
}
pub unsafe fn pg_fdatasync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_fdatasync(arg_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        pg_fdatasync(arg_fd)
    })
}
pub unsafe fn pg_flush_data(arg_fd: ::std::os::raw::c_int, arg_offset: off_t, arg_amount: off_t) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_flush_data(arg_fd: ::std::os::raw::c_int, arg_offset: off_t, arg_amount: off_t);
        }
        pg_flush_data(arg_fd, arg_offset, arg_amount)
    })
}
pub unsafe fn fsync_fname(arg_fname: *const ::std::os::raw::c_char, arg_isdir: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fsync_fname(arg_fname: *const ::std::os::raw::c_char, arg_isdir: bool);
        }
        fsync_fname(arg_fname, arg_isdir)
    })
}
pub unsafe fn fsync_fname_ext(
    arg_fname: *const ::std::os::raw::c_char,
    arg_isdir: bool,
    arg_ignore_perm: bool,
    arg_elevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn fsync_fname_ext(
                arg_fname: *const ::std::os::raw::c_char,
                arg_isdir: bool,
                arg_ignore_perm: bool,
                arg_elevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        fsync_fname_ext(arg_fname, arg_isdir, arg_ignore_perm, arg_elevel)
    })
}
pub unsafe fn durable_rename(
    arg_oldfile: *const ::std::os::raw::c_char,
    arg_newfile: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_rename(
                arg_oldfile: *const ::std::os::raw::c_char,
                arg_newfile: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_rename(arg_oldfile, arg_newfile, arg_loglevel)
    })
}
pub unsafe fn durable_unlink(
    arg_fname: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_unlink(
                arg_fname: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_unlink(arg_fname, arg_loglevel)
    })
}
pub unsafe fn durable_rename_excl(
    arg_oldfile: *const ::std::os::raw::c_char,
    arg_newfile: *const ::std::os::raw::c_char,
    arg_loglevel: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn durable_rename_excl(
                arg_oldfile: *const ::std::os::raw::c_char,
                arg_newfile: *const ::std::os::raw::c_char,
                arg_loglevel: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        durable_rename_excl(arg_oldfile, arg_newfile, arg_loglevel)
    })
}
pub unsafe fn SyncDataDirectory() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SyncDataDirectory();
        }
        SyncDataDirectory()
    })
}
pub unsafe fn data_sync_elevel(arg_elevel: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn data_sync_elevel(arg_elevel: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        data_sync_elevel(arg_elevel)
    })
}
pub unsafe fn SpinlockSemas() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SpinlockSemas() -> ::std::os::raw::c_int;
        }
        SpinlockSemas()
    })
}
pub unsafe fn SpinlockSemaSize() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SpinlockSemaSize() -> Size;
        }
        SpinlockSemaSize()
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SharedFileSet {
    pub creator_pid: pid_t,
    pub number: uint32,
    pub mutex: slock_t,
    pub refcnt: ::std::os::raw::c_int,
    pub ntablespaces: ::std::os::raw::c_int,
    pub tablespaces: [Oid; 8usize],
}
pub unsafe fn SharedFileSetInit(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetInit(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment);
        }
        SharedFileSetInit(arg_fileset, arg_seg)
    })
}
pub unsafe fn SharedFileSetAttach(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetAttach(arg_fileset: *mut SharedFileSet, arg_seg: *mut dsm_segment);
        }
        SharedFileSetAttach(arg_fileset, arg_seg)
    })
}
pub unsafe fn SharedFileSetCreate(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetCreate(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
            ) -> File;
        }
        SharedFileSetCreate(arg_fileset, arg_name)
    })
}
pub unsafe fn SharedFileSetOpen(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
) -> File {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetOpen(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
            ) -> File;
        }
        SharedFileSetOpen(arg_fileset, arg_name)
    })
}
pub unsafe fn SharedFileSetDelete(
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
    arg_error_on_failure: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetDelete(
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
                arg_error_on_failure: bool,
            ) -> bool;
        }
        SharedFileSetDelete(arg_fileset, arg_name, arg_error_on_failure)
    })
}
pub unsafe fn SharedFileSetDeleteAll(arg_fileset: *mut SharedFileSet) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SharedFileSetDeleteAll(arg_fileset: *mut SharedFileSet);
        }
        SharedFileSetDeleteAll(arg_fileset)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestore {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestoreAccessor {
    _unused: [u8; 0],
}
pub unsafe fn sts_estimate(arg_participants: ::std::os::raw::c_int) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_estimate(arg_participants: ::std::os::raw::c_int) -> usize;
        }
        sts_estimate(arg_participants)
    })
}
pub unsafe fn sts_initialize(
    arg_sts: *mut SharedTuplestore,
    arg_participants: ::std::os::raw::c_int,
    arg_my_participant_number: ::std::os::raw::c_int,
    arg_meta_data_size: usize,
    arg_flags: ::std::os::raw::c_int,
    arg_fileset: *mut SharedFileSet,
    arg_name: *const ::std::os::raw::c_char,
) -> *mut SharedTuplestoreAccessor {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_initialize(
                arg_sts: *mut SharedTuplestore,
                arg_participants: ::std::os::raw::c_int,
                arg_my_participant_number: ::std::os::raw::c_int,
                arg_meta_data_size: usize,
                arg_flags: ::std::os::raw::c_int,
                arg_fileset: *mut SharedFileSet,
                arg_name: *const ::std::os::raw::c_char,
            ) -> *mut SharedTuplestoreAccessor;
        }
        sts_initialize(
            arg_sts,
            arg_participants,
            arg_my_participant_number,
            arg_meta_data_size,
            arg_flags,
            arg_fileset,
            arg_name,
        )
    })
}
pub unsafe fn sts_attach(
    arg_sts: *mut SharedTuplestore,
    arg_my_participant_number: ::std::os::raw::c_int,
    arg_fileset: *mut SharedFileSet,
) -> *mut SharedTuplestoreAccessor {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_attach(
                arg_sts: *mut SharedTuplestore,
                arg_my_participant_number: ::std::os::raw::c_int,
                arg_fileset: *mut SharedFileSet,
            ) -> *mut SharedTuplestoreAccessor;
        }
        sts_attach(arg_sts, arg_my_participant_number, arg_fileset)
    })
}
pub unsafe fn sts_end_write(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_end_write(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_end_write(arg_accessor)
    })
}
pub unsafe fn sts_reinitialize(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_reinitialize(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_reinitialize(arg_accessor)
    })
}
pub unsafe fn sts_begin_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_begin_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_begin_parallel_scan(arg_accessor)
    })
}
pub unsafe fn sts_end_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_end_parallel_scan(arg_accessor: *mut SharedTuplestoreAccessor);
        }
        sts_end_parallel_scan(arg_accessor)
    })
}
pub unsafe fn sts_puttuple(
    arg_accessor: *mut SharedTuplestoreAccessor,
    arg_meta_data: *mut ::std::os::raw::c_void,
    arg_tuple: MinimalTuple,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_puttuple(
                arg_accessor: *mut SharedTuplestoreAccessor,
                arg_meta_data: *mut ::std::os::raw::c_void,
                arg_tuple: MinimalTuple,
            );
        }
        sts_puttuple(arg_accessor, arg_meta_data, arg_tuple)
    })
}
pub unsafe fn sts_parallel_scan_next(
    arg_accessor: *mut SharedTuplestoreAccessor,
    arg_meta_data: *mut ::std::os::raw::c_void,
) -> MinimalTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn sts_parallel_scan_next(
                arg_accessor: *mut SharedTuplestoreAccessor,
                arg_meta_data: *mut ::std::os::raw::c_void,
            ) -> MinimalTuple;
        }
        sts_parallel_scan_next(arg_accessor, arg_meta_data)
    })
}
pub type Timestamp = int64;
pub type TimestampTz = int64;
pub type TimeOffset = int64;
pub type fsec_t = int32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Interval {
    pub time: TimeOffset,
    pub day: int32,
    pub month: int32,
}
pub const SnapshotType_SNAPSHOT_MVCC: SnapshotType = 0;
pub const SnapshotType_SNAPSHOT_SELF: SnapshotType = 1;
pub const SnapshotType_SNAPSHOT_ANY: SnapshotType = 2;
pub const SnapshotType_SNAPSHOT_TOAST: SnapshotType = 3;
pub const SnapshotType_SNAPSHOT_DIRTY: SnapshotType = 4;
pub const SnapshotType_SNAPSHOT_HISTORIC_MVCC: SnapshotType = 5;
pub const SnapshotType_SNAPSHOT_NON_VACUUMABLE: SnapshotType = 6;
pub type SnapshotType = ::std::os::raw::c_uint;
pub type Snapshot = *mut SnapshotData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SnapshotData {
    pub snapshot_type: SnapshotType,
    pub xmin: TransactionId,
    pub xmax: TransactionId,
    pub xip: *mut TransactionId,
    pub xcnt: uint32,
    pub subxip: *mut TransactionId,
    pub subxcnt: int32,
    pub suboverflowed: bool,
    pub takenDuringRecovery: bool,
    pub copied: bool,
    pub curcid: CommandId,
    pub speculativeToken: uint32,
    pub active_count: uint32,
    pub regd_count: uint32,
    pub ph_node: pairingheap_node,
    pub whenTaken: TimestampTz,
    pub lsn: XLogRecPtr,
}
impl Default for SnapshotData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Relation = *mut RelationData;
pub type RelationPtr = *mut Relation;
pub unsafe fn RelationIdGetRelation(arg_relationId: Oid) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationIdGetRelation(arg_relationId: Oid) -> Relation;
        }
        RelationIdGetRelation(arg_relationId)
    })
}
pub unsafe fn RelationClose(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationClose(arg_relation: Relation);
        }
        RelationClose(arg_relation)
    })
}
pub unsafe fn RelationGetFKeyList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetFKeyList(arg_relation: Relation) -> *mut List;
        }
        RelationGetFKeyList(arg_relation)
    })
}
pub unsafe fn RelationGetIndexList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexList(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexList(arg_relation)
    })
}
pub unsafe fn RelationGetStatExtList(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetStatExtList(arg_relation: Relation) -> *mut List;
        }
        RelationGetStatExtList(arg_relation)
    })
}
pub unsafe fn RelationGetPrimaryKeyIndex(arg_relation: Relation) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetPrimaryKeyIndex(arg_relation: Relation) -> Oid;
        }
        RelationGetPrimaryKeyIndex(arg_relation)
    })
}
pub unsafe fn RelationGetReplicaIndex(arg_relation: Relation) -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetReplicaIndex(arg_relation: Relation) -> Oid;
        }
        RelationGetReplicaIndex(arg_relation)
    })
}
pub unsafe fn RelationGetIndexExpressions(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexExpressions(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexExpressions(arg_relation)
    })
}
pub unsafe fn RelationGetDummyIndexExpressions(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetDummyIndexExpressions(arg_relation: Relation) -> *mut List;
        }
        RelationGetDummyIndexExpressions(arg_relation)
    })
}
pub unsafe fn RelationGetIndexPredicate(arg_relation: Relation) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexPredicate(arg_relation: Relation) -> *mut List;
        }
        RelationGetIndexPredicate(arg_relation)
    })
}
pub unsafe fn RelationGetIndexRawAttOptions(arg_relation: Relation) -> *mut Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexRawAttOptions(arg_relation: Relation) -> *mut Datum;
        }
        RelationGetIndexRawAttOptions(arg_relation)
    })
}
pub unsafe fn RelationGetIndexAttOptions(
    arg_relation: Relation,
    arg_copy: bool,
) -> *mut *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexAttOptions(
                arg_relation: Relation,
                arg_copy: bool,
            ) -> *mut *mut bytea;
        }
        RelationGetIndexAttOptions(arg_relation, arg_copy)
    })
}
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_ALL: IndexAttrBitmapKind = 0;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_KEY: IndexAttrBitmapKind = 1;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_PRIMARY_KEY: IndexAttrBitmapKind = 2;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_IDENTITY_KEY: IndexAttrBitmapKind = 3;
pub type IndexAttrBitmapKind = ::std::os::raw::c_uint;
pub unsafe fn RelationGetIndexAttrBitmap(
    arg_relation: Relation,
    arg_attrKind: IndexAttrBitmapKind,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexAttrBitmap(
                arg_relation: Relation,
                arg_attrKind: IndexAttrBitmapKind,
            ) -> *mut Bitmapset;
        }
        RelationGetIndexAttrBitmap(arg_relation, arg_attrKind)
    })
}
pub unsafe fn RelationGetExclusionInfo(
    arg_indexRelation: Relation,
    arg_operators: *mut *mut Oid,
    arg_procs: *mut *mut Oid,
    arg_strategies: *mut *mut uint16,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetExclusionInfo(
                arg_indexRelation: Relation,
                arg_operators: *mut *mut Oid,
                arg_procs: *mut *mut Oid,
                arg_strategies: *mut *mut uint16,
            );
        }
        RelationGetExclusionInfo(arg_indexRelation, arg_operators, arg_procs, arg_strategies)
    })
}
pub unsafe fn RelationInitIndexAccessInfo(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationInitIndexAccessInfo(arg_relation: Relation);
        }
        RelationInitIndexAccessInfo(arg_relation)
    })
}
pub unsafe fn GetRelationPublicationActions(arg_relation: Relation) -> *mut PublicationActions {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetRelationPublicationActions(arg_relation: Relation) -> *mut PublicationActions;
        }
        GetRelationPublicationActions(arg_relation)
    })
}
pub unsafe fn RelationInitTableAccessMethod(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationInitTableAccessMethod(arg_relation: Relation);
        }
        RelationInitTableAccessMethod(arg_relation)
    })
}
pub unsafe fn errtable(arg_rel: Relation) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtable(arg_rel: Relation) -> ::std::os::raw::c_int;
        }
        errtable(arg_rel)
    })
}
pub unsafe fn errtablecol(
    arg_rel: Relation,
    arg_attnum: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtablecol(
                arg_rel: Relation,
                arg_attnum: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        errtablecol(arg_rel, arg_attnum)
    })
}
pub unsafe fn errtablecolname(
    arg_rel: Relation,
    arg_colname: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtablecolname(
                arg_rel: Relation,
                arg_colname: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        errtablecolname(arg_rel, arg_colname)
    })
}
pub unsafe fn errtableconstraint(
    arg_rel: Relation,
    arg_conname: *const ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn errtableconstraint(
                arg_rel: Relation,
                arg_conname: *const ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        errtableconstraint(arg_rel, arg_conname)
    })
}
pub unsafe fn RelationCacheInitialize() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitialize();
        }
        RelationCacheInitialize()
    })
}
pub unsafe fn RelationCacheInitializePhase2() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitializePhase2();
        }
        RelationCacheInitializePhase2()
    })
}
pub unsafe fn RelationCacheInitializePhase3() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitializePhase3();
        }
        RelationCacheInitializePhase3()
    })
}
pub unsafe fn RelationBuildLocalRelation(
    arg_relname: *const ::std::os::raw::c_char,
    arg_relnamespace: Oid,
    arg_tupDesc: TupleDesc,
    arg_relid: Oid,
    arg_accessmtd: Oid,
    arg_relfilenode: Oid,
    arg_reltablespace: Oid,
    arg_shared_relation: bool,
    arg_mapped_relation: bool,
    arg_relpersistence: ::std::os::raw::c_char,
    arg_relkind: ::std::os::raw::c_char,
) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationBuildLocalRelation(
                arg_relname: *const ::std::os::raw::c_char,
                arg_relnamespace: Oid,
                arg_tupDesc: TupleDesc,
                arg_relid: Oid,
                arg_accessmtd: Oid,
                arg_relfilenode: Oid,
                arg_reltablespace: Oid,
                arg_shared_relation: bool,
                arg_mapped_relation: bool,
                arg_relpersistence: ::std::os::raw::c_char,
                arg_relkind: ::std::os::raw::c_char,
            ) -> Relation;
        }
        RelationBuildLocalRelation(
            arg_relname,
            arg_relnamespace,
            arg_tupDesc,
            arg_relid,
            arg_accessmtd,
            arg_relfilenode,
            arg_reltablespace,
            arg_shared_relation,
            arg_mapped_relation,
            arg_relpersistence,
            arg_relkind,
        )
    })
}
pub unsafe fn RelationSetNewRelfilenode(
    arg_relation: Relation,
    arg_persistence: ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationSetNewRelfilenode(
                arg_relation: Relation,
                arg_persistence: ::std::os::raw::c_char,
            );
        }
        RelationSetNewRelfilenode(arg_relation, arg_persistence)
    })
}
pub unsafe fn RelationAssumeNewRelfilenode(arg_relation: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationAssumeNewRelfilenode(arg_relation: Relation);
        }
        RelationAssumeNewRelfilenode(arg_relation)
    })
}
pub unsafe fn RelationForgetRelation(arg_rid: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationForgetRelation(arg_rid: Oid);
        }
        RelationForgetRelation(arg_rid)
    })
}
pub unsafe fn RelationCacheInvalidateEntry(arg_relationId: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInvalidateEntry(arg_relationId: Oid);
        }
        RelationCacheInvalidateEntry(arg_relationId)
    })
}
pub unsafe fn RelationCacheInvalidate(arg_debug_discard: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInvalidate(arg_debug_discard: bool);
        }
        RelationCacheInvalidate(arg_debug_discard)
    })
}
pub unsafe fn RelationCloseSmgrByOid(arg_relationId: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCloseSmgrByOid(arg_relationId: Oid);
        }
        RelationCloseSmgrByOid(arg_relationId)
    })
}
pub unsafe fn AssertPendingSyncs_RelationCache() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AssertPendingSyncs_RelationCache();
        }
        AssertPendingSyncs_RelationCache()
    })
}
pub unsafe fn AtEOXact_RelationCache(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_RelationCache(arg_isCommit: bool);
        }
        AtEOXact_RelationCache(arg_isCommit)
    })
}
pub unsafe fn AtEOSubXact_RelationCache(
    arg_isCommit: bool,
    arg_mySubid: SubTransactionId,
    arg_parentSubid: SubTransactionId,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_RelationCache(
                arg_isCommit: bool,
                arg_mySubid: SubTransactionId,
                arg_parentSubid: SubTransactionId,
            );
        }
        AtEOSubXact_RelationCache(arg_isCommit, arg_mySubid, arg_parentSubid)
    })
}
pub unsafe fn RelationIdIsInInitFile(arg_relationId: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationIdIsInInitFile(arg_relationId: Oid) -> bool;
        }
        RelationIdIsInInitFile(arg_relationId)
    })
}
pub unsafe fn RelationCacheInitFilePreInvalidate() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFilePreInvalidate();
        }
        RelationCacheInitFilePreInvalidate()
    })
}
pub unsafe fn RelationCacheInitFilePostInvalidate() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFilePostInvalidate();
        }
        RelationCacheInitFilePostInvalidate()
    })
}
pub unsafe fn RelationCacheInitFileRemove() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationCacheInitFileRemove();
        }
        RelationCacheInitFileRemove()
    })
}
extern "C" {
    pub static mut criticalRelcachesBuilt: bool;
}
extern "C" {
    pub static mut criticalSharedRelcachesBuilt: bool;
}
pub type SortSupport = *mut SortSupportData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortSupportData {
    pub ssup_cxt: MemoryContext,
    pub ssup_collation: Oid,
    pub ssup_reverse: bool,
    pub ssup_nulls_first: bool,
    pub ssup_attno: AttrNumber,
    pub ssup_extra: *mut ::std::os::raw::c_void,
    pub comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
    pub abbreviate: bool,
    pub abbrev_converter:
        ::std::option::Option<unsafe extern "C" fn(original: Datum, ssup: SortSupport) -> Datum>,
    pub abbrev_abort: ::std::option::Option<
        unsafe extern "C" fn(memtupcount: ::std::os::raw::c_int, ssup: SortSupport) -> bool,
    >,
    pub abbrev_full_comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
}
impl Default for SortSupportData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn PrepareSortSupportComparisonShim(arg_cmpFunc: Oid, arg_ssup: SortSupport) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportComparisonShim(arg_cmpFunc: Oid, arg_ssup: SortSupport);
        }
        PrepareSortSupportComparisonShim(arg_cmpFunc, arg_ssup)
    })
}
pub unsafe fn PrepareSortSupportFromOrderingOp(arg_orderingOp: Oid, arg_ssup: SortSupport) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportFromOrderingOp(arg_orderingOp: Oid, arg_ssup: SortSupport);
        }
        PrepareSortSupportFromOrderingOp(arg_orderingOp, arg_ssup)
    })
}
pub unsafe fn PrepareSortSupportFromIndexRel(
    arg_indexRel: Relation,
    arg_strategy: int16,
    arg_ssup: SortSupport,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PrepareSortSupportFromIndexRel(
                arg_indexRel: Relation,
                arg_strategy: int16,
                arg_ssup: SortSupport,
            );
        }
        PrepareSortSupportFromIndexRel(arg_indexRel, arg_strategy, arg_ssup)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexTupleData {
    pub t_tid: ItemPointerData,
    pub t_info: ::std::os::raw::c_ushort,
}
pub type IndexTuple = *mut IndexTupleData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexAttributeBitMapData {
    pub bits: [bits8; 4usize],
}
pub type IndexAttributeBitMap = *mut IndexAttributeBitMapData;
pub unsafe fn index_form_tuple(
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_form_tuple(
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> IndexTuple;
        }
        index_form_tuple(arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn nocache_index_getattr(
    arg_tup: IndexTuple,
    arg_attnum: ::std::os::raw::c_int,
    arg_tupleDesc: TupleDesc,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn nocache_index_getattr(
                arg_tup: IndexTuple,
                arg_attnum: ::std::os::raw::c_int,
                arg_tupleDesc: TupleDesc,
            ) -> Datum;
        }
        nocache_index_getattr(arg_tup, arg_attnum, arg_tupleDesc)
    })
}
pub unsafe fn index_deform_tuple(
    arg_tup: IndexTuple,
    arg_tupleDescriptor: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_deform_tuple(
                arg_tup: IndexTuple,
                arg_tupleDescriptor: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        index_deform_tuple(arg_tup, arg_tupleDescriptor, arg_values, arg_isnull)
    })
}
pub unsafe fn CopyIndexTuple(arg_source: IndexTuple) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CopyIndexTuple(arg_source: IndexTuple) -> IndexTuple;
        }
        CopyIndexTuple(arg_source)
    })
}
pub unsafe fn index_truncate_tuple(
    arg_sourceDescriptor: TupleDesc,
    arg_source: IndexTuple,
    arg_leavenatts: ::std::os::raw::c_int,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_truncate_tuple(
                arg_sourceDescriptor: TupleDesc,
                arg_source: IndexTuple,
                arg_leavenatts: ::std::os::raw::c_int,
            ) -> IndexTuple;
        }
        index_truncate_tuple(arg_sourceDescriptor, arg_source, arg_leavenatts)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplesortstate {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sharedsort {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortCoordinateData {
    pub isWorker: bool,
    pub nParticipants: ::std::os::raw::c_int,
    pub sharedsort: *mut Sharedsort,
}
impl Default for SortCoordinateData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SortCoordinate = *mut SortCoordinateData;
pub const TuplesortMethod_SORT_TYPE_STILL_IN_PROGRESS: TuplesortMethod = 0;
pub const TuplesortMethod_SORT_TYPE_TOP_N_HEAPSORT: TuplesortMethod = 1;
pub const TuplesortMethod_SORT_TYPE_QUICKSORT: TuplesortMethod = 2;
pub const TuplesortMethod_SORT_TYPE_EXTERNAL_SORT: TuplesortMethod = 4;
pub const TuplesortMethod_SORT_TYPE_EXTERNAL_MERGE: TuplesortMethod = 8;
pub type TuplesortMethod = ::std::os::raw::c_uint;
pub const TuplesortSpaceType_SORT_SPACE_TYPE_DISK: TuplesortSpaceType = 0;
pub const TuplesortSpaceType_SORT_SPACE_TYPE_MEMORY: TuplesortSpaceType = 1;
pub type TuplesortSpaceType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TuplesortInstrumentation {
    pub sortMethod: TuplesortMethod,
    pub spaceType: TuplesortSpaceType,
    pub spaceUsed: int64,
}
impl Default for TuplesortInstrumentation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn tuplesort_begin_heap(
    arg_tupDesc: TupleDesc,
    arg_nkeys: ::std::os::raw::c_int,
    arg_attNums: *mut AttrNumber,
    arg_sortOperators: *mut Oid,
    arg_sortCollations: *mut Oid,
    arg_nullsFirstFlags: *mut bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_heap(
                arg_tupDesc: TupleDesc,
                arg_nkeys: ::std::os::raw::c_int,
                arg_attNums: *mut AttrNumber,
                arg_sortOperators: *mut Oid,
                arg_sortCollations: *mut Oid,
                arg_nullsFirstFlags: *mut bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_heap(
            arg_tupDesc,
            arg_nkeys,
            arg_attNums,
            arg_sortOperators,
            arg_sortCollations,
            arg_nullsFirstFlags,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_cluster(
    arg_tupDesc: TupleDesc,
    arg_indexRel: Relation,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_cluster(
                arg_tupDesc: TupleDesc,
                arg_indexRel: Relation,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_cluster(
            arg_tupDesc,
            arg_indexRel,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_index_btree(
    arg_heapRel: Relation,
    arg_indexRel: Relation,
    arg_enforceUnique: bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_index_btree(
                arg_heapRel: Relation,
                arg_indexRel: Relation,
                arg_enforceUnique: bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_index_btree(
            arg_heapRel,
            arg_indexRel,
            arg_enforceUnique,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_index_hash(
    arg_heapRel: Relation,
    arg_indexRel: Relation,
    arg_high_mask: uint32,
    arg_low_mask: uint32,
    arg_max_buckets: uint32,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_index_hash(
                arg_heapRel: Relation,
                arg_indexRel: Relation,
                arg_high_mask: uint32,
                arg_low_mask: uint32,
                arg_max_buckets: uint32,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_index_hash(
            arg_heapRel,
            arg_indexRel,
            arg_high_mask,
            arg_low_mask,
            arg_max_buckets,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_begin_datum(
    arg_datumType: Oid,
    arg_sortOperator: Oid,
    arg_sortCollation: Oid,
    arg_nullsFirstFlag: bool,
    arg_workMem: ::std::os::raw::c_int,
    arg_coordinate: SortCoordinate,
    arg_randomAccess: bool,
) -> *mut Tuplesortstate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_begin_datum(
                arg_datumType: Oid,
                arg_sortOperator: Oid,
                arg_sortCollation: Oid,
                arg_nullsFirstFlag: bool,
                arg_workMem: ::std::os::raw::c_int,
                arg_coordinate: SortCoordinate,
                arg_randomAccess: bool,
            ) -> *mut Tuplesortstate;
        }
        tuplesort_begin_datum(
            arg_datumType,
            arg_sortOperator,
            arg_sortCollation,
            arg_nullsFirstFlag,
            arg_workMem,
            arg_coordinate,
            arg_randomAccess,
        )
    })
}
pub unsafe fn tuplesort_set_bound(arg_state: *mut Tuplesortstate, arg_bound: int64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_set_bound(arg_state: *mut Tuplesortstate, arg_bound: int64);
        }
        tuplesort_set_bound(arg_state, arg_bound)
    })
}
pub unsafe fn tuplesort_used_bound(arg_state: *mut Tuplesortstate) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_used_bound(arg_state: *mut Tuplesortstate) -> bool;
        }
        tuplesort_used_bound(arg_state)
    })
}
pub unsafe fn tuplesort_puttupleslot(
    arg_state: *mut Tuplesortstate,
    arg_slot: *mut TupleTableSlot,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_puttupleslot(
                arg_state: *mut Tuplesortstate,
                arg_slot: *mut TupleTableSlot,
            );
        }
        tuplesort_puttupleslot(arg_state, arg_slot)
    })
}
pub unsafe fn tuplesort_putheaptuple(arg_state: *mut Tuplesortstate, arg_tup: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putheaptuple(arg_state: *mut Tuplesortstate, arg_tup: HeapTuple);
        }
        tuplesort_putheaptuple(arg_state, arg_tup)
    })
}
pub unsafe fn tuplesort_putindextuplevalues(
    arg_state: *mut Tuplesortstate,
    arg_rel: Relation,
    arg_self_: ItemPointer,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putindextuplevalues(
                arg_state: *mut Tuplesortstate,
                arg_rel: Relation,
                arg_self_: ItemPointer,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        tuplesort_putindextuplevalues(arg_state, arg_rel, arg_self_, arg_values, arg_isnull)
    })
}
pub unsafe fn tuplesort_putdatum(arg_state: *mut Tuplesortstate, arg_val: Datum, arg_isNull: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_putdatum(arg_state: *mut Tuplesortstate, arg_val: Datum, arg_isNull: bool);
        }
        tuplesort_putdatum(arg_state, arg_val, arg_isNull)
    })
}
pub unsafe fn tuplesort_performsort(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_performsort(arg_state: *mut Tuplesortstate);
        }
        tuplesort_performsort(arg_state)
    })
}
pub unsafe fn tuplesort_gettupleslot(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
    arg_copy: bool,
    arg_slot: *mut TupleTableSlot,
    arg_abbrev: *mut Datum,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_gettupleslot(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
                arg_copy: bool,
                arg_slot: *mut TupleTableSlot,
                arg_abbrev: *mut Datum,
            ) -> bool;
        }
        tuplesort_gettupleslot(arg_state, arg_forward, arg_copy, arg_slot, arg_abbrev)
    })
}
pub unsafe fn tuplesort_getheaptuple(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getheaptuple(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
            ) -> HeapTuple;
        }
        tuplesort_getheaptuple(arg_state, arg_forward)
    })
}
pub unsafe fn tuplesort_getindextuple(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
) -> IndexTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getindextuple(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
            ) -> IndexTuple;
        }
        tuplesort_getindextuple(arg_state, arg_forward)
    })
}
pub unsafe fn tuplesort_getdatum(
    arg_state: *mut Tuplesortstate,
    arg_forward: bool,
    arg_val: *mut Datum,
    arg_isNull: *mut bool,
    arg_abbrev: *mut Datum,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_getdatum(
                arg_state: *mut Tuplesortstate,
                arg_forward: bool,
                arg_val: *mut Datum,
                arg_isNull: *mut bool,
                arg_abbrev: *mut Datum,
            ) -> bool;
        }
        tuplesort_getdatum(arg_state, arg_forward, arg_val, arg_isNull, arg_abbrev)
    })
}
pub unsafe fn tuplesort_skiptuples(
    arg_state: *mut Tuplesortstate,
    arg_ntuples: int64,
    arg_forward: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_skiptuples(
                arg_state: *mut Tuplesortstate,
                arg_ntuples: int64,
                arg_forward: bool,
            ) -> bool;
        }
        tuplesort_skiptuples(arg_state, arg_ntuples, arg_forward)
    })
}
pub unsafe fn tuplesort_end(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_end(arg_state: *mut Tuplesortstate);
        }
        tuplesort_end(arg_state)
    })
}
pub unsafe fn tuplesort_reset(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_reset(arg_state: *mut Tuplesortstate);
        }
        tuplesort_reset(arg_state)
    })
}
pub unsafe fn tuplesort_get_stats(
    arg_state: *mut Tuplesortstate,
    arg_stats: *mut TuplesortInstrumentation,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_get_stats(
                arg_state: *mut Tuplesortstate,
                arg_stats: *mut TuplesortInstrumentation,
            );
        }
        tuplesort_get_stats(arg_state, arg_stats)
    })
}
pub unsafe fn tuplesort_method_name(arg_m: TuplesortMethod) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_method_name(arg_m: TuplesortMethod) -> *const ::std::os::raw::c_char;
        }
        tuplesort_method_name(arg_m)
    })
}
pub unsafe fn tuplesort_space_type_name(
    arg_t: TuplesortSpaceType,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_space_type_name(
                arg_t: TuplesortSpaceType,
            ) -> *const ::std::os::raw::c_char;
        }
        tuplesort_space_type_name(arg_t)
    })
}
pub unsafe fn tuplesort_merge_order(arg_allowedMem: int64) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_merge_order(arg_allowedMem: int64) -> ::std::os::raw::c_int;
        }
        tuplesort_merge_order(arg_allowedMem)
    })
}
pub unsafe fn tuplesort_estimate_shared(arg_nworkers: ::std::os::raw::c_int) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_estimate_shared(arg_nworkers: ::std::os::raw::c_int) -> Size;
        }
        tuplesort_estimate_shared(arg_nworkers)
    })
}
pub unsafe fn tuplesort_initialize_shared(
    arg_shared: *mut Sharedsort,
    arg_nWorkers: ::std::os::raw::c_int,
    arg_seg: *mut dsm_segment,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_initialize_shared(
                arg_shared: *mut Sharedsort,
                arg_nWorkers: ::std::os::raw::c_int,
                arg_seg: *mut dsm_segment,
            );
        }
        tuplesort_initialize_shared(arg_shared, arg_nWorkers, arg_seg)
    })
}
pub unsafe fn tuplesort_attach_shared(arg_shared: *mut Sharedsort, arg_seg: *mut dsm_segment) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_attach_shared(arg_shared: *mut Sharedsort, arg_seg: *mut dsm_segment);
        }
        tuplesort_attach_shared(arg_shared, arg_seg)
    })
}
pub unsafe fn tuplesort_rescan(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_rescan(arg_state: *mut Tuplesortstate);
        }
        tuplesort_rescan(arg_state)
    })
}
pub unsafe fn tuplesort_markpos(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_markpos(arg_state: *mut Tuplesortstate);
        }
        tuplesort_markpos(arg_state)
    })
}
pub unsafe fn tuplesort_restorepos(arg_state: *mut Tuplesortstate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplesort_restorepos(arg_state: *mut Tuplesortstate);
        }
        tuplesort_restorepos(arg_state)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplestorestate {
    _unused: [u8; 0],
}
pub unsafe fn tuplestore_begin_heap(
    arg_randomAccess: bool,
    arg_interXact: bool,
    arg_maxKBytes: ::std::os::raw::c_int,
) -> *mut Tuplestorestate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_begin_heap(
                arg_randomAccess: bool,
                arg_interXact: bool,
                arg_maxKBytes: ::std::os::raw::c_int,
            ) -> *mut Tuplestorestate;
        }
        tuplestore_begin_heap(arg_randomAccess, arg_interXact, arg_maxKBytes)
    })
}
pub unsafe fn tuplestore_set_eflags(
    arg_state: *mut Tuplestorestate,
    arg_eflags: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_set_eflags(
                arg_state: *mut Tuplestorestate,
                arg_eflags: ::std::os::raw::c_int,
            );
        }
        tuplestore_set_eflags(arg_state, arg_eflags)
    })
}
pub unsafe fn tuplestore_puttupleslot(
    arg_state: *mut Tuplestorestate,
    arg_slot: *mut TupleTableSlot,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_puttupleslot(
                arg_state: *mut Tuplestorestate,
                arg_slot: *mut TupleTableSlot,
            );
        }
        tuplestore_puttupleslot(arg_state, arg_slot)
    })
}
pub unsafe fn tuplestore_puttuple(arg_state: *mut Tuplestorestate, arg_tuple: HeapTuple) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_puttuple(arg_state: *mut Tuplestorestate, arg_tuple: HeapTuple);
        }
        tuplestore_puttuple(arg_state, arg_tuple)
    })
}
pub unsafe fn tuplestore_putvalues(
    arg_state: *mut Tuplestorestate,
    arg_tdesc: TupleDesc,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_putvalues(
                arg_state: *mut Tuplestorestate,
                arg_tdesc: TupleDesc,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        tuplestore_putvalues(arg_state, arg_tdesc, arg_values, arg_isnull)
    })
}
pub unsafe fn tuplestore_alloc_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_eflags: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_alloc_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_eflags: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        tuplestore_alloc_read_pointer(arg_state, arg_eflags)
    })
}
pub unsafe fn tuplestore_select_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_ptr: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_select_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_ptr: ::std::os::raw::c_int,
            );
        }
        tuplestore_select_read_pointer(arg_state, arg_ptr)
    })
}
pub unsafe fn tuplestore_copy_read_pointer(
    arg_state: *mut Tuplestorestate,
    arg_srcptr: ::std::os::raw::c_int,
    arg_destptr: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_copy_read_pointer(
                arg_state: *mut Tuplestorestate,
                arg_srcptr: ::std::os::raw::c_int,
                arg_destptr: ::std::os::raw::c_int,
            );
        }
        tuplestore_copy_read_pointer(arg_state, arg_srcptr, arg_destptr)
    })
}
pub unsafe fn tuplestore_trim(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_trim(arg_state: *mut Tuplestorestate);
        }
        tuplestore_trim(arg_state)
    })
}
pub unsafe fn tuplestore_in_memory(arg_state: *mut Tuplestorestate) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_in_memory(arg_state: *mut Tuplestorestate) -> bool;
        }
        tuplestore_in_memory(arg_state)
    })
}
pub unsafe fn tuplestore_gettupleslot(
    arg_state: *mut Tuplestorestate,
    arg_forward: bool,
    arg_copy: bool,
    arg_slot: *mut TupleTableSlot,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_gettupleslot(
                arg_state: *mut Tuplestorestate,
                arg_forward: bool,
                arg_copy: bool,
                arg_slot: *mut TupleTableSlot,
            ) -> bool;
        }
        tuplestore_gettupleslot(arg_state, arg_forward, arg_copy, arg_slot)
    })
}
pub unsafe fn tuplestore_advance(arg_state: *mut Tuplestorestate, arg_forward: bool) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_advance(arg_state: *mut Tuplestorestate, arg_forward: bool) -> bool;
        }
        tuplestore_advance(arg_state, arg_forward)
    })
}
pub unsafe fn tuplestore_skiptuples(
    arg_state: *mut Tuplestorestate,
    arg_ntuples: int64,
    arg_forward: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_skiptuples(
                arg_state: *mut Tuplestorestate,
                arg_ntuples: int64,
                arg_forward: bool,
            ) -> bool;
        }
        tuplestore_skiptuples(arg_state, arg_ntuples, arg_forward)
    })
}
pub unsafe fn tuplestore_tuple_count(arg_state: *mut Tuplestorestate) -> int64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_tuple_count(arg_state: *mut Tuplestorestate) -> int64;
        }
        tuplestore_tuple_count(arg_state)
    })
}
pub unsafe fn tuplestore_ateof(arg_state: *mut Tuplestorestate) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_ateof(arg_state: *mut Tuplestorestate) -> bool;
        }
        tuplestore_ateof(arg_state)
    })
}
pub unsafe fn tuplestore_rescan(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_rescan(arg_state: *mut Tuplestorestate);
        }
        tuplestore_rescan(arg_state)
    })
}
pub unsafe fn tuplestore_clear(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_clear(arg_state: *mut Tuplestorestate);
        }
        tuplestore_clear(arg_state)
    })
}
pub unsafe fn tuplestore_end(arg_state: *mut Tuplestorestate) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplestore_end(arg_state: *mut Tuplestorestate);
        }
        tuplestore_end(arg_state)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRoutingInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelHashJoinState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyMultiInsertBuffer {
    _unused: [u8; 0],
}
pub type ExprStateEvalFunc = ::std::option::Option<
    unsafe extern "C" fn(
        expression: *mut ExprState,
        econtext: *mut ExprContext,
        isNull: *mut bool,
    ) -> Datum,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprState {
    pub tag: NodeTag,
    pub flags: uint8,
    pub resnull: bool,
    pub resvalue: Datum,
    pub resultslot: *mut TupleTableSlot,
    pub steps: *mut ExprEvalStep,
    pub evalfunc: ExprStateEvalFunc,
    pub expr: *mut Expr,
    pub evalfunc_private: *mut ::std::os::raw::c_void,
    pub steps_len: ::std::os::raw::c_int,
    pub steps_alloc: ::std::os::raw::c_int,
    pub parent: *mut PlanState,
    pub ext_params: ParamListInfo,
    pub innermost_caseval: *mut Datum,
    pub innermost_casenull: *mut bool,
    pub innermost_domainval: *mut Datum,
    pub innermost_domainnull: *mut bool,
}
impl Default for ExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexInfo {
    pub type_: NodeTag,
    pub ii_NumIndexAttrs: ::std::os::raw::c_int,
    pub ii_NumIndexKeyAttrs: ::std::os::raw::c_int,
    pub ii_IndexAttrNumbers: [AttrNumber; 32usize],
    pub ii_Expressions: *mut List,
    pub ii_ExpressionsState: *mut List,
    pub ii_Predicate: *mut List,
    pub ii_PredicateState: *mut ExprState,
    pub ii_ExclusionOps: *mut Oid,
    pub ii_ExclusionProcs: *mut Oid,
    pub ii_ExclusionStrats: *mut uint16,
    pub ii_UniqueOps: *mut Oid,
    pub ii_UniqueProcs: *mut Oid,
    pub ii_UniqueStrats: *mut uint16,
    pub ii_OpclassOptions: *mut Datum,
    pub ii_Unique: bool,
    pub ii_ReadyForInserts: bool,
    pub ii_Concurrent: bool,
    pub ii_BrokenHotChain: bool,
    pub ii_ParallelWorkers: ::std::os::raw::c_int,
    pub ii_Am: Oid,
    pub ii_AmCache: *mut ::std::os::raw::c_void,
    pub ii_Context: MemoryContext,
}
impl Default for IndexInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext_CB {
    pub next: *mut ExprContext_CB,
    pub function: ExprContextCallbackFunction,
    pub arg: Datum,
}
impl Default for ExprContext_CB {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext {
    pub type_: NodeTag,
    pub ecxt_scantuple: *mut TupleTableSlot,
    pub ecxt_innertuple: *mut TupleTableSlot,
    pub ecxt_outertuple: *mut TupleTableSlot,
    pub ecxt_per_query_memory: MemoryContext,
    pub ecxt_per_tuple_memory: MemoryContext,
    pub ecxt_param_exec_vals: *mut ParamExecData,
    pub ecxt_param_list_info: ParamListInfo,
    pub ecxt_aggvalues: *mut Datum,
    pub ecxt_aggnulls: *mut bool,
    pub caseValue_datum: Datum,
    pub caseValue_isNull: bool,
    pub domainValue_datum: Datum,
    pub domainValue_isNull: bool,
    pub ecxt_estate: *mut EState,
    pub ecxt_callbacks: *mut ExprContext_CB,
}
impl Default for ExprContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ExprDoneCond_ExprSingleResult: ExprDoneCond = 0;
pub const ExprDoneCond_ExprMultipleResult: ExprDoneCond = 1;
pub const ExprDoneCond_ExprEndResult: ExprDoneCond = 2;
pub type ExprDoneCond = ::std::os::raw::c_uint;
pub const SetFunctionReturnMode_SFRM_ValuePerCall: SetFunctionReturnMode = 1;
pub const SetFunctionReturnMode_SFRM_Materialize: SetFunctionReturnMode = 2;
pub const SetFunctionReturnMode_SFRM_Materialize_Random: SetFunctionReturnMode = 4;
pub const SetFunctionReturnMode_SFRM_Materialize_Preferred: SetFunctionReturnMode = 8;
pub type SetFunctionReturnMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReturnSetInfo {
    pub type_: NodeTag,
    pub econtext: *mut ExprContext,
    pub expectedDesc: TupleDesc,
    pub allowedModes: ::std::os::raw::c_int,
    pub returnMode: SetFunctionReturnMode,
    pub isDone: ExprDoneCond,
    pub setResult: *mut Tuplestorestate,
    pub setDesc: TupleDesc,
}
impl Default for ReturnSetInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectionInfo {
    pub type_: NodeTag,
    pub pi_state: ExprState,
    pub pi_exprContext: *mut ExprContext,
}
impl Default for ProjectionInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JunkFilter {
    pub type_: NodeTag,
    pub jf_targetList: *mut List,
    pub jf_cleanTupType: TupleDesc,
    pub jf_cleanMap: *mut AttrNumber,
    pub jf_resultSlot: *mut TupleTableSlot,
    pub jf_junkAttNo: AttrNumber,
}
impl Default for JunkFilter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictSetState {
    pub type_: NodeTag,
    pub oc_Existing: *mut TupleTableSlot,
    pub oc_ProjSlot: *mut TupleTableSlot,
    pub oc_ProjInfo: *mut ProjectionInfo,
    pub oc_WhereClause: *mut ExprState,
}
impl Default for OnConflictSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultRelInfo {
    pub type_: NodeTag,
    pub ri_RangeTableIndex: Index,
    pub ri_RelationDesc: Relation,
    pub ri_NumIndices: ::std::os::raw::c_int,
    pub ri_IndexRelationDescs: RelationPtr,
    pub ri_IndexRelationInfo: *mut *mut IndexInfo,
    pub ri_TrigDesc: *mut TriggerDesc,
    pub ri_TrigFunctions: *mut FmgrInfo,
    pub ri_TrigWhenExprs: *mut *mut ExprState,
    pub ri_TrigInstrument: *mut Instrumentation,
    pub ri_ReturningSlot: *mut TupleTableSlot,
    pub ri_TrigOldSlot: *mut TupleTableSlot,
    pub ri_TrigNewSlot: *mut TupleTableSlot,
    pub ri_FdwRoutine: *mut FdwRoutine,
    pub ri_FdwState: *mut ::std::os::raw::c_void,
    pub ri_usesFdwDirectModify: bool,
    pub ri_WithCheckOptions: *mut List,
    pub ri_WithCheckOptionExprs: *mut List,
    pub ri_ConstraintExprs: *mut *mut ExprState,
    pub ri_GeneratedExprs: *mut *mut ExprState,
    pub ri_NumGeneratedNeeded: ::std::os::raw::c_int,
    pub ri_junkFilter: *mut JunkFilter,
    pub ri_returningList: *mut List,
    pub ri_projectReturning: *mut ProjectionInfo,
    pub ri_onConflictArbiterIndexes: *mut List,
    pub ri_onConflict: *mut OnConflictSetState,
    pub ri_PartitionCheck: *mut List,
    pub ri_PartitionCheckExpr: *mut ExprState,
    pub ri_RootResultRelInfo: *mut ResultRelInfo,
    pub ri_PartitionInfo: *mut PartitionRoutingInfo,
    pub ri_CopyMultiInsertBuffer: *mut CopyMultiInsertBuffer,
}
impl Default for ResultRelInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EState {
    pub type_: NodeTag,
    pub es_direction: ScanDirection,
    pub es_snapshot: Snapshot,
    pub es_crosscheck_snapshot: Snapshot,
    pub es_range_table: *mut List,
    pub es_range_table_size: Index,
    pub es_relations: *mut Relation,
    pub es_rowmarks: *mut *mut ExecRowMark,
    pub es_plannedstmt: *mut PlannedStmt,
    pub es_sourceText: *const ::std::os::raw::c_char,
    pub es_junkFilter: *mut JunkFilter,
    pub es_output_cid: CommandId,
    pub es_result_relations: *mut ResultRelInfo,
    pub es_num_result_relations: ::std::os::raw::c_int,
    pub es_result_relation_info: *mut ResultRelInfo,
    pub es_root_result_relations: *mut ResultRelInfo,
    pub es_num_root_result_relations: ::std::os::raw::c_int,
    pub es_partition_directory: PartitionDirectory,
    pub es_tuple_routing_result_relations: *mut List,
    pub es_trig_target_relations: *mut List,
    pub es_param_list_info: ParamListInfo,
    pub es_param_exec_vals: *mut ParamExecData,
    pub es_queryEnv: *mut QueryEnvironment,
    pub es_query_cxt: MemoryContext,
    pub es_tupleTable: *mut List,
    pub es_processed: uint64,
    pub es_top_eflags: ::std::os::raw::c_int,
    pub es_instrument: ::std::os::raw::c_int,
    pub es_finished: bool,
    pub es_exprcontexts: *mut List,
    pub es_subplanstates: *mut List,
    pub es_auxmodifytables: *mut List,
    pub es_per_tuple_exprcontext: *mut ExprContext,
    pub es_epq_active: *mut EPQState,
    pub es_use_parallel_mode: bool,
    pub es_query_dsa: *mut dsa_area,
    pub es_jit_flags: ::std::os::raw::c_int,
    pub es_jit: *mut JitContext,
    pub es_jit_worker_instr: *mut JitInstrumentation,
}
impl Default for EState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecRowMark {
    pub relation: Relation,
    pub relid: Oid,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub ermActive: bool,
    pub curCtid: ItemPointerData,
    pub ermExtra: *mut ::std::os::raw::c_void,
}
impl Default for ExecRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecAuxRowMark {
    pub rowmark: *mut ExecRowMark,
    pub ctidAttNo: AttrNumber,
    pub toidAttNo: AttrNumber,
    pub wholeAttNo: AttrNumber,
}
impl Default for ExecAuxRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashEntry = *mut TupleHashEntryData;
pub type TupleHashTable = *mut TupleHashTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashEntryData {
    pub firstTuple: MinimalTuple,
    pub additional: *mut ::std::os::raw::c_void,
    pub status: uint32,
    pub hash: uint32,
}
impl Default for TupleHashEntryData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static pg_leftmost_one_pos: [uint8; 256usize];
}
extern "C" {
    pub static pg_rightmost_one_pos: [uint8; 256usize];
}
extern "C" {
    pub static pg_number_of_ones: [uint8; 256usize];
}
extern "C" {
    pub static mut pg_popcount32:
        ::std::option::Option<unsafe extern "C" fn(word: uint32) -> ::std::os::raw::c_int>;
}
extern "C" {
    pub static mut pg_popcount64:
        ::std::option::Option<unsafe extern "C" fn(word: uint64) -> ::std::os::raw::c_int>;
}
pub unsafe fn pg_popcount(
    arg_buf: *const ::std::os::raw::c_char,
    arg_bytes: ::std::os::raw::c_int,
) -> uint64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_popcount(
                arg_buf: *const ::std::os::raw::c_char,
                arg_bytes: ::std::os::raw::c_int,
            ) -> uint64;
        }
        pg_popcount(arg_buf, arg_bytes)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tuplehash_hash {
    pub size: uint64,
    pub members: uint32,
    pub sizemask: uint32,
    pub grow_threshold: uint32,
    pub data: *mut TupleHashEntryData,
    pub ctx: MemoryContext,
    pub private_data: *mut ::std::os::raw::c_void,
}
impl Default for tuplehash_hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const tuplehash_status_tuplehash_SH_EMPTY: tuplehash_status = 0;
pub const tuplehash_status_tuplehash_SH_IN_USE: tuplehash_status = 1;
pub type tuplehash_status = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct tuplehash_iterator {
    pub cur: uint32,
    pub end: uint32,
    pub done: bool,
}
pub unsafe fn tuplehash_create(
    arg_ctx: MemoryContext,
    arg_nelements: uint32,
    arg_private_data: *mut ::std::os::raw::c_void,
) -> *mut tuplehash_hash {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_create(
                arg_ctx: MemoryContext,
                arg_nelements: uint32,
                arg_private_data: *mut ::std::os::raw::c_void,
            ) -> *mut tuplehash_hash;
        }
        tuplehash_create(arg_ctx, arg_nelements, arg_private_data)
    })
}
pub unsafe fn tuplehash_destroy(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_destroy(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_destroy(arg_tb)
    })
}
pub unsafe fn tuplehash_reset(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_reset(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_reset(arg_tb)
    })
}
pub unsafe fn tuplehash_grow(arg_tb: *mut tuplehash_hash, arg_newsize: uint64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_grow(arg_tb: *mut tuplehash_hash, arg_newsize: uint64);
        }
        tuplehash_grow(arg_tb, arg_newsize)
    })
}
pub unsafe fn tuplehash_insert(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
    arg_found: *mut bool,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_insert(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
                arg_found: *mut bool,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_insert(arg_tb, arg_key, arg_found)
    })
}
pub unsafe fn tuplehash_insert_hash(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
    arg_hash: uint32,
    arg_found: *mut bool,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_insert_hash(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
                arg_hash: uint32,
                arg_found: *mut bool,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_insert_hash(arg_tb, arg_key, arg_hash, arg_found)
    })
}
pub unsafe fn tuplehash_lookup(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_lookup(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_lookup(arg_tb, arg_key)
    })
}
pub unsafe fn tuplehash_lookup_hash(
    arg_tb: *mut tuplehash_hash,
    arg_key: MinimalTuple,
    arg_hash: uint32,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_lookup_hash(
                arg_tb: *mut tuplehash_hash,
                arg_key: MinimalTuple,
                arg_hash: uint32,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_lookup_hash(arg_tb, arg_key, arg_hash)
    })
}
pub unsafe fn tuplehash_delete(arg_tb: *mut tuplehash_hash, arg_key: MinimalTuple) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_delete(arg_tb: *mut tuplehash_hash, arg_key: MinimalTuple) -> bool;
        }
        tuplehash_delete(arg_tb, arg_key)
    })
}
pub unsafe fn tuplehash_start_iterate(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_start_iterate(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
            );
        }
        tuplehash_start_iterate(arg_tb, arg_iter)
    })
}
pub unsafe fn tuplehash_start_iterate_at(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
    arg_at: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_start_iterate_at(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
                arg_at: uint32,
            );
        }
        tuplehash_start_iterate_at(arg_tb, arg_iter, arg_at)
    })
}
pub unsafe fn tuplehash_iterate(
    arg_tb: *mut tuplehash_hash,
    arg_iter: *mut tuplehash_iterator,
) -> *mut TupleHashEntryData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_iterate(
                arg_tb: *mut tuplehash_hash,
                arg_iter: *mut tuplehash_iterator,
            ) -> *mut TupleHashEntryData;
        }
        tuplehash_iterate(arg_tb, arg_iter)
    })
}
pub unsafe fn tuplehash_stat(arg_tb: *mut tuplehash_hash) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn tuplehash_stat(arg_tb: *mut tuplehash_hash);
        }
        tuplehash_stat(arg_tb)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashTableData {
    pub hashtab: *mut tuplehash_hash,
    pub numCols: ::std::os::raw::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_func: *mut ExprState,
    pub tab_collations: *mut Oid,
    pub tablecxt: MemoryContext,
    pub tempcxt: MemoryContext,
    pub entrysize: Size,
    pub tableslot: *mut TupleTableSlot,
    pub inputslot: *mut TupleTableSlot,
    pub in_hash_funcs: *mut FmgrInfo,
    pub cur_eq_func: *mut ExprState,
    pub hash_iv: uint32,
    pub exprcontext: *mut ExprContext,
}
impl Default for TupleHashTableData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashIterator = tuplehash_iterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggrefExprState {
    pub type_: NodeTag,
    pub aggref: *mut Aggref,
    pub aggno: ::std::os::raw::c_int,
}
impl Default for AggrefExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFuncExprState {
    pub type_: NodeTag,
    pub wfunc: *mut WindowFunc,
    pub args: *mut List,
    pub aggfilter: *mut ExprState,
    pub wfuncno: ::std::os::raw::c_int,
}
impl Default for WindowFuncExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetExprState {
    pub type_: NodeTag,
    pub expr: *mut Expr,
    pub args: *mut List,
    pub elidedFuncState: *mut ExprState,
    pub func: FmgrInfo,
    pub funcResultStore: *mut Tuplestorestate,
    pub funcResultSlot: *mut TupleTableSlot,
    pub funcResultDesc: TupleDesc,
    pub funcReturnsTuple: bool,
    pub funcReturnsSet: bool,
    pub setArgsValid: bool,
    pub shutdown_reg: bool,
    pub fcinfo: FunctionCallInfo,
}
impl Default for SetExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut SubPlan,
    pub planstate: *mut PlanState,
    pub parent: *mut PlanState,
    pub testexpr: *mut ExprState,
    pub args: *mut List,
    pub curTuple: HeapTuple,
    pub curArray: Datum,
    pub descRight: TupleDesc,
    pub projLeft: *mut ProjectionInfo,
    pub projRight: *mut ProjectionInfo,
    pub hashtable: TupleHashTable,
    pub hashnulls: TupleHashTable,
    pub havehashrows: bool,
    pub havenullrows: bool,
    pub hashtablecxt: MemoryContext,
    pub hashtempcxt: MemoryContext,
    pub innerecontext: *mut ExprContext,
    pub numCols: ::std::os::raw::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_eq_funcoids: *mut Oid,
    pub tab_collations: *mut Oid,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_funcs: *mut FmgrInfo,
    pub lhs_hash_funcs: *mut FmgrInfo,
    pub cur_eq_funcs: *mut FmgrInfo,
    pub cur_eq_comp: *mut ExprState,
}
impl Default for SubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut AlternativeSubPlan,
    pub subplans: *mut List,
    pub active: ::std::os::raw::c_int,
}
impl Default for AlternativeSubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DomainConstraintType_DOM_CONSTRAINT_NOTNULL: DomainConstraintType = 0;
pub const DomainConstraintType_DOM_CONSTRAINT_CHECK: DomainConstraintType = 1;
pub type DomainConstraintType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DomainConstraintState {
    pub type_: NodeTag,
    pub constrainttype: DomainConstraintType,
    pub name: *mut ::std::os::raw::c_char,
    pub check_expr: *mut Expr,
    pub check_exprstate: *mut ExprState,
}
impl Default for DomainConstraintState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExecProcNodeMtd =
    ::std::option::Option<unsafe extern "C" fn(pstate: *mut PlanState) -> *mut TupleTableSlot>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanState {
    pub type_: NodeTag,
    pub plan: *mut Plan,
    pub state: *mut EState,
    pub ExecProcNode: ExecProcNodeMtd,
    pub ExecProcNodeReal: ExecProcNodeMtd,
    pub instrument: *mut Instrumentation,
    pub worker_instrument: *mut WorkerInstrumentation,
    pub worker_jit_instrument: *mut SharedJitInstrumentation,
    pub qual: *mut ExprState,
    pub lefttree: *mut PlanState,
    pub righttree: *mut PlanState,
    pub initPlan: *mut List,
    pub subPlan: *mut List,
    pub chgParam: *mut Bitmapset,
    pub ps_ResultTupleDesc: TupleDesc,
    pub ps_ResultTupleSlot: *mut TupleTableSlot,
    pub ps_ExprContext: *mut ExprContext,
    pub ps_ProjInfo: *mut ProjectionInfo,
    pub scandesc: TupleDesc,
    pub scanops: *const TupleTableSlotOps,
    pub outerops: *const TupleTableSlotOps,
    pub innerops: *const TupleTableSlotOps,
    pub resultops: *const TupleTableSlotOps,
    pub scanopsfixed: bool,
    pub outeropsfixed: bool,
    pub inneropsfixed: bool,
    pub resultopsfixed: bool,
    pub scanopsset: bool,
    pub outeropsset: bool,
    pub inneropsset: bool,
    pub resultopsset: bool,
}
impl Default for PlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EPQState {
    pub parentestate: *mut EState,
    pub epqParam: ::std::os::raw::c_int,
    pub tuple_table: *mut List,
    pub relsubs_slot: *mut *mut TupleTableSlot,
    pub plan: *mut Plan,
    pub arowMarks: *mut List,
    pub origslot: *mut TupleTableSlot,
    pub recheckestate: *mut EState,
    pub relsubs_rowmark: *mut *mut ExecAuxRowMark,
    pub relsubs_done: *mut bool,
    pub recheckplanstate: *mut PlanState,
}
impl Default for EPQState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultState {
    pub ps: PlanState,
    pub resconstantqual: *mut ExprState,
    pub rs_done: bool,
    pub rs_checkqual: bool,
}
impl Default for ResultState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSetState {
    pub ps: PlanState,
    pub elems: *mut *mut Node,
    pub elemdone: *mut ExprDoneCond,
    pub nelems: ::std::os::raw::c_int,
    pub pending_srf_tuples: bool,
    pub argcontext: MemoryContext,
}
impl Default for ProjectSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTableState {
    pub ps: PlanState,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub mt_done: bool,
    pub mt_plans: *mut *mut PlanState,
    pub mt_nplans: ::std::os::raw::c_int,
    pub mt_whichplan: ::std::os::raw::c_int,
    pub mt_scans: *mut *mut TupleTableSlot,
    pub resultRelInfo: *mut ResultRelInfo,
    pub rootResultRelInfo: *mut ResultRelInfo,
    pub mt_arowmarks: *mut *mut List,
    pub mt_epqstate: EPQState,
    pub fireBSTriggers: bool,
    pub mt_root_tuple_slot: *mut TupleTableSlot,
    pub mt_partition_tuple_routing: *mut PartitionTupleRouting,
    pub mt_transition_capture: *mut TransitionCaptureState,
    pub mt_oc_transition_capture: *mut TransitionCaptureState,
    pub mt_per_subplan_tupconv_maps: *mut *mut TupleConversionMap,
}
impl Default for ModifyTableState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelAppendState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AppendState {
    pub ps: PlanState,
    pub appendplans: *mut *mut PlanState,
    pub as_nplans: ::std::os::raw::c_int,
    pub as_whichplan: ::std::os::raw::c_int,
    pub as_first_partial_plan: ::std::os::raw::c_int,
    pub as_pstate: *mut ParallelAppendState,
    pub pstate_len: Size,
    pub as_prune_state: *mut PartitionPruneState,
    pub as_valid_subplans: *mut Bitmapset,
    pub choose_next_subplan:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut AppendState) -> bool>,
}
impl Default for AppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppendState {
    pub ps: PlanState,
    pub mergeplans: *mut *mut PlanState,
    pub ms_nplans: ::std::os::raw::c_int,
    pub ms_nkeys: ::std::os::raw::c_int,
    pub ms_sortkeys: SortSupport,
    pub ms_slots: *mut *mut TupleTableSlot,
    pub ms_heap: *mut binaryheap,
    pub ms_initialized: bool,
    pub ms_prune_state: *mut PartitionPruneState,
    pub ms_valid_subplans: *mut Bitmapset,
}
impl Default for MergeAppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnionState {
    pub ps: PlanState,
    pub recursing: bool,
    pub intermediate_empty: bool,
    pub working_table: *mut Tuplestorestate,
    pub intermediate_table: *mut Tuplestorestate,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub tempContext: MemoryContext,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
}
impl Default for RecursiveUnionState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAndState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapAndState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOrState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapOrState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanState {
    pub ps: PlanState,
    pub ss_currentRelation: Relation,
    pub ss_currentScanDesc: *mut TableScanDescData,
    pub ss_ScanTupleSlot: *mut TupleTableSlot,
}
impl Default for ScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SeqScanState {
    pub ss: ScanState,
    pub pscan_len: Size,
}
impl Default for SeqScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScanState {
    pub ss: ScanState,
    pub args: *mut List,
    pub repeatable: *mut ExprState,
    pub tsmroutine: *mut TsmRoutine,
    pub tsm_state: *mut ::std::os::raw::c_void,
    pub use_bulkread: bool,
    pub use_pagemode: bool,
    pub begun: bool,
    pub seed: uint32,
    pub donetuples: int64,
    pub haveblock: bool,
    pub done: bool,
}
impl Default for SampleScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexRuntimeKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub key_expr: *mut ExprState,
    pub key_toastable: bool,
}
impl Default for IndexRuntimeKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexArrayKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub array_expr: *mut ExprState,
    pub next_elem: ::std::os::raw::c_int,
    pub num_elems: ::std::os::raw::c_int,
    pub elem_values: *mut Datum,
    pub elem_nulls: *mut bool,
}
impl Default for IndexArrayKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanState {
    pub ss: ScanState,
    pub indexqualorig: *mut ExprState,
    pub indexorderbyorig: *mut List,
    pub iss_ScanKeys: *mut ScanKeyData,
    pub iss_NumScanKeys: ::std::os::raw::c_int,
    pub iss_OrderByKeys: *mut ScanKeyData,
    pub iss_NumOrderByKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub iss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeysReady: bool,
    pub iss_RuntimeContext: *mut ExprContext,
    pub iss_RelationDesc: Relation,
    pub iss_ScanDesc: *mut IndexScanDescData,
    pub iss_ReorderQueue: *mut pairingheap,
    pub iss_ReachedEnd: bool,
    pub iss_OrderByValues: *mut Datum,
    pub iss_OrderByNulls: *mut bool,
    pub iss_SortSupport: SortSupport,
    pub iss_OrderByTypByVals: *mut bool,
    pub iss_OrderByTypLens: *mut int16,
    pub iss_PscanLen: Size,
}
impl Default for IndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScanState {
    pub ss: ScanState,
    pub recheckqual: *mut ExprState,
    pub ioss_ScanKeys: *mut ScanKeyData,
    pub ioss_NumScanKeys: ::std::os::raw::c_int,
    pub ioss_OrderByKeys: *mut ScanKeyData,
    pub ioss_NumOrderByKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub ioss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeysReady: bool,
    pub ioss_RuntimeContext: *mut ExprContext,
    pub ioss_RelationDesc: Relation,
    pub ioss_ScanDesc: *mut IndexScanDescData,
    pub ioss_TableSlot: *mut TupleTableSlot,
    pub ioss_VMBuffer: Buffer,
    pub ioss_PscanLen: Size,
}
impl Default for IndexOnlyScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScanState {
    pub ss: ScanState,
    pub biss_result: *mut TIDBitmap,
    pub biss_ScanKeys: *mut ScanKeyData,
    pub biss_NumScanKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub biss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub biss_ArrayKeys: *mut IndexArrayKeyInfo,
    pub biss_NumArrayKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeysReady: bool,
    pub biss_RuntimeContext: *mut ExprContext,
    pub biss_RelationDesc: Relation,
    pub biss_ScanDesc: *mut IndexScanDescData,
}
impl Default for BitmapIndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SharedBitmapState_BM_INITIAL: SharedBitmapState = 0;
pub const SharedBitmapState_BM_INPROGRESS: SharedBitmapState = 1;
pub const SharedBitmapState_BM_FINISHED: SharedBitmapState = 2;
pub type SharedBitmapState = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct ParallelBitmapHeapState {
    pub tbmiterator: dsa_pointer,
    pub prefetch_iterator: dsa_pointer,
    pub mutex: slock_t,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub state: SharedBitmapState,
    pub cv: ConditionVariable,
    pub phs_snapshot_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for ParallelBitmapHeapState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScanState {
    pub ss: ScanState,
    pub bitmapqualorig: *mut ExprState,
    pub tbm: *mut TIDBitmap,
    pub tbmiterator: *mut TBMIterator,
    pub tbmres: *mut TBMIterateResult,
    pub can_skip_fetch: bool,
    pub return_empty_tuples: ::std::os::raw::c_int,
    pub vmbuffer: Buffer,
    pub pvmbuffer: Buffer,
    pub exact_pages: ::std::os::raw::c_long,
    pub lossy_pages: ::std::os::raw::c_long,
    pub prefetch_iterator: *mut TBMIterator,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub prefetch_maximum: ::std::os::raw::c_int,
    pub pscan_len: Size,
    pub initialized: bool,
    pub shared_tbmiterator: *mut TBMSharedIterator,
    pub shared_prefetch_iterator: *mut TBMSharedIterator,
    pub pstate: *mut ParallelBitmapHeapState,
}
impl Default for BitmapHeapScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScanState {
    pub ss: ScanState,
    pub tss_tidexprs: *mut List,
    pub tss_isCurrentOf: bool,
    pub tss_NumTids: ::std::os::raw::c_int,
    pub tss_TidPtr: ::std::os::raw::c_int,
    pub tss_TidList: *mut ItemPointerData,
    pub tss_htup: HeapTupleData,
}
impl Default for TidScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScanState {
    pub ss: ScanState,
    pub subplan: *mut PlanState,
}
impl Default for SubqueryScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanPerFuncState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub ordinality: bool,
    pub simple: bool,
    pub ordinal: int64,
    pub nfuncs: ::std::os::raw::c_int,
    pub funcstates: *mut FunctionScanPerFuncState,
    pub argcontext: MemoryContext,
}
impl Default for FunctionScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScanState {
    pub ss: ScanState,
    pub rowcontext: *mut ExprContext,
    pub exprlists: *mut *mut List,
    pub exprstatelists: *mut *mut List,
    pub array_len: ::std::os::raw::c_int,
    pub curr_idx: ::std::os::raw::c_int,
}
impl Default for ValuesScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScanState {
    pub ss: ScanState,
    pub docexpr: *mut ExprState,
    pub rowexpr: *mut ExprState,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub ns_names: *mut List,
    pub ns_uris: *mut List,
    pub notnulls: *mut Bitmapset,
    pub opaque: *mut ::std::os::raw::c_void,
    pub routine: *mut TableFuncRoutine,
    pub in_functions: *mut FmgrInfo,
    pub typioparams: *mut Oid,
    pub ordinal: int64,
    pub perTableCxt: MemoryContext,
    pub tupstore: *mut Tuplestorestate,
}
impl Default for TableFuncScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub readptr: ::std::os::raw::c_int,
    pub cteplanstate: *mut PlanState,
    pub leader: *mut CteScanState,
    pub cte_table: *mut Tuplestorestate,
    pub eof_cte: bool,
}
impl Default for CteScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScanState {
    pub ss: ScanState,
    pub readptr: ::std::os::raw::c_int,
    pub tupdesc: TupleDesc,
    pub relation: *mut Tuplestorestate,
}
impl Default for NamedTuplestoreScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScanState {
    pub ss: ScanState,
    pub rustate: *mut RecursiveUnionState,
}
impl Default for WorkTableScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScanState {
    pub ss: ScanState,
    pub fdw_recheck_quals: *mut ExprState,
    pub pscan_len: Size,
    pub fdwroutine: *mut FdwRoutine,
    pub fdw_state: *mut ::std::os::raw::c_void,
}
impl Default for ForeignScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScanState {
    pub ss: ScanState,
    pub flags: uint32,
    pub custom_ps: *mut List,
    pub pscan_len: Size,
    pub methods: *const CustomExecMethods,
}
impl Default for CustomScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinState {
    pub ps: PlanState,
    pub jointype: JoinType,
    pub single_match: bool,
    pub joinqual: *mut ExprState,
}
impl Default for JoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopState {
    pub js: JoinState,
    pub nl_NeedNewOuter: bool,
    pub nl_MatchedOuter: bool,
    pub nl_NullInnerTupleSlot: *mut TupleTableSlot,
}
impl Default for NestLoopState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinClauseData {
    _unused: [u8; 0],
}
pub type MergeJoinClause = *mut MergeJoinClauseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinState {
    pub js: JoinState,
    pub mj_NumClauses: ::std::os::raw::c_int,
    pub mj_Clauses: MergeJoinClause,
    pub mj_JoinState: ::std::os::raw::c_int,
    pub mj_SkipMarkRestore: bool,
    pub mj_ExtraMarks: bool,
    pub mj_ConstFalseJoin: bool,
    pub mj_FillOuter: bool,
    pub mj_FillInner: bool,
    pub mj_MatchedOuter: bool,
    pub mj_MatchedInner: bool,
    pub mj_OuterTupleSlot: *mut TupleTableSlot,
    pub mj_InnerTupleSlot: *mut TupleTableSlot,
    pub mj_MarkedTupleSlot: *mut TupleTableSlot,
    pub mj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub mj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub mj_OuterEContext: *mut ExprContext,
    pub mj_InnerEContext: *mut ExprContext,
}
impl Default for MergeJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTupleData {
    _unused: [u8; 0],
}
pub type HashJoinTuple = *mut HashJoinTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTableData {
    _unused: [u8; 0],
}
pub type HashJoinTable = *mut HashJoinTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinState {
    pub js: JoinState,
    pub hashclauses: *mut ExprState,
    pub hj_OuterHashKeys: *mut List,
    pub hj_HashOperators: *mut List,
    pub hj_Collations: *mut List,
    pub hj_HashTable: HashJoinTable,
    pub hj_CurHashValue: uint32,
    pub hj_CurBucketNo: ::std::os::raw::c_int,
    pub hj_CurSkewBucketNo: ::std::os::raw::c_int,
    pub hj_CurTuple: HashJoinTuple,
    pub hj_OuterTupleSlot: *mut TupleTableSlot,
    pub hj_HashTupleSlot: *mut TupleTableSlot,
    pub hj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub hj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub hj_FirstOuterTupleSlot: *mut TupleTableSlot,
    pub hj_JoinState: ::std::os::raw::c_int,
    pub hj_MatchedOuter: bool,
    pub hj_OuterNotEmpty: bool,
}
impl Default for HashJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MaterialState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub eof_underlying: bool,
    pub tuplestorestate: *mut Tuplestorestate,
}
impl Default for MaterialState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PresortedKeyData {
    pub flinfo: FmgrInfo,
    pub fcinfo: FunctionCallInfo,
    pub attno: OffsetNumber,
}
impl Default for PresortedKeyData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SharedSortInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinstrument: __IncompleteArrayField<TuplesortInstrumentation>,
}
impl Default for SharedSortInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortState {
    pub ss: ScanState,
    pub randomAccess: bool,
    pub bounded: bool,
    pub bound: int64,
    pub sort_Done: bool,
    pub bounded_Done: bool,
    pub bound_Done: int64,
    pub tuplesortstate: *mut ::std::os::raw::c_void,
    pub am_worker: bool,
    pub shared_info: *mut SharedSortInfo,
}
impl Default for SortState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IncrementalSortGroupInfo {
    pub groupCount: int64,
    pub maxDiskSpaceUsed: int64,
    pub totalDiskSpaceUsed: int64,
    pub maxMemorySpaceUsed: int64,
    pub totalMemorySpaceUsed: int64,
    pub sortMethods: bits32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IncrementalSortInfo {
    pub fullsortGroupInfo: IncrementalSortGroupInfo,
    pub prefixsortGroupInfo: IncrementalSortGroupInfo,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedIncrementalSortInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinfo: __IncompleteArrayField<IncrementalSortInfo>,
}
pub const IncrementalSortExecutionStatus_INCSORT_LOADFULLSORT: IncrementalSortExecutionStatus = 0;
pub const IncrementalSortExecutionStatus_INCSORT_LOADPREFIXSORT: IncrementalSortExecutionStatus = 1;
pub const IncrementalSortExecutionStatus_INCSORT_READFULLSORT: IncrementalSortExecutionStatus = 2;
pub const IncrementalSortExecutionStatus_INCSORT_READPREFIXSORT: IncrementalSortExecutionStatus = 3;
pub type IncrementalSortExecutionStatus = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSortState {
    pub ss: ScanState,
    pub bounded: bool,
    pub bound: int64,
    pub outerNodeDone: bool,
    pub bound_Done: int64,
    pub execution_status: IncrementalSortExecutionStatus,
    pub n_fullsort_remaining: int64,
    pub fullsort_state: *mut Tuplesortstate,
    pub prefixsort_state: *mut Tuplesortstate,
    pub presorted_keys: *mut PresortedKeyData,
    pub incsort_info: IncrementalSortInfo,
    pub group_pivot: *mut TupleTableSlot,
    pub transfer_tuple: *mut TupleTableSlot,
    pub am_worker: bool,
    pub shared_info: *mut SharedIncrementalSortInfo,
}
impl Default for IncrementalSortState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupState {
    pub ss: ScanState,
    pub eqfunction: *mut ExprState,
    pub grp_done: bool,
}
impl Default for GroupState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AggregateInstrumentation {
    pub hash_mem_peak: Size,
    pub hash_disk_used: uint64,
    pub hash_batches_used: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedAggInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinstrument: __IncompleteArrayField<AggregateInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerAggData {
    _unused: [u8; 0],
}
pub type AggStatePerAgg = *mut AggStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerTransData {
    _unused: [u8; 0],
}
pub type AggStatePerTrans = *mut AggStatePerTransData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerGroupData {
    _unused: [u8; 0],
}
pub type AggStatePerGroup = *mut AggStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerPhaseData {
    _unused: [u8; 0],
}
pub type AggStatePerPhase = *mut AggStatePerPhaseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerHashData {
    _unused: [u8; 0],
}
pub type AggStatePerHash = *mut AggStatePerHashData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggState {
    pub ss: ScanState,
    pub aggs: *mut List,
    pub numaggs: ::std::os::raw::c_int,
    pub numtrans: ::std::os::raw::c_int,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub phase: AggStatePerPhase,
    pub numphases: ::std::os::raw::c_int,
    pub current_phase: ::std::os::raw::c_int,
    pub peragg: AggStatePerAgg,
    pub pertrans: AggStatePerTrans,
    pub hashcontext: *mut ExprContext,
    pub aggcontexts: *mut *mut ExprContext,
    pub tmpcontext: *mut ExprContext,
    pub curaggcontext: *mut ExprContext,
    pub curperagg: AggStatePerAgg,
    pub curpertrans: AggStatePerTrans,
    pub input_done: bool,
    pub agg_done: bool,
    pub projected_set: ::std::os::raw::c_int,
    pub current_set: ::std::os::raw::c_int,
    pub grouped_cols: *mut Bitmapset,
    pub all_grouped_cols: *mut List,
    pub colnos_needed: *mut Bitmapset,
    pub max_colno_needed: ::std::os::raw::c_int,
    pub all_cols_needed: bool,
    pub maxsets: ::std::os::raw::c_int,
    pub phases: AggStatePerPhase,
    pub sort_in: *mut Tuplesortstate,
    pub sort_out: *mut Tuplesortstate,
    pub sort_slot: *mut TupleTableSlot,
    pub pergroups: *mut AggStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub table_filled: bool,
    pub num_hashes: ::std::os::raw::c_int,
    pub hash_metacxt: MemoryContext,
    pub hash_tapeinfo: *mut HashTapeInfo,
    pub hash_spills: *mut HashAggSpill,
    pub hash_spill_rslot: *mut TupleTableSlot,
    pub hash_spill_wslot: *mut TupleTableSlot,
    pub hash_batches: *mut List,
    pub hash_ever_spilled: bool,
    pub hash_spill_mode: bool,
    pub hash_mem_limit: Size,
    pub hash_ngroups_limit: uint64,
    pub hash_planned_partitions: ::std::os::raw::c_int,
    pub hashentrysize: f64,
    pub hash_mem_peak: Size,
    pub hash_ngroups_current: uint64,
    pub hash_disk_used: uint64,
    pub hash_batches_used: ::std::os::raw::c_int,
    pub perhash: AggStatePerHash,
    pub hash_pergroup: *mut AggStatePerGroup,
    pub all_pergroups: *mut AggStatePerGroup,
    pub combinedproj: *mut ProjectionInfo,
    pub shared_info: *mut SharedAggInfo,
}
impl Default for AggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerFuncData {
    _unused: [u8; 0],
}
pub type WindowStatePerFunc = *mut WindowStatePerFuncData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerAggData {
    _unused: [u8; 0],
}
pub type WindowStatePerAgg = *mut WindowStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAggState {
    pub ss: ScanState,
    pub funcs: *mut List,
    pub numfuncs: ::std::os::raw::c_int,
    pub numaggs: ::std::os::raw::c_int,
    pub perfunc: WindowStatePerFunc,
    pub peragg: WindowStatePerAgg,
    pub partEqfunction: *mut ExprState,
    pub ordEqfunction: *mut ExprState,
    pub buffer: *mut Tuplestorestate,
    pub current_ptr: ::std::os::raw::c_int,
    pub framehead_ptr: ::std::os::raw::c_int,
    pub frametail_ptr: ::std::os::raw::c_int,
    pub grouptail_ptr: ::std::os::raw::c_int,
    pub spooled_rows: int64,
    pub currentpos: int64,
    pub frameheadpos: int64,
    pub frametailpos: int64,
    pub agg_winobj: *mut WindowObjectData,
    pub aggregatedbase: int64,
    pub aggregatedupto: int64,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut ExprState,
    pub endOffset: *mut ExprState,
    pub startOffsetValue: Datum,
    pub endOffsetValue: Datum,
    pub startInRangeFunc: FmgrInfo,
    pub endInRangeFunc: FmgrInfo,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub currentgroup: int64,
    pub frameheadgroup: int64,
    pub frametailgroup: int64,
    pub groupheadpos: int64,
    pub grouptailpos: int64,
    pub partcontext: MemoryContext,
    pub aggcontext: MemoryContext,
    pub curaggcontext: MemoryContext,
    pub tmpcontext: *mut ExprContext,
    pub all_first: bool,
    pub all_done: bool,
    pub partition_spooled: bool,
    pub more_partitions: bool,
    pub framehead_valid: bool,
    pub frametail_valid: bool,
    pub grouptail_valid: bool,
    pub first_part_slot: *mut TupleTableSlot,
    pub framehead_slot: *mut TupleTableSlot,
    pub frametail_slot: *mut TupleTableSlot,
    pub agg_row_slot: *mut TupleTableSlot,
    pub temp_slot_1: *mut TupleTableSlot,
    pub temp_slot_2: *mut TupleTableSlot,
}
impl Default for WindowAggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UniqueState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
}
impl Default for UniqueState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherState {
    pub ps: PlanState,
    pub initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub funnel_slot: *mut TupleTableSlot,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub nextreader: ::std::os::raw::c_int,
    pub reader: *mut *mut TupleQueueReader,
}
impl Default for GatherState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GMReaderTupleBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMergeState {
    pub ps: PlanState,
    pub initialized: bool,
    pub gm_initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub tupDesc: TupleDesc,
    pub gm_nkeys: ::std::os::raw::c_int,
    pub gm_sortkeys: SortSupport,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub gm_slots: *mut *mut TupleTableSlot,
    pub reader: *mut *mut TupleQueueReader,
    pub gm_tuple_buffers: *mut GMReaderTupleBuffer,
    pub gm_heap: *mut binaryheap,
}
impl Default for GatherMergeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct HashInstrumentation {
    pub nbuckets: ::std::os::raw::c_int,
    pub nbuckets_original: ::std::os::raw::c_int,
    pub nbatch: ::std::os::raw::c_int,
    pub nbatch_original: ::std::os::raw::c_int,
    pub space_peak: Size,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedHashInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub hinstrument: __IncompleteArrayField<HashInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashState {
    pub ps: PlanState,
    pub hashtable: HashJoinTable,
    pub hashkeys: *mut List,
    pub shared_info: *mut SharedHashInfo,
    pub hinstrument: *mut HashInstrumentation,
    pub parallel_state: *mut ParallelHashJoinState,
}
impl Default for HashState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpStatePerGroupData {
    _unused: [u8; 0],
}
pub type SetOpStatePerGroup = *mut SetOpStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub setop_done: bool,
    pub numOutput: ::std::os::raw::c_long,
    pub pergroup: SetOpStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
    pub table_filled: bool,
    pub hashiter: TupleHashIterator,
}
impl Default for SetOpState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRowsState {
    pub ps: PlanState,
    pub lr_arowMarks: *mut List,
    pub lr_epqstate: EPQState,
}
impl Default for LockRowsState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const LimitStateCond_LIMIT_INITIAL: LimitStateCond = 0;
pub const LimitStateCond_LIMIT_RESCAN: LimitStateCond = 1;
pub const LimitStateCond_LIMIT_EMPTY: LimitStateCond = 2;
pub const LimitStateCond_LIMIT_INWINDOW: LimitStateCond = 3;
pub const LimitStateCond_LIMIT_WINDOWEND_TIES: LimitStateCond = 4;
pub const LimitStateCond_LIMIT_SUBPLANEOF: LimitStateCond = 5;
pub const LimitStateCond_LIMIT_WINDOWEND: LimitStateCond = 6;
pub const LimitStateCond_LIMIT_WINDOWSTART: LimitStateCond = 7;
pub type LimitStateCond = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LimitState {
    pub ps: PlanState,
    pub limitOffset: *mut ExprState,
    pub limitCount: *mut ExprState,
    pub limitOption: LimitOption,
    pub offset: int64,
    pub count: int64,
    pub noCount: bool,
    pub lstate: LimitStateCond,
    pub position: int64,
    pub subSlot: *mut TupleTableSlot,
    pub eqfunction: *mut ExprState,
    pub last_slot: *mut TupleTableSlot,
}
impl Default for LimitState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CommandTag_CMDTAG_UNKNOWN: CommandTag = 0;
pub const CommandTag_CMDTAG_ALTER_ACCESS_METHOD: CommandTag = 1;
pub const CommandTag_CMDTAG_ALTER_AGGREGATE: CommandTag = 2;
pub const CommandTag_CMDTAG_ALTER_CAST: CommandTag = 3;
pub const CommandTag_CMDTAG_ALTER_COLLATION: CommandTag = 4;
pub const CommandTag_CMDTAG_ALTER_CONSTRAINT: CommandTag = 5;
pub const CommandTag_CMDTAG_ALTER_CONVERSION: CommandTag = 6;
pub const CommandTag_CMDTAG_ALTER_DATABASE: CommandTag = 7;
pub const CommandTag_CMDTAG_ALTER_DEFAULT_PRIVILEGES: CommandTag = 8;
pub const CommandTag_CMDTAG_ALTER_DOMAIN: CommandTag = 9;
pub const CommandTag_CMDTAG_ALTER_EVENT_TRIGGER: CommandTag = 10;
pub const CommandTag_CMDTAG_ALTER_EXTENSION: CommandTag = 11;
pub const CommandTag_CMDTAG_ALTER_FOREIGN_DATA_WRAPPER: CommandTag = 12;
pub const CommandTag_CMDTAG_ALTER_FOREIGN_TABLE: CommandTag = 13;
pub const CommandTag_CMDTAG_ALTER_FUNCTION: CommandTag = 14;
pub const CommandTag_CMDTAG_ALTER_INDEX: CommandTag = 15;
pub const CommandTag_CMDTAG_ALTER_LANGUAGE: CommandTag = 16;
pub const CommandTag_CMDTAG_ALTER_LARGE_OBJECT: CommandTag = 17;
pub const CommandTag_CMDTAG_ALTER_MATERIALIZED_VIEW: CommandTag = 18;
pub const CommandTag_CMDTAG_ALTER_OPERATOR: CommandTag = 19;
pub const CommandTag_CMDTAG_ALTER_OPERATOR_CLASS: CommandTag = 20;
pub const CommandTag_CMDTAG_ALTER_OPERATOR_FAMILY: CommandTag = 21;
pub const CommandTag_CMDTAG_ALTER_POLICY: CommandTag = 22;
pub const CommandTag_CMDTAG_ALTER_PROCEDURE: CommandTag = 23;
pub const CommandTag_CMDTAG_ALTER_PUBLICATION: CommandTag = 24;
pub const CommandTag_CMDTAG_ALTER_ROLE: CommandTag = 25;
pub const CommandTag_CMDTAG_ALTER_ROUTINE: CommandTag = 26;
pub const CommandTag_CMDTAG_ALTER_RULE: CommandTag = 27;
pub const CommandTag_CMDTAG_ALTER_SCHEMA: CommandTag = 28;
pub const CommandTag_CMDTAG_ALTER_SEQUENCE: CommandTag = 29;
pub const CommandTag_CMDTAG_ALTER_SERVER: CommandTag = 30;
pub const CommandTag_CMDTAG_ALTER_STATISTICS: CommandTag = 31;
pub const CommandTag_CMDTAG_ALTER_SUBSCRIPTION: CommandTag = 32;
pub const CommandTag_CMDTAG_ALTER_SYSTEM: CommandTag = 33;
pub const CommandTag_CMDTAG_ALTER_TABLE: CommandTag = 34;
pub const CommandTag_CMDTAG_ALTER_TABLESPACE: CommandTag = 35;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_CONFIGURATION: CommandTag = 36;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_DICTIONARY: CommandTag = 37;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_PARSER: CommandTag = 38;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_TEMPLATE: CommandTag = 39;
pub const CommandTag_CMDTAG_ALTER_TRANSFORM: CommandTag = 40;
pub const CommandTag_CMDTAG_ALTER_TRIGGER: CommandTag = 41;
pub const CommandTag_CMDTAG_ALTER_TYPE: CommandTag = 42;
pub const CommandTag_CMDTAG_ALTER_USER_MAPPING: CommandTag = 43;
pub const CommandTag_CMDTAG_ALTER_VIEW: CommandTag = 44;
pub const CommandTag_CMDTAG_ANALYZE: CommandTag = 45;
pub const CommandTag_CMDTAG_BEGIN: CommandTag = 46;
pub const CommandTag_CMDTAG_CALL: CommandTag = 47;
pub const CommandTag_CMDTAG_CHECKPOINT: CommandTag = 48;
pub const CommandTag_CMDTAG_CLOSE: CommandTag = 49;
pub const CommandTag_CMDTAG_CLOSE_CURSOR: CommandTag = 50;
pub const CommandTag_CMDTAG_CLOSE_CURSOR_ALL: CommandTag = 51;
pub const CommandTag_CMDTAG_CLUSTER: CommandTag = 52;
pub const CommandTag_CMDTAG_COMMENT: CommandTag = 53;
pub const CommandTag_CMDTAG_COMMIT: CommandTag = 54;
pub const CommandTag_CMDTAG_COMMIT_PREPARED: CommandTag = 55;
pub const CommandTag_CMDTAG_COPY: CommandTag = 56;
pub const CommandTag_CMDTAG_COPY_FROM: CommandTag = 57;
pub const CommandTag_CMDTAG_CREATE_ACCESS_METHOD: CommandTag = 58;
pub const CommandTag_CMDTAG_CREATE_AGGREGATE: CommandTag = 59;
pub const CommandTag_CMDTAG_CREATE_CAST: CommandTag = 60;
pub const CommandTag_CMDTAG_CREATE_COLLATION: CommandTag = 61;
pub const CommandTag_CMDTAG_CREATE_CONSTRAINT: CommandTag = 62;
pub const CommandTag_CMDTAG_CREATE_CONVERSION: CommandTag = 63;
pub const CommandTag_CMDTAG_CREATE_DATABASE: CommandTag = 64;
pub const CommandTag_CMDTAG_CREATE_DOMAIN: CommandTag = 65;
pub const CommandTag_CMDTAG_CREATE_EVENT_TRIGGER: CommandTag = 66;
pub const CommandTag_CMDTAG_CREATE_EXTENSION: CommandTag = 67;
pub const CommandTag_CMDTAG_CREATE_FOREIGN_DATA_WRAPPER: CommandTag = 68;
pub const CommandTag_CMDTAG_CREATE_FOREIGN_TABLE: CommandTag = 69;
pub const CommandTag_CMDTAG_CREATE_FUNCTION: CommandTag = 70;
pub const CommandTag_CMDTAG_CREATE_INDEX: CommandTag = 71;
pub const CommandTag_CMDTAG_CREATE_LANGUAGE: CommandTag = 72;
pub const CommandTag_CMDTAG_CREATE_MATERIALIZED_VIEW: CommandTag = 73;
pub const CommandTag_CMDTAG_CREATE_OPERATOR: CommandTag = 74;
pub const CommandTag_CMDTAG_CREATE_OPERATOR_CLASS: CommandTag = 75;
pub const CommandTag_CMDTAG_CREATE_OPERATOR_FAMILY: CommandTag = 76;
pub const CommandTag_CMDTAG_CREATE_POLICY: CommandTag = 77;
pub const CommandTag_CMDTAG_CREATE_PROCEDURE: CommandTag = 78;
pub const CommandTag_CMDTAG_CREATE_PUBLICATION: CommandTag = 79;
pub const CommandTag_CMDTAG_CREATE_ROLE: CommandTag = 80;
pub const CommandTag_CMDTAG_CREATE_ROUTINE: CommandTag = 81;
pub const CommandTag_CMDTAG_CREATE_RULE: CommandTag = 82;
pub const CommandTag_CMDTAG_CREATE_SCHEMA: CommandTag = 83;
pub const CommandTag_CMDTAG_CREATE_SEQUENCE: CommandTag = 84;
pub const CommandTag_CMDTAG_CREATE_SERVER: CommandTag = 85;
pub const CommandTag_CMDTAG_CREATE_STATISTICS: CommandTag = 86;
pub const CommandTag_CMDTAG_CREATE_SUBSCRIPTION: CommandTag = 87;
pub const CommandTag_CMDTAG_CREATE_TABLE: CommandTag = 88;
pub const CommandTag_CMDTAG_CREATE_TABLE_AS: CommandTag = 89;
pub const CommandTag_CMDTAG_CREATE_TABLESPACE: CommandTag = 90;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_CONFIGURATION: CommandTag = 91;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_DICTIONARY: CommandTag = 92;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_PARSER: CommandTag = 93;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_TEMPLATE: CommandTag = 94;
pub const CommandTag_CMDTAG_CREATE_TRANSFORM: CommandTag = 95;
pub const CommandTag_CMDTAG_CREATE_TRIGGER: CommandTag = 96;
pub const CommandTag_CMDTAG_CREATE_TYPE: CommandTag = 97;
pub const CommandTag_CMDTAG_CREATE_USER_MAPPING: CommandTag = 98;
pub const CommandTag_CMDTAG_CREATE_VIEW: CommandTag = 99;
pub const CommandTag_CMDTAG_DEALLOCATE: CommandTag = 100;
pub const CommandTag_CMDTAG_DEALLOCATE_ALL: CommandTag = 101;
pub const CommandTag_CMDTAG_DECLARE_CURSOR: CommandTag = 102;
pub const CommandTag_CMDTAG_DELETE: CommandTag = 103;
pub const CommandTag_CMDTAG_DISCARD: CommandTag = 104;
pub const CommandTag_CMDTAG_DISCARD_ALL: CommandTag = 105;
pub const CommandTag_CMDTAG_DISCARD_PLANS: CommandTag = 106;
pub const CommandTag_CMDTAG_DISCARD_SEQUENCES: CommandTag = 107;
pub const CommandTag_CMDTAG_DISCARD_TEMP: CommandTag = 108;
pub const CommandTag_CMDTAG_DO: CommandTag = 109;
pub const CommandTag_CMDTAG_DROP_ACCESS_METHOD: CommandTag = 110;
pub const CommandTag_CMDTAG_DROP_AGGREGATE: CommandTag = 111;
pub const CommandTag_CMDTAG_DROP_CAST: CommandTag = 112;
pub const CommandTag_CMDTAG_DROP_COLLATION: CommandTag = 113;
pub const CommandTag_CMDTAG_DROP_CONSTRAINT: CommandTag = 114;
pub const CommandTag_CMDTAG_DROP_CONVERSION: CommandTag = 115;
pub const CommandTag_CMDTAG_DROP_DATABASE: CommandTag = 116;
pub const CommandTag_CMDTAG_DROP_DOMAIN: CommandTag = 117;
pub const CommandTag_CMDTAG_DROP_EVENT_TRIGGER: CommandTag = 118;
pub const CommandTag_CMDTAG_DROP_EXTENSION: CommandTag = 119;
pub const CommandTag_CMDTAG_DROP_FOREIGN_DATA_WRAPPER: CommandTag = 120;
pub const CommandTag_CMDTAG_DROP_FOREIGN_TABLE: CommandTag = 121;
pub const CommandTag_CMDTAG_DROP_FUNCTION: CommandTag = 122;
pub const CommandTag_CMDTAG_DROP_INDEX: CommandTag = 123;
pub const CommandTag_CMDTAG_DROP_LANGUAGE: CommandTag = 124;
pub const CommandTag_CMDTAG_DROP_MATERIALIZED_VIEW: CommandTag = 125;
pub const CommandTag_CMDTAG_DROP_OPERATOR: CommandTag = 126;
pub const CommandTag_CMDTAG_DROP_OPERATOR_CLASS: CommandTag = 127;
pub const CommandTag_CMDTAG_DROP_OPERATOR_FAMILY: CommandTag = 128;
pub const CommandTag_CMDTAG_DROP_OWNED: CommandTag = 129;
pub const CommandTag_CMDTAG_DROP_POLICY: CommandTag = 130;
pub const CommandTag_CMDTAG_DROP_PROCEDURE: CommandTag = 131;
pub const CommandTag_CMDTAG_DROP_PUBLICATION: CommandTag = 132;
pub const CommandTag_CMDTAG_DROP_ROLE: CommandTag = 133;
pub const CommandTag_CMDTAG_DROP_ROUTINE: CommandTag = 134;
pub const CommandTag_CMDTAG_DROP_RULE: CommandTag = 135;
pub const CommandTag_CMDTAG_DROP_SCHEMA: CommandTag = 136;
pub const CommandTag_CMDTAG_DROP_SEQUENCE: CommandTag = 137;
pub const CommandTag_CMDTAG_DROP_SERVER: CommandTag = 138;
pub const CommandTag_CMDTAG_DROP_STATISTICS: CommandTag = 139;
pub const CommandTag_CMDTAG_DROP_SUBSCRIPTION: CommandTag = 140;
pub const CommandTag_CMDTAG_DROP_TABLE: CommandTag = 141;
pub const CommandTag_CMDTAG_DROP_TABLESPACE: CommandTag = 142;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_CONFIGURATION: CommandTag = 143;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_DICTIONARY: CommandTag = 144;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_PARSER: CommandTag = 145;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_TEMPLATE: CommandTag = 146;
pub const CommandTag_CMDTAG_DROP_TRANSFORM: CommandTag = 147;
pub const CommandTag_CMDTAG_DROP_TRIGGER: CommandTag = 148;
pub const CommandTag_CMDTAG_DROP_TYPE: CommandTag = 149;
pub const CommandTag_CMDTAG_DROP_USER_MAPPING: CommandTag = 150;
pub const CommandTag_CMDTAG_DROP_VIEW: CommandTag = 151;
pub const CommandTag_CMDTAG_EXECUTE: CommandTag = 152;
pub const CommandTag_CMDTAG_EXPLAIN: CommandTag = 153;
pub const CommandTag_CMDTAG_FETCH: CommandTag = 154;
pub const CommandTag_CMDTAG_GRANT: CommandTag = 155;
pub const CommandTag_CMDTAG_GRANT_ROLE: CommandTag = 156;
pub const CommandTag_CMDTAG_IMPORT_FOREIGN_SCHEMA: CommandTag = 157;
pub const CommandTag_CMDTAG_INSERT: CommandTag = 158;
pub const CommandTag_CMDTAG_LISTEN: CommandTag = 159;
pub const CommandTag_CMDTAG_LOAD: CommandTag = 160;
pub const CommandTag_CMDTAG_LOCK_TABLE: CommandTag = 161;
pub const CommandTag_CMDTAG_MOVE: CommandTag = 162;
pub const CommandTag_CMDTAG_NOTIFY: CommandTag = 163;
pub const CommandTag_CMDTAG_PREPARE: CommandTag = 164;
pub const CommandTag_CMDTAG_PREPARE_TRANSACTION: CommandTag = 165;
pub const CommandTag_CMDTAG_REASSIGN_OWNED: CommandTag = 166;
pub const CommandTag_CMDTAG_REFRESH_MATERIALIZED_VIEW: CommandTag = 167;
pub const CommandTag_CMDTAG_REINDEX: CommandTag = 168;
pub const CommandTag_CMDTAG_RELEASE: CommandTag = 169;
pub const CommandTag_CMDTAG_RESET: CommandTag = 170;
pub const CommandTag_CMDTAG_REVOKE: CommandTag = 171;
pub const CommandTag_CMDTAG_REVOKE_ROLE: CommandTag = 172;
pub const CommandTag_CMDTAG_ROLLBACK: CommandTag = 173;
pub const CommandTag_CMDTAG_ROLLBACK_PREPARED: CommandTag = 174;
pub const CommandTag_CMDTAG_SAVEPOINT: CommandTag = 175;
pub const CommandTag_CMDTAG_SECURITY_LABEL: CommandTag = 176;
pub const CommandTag_CMDTAG_SELECT: CommandTag = 177;
pub const CommandTag_CMDTAG_SELECT_FOR_KEY_SHARE: CommandTag = 178;
pub const CommandTag_CMDTAG_SELECT_FOR_NO_KEY_UPDATE: CommandTag = 179;
pub const CommandTag_CMDTAG_SELECT_FOR_SHARE: CommandTag = 180;
pub const CommandTag_CMDTAG_SELECT_FOR_UPDATE: CommandTag = 181;
pub const CommandTag_CMDTAG_SELECT_INTO: CommandTag = 182;
pub const CommandTag_CMDTAG_SET: CommandTag = 183;
pub const CommandTag_CMDTAG_SET_CONSTRAINTS: CommandTag = 184;
pub const CommandTag_CMDTAG_SHOW: CommandTag = 185;
pub const CommandTag_CMDTAG_START_TRANSACTION: CommandTag = 186;
pub const CommandTag_CMDTAG_TRUNCATE_TABLE: CommandTag = 187;
pub const CommandTag_CMDTAG_UNLISTEN: CommandTag = 188;
pub const CommandTag_CMDTAG_UPDATE: CommandTag = 189;
pub const CommandTag_CMDTAG_VACUUM: CommandTag = 190;
pub const CommandTag_COMMAND_TAG_NEXTTAG: CommandTag = 191;
pub type CommandTag = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryCompletion {
    pub commandTag: CommandTag,
    pub nprocessed: uint64,
}
impl Default for QueryCompletion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn InitializeQueryCompletion(arg_qc: *mut QueryCompletion) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitializeQueryCompletion(arg_qc: *mut QueryCompletion);
        }
        InitializeQueryCompletion(arg_qc)
    })
}
pub unsafe fn GetCommandTagName(arg_commandTag: CommandTag) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetCommandTagName(arg_commandTag: CommandTag) -> *const ::std::os::raw::c_char;
        }
        GetCommandTagName(arg_commandTag)
    })
}
pub unsafe fn command_tag_display_rowcount(arg_commandTag: CommandTag) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn command_tag_display_rowcount(arg_commandTag: CommandTag) -> bool;
        }
        command_tag_display_rowcount(arg_commandTag)
    })
}
pub unsafe fn command_tag_event_trigger_ok(arg_commandTag: CommandTag) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn command_tag_event_trigger_ok(arg_commandTag: CommandTag) -> bool;
        }
        command_tag_event_trigger_ok(arg_commandTag)
    })
}
pub unsafe fn command_tag_table_rewrite_ok(arg_commandTag: CommandTag) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn command_tag_table_rewrite_ok(arg_commandTag: CommandTag) -> bool;
        }
        command_tag_table_rewrite_ok(arg_commandTag)
    })
}
pub unsafe fn GetCommandTagEnum(arg_tagname: *const ::std::os::raw::c_char) -> CommandTag {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetCommandTagEnum(arg_tagname: *const ::std::os::raw::c_char) -> CommandTag;
        }
        GetCommandTagEnum(arg_tagname)
    })
}
pub const CommandDest_DestNone: CommandDest = 0;
pub const CommandDest_DestDebug: CommandDest = 1;
pub const CommandDest_DestRemote: CommandDest = 2;
pub const CommandDest_DestRemoteExecute: CommandDest = 3;
pub const CommandDest_DestRemoteSimple: CommandDest = 4;
pub const CommandDest_DestSPI: CommandDest = 5;
pub const CommandDest_DestTuplestore: CommandDest = 6;
pub const CommandDest_DestIntoRel: CommandDest = 7;
pub const CommandDest_DestCopyOut: CommandDest = 8;
pub const CommandDest_DestSQLFunction: CommandDest = 9;
pub const CommandDest_DestTransientRel: CommandDest = 10;
pub const CommandDest_DestTupleQueue: CommandDest = 11;
pub type CommandDest = ::std::os::raw::c_uint;
pub type DestReceiver = _DestReceiver;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DestReceiver {
    pub receiveSlot: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, self_: *mut DestReceiver) -> bool,
    >,
    pub rStartup: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut DestReceiver,
            operation: ::std::os::raw::c_int,
            typeinfo: TupleDesc,
        ),
    >,
    pub rShutdown: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub rDestroy: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub mydest: CommandDest,
}
impl Default for _DestReceiver {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut None_Receiver: *mut DestReceiver;
}
pub unsafe fn BeginCommand(arg_commandTag: CommandTag, arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BeginCommand(arg_commandTag: CommandTag, arg_dest: CommandDest);
        }
        BeginCommand(arg_commandTag, arg_dest)
    })
}
pub unsafe fn CreateDestReceiver(arg_dest: CommandDest) -> *mut DestReceiver {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateDestReceiver(arg_dest: CommandDest) -> *mut DestReceiver;
        }
        CreateDestReceiver(arg_dest)
    })
}
pub unsafe fn EndCommand(
    arg_qc: *const QueryCompletion,
    arg_dest: CommandDest,
    arg_force_undecorated_output: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EndCommand(
                arg_qc: *const QueryCompletion,
                arg_dest: CommandDest,
                arg_force_undecorated_output: bool,
            );
        }
        EndCommand(arg_qc, arg_dest, arg_force_undecorated_output)
    })
}
pub unsafe fn EndReplicationCommand(arg_commandTag: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EndReplicationCommand(arg_commandTag: *const ::std::os::raw::c_char);
        }
        EndReplicationCommand(arg_commandTag)
    })
}
pub unsafe fn NullCommand(arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn NullCommand(arg_dest: CommandDest);
        }
        NullCommand(arg_dest)
    })
}
pub unsafe fn ReadyForQuery(arg_dest: CommandDest) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReadyForQuery(arg_dest: CommandDest);
        }
        ReadyForQuery(arg_dest)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryDesc {
    pub operation: CmdType,
    pub plannedstmt: *mut PlannedStmt,
    pub sourceText: *const ::std::os::raw::c_char,
    pub snapshot: Snapshot,
    pub crosscheck_snapshot: Snapshot,
    pub dest: *mut DestReceiver,
    pub params: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
    pub instrument_options: ::std::os::raw::c_int,
    pub tupDesc: TupleDesc,
    pub estate: *mut EState,
    pub planstate: *mut PlanState,
    pub already_executed: bool,
    pub totaltime: *mut Instrumentation,
}
impl Default for QueryDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn CreateQueryDesc(
    arg_plannedstmt: *mut PlannedStmt,
    arg_sourceText: *const ::std::os::raw::c_char,
    arg_snapshot: Snapshot,
    arg_crosscheck_snapshot: Snapshot,
    arg_dest: *mut DestReceiver,
    arg_params: ParamListInfo,
    arg_queryEnv: *mut QueryEnvironment,
    arg_instrument_options: ::std::os::raw::c_int,
) -> *mut QueryDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateQueryDesc(
                arg_plannedstmt: *mut PlannedStmt,
                arg_sourceText: *const ::std::os::raw::c_char,
                arg_snapshot: Snapshot,
                arg_crosscheck_snapshot: Snapshot,
                arg_dest: *mut DestReceiver,
                arg_params: ParamListInfo,
                arg_queryEnv: *mut QueryEnvironment,
                arg_instrument_options: ::std::os::raw::c_int,
            ) -> *mut QueryDesc;
        }
        CreateQueryDesc(
            arg_plannedstmt,
            arg_sourceText,
            arg_snapshot,
            arg_crosscheck_snapshot,
            arg_dest,
            arg_params,
            arg_queryEnv,
            arg_instrument_options,
        )
    })
}
pub unsafe fn FreeQueryDesc(arg_qdesc: *mut QueryDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeQueryDesc(arg_qdesc: *mut QueryDesc);
        }
        FreeQueryDesc(arg_qdesc)
    })
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Value {
    pub type_: NodeTag,
    pub val: Value_ValUnion,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Value_ValUnion {
    pub ival: ::std::os::raw::c_int,
    pub str_: *mut ::std::os::raw::c_char,
}
impl Default for Value_ValUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for Value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn makeInteger(arg_i: ::std::os::raw::c_int) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeInteger(arg_i: ::std::os::raw::c_int) -> *mut Value;
        }
        makeInteger(arg_i)
    })
}
pub unsafe fn makeFloat(arg_numericStr: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeFloat(arg_numericStr: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeFloat(arg_numericStr)
    })
}
pub unsafe fn makeString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeString(arg_str_)
    })
}
pub unsafe fn makeBitString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn makeBitString(arg_str_: *mut ::std::os::raw::c_char) -> *mut Value;
        }
        makeBitString(arg_str_)
    })
}
pub const OverridingKind_OVERRIDING_NOT_SET: OverridingKind = 0;
pub const OverridingKind_OVERRIDING_USER_VALUE: OverridingKind = 1;
pub const OverridingKind_OVERRIDING_SYSTEM_VALUE: OverridingKind = 2;
pub type OverridingKind = ::std::os::raw::c_uint;
pub const QuerySource_QSRC_ORIGINAL: QuerySource = 0;
pub const QuerySource_QSRC_PARSER: QuerySource = 1;
pub const QuerySource_QSRC_INSTEAD_RULE: QuerySource = 2;
pub const QuerySource_QSRC_QUAL_INSTEAD_RULE: QuerySource = 3;
pub const QuerySource_QSRC_NON_INSTEAD_RULE: QuerySource = 4;
pub type QuerySource = ::std::os::raw::c_uint;
pub const SortByDir_SORTBY_DEFAULT: SortByDir = 0;
pub const SortByDir_SORTBY_ASC: SortByDir = 1;
pub const SortByDir_SORTBY_DESC: SortByDir = 2;
pub const SortByDir_SORTBY_USING: SortByDir = 3;
pub type SortByDir = ::std::os::raw::c_uint;
pub const SortByNulls_SORTBY_NULLS_DEFAULT: SortByNulls = 0;
pub const SortByNulls_SORTBY_NULLS_FIRST: SortByNulls = 1;
pub const SortByNulls_SORTBY_NULLS_LAST: SortByNulls = 2;
pub type SortByNulls = ::std::os::raw::c_uint;
pub type AclMode = uint32;
#[doc = "\tQuery Tree"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Query {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub querySource: QuerySource,
    pub queryId: uint64,
    pub canSetTag: bool,
    pub utilityStmt: *mut Node,
    pub resultRelation: ::std::os::raw::c_int,
    pub hasAggs: bool,
    pub hasWindowFuncs: bool,
    pub hasTargetSRFs: bool,
    pub hasSubLinks: bool,
    pub hasDistinctOn: bool,
    pub hasRecursive: bool,
    pub hasModifyingCTE: bool,
    pub hasForUpdate: bool,
    pub hasRowSecurity: bool,
    pub cteList: *mut List,
    pub rtable: *mut List,
    pub jointree: *mut FromExpr,
    pub targetList: *mut List,
    pub override_: OverridingKind,
    pub onConflict: *mut OnConflictExpr,
    pub returningList: *mut List,
    pub groupClause: *mut List,
    pub groupingSets: *mut List,
    pub havingQual: *mut Node,
    pub windowClause: *mut List,
    pub distinctClause: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption,
    pub rowMarks: *mut List,
    pub setOperations: *mut Node,
    pub constraintDeps: *mut List,
    pub withCheckOptions: *mut List,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for Query {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\tSupporting data structures for Parse Trees"]
#[doc = ""]
#[doc = "\tMost of these node types appear in raw parsetrees output by the grammar,"]
#[doc = "\tand get transformed to something else by the analyzer.  A few of them"]
#[doc = "\tare used as-is in transformed querytrees."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeName {
    pub type_: NodeTag,
    pub names: *mut List,
    pub typeOid: Oid,
    pub setof: bool,
    pub pct_type: bool,
    pub typmods: *mut List,
    pub typemod: int32,
    pub arrayBounds: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeName {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnRef {
    pub type_: NodeTag,
    pub fields: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamRef {
    pub type_: NodeTag,
    pub number: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for ParamRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const A_Expr_Kind_AEXPR_OP: A_Expr_Kind = 0;
pub const A_Expr_Kind_AEXPR_OP_ANY: A_Expr_Kind = 1;
pub const A_Expr_Kind_AEXPR_OP_ALL: A_Expr_Kind = 2;
pub const A_Expr_Kind_AEXPR_DISTINCT: A_Expr_Kind = 3;
pub const A_Expr_Kind_AEXPR_NOT_DISTINCT: A_Expr_Kind = 4;
pub const A_Expr_Kind_AEXPR_NULLIF: A_Expr_Kind = 5;
pub const A_Expr_Kind_AEXPR_OF: A_Expr_Kind = 6;
pub const A_Expr_Kind_AEXPR_IN: A_Expr_Kind = 7;
pub const A_Expr_Kind_AEXPR_LIKE: A_Expr_Kind = 8;
pub const A_Expr_Kind_AEXPR_ILIKE: A_Expr_Kind = 9;
pub const A_Expr_Kind_AEXPR_SIMILAR: A_Expr_Kind = 10;
pub const A_Expr_Kind_AEXPR_BETWEEN: A_Expr_Kind = 11;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN: A_Expr_Kind = 12;
pub const A_Expr_Kind_AEXPR_BETWEEN_SYM: A_Expr_Kind = 13;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN_SYM: A_Expr_Kind = 14;
pub const A_Expr_Kind_AEXPR_PAREN: A_Expr_Kind = 15;
pub type A_Expr_Kind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Expr {
    pub type_: NodeTag,
    pub kind: A_Expr_Kind,
    pub name: *mut List,
    pub lexpr: *mut Node,
    pub rexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct A_Const {
    pub type_: NodeTag,
    pub val: Value,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeCast {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeCast {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateClause {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub collname: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RoleSpecType_ROLESPEC_CSTRING: RoleSpecType = 0;
pub const RoleSpecType_ROLESPEC_CURRENT_USER: RoleSpecType = 1;
pub const RoleSpecType_ROLESPEC_SESSION_USER: RoleSpecType = 2;
pub const RoleSpecType_ROLESPEC_PUBLIC: RoleSpecType = 3;
pub type RoleSpecType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RoleSpec {
    pub type_: NodeTag,
    pub roletype: RoleSpecType,
    pub rolename: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for RoleSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCall {
    pub type_: NodeTag,
    pub funcname: *mut List,
    pub args: *mut List,
    pub agg_order: *mut List,
    pub agg_filter: *mut Node,
    pub agg_within_group: bool,
    pub agg_star: bool,
    pub agg_distinct: bool,
    pub func_variadic: bool,
    pub over: *mut WindowDef,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncCall {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Star {
    pub type_: NodeTag,
}
impl Default for A_Star {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indices {
    pub type_: NodeTag,
    pub is_slice: bool,
    pub lidx: *mut Node,
    pub uidx: *mut Node,
}
impl Default for A_Indices {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indirection {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub indirection: *mut List,
}
impl Default for A_Indirection {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_ArrayExpr {
    pub type_: NodeTag,
    pub elements: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResTarget {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub indirection: *mut List,
    pub val: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for ResTarget {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MultiAssignRef {
    pub type_: NodeTag,
    pub source: *mut Node,
    pub colno: ::std::os::raw::c_int,
    pub ncolumns: ::std::os::raw::c_int,
}
impl Default for MultiAssignRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortBy {
    pub type_: NodeTag,
    pub node: *mut Node,
    pub sortby_dir: SortByDir,
    pub sortby_nulls: SortByNulls,
    pub useOp: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for SortBy {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowDef {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeSubselect {
    pub type_: NodeTag,
    pub lateral: bool,
    pub subquery: *mut Node,
    pub alias: *mut Alias,
}
impl Default for RangeSubselect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeFunction {
    pub type_: NodeTag,
    pub lateral: bool,
    pub ordinality: bool,
    pub is_rowsfrom: bool,
    pub functions: *mut List,
    pub alias: *mut Alias,
    pub coldeflist: *mut List,
}
impl Default for RangeFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFunc {
    pub type_: NodeTag,
    pub lateral: bool,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub namespaces: *mut List,
    pub columns: *mut List,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFuncCol {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub for_ordinality: bool,
    pub is_not_null: bool,
    pub colexpr: *mut Node,
    pub coldefexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFuncCol {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableSample {
    pub type_: NodeTag,
    pub relation: *mut Node,
    pub method: *mut List,
    pub args: *mut List,
    pub repeatable: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableSample {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnDef {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub inhcount: ::std::os::raw::c_int,
    pub is_local: bool,
    pub is_not_null: bool,
    pub is_from_type: bool,
    pub storage: ::std::os::raw::c_char,
    pub raw_default: *mut Node,
    pub cooked_default: *mut Node,
    pub identity: ::std::os::raw::c_char,
    pub identitySequence: *mut RangeVar,
    pub generated: ::std::os::raw::c_char,
    pub collClause: *mut CollateClause,
    pub collOid: Oid,
    pub constraints: *mut List,
    pub fdwoptions: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableLikeClause {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub options: bits32,
    pub relationOid: Oid,
}
impl Default for TableLikeClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TableLikeOption_CREATE_TABLE_LIKE_COMMENTS: TableLikeOption = 1;
pub const TableLikeOption_CREATE_TABLE_LIKE_CONSTRAINTS: TableLikeOption = 2;
pub const TableLikeOption_CREATE_TABLE_LIKE_DEFAULTS: TableLikeOption = 4;
pub const TableLikeOption_CREATE_TABLE_LIKE_GENERATED: TableLikeOption = 8;
pub const TableLikeOption_CREATE_TABLE_LIKE_IDENTITY: TableLikeOption = 16;
pub const TableLikeOption_CREATE_TABLE_LIKE_INDEXES: TableLikeOption = 32;
pub const TableLikeOption_CREATE_TABLE_LIKE_STATISTICS: TableLikeOption = 64;
pub const TableLikeOption_CREATE_TABLE_LIKE_STORAGE: TableLikeOption = 128;
pub const TableLikeOption_CREATE_TABLE_LIKE_ALL: TableLikeOption = 2147483647;
pub type TableLikeOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub indexcolname: *mut ::std::os::raw::c_char,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub opclassopts: *mut List,
    pub ordering: SortByDir,
    pub nulls_ordering: SortByNulls,
}
impl Default for IndexElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DefElemAction_DEFELEM_UNSPEC: DefElemAction = 0;
pub const DefElemAction_DEFELEM_SET: DefElemAction = 1;
pub const DefElemAction_DEFELEM_ADD: DefElemAction = 2;
pub const DefElemAction_DEFELEM_DROP: DefElemAction = 3;
pub type DefElemAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefElem {
    pub type_: NodeTag,
    pub defnamespace: *mut ::std::os::raw::c_char,
    pub defname: *mut ::std::os::raw::c_char,
    pub arg: *mut Node,
    pub defaction: DefElemAction,
    pub location: ::std::os::raw::c_int,
}
impl Default for DefElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockingClause {
    pub type_: NodeTag,
    pub lockedRels: *mut List,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
}
impl Default for LockingClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlSerialize {
    pub type_: NodeTag,
    pub xmloption: XmlOptionType,
    pub expr: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlSerialize {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionSpec {
    pub type_: NodeTag,
    pub strategy: *mut ::std::os::raw::c_char,
    pub partParams: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundSpec {
    pub type_: NodeTag,
    pub strategy: ::std::os::raw::c_char,
    pub is_default: bool,
    pub modulus: ::std::os::raw::c_int,
    pub remainder: ::std::os::raw::c_int,
    pub listdatums: *mut List,
    pub lowerdatums: *mut List,
    pub upperdatums: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionBoundSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MINVALUE: PartitionRangeDatumKind = -1;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_VALUE: PartitionRangeDatumKind = 0;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MAXVALUE: PartitionRangeDatumKind = 1;
pub type PartitionRangeDatumKind = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRangeDatum {
    pub type_: NodeTag,
    pub kind: PartitionRangeDatumKind,
    pub value: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionRangeDatum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionCmd {
    pub type_: NodeTag,
    pub name: *mut RangeVar,
    pub bound: *mut PartitionBoundSpec,
}
impl Default for PartitionCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RTEKind_RTE_RELATION: RTEKind = 0;
pub const RTEKind_RTE_SUBQUERY: RTEKind = 1;
pub const RTEKind_RTE_JOIN: RTEKind = 2;
pub const RTEKind_RTE_FUNCTION: RTEKind = 3;
pub const RTEKind_RTE_TABLEFUNC: RTEKind = 4;
pub const RTEKind_RTE_VALUES: RTEKind = 5;
pub const RTEKind_RTE_CTE: RTEKind = 6;
pub const RTEKind_RTE_NAMEDTUPLESTORE: RTEKind = 7;
pub const RTEKind_RTE_RESULT: RTEKind = 8;
pub type RTEKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblEntry {
    pub type_: NodeTag,
    pub rtekind: RTEKind,
    pub relid: Oid,
    pub relkind: ::std::os::raw::c_char,
    pub rellockmode: ::std::os::raw::c_int,
    pub tablesample: *mut TableSampleClause,
    pub subquery: *mut Query,
    pub security_barrier: bool,
    pub jointype: JoinType,
    pub joinmergedcols: ::std::os::raw::c_int,
    pub joinaliasvars: *mut List,
    pub joinleftcols: *mut List,
    pub joinrightcols: *mut List,
    pub functions: *mut List,
    pub funcordinality: bool,
    pub tablefunc: *mut TableFunc,
    pub values_lists: *mut List,
    pub ctename: *mut ::std::os::raw::c_char,
    pub ctelevelsup: Index,
    pub self_reference: bool,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub enrname: *mut ::std::os::raw::c_char,
    pub enrtuples: f64,
    pub alias: *mut Alias,
    pub eref: *mut Alias,
    pub lateral: bool,
    pub inh: bool,
    pub inFromCl: bool,
    pub requiredPerms: AclMode,
    pub checkAsUser: Oid,
    pub selectedCols: *mut Bitmapset,
    pub insertedCols: *mut Bitmapset,
    pub updatedCols: *mut Bitmapset,
    pub extraUpdatedCols: *mut Bitmapset,
    pub securityQuals: *mut List,
}
impl Default for RangeTblEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblFunction {
    pub type_: NodeTag,
    pub funcexpr: *mut Node,
    pub funccolcount: ::std::os::raw::c_int,
    pub funccolnames: *mut List,
    pub funccoltypes: *mut List,
    pub funccoltypmods: *mut List,
    pub funccolcollations: *mut List,
    pub funcparams: *mut Bitmapset,
}
impl Default for RangeTblFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableSampleClause {
    pub type_: NodeTag,
    pub tsmhandler: Oid,
    pub args: *mut List,
    pub repeatable: *mut Expr,
}
impl Default for TableSampleClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const WCOKind_WCO_VIEW_CHECK: WCOKind = 0;
pub const WCOKind_WCO_RLS_INSERT_CHECK: WCOKind = 1;
pub const WCOKind_WCO_RLS_UPDATE_CHECK: WCOKind = 2;
pub const WCOKind_WCO_RLS_CONFLICT_CHECK: WCOKind = 3;
pub type WCOKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithCheckOption {
    pub type_: NodeTag,
    pub kind: WCOKind,
    pub relname: *mut ::std::os::raw::c_char,
    pub polname: *mut ::std::os::raw::c_char,
    pub qual: *mut Node,
    pub cascaded: bool,
}
impl Default for WithCheckOption {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortGroupClause {
    pub type_: NodeTag,
    pub tleSortGroupRef: Index,
    pub eqop: Oid,
    pub sortop: Oid,
    pub nulls_first: bool,
    pub hashable: bool,
}
impl Default for SortGroupClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const GroupingSetKind_GROUPING_SET_EMPTY: GroupingSetKind = 0;
pub const GroupingSetKind_GROUPING_SET_SIMPLE: GroupingSetKind = 1;
pub const GroupingSetKind_GROUPING_SET_ROLLUP: GroupingSetKind = 2;
pub const GroupingSetKind_GROUPING_SET_CUBE: GroupingSetKind = 3;
pub const GroupingSetKind_GROUPING_SET_SETS: GroupingSetKind = 4;
pub type GroupingSetKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingSet {
    pub type_: NodeTag,
    pub kind: GroupingSetKind,
    pub content: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowClause {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub winref: Index,
    pub copiedOrder: bool,
}
impl Default for WindowClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowMarkClause {
    pub type_: NodeTag,
    pub rti: Index,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub pushedDown: bool,
}
impl Default for RowMarkClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithClause {
    pub type_: NodeTag,
    pub ctes: *mut List,
    pub recursive: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WithClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferClause {
    pub type_: NodeTag,
    pub indexElems: *mut List,
    pub whereClause: *mut Node,
    pub conname: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for InferClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictClause {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub infer: *mut InferClause,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for OnConflictClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CTEMaterialize_CTEMaterializeDefault: CTEMaterialize = 0;
pub const CTEMaterialize_CTEMaterializeAlways: CTEMaterialize = 1;
pub const CTEMaterialize_CTEMaterializeNever: CTEMaterialize = 2;
pub type CTEMaterialize = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommonTableExpr {
    pub type_: NodeTag,
    pub ctename: *mut ::std::os::raw::c_char,
    pub aliascolnames: *mut List,
    pub ctematerialized: CTEMaterialize,
    pub ctequery: *mut Node,
    pub location: ::std::os::raw::c_int,
    pub cterecursive: bool,
    pub cterefcount: ::std::os::raw::c_int,
    pub ctecolnames: *mut List,
    pub ctecoltypes: *mut List,
    pub ctecoltypmods: *mut List,
    pub ctecolcollations: *mut List,
}
impl Default for CommonTableExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerTransition {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub isNew: bool,
    pub isTable: bool,
}
impl Default for TriggerTransition {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tRaw Grammar Output Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RawStmt {
    pub type_: NodeTag,
    pub stmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for RawStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tOptimizable Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InsertStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cols: *mut List,
    pub selectStmt: *mut Node,
    pub onConflictClause: *mut OnConflictClause,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
    pub override_: OverridingKind,
}
impl Default for InsertStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeleteStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub usingClause: *mut List,
    pub whereClause: *mut Node,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for DeleteStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UpdateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub fromClause: *mut List,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for UpdateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SetOperation_SETOP_NONE: SetOperation = 0;
pub const SetOperation_SETOP_UNION: SetOperation = 1;
pub const SetOperation_SETOP_INTERSECT: SetOperation = 2;
pub const SetOperation_SETOP_EXCEPT: SetOperation = 3;
pub type SetOperation = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SelectStmt {
    pub type_: NodeTag,
    pub distinctClause: *mut List,
    pub intoClause: *mut IntoClause,
    pub targetList: *mut List,
    pub fromClause: *mut List,
    pub whereClause: *mut Node,
    pub groupClause: *mut List,
    pub havingClause: *mut Node,
    pub windowClause: *mut List,
    pub valuesLists: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption,
    pub lockingClause: *mut List,
    pub withClause: *mut WithClause,
    pub op: SetOperation,
    pub all: bool,
    pub larg: *mut SelectStmt,
    pub rarg: *mut SelectStmt,
}
impl Default for SelectStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOperationStmt {
    pub type_: NodeTag,
    pub op: SetOperation,
    pub all: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub colTypes: *mut List,
    pub colTypmods: *mut List,
    pub colCollations: *mut List,
    pub groupClauses: *mut List,
}
impl Default for SetOperationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ObjectType_OBJECT_ACCESS_METHOD: ObjectType = 0;
pub const ObjectType_OBJECT_AGGREGATE: ObjectType = 1;
pub const ObjectType_OBJECT_AMOP: ObjectType = 2;
pub const ObjectType_OBJECT_AMPROC: ObjectType = 3;
pub const ObjectType_OBJECT_ATTRIBUTE: ObjectType = 4;
pub const ObjectType_OBJECT_CAST: ObjectType = 5;
pub const ObjectType_OBJECT_COLUMN: ObjectType = 6;
pub const ObjectType_OBJECT_COLLATION: ObjectType = 7;
pub const ObjectType_OBJECT_CONVERSION: ObjectType = 8;
pub const ObjectType_OBJECT_DATABASE: ObjectType = 9;
pub const ObjectType_OBJECT_DEFAULT: ObjectType = 10;
pub const ObjectType_OBJECT_DEFACL: ObjectType = 11;
pub const ObjectType_OBJECT_DOMAIN: ObjectType = 12;
pub const ObjectType_OBJECT_DOMCONSTRAINT: ObjectType = 13;
pub const ObjectType_OBJECT_EVENT_TRIGGER: ObjectType = 14;
pub const ObjectType_OBJECT_EXTENSION: ObjectType = 15;
pub const ObjectType_OBJECT_FDW: ObjectType = 16;
pub const ObjectType_OBJECT_FOREIGN_SERVER: ObjectType = 17;
pub const ObjectType_OBJECT_FOREIGN_TABLE: ObjectType = 18;
pub const ObjectType_OBJECT_FUNCTION: ObjectType = 19;
pub const ObjectType_OBJECT_INDEX: ObjectType = 20;
pub const ObjectType_OBJECT_LANGUAGE: ObjectType = 21;
pub const ObjectType_OBJECT_LARGEOBJECT: ObjectType = 22;
pub const ObjectType_OBJECT_MATVIEW: ObjectType = 23;
pub const ObjectType_OBJECT_OPCLASS: ObjectType = 24;
pub const ObjectType_OBJECT_OPERATOR: ObjectType = 25;
pub const ObjectType_OBJECT_OPFAMILY: ObjectType = 26;
pub const ObjectType_OBJECT_POLICY: ObjectType = 27;
pub const ObjectType_OBJECT_PROCEDURE: ObjectType = 28;
pub const ObjectType_OBJECT_PUBLICATION: ObjectType = 29;
pub const ObjectType_OBJECT_PUBLICATION_REL: ObjectType = 30;
pub const ObjectType_OBJECT_ROLE: ObjectType = 31;
pub const ObjectType_OBJECT_ROUTINE: ObjectType = 32;
pub const ObjectType_OBJECT_RULE: ObjectType = 33;
pub const ObjectType_OBJECT_SCHEMA: ObjectType = 34;
pub const ObjectType_OBJECT_SEQUENCE: ObjectType = 35;
pub const ObjectType_OBJECT_SUBSCRIPTION: ObjectType = 36;
pub const ObjectType_OBJECT_STATISTIC_EXT: ObjectType = 37;
pub const ObjectType_OBJECT_TABCONSTRAINT: ObjectType = 38;
pub const ObjectType_OBJECT_TABLE: ObjectType = 39;
pub const ObjectType_OBJECT_TABLESPACE: ObjectType = 40;
pub const ObjectType_OBJECT_TRANSFORM: ObjectType = 41;
pub const ObjectType_OBJECT_TRIGGER: ObjectType = 42;
pub const ObjectType_OBJECT_TSCONFIGURATION: ObjectType = 43;
pub const ObjectType_OBJECT_TSDICTIONARY: ObjectType = 44;
pub const ObjectType_OBJECT_TSPARSER: ObjectType = 45;
pub const ObjectType_OBJECT_TSTEMPLATE: ObjectType = 46;
pub const ObjectType_OBJECT_TYPE: ObjectType = 47;
pub const ObjectType_OBJECT_USER_MAPPING: ObjectType = 48;
pub const ObjectType_OBJECT_VIEW: ObjectType = 49;
#[doc = "\t\tOther Statements (no optimizations required)"]
#[doc = ""]
#[doc = "\t\tThese are not touched by parser/analyze.c except to put them into"]
#[doc = "\t\tthe utilityStmt field of a Query.  This is eventually passed to"]
#[doc = "\t\tProcessUtility (by-passing rewriting and planning).  Some of the"]
#[doc = "\t\tstatements do need attention from parse analysis, and this is"]
#[doc = "\t\tdone by routines in parser/parse_utilcmd.c after ProcessUtility"]
#[doc = "\t\treceives the command for execution."]
#[doc = "\t\tDECLARE CURSOR, EXPLAIN, and CREATE TABLE AS are special cases:"]
#[doc = "\t\tthey contain optimizable statements, which get processed normally"]
#[doc = "\t\tby parser/analyze.c."]
pub type ObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSchemaStmt {
    pub type_: NodeTag,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub authrole: *mut RoleSpec,
    pub schemaElts: *mut List,
    pub if_not_exists: bool,
}
impl Default for CreateSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DropBehavior_DROP_RESTRICT: DropBehavior = 0;
pub const DropBehavior_DROP_CASCADE: DropBehavior = 1;
pub type DropBehavior = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cmds: *mut List,
    pub relkind: ObjectType,
    pub missing_ok: bool,
}
impl Default for AlterTableStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterTableType_AT_AddColumn: AlterTableType = 0;
pub const AlterTableType_AT_AddColumnRecurse: AlterTableType = 1;
pub const AlterTableType_AT_AddColumnToView: AlterTableType = 2;
pub const AlterTableType_AT_ColumnDefault: AlterTableType = 3;
pub const AlterTableType_AT_CookedColumnDefault: AlterTableType = 4;
pub const AlterTableType_AT_DropNotNull: AlterTableType = 5;
pub const AlterTableType_AT_SetNotNull: AlterTableType = 6;
pub const AlterTableType_AT_DropExpression: AlterTableType = 7;
pub const AlterTableType_AT_CheckNotNull: AlterTableType = 8;
pub const AlterTableType_AT_SetStatistics: AlterTableType = 9;
pub const AlterTableType_AT_SetOptions: AlterTableType = 10;
pub const AlterTableType_AT_ResetOptions: AlterTableType = 11;
pub const AlterTableType_AT_SetStorage: AlterTableType = 12;
pub const AlterTableType_AT_DropColumn: AlterTableType = 13;
pub const AlterTableType_AT_DropColumnRecurse: AlterTableType = 14;
pub const AlterTableType_AT_AddIndex: AlterTableType = 15;
pub const AlterTableType_AT_ReAddIndex: AlterTableType = 16;
pub const AlterTableType_AT_AddConstraint: AlterTableType = 17;
pub const AlterTableType_AT_AddConstraintRecurse: AlterTableType = 18;
pub const AlterTableType_AT_ReAddConstraint: AlterTableType = 19;
pub const AlterTableType_AT_ReAddDomainConstraint: AlterTableType = 20;
pub const AlterTableType_AT_AlterConstraint: AlterTableType = 21;
pub const AlterTableType_AT_ValidateConstraint: AlterTableType = 22;
pub const AlterTableType_AT_ValidateConstraintRecurse: AlterTableType = 23;
pub const AlterTableType_AT_AddIndexConstraint: AlterTableType = 24;
pub const AlterTableType_AT_DropConstraint: AlterTableType = 25;
pub const AlterTableType_AT_DropConstraintRecurse: AlterTableType = 26;
pub const AlterTableType_AT_ReAddComment: AlterTableType = 27;
pub const AlterTableType_AT_AlterColumnType: AlterTableType = 28;
pub const AlterTableType_AT_AlterColumnGenericOptions: AlterTableType = 29;
pub const AlterTableType_AT_ChangeOwner: AlterTableType = 30;
pub const AlterTableType_AT_ClusterOn: AlterTableType = 31;
pub const AlterTableType_AT_DropCluster: AlterTableType = 32;
pub const AlterTableType_AT_SetLogged: AlterTableType = 33;
pub const AlterTableType_AT_SetUnLogged: AlterTableType = 34;
pub const AlterTableType_AT_DropOids: AlterTableType = 35;
pub const AlterTableType_AT_SetTableSpace: AlterTableType = 36;
pub const AlterTableType_AT_SetRelOptions: AlterTableType = 37;
pub const AlterTableType_AT_ResetRelOptions: AlterTableType = 38;
pub const AlterTableType_AT_ReplaceRelOptions: AlterTableType = 39;
pub const AlterTableType_AT_EnableTrig: AlterTableType = 40;
pub const AlterTableType_AT_EnableAlwaysTrig: AlterTableType = 41;
pub const AlterTableType_AT_EnableReplicaTrig: AlterTableType = 42;
pub const AlterTableType_AT_DisableTrig: AlterTableType = 43;
pub const AlterTableType_AT_EnableTrigAll: AlterTableType = 44;
pub const AlterTableType_AT_DisableTrigAll: AlterTableType = 45;
pub const AlterTableType_AT_EnableTrigUser: AlterTableType = 46;
pub const AlterTableType_AT_DisableTrigUser: AlterTableType = 47;
pub const AlterTableType_AT_EnableRule: AlterTableType = 48;
pub const AlterTableType_AT_EnableAlwaysRule: AlterTableType = 49;
pub const AlterTableType_AT_EnableReplicaRule: AlterTableType = 50;
pub const AlterTableType_AT_DisableRule: AlterTableType = 51;
pub const AlterTableType_AT_AddInherit: AlterTableType = 52;
pub const AlterTableType_AT_DropInherit: AlterTableType = 53;
pub const AlterTableType_AT_AddOf: AlterTableType = 54;
pub const AlterTableType_AT_DropOf: AlterTableType = 55;
pub const AlterTableType_AT_ReplicaIdentity: AlterTableType = 56;
pub const AlterTableType_AT_EnableRowSecurity: AlterTableType = 57;
pub const AlterTableType_AT_DisableRowSecurity: AlterTableType = 58;
pub const AlterTableType_AT_ForceRowSecurity: AlterTableType = 59;
pub const AlterTableType_AT_NoForceRowSecurity: AlterTableType = 60;
pub const AlterTableType_AT_GenericOptions: AlterTableType = 61;
pub const AlterTableType_AT_AttachPartition: AlterTableType = 62;
pub const AlterTableType_AT_DetachPartition: AlterTableType = 63;
pub const AlterTableType_AT_AddIdentity: AlterTableType = 64;
pub const AlterTableType_AT_SetIdentity: AlterTableType = 65;
pub const AlterTableType_AT_DropIdentity: AlterTableType = 66;
pub type AlterTableType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicaIdentityStmt {
    pub type_: NodeTag,
    pub identity_type: ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for ReplicaIdentityStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableCmd {
    pub type_: NodeTag,
    pub subtype: AlterTableType,
    pub name: *mut ::std::os::raw::c_char,
    pub num: int16,
    pub newowner: *mut RoleSpec,
    pub def: *mut Node,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
    pub recurse: bool,
}
impl Default for AlterTableCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterCollationStmt {
    pub type_: NodeTag,
    pub collname: *mut List,
}
impl Default for AlterCollationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDomainStmt {
    pub type_: NodeTag,
    pub subtype: ::std::os::raw::c_char,
    pub typeName: *mut List,
    pub name: *mut ::std::os::raw::c_char,
    pub def: *mut Node,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
}
impl Default for AlterDomainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const GrantTargetType_ACL_TARGET_OBJECT: GrantTargetType = 0;
pub const GrantTargetType_ACL_TARGET_ALL_IN_SCHEMA: GrantTargetType = 1;
pub const GrantTargetType_ACL_TARGET_DEFAULTS: GrantTargetType = 2;
pub type GrantTargetType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantStmt {
    pub type_: NodeTag,
    pub is_grant: bool,
    pub targtype: GrantTargetType,
    pub objtype: ObjectType,
    pub objects: *mut List,
    pub privileges: *mut List,
    pub grantees: *mut List,
    pub grant_option: bool,
    pub behavior: DropBehavior,
}
impl Default for GrantStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectWithArgs {
    pub type_: NodeTag,
    pub objname: *mut List,
    pub objargs: *mut List,
    pub args_unspecified: bool,
}
impl Default for ObjectWithArgs {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AccessPriv {
    pub type_: NodeTag,
    pub priv_name: *mut ::std::os::raw::c_char,
    pub cols: *mut List,
}
impl Default for AccessPriv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantRoleStmt {
    pub type_: NodeTag,
    pub granted_roles: *mut List,
    pub grantee_roles: *mut List,
    pub is_grant: bool,
    pub admin_opt: bool,
    pub grantor: *mut RoleSpec,
    pub behavior: DropBehavior,
}
impl Default for GrantRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDefaultPrivilegesStmt {
    pub type_: NodeTag,
    pub options: *mut List,
    pub action: *mut GrantStmt,
}
impl Default for AlterDefaultPrivilegesStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub query: *mut Node,
    pub attlist: *mut List,
    pub is_from: bool,
    pub is_program: bool,
    pub filename: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub whereClause: *mut Node,
}
impl Default for CopyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const VariableSetKind_VAR_SET_VALUE: VariableSetKind = 0;
pub const VariableSetKind_VAR_SET_DEFAULT: VariableSetKind = 1;
pub const VariableSetKind_VAR_SET_CURRENT: VariableSetKind = 2;
pub const VariableSetKind_VAR_SET_MULTI: VariableSetKind = 3;
pub const VariableSetKind_VAR_RESET: VariableSetKind = 4;
pub const VariableSetKind_VAR_RESET_ALL: VariableSetKind = 5;
pub type VariableSetKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableSetStmt {
    pub type_: NodeTag,
    pub kind: VariableSetKind,
    pub name: *mut ::std::os::raw::c_char,
    pub args: *mut List,
    pub is_local: bool,
}
impl Default for VariableSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableShowStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for VariableShowStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub tableElts: *mut List,
    pub inhRelations: *mut List,
    pub partbound: *mut PartitionBoundSpec,
    pub partspec: *mut PartitionSpec,
    pub ofTypename: *mut TypeName,
    pub constraints: *mut List,
    pub options: *mut List,
    pub oncommit: OnCommitAction,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
}
impl Default for CreateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ConstrType_CONSTR_NULL: ConstrType = 0;
pub const ConstrType_CONSTR_NOTNULL: ConstrType = 1;
pub const ConstrType_CONSTR_DEFAULT: ConstrType = 2;
pub const ConstrType_CONSTR_IDENTITY: ConstrType = 3;
pub const ConstrType_CONSTR_GENERATED: ConstrType = 4;
pub const ConstrType_CONSTR_CHECK: ConstrType = 5;
pub const ConstrType_CONSTR_PRIMARY: ConstrType = 6;
pub const ConstrType_CONSTR_UNIQUE: ConstrType = 7;
pub const ConstrType_CONSTR_EXCLUSION: ConstrType = 8;
pub const ConstrType_CONSTR_FOREIGN: ConstrType = 9;
pub const ConstrType_CONSTR_ATTR_DEFERRABLE: ConstrType = 10;
pub const ConstrType_CONSTR_ATTR_NOT_DEFERRABLE: ConstrType = 11;
pub const ConstrType_CONSTR_ATTR_DEFERRED: ConstrType = 12;
pub const ConstrType_CONSTR_ATTR_IMMEDIATE: ConstrType = 13;
pub type ConstrType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Constraint {
    pub type_: NodeTag,
    pub contype: ConstrType,
    pub conname: *mut ::std::os::raw::c_char,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub location: ::std::os::raw::c_int,
    pub is_no_inherit: bool,
    pub raw_expr: *mut Node,
    pub cooked_expr: *mut ::std::os::raw::c_char,
    pub generated_when: ::std::os::raw::c_char,
    pub keys: *mut List,
    pub including: *mut List,
    pub exclusions: *mut List,
    pub options: *mut List,
    pub indexname: *mut ::std::os::raw::c_char,
    pub indexspace: *mut ::std::os::raw::c_char,
    pub reset_default_tblspc: bool,
    pub access_method: *mut ::std::os::raw::c_char,
    pub where_clause: *mut Node,
    pub pktable: *mut RangeVar,
    pub fk_attrs: *mut List,
    pub pk_attrs: *mut List,
    pub fk_matchtype: ::std::os::raw::c_char,
    pub fk_upd_action: ::std::os::raw::c_char,
    pub fk_del_action: ::std::os::raw::c_char,
    pub old_conpfeqop: *mut List,
    pub old_pktable_oid: Oid,
    pub skip_validation: bool,
    pub initially_valid: bool,
}
impl Default for Constraint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub owner: *mut RoleSpec,
    pub location: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for DropTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableSpaceOptionsStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub isReset: bool,
}
impl Default for AlterTableSpaceOptionsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableMoveAllStmt {
    pub type_: NodeTag,
    pub orig_tablespacename: *mut ::std::os::raw::c_char,
    pub objtype: ObjectType,
    pub roles: *mut List,
    pub new_tablespacename: *mut ::std::os::raw::c_char,
    pub nowait: bool,
}
impl Default for AlterTableMoveAllStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateExtensionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterExtensionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionContentsStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub action: ::std::os::raw::c_int,
    pub objtype: ObjectType,
    pub object: *mut Node,
}
impl Default for AlterExtensionContentsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateFdwStmt {
    pub type_: NodeTag,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub func_options: *mut List,
    pub options: *mut List,
}
impl Default for CreateFdwStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterFdwStmt {
    pub type_: NodeTag,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub func_options: *mut List,
    pub options: *mut List,
}
impl Default for AlterFdwStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateForeignServerStmt {
    pub type_: NodeTag,
    pub servername: *mut ::std::os::raw::c_char,
    pub servertype: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateForeignServerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterForeignServerStmt {
    pub type_: NodeTag,
    pub servername: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub has_version: bool,
}
impl Default for AlterForeignServerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateForeignTableStmt {
    pub base: CreateStmt,
    pub servername: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateForeignTableStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for DropUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_ALL: ImportForeignSchemaType = 0;
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_LIMIT_TO: ImportForeignSchemaType = 1;
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_EXCEPT: ImportForeignSchemaType = 2;
pub type ImportForeignSchemaType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImportForeignSchemaStmt {
    pub type_: NodeTag,
    pub server_name: *mut ::std::os::raw::c_char,
    pub remote_schema: *mut ::std::os::raw::c_char,
    pub local_schema: *mut ::std::os::raw::c_char,
    pub list_type: ImportForeignSchemaType,
    pub table_list: *mut List,
    pub options: *mut List,
}
impl Default for ImportForeignSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePolicyStmt {
    pub type_: NodeTag,
    pub policy_name: *mut ::std::os::raw::c_char,
    pub table: *mut RangeVar,
    pub cmd_name: *mut ::std::os::raw::c_char,
    pub permissive: bool,
    pub roles: *mut List,
    pub qual: *mut Node,
    pub with_check: *mut Node,
}
impl Default for CreatePolicyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterPolicyStmt {
    pub type_: NodeTag,
    pub policy_name: *mut ::std::os::raw::c_char,
    pub table: *mut RangeVar,
    pub roles: *mut List,
    pub qual: *mut Node,
    pub with_check: *mut Node,
}
impl Default for AlterPolicyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateAmStmt {
    pub type_: NodeTag,
    pub amname: *mut ::std::os::raw::c_char,
    pub handler_name: *mut List,
    pub amtype: ::std::os::raw::c_char,
}
impl Default for CreateAmStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub relation: *mut RangeVar,
    pub funcname: *mut List,
    pub args: *mut List,
    pub row: bool,
    pub timing: int16,
    pub events: int16,
    pub columns: *mut List,
    pub whenClause: *mut Node,
    pub isconstraint: bool,
    pub transitionRels: *mut List,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub constrrel: *mut RangeVar,
}
impl Default for CreateTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateEventTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub eventname: *mut ::std::os::raw::c_char,
    pub whenclause: *mut List,
    pub funcname: *mut List,
}
impl Default for CreateEventTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterEventTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub tgenabled: ::std::os::raw::c_char,
}
impl Default for AlterEventTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePLangStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub plname: *mut ::std::os::raw::c_char,
    pub plhandler: *mut List,
    pub plinline: *mut List,
    pub plvalidator: *mut List,
    pub pltrusted: bool,
}
impl Default for CreatePLangStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RoleStmtType_ROLESTMT_ROLE: RoleStmtType = 0;
pub const RoleStmtType_ROLESTMT_USER: RoleStmtType = 1;
pub const RoleStmtType_ROLESTMT_GROUP: RoleStmtType = 2;
pub type RoleStmtType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateRoleStmt {
    pub type_: NodeTag,
    pub stmt_type: RoleStmtType,
    pub role: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterRoleStmt {
    pub type_: NodeTag,
    pub role: *mut RoleSpec,
    pub options: *mut List,
    pub action: ::std::os::raw::c_int,
}
impl Default for AlterRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterRoleSetStmt {
    pub type_: NodeTag,
    pub role: *mut RoleSpec,
    pub database: *mut ::std::os::raw::c_char,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterRoleSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropRoleStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub missing_ok: bool,
}
impl Default for DropRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSeqStmt {
    pub type_: NodeTag,
    pub sequence: *mut RangeVar,
    pub options: *mut List,
    pub ownerId: Oid,
    pub for_identity: bool,
    pub if_not_exists: bool,
}
impl Default for CreateSeqStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSeqStmt {
    pub type_: NodeTag,
    pub sequence: *mut RangeVar,
    pub options: *mut List,
    pub for_identity: bool,
    pub missing_ok: bool,
}
impl Default for AlterSeqStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefineStmt {
    pub type_: NodeTag,
    pub kind: ObjectType,
    pub oldstyle: bool,
    pub defnames: *mut List,
    pub args: *mut List,
    pub definition: *mut List,
    pub if_not_exists: bool,
    pub replace: bool,
}
impl Default for DefineStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateDomainStmt {
    pub type_: NodeTag,
    pub domainname: *mut List,
    pub typeName: *mut TypeName,
    pub collClause: *mut CollateClause,
    pub constraints: *mut List,
}
impl Default for CreateDomainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpClassStmt {
    pub type_: NodeTag,
    pub opclassname: *mut List,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
    pub datatype: *mut TypeName,
    pub items: *mut List,
    pub isDefault: bool,
}
impl Default for CreateOpClassStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpClassItem {
    pub type_: NodeTag,
    pub itemtype: ::std::os::raw::c_int,
    pub name: *mut ObjectWithArgs,
    pub number: ::std::os::raw::c_int,
    pub order_family: *mut List,
    pub class_args: *mut List,
    pub storedtype: *mut TypeName,
}
impl Default for CreateOpClassItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpFamilyStmt {
    pub type_: NodeTag,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
}
impl Default for CreateOpFamilyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOpFamilyStmt {
    pub type_: NodeTag,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
    pub isDrop: bool,
    pub items: *mut List,
}
impl Default for AlterOpFamilyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropStmt {
    pub type_: NodeTag,
    pub objects: *mut List,
    pub removeType: ObjectType,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
    pub concurrent: bool,
}
impl Default for DropStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TruncateStmt {
    pub type_: NodeTag,
    pub relations: *mut List,
    pub restart_seqs: bool,
    pub behavior: DropBehavior,
}
impl Default for TruncateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommentStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType,
    pub object: *mut Node,
    pub comment: *mut ::std::os::raw::c_char,
}
impl Default for CommentStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SecLabelStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType,
    pub object: *mut Node,
    pub provider: *mut ::std::os::raw::c_char,
    pub label: *mut ::std::os::raw::c_char,
}
impl Default for SecLabelStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeclareCursorStmt {
    pub type_: NodeTag,
    pub portalname: *mut ::std::os::raw::c_char,
    pub options: ::std::os::raw::c_int,
    pub query: *mut Node,
}
impl Default for DeclareCursorStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClosePortalStmt {
    pub type_: NodeTag,
    pub portalname: *mut ::std::os::raw::c_char,
}
impl Default for ClosePortalStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const FetchDirection_FETCH_FORWARD: FetchDirection = 0;
pub const FetchDirection_FETCH_BACKWARD: FetchDirection = 1;
pub const FetchDirection_FETCH_ABSOLUTE: FetchDirection = 2;
pub const FetchDirection_FETCH_RELATIVE: FetchDirection = 3;
pub type FetchDirection = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FetchStmt {
    pub type_: NodeTag,
    pub direction: FetchDirection,
    pub howMany: ::std::os::raw::c_long,
    pub portalname: *mut ::std::os::raw::c_char,
    pub ismove: bool,
}
impl Default for FetchStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexStmt {
    pub type_: NodeTag,
    pub idxname: *mut ::std::os::raw::c_char,
    pub relation: *mut RangeVar,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub tableSpace: *mut ::std::os::raw::c_char,
    pub indexParams: *mut List,
    pub indexIncludingParams: *mut List,
    pub options: *mut List,
    pub whereClause: *mut Node,
    pub excludeOpNames: *mut List,
    pub idxcomment: *mut ::std::os::raw::c_char,
    pub indexOid: Oid,
    pub oldNode: Oid,
    pub oldCreateSubid: SubTransactionId,
    pub oldFirstRelfilenodeSubid: SubTransactionId,
    pub unique: bool,
    pub primary: bool,
    pub isconstraint: bool,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub transformed: bool,
    pub concurrent: bool,
    pub if_not_exists: bool,
    pub reset_default_tblspc: bool,
}
impl Default for IndexStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStatsStmt {
    pub type_: NodeTag,
    pub defnames: *mut List,
    pub stat_types: *mut List,
    pub exprs: *mut List,
    pub relations: *mut List,
    pub stxcomment: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
}
impl Default for CreateStatsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterStatsStmt {
    pub type_: NodeTag,
    pub defnames: *mut List,
    pub stxstattarget: ::std::os::raw::c_int,
    pub missing_ok: bool,
}
impl Default for AlterStatsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateFunctionStmt {
    pub type_: NodeTag,
    pub is_procedure: bool,
    pub replace: bool,
    pub funcname: *mut List,
    pub parameters: *mut List,
    pub returnType: *mut TypeName,
    pub options: *mut List,
}
impl Default for CreateFunctionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const FunctionParameterMode_FUNC_PARAM_IN: FunctionParameterMode = 105;
pub const FunctionParameterMode_FUNC_PARAM_OUT: FunctionParameterMode = 111;
pub const FunctionParameterMode_FUNC_PARAM_INOUT: FunctionParameterMode = 98;
pub const FunctionParameterMode_FUNC_PARAM_VARIADIC: FunctionParameterMode = 118;
pub const FunctionParameterMode_FUNC_PARAM_TABLE: FunctionParameterMode = 116;
pub type FunctionParameterMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionParameter {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub argType: *mut TypeName,
    pub mode: FunctionParameterMode,
    pub defexpr: *mut Node,
}
impl Default for FunctionParameter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterFunctionStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType,
    pub func: *mut ObjectWithArgs,
    pub actions: *mut List,
}
impl Default for AlterFunctionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DoStmt {
    pub type_: NodeTag,
    pub args: *mut List,
}
impl Default for DoStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InlineCodeBlock {
    pub type_: NodeTag,
    pub source_text: *mut ::std::os::raw::c_char,
    pub langOid: Oid,
    pub langIsTrusted: bool,
    pub atomic: bool,
}
impl Default for InlineCodeBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CallStmt {
    pub type_: NodeTag,
    pub funccall: *mut FuncCall,
    pub funcexpr: *mut FuncExpr,
}
impl Default for CallStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CallContext {
    pub type_: NodeTag,
    pub atomic: bool,
}
impl Default for CallContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RenameStmt {
    pub type_: NodeTag,
    pub renameType: ObjectType,
    pub relationType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub subname: *mut ::std::os::raw::c_char,
    pub newname: *mut ::std::os::raw::c_char,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
}
impl Default for RenameStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterObjectDependsStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub extname: *mut Value,
    pub remove: bool,
}
impl Default for AlterObjectDependsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterObjectSchemaStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub newschema: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for AlterObjectSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOwnerStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub newowner: *mut RoleSpec,
}
impl Default for AlterOwnerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOperatorStmt {
    pub type_: NodeTag,
    pub opername: *mut ObjectWithArgs,
    pub options: *mut List,
}
impl Default for AlterOperatorStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTypeStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub options: *mut List,
}
impl Default for AlterTypeStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RuleStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub rulename: *mut ::std::os::raw::c_char,
    pub whereClause: *mut Node,
    pub event: CmdType,
    pub instead: bool,
    pub actions: *mut List,
    pub replace: bool,
}
impl Default for RuleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NotifyStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
    pub payload: *mut ::std::os::raw::c_char,
}
impl Default for NotifyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ListenStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
}
impl Default for ListenStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UnlistenStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
}
impl Default for UnlistenStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TransactionStmtKind_TRANS_STMT_BEGIN: TransactionStmtKind = 0;
pub const TransactionStmtKind_TRANS_STMT_START: TransactionStmtKind = 1;
pub const TransactionStmtKind_TRANS_STMT_COMMIT: TransactionStmtKind = 2;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK: TransactionStmtKind = 3;
pub const TransactionStmtKind_TRANS_STMT_SAVEPOINT: TransactionStmtKind = 4;
pub const TransactionStmtKind_TRANS_STMT_RELEASE: TransactionStmtKind = 5;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK_TO: TransactionStmtKind = 6;
pub const TransactionStmtKind_TRANS_STMT_PREPARE: TransactionStmtKind = 7;
pub const TransactionStmtKind_TRANS_STMT_COMMIT_PREPARED: TransactionStmtKind = 8;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK_PREPARED: TransactionStmtKind = 9;
pub type TransactionStmtKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TransactionStmt {
    pub type_: NodeTag,
    pub kind: TransactionStmtKind,
    pub options: *mut List,
    pub savepoint_name: *mut ::std::os::raw::c_char,
    pub gid: *mut ::std::os::raw::c_char,
    pub chain: bool,
}
impl Default for TransactionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CompositeTypeStmt {
    pub type_: NodeTag,
    pub typevar: *mut RangeVar,
    pub coldeflist: *mut List,
}
impl Default for CompositeTypeStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateEnumStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub vals: *mut List,
}
impl Default for CreateEnumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateRangeStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub params: *mut List,
}
impl Default for CreateRangeStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterEnumStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub oldVal: *mut ::std::os::raw::c_char,
    pub newVal: *mut ::std::os::raw::c_char,
    pub newValNeighbor: *mut ::std::os::raw::c_char,
    pub newValIsAfter: bool,
    pub skipIfNewValExists: bool,
}
impl Default for AlterEnumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ViewCheckOption_NO_CHECK_OPTION: ViewCheckOption = 0;
pub const ViewCheckOption_LOCAL_CHECK_OPTION: ViewCheckOption = 1;
pub const ViewCheckOption_CASCADED_CHECK_OPTION: ViewCheckOption = 2;
pub type ViewCheckOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ViewStmt {
    pub type_: NodeTag,
    pub view: *mut RangeVar,
    pub aliases: *mut List,
    pub query: *mut Node,
    pub replace: bool,
    pub options: *mut List,
    pub withCheckOption: ViewCheckOption,
}
impl Default for ViewStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LoadStmt {
    pub type_: NodeTag,
    pub filename: *mut ::std::os::raw::c_char,
}
impl Default for LoadStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatedbStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreatedbStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterDatabaseStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseSetStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterDatabaseSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropdbStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
    pub options: *mut List,
}
impl Default for DropdbStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSystemStmt {
    pub type_: NodeTag,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterSystemStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ClusterOption_CLUOPT_RECHECK: ClusterOption = 1;
pub const ClusterOption_CLUOPT_VERBOSE: ClusterOption = 2;
pub type ClusterOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClusterStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub indexname: *mut ::std::os::raw::c_char,
    pub options: ::std::os::raw::c_int,
}
impl Default for ClusterStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacuumStmt {
    pub type_: NodeTag,
    pub options: *mut List,
    pub rels: *mut List,
    pub is_vacuumcmd: bool,
}
impl Default for VacuumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacuumRelation {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub oid: Oid,
    pub va_cols: *mut List,
}
impl Default for VacuumRelation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExplainStmt {
    pub type_: NodeTag,
    pub query: *mut Node,
    pub options: *mut List,
}
impl Default for ExplainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableAsStmt {
    pub type_: NodeTag,
    pub query: *mut Node,
    pub into: *mut IntoClause,
    pub relkind: ObjectType,
    pub is_select_into: bool,
    pub if_not_exists: bool,
}
impl Default for CreateTableAsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RefreshMatViewStmt {
    pub type_: NodeTag,
    pub concurrent: bool,
    pub skipData: bool,
    pub relation: *mut RangeVar,
}
impl Default for RefreshMatViewStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CheckPointStmt {
    pub type_: NodeTag,
}
impl Default for CheckPointStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DiscardMode_DISCARD_ALL: DiscardMode = 0;
pub const DiscardMode_DISCARD_PLANS: DiscardMode = 1;
pub const DiscardMode_DISCARD_SEQUENCES: DiscardMode = 2;
pub const DiscardMode_DISCARD_TEMP: DiscardMode = 3;
pub type DiscardMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DiscardStmt {
    pub type_: NodeTag,
    pub target: DiscardMode,
}
impl Default for DiscardStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockStmt {
    pub type_: NodeTag,
    pub relations: *mut List,
    pub mode: ::std::os::raw::c_int,
    pub nowait: bool,
}
impl Default for LockStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstraintsSetStmt {
    pub type_: NodeTag,
    pub constraints: *mut List,
    pub deferred: bool,
}
impl Default for ConstraintsSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ReindexObjectType_REINDEX_OBJECT_INDEX: ReindexObjectType = 0;
pub const ReindexObjectType_REINDEX_OBJECT_TABLE: ReindexObjectType = 1;
pub const ReindexObjectType_REINDEX_OBJECT_SCHEMA: ReindexObjectType = 2;
pub const ReindexObjectType_REINDEX_OBJECT_SYSTEM: ReindexObjectType = 3;
pub const ReindexObjectType_REINDEX_OBJECT_DATABASE: ReindexObjectType = 4;
pub type ReindexObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReindexStmt {
    pub type_: NodeTag,
    pub kind: ReindexObjectType,
    pub relation: *mut RangeVar,
    pub name: *const ::std::os::raw::c_char,
    pub options: ::std::os::raw::c_int,
    pub concurrent: bool,
}
impl Default for ReindexStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateConversionStmt {
    pub type_: NodeTag,
    pub conversion_name: *mut List,
    pub for_encoding_name: *mut ::std::os::raw::c_char,
    pub to_encoding_name: *mut ::std::os::raw::c_char,
    pub func_name: *mut List,
    pub def: bool,
}
impl Default for CreateConversionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateCastStmt {
    pub type_: NodeTag,
    pub sourcetype: *mut TypeName,
    pub targettype: *mut TypeName,
    pub func: *mut ObjectWithArgs,
    pub context: CoercionContext,
    pub inout: bool,
}
impl Default for CreateCastStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTransformStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub type_name: *mut TypeName,
    pub lang: *mut ::std::os::raw::c_char,
    pub fromsql: *mut ObjectWithArgs,
    pub tosql: *mut ObjectWithArgs,
}
impl Default for CreateTransformStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PrepareStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub argtypes: *mut List,
    pub query: *mut Node,
}
impl Default for PrepareStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecuteStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub params: *mut List,
}
impl Default for ExecuteStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeallocateStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for DeallocateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropOwnedStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub behavior: DropBehavior,
}
impl Default for DropOwnedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReassignOwnedStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub newrole: *mut RoleSpec,
}
impl Default for ReassignOwnedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTSDictionaryStmt {
    pub type_: NodeTag,
    pub dictname: *mut List,
    pub options: *mut List,
}
impl Default for AlterTSDictionaryStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterTSConfigType_ALTER_TSCONFIG_ADD_MAPPING: AlterTSConfigType = 0;
pub const AlterTSConfigType_ALTER_TSCONFIG_ALTER_MAPPING_FOR_TOKEN: AlterTSConfigType = 1;
pub const AlterTSConfigType_ALTER_TSCONFIG_REPLACE_DICT: AlterTSConfigType = 2;
pub const AlterTSConfigType_ALTER_TSCONFIG_REPLACE_DICT_FOR_TOKEN: AlterTSConfigType = 3;
pub const AlterTSConfigType_ALTER_TSCONFIG_DROP_MAPPING: AlterTSConfigType = 4;
pub type AlterTSConfigType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTSConfigurationStmt {
    pub type_: NodeTag,
    pub kind: AlterTSConfigType,
    pub cfgname: *mut List,
    pub tokentype: *mut List,
    pub dicts: *mut List,
    pub override_: bool,
    pub replace: bool,
    pub missing_ok: bool,
}
impl Default for AlterTSConfigurationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePublicationStmt {
    pub type_: NodeTag,
    pub pubname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub tables: *mut List,
    pub for_all_tables: bool,
}
impl Default for CreatePublicationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterPublicationStmt {
    pub type_: NodeTag,
    pub pubname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub tables: *mut List,
    pub for_all_tables: bool,
    pub tableAction: DefElemAction,
}
impl Default for AlterPublicationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSubscriptionStmt {
    pub type_: NodeTag,
    pub subname: *mut ::std::os::raw::c_char,
    pub conninfo: *mut ::std::os::raw::c_char,
    pub publication: *mut List,
    pub options: *mut List,
}
impl Default for CreateSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_OPTIONS: AlterSubscriptionType = 0;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_CONNECTION: AlterSubscriptionType = 1;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_PUBLICATION: AlterSubscriptionType = 2;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_REFRESH: AlterSubscriptionType = 3;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_ENABLED: AlterSubscriptionType = 4;
pub type AlterSubscriptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSubscriptionStmt {
    pub type_: NodeTag,
    pub kind: AlterSubscriptionType,
    pub subname: *mut ::std::os::raw::c_char,
    pub conninfo: *mut ::std::os::raw::c_char,
    pub publication: *mut List,
    pub options: *mut List,
}
impl Default for AlterSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropSubscriptionStmt {
    pub type_: NodeTag,
    pub subname: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
    pub behavior: DropBehavior,
}
impl Default for DropSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemoryContextCounters {
    pub nblocks: Size,
    pub freechunks: Size,
    pub totalspace: Size,
    pub freespace: Size,
}
pub type MemoryStatsPrintFunc = ::std::option::Option<
    unsafe extern "C" fn(
        context: MemoryContext,
        passthru: *mut ::std::os::raw::c_void,
        stats_string: *const ::std::os::raw::c_char,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemoryContextMethods {
    pub alloc: ::std::option::Option<
        unsafe extern "C" fn(context: MemoryContext, size: Size) -> *mut ::std::os::raw::c_void,
    >,
    pub free_p: ::std::option::Option<
        unsafe extern "C" fn(context: MemoryContext, pointer: *mut ::std::os::raw::c_void),
    >,
    pub realloc: ::std::option::Option<
        unsafe extern "C" fn(
            context: MemoryContext,
            pointer: *mut ::std::os::raw::c_void,
            size: Size,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub reset: ::std::option::Option<unsafe extern "C" fn(context: MemoryContext)>,
    pub delete_context: ::std::option::Option<unsafe extern "C" fn(context: MemoryContext)>,
    pub get_chunk_space: ::std::option::Option<
        unsafe extern "C" fn(context: MemoryContext, pointer: *mut ::std::os::raw::c_void) -> Size,
    >,
    pub is_empty: ::std::option::Option<unsafe extern "C" fn(context: MemoryContext) -> bool>,
    pub stats: ::std::option::Option<
        unsafe extern "C" fn(
            context: MemoryContext,
            printfunc: MemoryStatsPrintFunc,
            passthru: *mut ::std::os::raw::c_void,
            totals: *mut MemoryContextCounters,
        ),
    >,
    pub check: ::std::option::Option<unsafe extern "C" fn(context: MemoryContext)>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextData {
    pub type_: NodeTag,
    pub isReset: bool,
    pub allowInCritSection: bool,
    pub mem_allocated: Size,
    pub methods: *const MemoryContextMethods,
    pub parent: MemoryContext,
    pub firstchild: MemoryContext,
    pub prevchild: MemoryContext,
    pub nextchild: MemoryContext,
    pub name: *const ::std::os::raw::c_char,
    pub ident: *const ::std::os::raw::c_char,
    pub reset_cbs: *mut MemoryContextCallback,
}
impl Default for MemoryContextData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut TopMemoryContext: MemoryContext;
}
extern "C" {
    pub static mut ErrorContext: MemoryContext;
}
extern "C" {
    pub static mut PostmasterContext: MemoryContext;
}
extern "C" {
    pub static mut CacheMemoryContext: MemoryContext;
}
extern "C" {
    pub static mut MessageContext: MemoryContext;
}
extern "C" {
    pub static mut TopTransactionContext: MemoryContext;
}
extern "C" {
    pub static mut CurTransactionContext: MemoryContext;
}
extern "C" {
    pub static mut PortalContext: MemoryContext;
}
pub unsafe fn MemoryContextInit() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextInit();
        }
        MemoryContextInit()
    })
}
pub unsafe fn MemoryContextReset(arg_context: MemoryContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextReset(arg_context: MemoryContext);
        }
        MemoryContextReset(arg_context)
    })
}
pub unsafe fn MemoryContextDelete(arg_context: MemoryContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextDelete(arg_context: MemoryContext);
        }
        MemoryContextDelete(arg_context)
    })
}
pub unsafe fn MemoryContextResetOnly(arg_context: MemoryContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextResetOnly(arg_context: MemoryContext);
        }
        MemoryContextResetOnly(arg_context)
    })
}
pub unsafe fn MemoryContextResetChildren(arg_context: MemoryContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextResetChildren(arg_context: MemoryContext);
        }
        MemoryContextResetChildren(arg_context)
    })
}
pub unsafe fn MemoryContextDeleteChildren(arg_context: MemoryContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextDeleteChildren(arg_context: MemoryContext);
        }
        MemoryContextDeleteChildren(arg_context)
    })
}
pub unsafe fn MemoryContextSetIdentifier(
    arg_context: MemoryContext,
    arg_id: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextSetIdentifier(
                arg_context: MemoryContext,
                arg_id: *const ::std::os::raw::c_char,
            );
        }
        MemoryContextSetIdentifier(arg_context, arg_id)
    })
}
pub unsafe fn MemoryContextSetParent(arg_context: MemoryContext, arg_new_parent: MemoryContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextSetParent(arg_context: MemoryContext, arg_new_parent: MemoryContext);
        }
        MemoryContextSetParent(arg_context, arg_new_parent)
    })
}
pub unsafe fn GetMemoryChunkSpace(arg_pointer: *mut ::std::os::raw::c_void) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetMemoryChunkSpace(arg_pointer: *mut ::std::os::raw::c_void) -> Size;
        }
        GetMemoryChunkSpace(arg_pointer)
    })
}
pub unsafe fn MemoryContextGetParent(arg_context: MemoryContext) -> MemoryContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextGetParent(arg_context: MemoryContext) -> MemoryContext;
        }
        MemoryContextGetParent(arg_context)
    })
}
pub unsafe fn MemoryContextIsEmpty(arg_context: MemoryContext) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextIsEmpty(arg_context: MemoryContext) -> bool;
        }
        MemoryContextIsEmpty(arg_context)
    })
}
pub unsafe fn MemoryContextMemAllocated(arg_context: MemoryContext, arg_recurse: bool) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextMemAllocated(arg_context: MemoryContext, arg_recurse: bool) -> Size;
        }
        MemoryContextMemAllocated(arg_context, arg_recurse)
    })
}
pub unsafe fn MemoryContextStats(arg_context: MemoryContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextStats(arg_context: MemoryContext);
        }
        MemoryContextStats(arg_context)
    })
}
pub unsafe fn MemoryContextStatsDetail(
    arg_context: MemoryContext,
    arg_max_children: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextStatsDetail(
                arg_context: MemoryContext,
                arg_max_children: ::std::os::raw::c_int,
            );
        }
        MemoryContextStatsDetail(arg_context, arg_max_children)
    })
}
pub unsafe fn MemoryContextAllowInCriticalSection(arg_context: MemoryContext, arg_allow: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextAllowInCriticalSection(arg_context: MemoryContext, arg_allow: bool);
        }
        MemoryContextAllowInCriticalSection(arg_context, arg_allow)
    })
}
pub unsafe fn MemoryContextCheck(arg_context: MemoryContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextCheck(arg_context: MemoryContext);
        }
        MemoryContextCheck(arg_context)
    })
}
pub unsafe fn MemoryContextContains(
    arg_context: MemoryContext,
    arg_pointer: *mut ::std::os::raw::c_void,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextContains(
                arg_context: MemoryContext,
                arg_pointer: *mut ::std::os::raw::c_void,
            ) -> bool;
        }
        MemoryContextContains(arg_context, arg_pointer)
    })
}
pub unsafe fn MemoryContextCreate(
    arg_node: MemoryContext,
    arg_tag: NodeTag,
    arg_methods: *const MemoryContextMethods,
    arg_parent: MemoryContext,
    arg_name: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MemoryContextCreate(
                arg_node: MemoryContext,
                arg_tag: NodeTag,
                arg_methods: *const MemoryContextMethods,
                arg_parent: MemoryContext,
                arg_name: *const ::std::os::raw::c_char,
            );
        }
        MemoryContextCreate(arg_node, arg_tag, arg_methods, arg_parent, arg_name)
    })
}
pub unsafe fn AllocSetContextCreateInternal(
    arg_parent: MemoryContext,
    arg_name: *const ::std::os::raw::c_char,
    arg_minContextSize: Size,
    arg_initBlockSize: Size,
    arg_maxBlockSize: Size,
) -> MemoryContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AllocSetContextCreateInternal(
                arg_parent: MemoryContext,
                arg_name: *const ::std::os::raw::c_char,
                arg_minContextSize: Size,
                arg_initBlockSize: Size,
                arg_maxBlockSize: Size,
            ) -> MemoryContext;
        }
        AllocSetContextCreateInternal(
            arg_parent,
            arg_name,
            arg_minContextSize,
            arg_initBlockSize,
            arg_maxBlockSize,
        )
    })
}
pub unsafe fn SlabContextCreate(
    arg_parent: MemoryContext,
    arg_name: *const ::std::os::raw::c_char,
    arg_blockSize: Size,
    arg_chunkSize: Size,
) -> MemoryContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SlabContextCreate(
                arg_parent: MemoryContext,
                arg_name: *const ::std::os::raw::c_char,
                arg_blockSize: Size,
                arg_chunkSize: Size,
            ) -> MemoryContext;
        }
        SlabContextCreate(arg_parent, arg_name, arg_blockSize, arg_chunkSize)
    })
}
pub unsafe fn GenerationContextCreate(
    arg_parent: MemoryContext,
    arg_name: *const ::std::os::raw::c_char,
    arg_blockSize: Size,
) -> MemoryContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GenerationContextCreate(
                arg_parent: MemoryContext,
                arg_name: *const ::std::os::raw::c_char,
                arg_blockSize: Size,
            ) -> MemoryContext;
        }
        GenerationContextCreate(arg_parent, arg_name, arg_blockSize)
    })
}
pub type ExecutorStart_hook_type = ::std::option::Option<
    unsafe extern "C" fn(queryDesc: *mut QueryDesc, eflags: ::std::os::raw::c_int),
>;
extern "C" {
    pub static mut ExecutorStart_hook: ExecutorStart_hook_type;
}
pub type ExecutorRun_hook_type = ::std::option::Option<
    unsafe extern "C" fn(
        queryDesc: *mut QueryDesc,
        direction: ScanDirection,
        count: uint64,
        execute_once: bool,
    ),
>;
extern "C" {
    pub static mut ExecutorRun_hook: ExecutorRun_hook_type;
}
pub type ExecutorFinish_hook_type =
    ::std::option::Option<unsafe extern "C" fn(queryDesc: *mut QueryDesc)>;
extern "C" {
    pub static mut ExecutorFinish_hook: ExecutorFinish_hook_type;
}
pub type ExecutorEnd_hook_type =
    ::std::option::Option<unsafe extern "C" fn(queryDesc: *mut QueryDesc)>;
extern "C" {
    pub static mut ExecutorEnd_hook: ExecutorEnd_hook_type;
}
pub type ExecutorCheckPerms_hook_type =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut List, arg2: bool) -> bool>;
extern "C" {
    pub static mut ExecutorCheckPerms_hook: ExecutorCheckPerms_hook_type;
}
pub unsafe fn ExecReScan(arg_node: *mut PlanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecReScan(arg_node: *mut PlanState);
        }
        ExecReScan(arg_node)
    })
}
pub unsafe fn ExecMarkPos(arg_node: *mut PlanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecMarkPos(arg_node: *mut PlanState);
        }
        ExecMarkPos(arg_node)
    })
}
pub unsafe fn ExecRestrPos(arg_node: *mut PlanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecRestrPos(arg_node: *mut PlanState);
        }
        ExecRestrPos(arg_node)
    })
}
pub unsafe fn ExecSupportsMarkRestore(arg_pathnode: *mut Path) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSupportsMarkRestore(arg_pathnode: *mut Path) -> bool;
        }
        ExecSupportsMarkRestore(arg_pathnode)
    })
}
pub unsafe fn ExecSupportsBackwardScan(arg_node: *mut Plan) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSupportsBackwardScan(arg_node: *mut Plan) -> bool;
        }
        ExecSupportsBackwardScan(arg_node)
    })
}
pub unsafe fn ExecMaterializesOutput(arg_plantype: NodeTag) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecMaterializesOutput(arg_plantype: NodeTag) -> bool;
        }
        ExecMaterializesOutput(arg_plantype)
    })
}
pub unsafe fn execCurrentOf(
    arg_cexpr: *mut CurrentOfExpr,
    arg_econtext: *mut ExprContext,
    arg_table_oid: Oid,
    arg_current_tid: ItemPointer,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execCurrentOf(
                arg_cexpr: *mut CurrentOfExpr,
                arg_econtext: *mut ExprContext,
                arg_table_oid: Oid,
                arg_current_tid: ItemPointer,
            ) -> bool;
        }
        execCurrentOf(arg_cexpr, arg_econtext, arg_table_oid, arg_current_tid)
    })
}
pub unsafe fn execTuplesMatchPrepare(
    arg_desc: TupleDesc,
    arg_numCols: ::std::os::raw::c_int,
    arg_keyColIdx: *const AttrNumber,
    arg_eqOperators: *const Oid,
    arg_collations: *const Oid,
    arg_parent: *mut PlanState,
) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execTuplesMatchPrepare(
                arg_desc: TupleDesc,
                arg_numCols: ::std::os::raw::c_int,
                arg_keyColIdx: *const AttrNumber,
                arg_eqOperators: *const Oid,
                arg_collations: *const Oid,
                arg_parent: *mut PlanState,
            ) -> *mut ExprState;
        }
        execTuplesMatchPrepare(
            arg_desc,
            arg_numCols,
            arg_keyColIdx,
            arg_eqOperators,
            arg_collations,
            arg_parent,
        )
    })
}
pub unsafe fn execTuplesHashPrepare(
    arg_numCols: ::std::os::raw::c_int,
    arg_eqOperators: *const Oid,
    arg_eqFuncOids: *mut *mut Oid,
    arg_hashFunctions: *mut *mut FmgrInfo,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn execTuplesHashPrepare(
                arg_numCols: ::std::os::raw::c_int,
                arg_eqOperators: *const Oid,
                arg_eqFuncOids: *mut *mut Oid,
                arg_hashFunctions: *mut *mut FmgrInfo,
            );
        }
        execTuplesHashPrepare(arg_numCols, arg_eqOperators, arg_eqFuncOids, arg_hashFunctions)
    })
}
pub unsafe fn BuildTupleHashTable(
    arg_parent: *mut PlanState,
    arg_inputDesc: TupleDesc,
    arg_numCols: ::std::os::raw::c_int,
    arg_keyColIdx: *mut AttrNumber,
    arg_eqfuncoids: *const Oid,
    arg_hashfunctions: *mut FmgrInfo,
    arg_collations: *mut Oid,
    arg_nbuckets: ::std::os::raw::c_long,
    arg_additionalsize: Size,
    arg_tablecxt: MemoryContext,
    arg_tempcxt: MemoryContext,
    arg_use_variable_hash_iv: bool,
) -> TupleHashTable {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildTupleHashTable(
                arg_parent: *mut PlanState,
                arg_inputDesc: TupleDesc,
                arg_numCols: ::std::os::raw::c_int,
                arg_keyColIdx: *mut AttrNumber,
                arg_eqfuncoids: *const Oid,
                arg_hashfunctions: *mut FmgrInfo,
                arg_collations: *mut Oid,
                arg_nbuckets: ::std::os::raw::c_long,
                arg_additionalsize: Size,
                arg_tablecxt: MemoryContext,
                arg_tempcxt: MemoryContext,
                arg_use_variable_hash_iv: bool,
            ) -> TupleHashTable;
        }
        BuildTupleHashTable(
            arg_parent,
            arg_inputDesc,
            arg_numCols,
            arg_keyColIdx,
            arg_eqfuncoids,
            arg_hashfunctions,
            arg_collations,
            arg_nbuckets,
            arg_additionalsize,
            arg_tablecxt,
            arg_tempcxt,
            arg_use_variable_hash_iv,
        )
    })
}
pub unsafe fn BuildTupleHashTableExt(
    arg_parent: *mut PlanState,
    arg_inputDesc: TupleDesc,
    arg_numCols: ::std::os::raw::c_int,
    arg_keyColIdx: *mut AttrNumber,
    arg_eqfuncoids: *const Oid,
    arg_hashfunctions: *mut FmgrInfo,
    arg_collations: *mut Oid,
    arg_nbuckets: ::std::os::raw::c_long,
    arg_additionalsize: Size,
    arg_metacxt: MemoryContext,
    arg_tablecxt: MemoryContext,
    arg_tempcxt: MemoryContext,
    arg_use_variable_hash_iv: bool,
) -> TupleHashTable {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildTupleHashTableExt(
                arg_parent: *mut PlanState,
                arg_inputDesc: TupleDesc,
                arg_numCols: ::std::os::raw::c_int,
                arg_keyColIdx: *mut AttrNumber,
                arg_eqfuncoids: *const Oid,
                arg_hashfunctions: *mut FmgrInfo,
                arg_collations: *mut Oid,
                arg_nbuckets: ::std::os::raw::c_long,
                arg_additionalsize: Size,
                arg_metacxt: MemoryContext,
                arg_tablecxt: MemoryContext,
                arg_tempcxt: MemoryContext,
                arg_use_variable_hash_iv: bool,
            ) -> TupleHashTable;
        }
        BuildTupleHashTableExt(
            arg_parent,
            arg_inputDesc,
            arg_numCols,
            arg_keyColIdx,
            arg_eqfuncoids,
            arg_hashfunctions,
            arg_collations,
            arg_nbuckets,
            arg_additionalsize,
            arg_metacxt,
            arg_tablecxt,
            arg_tempcxt,
            arg_use_variable_hash_iv,
        )
    })
}
pub unsafe fn LookupTupleHashEntry(
    arg_hashtable: TupleHashTable,
    arg_slot: *mut TupleTableSlot,
    arg_isnew: *mut bool,
    arg_hash: *mut uint32,
) -> TupleHashEntry {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LookupTupleHashEntry(
                arg_hashtable: TupleHashTable,
                arg_slot: *mut TupleTableSlot,
                arg_isnew: *mut bool,
                arg_hash: *mut uint32,
            ) -> TupleHashEntry;
        }
        LookupTupleHashEntry(arg_hashtable, arg_slot, arg_isnew, arg_hash)
    })
}
pub unsafe fn TupleHashTableHash(
    arg_hashtable: TupleHashTable,
    arg_slot: *mut TupleTableSlot,
) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleHashTableHash(
                arg_hashtable: TupleHashTable,
                arg_slot: *mut TupleTableSlot,
            ) -> uint32;
        }
        TupleHashTableHash(arg_hashtable, arg_slot)
    })
}
pub unsafe fn LookupTupleHashEntryHash(
    arg_hashtable: TupleHashTable,
    arg_slot: *mut TupleTableSlot,
    arg_isnew: *mut bool,
    arg_hash: uint32,
) -> TupleHashEntry {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LookupTupleHashEntryHash(
                arg_hashtable: TupleHashTable,
                arg_slot: *mut TupleTableSlot,
                arg_isnew: *mut bool,
                arg_hash: uint32,
            ) -> TupleHashEntry;
        }
        LookupTupleHashEntryHash(arg_hashtable, arg_slot, arg_isnew, arg_hash)
    })
}
pub unsafe fn FindTupleHashEntry(
    arg_hashtable: TupleHashTable,
    arg_slot: *mut TupleTableSlot,
    arg_eqcomp: *mut ExprState,
    arg_hashfunctions: *mut FmgrInfo,
) -> TupleHashEntry {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FindTupleHashEntry(
                arg_hashtable: TupleHashTable,
                arg_slot: *mut TupleTableSlot,
                arg_eqcomp: *mut ExprState,
                arg_hashfunctions: *mut FmgrInfo,
            ) -> TupleHashEntry;
        }
        FindTupleHashEntry(arg_hashtable, arg_slot, arg_eqcomp, arg_hashfunctions)
    })
}
pub unsafe fn ResetTupleHashTable(arg_hashtable: TupleHashTable) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ResetTupleHashTable(arg_hashtable: TupleHashTable);
        }
        ResetTupleHashTable(arg_hashtable)
    })
}
pub unsafe fn ExecInitJunkFilter(
    arg_targetList: *mut List,
    arg_slot: *mut TupleTableSlot,
) -> *mut JunkFilter {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitJunkFilter(
                arg_targetList: *mut List,
                arg_slot: *mut TupleTableSlot,
            ) -> *mut JunkFilter;
        }
        ExecInitJunkFilter(arg_targetList, arg_slot)
    })
}
pub unsafe fn ExecInitJunkFilterInsertion(
    arg_targetList: *mut List,
    arg_cleanTupType: TupleDesc,
    arg_slot: *mut TupleTableSlot,
) -> *mut JunkFilter {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitJunkFilterInsertion(
                arg_targetList: *mut List,
                arg_cleanTupType: TupleDesc,
                arg_slot: *mut TupleTableSlot,
            ) -> *mut JunkFilter;
        }
        ExecInitJunkFilterInsertion(arg_targetList, arg_cleanTupType, arg_slot)
    })
}
pub unsafe fn ExecInitJunkFilterConversion(
    arg_targetList: *mut List,
    arg_cleanTupType: TupleDesc,
    arg_slot: *mut TupleTableSlot,
) -> *mut JunkFilter {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitJunkFilterConversion(
                arg_targetList: *mut List,
                arg_cleanTupType: TupleDesc,
                arg_slot: *mut TupleTableSlot,
            ) -> *mut JunkFilter;
        }
        ExecInitJunkFilterConversion(arg_targetList, arg_cleanTupType, arg_slot)
    })
}
pub unsafe fn ExecFindJunkAttribute(
    arg_junkfilter: *mut JunkFilter,
    arg_attrName: *const ::std::os::raw::c_char,
) -> AttrNumber {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFindJunkAttribute(
                arg_junkfilter: *mut JunkFilter,
                arg_attrName: *const ::std::os::raw::c_char,
            ) -> AttrNumber;
        }
        ExecFindJunkAttribute(arg_junkfilter, arg_attrName)
    })
}
pub unsafe fn ExecFindJunkAttributeInTlist(
    arg_targetlist: *mut List,
    arg_attrName: *const ::std::os::raw::c_char,
) -> AttrNumber {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFindJunkAttributeInTlist(
                arg_targetlist: *mut List,
                arg_attrName: *const ::std::os::raw::c_char,
            ) -> AttrNumber;
        }
        ExecFindJunkAttributeInTlist(arg_targetlist, arg_attrName)
    })
}
pub unsafe fn ExecGetJunkAttribute(
    arg_slot: *mut TupleTableSlot,
    arg_attno: AttrNumber,
    arg_isNull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetJunkAttribute(
                arg_slot: *mut TupleTableSlot,
                arg_attno: AttrNumber,
                arg_isNull: *mut bool,
            ) -> Datum;
        }
        ExecGetJunkAttribute(arg_slot, arg_attno, arg_isNull)
    })
}
pub unsafe fn ExecFilterJunk(
    arg_junkfilter: *mut JunkFilter,
    arg_slot: *mut TupleTableSlot,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFilterJunk(
                arg_junkfilter: *mut JunkFilter,
                arg_slot: *mut TupleTableSlot,
            ) -> *mut TupleTableSlot;
        }
        ExecFilterJunk(arg_junkfilter, arg_slot)
    })
}
pub unsafe fn ExecutorStart(arg_queryDesc: *mut QueryDesc, arg_eflags: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecutorStart(arg_queryDesc: *mut QueryDesc, arg_eflags: ::std::os::raw::c_int);
        }
        ExecutorStart(arg_queryDesc, arg_eflags)
    })
}
pub unsafe fn standard_ExecutorStart(
    arg_queryDesc: *mut QueryDesc,
    arg_eflags: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn standard_ExecutorStart(
                arg_queryDesc: *mut QueryDesc,
                arg_eflags: ::std::os::raw::c_int,
            );
        }
        standard_ExecutorStart(arg_queryDesc, arg_eflags)
    })
}
pub unsafe fn ExecutorRun(
    arg_queryDesc: *mut QueryDesc,
    arg_direction: ScanDirection,
    arg_count: uint64,
    arg_execute_once: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecutorRun(
                arg_queryDesc: *mut QueryDesc,
                arg_direction: ScanDirection,
                arg_count: uint64,
                arg_execute_once: bool,
            );
        }
        ExecutorRun(arg_queryDesc, arg_direction, arg_count, arg_execute_once)
    })
}
pub unsafe fn standard_ExecutorRun(
    arg_queryDesc: *mut QueryDesc,
    arg_direction: ScanDirection,
    arg_count: uint64,
    arg_execute_once: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn standard_ExecutorRun(
                arg_queryDesc: *mut QueryDesc,
                arg_direction: ScanDirection,
                arg_count: uint64,
                arg_execute_once: bool,
            );
        }
        standard_ExecutorRun(arg_queryDesc, arg_direction, arg_count, arg_execute_once)
    })
}
pub unsafe fn ExecutorFinish(arg_queryDesc: *mut QueryDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecutorFinish(arg_queryDesc: *mut QueryDesc);
        }
        ExecutorFinish(arg_queryDesc)
    })
}
pub unsafe fn standard_ExecutorFinish(arg_queryDesc: *mut QueryDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn standard_ExecutorFinish(arg_queryDesc: *mut QueryDesc);
        }
        standard_ExecutorFinish(arg_queryDesc)
    })
}
pub unsafe fn ExecutorEnd(arg_queryDesc: *mut QueryDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecutorEnd(arg_queryDesc: *mut QueryDesc);
        }
        ExecutorEnd(arg_queryDesc)
    })
}
pub unsafe fn standard_ExecutorEnd(arg_queryDesc: *mut QueryDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn standard_ExecutorEnd(arg_queryDesc: *mut QueryDesc);
        }
        standard_ExecutorEnd(arg_queryDesc)
    })
}
pub unsafe fn ExecutorRewind(arg_queryDesc: *mut QueryDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecutorRewind(arg_queryDesc: *mut QueryDesc);
        }
        ExecutorRewind(arg_queryDesc)
    })
}
pub unsafe fn ExecCheckRTPerms(arg_rangeTable: *mut List, arg_ereport_on_violation: bool) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecCheckRTPerms(arg_rangeTable: *mut List, arg_ereport_on_violation: bool) -> bool;
        }
        ExecCheckRTPerms(arg_rangeTable, arg_ereport_on_violation)
    })
}
pub unsafe fn CheckValidResultRel(arg_resultRelInfo: *mut ResultRelInfo, arg_operation: CmdType) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CheckValidResultRel(arg_resultRelInfo: *mut ResultRelInfo, arg_operation: CmdType);
        }
        CheckValidResultRel(arg_resultRelInfo, arg_operation)
    })
}
pub unsafe fn InitResultRelInfo(
    arg_resultRelInfo: *mut ResultRelInfo,
    arg_resultRelationDesc: Relation,
    arg_resultRelationIndex: Index,
    arg_partition_root_rri: *mut ResultRelInfo,
    arg_instrument_options: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitResultRelInfo(
                arg_resultRelInfo: *mut ResultRelInfo,
                arg_resultRelationDesc: Relation,
                arg_resultRelationIndex: Index,
                arg_partition_root_rri: *mut ResultRelInfo,
                arg_instrument_options: ::std::os::raw::c_int,
            );
        }
        InitResultRelInfo(
            arg_resultRelInfo,
            arg_resultRelationDesc,
            arg_resultRelationIndex,
            arg_partition_root_rri,
            arg_instrument_options,
        )
    })
}
pub unsafe fn ExecGetTriggerResultRel(
    arg_estate: *mut EState,
    arg_relid: Oid,
) -> *mut ResultRelInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetTriggerResultRel(
                arg_estate: *mut EState,
                arg_relid: Oid,
            ) -> *mut ResultRelInfo;
        }
        ExecGetTriggerResultRel(arg_estate, arg_relid)
    })
}
pub unsafe fn ExecCleanUpTriggerState(arg_estate: *mut EState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecCleanUpTriggerState(arg_estate: *mut EState);
        }
        ExecCleanUpTriggerState(arg_estate)
    })
}
pub unsafe fn ExecConstraints(
    arg_resultRelInfo: *mut ResultRelInfo,
    arg_slot: *mut TupleTableSlot,
    arg_estate: *mut EState,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecConstraints(
                arg_resultRelInfo: *mut ResultRelInfo,
                arg_slot: *mut TupleTableSlot,
                arg_estate: *mut EState,
            );
        }
        ExecConstraints(arg_resultRelInfo, arg_slot, arg_estate)
    })
}
pub unsafe fn ExecPartitionCheck(
    arg_resultRelInfo: *mut ResultRelInfo,
    arg_slot: *mut TupleTableSlot,
    arg_estate: *mut EState,
    arg_emitError: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecPartitionCheck(
                arg_resultRelInfo: *mut ResultRelInfo,
                arg_slot: *mut TupleTableSlot,
                arg_estate: *mut EState,
                arg_emitError: bool,
            ) -> bool;
        }
        ExecPartitionCheck(arg_resultRelInfo, arg_slot, arg_estate, arg_emitError)
    })
}
pub unsafe fn ExecPartitionCheckEmitError(
    arg_resultRelInfo: *mut ResultRelInfo,
    arg_slot: *mut TupleTableSlot,
    arg_estate: *mut EState,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecPartitionCheckEmitError(
                arg_resultRelInfo: *mut ResultRelInfo,
                arg_slot: *mut TupleTableSlot,
                arg_estate: *mut EState,
            );
        }
        ExecPartitionCheckEmitError(arg_resultRelInfo, arg_slot, arg_estate)
    })
}
pub unsafe fn ExecWithCheckOptions(
    arg_kind: WCOKind,
    arg_resultRelInfo: *mut ResultRelInfo,
    arg_slot: *mut TupleTableSlot,
    arg_estate: *mut EState,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecWithCheckOptions(
                arg_kind: WCOKind,
                arg_resultRelInfo: *mut ResultRelInfo,
                arg_slot: *mut TupleTableSlot,
                arg_estate: *mut EState,
            );
        }
        ExecWithCheckOptions(arg_kind, arg_resultRelInfo, arg_slot, arg_estate)
    })
}
pub unsafe fn ExecUpdateLockMode(
    arg_estate: *mut EState,
    arg_relinfo: *mut ResultRelInfo,
) -> LockTupleMode {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecUpdateLockMode(
                arg_estate: *mut EState,
                arg_relinfo: *mut ResultRelInfo,
            ) -> LockTupleMode;
        }
        ExecUpdateLockMode(arg_estate, arg_relinfo)
    })
}
pub unsafe fn ExecFindRowMark(
    arg_estate: *mut EState,
    arg_rti: Index,
    arg_missing_ok: bool,
) -> *mut ExecRowMark {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFindRowMark(
                arg_estate: *mut EState,
                arg_rti: Index,
                arg_missing_ok: bool,
            ) -> *mut ExecRowMark;
        }
        ExecFindRowMark(arg_estate, arg_rti, arg_missing_ok)
    })
}
pub unsafe fn ExecBuildAuxRowMark(
    arg_erm: *mut ExecRowMark,
    arg_targetlist: *mut List,
) -> *mut ExecAuxRowMark {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecBuildAuxRowMark(
                arg_erm: *mut ExecRowMark,
                arg_targetlist: *mut List,
            ) -> *mut ExecAuxRowMark;
        }
        ExecBuildAuxRowMark(arg_erm, arg_targetlist)
    })
}
pub unsafe fn EvalPlanQual(
    arg_epqstate: *mut EPQState,
    arg_relation: Relation,
    arg_rti: Index,
    arg_testslot: *mut TupleTableSlot,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EvalPlanQual(
                arg_epqstate: *mut EPQState,
                arg_relation: Relation,
                arg_rti: Index,
                arg_testslot: *mut TupleTableSlot,
            ) -> *mut TupleTableSlot;
        }
        EvalPlanQual(arg_epqstate, arg_relation, arg_rti, arg_testslot)
    })
}
pub unsafe fn EvalPlanQualInit(
    arg_epqstate: *mut EPQState,
    arg_parentestate: *mut EState,
    arg_subplan: *mut Plan,
    arg_auxrowmarks: *mut List,
    arg_epqParam: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EvalPlanQualInit(
                arg_epqstate: *mut EPQState,
                arg_parentestate: *mut EState,
                arg_subplan: *mut Plan,
                arg_auxrowmarks: *mut List,
                arg_epqParam: ::std::os::raw::c_int,
            );
        }
        EvalPlanQualInit(arg_epqstate, arg_parentestate, arg_subplan, arg_auxrowmarks, arg_epqParam)
    })
}
pub unsafe fn EvalPlanQualSetPlan(
    arg_epqstate: *mut EPQState,
    arg_subplan: *mut Plan,
    arg_auxrowmarks: *mut List,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EvalPlanQualSetPlan(
                arg_epqstate: *mut EPQState,
                arg_subplan: *mut Plan,
                arg_auxrowmarks: *mut List,
            );
        }
        EvalPlanQualSetPlan(arg_epqstate, arg_subplan, arg_auxrowmarks)
    })
}
pub unsafe fn EvalPlanQualSlot(
    arg_epqstate: *mut EPQState,
    arg_relation: Relation,
    arg_rti: Index,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EvalPlanQualSlot(
                arg_epqstate: *mut EPQState,
                arg_relation: Relation,
                arg_rti: Index,
            ) -> *mut TupleTableSlot;
        }
        EvalPlanQualSlot(arg_epqstate, arg_relation, arg_rti)
    })
}
pub unsafe fn EvalPlanQualFetchRowMark(
    arg_epqstate: *mut EPQState,
    arg_rti: Index,
    arg_slot: *mut TupleTableSlot,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EvalPlanQualFetchRowMark(
                arg_epqstate: *mut EPQState,
                arg_rti: Index,
                arg_slot: *mut TupleTableSlot,
            ) -> bool;
        }
        EvalPlanQualFetchRowMark(arg_epqstate, arg_rti, arg_slot)
    })
}
pub unsafe fn EvalPlanQualNext(arg_epqstate: *mut EPQState) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EvalPlanQualNext(arg_epqstate: *mut EPQState) -> *mut TupleTableSlot;
        }
        EvalPlanQualNext(arg_epqstate)
    })
}
pub unsafe fn EvalPlanQualBegin(arg_epqstate: *mut EPQState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EvalPlanQualBegin(arg_epqstate: *mut EPQState);
        }
        EvalPlanQualBegin(arg_epqstate)
    })
}
pub unsafe fn EvalPlanQualEnd(arg_epqstate: *mut EPQState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn EvalPlanQualEnd(arg_epqstate: *mut EPQState);
        }
        EvalPlanQualEnd(arg_epqstate)
    })
}
pub unsafe fn ExecInitNode(
    arg_node: *mut Plan,
    arg_estate: *mut EState,
    arg_eflags: ::std::os::raw::c_int,
) -> *mut PlanState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitNode(
                arg_node: *mut Plan,
                arg_estate: *mut EState,
                arg_eflags: ::std::os::raw::c_int,
            ) -> *mut PlanState;
        }
        ExecInitNode(arg_node, arg_estate, arg_eflags)
    })
}
pub unsafe fn ExecSetExecProcNode(arg_node: *mut PlanState, arg_function: ExecProcNodeMtd) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSetExecProcNode(arg_node: *mut PlanState, arg_function: ExecProcNodeMtd);
        }
        ExecSetExecProcNode(arg_node, arg_function)
    })
}
pub unsafe fn MultiExecProcNode(arg_node: *mut PlanState) -> *mut Node {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MultiExecProcNode(arg_node: *mut PlanState) -> *mut Node;
        }
        MultiExecProcNode(arg_node)
    })
}
pub unsafe fn ExecEndNode(arg_node: *mut PlanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecEndNode(arg_node: *mut PlanState);
        }
        ExecEndNode(arg_node)
    })
}
pub unsafe fn ExecShutdownNode(arg_node: *mut PlanState) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecShutdownNode(arg_node: *mut PlanState) -> bool;
        }
        ExecShutdownNode(arg_node)
    })
}
pub unsafe fn ExecSetTupleBound(arg_tuples_needed: int64, arg_child_node: *mut PlanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSetTupleBound(arg_tuples_needed: int64, arg_child_node: *mut PlanState);
        }
        ExecSetTupleBound(arg_tuples_needed, arg_child_node)
    })
}
pub unsafe fn ExecInitExpr(arg_node: *mut Expr, arg_parent: *mut PlanState) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitExpr(arg_node: *mut Expr, arg_parent: *mut PlanState) -> *mut ExprState;
        }
        ExecInitExpr(arg_node, arg_parent)
    })
}
pub unsafe fn ExecInitExprWithParams(
    arg_node: *mut Expr,
    arg_ext_params: ParamListInfo,
) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitExprWithParams(
                arg_node: *mut Expr,
                arg_ext_params: ParamListInfo,
            ) -> *mut ExprState;
        }
        ExecInitExprWithParams(arg_node, arg_ext_params)
    })
}
pub unsafe fn ExecInitQual(arg_qual: *mut List, arg_parent: *mut PlanState) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitQual(arg_qual: *mut List, arg_parent: *mut PlanState) -> *mut ExprState;
        }
        ExecInitQual(arg_qual, arg_parent)
    })
}
pub unsafe fn ExecInitCheck(arg_qual: *mut List, arg_parent: *mut PlanState) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitCheck(arg_qual: *mut List, arg_parent: *mut PlanState) -> *mut ExprState;
        }
        ExecInitCheck(arg_qual, arg_parent)
    })
}
pub unsafe fn ExecInitExprList(arg_nodes: *mut List, arg_parent: *mut PlanState) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitExprList(arg_nodes: *mut List, arg_parent: *mut PlanState) -> *mut List;
        }
        ExecInitExprList(arg_nodes, arg_parent)
    })
}
pub unsafe fn ExecBuildAggTrans(
    arg_aggstate: *mut AggState,
    arg_phase: *mut AggStatePerPhaseData,
    arg_doSort: bool,
    arg_doHash: bool,
    arg_nullcheck: bool,
) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecBuildAggTrans(
                arg_aggstate: *mut AggState,
                arg_phase: *mut AggStatePerPhaseData,
                arg_doSort: bool,
                arg_doHash: bool,
                arg_nullcheck: bool,
            ) -> *mut ExprState;
        }
        ExecBuildAggTrans(arg_aggstate, arg_phase, arg_doSort, arg_doHash, arg_nullcheck)
    })
}
pub unsafe fn ExecBuildGroupingEqual(
    arg_ldesc: TupleDesc,
    arg_rdesc: TupleDesc,
    arg_lops: *const TupleTableSlotOps,
    arg_rops: *const TupleTableSlotOps,
    arg_numCols: ::std::os::raw::c_int,
    arg_keyColIdx: *const AttrNumber,
    arg_eqfunctions: *const Oid,
    arg_collations: *const Oid,
    arg_parent: *mut PlanState,
) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecBuildGroupingEqual(
                arg_ldesc: TupleDesc,
                arg_rdesc: TupleDesc,
                arg_lops: *const TupleTableSlotOps,
                arg_rops: *const TupleTableSlotOps,
                arg_numCols: ::std::os::raw::c_int,
                arg_keyColIdx: *const AttrNumber,
                arg_eqfunctions: *const Oid,
                arg_collations: *const Oid,
                arg_parent: *mut PlanState,
            ) -> *mut ExprState;
        }
        ExecBuildGroupingEqual(
            arg_ldesc,
            arg_rdesc,
            arg_lops,
            arg_rops,
            arg_numCols,
            arg_keyColIdx,
            arg_eqfunctions,
            arg_collations,
            arg_parent,
        )
    })
}
pub unsafe fn ExecBuildProjectionInfo(
    arg_targetList: *mut List,
    arg_econtext: *mut ExprContext,
    arg_slot: *mut TupleTableSlot,
    arg_parent: *mut PlanState,
    arg_inputDesc: TupleDesc,
) -> *mut ProjectionInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecBuildProjectionInfo(
                arg_targetList: *mut List,
                arg_econtext: *mut ExprContext,
                arg_slot: *mut TupleTableSlot,
                arg_parent: *mut PlanState,
                arg_inputDesc: TupleDesc,
            ) -> *mut ProjectionInfo;
        }
        ExecBuildProjectionInfo(arg_targetList, arg_econtext, arg_slot, arg_parent, arg_inputDesc)
    })
}
pub unsafe fn ExecBuildProjectionInfoExt(
    arg_targetList: *mut List,
    arg_econtext: *mut ExprContext,
    arg_slot: *mut TupleTableSlot,
    arg_assignJunkEntries: bool,
    arg_parent: *mut PlanState,
    arg_inputDesc: TupleDesc,
) -> *mut ProjectionInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecBuildProjectionInfoExt(
                arg_targetList: *mut List,
                arg_econtext: *mut ExprContext,
                arg_slot: *mut TupleTableSlot,
                arg_assignJunkEntries: bool,
                arg_parent: *mut PlanState,
                arg_inputDesc: TupleDesc,
            ) -> *mut ProjectionInfo;
        }
        ExecBuildProjectionInfoExt(
            arg_targetList,
            arg_econtext,
            arg_slot,
            arg_assignJunkEntries,
            arg_parent,
            arg_inputDesc,
        )
    })
}
pub unsafe fn ExecPrepareExpr(arg_node: *mut Expr, arg_estate: *mut EState) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecPrepareExpr(arg_node: *mut Expr, arg_estate: *mut EState) -> *mut ExprState;
        }
        ExecPrepareExpr(arg_node, arg_estate)
    })
}
pub unsafe fn ExecPrepareQual(arg_qual: *mut List, arg_estate: *mut EState) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecPrepareQual(arg_qual: *mut List, arg_estate: *mut EState) -> *mut ExprState;
        }
        ExecPrepareQual(arg_qual, arg_estate)
    })
}
pub unsafe fn ExecPrepareCheck(arg_qual: *mut List, arg_estate: *mut EState) -> *mut ExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecPrepareCheck(arg_qual: *mut List, arg_estate: *mut EState) -> *mut ExprState;
        }
        ExecPrepareCheck(arg_qual, arg_estate)
    })
}
pub unsafe fn ExecPrepareExprList(arg_nodes: *mut List, arg_estate: *mut EState) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecPrepareExprList(arg_nodes: *mut List, arg_estate: *mut EState) -> *mut List;
        }
        ExecPrepareExprList(arg_nodes, arg_estate)
    })
}
pub unsafe fn ExecCheck(arg_state: *mut ExprState, arg_context: *mut ExprContext) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecCheck(arg_state: *mut ExprState, arg_context: *mut ExprContext) -> bool;
        }
        ExecCheck(arg_state, arg_context)
    })
}
pub unsafe fn ExecInitTableFunctionResult(
    arg_expr: *mut Expr,
    arg_econtext: *mut ExprContext,
    arg_parent: *mut PlanState,
) -> *mut SetExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitTableFunctionResult(
                arg_expr: *mut Expr,
                arg_econtext: *mut ExprContext,
                arg_parent: *mut PlanState,
            ) -> *mut SetExprState;
        }
        ExecInitTableFunctionResult(arg_expr, arg_econtext, arg_parent)
    })
}
pub unsafe fn ExecMakeTableFunctionResult(
    arg_setexpr: *mut SetExprState,
    arg_econtext: *mut ExprContext,
    arg_argContext: MemoryContext,
    arg_expectedDesc: TupleDesc,
    arg_randomAccess: bool,
) -> *mut Tuplestorestate {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecMakeTableFunctionResult(
                arg_setexpr: *mut SetExprState,
                arg_econtext: *mut ExprContext,
                arg_argContext: MemoryContext,
                arg_expectedDesc: TupleDesc,
                arg_randomAccess: bool,
            ) -> *mut Tuplestorestate;
        }
        ExecMakeTableFunctionResult(
            arg_setexpr,
            arg_econtext,
            arg_argContext,
            arg_expectedDesc,
            arg_randomAccess,
        )
    })
}
pub unsafe fn ExecInitFunctionResultSet(
    arg_expr: *mut Expr,
    arg_econtext: *mut ExprContext,
    arg_parent: *mut PlanState,
) -> *mut SetExprState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitFunctionResultSet(
                arg_expr: *mut Expr,
                arg_econtext: *mut ExprContext,
                arg_parent: *mut PlanState,
            ) -> *mut SetExprState;
        }
        ExecInitFunctionResultSet(arg_expr, arg_econtext, arg_parent)
    })
}
pub unsafe fn ExecMakeFunctionResultSet(
    arg_fcache: *mut SetExprState,
    arg_econtext: *mut ExprContext,
    arg_argContext: MemoryContext,
    arg_isNull: *mut bool,
    arg_isDone: *mut ExprDoneCond,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecMakeFunctionResultSet(
                arg_fcache: *mut SetExprState,
                arg_econtext: *mut ExprContext,
                arg_argContext: MemoryContext,
                arg_isNull: *mut bool,
                arg_isDone: *mut ExprDoneCond,
            ) -> Datum;
        }
        ExecMakeFunctionResultSet(arg_fcache, arg_econtext, arg_argContext, arg_isNull, arg_isDone)
    })
}
pub type ExecScanAccessMtd =
    ::std::option::Option<unsafe extern "C" fn(node: *mut ScanState) -> *mut TupleTableSlot>;
pub type ExecScanRecheckMtd = ::std::option::Option<
    unsafe extern "C" fn(node: *mut ScanState, slot: *mut TupleTableSlot) -> bool,
>;
pub unsafe fn ExecScan(
    arg_node: *mut ScanState,
    arg_accessMtd: ExecScanAccessMtd,
    arg_recheckMtd: ExecScanRecheckMtd,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecScan(
                arg_node: *mut ScanState,
                arg_accessMtd: ExecScanAccessMtd,
                arg_recheckMtd: ExecScanRecheckMtd,
            ) -> *mut TupleTableSlot;
        }
        ExecScan(arg_node, arg_accessMtd, arg_recheckMtd)
    })
}
pub unsafe fn ExecAssignScanProjectionInfo(arg_node: *mut ScanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecAssignScanProjectionInfo(arg_node: *mut ScanState);
        }
        ExecAssignScanProjectionInfo(arg_node)
    })
}
pub unsafe fn ExecAssignScanProjectionInfoWithVarno(arg_node: *mut ScanState, arg_varno: Index) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecAssignScanProjectionInfoWithVarno(arg_node: *mut ScanState, arg_varno: Index);
        }
        ExecAssignScanProjectionInfoWithVarno(arg_node, arg_varno)
    })
}
pub unsafe fn ExecScanReScan(arg_node: *mut ScanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecScanReScan(arg_node: *mut ScanState);
        }
        ExecScanReScan(arg_node)
    })
}
pub unsafe fn ExecInitResultTypeTL(arg_planstate: *mut PlanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitResultTypeTL(arg_planstate: *mut PlanState);
        }
        ExecInitResultTypeTL(arg_planstate)
    })
}
pub unsafe fn ExecInitResultSlot(
    arg_planstate: *mut PlanState,
    arg_tts_ops: *const TupleTableSlotOps,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitResultSlot(
                arg_planstate: *mut PlanState,
                arg_tts_ops: *const TupleTableSlotOps,
            );
        }
        ExecInitResultSlot(arg_planstate, arg_tts_ops)
    })
}
pub unsafe fn ExecInitResultTupleSlotTL(
    arg_planstate: *mut PlanState,
    arg_tts_ops: *const TupleTableSlotOps,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitResultTupleSlotTL(
                arg_planstate: *mut PlanState,
                arg_tts_ops: *const TupleTableSlotOps,
            );
        }
        ExecInitResultTupleSlotTL(arg_planstate, arg_tts_ops)
    })
}
pub unsafe fn ExecInitScanTupleSlot(
    arg_estate: *mut EState,
    arg_scanstate: *mut ScanState,
    arg_tupleDesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitScanTupleSlot(
                arg_estate: *mut EState,
                arg_scanstate: *mut ScanState,
                arg_tupleDesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            );
        }
        ExecInitScanTupleSlot(arg_estate, arg_scanstate, arg_tupleDesc, arg_tts_ops)
    })
}
pub unsafe fn ExecInitExtraTupleSlot(
    arg_estate: *mut EState,
    arg_tupledesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitExtraTupleSlot(
                arg_estate: *mut EState,
                arg_tupledesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        ExecInitExtraTupleSlot(arg_estate, arg_tupledesc, arg_tts_ops)
    })
}
pub unsafe fn ExecInitNullTupleSlot(
    arg_estate: *mut EState,
    arg_tupType: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitNullTupleSlot(
                arg_estate: *mut EState,
                arg_tupType: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupleTableSlot;
        }
        ExecInitNullTupleSlot(arg_estate, arg_tupType, arg_tts_ops)
    })
}
pub unsafe fn ExecTypeFromTL(arg_targetList: *mut List) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecTypeFromTL(arg_targetList: *mut List) -> TupleDesc;
        }
        ExecTypeFromTL(arg_targetList)
    })
}
pub unsafe fn ExecCleanTypeFromTL(arg_targetList: *mut List) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecCleanTypeFromTL(arg_targetList: *mut List) -> TupleDesc;
        }
        ExecCleanTypeFromTL(arg_targetList)
    })
}
pub unsafe fn ExecTypeFromExprList(arg_exprList: *mut List) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecTypeFromExprList(arg_exprList: *mut List) -> TupleDesc;
        }
        ExecTypeFromExprList(arg_exprList)
    })
}
pub unsafe fn ExecTypeSetColNames(arg_typeInfo: TupleDesc, arg_namesList: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecTypeSetColNames(arg_typeInfo: TupleDesc, arg_namesList: *mut List);
        }
        ExecTypeSetColNames(arg_typeInfo, arg_namesList)
    })
}
pub unsafe fn UpdateChangedParamSet(arg_node: *mut PlanState, arg_newchg: *mut Bitmapset) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn UpdateChangedParamSet(arg_node: *mut PlanState, arg_newchg: *mut Bitmapset);
        }
        UpdateChangedParamSet(arg_node, arg_newchg)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupOutputState {
    pub slot: *mut TupleTableSlot,
    pub dest: *mut DestReceiver,
}
impl Default for TupOutputState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn begin_tup_output_tupdesc(
    arg_dest: *mut DestReceiver,
    arg_tupdesc: TupleDesc,
    arg_tts_ops: *const TupleTableSlotOps,
) -> *mut TupOutputState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn begin_tup_output_tupdesc(
                arg_dest: *mut DestReceiver,
                arg_tupdesc: TupleDesc,
                arg_tts_ops: *const TupleTableSlotOps,
            ) -> *mut TupOutputState;
        }
        begin_tup_output_tupdesc(arg_dest, arg_tupdesc, arg_tts_ops)
    })
}
pub unsafe fn do_tup_output(
    arg_tstate: *mut TupOutputState,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn do_tup_output(
                arg_tstate: *mut TupOutputState,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            );
        }
        do_tup_output(arg_tstate, arg_values, arg_isnull)
    })
}
pub unsafe fn do_text_output_multiline(
    arg_tstate: *mut TupOutputState,
    arg_txt: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn do_text_output_multiline(
                arg_tstate: *mut TupOutputState,
                arg_txt: *const ::std::os::raw::c_char,
            );
        }
        do_text_output_multiline(arg_tstate, arg_txt)
    })
}
pub unsafe fn end_tup_output(arg_tstate: *mut TupOutputState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn end_tup_output(arg_tstate: *mut TupOutputState);
        }
        end_tup_output(arg_tstate)
    })
}
pub unsafe fn CreateExecutorState() -> *mut EState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateExecutorState() -> *mut EState;
        }
        CreateExecutorState()
    })
}
pub unsafe fn FreeExecutorState(arg_estate: *mut EState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeExecutorState(arg_estate: *mut EState);
        }
        FreeExecutorState(arg_estate)
    })
}
pub unsafe fn CreateExprContext(arg_estate: *mut EState) -> *mut ExprContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateExprContext(arg_estate: *mut EState) -> *mut ExprContext;
        }
        CreateExprContext(arg_estate)
    })
}
pub unsafe fn CreateWorkExprContext(arg_estate: *mut EState) -> *mut ExprContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateWorkExprContext(arg_estate: *mut EState) -> *mut ExprContext;
        }
        CreateWorkExprContext(arg_estate)
    })
}
pub unsafe fn CreateStandaloneExprContext() -> *mut ExprContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateStandaloneExprContext() -> *mut ExprContext;
        }
        CreateStandaloneExprContext()
    })
}
pub unsafe fn FreeExprContext(arg_econtext: *mut ExprContext, arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeExprContext(arg_econtext: *mut ExprContext, arg_isCommit: bool);
        }
        FreeExprContext(arg_econtext, arg_isCommit)
    })
}
pub unsafe fn ReScanExprContext(arg_econtext: *mut ExprContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ReScanExprContext(arg_econtext: *mut ExprContext);
        }
        ReScanExprContext(arg_econtext)
    })
}
pub unsafe fn MakePerTupleExprContext(arg_estate: *mut EState) -> *mut ExprContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MakePerTupleExprContext(arg_estate: *mut EState) -> *mut ExprContext;
        }
        MakePerTupleExprContext(arg_estate)
    })
}
pub unsafe fn ExecAssignExprContext(arg_estate: *mut EState, arg_planstate: *mut PlanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecAssignExprContext(arg_estate: *mut EState, arg_planstate: *mut PlanState);
        }
        ExecAssignExprContext(arg_estate, arg_planstate)
    })
}
pub unsafe fn ExecGetResultType(arg_planstate: *mut PlanState) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetResultType(arg_planstate: *mut PlanState) -> TupleDesc;
        }
        ExecGetResultType(arg_planstate)
    })
}
pub unsafe fn ExecGetResultSlotOps(
    arg_planstate: *mut PlanState,
    arg_isfixed: *mut bool,
) -> *const TupleTableSlotOps {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetResultSlotOps(
                arg_planstate: *mut PlanState,
                arg_isfixed: *mut bool,
            ) -> *const TupleTableSlotOps;
        }
        ExecGetResultSlotOps(arg_planstate, arg_isfixed)
    })
}
pub unsafe fn ExecAssignProjectionInfo(arg_planstate: *mut PlanState, arg_inputDesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecAssignProjectionInfo(arg_planstate: *mut PlanState, arg_inputDesc: TupleDesc);
        }
        ExecAssignProjectionInfo(arg_planstate, arg_inputDesc)
    })
}
pub unsafe fn ExecConditionalAssignProjectionInfo(
    arg_planstate: *mut PlanState,
    arg_inputDesc: TupleDesc,
    arg_varno: Index,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecConditionalAssignProjectionInfo(
                arg_planstate: *mut PlanState,
                arg_inputDesc: TupleDesc,
                arg_varno: Index,
            );
        }
        ExecConditionalAssignProjectionInfo(arg_planstate, arg_inputDesc, arg_varno)
    })
}
pub unsafe fn ExecFreeExprContext(arg_planstate: *mut PlanState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecFreeExprContext(arg_planstate: *mut PlanState);
        }
        ExecFreeExprContext(arg_planstate)
    })
}
pub unsafe fn ExecAssignScanType(arg_scanstate: *mut ScanState, arg_tupDesc: TupleDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecAssignScanType(arg_scanstate: *mut ScanState, arg_tupDesc: TupleDesc);
        }
        ExecAssignScanType(arg_scanstate, arg_tupDesc)
    })
}
pub unsafe fn ExecCreateScanSlotFromOuterPlan(
    arg_estate: *mut EState,
    arg_scanstate: *mut ScanState,
    arg_tts_ops: *const TupleTableSlotOps,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecCreateScanSlotFromOuterPlan(
                arg_estate: *mut EState,
                arg_scanstate: *mut ScanState,
                arg_tts_ops: *const TupleTableSlotOps,
            );
        }
        ExecCreateScanSlotFromOuterPlan(arg_estate, arg_scanstate, arg_tts_ops)
    })
}
pub unsafe fn ExecRelationIsTargetRelation(arg_estate: *mut EState, arg_scanrelid: Index) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecRelationIsTargetRelation(arg_estate: *mut EState, arg_scanrelid: Index) -> bool;
        }
        ExecRelationIsTargetRelation(arg_estate, arg_scanrelid)
    })
}
pub unsafe fn ExecOpenScanRelation(
    arg_estate: *mut EState,
    arg_scanrelid: Index,
    arg_eflags: ::std::os::raw::c_int,
) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecOpenScanRelation(
                arg_estate: *mut EState,
                arg_scanrelid: Index,
                arg_eflags: ::std::os::raw::c_int,
            ) -> Relation;
        }
        ExecOpenScanRelation(arg_estate, arg_scanrelid, arg_eflags)
    })
}
pub unsafe fn ExecInitRangeTable(arg_estate: *mut EState, arg_rangeTable: *mut List) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInitRangeTable(arg_estate: *mut EState, arg_rangeTable: *mut List);
        }
        ExecInitRangeTable(arg_estate, arg_rangeTable)
    })
}
pub unsafe fn ExecGetRangeTableRelation(arg_estate: *mut EState, arg_rti: Index) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetRangeTableRelation(arg_estate: *mut EState, arg_rti: Index) -> Relation;
        }
        ExecGetRangeTableRelation(arg_estate, arg_rti)
    })
}
pub unsafe fn executor_errposition(
    arg_estate: *mut EState,
    arg_location: ::std::os::raw::c_int,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn executor_errposition(
                arg_estate: *mut EState,
                arg_location: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int;
        }
        executor_errposition(arg_estate, arg_location)
    })
}
pub unsafe fn RegisterExprContextCallback(
    arg_econtext: *mut ExprContext,
    arg_function: ExprContextCallbackFunction,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RegisterExprContextCallback(
                arg_econtext: *mut ExprContext,
                arg_function: ExprContextCallbackFunction,
                arg_arg: Datum,
            );
        }
        RegisterExprContextCallback(arg_econtext, arg_function, arg_arg)
    })
}
pub unsafe fn UnregisterExprContextCallback(
    arg_econtext: *mut ExprContext,
    arg_function: ExprContextCallbackFunction,
    arg_arg: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn UnregisterExprContextCallback(
                arg_econtext: *mut ExprContext,
                arg_function: ExprContextCallbackFunction,
                arg_arg: Datum,
            );
        }
        UnregisterExprContextCallback(arg_econtext, arg_function, arg_arg)
    })
}
pub unsafe fn GetAttributeByName(
    arg_tuple: HeapTupleHeader,
    arg_attname: *const ::std::os::raw::c_char,
    arg_isNull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetAttributeByName(
                arg_tuple: HeapTupleHeader,
                arg_attname: *const ::std::os::raw::c_char,
                arg_isNull: *mut bool,
            ) -> Datum;
        }
        GetAttributeByName(arg_tuple, arg_attname, arg_isNull)
    })
}
pub unsafe fn GetAttributeByNum(
    arg_tuple: HeapTupleHeader,
    arg_attrno: AttrNumber,
    arg_isNull: *mut bool,
) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetAttributeByNum(
                arg_tuple: HeapTupleHeader,
                arg_attrno: AttrNumber,
                arg_isNull: *mut bool,
            ) -> Datum;
        }
        GetAttributeByNum(arg_tuple, arg_attrno, arg_isNull)
    })
}
pub unsafe fn ExecTargetListLength(arg_targetlist: *mut List) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecTargetListLength(arg_targetlist: *mut List) -> ::std::os::raw::c_int;
        }
        ExecTargetListLength(arg_targetlist)
    })
}
pub unsafe fn ExecCleanTargetListLength(arg_targetlist: *mut List) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecCleanTargetListLength(arg_targetlist: *mut List) -> ::std::os::raw::c_int;
        }
        ExecCleanTargetListLength(arg_targetlist)
    })
}
pub unsafe fn ExecGetTriggerOldSlot(
    arg_estate: *mut EState,
    arg_relInfo: *mut ResultRelInfo,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetTriggerOldSlot(
                arg_estate: *mut EState,
                arg_relInfo: *mut ResultRelInfo,
            ) -> *mut TupleTableSlot;
        }
        ExecGetTriggerOldSlot(arg_estate, arg_relInfo)
    })
}
pub unsafe fn ExecGetTriggerNewSlot(
    arg_estate: *mut EState,
    arg_relInfo: *mut ResultRelInfo,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetTriggerNewSlot(
                arg_estate: *mut EState,
                arg_relInfo: *mut ResultRelInfo,
            ) -> *mut TupleTableSlot;
        }
        ExecGetTriggerNewSlot(arg_estate, arg_relInfo)
    })
}
pub unsafe fn ExecGetReturningSlot(
    arg_estate: *mut EState,
    arg_relInfo: *mut ResultRelInfo,
) -> *mut TupleTableSlot {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetReturningSlot(
                arg_estate: *mut EState,
                arg_relInfo: *mut ResultRelInfo,
            ) -> *mut TupleTableSlot;
        }
        ExecGetReturningSlot(arg_estate, arg_relInfo)
    })
}
pub unsafe fn ExecGetInsertedCols(
    arg_relinfo: *mut ResultRelInfo,
    arg_estate: *mut EState,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetInsertedCols(
                arg_relinfo: *mut ResultRelInfo,
                arg_estate: *mut EState,
            ) -> *mut Bitmapset;
        }
        ExecGetInsertedCols(arg_relinfo, arg_estate)
    })
}
pub unsafe fn ExecGetUpdatedCols(
    arg_relinfo: *mut ResultRelInfo,
    arg_estate: *mut EState,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetUpdatedCols(
                arg_relinfo: *mut ResultRelInfo,
                arg_estate: *mut EState,
            ) -> *mut Bitmapset;
        }
        ExecGetUpdatedCols(arg_relinfo, arg_estate)
    })
}
pub unsafe fn ExecGetExtraUpdatedCols(
    arg_relinfo: *mut ResultRelInfo,
    arg_estate: *mut EState,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetExtraUpdatedCols(
                arg_relinfo: *mut ResultRelInfo,
                arg_estate: *mut EState,
            ) -> *mut Bitmapset;
        }
        ExecGetExtraUpdatedCols(arg_relinfo, arg_estate)
    })
}
pub unsafe fn ExecGetAllUpdatedCols(
    arg_relinfo: *mut ResultRelInfo,
    arg_estate: *mut EState,
) -> *mut Bitmapset {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecGetAllUpdatedCols(
                arg_relinfo: *mut ResultRelInfo,
                arg_estate: *mut EState,
            ) -> *mut Bitmapset;
        }
        ExecGetAllUpdatedCols(arg_relinfo, arg_estate)
    })
}
pub unsafe fn ExecOpenIndices(arg_resultRelInfo: *mut ResultRelInfo, arg_speculative: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecOpenIndices(arg_resultRelInfo: *mut ResultRelInfo, arg_speculative: bool);
        }
        ExecOpenIndices(arg_resultRelInfo, arg_speculative)
    })
}
pub unsafe fn ExecCloseIndices(arg_resultRelInfo: *mut ResultRelInfo) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecCloseIndices(arg_resultRelInfo: *mut ResultRelInfo);
        }
        ExecCloseIndices(arg_resultRelInfo)
    })
}
pub unsafe fn ExecInsertIndexTuples(
    arg_slot: *mut TupleTableSlot,
    arg_estate: *mut EState,
    arg_noDupErr: bool,
    arg_specConflict: *mut bool,
    arg_arbiterIndexes: *mut List,
) -> *mut List {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecInsertIndexTuples(
                arg_slot: *mut TupleTableSlot,
                arg_estate: *mut EState,
                arg_noDupErr: bool,
                arg_specConflict: *mut bool,
                arg_arbiterIndexes: *mut List,
            ) -> *mut List;
        }
        ExecInsertIndexTuples(
            arg_slot,
            arg_estate,
            arg_noDupErr,
            arg_specConflict,
            arg_arbiterIndexes,
        )
    })
}
pub unsafe fn ExecCheckIndexConstraints(
    arg_slot: *mut TupleTableSlot,
    arg_estate: *mut EState,
    arg_conflictTid: ItemPointer,
    arg_arbiterIndexes: *mut List,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecCheckIndexConstraints(
                arg_slot: *mut TupleTableSlot,
                arg_estate: *mut EState,
                arg_conflictTid: ItemPointer,
                arg_arbiterIndexes: *mut List,
            ) -> bool;
        }
        ExecCheckIndexConstraints(arg_slot, arg_estate, arg_conflictTid, arg_arbiterIndexes)
    })
}
pub unsafe fn check_exclusion_constraint(
    arg_heap: Relation,
    arg_index: Relation,
    arg_indexInfo: *mut IndexInfo,
    arg_tupleid: ItemPointer,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
    arg_estate: *mut EState,
    arg_newIndex: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn check_exclusion_constraint(
                arg_heap: Relation,
                arg_index: Relation,
                arg_indexInfo: *mut IndexInfo,
                arg_tupleid: ItemPointer,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
                arg_estate: *mut EState,
                arg_newIndex: bool,
            );
        }
        check_exclusion_constraint(
            arg_heap,
            arg_index,
            arg_indexInfo,
            arg_tupleid,
            arg_values,
            arg_isnull,
            arg_estate,
            arg_newIndex,
        )
    })
}
pub unsafe fn RelationFindReplTupleByIndex(
    arg_rel: Relation,
    arg_idxoid: Oid,
    arg_lockmode: LockTupleMode,
    arg_searchslot: *mut TupleTableSlot,
    arg_outslot: *mut TupleTableSlot,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationFindReplTupleByIndex(
                arg_rel: Relation,
                arg_idxoid: Oid,
                arg_lockmode: LockTupleMode,
                arg_searchslot: *mut TupleTableSlot,
                arg_outslot: *mut TupleTableSlot,
            ) -> bool;
        }
        RelationFindReplTupleByIndex(arg_rel, arg_idxoid, arg_lockmode, arg_searchslot, arg_outslot)
    })
}
pub unsafe fn RelationFindReplTupleSeq(
    arg_rel: Relation,
    arg_lockmode: LockTupleMode,
    arg_searchslot: *mut TupleTableSlot,
    arg_outslot: *mut TupleTableSlot,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationFindReplTupleSeq(
                arg_rel: Relation,
                arg_lockmode: LockTupleMode,
                arg_searchslot: *mut TupleTableSlot,
                arg_outslot: *mut TupleTableSlot,
            ) -> bool;
        }
        RelationFindReplTupleSeq(arg_rel, arg_lockmode, arg_searchslot, arg_outslot)
    })
}
pub unsafe fn ExecSimpleRelationInsert(arg_estate: *mut EState, arg_slot: *mut TupleTableSlot) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSimpleRelationInsert(arg_estate: *mut EState, arg_slot: *mut TupleTableSlot);
        }
        ExecSimpleRelationInsert(arg_estate, arg_slot)
    })
}
pub unsafe fn ExecSimpleRelationUpdate(
    arg_estate: *mut EState,
    arg_epqstate: *mut EPQState,
    arg_searchslot: *mut TupleTableSlot,
    arg_slot: *mut TupleTableSlot,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSimpleRelationUpdate(
                arg_estate: *mut EState,
                arg_epqstate: *mut EPQState,
                arg_searchslot: *mut TupleTableSlot,
                arg_slot: *mut TupleTableSlot,
            );
        }
        ExecSimpleRelationUpdate(arg_estate, arg_epqstate, arg_searchslot, arg_slot)
    })
}
pub unsafe fn ExecSimpleRelationDelete(
    arg_estate: *mut EState,
    arg_epqstate: *mut EPQState,
    arg_searchslot: *mut TupleTableSlot,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExecSimpleRelationDelete(
                arg_estate: *mut EState,
                arg_epqstate: *mut EPQState,
                arg_searchslot: *mut TupleTableSlot,
            );
        }
        ExecSimpleRelationDelete(arg_estate, arg_epqstate, arg_searchslot)
    })
}
pub unsafe fn CheckCmdReplicaIdentity(arg_rel: Relation, arg_cmd: CmdType) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CheckCmdReplicaIdentity(arg_rel: Relation, arg_cmd: CmdType);
        }
        CheckCmdReplicaIdentity(arg_rel, arg_cmd)
    })
}
pub unsafe fn CheckSubscriptionRelkind(
    arg_relkind: ::std::os::raw::c_char,
    arg_nspname: *const ::std::os::raw::c_char,
    arg_relname: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CheckSubscriptionRelkind(
                arg_relkind: ::std::os::raw::c_char,
                arg_nspname: *const ::std::os::raw::c_char,
                arg_relname: *const ::std::os::raw::c_char,
            );
        }
        CheckSubscriptionRelkind(arg_relkind, arg_nspname, arg_relname)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttInMetadata {
    pub tupdesc: TupleDesc,
    pub attinfuncs: *mut FmgrInfo,
    pub attioparams: *mut Oid,
    pub atttypmods: *mut int32,
}
impl Default for AttInMetadata {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCallContext {
    pub call_cntr: uint64,
    pub max_calls: uint64,
    pub user_fctx: *mut ::std::os::raw::c_void,
    pub attinmeta: *mut AttInMetadata,
    pub multi_call_memory_ctx: MemoryContext,
    pub tuple_desc: TupleDesc,
}
impl Default for FuncCallContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TypeFuncClass_TYPEFUNC_SCALAR: TypeFuncClass = 0;
pub const TypeFuncClass_TYPEFUNC_COMPOSITE: TypeFuncClass = 1;
pub const TypeFuncClass_TYPEFUNC_COMPOSITE_DOMAIN: TypeFuncClass = 2;
pub const TypeFuncClass_TYPEFUNC_RECORD: TypeFuncClass = 3;
pub const TypeFuncClass_TYPEFUNC_OTHER: TypeFuncClass = 4;
pub type TypeFuncClass = ::std::os::raw::c_uint;
pub unsafe fn get_call_result_type(
    arg_fcinfo: FunctionCallInfo,
    arg_resultTypeId: *mut Oid,
    arg_resultTupleDesc: *mut TupleDesc,
) -> TypeFuncClass {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_call_result_type(
                arg_fcinfo: FunctionCallInfo,
                arg_resultTypeId: *mut Oid,
                arg_resultTupleDesc: *mut TupleDesc,
            ) -> TypeFuncClass;
        }
        get_call_result_type(arg_fcinfo, arg_resultTypeId, arg_resultTupleDesc)
    })
}
pub unsafe fn get_expr_result_type(
    arg_expr: *mut Node,
    arg_resultTypeId: *mut Oid,
    arg_resultTupleDesc: *mut TupleDesc,
) -> TypeFuncClass {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_expr_result_type(
                arg_expr: *mut Node,
                arg_resultTypeId: *mut Oid,
                arg_resultTupleDesc: *mut TupleDesc,
            ) -> TypeFuncClass;
        }
        get_expr_result_type(arg_expr, arg_resultTypeId, arg_resultTupleDesc)
    })
}
pub unsafe fn get_func_result_type(
    arg_functionId: Oid,
    arg_resultTypeId: *mut Oid,
    arg_resultTupleDesc: *mut TupleDesc,
) -> TypeFuncClass {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_func_result_type(
                arg_functionId: Oid,
                arg_resultTypeId: *mut Oid,
                arg_resultTupleDesc: *mut TupleDesc,
            ) -> TypeFuncClass;
        }
        get_func_result_type(arg_functionId, arg_resultTypeId, arg_resultTupleDesc)
    })
}
pub unsafe fn get_expr_result_tupdesc(arg_expr: *mut Node, arg_noError: bool) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_expr_result_tupdesc(arg_expr: *mut Node, arg_noError: bool) -> TupleDesc;
        }
        get_expr_result_tupdesc(arg_expr, arg_noError)
    })
}
pub unsafe fn resolve_polymorphic_argtypes(
    arg_numargs: ::std::os::raw::c_int,
    arg_argtypes: *mut Oid,
    arg_argmodes: *mut ::std::os::raw::c_char,
    arg_call_expr: *mut Node,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn resolve_polymorphic_argtypes(
                arg_numargs: ::std::os::raw::c_int,
                arg_argtypes: *mut Oid,
                arg_argmodes: *mut ::std::os::raw::c_char,
                arg_call_expr: *mut Node,
            ) -> bool;
        }
        resolve_polymorphic_argtypes(arg_numargs, arg_argtypes, arg_argmodes, arg_call_expr)
    })
}
pub unsafe fn get_func_arg_info(
    arg_procTup: HeapTuple,
    arg_p_argtypes: *mut *mut Oid,
    arg_p_argnames: *mut *mut *mut ::std::os::raw::c_char,
    arg_p_argmodes: *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_func_arg_info(
                arg_procTup: HeapTuple,
                arg_p_argtypes: *mut *mut Oid,
                arg_p_argnames: *mut *mut *mut ::std::os::raw::c_char,
                arg_p_argmodes: *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        get_func_arg_info(arg_procTup, arg_p_argtypes, arg_p_argnames, arg_p_argmodes)
    })
}
pub unsafe fn get_func_input_arg_names(
    arg_proargnames: Datum,
    arg_proargmodes: Datum,
    arg_arg_names: *mut *mut *mut ::std::os::raw::c_char,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_func_input_arg_names(
                arg_proargnames: Datum,
                arg_proargmodes: Datum,
                arg_arg_names: *mut *mut *mut ::std::os::raw::c_char,
            ) -> ::std::os::raw::c_int;
        }
        get_func_input_arg_names(arg_proargnames, arg_proargmodes, arg_arg_names)
    })
}
pub unsafe fn get_func_trftypes(
    arg_procTup: HeapTuple,
    arg_p_trftypes: *mut *mut Oid,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_func_trftypes(
                arg_procTup: HeapTuple,
                arg_p_trftypes: *mut *mut Oid,
            ) -> ::std::os::raw::c_int;
        }
        get_func_trftypes(arg_procTup, arg_p_trftypes)
    })
}
pub unsafe fn get_func_result_name(arg_functionId: Oid) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_func_result_name(arg_functionId: Oid) -> *mut ::std::os::raw::c_char;
        }
        get_func_result_name(arg_functionId)
    })
}
pub unsafe fn build_function_result_tupdesc_d(
    arg_prokind: ::std::os::raw::c_char,
    arg_proallargtypes: Datum,
    arg_proargmodes: Datum,
    arg_proargnames: Datum,
) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn build_function_result_tupdesc_d(
                arg_prokind: ::std::os::raw::c_char,
                arg_proallargtypes: Datum,
                arg_proargmodes: Datum,
                arg_proargnames: Datum,
            ) -> TupleDesc;
        }
        build_function_result_tupdesc_d(
            arg_prokind,
            arg_proallargtypes,
            arg_proargmodes,
            arg_proargnames,
        )
    })
}
pub unsafe fn build_function_result_tupdesc_t(arg_procTuple: HeapTuple) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn build_function_result_tupdesc_t(arg_procTuple: HeapTuple) -> TupleDesc;
        }
        build_function_result_tupdesc_t(arg_procTuple)
    })
}
pub unsafe fn RelationNameGetTupleDesc(arg_relname: *const ::std::os::raw::c_char) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationNameGetTupleDesc(arg_relname: *const ::std::os::raw::c_char) -> TupleDesc;
        }
        RelationNameGetTupleDesc(arg_relname)
    })
}
pub unsafe fn TypeGetTupleDesc(arg_typeoid: Oid, arg_colaliases: *mut List) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TypeGetTupleDesc(arg_typeoid: Oid, arg_colaliases: *mut List) -> TupleDesc;
        }
        TypeGetTupleDesc(arg_typeoid, arg_colaliases)
    })
}
pub unsafe fn BlessTupleDesc(arg_tupdesc: TupleDesc) -> TupleDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BlessTupleDesc(arg_tupdesc: TupleDesc) -> TupleDesc;
        }
        BlessTupleDesc(arg_tupdesc)
    })
}
pub unsafe fn TupleDescGetAttInMetadata(arg_tupdesc: TupleDesc) -> *mut AttInMetadata {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TupleDescGetAttInMetadata(arg_tupdesc: TupleDesc) -> *mut AttInMetadata;
        }
        TupleDescGetAttInMetadata(arg_tupdesc)
    })
}
pub unsafe fn BuildTupleFromCStrings(
    arg_attinmeta: *mut AttInMetadata,
    arg_values: *mut *mut ::std::os::raw::c_char,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildTupleFromCStrings(
                arg_attinmeta: *mut AttInMetadata,
                arg_values: *mut *mut ::std::os::raw::c_char,
            ) -> HeapTuple;
        }
        BuildTupleFromCStrings(arg_attinmeta, arg_values)
    })
}
pub unsafe fn HeapTupleHeaderGetDatum(arg_tuple: HeapTupleHeader) -> Datum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HeapTupleHeaderGetDatum(arg_tuple: HeapTupleHeader) -> Datum;
        }
        HeapTupleHeaderGetDatum(arg_tuple)
    })
}
pub unsafe fn init_MultiFuncCall(arg_fcinfo: FunctionCallInfo) -> *mut FuncCallContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn init_MultiFuncCall(arg_fcinfo: FunctionCallInfo) -> *mut FuncCallContext;
        }
        init_MultiFuncCall(arg_fcinfo)
    })
}
pub unsafe fn per_MultiFuncCall(arg_fcinfo: FunctionCallInfo) -> *mut FuncCallContext {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn per_MultiFuncCall(arg_fcinfo: FunctionCallInfo) -> *mut FuncCallContext;
        }
        per_MultiFuncCall(arg_fcinfo)
    })
}
pub unsafe fn end_MultiFuncCall(arg_fcinfo: FunctionCallInfo, arg_funcctx: *mut FuncCallContext) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn end_MultiFuncCall(arg_fcinfo: FunctionCallInfo, arg_funcctx: *mut FuncCallContext);
        }
        end_MultiFuncCall(arg_fcinfo, arg_funcctx)
    })
}
pub unsafe fn extract_variadic_args(
    arg_fcinfo: FunctionCallInfo,
    arg_variadic_start: ::std::os::raw::c_int,
    arg_convert_unknown: bool,
    arg_values: *mut *mut Datum,
    arg_types: *mut *mut Oid,
    arg_nulls: *mut *mut bool,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn extract_variadic_args(
                arg_fcinfo: FunctionCallInfo,
                arg_variadic_start: ::std::os::raw::c_int,
                arg_convert_unknown: bool,
                arg_values: *mut *mut Datum,
                arg_types: *mut *mut Oid,
                arg_nulls: *mut *mut bool,
            ) -> ::std::os::raw::c_int;
        }
        extract_variadic_args(
            arg_fcinfo,
            arg_variadic_start,
            arg_convert_unknown,
            arg_values,
            arg_types,
            arg_nulls,
        )
    })
}
pub type sig_atomic_t = __sig_atomic_t;
pub const SIGEV_SIGNAL: _bindgen_ty_17 = 0;
pub const SIGEV_NONE: _bindgen_ty_17 = 1;
pub const SIGEV_THREAD: _bindgen_ty_17 = 2;
pub const SIGEV_THREAD_ID: _bindgen_ty_17 = 4;
pub type _bindgen_ty_17 = ::std::os::raw::c_uint;
pub type pg_time_t = int64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
impl Default for pg_tm {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tz {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tzenum {
    _unused: [u8; 0],
}
pub unsafe fn pg_localtime(arg_timep: *const pg_time_t, arg_tz: *const pg_tz) -> *mut pg_tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_localtime(arg_timep: *const pg_time_t, arg_tz: *const pg_tz) -> *mut pg_tm;
        }
        pg_localtime(arg_timep, arg_tz)
    })
}
pub unsafe fn pg_gmtime(arg_timep: *const pg_time_t) -> *mut pg_tm {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_gmtime(arg_timep: *const pg_time_t) -> *mut pg_tm;
        }
        pg_gmtime(arg_timep)
    })
}
pub unsafe fn pg_next_dst_boundary(
    arg_timep: *const pg_time_t,
    arg_before_gmtoff: *mut ::std::os::raw::c_long,
    arg_before_isdst: *mut ::std::os::raw::c_int,
    arg_boundary: *mut pg_time_t,
    arg_after_gmtoff: *mut ::std::os::raw::c_long,
    arg_after_isdst: *mut ::std::os::raw::c_int,
    arg_tz: *const pg_tz,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_next_dst_boundary(
                arg_timep: *const pg_time_t,
                arg_before_gmtoff: *mut ::std::os::raw::c_long,
                arg_before_isdst: *mut ::std::os::raw::c_int,
                arg_boundary: *mut pg_time_t,
                arg_after_gmtoff: *mut ::std::os::raw::c_long,
                arg_after_isdst: *mut ::std::os::raw::c_int,
                arg_tz: *const pg_tz,
            ) -> ::std::os::raw::c_int;
        }
        pg_next_dst_boundary(
            arg_timep,
            arg_before_gmtoff,
            arg_before_isdst,
            arg_boundary,
            arg_after_gmtoff,
            arg_after_isdst,
            arg_tz,
        )
    })
}
pub unsafe fn pg_interpret_timezone_abbrev(
    arg_abbrev: *const ::std::os::raw::c_char,
    arg_timep: *const pg_time_t,
    arg_gmtoff: *mut ::std::os::raw::c_long,
    arg_isdst: *mut ::std::os::raw::c_int,
    arg_tz: *const pg_tz,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_interpret_timezone_abbrev(
                arg_abbrev: *const ::std::os::raw::c_char,
                arg_timep: *const pg_time_t,
                arg_gmtoff: *mut ::std::os::raw::c_long,
                arg_isdst: *mut ::std::os::raw::c_int,
                arg_tz: *const pg_tz,
            ) -> bool;
        }
        pg_interpret_timezone_abbrev(arg_abbrev, arg_timep, arg_gmtoff, arg_isdst, arg_tz)
    })
}
pub unsafe fn pg_get_timezone_offset(
    arg_tz: *const pg_tz,
    arg_gmtoff: *mut ::std::os::raw::c_long,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_get_timezone_offset(
                arg_tz: *const pg_tz,
                arg_gmtoff: *mut ::std::os::raw::c_long,
            ) -> bool;
        }
        pg_get_timezone_offset(arg_tz, arg_gmtoff)
    })
}
pub unsafe fn pg_get_timezone_name(arg_tz: *mut pg_tz) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_get_timezone_name(arg_tz: *mut pg_tz) -> *const ::std::os::raw::c_char;
        }
        pg_get_timezone_name(arg_tz)
    })
}
pub unsafe fn pg_tz_acceptable(arg_tz: *mut pg_tz) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tz_acceptable(arg_tz: *mut pg_tz) -> bool;
        }
        pg_tz_acceptable(arg_tz)
    })
}
pub unsafe fn pg_strftime(
    arg_s: *mut ::std::os::raw::c_char,
    arg_max: usize,
    arg_format: *const ::std::os::raw::c_char,
    arg_tm: *const pg_tm,
) -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_strftime(
                arg_s: *mut ::std::os::raw::c_char,
                arg_max: usize,
                arg_format: *const ::std::os::raw::c_char,
                arg_tm: *const pg_tm,
            ) -> usize;
        }
        pg_strftime(arg_s, arg_max, arg_format, arg_tm)
    })
}
extern "C" {
    pub static mut session_timezone: *mut pg_tz;
}
extern "C" {
    pub static mut log_timezone: *mut pg_tz;
}
pub unsafe fn pg_timezone_initialize() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_timezone_initialize();
        }
        pg_timezone_initialize()
    })
}
pub unsafe fn pg_tzset(arg_tzname: *const ::std::os::raw::c_char) -> *mut pg_tz {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tzset(arg_tzname: *const ::std::os::raw::c_char) -> *mut pg_tz;
        }
        pg_tzset(arg_tzname)
    })
}
pub unsafe fn pg_tzset_offset(arg_gmtoffset: ::std::os::raw::c_long) -> *mut pg_tz {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tzset_offset(arg_gmtoffset: ::std::os::raw::c_long) -> *mut pg_tz;
        }
        pg_tzset_offset(arg_gmtoffset)
    })
}
pub unsafe fn pg_tzenumerate_start() -> *mut pg_tzenum {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tzenumerate_start() -> *mut pg_tzenum;
        }
        pg_tzenumerate_start()
    })
}
pub unsafe fn pg_tzenumerate_next(arg_dir: *mut pg_tzenum) -> *mut pg_tz {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tzenumerate_next(arg_dir: *mut pg_tzenum) -> *mut pg_tz;
        }
        pg_tzenumerate_next(arg_dir)
    })
}
pub unsafe fn pg_tzenumerate_end(arg_dir: *mut pg_tzenum) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_tzenumerate_end(arg_dir: *mut pg_tzenum);
        }
        pg_tzenumerate_end(arg_dir)
    })
}
extern "C" {
    #[doc = "\t  System interrupt and critical section handling"]
    #[doc = ""]
    #[doc = " There are two types of interrupts that a running backend needs to accept"]
    #[doc = " without messing up its state: QueryCancel (SIGINT) and ProcDie (SIGTERM)."]
    #[doc = " In both cases, we need to be able to clean up the current transaction"]
    #[doc = " gracefully, so we can't respond to the interrupt instantaneously ---"]
    #[doc = " there's no guarantee that internal data structures would be self-consistent"]
    #[doc = " if the code is interrupted at an arbitrary instant.  Instead, the signal"]
    #[doc = " handlers set flags that are checked periodically during execution."]
    #[doc = ""]
    #[doc = " The CHECK_FOR_INTERRUPTS() macro is called at strategically located spots"]
    #[doc = " where it is normally safe to accept a cancel or die interrupt.  In some"]
    #[doc = " cases, we invoke CHECK_FOR_INTERRUPTS() inside low-level subroutines that"]
    #[doc = " might sometimes be called in contexts that do *not* want to allow a cancel"]
    #[doc = " or die interrupt.  The HOLD_INTERRUPTS() and RESUME_INTERRUPTS() macros"]
    #[doc = " allow code to ensure that no cancel or die interrupt will be accepted,"]
    #[doc = " even if CHECK_FOR_INTERRUPTS() gets called in a subroutine.  The interrupt"]
    #[doc = " will be held off until CHECK_FOR_INTERRUPTS() is done outside any"]
    #[doc = " HOLD_INTERRUPTS() ... RESUME_INTERRUPTS() section."]
    #[doc = ""]
    #[doc = " There is also a mechanism to prevent query cancel interrupts, while still"]
    #[doc = " allowing die interrupts: HOLD_CANCEL_INTERRUPTS() and"]
    #[doc = " RESUME_CANCEL_INTERRUPTS()."]
    #[doc = ""]
    #[doc = " Note that ProcessInterrupts() has also acquired a number of tasks that"]
    #[doc = " do not necessarily cause a query-cancel-or-die response.  Hence, it's"]
    #[doc = " possible that it will just clear InterruptPending and return."]
    #[doc = ""]
    #[doc = " INTERRUPTS_PENDING_CONDITION() can be checked to see whether an"]
    #[doc = " interrupt needs to be serviced, without trying to do so immediately."]
    #[doc = " Some callers are also interested in INTERRUPTS_CAN_BE_PROCESSED(),"]
    #[doc = " which tells whether ProcessInterrupts is sure to clear the interrupt."]
    #[doc = ""]
    #[doc = " Special mechanisms are used to let an interrupt be accepted when we are"]
    #[doc = " waiting for a lock or when we are waiting for command input (but, of"]
    #[doc = " course, only if the interrupt holdoff counter is zero).  See the"]
    #[doc = " related code for details."]
    #[doc = ""]
    #[doc = " A lost connection is handled similarly, although the loss of connection"]
    #[doc = " does not raise a signal, but is detected when we fail to write to the"]
    #[doc = " socket. If there was a signal for a broken connection, we could make use of"]
    #[doc = " it by setting ClientConnectionLost in the signal handler."]
    #[doc = ""]
    #[doc = " A related, but conceptually distinct, mechanism is the \"critical section\""]
    #[doc = " mechanism.  A critical section not only holds off cancel/die interrupts,"]
    #[doc = " but causes any ereport(ERROR) or ereport(FATAL) to become ereport(PANIC)"]
    #[doc = " --- that is, a system-wide reset is forced.  Needless to say, only really"]
    #[doc = " *critical* code should be marked as a critical section!\tCurrently, this"]
    #[doc = " mechanism is only used for XLOG-related code."]
    #[doc = ""]
    pub static mut InterruptPending: sig_atomic_t;
}
extern "C" {
    pub static mut QueryCancelPending: sig_atomic_t;
}
extern "C" {
    pub static mut ProcDiePending: sig_atomic_t;
}
extern "C" {
    pub static mut IdleInTransactionSessionTimeoutPending: sig_atomic_t;
}
extern "C" {
    pub static mut ProcSignalBarrierPending: sig_atomic_t;
}
extern "C" {
    pub static mut ClientConnectionLost: sig_atomic_t;
}
extern "C" {
    pub static mut InterruptHoldoffCount: uint32;
}
extern "C" {
    pub static mut QueryCancelHoldoffCount: uint32;
}
extern "C" {
    pub static mut CritSectionCount: uint32;
}
pub unsafe fn ProcessInterrupts() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcessInterrupts();
        }
        ProcessInterrupts()
    })
}
extern "C" {
    #[doc = "\t  globals.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *"]
    pub static mut PostmasterPid: pid_t;
}
extern "C" {
    pub static mut IsPostmasterEnvironment: bool;
}
extern "C" {
    pub static mut IsUnderPostmaster: bool;
}
extern "C" {
    pub static mut IsBackgroundWorker: bool;
}
extern "C" {
    pub static mut IsBinaryUpgrade: bool;
}
extern "C" {
    pub static mut ExitOnAnyError: bool;
}
extern "C" {
    pub static mut DataDir: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut data_directory_mode: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut NBuffers: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MaxBackends: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MaxConnections: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_worker_processes: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_parallel_workers: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MyProcPid: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MyStartTime: pg_time_t;
}
extern "C" {
    pub static mut MyStartTimestamp: TimestampTz;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Port {
    _unused: [u8; 0],
}
extern "C" {
    pub static mut MyProcPort: *mut Port;
}
extern "C" {
    pub static mut MyLatch: *mut Latch;
}
extern "C" {
    pub static mut MyCancelKey: int32;
}
extern "C" {
    pub static mut MyPMChildSlot: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut OutputFileName: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut my_exec_path: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut pkglib_path: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut MyDatabaseId: Oid;
}
extern "C" {
    pub static mut MyDatabaseTableSpace: Oid;
}
extern "C" {
    pub static mut DateStyle: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut DateOrder: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut IntervalStyle: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut enableFsync: bool;
}
extern "C" {
    pub static mut allowSystemTableMods: bool;
}
extern "C" {
    pub static mut work_mem: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut hash_mem_multiplier: f64;
}
extern "C" {
    pub static mut maintenance_work_mem: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_parallel_maintenance_workers: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostPageHit: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostPageMiss: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostPageDirty: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostLimit: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostDelay: f64;
}
extern "C" {
    pub static mut VacuumPageHit: int64;
}
extern "C" {
    pub static mut VacuumPageMiss: int64;
}
extern "C" {
    pub static mut VacuumPageDirty: int64;
}
extern "C" {
    pub static mut VacuumCostBalance: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostActive: bool;
}
extern "C" {
    pub static mut vacuum_cleanup_index_scale_factor: f64;
}
pub type pg_stack_base_t = *mut ::std::os::raw::c_char;
pub unsafe fn set_stack_base() -> pg_stack_base_t {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn set_stack_base() -> pg_stack_base_t;
        }
        set_stack_base()
    })
}
pub unsafe fn restore_stack_base(arg_base: pg_stack_base_t) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn restore_stack_base(arg_base: pg_stack_base_t);
        }
        restore_stack_base(arg_base)
    })
}
pub unsafe fn check_stack_depth() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn check_stack_depth();
        }
        check_stack_depth()
    })
}
pub unsafe fn stack_is_too_deep() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn stack_is_too_deep() -> bool;
        }
        stack_is_too_deep()
    })
}
pub unsafe fn PreventCommandIfReadOnly(arg_cmdname: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PreventCommandIfReadOnly(arg_cmdname: *const ::std::os::raw::c_char);
        }
        PreventCommandIfReadOnly(arg_cmdname)
    })
}
pub unsafe fn PreventCommandIfParallelMode(arg_cmdname: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PreventCommandIfParallelMode(arg_cmdname: *const ::std::os::raw::c_char);
        }
        PreventCommandIfParallelMode(arg_cmdname)
    })
}
pub unsafe fn PreventCommandDuringRecovery(arg_cmdname: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PreventCommandDuringRecovery(arg_cmdname: *const ::std::os::raw::c_char);
        }
        PreventCommandDuringRecovery(arg_cmdname)
    })
}
extern "C" {
    pub static mut trace_recovery_messages: ::std::os::raw::c_int;
}
pub unsafe fn trace_recovery(arg_trace_level: ::std::os::raw::c_int) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn trace_recovery(arg_trace_level: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
        }
        trace_recovery(arg_trace_level)
    })
}
extern "C" {
    pub static mut DatabasePath: *mut ::std::os::raw::c_char;
}
pub unsafe fn InitPostmasterChild() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitPostmasterChild();
        }
        InitPostmasterChild()
    })
}
pub unsafe fn InitStandaloneProcess(arg_argv0: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitStandaloneProcess(arg_argv0: *const ::std::os::raw::c_char);
        }
        InitStandaloneProcess(arg_argv0)
    })
}
pub unsafe fn SwitchToSharedLatch() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SwitchToSharedLatch();
        }
        SwitchToSharedLatch()
    })
}
pub unsafe fn SwitchBackToLocalLatch() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SwitchBackToLocalLatch();
        }
        SwitchBackToLocalLatch()
    })
}
pub const BackendType_B_INVALID: BackendType = 0;
pub const BackendType_B_AUTOVAC_LAUNCHER: BackendType = 1;
pub const BackendType_B_AUTOVAC_WORKER: BackendType = 2;
pub const BackendType_B_BACKEND: BackendType = 3;
pub const BackendType_B_BG_WORKER: BackendType = 4;
pub const BackendType_B_BG_WRITER: BackendType = 5;
pub const BackendType_B_CHECKPOINTER: BackendType = 6;
pub const BackendType_B_STARTUP: BackendType = 7;
pub const BackendType_B_WAL_RECEIVER: BackendType = 8;
pub const BackendType_B_WAL_SENDER: BackendType = 9;
pub const BackendType_B_WAL_WRITER: BackendType = 10;
pub const BackendType_B_ARCHIVER: BackendType = 11;
pub const BackendType_B_STATS_COLLECTOR: BackendType = 12;
pub const BackendType_B_LOGGER: BackendType = 13;
pub type BackendType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut MyBackendType: BackendType;
}
pub unsafe fn GetBackendTypeDesc(arg_backendType: BackendType) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetBackendTypeDesc(arg_backendType: BackendType) -> *const ::std::os::raw::c_char;
        }
        GetBackendTypeDesc(arg_backendType)
    })
}
pub unsafe fn SetDatabasePath(arg_path: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetDatabasePath(arg_path: *const ::std::os::raw::c_char);
        }
        SetDatabasePath(arg_path)
    })
}
pub unsafe fn checkDataDir() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn checkDataDir();
        }
        checkDataDir()
    })
}
pub unsafe fn SetDataDir(arg_dir: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetDataDir(arg_dir: *const ::std::os::raw::c_char);
        }
        SetDataDir(arg_dir)
    })
}
pub unsafe fn ChangeToDataDir() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ChangeToDataDir();
        }
        ChangeToDataDir()
    })
}
pub unsafe fn GetUserNameFromId(arg_roleid: Oid, arg_noerr: bool) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetUserNameFromId(arg_roleid: Oid, arg_noerr: bool) -> *mut ::std::os::raw::c_char;
        }
        GetUserNameFromId(arg_roleid, arg_noerr)
    })
}
pub unsafe fn GetUserId() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetUserId() -> Oid;
        }
        GetUserId()
    })
}
pub unsafe fn GetOuterUserId() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetOuterUserId() -> Oid;
        }
        GetOuterUserId()
    })
}
pub unsafe fn GetSessionUserId() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetSessionUserId() -> Oid;
        }
        GetSessionUserId()
    })
}
pub unsafe fn GetAuthenticatedUserId() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetAuthenticatedUserId() -> Oid;
        }
        GetAuthenticatedUserId()
    })
}
pub unsafe fn GetUserIdAndSecContext(
    arg_userid: *mut Oid,
    arg_sec_context: *mut ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetUserIdAndSecContext(
                arg_userid: *mut Oid,
                arg_sec_context: *mut ::std::os::raw::c_int,
            );
        }
        GetUserIdAndSecContext(arg_userid, arg_sec_context)
    })
}
pub unsafe fn SetUserIdAndSecContext(arg_userid: Oid, arg_sec_context: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetUserIdAndSecContext(arg_userid: Oid, arg_sec_context: ::std::os::raw::c_int);
        }
        SetUserIdAndSecContext(arg_userid, arg_sec_context)
    })
}
pub unsafe fn InLocalUserIdChange() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InLocalUserIdChange() -> bool;
        }
        InLocalUserIdChange()
    })
}
pub unsafe fn InSecurityRestrictedOperation() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InSecurityRestrictedOperation() -> bool;
        }
        InSecurityRestrictedOperation()
    })
}
pub unsafe fn InNoForceRLSOperation() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InNoForceRLSOperation() -> bool;
        }
        InNoForceRLSOperation()
    })
}
pub unsafe fn GetUserIdAndContext(arg_userid: *mut Oid, arg_sec_def_context: *mut bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetUserIdAndContext(arg_userid: *mut Oid, arg_sec_def_context: *mut bool);
        }
        GetUserIdAndContext(arg_userid, arg_sec_def_context)
    })
}
pub unsafe fn SetUserIdAndContext(arg_userid: Oid, arg_sec_def_context: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetUserIdAndContext(arg_userid: Oid, arg_sec_def_context: bool);
        }
        SetUserIdAndContext(arg_userid, arg_sec_def_context)
    })
}
pub unsafe fn InitializeSessionUserId(
    arg_rolename: *const ::std::os::raw::c_char,
    arg_useroid: Oid,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitializeSessionUserId(
                arg_rolename: *const ::std::os::raw::c_char,
                arg_useroid: Oid,
            );
        }
        InitializeSessionUserId(arg_rolename, arg_useroid)
    })
}
pub unsafe fn InitializeSessionUserIdStandalone() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitializeSessionUserIdStandalone();
        }
        InitializeSessionUserIdStandalone()
    })
}
pub unsafe fn SetSessionAuthorization(arg_userid: Oid, arg_is_superuser: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetSessionAuthorization(arg_userid: Oid, arg_is_superuser: bool);
        }
        SetSessionAuthorization(arg_userid, arg_is_superuser)
    })
}
pub unsafe fn GetCurrentRoleId() -> Oid {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetCurrentRoleId() -> Oid;
        }
        GetCurrentRoleId()
    })
}
pub unsafe fn SetCurrentRoleId(arg_roleid: Oid, arg_is_superuser: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetCurrentRoleId(arg_roleid: Oid, arg_is_superuser: bool);
        }
        SetCurrentRoleId(arg_roleid, arg_is_superuser)
    })
}
pub unsafe fn superuser() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn superuser() -> bool;
        }
        superuser()
    })
}
pub unsafe fn superuser_arg(arg_roleid: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn superuser_arg(arg_roleid: Oid) -> bool;
        }
        superuser_arg(arg_roleid)
    })
}
pub const ProcessingMode_BootstrapProcessing: ProcessingMode = 0;
pub const ProcessingMode_InitProcessing: ProcessingMode = 1;
pub const ProcessingMode_NormalProcessing: ProcessingMode = 2;
#[doc = "\t  pmod.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *"]
#[doc = "\t\t\tPOSTGRES processing mode definitions.                            *"]
pub type ProcessingMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut Mode: ProcessingMode;
}
pub const AuxProcType_NotAnAuxProcess: AuxProcType = -1;
pub const AuxProcType_CheckerProcess: AuxProcType = 0;
pub const AuxProcType_BootstrapProcess: AuxProcType = 1;
pub const AuxProcType_StartupProcess: AuxProcType = 2;
pub const AuxProcType_BgWriterProcess: AuxProcType = 3;
pub const AuxProcType_CheckpointerProcess: AuxProcType = 4;
pub const AuxProcType_WalWriterProcess: AuxProcType = 5;
pub const AuxProcType_WalReceiverProcess: AuxProcType = 6;
pub const AuxProcType_NUM_AUXPROCTYPES: AuxProcType = 7;
pub type AuxProcType = ::std::os::raw::c_int;
extern "C" {
    pub static mut MyAuxProcType: AuxProcType;
}
pub unsafe fn pg_split_opts(
    arg_argv: *mut *mut ::std::os::raw::c_char,
    arg_argcp: *mut ::std::os::raw::c_int,
    arg_optstr: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_split_opts(
                arg_argv: *mut *mut ::std::os::raw::c_char,
                arg_argcp: *mut ::std::os::raw::c_int,
                arg_optstr: *const ::std::os::raw::c_char,
            );
        }
        pg_split_opts(arg_argv, arg_argcp, arg_optstr)
    })
}
pub unsafe fn InitializeMaxBackends() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitializeMaxBackends();
        }
        InitializeMaxBackends()
    })
}
pub unsafe fn InitPostgres(
    arg_in_dbname: *const ::std::os::raw::c_char,
    arg_dboid: Oid,
    arg_username: *const ::std::os::raw::c_char,
    arg_useroid: Oid,
    arg_out_dbname: *mut ::std::os::raw::c_char,
    arg_override_allow_connections: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitPostgres(
                arg_in_dbname: *const ::std::os::raw::c_char,
                arg_dboid: Oid,
                arg_username: *const ::std::os::raw::c_char,
                arg_useroid: Oid,
                arg_out_dbname: *mut ::std::os::raw::c_char,
                arg_override_allow_connections: bool,
            );
        }
        InitPostgres(
            arg_in_dbname,
            arg_dboid,
            arg_username,
            arg_useroid,
            arg_out_dbname,
            arg_override_allow_connections,
        )
    })
}
pub unsafe fn BaseInit() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BaseInit();
        }
        BaseInit()
    })
}
extern "C" {
    pub static mut IgnoreSystemIndexes: bool;
}
extern "C" {
    pub static mut process_shared_preload_libraries_in_progress: bool;
}
extern "C" {
    pub static mut session_preload_libraries_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut shared_preload_libraries_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut local_preload_libraries_string: *mut ::std::os::raw::c_char;
}
pub unsafe fn CreateDataDirLockFile(arg_amPostmaster: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateDataDirLockFile(arg_amPostmaster: bool);
        }
        CreateDataDirLockFile(arg_amPostmaster)
    })
}
pub unsafe fn CreateSocketLockFile(
    arg_socketfile: *const ::std::os::raw::c_char,
    arg_amPostmaster: bool,
    arg_socketDir: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateSocketLockFile(
                arg_socketfile: *const ::std::os::raw::c_char,
                arg_amPostmaster: bool,
                arg_socketDir: *const ::std::os::raw::c_char,
            );
        }
        CreateSocketLockFile(arg_socketfile, arg_amPostmaster, arg_socketDir)
    })
}
pub unsafe fn TouchSocketLockFiles() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TouchSocketLockFiles();
        }
        TouchSocketLockFiles()
    })
}
pub unsafe fn AddToDataDirLockFile(
    arg_target_line: ::std::os::raw::c_int,
    arg_str_: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AddToDataDirLockFile(
                arg_target_line: ::std::os::raw::c_int,
                arg_str_: *const ::std::os::raw::c_char,
            );
        }
        AddToDataDirLockFile(arg_target_line, arg_str_)
    })
}
pub unsafe fn RecheckDataDirLockFile() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RecheckDataDirLockFile() -> bool;
        }
        RecheckDataDirLockFile()
    })
}
pub unsafe fn ValidatePgVersion(arg_path: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ValidatePgVersion(arg_path: *const ::std::os::raw::c_char);
        }
        ValidatePgVersion(arg_path)
    })
}
pub unsafe fn process_shared_preload_libraries() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn process_shared_preload_libraries();
        }
        process_shared_preload_libraries()
    })
}
pub unsafe fn process_session_preload_libraries() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn process_session_preload_libraries();
        }
        process_session_preload_libraries()
    })
}
pub unsafe fn pg_bindtextdomain(arg_domain: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_bindtextdomain(arg_domain: *const ::std::os::raw::c_char);
        }
        pg_bindtextdomain(arg_domain)
    })
}
pub unsafe fn has_rolreplication(arg_roleid: Oid) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn has_rolreplication(arg_roleid: Oid) -> bool;
        }
        has_rolreplication(arg_roleid)
    })
}
pub unsafe fn BackupInProgress() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BackupInProgress() -> bool;
        }
        BackupInProgress()
    })
}
pub unsafe fn CancelBackup() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CancelBackup();
        }
        CancelBackup()
    })
}
pub unsafe fn get_hash_memory_limit() -> usize {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_hash_memory_limit() -> usize;
        }
        get_hash_memory_limit()
    })
}
pub unsafe fn get_hash_mem() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn get_hash_mem() -> ::std::os::raw::c_int;
        }
        get_hash_mem()
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SockAddr {
    pub addr: sockaddr_storage,
    pub salen: socklen_t,
}
impl Default for SockAddr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ProtocolVersion = uint32;
pub type MsgType = ProtocolVersion;
pub type PacketLen = uint32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StartupPacket {
    pub protoVersion: ProtocolVersion,
    pub database: [::std::os::raw::c_char; 64usize],
    pub user: [::std::os::raw::c_char; 32usize],
    pub options: [::std::os::raw::c_char; 64usize],
    pub unused: [::std::os::raw::c_char; 64usize],
    pub tty: [::std::os::raw::c_char; 64usize],
}
impl Default for StartupPacket {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut Db_user_namespace: bool;
}
pub type AuthRequest = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CancelRequestPacket {
    pub cancelRequestCode: MsgType,
    pub backendPID: uint32,
    pub cancelAuthCode: uint32,
}
pub unsafe fn pgarch_start() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgarch_start() -> ::std::os::raw::c_int;
        }
        pgarch_start()
    })
}
pub type RmgrId = uint8;
pub const RmgrIds_RM_XLOG_ID: RmgrIds = 0;
pub const RmgrIds_RM_XACT_ID: RmgrIds = 1;
pub const RmgrIds_RM_SMGR_ID: RmgrIds = 2;
pub const RmgrIds_RM_CLOG_ID: RmgrIds = 3;
pub const RmgrIds_RM_DBASE_ID: RmgrIds = 4;
pub const RmgrIds_RM_TBLSPC_ID: RmgrIds = 5;
pub const RmgrIds_RM_MULTIXACT_ID: RmgrIds = 6;
pub const RmgrIds_RM_RELMAP_ID: RmgrIds = 7;
pub const RmgrIds_RM_STANDBY_ID: RmgrIds = 8;
pub const RmgrIds_RM_HEAP2_ID: RmgrIds = 9;
pub const RmgrIds_RM_HEAP_ID: RmgrIds = 10;
pub const RmgrIds_RM_BTREE_ID: RmgrIds = 11;
pub const RmgrIds_RM_HASH_ID: RmgrIds = 12;
pub const RmgrIds_RM_GIN_ID: RmgrIds = 13;
pub const RmgrIds_RM_GIST_ID: RmgrIds = 14;
pub const RmgrIds_RM_SEQ_ID: RmgrIds = 15;
pub const RmgrIds_RM_SPGIST_ID: RmgrIds = 16;
pub const RmgrIds_RM_BRIN_ID: RmgrIds = 17;
pub const RmgrIds_RM_COMMIT_TS_ID: RmgrIds = 18;
pub const RmgrIds_RM_REPLORIGIN_ID: RmgrIds = 19;
pub const RmgrIds_RM_GENERIC_ID: RmgrIds = 20;
pub const RmgrIds_RM_LOGICALMSG_ID: RmgrIds = 21;
pub const RmgrIds_RM_NEXT_ID: RmgrIds = 22;
pub type RmgrIds = ::std::os::raw::c_uint;
pub type pg_crc32c = uint32;
pub unsafe fn pg_comp_crc32c_sb8(
    arg_crc: pg_crc32c,
    arg_data: *const ::std::os::raw::c_void,
    arg_len: usize,
) -> pg_crc32c {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_comp_crc32c_sb8(
                arg_crc: pg_crc32c,
                arg_data: *const ::std::os::raw::c_void,
                arg_len: usize,
            ) -> pg_crc32c;
        }
        pg_comp_crc32c_sb8(arg_crc, arg_data, arg_len)
    })
}
extern "C" {
    pub static mut pg_comp_crc32c: ::std::option::Option<
        unsafe extern "C" fn(
            crc: pg_crc32c,
            data: *const ::std::os::raw::c_void,
            len: usize,
        ) -> pg_crc32c,
    >;
}
pub unsafe fn pg_comp_crc32c_sse42(
    arg_crc: pg_crc32c,
    arg_data: *const ::std::os::raw::c_void,
    arg_len: usize,
) -> pg_crc32c {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pg_comp_crc32c_sse42(
                arg_crc: pg_crc32c,
                arg_data: *const ::std::os::raw::c_void,
                arg_len: usize,
            ) -> pg_crc32c;
        }
        pg_comp_crc32c_sse42(arg_crc, arg_data, arg_len)
    })
}
pub const ForkNumber_InvalidForkNumber: ForkNumber = -1;
pub const ForkNumber_MAIN_FORKNUM: ForkNumber = 0;
pub const ForkNumber_FSM_FORKNUM: ForkNumber = 1;
pub const ForkNumber_VISIBILITYMAP_FORKNUM: ForkNumber = 2;
pub const ForkNumber_INIT_FORKNUM: ForkNumber = 3;
pub type ForkNumber = ::std::os::raw::c_int;
extern "C" {
    pub static mut forkNames: [*const ::std::os::raw::c_char; 0usize];
}
pub unsafe fn forkname_to_number(arg_forkName: *const ::std::os::raw::c_char) -> ForkNumber {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn forkname_to_number(arg_forkName: *const ::std::os::raw::c_char) -> ForkNumber;
        }
        forkname_to_number(arg_forkName)
    })
}
pub unsafe fn forkname_chars(
    arg_str_: *const ::std::os::raw::c_char,
    arg_fork: *mut ForkNumber,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn forkname_chars(
                arg_str_: *const ::std::os::raw::c_char,
                arg_fork: *mut ForkNumber,
            ) -> ::std::os::raw::c_int;
        }
        forkname_chars(arg_str_, arg_fork)
    })
}
pub unsafe fn GetDatabasePath(arg_dbNode: Oid, arg_spcNode: Oid) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetDatabasePath(arg_dbNode: Oid, arg_spcNode: Oid) -> *mut ::std::os::raw::c_char;
        }
        GetDatabasePath(arg_dbNode, arg_spcNode)
    })
}
pub unsafe fn GetRelationPath(
    arg_dbNode: Oid,
    arg_spcNode: Oid,
    arg_relNode: Oid,
    arg_backendId: ::std::os::raw::c_int,
    arg_forkNumber: ForkNumber,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetRelationPath(
                arg_dbNode: Oid,
                arg_spcNode: Oid,
                arg_relNode: Oid,
                arg_backendId: ::std::os::raw::c_int,
                arg_forkNumber: ForkNumber,
            ) -> *mut ::std::os::raw::c_char;
        }
        GetRelationPath(arg_dbNode, arg_spcNode, arg_relNode, arg_backendId, arg_forkNumber)
    })
}
pub type BackendId = ::std::os::raw::c_int;
extern "C" {
    pub static mut MyBackendId: BackendId;
}
extern "C" {
    pub static mut ParallelMasterBackendId: BackendId;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct RelFileNode {
    pub spcNode: Oid,
    pub dbNode: Oid,
    pub relNode: Oid,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct RelFileNodeBackend {
    pub node: RelFileNode,
    pub backend: BackendId,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecord {
    pub xl_tot_len: uint32,
    pub xl_xid: TransactionId,
    pub xl_prev: XLogRecPtr,
    pub xl_info: uint8,
    pub xl_rmid: RmgrId,
    pub xl_crc: pg_crc32c,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockHeader {
    pub id: uint8,
    pub fork_flags: uint8,
    pub data_length: uint16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockImageHeader {
    pub length: uint16,
    pub hole_offset: uint16,
    pub bimg_info: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockCompressHeader {
    pub hole_length: uint16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordDataHeaderShort {
    pub id: uint8,
    pub data_length: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordDataHeaderLong {
    pub id: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WALOpenSegment {
    pub ws_file: ::std::os::raw::c_int,
    pub ws_segno: XLogSegNo,
    pub ws_tli: TimeLineID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WALSegmentContext {
    pub ws_dir: [::std::os::raw::c_char; 1024usize],
    pub ws_segsize: ::std::os::raw::c_int,
}
impl Default for WALSegmentContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type XLogPageReadCB = ::std::option::Option<
    unsafe extern "C" fn(
        xlogreader: *mut XLogReaderState,
        targetPagePtr: XLogRecPtr,
        reqLen: ::std::os::raw::c_int,
        targetRecPtr: XLogRecPtr,
        readBuf: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type WALSegmentOpenCB = ::std::option::Option<
    unsafe extern "C" fn(
        xlogreader: *mut XLogReaderState,
        nextSegNo: XLogSegNo,
        tli_p: *mut TimeLineID,
    ),
>;
pub type WALSegmentCloseCB =
    ::std::option::Option<unsafe extern "C" fn(xlogreader: *mut XLogReaderState)>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogReaderRoutine {
    pub page_read: XLogPageReadCB,
    pub segment_open: WALSegmentOpenCB,
    pub segment_close: WALSegmentCloseCB,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DecodedBkpBlock {
    pub in_use: bool,
    pub rnode: RelFileNode,
    pub forknum: ForkNumber,
    pub blkno: BlockNumber,
    pub flags: uint8,
    pub has_image: bool,
    pub apply_image: bool,
    pub bkp_image: *mut ::std::os::raw::c_char,
    pub hole_offset: uint16,
    pub hole_length: uint16,
    pub bimg_len: uint16,
    pub bimg_info: uint8,
    pub has_data: bool,
    pub data: *mut ::std::os::raw::c_char,
    pub data_len: uint16,
    pub data_bufsz: uint16,
}
impl Default for DecodedBkpBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogReaderState {
    pub routine: XLogReaderRoutine,
    pub system_identifier: uint64,
    pub private_data: *mut ::std::os::raw::c_void,
    pub ReadRecPtr: XLogRecPtr,
    pub EndRecPtr: XLogRecPtr,
    pub decoded_record: *mut XLogRecord,
    pub main_data: *mut ::std::os::raw::c_char,
    pub main_data_len: uint32,
    pub main_data_bufsz: uint32,
    pub record_origin: RepOriginId,
    pub blocks: [DecodedBkpBlock; 33usize],
    pub max_block_id: ::std::os::raw::c_int,
    pub readBuf: *mut ::std::os::raw::c_char,
    pub readLen: uint32,
    pub segcxt: WALSegmentContext,
    pub seg: WALOpenSegment,
    pub segoff: uint32,
    pub latestPagePtr: XLogRecPtr,
    pub latestPageTLI: TimeLineID,
    pub currRecPtr: XLogRecPtr,
    pub currTLI: TimeLineID,
    pub currTLIValidUntil: XLogRecPtr,
    pub nextTLI: TimeLineID,
    pub readRecordBuf: *mut ::std::os::raw::c_char,
    pub readRecordBufSize: uint32,
    pub errormsg_buf: *mut ::std::os::raw::c_char,
    pub abortedRecPtr: XLogRecPtr,
    pub missingContrecPtr: XLogRecPtr,
    pub overwrittenRecPtr: XLogRecPtr,
}
impl Default for XLogReaderState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn XLogReaderAllocate(
    arg_wal_segment_size: ::std::os::raw::c_int,
    arg_waldir: *const ::std::os::raw::c_char,
    arg_routine: *mut XLogReaderRoutine,
    arg_private_data: *mut ::std::os::raw::c_void,
) -> *mut XLogReaderState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn XLogReaderAllocate(
                arg_wal_segment_size: ::std::os::raw::c_int,
                arg_waldir: *const ::std::os::raw::c_char,
                arg_routine: *mut XLogReaderRoutine,
                arg_private_data: *mut ::std::os::raw::c_void,
            ) -> *mut XLogReaderState;
        }
        XLogReaderAllocate(arg_wal_segment_size, arg_waldir, arg_routine, arg_private_data)
    })
}
pub unsafe fn LocalXLogReaderRoutine() -> *mut XLogReaderRoutine {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LocalXLogReaderRoutine() -> *mut XLogReaderRoutine;
        }
        LocalXLogReaderRoutine()
    })
}
pub unsafe fn XLogReaderFree(arg_state: *mut XLogReaderState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn XLogReaderFree(arg_state: *mut XLogReaderState);
        }
        XLogReaderFree(arg_state)
    })
}
pub unsafe fn XLogBeginRead(arg_state: *mut XLogReaderState, arg_RecPtr: XLogRecPtr) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn XLogBeginRead(arg_state: *mut XLogReaderState, arg_RecPtr: XLogRecPtr);
        }
        XLogBeginRead(arg_state, arg_RecPtr)
    })
}
pub unsafe fn XLogReadRecord(
    arg_state: *mut XLogReaderState,
    arg_errormsg: *mut *mut ::std::os::raw::c_char,
) -> *mut XLogRecord {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn XLogReadRecord(
                arg_state: *mut XLogReaderState,
                arg_errormsg: *mut *mut ::std::os::raw::c_char,
            ) -> *mut XLogRecord;
        }
        XLogReadRecord(arg_state, arg_errormsg)
    })
}
pub unsafe fn XLogReaderValidatePageHeader(
    arg_state: *mut XLogReaderState,
    arg_recptr: XLogRecPtr,
    arg_phdr: *mut ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn XLogReaderValidatePageHeader(
                arg_state: *mut XLogReaderState,
                arg_recptr: XLogRecPtr,
                arg_phdr: *mut ::std::os::raw::c_char,
            ) -> bool;
        }
        XLogReaderValidatePageHeader(arg_state, arg_recptr, arg_phdr)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WALReadError {
    pub wre_errno: ::std::os::raw::c_int,
    pub wre_off: ::std::os::raw::c_int,
    pub wre_req: ::std::os::raw::c_int,
    pub wre_read: ::std::os::raw::c_int,
    pub wre_seg: WALOpenSegment,
}
pub unsafe fn WALRead(
    arg_state: *mut XLogReaderState,
    arg_buf: *mut ::std::os::raw::c_char,
    arg_startptr: XLogRecPtr,
    arg_count: Size,
    arg_tli: TimeLineID,
    arg_errinfo: *mut WALReadError,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn WALRead(
                arg_state: *mut XLogReaderState,
                arg_buf: *mut ::std::os::raw::c_char,
                arg_startptr: XLogRecPtr,
                arg_count: Size,
                arg_tli: TimeLineID,
                arg_errinfo: *mut WALReadError,
            ) -> bool;
        }
        WALRead(arg_state, arg_buf, arg_startptr, arg_count, arg_tli, arg_errinfo)
    })
}
pub unsafe fn DecodeXLogRecord(
    arg_state: *mut XLogReaderState,
    arg_record: *mut XLogRecord,
    arg_errmsg: *mut *mut ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DecodeXLogRecord(
                arg_state: *mut XLogReaderState,
                arg_record: *mut XLogRecord,
                arg_errmsg: *mut *mut ::std::os::raw::c_char,
            ) -> bool;
        }
        DecodeXLogRecord(arg_state, arg_record, arg_errmsg)
    })
}
pub unsafe fn XLogRecGetFullXid(arg_record: *mut XLogReaderState) -> FullTransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn XLogRecGetFullXid(arg_record: *mut XLogReaderState) -> FullTransactionId;
        }
        XLogRecGetFullXid(arg_record)
    })
}
pub unsafe fn RestoreBlockImage(
    arg_record: *mut XLogReaderState,
    arg_block_id: uint8,
    arg_page: *mut ::std::os::raw::c_char,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RestoreBlockImage(
                arg_record: *mut XLogReaderState,
                arg_block_id: uint8,
                arg_page: *mut ::std::os::raw::c_char,
            ) -> bool;
        }
        RestoreBlockImage(arg_record, arg_block_id, arg_page)
    })
}
pub unsafe fn XLogRecGetBlockData(
    arg_record: *mut XLogReaderState,
    arg_block_id: uint8,
    arg_len: *mut Size,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn XLogRecGetBlockData(
                arg_record: *mut XLogReaderState,
                arg_block_id: uint8,
                arg_len: *mut Size,
            ) -> *mut ::std::os::raw::c_char;
        }
        XLogRecGetBlockData(arg_record, arg_block_id, arg_len)
    })
}
pub unsafe fn XLogRecGetBlockTag(
    arg_record: *mut XLogReaderState,
    arg_block_id: uint8,
    arg_rnode: *mut RelFileNode,
    arg_forknum: *mut ForkNumber,
    arg_blknum: *mut BlockNumber,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn XLogRecGetBlockTag(
                arg_record: *mut XLogReaderState,
                arg_block_id: uint8,
                arg_rnode: *mut RelFileNode,
                arg_forknum: *mut ForkNumber,
                arg_blknum: *mut BlockNumber,
            ) -> bool;
        }
        XLogRecGetBlockTag(arg_record, arg_block_id, arg_rnode, arg_forknum, arg_blknum)
    })
}
pub type XidStatus = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_clog_truncate {
    pub pageno: ::std::os::raw::c_int,
    pub oldestXact: TransactionId,
    pub oldestXactDb: Oid,
}
pub unsafe fn TransactionIdSetTreeStatus(
    arg_xid: TransactionId,
    arg_nsubxids: ::std::os::raw::c_int,
    arg_subxids: *mut TransactionId,
    arg_status: XidStatus,
    arg_lsn: XLogRecPtr,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdSetTreeStatus(
                arg_xid: TransactionId,
                arg_nsubxids: ::std::os::raw::c_int,
                arg_subxids: *mut TransactionId,
                arg_status: XidStatus,
                arg_lsn: XLogRecPtr,
            );
        }
        TransactionIdSetTreeStatus(arg_xid, arg_nsubxids, arg_subxids, arg_status, arg_lsn)
    })
}
pub unsafe fn TransactionIdGetStatus(
    arg_xid: TransactionId,
    arg_lsn: *mut XLogRecPtr,
) -> XidStatus {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TransactionIdGetStatus(
                arg_xid: TransactionId,
                arg_lsn: *mut XLogRecPtr,
            ) -> XidStatus;
        }
        TransactionIdGetStatus(arg_xid, arg_lsn)
    })
}
pub unsafe fn CLOGShmemBuffers() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CLOGShmemBuffers() -> Size;
        }
        CLOGShmemBuffers()
    })
}
pub unsafe fn CLOGShmemSize() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CLOGShmemSize() -> Size;
        }
        CLOGShmemSize()
    })
}
pub unsafe fn CLOGShmemInit() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CLOGShmemInit();
        }
        CLOGShmemInit()
    })
}
pub unsafe fn BootStrapCLOG() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BootStrapCLOG();
        }
        BootStrapCLOG()
    })
}
pub unsafe fn StartupCLOG() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn StartupCLOG();
        }
        StartupCLOG()
    })
}
pub unsafe fn TrimCLOG() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TrimCLOG();
        }
        TrimCLOG()
    })
}
pub unsafe fn ShutdownCLOG() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ShutdownCLOG();
        }
        ShutdownCLOG()
    })
}
pub unsafe fn CheckPointCLOG() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CheckPointCLOG();
        }
        CheckPointCLOG()
    })
}
pub unsafe fn ExtendCLOG(arg_newestXact: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ExtendCLOG(arg_newestXact: TransactionId);
        }
        ExtendCLOG(arg_newestXact)
    })
}
pub unsafe fn TruncateCLOG(arg_oldestXact: TransactionId, arg_oldestxid_datoid: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn TruncateCLOG(arg_oldestXact: TransactionId, arg_oldestxid_datoid: Oid);
        }
        TruncateCLOG(arg_oldestXact, arg_oldestxid_datoid)
    })
}
pub unsafe fn clog_redo(arg_record: *mut XLogReaderState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clog_redo(arg_record: *mut XLogReaderState);
        }
        clog_redo(arg_record)
    })
}
pub unsafe fn clog_desc(arg_buf: StringInfo, arg_record: *mut XLogReaderState) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clog_desc(arg_buf: StringInfo, arg_record: *mut XLogReaderState);
        }
        clog_desc(arg_buf, arg_record)
    })
}
pub unsafe fn clog_identify(arg_info: uint8) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn clog_identify(arg_info: uint8) -> *const ::std::os::raw::c_char;
        }
        clog_identify(arg_info)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_node {
    pub prev: *mut dlist_node,
    pub next: *mut dlist_node,
}
impl Default for dlist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_head {
    pub head: dlist_node,
}
impl Default for dlist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_iter {
    pub cur: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_mutable_iter {
    pub cur: *mut dlist_node,
    pub next: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_mutable_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_node {
    pub next: *mut slist_node,
}
impl Default for slist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_head {
    pub head: slist_node,
}
impl Default for slist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_iter {
    pub cur: *mut slist_node,
}
impl Default for slist_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_mutable_iter {
    pub cur: *mut slist_node,
    pub next: *mut slist_node,
    pub prev: *mut slist_node,
}
impl Default for slist_mutable_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn slist_delete(arg_head: *mut slist_head, arg_node: *mut slist_node) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn slist_delete(arg_head: *mut slist_head, arg_node: *mut slist_node);
        }
        slist_delete(arg_head, arg_node)
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Latch {
    pub is_set: sig_atomic_t,
    pub is_shared: bool,
    pub owner_pid: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WaitEvent {
    pub pos: ::std::os::raw::c_int,
    pub events: uint32,
    pub fd: pgsocket,
    pub user_data: *mut ::std::os::raw::c_void,
}
impl Default for WaitEvent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WaitEventSet {
    _unused: [u8; 0],
}
pub unsafe fn InitializeLatchSupport() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitializeLatchSupport();
        }
        InitializeLatchSupport()
    })
}
pub unsafe fn InitLatch(arg_latch: *mut Latch) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitLatch(arg_latch: *mut Latch);
        }
        InitLatch(arg_latch)
    })
}
pub unsafe fn InitSharedLatch(arg_latch: *mut Latch) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitSharedLatch(arg_latch: *mut Latch);
        }
        InitSharedLatch(arg_latch)
    })
}
pub unsafe fn OwnLatch(arg_latch: *mut Latch) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn OwnLatch(arg_latch: *mut Latch);
        }
        OwnLatch(arg_latch)
    })
}
pub unsafe fn DisownLatch(arg_latch: *mut Latch) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DisownLatch(arg_latch: *mut Latch);
        }
        DisownLatch(arg_latch)
    })
}
pub unsafe fn SetLatch(arg_latch: *mut Latch) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetLatch(arg_latch: *mut Latch);
        }
        SetLatch(arg_latch)
    })
}
pub unsafe fn ResetLatch(arg_latch: *mut Latch) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ResetLatch(arg_latch: *mut Latch);
        }
        ResetLatch(arg_latch)
    })
}
pub unsafe fn CreateWaitEventSet(
    arg_context: MemoryContext,
    arg_nevents: ::std::os::raw::c_int,
) -> *mut WaitEventSet {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateWaitEventSet(
                arg_context: MemoryContext,
                arg_nevents: ::std::os::raw::c_int,
            ) -> *mut WaitEventSet;
        }
        CreateWaitEventSet(arg_context, arg_nevents)
    })
}
pub unsafe fn FreeWaitEventSet(arg_set: *mut WaitEventSet) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn FreeWaitEventSet(arg_set: *mut WaitEventSet);
        }
        FreeWaitEventSet(arg_set)
    })
}
pub unsafe fn AddWaitEventToSet(
    arg_set: *mut WaitEventSet,
    arg_events: uint32,
    arg_fd: pgsocket,
    arg_latch: *mut Latch,
    arg_user_data: *mut ::std::os::raw::c_void,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AddWaitEventToSet(
                arg_set: *mut WaitEventSet,
                arg_events: uint32,
                arg_fd: pgsocket,
                arg_latch: *mut Latch,
                arg_user_data: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int;
        }
        AddWaitEventToSet(arg_set, arg_events, arg_fd, arg_latch, arg_user_data)
    })
}
pub unsafe fn ModifyWaitEvent(
    arg_set: *mut WaitEventSet,
    arg_pos: ::std::os::raw::c_int,
    arg_events: uint32,
    arg_latch: *mut Latch,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ModifyWaitEvent(
                arg_set: *mut WaitEventSet,
                arg_pos: ::std::os::raw::c_int,
                arg_events: uint32,
                arg_latch: *mut Latch,
            );
        }
        ModifyWaitEvent(arg_set, arg_pos, arg_events, arg_latch)
    })
}
pub unsafe fn WaitEventSetWait(
    arg_set: *mut WaitEventSet,
    arg_timeout: ::std::os::raw::c_long,
    arg_occurred_events: *mut WaitEvent,
    arg_nevents: ::std::os::raw::c_int,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn WaitEventSetWait(
                arg_set: *mut WaitEventSet,
                arg_timeout: ::std::os::raw::c_long,
                arg_occurred_events: *mut WaitEvent,
                arg_nevents: ::std::os::raw::c_int,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        WaitEventSetWait(
            arg_set,
            arg_timeout,
            arg_occurred_events,
            arg_nevents,
            arg_wait_event_info,
        )
    })
}
pub unsafe fn WaitLatch(
    arg_latch: *mut Latch,
    arg_wakeEvents: ::std::os::raw::c_int,
    arg_timeout: ::std::os::raw::c_long,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn WaitLatch(
                arg_latch: *mut Latch,
                arg_wakeEvents: ::std::os::raw::c_int,
                arg_timeout: ::std::os::raw::c_long,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        WaitLatch(arg_latch, arg_wakeEvents, arg_timeout, arg_wait_event_info)
    })
}
pub unsafe fn WaitLatchOrSocket(
    arg_latch: *mut Latch,
    arg_wakeEvents: ::std::os::raw::c_int,
    arg_sock: pgsocket,
    arg_timeout: ::std::os::raw::c_long,
    arg_wait_event_info: uint32,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn WaitLatchOrSocket(
                arg_latch: *mut Latch,
                arg_wakeEvents: ::std::os::raw::c_int,
                arg_sock: pgsocket,
                arg_timeout: ::std::os::raw::c_long,
                arg_wait_event_info: uint32,
            ) -> ::std::os::raw::c_int;
        }
        WaitLatchOrSocket(arg_latch, arg_wakeEvents, arg_sock, arg_timeout, arg_wait_event_info)
    })
}
pub unsafe fn latch_sigusr1_handler() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn latch_sigusr1_handler();
        }
        latch_sigusr1_handler()
    })
}
pub type LOCKMASK = ::std::os::raw::c_int;
pub type LOCKMODE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_standby_lock {
    pub xid: TransactionId,
    pub dbOid: Oid,
    pub relOid: Oid,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LWLock {
    pub tranche: uint16,
    pub state: pg_atomic_uint32,
    pub waiters: proclist_head,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union LWLockPadded {
    pub lock: LWLock,
    pub pad: [::std::os::raw::c_char; 128usize],
}
impl Default for LWLockPadded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union LWLockMinimallyPadded {
    pub lock: LWLock,
    pub pad: [::std::os::raw::c_char; 32usize],
}
impl Default for LWLockMinimallyPadded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut MainLWLockArray: *mut LWLockPadded;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedLWLockTranche {
    pub trancheId: ::std::os::raw::c_int,
    pub trancheName: *mut ::std::os::raw::c_char,
}
impl Default for NamedLWLockTranche {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut NamedLWLockTrancheArray: *mut NamedLWLockTranche;
}
extern "C" {
    pub static mut NamedLWLockTrancheRequests: ::std::os::raw::c_int;
}
pub const LWLockMode_LW_EXCLUSIVE: LWLockMode = 0;
pub const LWLockMode_LW_SHARED: LWLockMode = 1;
pub const LWLockMode_LW_WAIT_UNTIL_FREE: LWLockMode = 2;
pub type LWLockMode = ::std::os::raw::c_uint;
pub unsafe fn LWLockAcquire(arg_lock: *mut LWLock, arg_mode: LWLockMode) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockAcquire(arg_lock: *mut LWLock, arg_mode: LWLockMode) -> bool;
        }
        LWLockAcquire(arg_lock, arg_mode)
    })
}
pub unsafe fn LWLockConditionalAcquire(arg_lock: *mut LWLock, arg_mode: LWLockMode) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockConditionalAcquire(arg_lock: *mut LWLock, arg_mode: LWLockMode) -> bool;
        }
        LWLockConditionalAcquire(arg_lock, arg_mode)
    })
}
pub unsafe fn LWLockAcquireOrWait(arg_lock: *mut LWLock, arg_mode: LWLockMode) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockAcquireOrWait(arg_lock: *mut LWLock, arg_mode: LWLockMode) -> bool;
        }
        LWLockAcquireOrWait(arg_lock, arg_mode)
    })
}
pub unsafe fn LWLockRelease(arg_lock: *mut LWLock) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockRelease(arg_lock: *mut LWLock);
        }
        LWLockRelease(arg_lock)
    })
}
pub unsafe fn LWLockReleaseClearVar(
    arg_lock: *mut LWLock,
    arg_valptr: *mut uint64,
    arg_val: uint64,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockReleaseClearVar(
                arg_lock: *mut LWLock,
                arg_valptr: *mut uint64,
                arg_val: uint64,
            );
        }
        LWLockReleaseClearVar(arg_lock, arg_valptr, arg_val)
    })
}
pub unsafe fn LWLockReleaseAll() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockReleaseAll();
        }
        LWLockReleaseAll()
    })
}
pub unsafe fn LWLockHeldByMe(arg_lock: *mut LWLock) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockHeldByMe(arg_lock: *mut LWLock) -> bool;
        }
        LWLockHeldByMe(arg_lock)
    })
}
pub unsafe fn LWLockAnyHeldByMe(
    arg_lock: *mut LWLock,
    arg_nlocks: ::std::os::raw::c_int,
    arg_stride: usize,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockAnyHeldByMe(
                arg_lock: *mut LWLock,
                arg_nlocks: ::std::os::raw::c_int,
                arg_stride: usize,
            ) -> bool;
        }
        LWLockAnyHeldByMe(arg_lock, arg_nlocks, arg_stride)
    })
}
pub unsafe fn LWLockHeldByMeInMode(arg_lock: *mut LWLock, arg_mode: LWLockMode) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockHeldByMeInMode(arg_lock: *mut LWLock, arg_mode: LWLockMode) -> bool;
        }
        LWLockHeldByMeInMode(arg_lock, arg_mode)
    })
}
pub unsafe fn LWLockWaitForVar(
    arg_lock: *mut LWLock,
    arg_valptr: *mut uint64,
    arg_oldval: uint64,
    arg_newval: *mut uint64,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockWaitForVar(
                arg_lock: *mut LWLock,
                arg_valptr: *mut uint64,
                arg_oldval: uint64,
                arg_newval: *mut uint64,
            ) -> bool;
        }
        LWLockWaitForVar(arg_lock, arg_valptr, arg_oldval, arg_newval)
    })
}
pub unsafe fn LWLockUpdateVar(arg_lock: *mut LWLock, arg_valptr: *mut uint64, arg_value: uint64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockUpdateVar(arg_lock: *mut LWLock, arg_valptr: *mut uint64, arg_value: uint64);
        }
        LWLockUpdateVar(arg_lock, arg_valptr, arg_value)
    })
}
pub unsafe fn LWLockShmemSize() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockShmemSize() -> Size;
        }
        LWLockShmemSize()
    })
}
pub unsafe fn CreateLWLocks() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateLWLocks();
        }
        CreateLWLocks()
    })
}
pub unsafe fn InitLWLockAccess() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitLWLockAccess();
        }
        InitLWLockAccess()
    })
}
pub unsafe fn GetLWLockIdentifier(
    arg_classId: uint32,
    arg_eventId: uint16,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetLWLockIdentifier(
                arg_classId: uint32,
                arg_eventId: uint16,
            ) -> *const ::std::os::raw::c_char;
        }
        GetLWLockIdentifier(arg_classId, arg_eventId)
    })
}
pub unsafe fn RequestNamedLWLockTranche(
    arg_tranche_name: *const ::std::os::raw::c_char,
    arg_num_lwlocks: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RequestNamedLWLockTranche(
                arg_tranche_name: *const ::std::os::raw::c_char,
                arg_num_lwlocks: ::std::os::raw::c_int,
            );
        }
        RequestNamedLWLockTranche(arg_tranche_name, arg_num_lwlocks)
    })
}
pub unsafe fn GetNamedLWLockTranche(
    arg_tranche_name: *const ::std::os::raw::c_char,
) -> *mut LWLockPadded {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetNamedLWLockTranche(
                arg_tranche_name: *const ::std::os::raw::c_char,
            ) -> *mut LWLockPadded;
        }
        GetNamedLWLockTranche(arg_tranche_name)
    })
}
pub unsafe fn LWLockNewTrancheId() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockNewTrancheId() -> ::std::os::raw::c_int;
        }
        LWLockNewTrancheId()
    })
}
pub unsafe fn LWLockRegisterTranche(
    arg_tranche_id: ::std::os::raw::c_int,
    arg_tranche_name: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockRegisterTranche(
                arg_tranche_id: ::std::os::raw::c_int,
                arg_tranche_name: *const ::std::os::raw::c_char,
            );
        }
        LWLockRegisterTranche(arg_tranche_id, arg_tranche_name)
    })
}
pub unsafe fn LWLockInitialize(arg_lock: *mut LWLock, arg_tranche_id: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LWLockInitialize(arg_lock: *mut LWLock, arg_tranche_id: ::std::os::raw::c_int);
        }
        LWLockInitialize(arg_lock, arg_tranche_id)
    })
}
pub const BuiltinTrancheIds_LWTRANCHE_XACT_BUFFER: BuiltinTrancheIds = 48;
pub const BuiltinTrancheIds_LWTRANCHE_COMMITTS_BUFFER: BuiltinTrancheIds = 49;
pub const BuiltinTrancheIds_LWTRANCHE_SUBTRANS_BUFFER: BuiltinTrancheIds = 50;
pub const BuiltinTrancheIds_LWTRANCHE_MULTIXACTOFFSET_BUFFER: BuiltinTrancheIds = 51;
pub const BuiltinTrancheIds_LWTRANCHE_MULTIXACTMEMBER_BUFFER: BuiltinTrancheIds = 52;
pub const BuiltinTrancheIds_LWTRANCHE_NOTIFY_BUFFER: BuiltinTrancheIds = 53;
pub const BuiltinTrancheIds_LWTRANCHE_SERIAL_BUFFER: BuiltinTrancheIds = 54;
pub const BuiltinTrancheIds_LWTRANCHE_WAL_INSERT: BuiltinTrancheIds = 55;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_CONTENT: BuiltinTrancheIds = 56;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_IO: BuiltinTrancheIds = 57;
pub const BuiltinTrancheIds_LWTRANCHE_REPLICATION_ORIGIN_STATE: BuiltinTrancheIds = 58;
pub const BuiltinTrancheIds_LWTRANCHE_REPLICATION_SLOT_IO: BuiltinTrancheIds = 59;
pub const BuiltinTrancheIds_LWTRANCHE_LOCK_FASTPATH: BuiltinTrancheIds = 60;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_MAPPING: BuiltinTrancheIds = 61;
pub const BuiltinTrancheIds_LWTRANCHE_LOCK_MANAGER: BuiltinTrancheIds = 62;
pub const BuiltinTrancheIds_LWTRANCHE_PREDICATE_LOCK_MANAGER: BuiltinTrancheIds = 63;
pub const BuiltinTrancheIds_LWTRANCHE_PARALLEL_HASH_JOIN: BuiltinTrancheIds = 64;
pub const BuiltinTrancheIds_LWTRANCHE_PARALLEL_QUERY_DSA: BuiltinTrancheIds = 65;
pub const BuiltinTrancheIds_LWTRANCHE_PER_SESSION_DSA: BuiltinTrancheIds = 66;
pub const BuiltinTrancheIds_LWTRANCHE_PER_SESSION_RECORD_TYPE: BuiltinTrancheIds = 67;
pub const BuiltinTrancheIds_LWTRANCHE_PER_SESSION_RECORD_TYPMOD: BuiltinTrancheIds = 68;
pub const BuiltinTrancheIds_LWTRANCHE_SHARED_TUPLESTORE: BuiltinTrancheIds = 69;
pub const BuiltinTrancheIds_LWTRANCHE_SHARED_TIDBITMAP: BuiltinTrancheIds = 70;
pub const BuiltinTrancheIds_LWTRANCHE_PARALLEL_APPEND: BuiltinTrancheIds = 71;
pub const BuiltinTrancheIds_LWTRANCHE_PER_XACT_PREDICATE_LIST: BuiltinTrancheIds = 72;
pub const BuiltinTrancheIds_LWTRANCHE_FIRST_USER_DEFINED: BuiltinTrancheIds = 73;
pub type BuiltinTrancheIds = ::std::os::raw::c_uint;
pub type LWLockId = *mut LWLock;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SHM_QUEUE {
    pub prev: *mut SHM_QUEUE,
    pub next: *mut SHM_QUEUE,
}
impl Default for SHM_QUEUE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn InitShmemAccess(arg_seghdr: *mut ::std::os::raw::c_void) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitShmemAccess(arg_seghdr: *mut ::std::os::raw::c_void);
        }
        InitShmemAccess(arg_seghdr)
    })
}
pub unsafe fn InitShmemAllocation() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitShmemAllocation();
        }
        InitShmemAllocation()
    })
}
pub unsafe fn ShmemAlloc(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ShmemAlloc(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        ShmemAlloc(arg_size)
    })
}
pub unsafe fn ShmemAllocNoError(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ShmemAllocNoError(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        ShmemAllocNoError(arg_size)
    })
}
pub unsafe fn ShmemAllocUnlocked(arg_size: Size) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ShmemAllocUnlocked(arg_size: Size) -> *mut ::std::os::raw::c_void;
        }
        ShmemAllocUnlocked(arg_size)
    })
}
pub unsafe fn ShmemAddrIsValid(arg_addr: *const ::std::os::raw::c_void) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ShmemAddrIsValid(arg_addr: *const ::std::os::raw::c_void) -> bool;
        }
        ShmemAddrIsValid(arg_addr)
    })
}
pub unsafe fn InitShmemIndex() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitShmemIndex();
        }
        InitShmemIndex()
    })
}
pub unsafe fn ShmemInitHash(
    arg_name: *const ::std::os::raw::c_char,
    arg_init_size: ::std::os::raw::c_long,
    arg_max_size: ::std::os::raw::c_long,
    arg_infoP: *mut HASHCTL,
    arg_hash_flags: ::std::os::raw::c_int,
) -> *mut HTAB {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ShmemInitHash(
                arg_name: *const ::std::os::raw::c_char,
                arg_init_size: ::std::os::raw::c_long,
                arg_max_size: ::std::os::raw::c_long,
                arg_infoP: *mut HASHCTL,
                arg_hash_flags: ::std::os::raw::c_int,
            ) -> *mut HTAB;
        }
        ShmemInitHash(arg_name, arg_init_size, arg_max_size, arg_infoP, arg_hash_flags)
    })
}
pub unsafe fn ShmemInitStruct(
    arg_name: *const ::std::os::raw::c_char,
    arg_size: Size,
    arg_foundPtr: *mut bool,
) -> *mut ::std::os::raw::c_void {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ShmemInitStruct(
                arg_name: *const ::std::os::raw::c_char,
                arg_size: Size,
                arg_foundPtr: *mut bool,
            ) -> *mut ::std::os::raw::c_void;
        }
        ShmemInitStruct(arg_name, arg_size, arg_foundPtr)
    })
}
pub unsafe fn add_size(arg_s1: Size, arg_s2: Size) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn add_size(arg_s1: Size, arg_s2: Size) -> Size;
        }
        add_size(arg_s1, arg_s2)
    })
}
pub unsafe fn mul_size(arg_s1: Size, arg_s2: Size) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn mul_size(arg_s1: Size, arg_s2: Size) -> Size;
        }
        mul_size(arg_s1, arg_s2)
    })
}
pub unsafe fn RequestAddinShmemSpace(arg_size: Size) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RequestAddinShmemSpace(arg_size: Size);
        }
        RequestAddinShmemSpace(arg_size)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ShmemIndexEnt {
    pub key: [::std::os::raw::c_char; 48usize],
    pub location: *mut ::std::os::raw::c_void,
    pub size: Size,
    pub allocated_size: Size,
}
impl Default for ShmemIndexEnt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub unsafe fn SHMQueueInit(arg_queue: *mut SHM_QUEUE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueueInit(arg_queue: *mut SHM_QUEUE);
        }
        SHMQueueInit(arg_queue)
    })
}
pub unsafe fn SHMQueueElemInit(arg_queue: *mut SHM_QUEUE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueueElemInit(arg_queue: *mut SHM_QUEUE);
        }
        SHMQueueElemInit(arg_queue)
    })
}
pub unsafe fn SHMQueueDelete(arg_queue: *mut SHM_QUEUE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueueDelete(arg_queue: *mut SHM_QUEUE);
        }
        SHMQueueDelete(arg_queue)
    })
}
pub unsafe fn SHMQueueInsertBefore(arg_queue: *mut SHM_QUEUE, arg_elem: *mut SHM_QUEUE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueueInsertBefore(arg_queue: *mut SHM_QUEUE, arg_elem: *mut SHM_QUEUE);
        }
        SHMQueueInsertBefore(arg_queue, arg_elem)
    })
}
pub unsafe fn SHMQueueInsertAfter(arg_queue: *mut SHM_QUEUE, arg_elem: *mut SHM_QUEUE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueueInsertAfter(arg_queue: *mut SHM_QUEUE, arg_elem: *mut SHM_QUEUE);
        }
        SHMQueueInsertAfter(arg_queue, arg_elem)
    })
}
pub unsafe fn SHMQueueNext(
    arg_queue: *const SHM_QUEUE,
    arg_curElem: *const SHM_QUEUE,
    arg_linkOffset: Size,
) -> Pointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueueNext(
                arg_queue: *const SHM_QUEUE,
                arg_curElem: *const SHM_QUEUE,
                arg_linkOffset: Size,
            ) -> Pointer;
        }
        SHMQueueNext(arg_queue, arg_curElem, arg_linkOffset)
    })
}
pub unsafe fn SHMQueuePrev(
    arg_queue: *const SHM_QUEUE,
    arg_curElem: *const SHM_QUEUE,
    arg_linkOffset: Size,
) -> Pointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueuePrev(
                arg_queue: *const SHM_QUEUE,
                arg_curElem: *const SHM_QUEUE,
                arg_linkOffset: Size,
            ) -> Pointer;
        }
        SHMQueuePrev(arg_queue, arg_curElem, arg_linkOffset)
    })
}
pub unsafe fn SHMQueueEmpty(arg_queue: *const SHM_QUEUE) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueueEmpty(arg_queue: *const SHM_QUEUE) -> bool;
        }
        SHMQueueEmpty(arg_queue)
    })
}
pub unsafe fn SHMQueueIsDetached(arg_queue: *const SHM_QUEUE) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SHMQueueIsDetached(arg_queue: *const SHM_QUEUE) -> bool;
        }
        SHMQueueIsDetached(arg_queue)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROC_QUEUE {
    pub links: SHM_QUEUE,
    pub size: ::std::os::raw::c_int,
}
impl Default for PROC_QUEUE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut max_locks_per_xact: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VirtualTransactionId {
    pub backendId: BackendId,
    pub localTransactionId: LocalTransactionId,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockMethodData {
    pub numLockModes: ::std::os::raw::c_int,
    pub conflictTab: *const LOCKMASK,
    pub lockModeNames: *const *const ::std::os::raw::c_char,
    pub trace_flag: *const bool,
}
impl Default for LockMethodData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LockMethod = *const LockMethodData;
pub type LOCKMETHODID = uint16;
pub const LockTagType_LOCKTAG_RELATION: LockTagType = 0;
pub const LockTagType_LOCKTAG_RELATION_EXTEND: LockTagType = 1;
pub const LockTagType_LOCKTAG_DATABASE_FROZEN_IDS: LockTagType = 2;
pub const LockTagType_LOCKTAG_PAGE: LockTagType = 3;
pub const LockTagType_LOCKTAG_TUPLE: LockTagType = 4;
pub const LockTagType_LOCKTAG_TRANSACTION: LockTagType = 5;
pub const LockTagType_LOCKTAG_VIRTUALTRANSACTION: LockTagType = 6;
pub const LockTagType_LOCKTAG_SPECULATIVE_TOKEN: LockTagType = 7;
pub const LockTagType_LOCKTAG_OBJECT: LockTagType = 8;
pub const LockTagType_LOCKTAG_USERLOCK: LockTagType = 9;
pub const LockTagType_LOCKTAG_ADVISORY: LockTagType = 10;
pub type LockTagType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut LockTagTypeNames: [*const ::std::os::raw::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LOCKTAG {
    pub locktag_field1: uint32,
    pub locktag_field2: uint32,
    pub locktag_field3: uint32,
    pub locktag_field4: uint16,
    pub locktag_type: uint8,
    pub locktag_lockmethodid: uint8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCK {
    pub tag: LOCKTAG,
    pub grantMask: LOCKMASK,
    pub waitMask: LOCKMASK,
    pub procLocks: SHM_QUEUE,
    pub waitProcs: PROC_QUEUE,
    pub requested: [::std::os::raw::c_int; 10usize],
    pub nRequested: ::std::os::raw::c_int,
    pub granted: [::std::os::raw::c_int; 10usize],
    pub nGranted: ::std::os::raw::c_int,
}
impl Default for LOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROCLOCKTAG {
    pub myLock: *mut LOCK,
    pub myProc: *mut PGPROC,
}
impl Default for PROCLOCKTAG {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROCLOCK {
    pub tag: PROCLOCKTAG,
    pub groupLeader: *mut PGPROC,
    pub holdMask: LOCKMASK,
    pub releaseMask: LOCKMASK,
    pub lockLink: SHM_QUEUE,
    pub procLink: SHM_QUEUE,
}
impl Default for PROCLOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LOCALLOCKTAG {
    pub lock: LOCKTAG,
    pub mode: LOCKMODE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCALLOCKOWNER {
    pub owner: *mut ResourceOwnerData,
    pub nLocks: int64,
}
impl Default for LOCALLOCKOWNER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCALLOCK {
    pub tag: LOCALLOCKTAG,
    pub hashcode: uint32,
    pub lock: *mut LOCK,
    pub proclock: *mut PROCLOCK,
    pub nLocks: int64,
    pub numLockOwners: ::std::os::raw::c_int,
    pub maxLockOwners: ::std::os::raw::c_int,
    pub lockOwners: *mut LOCALLOCKOWNER,
    pub holdsStrongLockCount: bool,
    pub lockCleared: bool,
}
impl Default for LOCALLOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LockInstanceData {
    pub locktag: LOCKTAG,
    pub holdMask: LOCKMASK,
    pub waitLockMode: LOCKMODE,
    pub backend: BackendId,
    pub lxid: LocalTransactionId,
    pub pid: ::std::os::raw::c_int,
    pub leaderPid: ::std::os::raw::c_int,
    pub fastpath: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockData {
    pub nelements: ::std::os::raw::c_int,
    pub locks: *mut LockInstanceData,
}
impl Default for LockData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockedProcData {
    pub pid: ::std::os::raw::c_int,
    pub first_lock: ::std::os::raw::c_int,
    pub num_locks: ::std::os::raw::c_int,
    pub first_waiter: ::std::os::raw::c_int,
    pub num_waiters: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockedProcsData {
    pub procs: *mut BlockedProcData,
    pub locks: *mut LockInstanceData,
    pub waiter_pids: *mut ::std::os::raw::c_int,
    pub nprocs: ::std::os::raw::c_int,
    pub maxprocs: ::std::os::raw::c_int,
    pub nlocks: ::std::os::raw::c_int,
    pub maxlocks: ::std::os::raw::c_int,
    pub npids: ::std::os::raw::c_int,
    pub maxpids: ::std::os::raw::c_int,
}
impl Default for BlockedProcsData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const LockAcquireResult_LOCKACQUIRE_NOT_AVAIL: LockAcquireResult = 0;
pub const LockAcquireResult_LOCKACQUIRE_OK: LockAcquireResult = 1;
pub const LockAcquireResult_LOCKACQUIRE_ALREADY_HELD: LockAcquireResult = 2;
pub const LockAcquireResult_LOCKACQUIRE_ALREADY_CLEAR: LockAcquireResult = 3;
pub type LockAcquireResult = ::std::os::raw::c_uint;
pub const DeadLockState_DS_NOT_YET_CHECKED: DeadLockState = 0;
pub const DeadLockState_DS_NO_DEADLOCK: DeadLockState = 1;
pub const DeadLockState_DS_SOFT_DEADLOCK: DeadLockState = 2;
pub const DeadLockState_DS_HARD_DEADLOCK: DeadLockState = 3;
pub const DeadLockState_DS_BLOCKED_BY_AUTOVACUUM: DeadLockState = 4;
pub type DeadLockState = ::std::os::raw::c_uint;
pub unsafe fn InitLocks() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitLocks();
        }
        InitLocks()
    })
}
pub unsafe fn GetLocksMethodTable(arg_lock: *const LOCK) -> LockMethod {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetLocksMethodTable(arg_lock: *const LOCK) -> LockMethod;
        }
        GetLocksMethodTable(arg_lock)
    })
}
pub unsafe fn GetLockTagsMethodTable(arg_locktag: *const LOCKTAG) -> LockMethod {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetLockTagsMethodTable(arg_locktag: *const LOCKTAG) -> LockMethod;
        }
        GetLockTagsMethodTable(arg_locktag)
    })
}
pub unsafe fn LockTagHashCode(arg_locktag: *const LOCKTAG) -> uint32 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockTagHashCode(arg_locktag: *const LOCKTAG) -> uint32;
        }
        LockTagHashCode(arg_locktag)
    })
}
pub unsafe fn DoLockModesConflict(arg_mode1: LOCKMODE, arg_mode2: LOCKMODE) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DoLockModesConflict(arg_mode1: LOCKMODE, arg_mode2: LOCKMODE) -> bool;
        }
        DoLockModesConflict(arg_mode1, arg_mode2)
    })
}
pub unsafe fn LockAcquire(
    arg_locktag: *const LOCKTAG,
    arg_lockmode: LOCKMODE,
    arg_sessionLock: bool,
    arg_dontWait: bool,
) -> LockAcquireResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockAcquire(
                arg_locktag: *const LOCKTAG,
                arg_lockmode: LOCKMODE,
                arg_sessionLock: bool,
                arg_dontWait: bool,
            ) -> LockAcquireResult;
        }
        LockAcquire(arg_locktag, arg_lockmode, arg_sessionLock, arg_dontWait)
    })
}
pub unsafe fn LockAcquireExtended(
    arg_locktag: *const LOCKTAG,
    arg_lockmode: LOCKMODE,
    arg_sessionLock: bool,
    arg_dontWait: bool,
    arg_reportMemoryError: bool,
    arg_locallockp: *mut *mut LOCALLOCK,
) -> LockAcquireResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockAcquireExtended(
                arg_locktag: *const LOCKTAG,
                arg_lockmode: LOCKMODE,
                arg_sessionLock: bool,
                arg_dontWait: bool,
                arg_reportMemoryError: bool,
                arg_locallockp: *mut *mut LOCALLOCK,
            ) -> LockAcquireResult;
        }
        LockAcquireExtended(
            arg_locktag,
            arg_lockmode,
            arg_sessionLock,
            arg_dontWait,
            arg_reportMemoryError,
            arg_locallockp,
        )
    })
}
pub unsafe fn AbortStrongLockAcquire() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AbortStrongLockAcquire();
        }
        AbortStrongLockAcquire()
    })
}
pub unsafe fn MarkLockClear(arg_locallock: *mut LOCALLOCK) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn MarkLockClear(arg_locallock: *mut LOCALLOCK);
        }
        MarkLockClear(arg_locallock)
    })
}
pub unsafe fn LockRelease(
    arg_locktag: *const LOCKTAG,
    arg_lockmode: LOCKMODE,
    arg_sessionLock: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockRelease(
                arg_locktag: *const LOCKTAG,
                arg_lockmode: LOCKMODE,
                arg_sessionLock: bool,
            ) -> bool;
        }
        LockRelease(arg_locktag, arg_lockmode, arg_sessionLock)
    })
}
pub unsafe fn LockReleaseAll(arg_lockmethodid: LOCKMETHODID, arg_allLocks: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockReleaseAll(arg_lockmethodid: LOCKMETHODID, arg_allLocks: bool);
        }
        LockReleaseAll(arg_lockmethodid, arg_allLocks)
    })
}
pub unsafe fn LockReleaseSession(arg_lockmethodid: LOCKMETHODID) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockReleaseSession(arg_lockmethodid: LOCKMETHODID);
        }
        LockReleaseSession(arg_lockmethodid)
    })
}
pub unsafe fn LockReleaseCurrentOwner(
    arg_locallocks: *mut *mut LOCALLOCK,
    arg_nlocks: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockReleaseCurrentOwner(
                arg_locallocks: *mut *mut LOCALLOCK,
                arg_nlocks: ::std::os::raw::c_int,
            );
        }
        LockReleaseCurrentOwner(arg_locallocks, arg_nlocks)
    })
}
pub unsafe fn LockReassignCurrentOwner(
    arg_locallocks: *mut *mut LOCALLOCK,
    arg_nlocks: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockReassignCurrentOwner(
                arg_locallocks: *mut *mut LOCALLOCK,
                arg_nlocks: ::std::os::raw::c_int,
            );
        }
        LockReassignCurrentOwner(arg_locallocks, arg_nlocks)
    })
}
pub unsafe fn LockHeldByMe(arg_locktag: *const LOCKTAG, arg_lockmode: LOCKMODE) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockHeldByMe(arg_locktag: *const LOCKTAG, arg_lockmode: LOCKMODE) -> bool;
        }
        LockHeldByMe(arg_locktag, arg_lockmode)
    })
}
pub unsafe fn GetLockMethodLocalHash() -> *mut HTAB {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetLockMethodLocalHash() -> *mut HTAB;
        }
        GetLockMethodLocalHash()
    })
}
pub unsafe fn LockHasWaiters(
    arg_locktag: *const LOCKTAG,
    arg_lockmode: LOCKMODE,
    arg_sessionLock: bool,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockHasWaiters(
                arg_locktag: *const LOCKTAG,
                arg_lockmode: LOCKMODE,
                arg_sessionLock: bool,
            ) -> bool;
        }
        LockHasWaiters(arg_locktag, arg_lockmode, arg_sessionLock)
    })
}
pub unsafe fn GetLockConflicts(
    arg_locktag: *const LOCKTAG,
    arg_lockmode: LOCKMODE,
    arg_countp: *mut ::std::os::raw::c_int,
) -> *mut VirtualTransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetLockConflicts(
                arg_locktag: *const LOCKTAG,
                arg_lockmode: LOCKMODE,
                arg_countp: *mut ::std::os::raw::c_int,
            ) -> *mut VirtualTransactionId;
        }
        GetLockConflicts(arg_locktag, arg_lockmode, arg_countp)
    })
}
pub unsafe fn AtPrepare_Locks() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtPrepare_Locks();
        }
        AtPrepare_Locks()
    })
}
pub unsafe fn PostPrepare_Locks(arg_xid: TransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PostPrepare_Locks(arg_xid: TransactionId);
        }
        PostPrepare_Locks(arg_xid)
    })
}
pub unsafe fn LockCheckConflicts(
    arg_lockMethodTable: LockMethod,
    arg_lockmode: LOCKMODE,
    arg_lock: *mut LOCK,
    arg_proclock: *mut PROCLOCK,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockCheckConflicts(
                arg_lockMethodTable: LockMethod,
                arg_lockmode: LOCKMODE,
                arg_lock: *mut LOCK,
                arg_proclock: *mut PROCLOCK,
            ) -> bool;
        }
        LockCheckConflicts(arg_lockMethodTable, arg_lockmode, arg_lock, arg_proclock)
    })
}
pub unsafe fn GrantLock(arg_lock: *mut LOCK, arg_proclock: *mut PROCLOCK, arg_lockmode: LOCKMODE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GrantLock(arg_lock: *mut LOCK, arg_proclock: *mut PROCLOCK, arg_lockmode: LOCKMODE);
        }
        GrantLock(arg_lock, arg_proclock, arg_lockmode)
    })
}
pub unsafe fn GrantAwaitedLock() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GrantAwaitedLock();
        }
        GrantAwaitedLock()
    })
}
pub unsafe fn RemoveFromWaitQueue(arg_proc_: *mut PGPROC, arg_hashcode: uint32) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RemoveFromWaitQueue(arg_proc_: *mut PGPROC, arg_hashcode: uint32);
        }
        RemoveFromWaitQueue(arg_proc_, arg_hashcode)
    })
}
pub unsafe fn LockShmemSize() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockShmemSize() -> Size;
        }
        LockShmemSize()
    })
}
pub unsafe fn GetLockStatusData() -> *mut LockData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetLockStatusData() -> *mut LockData;
        }
        GetLockStatusData()
    })
}
pub unsafe fn GetBlockerStatusData(
    arg_blocked_pid: ::std::os::raw::c_int,
) -> *mut BlockedProcsData {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetBlockerStatusData(
                arg_blocked_pid: ::std::os::raw::c_int,
            ) -> *mut BlockedProcsData;
        }
        GetBlockerStatusData(arg_blocked_pid)
    })
}
pub unsafe fn GetRunningTransactionLocks(
    arg_nlocks: *mut ::std::os::raw::c_int,
) -> *mut xl_standby_lock {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetRunningTransactionLocks(
                arg_nlocks: *mut ::std::os::raw::c_int,
            ) -> *mut xl_standby_lock;
        }
        GetRunningTransactionLocks(arg_nlocks)
    })
}
pub unsafe fn GetLockmodeName(
    arg_lockmethodid: LOCKMETHODID,
    arg_mode: LOCKMODE,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetLockmodeName(
                arg_lockmethodid: LOCKMETHODID,
                arg_mode: LOCKMODE,
            ) -> *const ::std::os::raw::c_char;
        }
        GetLockmodeName(arg_lockmethodid, arg_mode)
    })
}
pub unsafe fn lock_twophase_recover(
    arg_xid: TransactionId,
    arg_info: uint16,
    arg_recdata: *mut ::std::os::raw::c_void,
    arg_len: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lock_twophase_recover(
                arg_xid: TransactionId,
                arg_info: uint16,
                arg_recdata: *mut ::std::os::raw::c_void,
                arg_len: uint32,
            );
        }
        lock_twophase_recover(arg_xid, arg_info, arg_recdata, arg_len)
    })
}
pub unsafe fn lock_twophase_postcommit(
    arg_xid: TransactionId,
    arg_info: uint16,
    arg_recdata: *mut ::std::os::raw::c_void,
    arg_len: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lock_twophase_postcommit(
                arg_xid: TransactionId,
                arg_info: uint16,
                arg_recdata: *mut ::std::os::raw::c_void,
                arg_len: uint32,
            );
        }
        lock_twophase_postcommit(arg_xid, arg_info, arg_recdata, arg_len)
    })
}
pub unsafe fn lock_twophase_postabort(
    arg_xid: TransactionId,
    arg_info: uint16,
    arg_recdata: *mut ::std::os::raw::c_void,
    arg_len: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lock_twophase_postabort(
                arg_xid: TransactionId,
                arg_info: uint16,
                arg_recdata: *mut ::std::os::raw::c_void,
                arg_len: uint32,
            );
        }
        lock_twophase_postabort(arg_xid, arg_info, arg_recdata, arg_len)
    })
}
pub unsafe fn lock_twophase_standby_recover(
    arg_xid: TransactionId,
    arg_info: uint16,
    arg_recdata: *mut ::std::os::raw::c_void,
    arg_len: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn lock_twophase_standby_recover(
                arg_xid: TransactionId,
                arg_info: uint16,
                arg_recdata: *mut ::std::os::raw::c_void,
                arg_len: uint32,
            );
        }
        lock_twophase_standby_recover(arg_xid, arg_info, arg_recdata, arg_len)
    })
}
pub unsafe fn DeadLockCheck(arg_proc_: *mut PGPROC) -> DeadLockState {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DeadLockCheck(arg_proc_: *mut PGPROC) -> DeadLockState;
        }
        DeadLockCheck(arg_proc_)
    })
}
pub unsafe fn GetBlockingAutoVacuumPgproc() -> *mut PGPROC {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetBlockingAutoVacuumPgproc() -> *mut PGPROC;
        }
        GetBlockingAutoVacuumPgproc()
    })
}
pub unsafe fn DeadLockReport() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn DeadLockReport();
        }
        DeadLockReport()
    })
}
pub unsafe fn RememberSimpleDeadLock(
    arg_proc1: *mut PGPROC,
    arg_lockmode: LOCKMODE,
    arg_lock: *mut LOCK,
    arg_proc2: *mut PGPROC,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RememberSimpleDeadLock(
                arg_proc1: *mut PGPROC,
                arg_lockmode: LOCKMODE,
                arg_lock: *mut LOCK,
                arg_proc2: *mut PGPROC,
            );
        }
        RememberSimpleDeadLock(arg_proc1, arg_lockmode, arg_lock, arg_proc2)
    })
}
pub unsafe fn InitDeadLockChecking() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitDeadLockChecking();
        }
        InitDeadLockChecking()
    })
}
pub unsafe fn LockWaiterCount(arg_locktag: *const LOCKTAG) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockWaiterCount(arg_locktag: *const LOCKTAG) -> ::std::os::raw::c_int;
        }
        LockWaiterCount(arg_locktag)
    })
}
pub unsafe fn VirtualXactLockTableInsert(arg_vxid: VirtualTransactionId) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn VirtualXactLockTableInsert(arg_vxid: VirtualTransactionId);
        }
        VirtualXactLockTableInsert(arg_vxid)
    })
}
pub unsafe fn VirtualXactLockTableCleanup() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn VirtualXactLockTableCleanup();
        }
        VirtualXactLockTableCleanup()
    })
}
pub unsafe fn VirtualXactLock(arg_vxid: VirtualTransactionId, arg_wait: bool) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn VirtualXactLock(arg_vxid: VirtualTransactionId, arg_wait: bool) -> bool;
        }
        VirtualXactLock(arg_vxid, arg_wait)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGSemaphoreData {
    _unused: [u8; 0],
}
pub type PGSemaphore = *mut PGSemaphoreData;
pub unsafe fn PGSemaphoreShmemSize(arg_maxSemas: ::std::os::raw::c_int) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PGSemaphoreShmemSize(arg_maxSemas: ::std::os::raw::c_int) -> Size;
        }
        PGSemaphoreShmemSize(arg_maxSemas)
    })
}
pub unsafe fn PGReserveSemaphores(arg_maxSemas: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PGReserveSemaphores(arg_maxSemas: ::std::os::raw::c_int);
        }
        PGReserveSemaphores(arg_maxSemas)
    })
}
pub unsafe fn PGSemaphoreCreate() -> PGSemaphore {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PGSemaphoreCreate() -> PGSemaphore;
        }
        PGSemaphoreCreate()
    })
}
pub unsafe fn PGSemaphoreReset(arg_sema: PGSemaphore) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PGSemaphoreReset(arg_sema: PGSemaphore);
        }
        PGSemaphoreReset(arg_sema)
    })
}
pub unsafe fn PGSemaphoreLock(arg_sema: PGSemaphore) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PGSemaphoreLock(arg_sema: PGSemaphore);
        }
        PGSemaphoreLock(arg_sema)
    })
}
pub unsafe fn PGSemaphoreUnlock(arg_sema: PGSemaphore) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PGSemaphoreUnlock(arg_sema: PGSemaphore);
        }
        PGSemaphoreUnlock(arg_sema)
    })
}
pub unsafe fn PGSemaphoreTryLock(arg_sema: PGSemaphore) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PGSemaphoreTryLock(arg_sema: PGSemaphore) -> bool;
        }
        PGSemaphoreTryLock(arg_sema)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XidCache {
    pub xids: [TransactionId; 64usize],
}
impl Default for XidCache {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGPROC {
    pub links: SHM_QUEUE,
    pub procgloballist: *mut *mut PGPROC,
    pub sem: PGSemaphore,
    pub waitStatus: ::std::os::raw::c_int,
    pub procLatch: Latch,
    pub lxid: LocalTransactionId,
    pub pid: ::std::os::raw::c_int,
    pub pgprocno: ::std::os::raw::c_int,
    pub backendId: BackendId,
    pub databaseId: Oid,
    pub roleId: Oid,
    pub tempNamespaceId: Oid,
    pub isBackgroundWorker: bool,
    pub recoveryConflictPending: bool,
    pub lwWaiting: bool,
    pub lwWaitMode: uint8,
    pub lwWaitLink: proclist_node,
    pub cvWaitLink: proclist_node,
    pub waitLock: *mut LOCK,
    pub waitProcLock: *mut PROCLOCK,
    pub waitLockMode: LOCKMODE,
    pub heldLocks: LOCKMASK,
    pub delayChkpt: bool,
    pub delayChkptEnd: bool,
    pub waitLSN: XLogRecPtr,
    pub syncRepState: ::std::os::raw::c_int,
    pub syncRepLinks: SHM_QUEUE,
    pub myProcLocks: [SHM_QUEUE; 16usize],
    pub subxids: XidCache,
    pub procArrayGroupMember: bool,
    pub procArrayGroupNext: pg_atomic_uint32,
    pub procArrayGroupMemberXid: TransactionId,
    pub wait_event_info: uint32,
    pub clogGroupMember: bool,
    pub clogGroupNext: pg_atomic_uint32,
    pub clogGroupMemberXid: TransactionId,
    pub clogGroupMemberXidStatus: XidStatus,
    pub clogGroupMemberPage: ::std::os::raw::c_int,
    pub clogGroupMemberLsn: XLogRecPtr,
    pub fpInfoLock: LWLock,
    pub fpLockBits: uint64,
    pub fpRelId: [Oid; 16usize],
    pub fpVXIDLock: bool,
    pub fpLocalTransactionId: LocalTransactionId,
    pub lockGroupLeader: *mut PGPROC,
    pub lockGroupMembers: dlist_head,
    pub lockGroupLink: dlist_node,
}
impl Default for PGPROC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut MyProc: *mut PGPROC;
}
extern "C" {
    pub static mut MyPgXact: *mut PGXACT;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PGXACT {
    pub xid: TransactionId,
    pub xmin: TransactionId,
    pub vacuumFlags: uint8,
    pub overflowed: bool,
    pub nxids: uint8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROC_HDR {
    pub allProcs: *mut PGPROC,
    pub allPgXact: *mut PGXACT,
    pub allProcCount: uint32,
    pub freeProcs: *mut PGPROC,
    pub autovacFreeProcs: *mut PGPROC,
    pub bgworkerFreeProcs: *mut PGPROC,
    pub walsenderFreeProcs: *mut PGPROC,
    pub procArrayGroupFirst: pg_atomic_uint32,
    pub clogGroupFirst: pg_atomic_uint32,
    pub walwriterLatch: *mut Latch,
    pub checkpointerLatch: *mut Latch,
    pub spins_per_delay: ::std::os::raw::c_int,
    pub startupProc: *mut PGPROC,
    pub startupProcPid: ::std::os::raw::c_int,
    pub startupBufferPinWaitBufId: ::std::os::raw::c_int,
}
impl Default for PROC_HDR {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut ProcGlobal: *mut PROC_HDR;
}
extern "C" {
    pub static mut PreparedXactProcs: *mut PGPROC;
}
extern "C" {
    pub static mut DeadlockTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut StatementTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut LockTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut IdleInTransactionSessionTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_lock_waits: bool;
}
pub unsafe fn ProcGlobalSemas() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcGlobalSemas() -> ::std::os::raw::c_int;
        }
        ProcGlobalSemas()
    })
}
pub unsafe fn ProcGlobalShmemSize() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcGlobalShmemSize() -> Size;
        }
        ProcGlobalShmemSize()
    })
}
pub unsafe fn InitProcGlobal() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitProcGlobal();
        }
        InitProcGlobal()
    })
}
pub unsafe fn InitProcess() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitProcess();
        }
        InitProcess()
    })
}
pub unsafe fn InitProcessPhase2() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitProcessPhase2();
        }
        InitProcessPhase2()
    })
}
pub unsafe fn InitAuxiliaryProcess() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn InitAuxiliaryProcess();
        }
        InitAuxiliaryProcess()
    })
}
pub unsafe fn PublishStartupProcessInformation() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PublishStartupProcessInformation();
        }
        PublishStartupProcessInformation()
    })
}
pub unsafe fn SetStartupBufferPinWaitBufId(arg_bufid: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn SetStartupBufferPinWaitBufId(arg_bufid: ::std::os::raw::c_int);
        }
        SetStartupBufferPinWaitBufId(arg_bufid)
    })
}
pub unsafe fn GetStartupBufferPinWaitBufId() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn GetStartupBufferPinWaitBufId() -> ::std::os::raw::c_int;
        }
        GetStartupBufferPinWaitBufId()
    })
}
pub unsafe fn HaveNFreeProcs(arg_n: ::std::os::raw::c_int) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn HaveNFreeProcs(arg_n: ::std::os::raw::c_int) -> bool;
        }
        HaveNFreeProcs(arg_n)
    })
}
pub unsafe fn ProcReleaseLocks(arg_isCommit: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcReleaseLocks(arg_isCommit: bool);
        }
        ProcReleaseLocks(arg_isCommit)
    })
}
pub unsafe fn ProcQueueInit(arg_queue: *mut PROC_QUEUE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcQueueInit(arg_queue: *mut PROC_QUEUE);
        }
        ProcQueueInit(arg_queue)
    })
}
pub unsafe fn ProcSleep(
    arg_locallock: *mut LOCALLOCK,
    arg_lockMethodTable: LockMethod,
) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcSleep(
                arg_locallock: *mut LOCALLOCK,
                arg_lockMethodTable: LockMethod,
            ) -> ::std::os::raw::c_int;
        }
        ProcSleep(arg_locallock, arg_lockMethodTable)
    })
}
pub unsafe fn ProcWakeup(
    arg_proc_: *mut PGPROC,
    arg_waitStatus: ::std::os::raw::c_int,
) -> *mut PGPROC {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcWakeup(
                arg_proc_: *mut PGPROC,
                arg_waitStatus: ::std::os::raw::c_int,
            ) -> *mut PGPROC;
        }
        ProcWakeup(arg_proc_, arg_waitStatus)
    })
}
pub unsafe fn ProcLockWakeup(arg_lockMethodTable: LockMethod, arg_lock: *mut LOCK) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcLockWakeup(arg_lockMethodTable: LockMethod, arg_lock: *mut LOCK);
        }
        ProcLockWakeup(arg_lockMethodTable, arg_lock)
    })
}
pub unsafe fn CheckDeadLockAlert() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CheckDeadLockAlert();
        }
        CheckDeadLockAlert()
    })
}
pub unsafe fn IsWaitingForLock() -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn IsWaitingForLock() -> bool;
        }
        IsWaitingForLock()
    })
}
pub unsafe fn LockErrorCleanup() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn LockErrorCleanup();
        }
        LockErrorCleanup()
    })
}
pub unsafe fn ProcWaitForSignal(arg_wait_event_info: uint32) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcWaitForSignal(arg_wait_event_info: uint32);
        }
        ProcWaitForSignal(arg_wait_event_info)
    })
}
pub unsafe fn ProcSendSignal(arg_pid: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ProcSendSignal(arg_pid: ::std::os::raw::c_int);
        }
        ProcSendSignal(arg_pid)
    })
}
pub unsafe fn AuxiliaryPidGetProc(arg_pid: ::std::os::raw::c_int) -> *mut PGPROC {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AuxiliaryPidGetProc(arg_pid: ::std::os::raw::c_int) -> *mut PGPROC;
        }
        AuxiliaryPidGetProc(arg_pid)
    })
}
pub unsafe fn BecomeLockGroupLeader() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BecomeLockGroupLeader();
        }
        BecomeLockGroupLeader()
    })
}
pub unsafe fn BecomeLockGroupMember(
    arg_leader: *mut PGPROC,
    arg_pid: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BecomeLockGroupMember(
                arg_leader: *mut PGPROC,
                arg_pid: ::std::os::raw::c_int,
            ) -> bool;
        }
        BecomeLockGroupMember(arg_leader, arg_pid)
    })
}
pub const TrackFunctionsLevel_TRACK_FUNC_OFF: TrackFunctionsLevel = 0;
pub const TrackFunctionsLevel_TRACK_FUNC_PL: TrackFunctionsLevel = 1;
pub const TrackFunctionsLevel_TRACK_FUNC_ALL: TrackFunctionsLevel = 2;
pub type TrackFunctionsLevel = ::std::os::raw::c_uint;
pub const StatMsgType_PGSTAT_MTYPE_DUMMY: StatMsgType = 0;
pub const StatMsgType_PGSTAT_MTYPE_INQUIRY: StatMsgType = 1;
pub const StatMsgType_PGSTAT_MTYPE_TABSTAT: StatMsgType = 2;
pub const StatMsgType_PGSTAT_MTYPE_TABPURGE: StatMsgType = 3;
pub const StatMsgType_PGSTAT_MTYPE_DROPDB: StatMsgType = 4;
pub const StatMsgType_PGSTAT_MTYPE_RESETCOUNTER: StatMsgType = 5;
pub const StatMsgType_PGSTAT_MTYPE_RESETSHAREDCOUNTER: StatMsgType = 6;
pub const StatMsgType_PGSTAT_MTYPE_RESETSINGLECOUNTER: StatMsgType = 7;
pub const StatMsgType_PGSTAT_MTYPE_RESETSLRUCOUNTER: StatMsgType = 8;
pub const StatMsgType_PGSTAT_MTYPE_AUTOVAC_START: StatMsgType = 9;
pub const StatMsgType_PGSTAT_MTYPE_VACUUM: StatMsgType = 10;
pub const StatMsgType_PGSTAT_MTYPE_ANALYZE: StatMsgType = 11;
pub const StatMsgType_PGSTAT_MTYPE_ARCHIVER: StatMsgType = 12;
pub const StatMsgType_PGSTAT_MTYPE_BGWRITER: StatMsgType = 13;
pub const StatMsgType_PGSTAT_MTYPE_SLRU: StatMsgType = 14;
pub const StatMsgType_PGSTAT_MTYPE_FUNCSTAT: StatMsgType = 15;
pub const StatMsgType_PGSTAT_MTYPE_FUNCPURGE: StatMsgType = 16;
pub const StatMsgType_PGSTAT_MTYPE_RECOVERYCONFLICT: StatMsgType = 17;
pub const StatMsgType_PGSTAT_MTYPE_TEMPFILE: StatMsgType = 18;
pub const StatMsgType_PGSTAT_MTYPE_DEADLOCK: StatMsgType = 19;
pub const StatMsgType_PGSTAT_MTYPE_CHECKSUMFAILURE: StatMsgType = 20;
pub type StatMsgType = ::std::os::raw::c_uint;
pub type PgStat_Counter = int64;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_TableCounts {
    pub t_numscans: PgStat_Counter,
    pub t_tuples_returned: PgStat_Counter,
    pub t_tuples_fetched: PgStat_Counter,
    pub t_tuples_inserted: PgStat_Counter,
    pub t_tuples_updated: PgStat_Counter,
    pub t_tuples_deleted: PgStat_Counter,
    pub t_tuples_hot_updated: PgStat_Counter,
    pub t_truncated: bool,
    pub t_delta_live_tuples: PgStat_Counter,
    pub t_delta_dead_tuples: PgStat_Counter,
    pub t_changed_tuples: PgStat_Counter,
    pub t_blocks_fetched: PgStat_Counter,
    pub t_blocks_hit: PgStat_Counter,
}
pub const PgStat_Shared_Reset_Target_RESET_ARCHIVER: PgStat_Shared_Reset_Target = 0;
pub const PgStat_Shared_Reset_Target_RESET_BGWRITER: PgStat_Shared_Reset_Target = 1;
pub type PgStat_Shared_Reset_Target = ::std::os::raw::c_uint;
pub const PgStat_Single_Reset_Type_RESET_TABLE: PgStat_Single_Reset_Type = 0;
pub const PgStat_Single_Reset_Type_RESET_FUNCTION: PgStat_Single_Reset_Type = 1;
pub type PgStat_Single_Reset_Type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableStatus {
    pub t_id: Oid,
    pub t_shared: bool,
    pub trans: *mut PgStat_TableXactStatus,
    pub t_counts: PgStat_TableCounts,
}
impl Default for PgStat_TableStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableXactStatus {
    pub tuples_inserted: PgStat_Counter,
    pub tuples_updated: PgStat_Counter,
    pub tuples_deleted: PgStat_Counter,
    pub truncated: bool,
    pub inserted_pre_trunc: PgStat_Counter,
    pub updated_pre_trunc: PgStat_Counter,
    pub deleted_pre_trunc: PgStat_Counter,
    pub nest_level: ::std::os::raw::c_int,
    pub upper: *mut PgStat_TableXactStatus,
    pub parent: *mut PgStat_TableStatus,
    pub next: *mut PgStat_TableXactStatus,
}
impl Default for PgStat_TableXactStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgHdr {
    pub m_type: StatMsgType,
    pub m_size: ::std::os::raw::c_int,
}
impl Default for PgStat_MsgHdr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDummy {
    pub m_hdr: PgStat_MsgHdr,
}
impl Default for PgStat_MsgDummy {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgInquiry {
    pub m_hdr: PgStat_MsgHdr,
    pub clock_time: TimestampTz,
    pub cutoff_time: TimestampTz,
    pub databaseid: Oid,
}
impl Default for PgStat_MsgInquiry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_TableEntry {
    pub t_id: Oid,
    pub t_counts: PgStat_TableCounts,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTabstat {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_xact_commit: ::std::os::raw::c_int,
    pub m_xact_rollback: ::std::os::raw::c_int,
    pub m_block_read_time: PgStat_Counter,
    pub m_block_write_time: PgStat_Counter,
    pub m_entry: [PgStat_TableEntry; 8usize],
}
impl Default for PgStat_MsgTabstat {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTabpurge {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_tableid: [Oid; 246usize],
}
impl Default for PgStat_MsgTabpurge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDropdb {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgDropdb {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetcounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgResetcounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetsharedcounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_resettarget: PgStat_Shared_Reset_Target,
}
impl Default for PgStat_MsgResetsharedcounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetsinglecounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_resettype: PgStat_Single_Reset_Type,
    pub m_objectid: Oid,
}
impl Default for PgStat_MsgResetsinglecounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetslrucounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_index: ::std::os::raw::c_int,
}
impl Default for PgStat_MsgResetslrucounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgAutovacStart {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_start_time: TimestampTz,
}
impl Default for PgStat_MsgAutovacStart {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgVacuum {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_tableoid: Oid,
    pub m_autovacuum: bool,
    pub m_vacuumtime: TimestampTz,
    pub m_live_tuples: PgStat_Counter,
    pub m_dead_tuples: PgStat_Counter,
}
impl Default for PgStat_MsgVacuum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgAnalyze {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_tableoid: Oid,
    pub m_autovacuum: bool,
    pub m_resetcounter: bool,
    pub m_analyzetime: TimestampTz,
    pub m_live_tuples: PgStat_Counter,
    pub m_dead_tuples: PgStat_Counter,
}
impl Default for PgStat_MsgAnalyze {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgArchiver {
    pub m_hdr: PgStat_MsgHdr,
    pub m_failed: bool,
    pub m_xlog: [::std::os::raw::c_char; 41usize],
    pub m_timestamp: TimestampTz,
}
impl Default for PgStat_MsgArchiver {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgBgWriter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_timed_checkpoints: PgStat_Counter,
    pub m_requested_checkpoints: PgStat_Counter,
    pub m_buf_written_checkpoints: PgStat_Counter,
    pub m_buf_written_clean: PgStat_Counter,
    pub m_maxwritten_clean: PgStat_Counter,
    pub m_buf_written_backend: PgStat_Counter,
    pub m_buf_fsync_backend: PgStat_Counter,
    pub m_buf_alloc: PgStat_Counter,
    pub m_checkpoint_write_time: PgStat_Counter,
    pub m_checkpoint_sync_time: PgStat_Counter,
}
impl Default for PgStat_MsgBgWriter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgSLRU {
    pub m_hdr: PgStat_MsgHdr,
    pub m_index: PgStat_Counter,
    pub m_blocks_zeroed: PgStat_Counter,
    pub m_blocks_hit: PgStat_Counter,
    pub m_blocks_read: PgStat_Counter,
    pub m_blocks_written: PgStat_Counter,
    pub m_blocks_exists: PgStat_Counter,
    pub m_flush: PgStat_Counter,
    pub m_truncate: PgStat_Counter,
}
impl Default for PgStat_MsgSLRU {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgRecoveryConflict {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_reason: ::std::os::raw::c_int,
}
impl Default for PgStat_MsgRecoveryConflict {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTempFile {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_filesize: usize,
}
impl Default for PgStat_MsgTempFile {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_FunctionCounts {
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: instr_time,
    pub f_self_time: instr_time,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_BackendFunctionEntry {
    pub f_id: Oid,
    pub f_counts: PgStat_FunctionCounts,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_FunctionEntry {
    pub f_id: Oid,
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: PgStat_Counter,
    pub f_self_time: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgFuncstat {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_entry: [PgStat_FunctionEntry; 30usize],
}
impl Default for PgStat_MsgFuncstat {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgFuncpurge {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_functionid: [Oid; 246usize],
}
impl Default for PgStat_MsgFuncpurge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDeadlock {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgDeadlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgChecksumFailure {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_failurecount: ::std::os::raw::c_int,
    pub m_failure_time: TimestampTz,
}
impl Default for PgStat_MsgChecksumFailure {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PgStat_Msg {
    pub msg_hdr: PgStat_MsgHdr,
    pub msg_dummy: PgStat_MsgDummy,
    pub msg_inquiry: PgStat_MsgInquiry,
    pub msg_tabstat: PgStat_MsgTabstat,
    pub msg_tabpurge: PgStat_MsgTabpurge,
    pub msg_dropdb: PgStat_MsgDropdb,
    pub msg_resetcounter: PgStat_MsgResetcounter,
    pub msg_resetsharedcounter: PgStat_MsgResetsharedcounter,
    pub msg_resetsinglecounter: PgStat_MsgResetsinglecounter,
    pub msg_resetslrucounter: PgStat_MsgResetslrucounter,
    pub msg_autovacuum_start: PgStat_MsgAutovacStart,
    pub msg_vacuum: PgStat_MsgVacuum,
    pub msg_analyze: PgStat_MsgAnalyze,
    pub msg_archiver: PgStat_MsgArchiver,
    pub msg_bgwriter: PgStat_MsgBgWriter,
    pub msg_slru: PgStat_MsgSLRU,
    pub msg_funcstat: PgStat_MsgFuncstat,
    pub msg_funcpurge: PgStat_MsgFuncpurge,
    pub msg_recoveryconflict: PgStat_MsgRecoveryConflict,
    pub msg_deadlock: PgStat_MsgDeadlock,
    pub msg_tempfile: PgStat_MsgTempFile,
    pub msg_checksumfailure: PgStat_MsgChecksumFailure,
}
impl Default for PgStat_Msg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_StatDBEntry {
    pub databaseid: Oid,
    pub n_xact_commit: PgStat_Counter,
    pub n_xact_rollback: PgStat_Counter,
    pub n_blocks_fetched: PgStat_Counter,
    pub n_blocks_hit: PgStat_Counter,
    pub n_tuples_returned: PgStat_Counter,
    pub n_tuples_fetched: PgStat_Counter,
    pub n_tuples_inserted: PgStat_Counter,
    pub n_tuples_updated: PgStat_Counter,
    pub n_tuples_deleted: PgStat_Counter,
    pub last_autovac_time: TimestampTz,
    pub n_conflict_tablespace: PgStat_Counter,
    pub n_conflict_lock: PgStat_Counter,
    pub n_conflict_snapshot: PgStat_Counter,
    pub n_conflict_bufferpin: PgStat_Counter,
    pub n_conflict_startup_deadlock: PgStat_Counter,
    pub n_temp_files: PgStat_Counter,
    pub n_temp_bytes: PgStat_Counter,
    pub n_deadlocks: PgStat_Counter,
    pub n_checksum_failures: PgStat_Counter,
    pub last_checksum_failure: TimestampTz,
    pub n_block_read_time: PgStat_Counter,
    pub n_block_write_time: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
    pub stats_timestamp: TimestampTz,
    pub tables: *mut HTAB,
    pub functions: *mut HTAB,
}
impl Default for PgStat_StatDBEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_StatTabEntry {
    pub tableid: Oid,
    pub numscans: PgStat_Counter,
    pub tuples_returned: PgStat_Counter,
    pub tuples_fetched: PgStat_Counter,
    pub tuples_inserted: PgStat_Counter,
    pub tuples_updated: PgStat_Counter,
    pub tuples_deleted: PgStat_Counter,
    pub tuples_hot_updated: PgStat_Counter,
    pub n_live_tuples: PgStat_Counter,
    pub n_dead_tuples: PgStat_Counter,
    pub changes_since_analyze: PgStat_Counter,
    pub inserts_since_vacuum: PgStat_Counter,
    pub blocks_fetched: PgStat_Counter,
    pub blocks_hit: PgStat_Counter,
    pub vacuum_timestamp: TimestampTz,
    pub vacuum_count: PgStat_Counter,
    pub autovac_vacuum_timestamp: TimestampTz,
    pub autovac_vacuum_count: PgStat_Counter,
    pub analyze_timestamp: TimestampTz,
    pub analyze_count: PgStat_Counter,
    pub autovac_analyze_timestamp: TimestampTz,
    pub autovac_analyze_count: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_StatFuncEntry {
    pub functionid: Oid,
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: PgStat_Counter,
    pub f_self_time: PgStat_Counter,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_ArchiverStats {
    pub archived_count: PgStat_Counter,
    pub last_archived_wal: [::std::os::raw::c_char; 41usize],
    pub last_archived_timestamp: TimestampTz,
    pub failed_count: PgStat_Counter,
    pub last_failed_wal: [::std::os::raw::c_char; 41usize],
    pub last_failed_timestamp: TimestampTz,
    pub stat_reset_timestamp: TimestampTz,
}
impl Default for PgStat_ArchiverStats {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_GlobalStats {
    pub stats_timestamp: TimestampTz,
    pub timed_checkpoints: PgStat_Counter,
    pub requested_checkpoints: PgStat_Counter,
    pub checkpoint_write_time: PgStat_Counter,
    pub checkpoint_sync_time: PgStat_Counter,
    pub buf_written_checkpoints: PgStat_Counter,
    pub buf_written_clean: PgStat_Counter,
    pub maxwritten_clean: PgStat_Counter,
    pub buf_written_backend: PgStat_Counter,
    pub buf_fsync_backend: PgStat_Counter,
    pub buf_alloc: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_SLRUStats {
    pub blocks_zeroed: PgStat_Counter,
    pub blocks_hit: PgStat_Counter,
    pub blocks_read: PgStat_Counter,
    pub blocks_written: PgStat_Counter,
    pub blocks_exists: PgStat_Counter,
    pub flush: PgStat_Counter,
    pub truncate: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
pub const BackendState_STATE_UNDEFINED: BackendState = 0;
pub const BackendState_STATE_IDLE: BackendState = 1;
pub const BackendState_STATE_RUNNING: BackendState = 2;
pub const BackendState_STATE_IDLEINTRANSACTION: BackendState = 3;
pub const BackendState_STATE_FASTPATH: BackendState = 4;
pub const BackendState_STATE_IDLEINTRANSACTION_ABORTED: BackendState = 5;
pub const BackendState_STATE_DISABLED: BackendState = 6;
pub type BackendState = ::std::os::raw::c_uint;
pub const WaitEventActivity_WAIT_EVENT_ARCHIVER_MAIN: WaitEventActivity = 83886080;
pub const WaitEventActivity_WAIT_EVENT_AUTOVACUUM_MAIN: WaitEventActivity = 83886081;
pub const WaitEventActivity_WAIT_EVENT_BGWRITER_HIBERNATE: WaitEventActivity = 83886082;
pub const WaitEventActivity_WAIT_EVENT_BGWRITER_MAIN: WaitEventActivity = 83886083;
pub const WaitEventActivity_WAIT_EVENT_CHECKPOINTER_MAIN: WaitEventActivity = 83886084;
pub const WaitEventActivity_WAIT_EVENT_LOGICAL_APPLY_MAIN: WaitEventActivity = 83886085;
pub const WaitEventActivity_WAIT_EVENT_LOGICAL_LAUNCHER_MAIN: WaitEventActivity = 83886086;
pub const WaitEventActivity_WAIT_EVENT_PGSTAT_MAIN: WaitEventActivity = 83886087;
pub const WaitEventActivity_WAIT_EVENT_RECOVERY_WAL_STREAM: WaitEventActivity = 83886088;
pub const WaitEventActivity_WAIT_EVENT_SYSLOGGER_MAIN: WaitEventActivity = 83886089;
pub const WaitEventActivity_WAIT_EVENT_WAL_RECEIVER_MAIN: WaitEventActivity = 83886090;
pub const WaitEventActivity_WAIT_EVENT_WAL_SENDER_MAIN: WaitEventActivity = 83886091;
pub const WaitEventActivity_WAIT_EVENT_WAL_WRITER_MAIN: WaitEventActivity = 83886092;
pub type WaitEventActivity = ::std::os::raw::c_uint;
pub const WaitEventClient_WAIT_EVENT_CLIENT_READ: WaitEventClient = 100663296;
pub const WaitEventClient_WAIT_EVENT_CLIENT_WRITE: WaitEventClient = 100663297;
pub const WaitEventClient_WAIT_EVENT_GSS_OPEN_SERVER: WaitEventClient = 100663298;
pub const WaitEventClient_WAIT_EVENT_LIBPQWALRECEIVER_CONNECT: WaitEventClient = 100663299;
pub const WaitEventClient_WAIT_EVENT_LIBPQWALRECEIVER_RECEIVE: WaitEventClient = 100663300;
pub const WaitEventClient_WAIT_EVENT_SSL_OPEN_SERVER: WaitEventClient = 100663301;
pub const WaitEventClient_WAIT_EVENT_WAL_RECEIVER_WAIT_START: WaitEventClient = 100663302;
pub const WaitEventClient_WAIT_EVENT_WAL_SENDER_WAIT_WAL: WaitEventClient = 100663303;
pub const WaitEventClient_WAIT_EVENT_WAL_SENDER_WRITE_DATA: WaitEventClient = 100663304;
pub type WaitEventClient = ::std::os::raw::c_uint;
pub const WaitEventIPC_WAIT_EVENT_BACKUP_WAIT_WAL_ARCHIVE: WaitEventIPC = 134217728;
pub const WaitEventIPC_WAIT_EVENT_BGWORKER_SHUTDOWN: WaitEventIPC = 134217729;
pub const WaitEventIPC_WAIT_EVENT_BGWORKER_STARTUP: WaitEventIPC = 134217730;
pub const WaitEventIPC_WAIT_EVENT_BTREE_PAGE: WaitEventIPC = 134217731;
pub const WaitEventIPC_WAIT_EVENT_CHECKPOINT_DONE: WaitEventIPC = 134217732;
pub const WaitEventIPC_WAIT_EVENT_CHECKPOINT_START: WaitEventIPC = 134217733;
pub const WaitEventIPC_WAIT_EVENT_EXECUTE_GATHER: WaitEventIPC = 134217734;
pub const WaitEventIPC_WAIT_EVENT_HASH_BATCH_ALLOCATE: WaitEventIPC = 134217735;
pub const WaitEventIPC_WAIT_EVENT_HASH_BATCH_ELECT: WaitEventIPC = 134217736;
pub const WaitEventIPC_WAIT_EVENT_HASH_BATCH_LOAD: WaitEventIPC = 134217737;
pub const WaitEventIPC_WAIT_EVENT_HASH_BUILD_ALLOCATE: WaitEventIPC = 134217738;
pub const WaitEventIPC_WAIT_EVENT_HASH_BUILD_ELECT: WaitEventIPC = 134217739;
pub const WaitEventIPC_WAIT_EVENT_HASH_BUILD_HASH_INNER: WaitEventIPC = 134217740;
pub const WaitEventIPC_WAIT_EVENT_HASH_BUILD_HASH_OUTER: WaitEventIPC = 134217741;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_ALLOCATE: WaitEventIPC = 134217742;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_DECIDE: WaitEventIPC = 134217743;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_ELECT: WaitEventIPC = 134217744;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_FINISH: WaitEventIPC = 134217745;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_REPARTITION: WaitEventIPC = 134217746;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BUCKETS_ALLOCATE: WaitEventIPC = 134217747;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BUCKETS_ELECT: WaitEventIPC = 134217748;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BUCKETS_REINSERT: WaitEventIPC = 134217749;
pub const WaitEventIPC_WAIT_EVENT_LOGICAL_SYNC_DATA: WaitEventIPC = 134217750;
pub const WaitEventIPC_WAIT_EVENT_LOGICAL_SYNC_STATE_CHANGE: WaitEventIPC = 134217751;
pub const WaitEventIPC_WAIT_EVENT_MQ_INTERNAL: WaitEventIPC = 134217752;
pub const WaitEventIPC_WAIT_EVENT_MQ_PUT_MESSAGE: WaitEventIPC = 134217753;
pub const WaitEventIPC_WAIT_EVENT_MQ_RECEIVE: WaitEventIPC = 134217754;
pub const WaitEventIPC_WAIT_EVENT_MQ_SEND: WaitEventIPC = 134217755;
pub const WaitEventIPC_WAIT_EVENT_PARALLEL_BITMAP_SCAN: WaitEventIPC = 134217756;
pub const WaitEventIPC_WAIT_EVENT_PARALLEL_CREATE_INDEX_SCAN: WaitEventIPC = 134217757;
pub const WaitEventIPC_WAIT_EVENT_PARALLEL_FINISH: WaitEventIPC = 134217758;
pub const WaitEventIPC_WAIT_EVENT_PROCARRAY_GROUP_UPDATE: WaitEventIPC = 134217759;
pub const WaitEventIPC_WAIT_EVENT_PROC_SIGNAL_BARRIER: WaitEventIPC = 134217760;
pub const WaitEventIPC_WAIT_EVENT_PROMOTE: WaitEventIPC = 134217761;
pub const WaitEventIPC_WAIT_EVENT_RECOVERY_CONFLICT_SNAPSHOT: WaitEventIPC = 134217762;
pub const WaitEventIPC_WAIT_EVENT_RECOVERY_CONFLICT_TABLESPACE: WaitEventIPC = 134217763;
pub const WaitEventIPC_WAIT_EVENT_RECOVERY_PAUSE: WaitEventIPC = 134217764;
pub const WaitEventIPC_WAIT_EVENT_REPLICATION_ORIGIN_DROP: WaitEventIPC = 134217765;
pub const WaitEventIPC_WAIT_EVENT_REPLICATION_SLOT_DROP: WaitEventIPC = 134217766;
pub const WaitEventIPC_WAIT_EVENT_SAFE_SNAPSHOT: WaitEventIPC = 134217767;
pub const WaitEventIPC_WAIT_EVENT_SYNC_REP: WaitEventIPC = 134217768;
pub const WaitEventIPC_WAIT_EVENT_XACT_GROUP_UPDATE: WaitEventIPC = 134217769;
pub type WaitEventIPC = ::std::os::raw::c_uint;
pub const WaitEventTimeout_WAIT_EVENT_BASE_BACKUP_THROTTLE: WaitEventTimeout = 150994944;
pub const WaitEventTimeout_WAIT_EVENT_PG_SLEEP: WaitEventTimeout = 150994945;
pub const WaitEventTimeout_WAIT_EVENT_RECOVERY_APPLY_DELAY: WaitEventTimeout = 150994946;
pub const WaitEventTimeout_WAIT_EVENT_RECOVERY_RETRIEVE_RETRY_INTERVAL: WaitEventTimeout =
    150994947;
pub const WaitEventTimeout_WAIT_EVENT_VACUUM_DELAY: WaitEventTimeout = 150994948;
pub const WaitEventTimeout_WAIT_EVENT_REGISTER_SYNC_REQUEST: WaitEventTimeout = 150994949;
pub type WaitEventTimeout = ::std::os::raw::c_uint;
pub const WaitEventIO_WAIT_EVENT_BUFFILE_READ: WaitEventIO = 167772160;
pub const WaitEventIO_WAIT_EVENT_BUFFILE_WRITE: WaitEventIO = 167772161;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_READ: WaitEventIO = 167772162;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_SYNC: WaitEventIO = 167772163;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_SYNC_UPDATE: WaitEventIO = 167772164;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_WRITE: WaitEventIO = 167772165;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_WRITE_UPDATE: WaitEventIO = 167772166;
pub const WaitEventIO_WAIT_EVENT_COPY_FILE_READ: WaitEventIO = 167772167;
pub const WaitEventIO_WAIT_EVENT_COPY_FILE_WRITE: WaitEventIO = 167772168;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_EXTEND: WaitEventIO = 167772169;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_FLUSH: WaitEventIO = 167772170;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_IMMEDIATE_SYNC: WaitEventIO = 167772171;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_PREFETCH: WaitEventIO = 167772172;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_READ: WaitEventIO = 167772173;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_SYNC: WaitEventIO = 167772174;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_TRUNCATE: WaitEventIO = 167772175;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_WRITE: WaitEventIO = 167772176;
pub const WaitEventIO_WAIT_EVENT_DSM_FILL_ZERO_WRITE: WaitEventIO = 167772177;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_READ: WaitEventIO = 167772178;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_SYNC: WaitEventIO = 167772179;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_WRITE: WaitEventIO = 167772180;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_READ: WaitEventIO = 167772181;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_SYNC: WaitEventIO = 167772182;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_WRITE: WaitEventIO = 167772183;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_RECHECKDATADIR_READ: WaitEventIO = 167772184;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_CHECKPOINT_SYNC: WaitEventIO = 167772185;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_MAPPING_SYNC: WaitEventIO = 167772186;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_MAPPING_WRITE: WaitEventIO = 167772187;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_SYNC: WaitEventIO = 167772188;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_TRUNCATE: WaitEventIO = 167772189;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_WRITE: WaitEventIO = 167772190;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_READ: WaitEventIO = 167772191;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_SYNC: WaitEventIO = 167772192;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_WRITE: WaitEventIO = 167772193;
pub const WaitEventIO_WAIT_EVENT_REORDER_BUFFER_READ: WaitEventIO = 167772194;
pub const WaitEventIO_WAIT_EVENT_REORDER_BUFFER_WRITE: WaitEventIO = 167772195;
pub const WaitEventIO_WAIT_EVENT_REORDER_LOGICAL_MAPPING_READ: WaitEventIO = 167772196;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_READ: WaitEventIO = 167772197;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_RESTORE_SYNC: WaitEventIO = 167772198;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_SYNC: WaitEventIO = 167772199;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_WRITE: WaitEventIO = 167772200;
pub const WaitEventIO_WAIT_EVENT_SLRU_FLUSH_SYNC: WaitEventIO = 167772201;
pub const WaitEventIO_WAIT_EVENT_SLRU_READ: WaitEventIO = 167772202;
pub const WaitEventIO_WAIT_EVENT_SLRU_SYNC: WaitEventIO = 167772203;
pub const WaitEventIO_WAIT_EVENT_SLRU_WRITE: WaitEventIO = 167772204;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_READ: WaitEventIO = 167772205;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_SYNC: WaitEventIO = 167772206;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_WRITE: WaitEventIO = 167772207;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_FILE_SYNC: WaitEventIO = 167772208;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_FILE_WRITE: WaitEventIO = 167772209;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_READ: WaitEventIO = 167772210;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_SYNC: WaitEventIO = 167772211;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_WRITE: WaitEventIO = 167772212;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_READ: WaitEventIO = 167772213;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_SYNC: WaitEventIO = 167772214;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_WRITE: WaitEventIO = 167772215;
pub const WaitEventIO_WAIT_EVENT_WALSENDER_TIMELINE_HISTORY_READ: WaitEventIO = 167772216;
pub const WaitEventIO_WAIT_EVENT_WAL_BOOTSTRAP_SYNC: WaitEventIO = 167772217;
pub const WaitEventIO_WAIT_EVENT_WAL_BOOTSTRAP_WRITE: WaitEventIO = 167772218;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_READ: WaitEventIO = 167772219;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_SYNC: WaitEventIO = 167772220;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_WRITE: WaitEventIO = 167772221;
pub const WaitEventIO_WAIT_EVENT_WAL_INIT_SYNC: WaitEventIO = 167772222;
pub const WaitEventIO_WAIT_EVENT_WAL_INIT_WRITE: WaitEventIO = 167772223;
pub const WaitEventIO_WAIT_EVENT_WAL_READ: WaitEventIO = 167772224;
pub const WaitEventIO_WAIT_EVENT_WAL_SYNC: WaitEventIO = 167772225;
pub const WaitEventIO_WAIT_EVENT_WAL_SYNC_METHOD_ASSIGN: WaitEventIO = 167772226;
pub const WaitEventIO_WAIT_EVENT_WAL_WRITE: WaitEventIO = 167772227;
pub type WaitEventIO = ::std::os::raw::c_uint;
pub const ProgressCommandType_PROGRESS_COMMAND_INVALID: ProgressCommandType = 0;
pub const ProgressCommandType_PROGRESS_COMMAND_VACUUM: ProgressCommandType = 1;
pub const ProgressCommandType_PROGRESS_COMMAND_ANALYZE: ProgressCommandType = 2;
pub const ProgressCommandType_PROGRESS_COMMAND_CLUSTER: ProgressCommandType = 3;
pub const ProgressCommandType_PROGRESS_COMMAND_CREATE_INDEX: ProgressCommandType = 4;
pub const ProgressCommandType_PROGRESS_COMMAND_BASEBACKUP: ProgressCommandType = 5;
pub type ProgressCommandType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendSSLStatus {
    pub ssl_bits: ::std::os::raw::c_int,
    pub ssl_compression: bool,
    pub ssl_version: [::std::os::raw::c_char; 64usize],
    pub ssl_cipher: [::std::os::raw::c_char; 64usize],
    pub ssl_client_dn: [::std::os::raw::c_char; 64usize],
    pub ssl_client_serial: [::std::os::raw::c_char; 64usize],
    pub ssl_issuer_dn: [::std::os::raw::c_char; 64usize],
}
impl Default for PgBackendSSLStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendGSSStatus {
    pub gss_princ: [::std::os::raw::c_char; 64usize],
    pub gss_auth: bool,
    pub gss_enc: bool,
}
impl Default for PgBackendGSSStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendStatus {
    pub st_changecount: ::std::os::raw::c_int,
    pub st_procpid: ::std::os::raw::c_int,
    pub st_backendType: BackendType,
    pub st_proc_start_timestamp: TimestampTz,
    pub st_xact_start_timestamp: TimestampTz,
    pub st_activity_start_timestamp: TimestampTz,
    pub st_state_start_timestamp: TimestampTz,
    pub st_databaseid: Oid,
    pub st_userid: Oid,
    pub st_clientaddr: SockAddr,
    pub st_clienthostname: *mut ::std::os::raw::c_char,
    pub st_ssl: bool,
    pub st_sslstatus: *mut PgBackendSSLStatus,
    pub st_gss: bool,
    pub st_gssstatus: *mut PgBackendGSSStatus,
    pub st_state: BackendState,
    pub st_appname: *mut ::std::os::raw::c_char,
    pub st_activity_raw: *mut ::std::os::raw::c_char,
    pub st_progress_command: ProgressCommandType,
    pub st_progress_command_target: Oid,
    pub st_progress_param: [int64; 20usize],
}
impl Default for PgBackendStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LocalPgBackendStatus {
    pub backendStatus: PgBackendStatus,
    pub backend_xid: TransactionId,
    pub backend_xmin: TransactionId,
}
impl Default for LocalPgBackendStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_FunctionCallUsage {
    pub fs: *mut PgStat_FunctionCounts,
    pub save_f_total_time: instr_time,
    pub save_total: instr_time,
    pub f_start: instr_time,
}
impl Default for PgStat_FunctionCallUsage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut pgstat_track_activities: bool;
}
extern "C" {
    pub static mut pgstat_track_counts: bool;
}
extern "C" {
    pub static mut pgstat_track_functions: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut pgstat_track_activity_query_size: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut pgstat_stat_directory: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut pgstat_stat_tmpname: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut pgstat_stat_filename: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut BgWriterStats: PgStat_MsgBgWriter;
}
extern "C" {
    pub static mut pgStatBlockReadTime: PgStat_Counter;
}
extern "C" {
    pub static mut pgStatBlockWriteTime: PgStat_Counter;
}
pub unsafe fn BackendStatusShmemSize() -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BackendStatusShmemSize() -> Size;
        }
        BackendStatusShmemSize()
    })
}
pub unsafe fn CreateSharedBackendStatus() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn CreateSharedBackendStatus();
        }
        CreateSharedBackendStatus()
    })
}
pub unsafe fn pgstat_init() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_init();
        }
        pgstat_init()
    })
}
pub unsafe fn pgstat_start() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_start() -> ::std::os::raw::c_int;
        }
        pgstat_start()
    })
}
pub unsafe fn pgstat_reset_all() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_reset_all();
        }
        pgstat_reset_all()
    })
}
pub unsafe fn allow_immediate_pgstat_restart() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn allow_immediate_pgstat_restart();
        }
        allow_immediate_pgstat_restart()
    })
}
pub unsafe fn pgstat_ping() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_ping();
        }
        pgstat_ping()
    })
}
pub unsafe fn pgstat_report_stat(arg_force: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_stat(arg_force: bool);
        }
        pgstat_report_stat(arg_force)
    })
}
pub unsafe fn pgstat_vacuum_stat() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_vacuum_stat();
        }
        pgstat_vacuum_stat()
    })
}
pub unsafe fn pgstat_drop_database(arg_databaseid: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_drop_database(arg_databaseid: Oid);
        }
        pgstat_drop_database(arg_databaseid)
    })
}
pub unsafe fn pgstat_clear_snapshot() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_clear_snapshot();
        }
        pgstat_clear_snapshot()
    })
}
pub unsafe fn pgstat_reset_counters() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_reset_counters();
        }
        pgstat_reset_counters()
    })
}
pub unsafe fn pgstat_reset_shared_counters(arg_arg1: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_reset_shared_counters(arg_arg1: *const ::std::os::raw::c_char);
        }
        pgstat_reset_shared_counters(arg_arg1)
    })
}
pub unsafe fn pgstat_reset_single_counter(arg_objectid: Oid, arg_type_: PgStat_Single_Reset_Type) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_reset_single_counter(arg_objectid: Oid, arg_type_: PgStat_Single_Reset_Type);
        }
        pgstat_reset_single_counter(arg_objectid, arg_type_)
    })
}
pub unsafe fn pgstat_reset_slru_counter(arg_arg1: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_reset_slru_counter(arg_arg1: *const ::std::os::raw::c_char);
        }
        pgstat_reset_slru_counter(arg_arg1)
    })
}
pub unsafe fn pgstat_report_autovac(arg_dboid: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_autovac(arg_dboid: Oid);
        }
        pgstat_report_autovac(arg_dboid)
    })
}
pub unsafe fn pgstat_report_vacuum(
    arg_tableoid: Oid,
    arg_shared: bool,
    arg_livetuples: PgStat_Counter,
    arg_deadtuples: PgStat_Counter,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_vacuum(
                arg_tableoid: Oid,
                arg_shared: bool,
                arg_livetuples: PgStat_Counter,
                arg_deadtuples: PgStat_Counter,
            );
        }
        pgstat_report_vacuum(arg_tableoid, arg_shared, arg_livetuples, arg_deadtuples)
    })
}
pub unsafe fn pgstat_report_analyze(
    arg_rel: Relation,
    arg_livetuples: PgStat_Counter,
    arg_deadtuples: PgStat_Counter,
    arg_resetcounter: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_analyze(
                arg_rel: Relation,
                arg_livetuples: PgStat_Counter,
                arg_deadtuples: PgStat_Counter,
                arg_resetcounter: bool,
            );
        }
        pgstat_report_analyze(arg_rel, arg_livetuples, arg_deadtuples, arg_resetcounter)
    })
}
pub unsafe fn pgstat_report_recovery_conflict(arg_reason: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_recovery_conflict(arg_reason: ::std::os::raw::c_int);
        }
        pgstat_report_recovery_conflict(arg_reason)
    })
}
pub unsafe fn pgstat_report_deadlock() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_deadlock();
        }
        pgstat_report_deadlock()
    })
}
pub unsafe fn pgstat_report_checksum_failures_in_db(
    arg_dboid: Oid,
    arg_failurecount: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_checksum_failures_in_db(
                arg_dboid: Oid,
                arg_failurecount: ::std::os::raw::c_int,
            );
        }
        pgstat_report_checksum_failures_in_db(arg_dboid, arg_failurecount)
    })
}
pub unsafe fn pgstat_report_checksum_failure() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_checksum_failure();
        }
        pgstat_report_checksum_failure()
    })
}
pub unsafe fn pgstat_initialize() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_initialize();
        }
        pgstat_initialize()
    })
}
pub unsafe fn pgstat_bestart() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_bestart();
        }
        pgstat_bestart()
    })
}
pub unsafe fn pgstat_report_activity(
    arg_state: BackendState,
    arg_cmd_str: *const ::std::os::raw::c_char,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_activity(
                arg_state: BackendState,
                arg_cmd_str: *const ::std::os::raw::c_char,
            );
        }
        pgstat_report_activity(arg_state, arg_cmd_str)
    })
}
pub unsafe fn pgstat_report_tempfile(arg_filesize: usize) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_tempfile(arg_filesize: usize);
        }
        pgstat_report_tempfile(arg_filesize)
    })
}
pub unsafe fn pgstat_report_appname(arg_appname: *const ::std::os::raw::c_char) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_appname(arg_appname: *const ::std::os::raw::c_char);
        }
        pgstat_report_appname(arg_appname)
    })
}
pub unsafe fn pgstat_report_xact_timestamp(arg_tstamp: TimestampTz) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_report_xact_timestamp(arg_tstamp: TimestampTz);
        }
        pgstat_report_xact_timestamp(arg_tstamp)
    })
}
pub unsafe fn pgstat_get_wait_event(arg_wait_event_info: uint32) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_get_wait_event(arg_wait_event_info: uint32) -> *const ::std::os::raw::c_char;
        }
        pgstat_get_wait_event(arg_wait_event_info)
    })
}
pub unsafe fn pgstat_get_wait_event_type(
    arg_wait_event_info: uint32,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_get_wait_event_type(
                arg_wait_event_info: uint32,
            ) -> *const ::std::os::raw::c_char;
        }
        pgstat_get_wait_event_type(arg_wait_event_info)
    })
}
pub unsafe fn pgstat_get_backend_current_activity(
    arg_pid: ::std::os::raw::c_int,
    arg_checkUser: bool,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_get_backend_current_activity(
                arg_pid: ::std::os::raw::c_int,
                arg_checkUser: bool,
            ) -> *const ::std::os::raw::c_char;
        }
        pgstat_get_backend_current_activity(arg_pid, arg_checkUser)
    })
}
pub unsafe fn pgstat_get_crashed_backend_activity(
    arg_pid: ::std::os::raw::c_int,
    arg_buffer: *mut ::std::os::raw::c_char,
    arg_buflen: ::std::os::raw::c_int,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_get_crashed_backend_activity(
                arg_pid: ::std::os::raw::c_int,
                arg_buffer: *mut ::std::os::raw::c_char,
                arg_buflen: ::std::os::raw::c_int,
            ) -> *const ::std::os::raw::c_char;
        }
        pgstat_get_crashed_backend_activity(arg_pid, arg_buffer, arg_buflen)
    })
}
pub unsafe fn pgstat_progress_start_command(arg_cmdtype: ProgressCommandType, arg_relid: Oid) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_progress_start_command(arg_cmdtype: ProgressCommandType, arg_relid: Oid);
        }
        pgstat_progress_start_command(arg_cmdtype, arg_relid)
    })
}
pub unsafe fn pgstat_progress_update_param(arg_index: ::std::os::raw::c_int, arg_val: int64) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_progress_update_param(arg_index: ::std::os::raw::c_int, arg_val: int64);
        }
        pgstat_progress_update_param(arg_index, arg_val)
    })
}
pub unsafe fn pgstat_progress_update_multi_param(
    arg_nparam: ::std::os::raw::c_int,
    arg_index: *const ::std::os::raw::c_int,
    arg_val: *const int64,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_progress_update_multi_param(
                arg_nparam: ::std::os::raw::c_int,
                arg_index: *const ::std::os::raw::c_int,
                arg_val: *const int64,
            );
        }
        pgstat_progress_update_multi_param(arg_nparam, arg_index, arg_val)
    })
}
pub unsafe fn pgstat_progress_end_command() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_progress_end_command();
        }
        pgstat_progress_end_command()
    })
}
pub unsafe fn find_tabstat_entry(arg_rel_id: Oid) -> *mut PgStat_TableStatus {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_tabstat_entry(arg_rel_id: Oid) -> *mut PgStat_TableStatus;
        }
        find_tabstat_entry(arg_rel_id)
    })
}
pub unsafe fn find_funcstat_entry(arg_func_id: Oid) -> *mut PgStat_BackendFunctionEntry {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn find_funcstat_entry(arg_func_id: Oid) -> *mut PgStat_BackendFunctionEntry;
        }
        find_funcstat_entry(arg_func_id)
    })
}
pub unsafe fn pgstat_initstats(arg_rel: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_initstats(arg_rel: Relation);
        }
        pgstat_initstats(arg_rel)
    })
}
pub unsafe fn pgstat_clip_activity(
    arg_raw_activity: *const ::std::os::raw::c_char,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_clip_activity(
                arg_raw_activity: *const ::std::os::raw::c_char,
            ) -> *mut ::std::os::raw::c_char;
        }
        pgstat_clip_activity(arg_raw_activity)
    })
}
pub unsafe fn pgstat_count_heap_insert(arg_rel: Relation, arg_n: PgStat_Counter) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_heap_insert(arg_rel: Relation, arg_n: PgStat_Counter);
        }
        pgstat_count_heap_insert(arg_rel, arg_n)
    })
}
pub unsafe fn pgstat_count_heap_update(arg_rel: Relation, arg_hot: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_heap_update(arg_rel: Relation, arg_hot: bool);
        }
        pgstat_count_heap_update(arg_rel, arg_hot)
    })
}
pub unsafe fn pgstat_count_heap_delete(arg_rel: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_heap_delete(arg_rel: Relation);
        }
        pgstat_count_heap_delete(arg_rel)
    })
}
pub unsafe fn pgstat_count_truncate(arg_rel: Relation) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_truncate(arg_rel: Relation);
        }
        pgstat_count_truncate(arg_rel)
    })
}
pub unsafe fn pgstat_update_heap_dead_tuples(arg_rel: Relation, arg_delta: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_update_heap_dead_tuples(arg_rel: Relation, arg_delta: ::std::os::raw::c_int);
        }
        pgstat_update_heap_dead_tuples(arg_rel, arg_delta)
    })
}
pub unsafe fn pgstat_init_function_usage(
    arg_fcinfo: *mut FunctionCallInfoBaseData,
    arg_fcu: *mut PgStat_FunctionCallUsage,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_init_function_usage(
                arg_fcinfo: *mut FunctionCallInfoBaseData,
                arg_fcu: *mut PgStat_FunctionCallUsage,
            );
        }
        pgstat_init_function_usage(arg_fcinfo, arg_fcu)
    })
}
pub unsafe fn pgstat_end_function_usage(
    arg_fcu: *mut PgStat_FunctionCallUsage,
    arg_finalize: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_end_function_usage(
                arg_fcu: *mut PgStat_FunctionCallUsage,
                arg_finalize: bool,
            );
        }
        pgstat_end_function_usage(arg_fcu, arg_finalize)
    })
}
pub unsafe fn AtEOXact_PgStat(arg_isCommit: bool, arg_parallel: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOXact_PgStat(arg_isCommit: bool, arg_parallel: bool);
        }
        AtEOXact_PgStat(arg_isCommit, arg_parallel)
    })
}
pub unsafe fn AtEOSubXact_PgStat(arg_isCommit: bool, arg_nestDepth: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtEOSubXact_PgStat(arg_isCommit: bool, arg_nestDepth: ::std::os::raw::c_int);
        }
        AtEOSubXact_PgStat(arg_isCommit, arg_nestDepth)
    })
}
pub unsafe fn AtPrepare_PgStat() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn AtPrepare_PgStat();
        }
        AtPrepare_PgStat()
    })
}
pub unsafe fn PostPrepare_PgStat() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn PostPrepare_PgStat();
        }
        PostPrepare_PgStat()
    })
}
pub unsafe fn pgstat_twophase_postcommit(
    arg_xid: TransactionId,
    arg_info: uint16,
    arg_recdata: *mut ::std::os::raw::c_void,
    arg_len: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_twophase_postcommit(
                arg_xid: TransactionId,
                arg_info: uint16,
                arg_recdata: *mut ::std::os::raw::c_void,
                arg_len: uint32,
            );
        }
        pgstat_twophase_postcommit(arg_xid, arg_info, arg_recdata, arg_len)
    })
}
pub unsafe fn pgstat_twophase_postabort(
    arg_xid: TransactionId,
    arg_info: uint16,
    arg_recdata: *mut ::std::os::raw::c_void,
    arg_len: uint32,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_twophase_postabort(
                arg_xid: TransactionId,
                arg_info: uint16,
                arg_recdata: *mut ::std::os::raw::c_void,
                arg_len: uint32,
            );
        }
        pgstat_twophase_postabort(arg_xid, arg_info, arg_recdata, arg_len)
    })
}
pub unsafe fn pgstat_send_archiver(arg_xlog: *const ::std::os::raw::c_char, arg_failed: bool) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_send_archiver(arg_xlog: *const ::std::os::raw::c_char, arg_failed: bool);
        }
        pgstat_send_archiver(arg_xlog, arg_failed)
    })
}
pub unsafe fn pgstat_send_bgwriter() {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_send_bgwriter();
        }
        pgstat_send_bgwriter()
    })
}
pub unsafe fn pgstat_fetch_stat_dbentry(arg_dbid: Oid) -> *mut PgStat_StatDBEntry {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_stat_dbentry(arg_dbid: Oid) -> *mut PgStat_StatDBEntry;
        }
        pgstat_fetch_stat_dbentry(arg_dbid)
    })
}
pub unsafe fn pgstat_fetch_stat_tabentry(arg_relid: Oid) -> *mut PgStat_StatTabEntry {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_stat_tabentry(arg_relid: Oid) -> *mut PgStat_StatTabEntry;
        }
        pgstat_fetch_stat_tabentry(arg_relid)
    })
}
pub unsafe fn pgstat_fetch_stat_beentry(arg_beid: ::std::os::raw::c_int) -> *mut PgBackendStatus {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_stat_beentry(arg_beid: ::std::os::raw::c_int) -> *mut PgBackendStatus;
        }
        pgstat_fetch_stat_beentry(arg_beid)
    })
}
pub unsafe fn pgstat_fetch_stat_local_beentry(
    arg_beid: ::std::os::raw::c_int,
) -> *mut LocalPgBackendStatus {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_stat_local_beentry(
                arg_beid: ::std::os::raw::c_int,
            ) -> *mut LocalPgBackendStatus;
        }
        pgstat_fetch_stat_local_beentry(arg_beid)
    })
}
pub unsafe fn pgstat_fetch_stat_funcentry(arg_funcid: Oid) -> *mut PgStat_StatFuncEntry {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_stat_funcentry(arg_funcid: Oid) -> *mut PgStat_StatFuncEntry;
        }
        pgstat_fetch_stat_funcentry(arg_funcid)
    })
}
pub unsafe fn pgstat_fetch_stat_numbackends() -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_stat_numbackends() -> ::std::os::raw::c_int;
        }
        pgstat_fetch_stat_numbackends()
    })
}
pub unsafe fn pgstat_fetch_stat_archiver() -> *mut PgStat_ArchiverStats {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_stat_archiver() -> *mut PgStat_ArchiverStats;
        }
        pgstat_fetch_stat_archiver()
    })
}
pub unsafe fn pgstat_fetch_global() -> *mut PgStat_GlobalStats {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_global() -> *mut PgStat_GlobalStats;
        }
        pgstat_fetch_global()
    })
}
pub unsafe fn pgstat_fetch_slru() -> *mut PgStat_SLRUStats {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_fetch_slru() -> *mut PgStat_SLRUStats;
        }
        pgstat_fetch_slru()
    })
}
pub unsafe fn pgstat_count_slru_page_zeroed(arg_slru_idx: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_slru_page_zeroed(arg_slru_idx: ::std::os::raw::c_int);
        }
        pgstat_count_slru_page_zeroed(arg_slru_idx)
    })
}
pub unsafe fn pgstat_count_slru_page_hit(arg_slru_idx: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_slru_page_hit(arg_slru_idx: ::std::os::raw::c_int);
        }
        pgstat_count_slru_page_hit(arg_slru_idx)
    })
}
pub unsafe fn pgstat_count_slru_page_read(arg_slru_idx: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_slru_page_read(arg_slru_idx: ::std::os::raw::c_int);
        }
        pgstat_count_slru_page_read(arg_slru_idx)
    })
}
pub unsafe fn pgstat_count_slru_page_written(arg_slru_idx: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_slru_page_written(arg_slru_idx: ::std::os::raw::c_int);
        }
        pgstat_count_slru_page_written(arg_slru_idx)
    })
}
pub unsafe fn pgstat_count_slru_page_exists(arg_slru_idx: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_slru_page_exists(arg_slru_idx: ::std::os::raw::c_int);
        }
        pgstat_count_slru_page_exists(arg_slru_idx)
    })
}
pub unsafe fn pgstat_count_slru_flush(arg_slru_idx: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_slru_flush(arg_slru_idx: ::std::os::raw::c_int);
        }
        pgstat_count_slru_flush(arg_slru_idx)
    })
}
pub unsafe fn pgstat_count_slru_truncate(arg_slru_idx: ::std::os::raw::c_int) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_count_slru_truncate(arg_slru_idx: ::std::os::raw::c_int);
        }
        pgstat_count_slru_truncate(arg_slru_idx)
    })
}
pub unsafe fn pgstat_slru_name(
    arg_slru_idx: ::std::os::raw::c_int,
) -> *const ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_slru_name(
                arg_slru_idx: ::std::os::raw::c_int,
            ) -> *const ::std::os::raw::c_char;
        }
        pgstat_slru_name(arg_slru_idx)
    })
}
pub unsafe fn pgstat_slru_index(arg_name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn pgstat_slru_index(arg_name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
        }
        pgstat_slru_index(arg_name)
    })
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanKeyData {
    pub sk_flags: ::std::os::raw::c_int,
    pub sk_attno: AttrNumber,
    pub sk_strategy: StrategyNumber,
    pub sk_subtype: Oid,
    pub sk_collation: Oid,
    pub sk_func: FmgrInfo,
    pub sk_argument: Datum,
}
impl Default for ScanKeyData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ScanKey = *mut ScanKeyData;
pub unsafe fn ScanKeyInit(
    arg_entry: ScanKey,
    arg_attributeNumber: AttrNumber,
    arg_strategy: StrategyNumber,
    arg_procedure: RegProcedure,
    arg_argument: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ScanKeyInit(
                arg_entry: ScanKey,
                arg_attributeNumber: AttrNumber,
                arg_strategy: StrategyNumber,
                arg_procedure: RegProcedure,
                arg_argument: Datum,
            );
        }
        ScanKeyInit(arg_entry, arg_attributeNumber, arg_strategy, arg_procedure, arg_argument)
    })
}
pub unsafe fn ScanKeyEntryInitialize(
    arg_entry: ScanKey,
    arg_flags: ::std::os::raw::c_int,
    arg_attributeNumber: AttrNumber,
    arg_strategy: StrategyNumber,
    arg_subtype: Oid,
    arg_collation: Oid,
    arg_procedure: RegProcedure,
    arg_argument: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ScanKeyEntryInitialize(
                arg_entry: ScanKey,
                arg_flags: ::std::os::raw::c_int,
                arg_attributeNumber: AttrNumber,
                arg_strategy: StrategyNumber,
                arg_subtype: Oid,
                arg_collation: Oid,
                arg_procedure: RegProcedure,
                arg_argument: Datum,
            );
        }
        ScanKeyEntryInitialize(
            arg_entry,
            arg_flags,
            arg_attributeNumber,
            arg_strategy,
            arg_subtype,
            arg_collation,
            arg_procedure,
            arg_argument,
        )
    })
}
pub unsafe fn ScanKeyEntryInitializeWithInfo(
    arg_entry: ScanKey,
    arg_flags: ::std::os::raw::c_int,
    arg_attributeNumber: AttrNumber,
    arg_strategy: StrategyNumber,
    arg_subtype: Oid,
    arg_collation: Oid,
    arg_finfo: *mut FmgrInfo,
    arg_argument: Datum,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn ScanKeyEntryInitializeWithInfo(
                arg_entry: ScanKey,
                arg_flags: ::std::os::raw::c_int,
                arg_attributeNumber: AttrNumber,
                arg_strategy: StrategyNumber,
                arg_subtype: Oid,
                arg_collation: Oid,
                arg_finfo: *mut FmgrInfo,
                arg_argument: Datum,
            );
        }
        ScanKeyEntryInitializeWithInfo(
            arg_entry,
            arg_flags,
            arg_attributeNumber,
            arg_strategy,
            arg_subtype,
            arg_collation,
            arg_finfo,
            arg_argument,
        )
    })
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexBuildResult {
    pub heap_tuples: f64,
    pub index_tuples: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexVacuumInfo {
    pub index: Relation,
    pub analyze_only: bool,
    pub report_progress: bool,
    pub estimated_count: bool,
    pub message_level: ::std::os::raw::c_int,
    pub num_heap_tuples: f64,
    pub strategy: BufferAccessStrategy,
}
impl Default for IndexVacuumInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexBulkDeleteResult {
    pub num_pages: BlockNumber,
    pub pages_removed: BlockNumber,
    pub estimated_count: bool,
    pub num_index_tuples: f64,
    pub tuples_removed: f64,
    pub pages_deleted: BlockNumber,
    pub pages_free: BlockNumber,
}
pub type IndexBulkDeleteCallback = ::std::option::Option<
    unsafe extern "C" fn(itemptr: ItemPointer, state: *mut ::std::os::raw::c_void) -> bool,
>;
pub type IndexScanDesc = *mut IndexScanDescData;
pub type SysScanDesc = *mut SysScanDescData;
pub type ParallelIndexScanDesc = *mut ParallelIndexScanDescData;
pub const IndexUniqueCheck_UNIQUE_CHECK_NO: IndexUniqueCheck = 0;
pub const IndexUniqueCheck_UNIQUE_CHECK_YES: IndexUniqueCheck = 1;
pub const IndexUniqueCheck_UNIQUE_CHECK_PARTIAL: IndexUniqueCheck = 2;
pub const IndexUniqueCheck_UNIQUE_CHECK_EXISTING: IndexUniqueCheck = 3;
pub type IndexUniqueCheck = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexOrderByDistance {
    pub value: f64,
    pub isnull: bool,
}
pub unsafe fn index_open(arg_relationId: Oid, arg_lockmode: LOCKMODE) -> Relation {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_open(arg_relationId: Oid, arg_lockmode: LOCKMODE) -> Relation;
        }
        index_open(arg_relationId, arg_lockmode)
    })
}
pub unsafe fn index_close(arg_relation: Relation, arg_lockmode: LOCKMODE) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_close(arg_relation: Relation, arg_lockmode: LOCKMODE);
        }
        index_close(arg_relation, arg_lockmode)
    })
}
pub unsafe fn index_insert(
    arg_indexRelation: Relation,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
    arg_heap_t_ctid: ItemPointer,
    arg_heapRelation: Relation,
    arg_checkUnique: IndexUniqueCheck,
    arg_indexInfo: *mut IndexInfo,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_insert(
                arg_indexRelation: Relation,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
                arg_heap_t_ctid: ItemPointer,
                arg_heapRelation: Relation,
                arg_checkUnique: IndexUniqueCheck,
                arg_indexInfo: *mut IndexInfo,
            ) -> bool;
        }
        index_insert(
            arg_indexRelation,
            arg_values,
            arg_isnull,
            arg_heap_t_ctid,
            arg_heapRelation,
            arg_checkUnique,
            arg_indexInfo,
        )
    })
}
pub unsafe fn index_beginscan(
    arg_heapRelation: Relation,
    arg_indexRelation: Relation,
    arg_snapshot: Snapshot,
    arg_nkeys: ::std::os::raw::c_int,
    arg_norderbys: ::std::os::raw::c_int,
) -> IndexScanDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_beginscan(
                arg_heapRelation: Relation,
                arg_indexRelation: Relation,
                arg_snapshot: Snapshot,
                arg_nkeys: ::std::os::raw::c_int,
                arg_norderbys: ::std::os::raw::c_int,
            ) -> IndexScanDesc;
        }
        index_beginscan(arg_heapRelation, arg_indexRelation, arg_snapshot, arg_nkeys, arg_norderbys)
    })
}
pub unsafe fn index_beginscan_bitmap(
    arg_indexRelation: Relation,
    arg_snapshot: Snapshot,
    arg_nkeys: ::std::os::raw::c_int,
) -> IndexScanDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_beginscan_bitmap(
                arg_indexRelation: Relation,
                arg_snapshot: Snapshot,
                arg_nkeys: ::std::os::raw::c_int,
            ) -> IndexScanDesc;
        }
        index_beginscan_bitmap(arg_indexRelation, arg_snapshot, arg_nkeys)
    })
}
pub unsafe fn index_rescan(
    arg_scan: IndexScanDesc,
    arg_keys: ScanKey,
    arg_nkeys: ::std::os::raw::c_int,
    arg_orderbys: ScanKey,
    arg_norderbys: ::std::os::raw::c_int,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_rescan(
                arg_scan: IndexScanDesc,
                arg_keys: ScanKey,
                arg_nkeys: ::std::os::raw::c_int,
                arg_orderbys: ScanKey,
                arg_norderbys: ::std::os::raw::c_int,
            );
        }
        index_rescan(arg_scan, arg_keys, arg_nkeys, arg_orderbys, arg_norderbys)
    })
}
pub unsafe fn index_endscan(arg_scan: IndexScanDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_endscan(arg_scan: IndexScanDesc);
        }
        index_endscan(arg_scan)
    })
}
pub unsafe fn index_markpos(arg_scan: IndexScanDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_markpos(arg_scan: IndexScanDesc);
        }
        index_markpos(arg_scan)
    })
}
pub unsafe fn index_restrpos(arg_scan: IndexScanDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_restrpos(arg_scan: IndexScanDesc);
        }
        index_restrpos(arg_scan)
    })
}
pub unsafe fn index_parallelscan_estimate(arg_indexrel: Relation, arg_snapshot: Snapshot) -> Size {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_parallelscan_estimate(arg_indexrel: Relation, arg_snapshot: Snapshot) -> Size;
        }
        index_parallelscan_estimate(arg_indexrel, arg_snapshot)
    })
}
pub unsafe fn index_parallelscan_initialize(
    arg_heaprel: Relation,
    arg_indexrel: Relation,
    arg_snapshot: Snapshot,
    arg_target: ParallelIndexScanDesc,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_parallelscan_initialize(
                arg_heaprel: Relation,
                arg_indexrel: Relation,
                arg_snapshot: Snapshot,
                arg_target: ParallelIndexScanDesc,
            );
        }
        index_parallelscan_initialize(arg_heaprel, arg_indexrel, arg_snapshot, arg_target)
    })
}
pub unsafe fn index_parallelrescan(arg_scan: IndexScanDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_parallelrescan(arg_scan: IndexScanDesc);
        }
        index_parallelrescan(arg_scan)
    })
}
pub unsafe fn index_beginscan_parallel(
    arg_heaprel: Relation,
    arg_indexrel: Relation,
    arg_nkeys: ::std::os::raw::c_int,
    arg_norderbys: ::std::os::raw::c_int,
    arg_pscan: ParallelIndexScanDesc,
) -> IndexScanDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_beginscan_parallel(
                arg_heaprel: Relation,
                arg_indexrel: Relation,
                arg_nkeys: ::std::os::raw::c_int,
                arg_norderbys: ::std::os::raw::c_int,
                arg_pscan: ParallelIndexScanDesc,
            ) -> IndexScanDesc;
        }
        index_beginscan_parallel(arg_heaprel, arg_indexrel, arg_nkeys, arg_norderbys, arg_pscan)
    })
}
pub unsafe fn index_getnext_tid(
    arg_scan: IndexScanDesc,
    arg_direction: ScanDirection,
) -> ItemPointer {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_getnext_tid(
                arg_scan: IndexScanDesc,
                arg_direction: ScanDirection,
            ) -> ItemPointer;
        }
        index_getnext_tid(arg_scan, arg_direction)
    })
}
pub unsafe fn index_fetch_heap(arg_scan: IndexScanDesc, arg_slot: *mut TupleTableSlot) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_fetch_heap(arg_scan: IndexScanDesc, arg_slot: *mut TupleTableSlot) -> bool;
        }
        index_fetch_heap(arg_scan, arg_slot)
    })
}
pub unsafe fn index_getnext_slot(
    arg_scan: IndexScanDesc,
    arg_direction: ScanDirection,
    arg_slot: *mut TupleTableSlot,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_getnext_slot(
                arg_scan: IndexScanDesc,
                arg_direction: ScanDirection,
                arg_slot: *mut TupleTableSlot,
            ) -> bool;
        }
        index_getnext_slot(arg_scan, arg_direction, arg_slot)
    })
}
pub unsafe fn index_getbitmap(arg_scan: IndexScanDesc, arg_bitmap: *mut TIDBitmap) -> int64 {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_getbitmap(arg_scan: IndexScanDesc, arg_bitmap: *mut TIDBitmap) -> int64;
        }
        index_getbitmap(arg_scan, arg_bitmap)
    })
}
pub unsafe fn index_bulk_delete(
    arg_info: *mut IndexVacuumInfo,
    arg_stats: *mut IndexBulkDeleteResult,
    arg_callback: IndexBulkDeleteCallback,
    arg_callback_state: *mut ::std::os::raw::c_void,
) -> *mut IndexBulkDeleteResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_bulk_delete(
                arg_info: *mut IndexVacuumInfo,
                arg_stats: *mut IndexBulkDeleteResult,
                arg_callback: IndexBulkDeleteCallback,
                arg_callback_state: *mut ::std::os::raw::c_void,
            ) -> *mut IndexBulkDeleteResult;
        }
        index_bulk_delete(arg_info, arg_stats, arg_callback, arg_callback_state)
    })
}
pub unsafe fn index_vacuum_cleanup(
    arg_info: *mut IndexVacuumInfo,
    arg_stats: *mut IndexBulkDeleteResult,
) -> *mut IndexBulkDeleteResult {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_vacuum_cleanup(
                arg_info: *mut IndexVacuumInfo,
                arg_stats: *mut IndexBulkDeleteResult,
            ) -> *mut IndexBulkDeleteResult;
        }
        index_vacuum_cleanup(arg_info, arg_stats)
    })
}
pub unsafe fn index_can_return(
    arg_indexRelation: Relation,
    arg_attno: ::std::os::raw::c_int,
) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_can_return(
                arg_indexRelation: Relation,
                arg_attno: ::std::os::raw::c_int,
            ) -> bool;
        }
        index_can_return(arg_indexRelation, arg_attno)
    })
}
pub unsafe fn index_getprocid(
    arg_irel: Relation,
    arg_attnum: AttrNumber,
    arg_procnum: uint16,
) -> RegProcedure {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_getprocid(
                arg_irel: Relation,
                arg_attnum: AttrNumber,
                arg_procnum: uint16,
            ) -> RegProcedure;
        }
        index_getprocid(arg_irel, arg_attnum, arg_procnum)
    })
}
pub unsafe fn index_getprocinfo(
    arg_irel: Relation,
    arg_attnum: AttrNumber,
    arg_procnum: uint16,
) -> *mut FmgrInfo {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_getprocinfo(
                arg_irel: Relation,
                arg_attnum: AttrNumber,
                arg_procnum: uint16,
            ) -> *mut FmgrInfo;
        }
        index_getprocinfo(arg_irel, arg_attnum, arg_procnum)
    })
}
pub unsafe fn index_store_float8_orderby_distances(
    arg_scan: IndexScanDesc,
    arg_orderByTypes: *mut Oid,
    arg_distances: *mut IndexOrderByDistance,
    arg_recheckOrderBy: bool,
) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_store_float8_orderby_distances(
                arg_scan: IndexScanDesc,
                arg_orderByTypes: *mut Oid,
                arg_distances: *mut IndexOrderByDistance,
                arg_recheckOrderBy: bool,
            );
        }
        index_store_float8_orderby_distances(
            arg_scan,
            arg_orderByTypes,
            arg_distances,
            arg_recheckOrderBy,
        )
    })
}
pub unsafe fn index_opclass_options(
    arg_relation: Relation,
    arg_attnum: AttrNumber,
    arg_attoptions: Datum,
    arg_validate: bool,
) -> *mut bytea {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_opclass_options(
                arg_relation: Relation,
                arg_attnum: AttrNumber,
                arg_attoptions: Datum,
                arg_validate: bool,
            ) -> *mut bytea;
        }
        index_opclass_options(arg_relation, arg_attnum, arg_attoptions, arg_validate)
    })
}
pub unsafe fn RelationGetIndexScan(
    arg_indexRelation: Relation,
    arg_nkeys: ::std::os::raw::c_int,
    arg_norderbys: ::std::os::raw::c_int,
) -> IndexScanDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn RelationGetIndexScan(
                arg_indexRelation: Relation,
                arg_nkeys: ::std::os::raw::c_int,
                arg_norderbys: ::std::os::raw::c_int,
            ) -> IndexScanDesc;
        }
        RelationGetIndexScan(arg_indexRelation, arg_nkeys, arg_norderbys)
    })
}
pub unsafe fn IndexScanEnd(arg_scan: IndexScanDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn IndexScanEnd(arg_scan: IndexScanDesc);
        }
        IndexScanEnd(arg_scan)
    })
}
pub unsafe fn BuildIndexValueDescription(
    arg_indexRelation: Relation,
    arg_values: *mut Datum,
    arg_isnull: *mut bool,
) -> *mut ::std::os::raw::c_char {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn BuildIndexValueDescription(
                arg_indexRelation: Relation,
                arg_values: *mut Datum,
                arg_isnull: *mut bool,
            ) -> *mut ::std::os::raw::c_char;
        }
        BuildIndexValueDescription(arg_indexRelation, arg_values, arg_isnull)
    })
}
pub unsafe fn index_compute_xid_horizon_for_tuples(
    arg_irel: Relation,
    arg_hrel: Relation,
    arg_ibuf: Buffer,
    arg_itemnos: *mut OffsetNumber,
    arg_nitems: ::std::os::raw::c_int,
) -> TransactionId {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn index_compute_xid_horizon_for_tuples(
                arg_irel: Relation,
                arg_hrel: Relation,
                arg_ibuf: Buffer,
                arg_itemnos: *mut OffsetNumber,
                arg_nitems: ::std::os::raw::c_int,
            ) -> TransactionId;
        }
        index_compute_xid_horizon_for_tuples(arg_irel, arg_hrel, arg_ibuf, arg_itemnos, arg_nitems)
    })
}
pub unsafe fn systable_beginscan(
    arg_heapRelation: Relation,
    arg_indexId: Oid,
    arg_indexOK: bool,
    arg_snapshot: Snapshot,
    arg_nkeys: ::std::os::raw::c_int,
    arg_key: ScanKey,
) -> SysScanDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn systable_beginscan(
                arg_heapRelation: Relation,
                arg_indexId: Oid,
                arg_indexOK: bool,
                arg_snapshot: Snapshot,
                arg_nkeys: ::std::os::raw::c_int,
                arg_key: ScanKey,
            ) -> SysScanDesc;
        }
        systable_beginscan(
            arg_heapRelation,
            arg_indexId,
            arg_indexOK,
            arg_snapshot,
            arg_nkeys,
            arg_key,
        )
    })
}
pub unsafe fn systable_getnext(arg_sysscan: SysScanDesc) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn systable_getnext(arg_sysscan: SysScanDesc) -> HeapTuple;
        }
        systable_getnext(arg_sysscan)
    })
}
pub unsafe fn systable_recheck_tuple(arg_sysscan: SysScanDesc, arg_tup: HeapTuple) -> bool {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn systable_recheck_tuple(arg_sysscan: SysScanDesc, arg_tup: HeapTuple) -> bool;
        }
        systable_recheck_tuple(arg_sysscan, arg_tup)
    })
}
pub unsafe fn systable_endscan(arg_sysscan: SysScanDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn systable_endscan(arg_sysscan: SysScanDesc);
        }
        systable_endscan(arg_sysscan)
    })
}
pub unsafe fn systable_beginscan_ordered(
    arg_heapRelation: Relation,
    arg_indexRelation: Relation,
    arg_snapshot: Snapshot,
    arg_nkeys: ::std::os::raw::c_int,
    arg_key: ScanKey,
) -> SysScanDesc {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn systable_beginscan_ordered(
                arg_heapRelation: Relation,
                arg_indexRelation: Relation,
                arg_snapshot: Snapshot,
                arg_nkeys: ::std::os::raw::c_int,
                arg_key: ScanKey,
            ) -> SysScanDesc;
        }
        systable_beginscan_ordered(
            arg_heapRelation,
            arg_indexRelation,
            arg_snapshot,
            arg_nkeys,
            arg_key,
        )
    })
}
pub unsafe fn systable_getnext_ordered(
    arg_sysscan: SysScanDesc,
    arg_direction: ScanDirection,
) -> HeapTuple {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn systable_getnext_ordered(
                arg_sysscan: SysScanDesc,
                arg_direction: ScanDirection,
            ) -> HeapTuple;
        }
        systable_getnext_ordered(arg_sysscan, arg_direction)
    })
}
pub unsafe fn systable_endscan_ordered(arg_sysscan: SysScanDesc) {
    crate::submodules::setjmp::pg_guard_ffi_boundary(move || {
        extern "C" {
            fn systable_endscan_ordered(arg_sysscan: SysScanDesc);
        }
        systable_endscan_ordered(arg_sysscan)
    })
}
pub const IndexAMProperty_AMPROP_UNKNOWN: IndexAMProperty = 0;
pub const IndexAMProperty_AMPROP_ASC: IndexAMProperty = 1;
pub const IndexAMProperty_AMPROP_DESC: IndexAMProperty = 2;
pub const IndexAMProperty_AMPROP_NULLS_FIRST: IndexAMProperty = 3;
pub const IndexAMProperty_AMPROP_NULLS_LAST: IndexAMProperty = 4;
pub const IndexAMProperty_AMPROP_ORDERABLE: IndexAMProperty = 5;
pub const IndexAMProperty_AMPROP_DISTANCE_ORDERABLE: IndexAMProperty = 6;
pub const IndexAMProperty_AMPROP_RETURNABLE: IndexAMProperty = 7;
pub const IndexAMProperty_AMPROP_SEARCH_ARRAY: IndexAMProperty = 8;
pub const IndexAMProperty_AMPROP_SEARCH_NULLS: IndexAMProperty = 9;
pub const IndexAMProperty_AMPROP_CLUSTERABLE: IndexAMProperty = 10;
pub const IndexAMProperty_AMPROP_INDEX_SCAN: IndexAMProperty = 11;
pub const IndexAMProperty_AMPROP_BITMAP_SCAN: IndexAMProperty = 12;
pub const IndexAMProperty_AMPROP_BACKWARD_SCAN: IndexAMProperty = 13;
pub const IndexAMProperty_AMPROP_CAN_ORDER: IndexAMProperty = 14;
pub const IndexAMProperty_AMPROP_CAN_UNIQUE: IndexAMProperty = 15;
pub const IndexAMProperty_AMPROP_CAN_MULTI_COL: IndexAMProperty = 16;
pub const IndexAMProperty_AMPROP_CAN_EXCLUDE: IndexAMProperty = 17;
pub const IndexAMProperty_AMPROP_CAN_INCLUDE: IndexAMProperty = 18;
pub type IndexAMProperty = ::std::os::raw::c_uint;
pub type ambuild_function = ::std::option::Option<
    unsafe extern "C" fn(
        heapRelation: Relation,
        indexRelation: Relation,
        indexInfo: *mut IndexInfo,
    ) -> *mut IndexBuildResult,
>;
pub type ambuildempty_function =
    ::std::option::Option<unsafe extern "C" fn(indexRelation: Relation)>;
pub type aminsert_function = ::std::option::Option<
    unsafe extern "C" fn(
        indexRelation: Relation,
        values: *mut Datum,
        isnull: *mut bool,
        heap_tid: ItemPointer,
        heapRelation: Relation,
        checkUnique: IndexUniqueCheck,
        indexInfo: *mut IndexInfo,
    ) -> bool,
>;
pub type ambulkdelete_function = ::std::option::Option<
    unsafe extern "C" fn(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
        callback: IndexBulkDeleteCallback,
        callback_state: *mut ::std::os::raw::c_void,
    ) -> *mut IndexBulkDeleteResult,
>;
pub type amvacuumcleanup_function = ::std::option::Option<
    unsafe extern "C" fn(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
    ) -> *mut IndexBulkDeleteResult,
>;
pub type amcanreturn_function = ::std::option::Option<
    unsafe extern "C" fn(indexRelation: Relation, attno: ::std::os::raw::c_int) -> bool,
>;
pub type amcostestimate_function = ::std::option::Option<
    unsafe extern "C" fn(
        root: *mut PlannerInfo,
        path: *mut IndexPath,
        loop_count: f64,
        indexStartupCost: *mut Cost,
        indexTotalCost: *mut Cost,
        indexSelectivity: *mut Selectivity,
        indexCorrelation: *mut f64,
        indexPages: *mut f64,
    ),
>;
pub t