package sshconf

// Keyword is a known SSH config keyword.
type Keyword string

const (
	Include                                 Keyword = "Include"
	HostKeyword                             Keyword = "Host"
	MatchKeyword                            Keyword = "Match"
	AddressFamilyKeyword                    Keyword = "AddressFamily"
	BatchModeKeyword                        Keyword = "BatchMode"
	BindAddressKeyword                      Keyword = "BindAddress"
	CanonicalDomainsKeyword                 Keyword = "CanonicalDomains"
	CanonicalizeFallbackLocalKeyword        Keyword = "CanonicalizeFallbackLocal"
	CanonicalizeHostnameKeyword             Keyword = "CanonicalizeHostname"
	CanonicalizeMaxDotsKeyword              Keyword = "CanonicalizeMaxDots"
	CanonicalizePermittedCNAMEsKeyword      Keyword = "CanonicalizePermittedCNAMEs"
	ChallengeResponseAuthenticationKeyword  Keyword = "ChallengeResponseAuthentication"
	CheckHostIPKeyword                      Keyword = "CheckHostIP"
	CipherKeyword                           Keyword = "Cipher"
	CiphersKeyword                          Keyword = "Ciphers"
	ClearAllForwardingsKeyword              Keyword = "ClearAllForwardings"
	CompressionKeyword                      Keyword = "Compression"
	CompressionLevelKeyword                 Keyword = "CompressionLevel"
	ConnectionAttemptsKeyword               Keyword = "ConnectionAttempts"
	ConnectTimeoutKeyword                   Keyword = "ConnectTimeout"
	ControlMasterKeyword                    Keyword = "ControlMaster"
	ControlPathKeyword                      Keyword = "ControlPath"
	ControlPersistKeyword                   Keyword = "ControlPersist"
	DynamicForwardKeyword                   Keyword = "DynamicForward"
	EnableSSHKeysignKeyword                 Keyword = "EnableSSHKeysign"
	EscapeCharKeyword                       Keyword = "EscapeChar"
	ExitOnForwardFailureKeyword             Keyword = "ExitOnForwardFailure"
	FingerprintHashKeyword                  Keyword = "FingerprintHash"
	ForwardAgentKeyword                     Keyword = "ForwardAgent"
	ForwardX11Keyword                       Keyword = "ForwardX11"
	ForwardX11TimeoutKeyword                Keyword = "ForwardX11Timeout"
	ForwardX11TrustedKeyword                Keyword = "ForwardX11Trusted"
	GatewayPortsKeyword                     Keyword = "GatewayPorts"
	GlobalKnownHostsFileKeyword             Keyword = "GlobalKnownHostsFile"
	GSSAPIAuthenticationKeyword             Keyword = "GSSAPIAuthentication"
	GSSAPIDelegateCredentialsKeyword        Keyword = "GSSAPIDelegateCredentials"
	HashKnownHostsKeyword                   Keyword = "HashKnownHosts"
	HostbasedAuthenticationKeyword          Keyword = "HostbasedAuthentication"
	HostbasedKeyTypesKeyword                Keyword = "HostbasedKeyTypes"
	HostKeyAlgorithmsKeyword                Keyword = "HostKeyAlgorithms"
	HostKeyAliasKeyword                     Keyword = "HostKeyAlias"
	HostNameKeyword                         Keyword = "HostName"
	IdentitiesOnlyKeyword                   Keyword = "IdentitiesOnly"
	IdentityFileKeyword                     Keyword = "IdentityFile"
	IgnoreUnknownKeyword                    Keyword = "IgnoreUnknown"
	IPQoSKeyword                            Keyword = "IPQoS"
	KbdInteractiveAuthenticationKeyword     Keyword = "KbdInteractiveAuthentication"
	KbdInteractiveDevicesKeyword            Keyword = "KbdInteractiveDevices"
	KexAlgorithmsKeyword                    Keyword = "KexAlgorithms"
	LocalCommandKeyword                     Keyword = "LocalCommand"
	LocalForwardKeyword                     Keyword = "LocalForward"
	LogLevelKeyword                         Keyword = "LogLevel"
	MACsKeyword                             Keyword = "MACs"
	NoHostAuthenticationForLocalhostKeyword Keyword = "NoHostAuthenticationForLocalhost"
	NumberOfPasswordPromptsKeyword          Keyword = "NumberOfPasswordPrompts"
	PasswordAuthenticationKeyword           Keyword = "PasswordAuthentication"
	PermitLocalCommandKeyword               Keyword = "PermitLocalCommand"
	PKCS11ProviderKeyword                   Keyword = "PKCS11Provider"
	PortKeyword                             Keyword = "Port"
	PreferredAuthenticationsKeyword         Keyword = "PreferredAuthentications"
	ProtocolKeyword                         Keyword = "Protocol"
	ProxyCommandKeyword                     Keyword = "ProxyCommand"
	ProxyUseFdpassKeyword                   Keyword = "ProxyUseFdpass"
	PubkeyAuthenticationKeyword             Keyword = "PubkeyAuthentication"
	RekeyLimitKeyword                       Keyword = "RekeyLimit"
	RemoteForwardKeyword                    Keyword = "RemoteForward"
	RequestTTYKeyword                       Keyword = "RequestTTY"
	RevokedHostKeysKeyword                  Keyword = "RevokedHostKeys"
	RhostsRSAAuthenticationKeyword          Keyword = "RhostsRSAAuthentication"
	RSAAuthenticationKeyword                Keyword = "RSAAuthentication"
	SendEnvKeyword                          Keyword = "SendEnv"
	ServerAliveCountMaxKeyword              Keyword = "ServerAliveCountMax"
	ServerAliveIntervalKeyword              Keyword = "ServerAliveInterval"
	StreamLocalBindMaskKeyword              Keyword = "StreamLocalBindMask"
	StreamLocalBindUnlinkKeyword            Keyword = "StreamLocalBindUnlink"
	StrictHostKeyCheckingKeyword            Keyword = "StrictHostKeyChecking"
	TCPKeepAliveKeyword                     Keyword = "TCPKeepAlive"
	TunnelKeyword                           Keyword = "Tunnel"
	TunnelDeviceKeyword                     Keyword = "TunnelDevice"
	UpdateHostKeysKeyword                   Keyword = "UpdateHostKeys"
	UsePrivilegedPortKeyword                Keyword = "UsePrivilegedPort"
	UserKeyword                             Keyword = "User"
	UserKnownHostsFileKeyword               Keyword = "UserKnownHostsFile"
	VerifyHostKeyDNSKeyword                 Keyword = "VerifyHostKeyDNS"
	VisualHostKeyKeyword                    Keyword = "VisualHostKey"
	XAuthLocationKeyword                    Keyword = "XAuthLocation"
)
