# How to contribute

Want to show Apache JMeter some love? Help out by contributing!

## :beetle: Found a bug?
Log it in our bugzilla:

* *http://jmeter.apache.org/issues.html* 
* or send a note to the *user mailing list*. 
Be sure to include all relevant information, like the versions of JMeter you’re using as long as Java version. 
A Test plan  that caused the issue as well as any error messages are also very helpful.

## :question: Need help?
Simply contact:

* our user mailing list *http://jmeter.apache.org/mail2.html#JMeterUser* 
* or ask question on [stackoverflow](https://stackoverflow.com/questions/tagged/jmeter).

## :bar_chart: What needs to be developed?

See:

* https://bz.apache.org/bugzilla/buglist.cgi?bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&bug_status=NEEDINFO&bug_severity=Blocker&bug_severity=Critical&bug_severity=Major&bug_severity=Normal&bug_severity=Regression&bug_severity=Minor&bug_severity=Trivial&product=JMeter&order=Bug%20Number&list_id=164231
* https://bz.apache.org/bugzilla/buglist.cgi?bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&bug_status=NEEDINFO&bug_severity=Enhancement&product=JMeter&order=Bug%20Number&list_id=164232

## :star2: Have a patch?
The best way to make sure your issue or feature is addressed is to submit a patch.
We accept patches through: 

* pull requests
* patch attached to bugzilla.

However, before sending a patch, please make sure that the following applies:

* Your commit message is descriptive.
* Your patch doesn't have useless merge commits.
* Your coding style is similar to ours.
* Your patch is 100% tested. JUnit are welcome. 
* All tests checks pass (run `ant test`)
* You understand that we're very grateful for your patch!

## :heart: Adding something new?
We do love to enhance Apache JMeter with you to become more powerful! 
The best way to workout your idea is to discuss it first at our dev mailing list:

* http://jmeter.apache.org/mail2.html#JMeterDev

Please, if you can, don't just throw us the code of a new feature; lets figure first together 
what would be the best approach regarding the current architecture and future plans, 
before any development. 
This way we all get sure that your idea is aligned with the codebase and you can enjoy 
your happy coding even more :)

## :closed_book: Want to write docs?

Documentation is very valuable to us. 

It is located in **xdocs** folder in XML format. 

You can contribute as you would for code through patch or PR.
