#pragma once

namespace loongarch {

	// Enum representing all LoongArch instruction IDs
	// Each instruction decoded in la64.cpp gets a unique ID
	enum class InstrId : unsigned short {
		INVALID = 0,  // Must be first and zero
		UNIMPLEMENTED,

		// All instructions from la64.cpp
		ADD_D,
		ADDI_D,
		ADDI_W,
		ADDU16I_D,
		ADD_W,
		ALSL_D,
		ALSL_W,
		AMADD_D,
		AMADD_W,
		AMAND_D,
		AMAND_W,
		AMOR_D,
		AMOR_W,
		AMSWAP_D,
		AMSWAP_W,
		AMXOR_D,
		AMXOR_W,
		AND,
		ANDI,
		ANDN,
		B,
		BCEQZ,
		BCNEZ,
		BEQ,
		BEQZ,
		BGE,
		BGEU,
		BITREV_4B,
		BITREV_8B,
		BITREV_D,
		BITREV_W,
		BL,
		BLT,
		BLTU,
		BNE,
		BNEZ,
		BREAK,
		BSTRINS_D,
		BSTRINS_W,
		BSTRPICK_D,
		BSTRPICK_W,
		BYTEPICK_D,
		CLO_D,
		CLO_W,
		CLZ_D,
		CLZ_W,
		CPUCFG,
		CTO_D,
		CTO_W,
		CTZ_D,
		CTZ_W,
		DBAR,
		DIV_D,
		DIV_DU,
		DIV_W,
		DIV_WU,
		EXT_W_B,
		EXT_W_H,
		FABS_D,
		FABS_S,
		FADD_D,
		FADD_S,
		FCLASS_D,
		FCLASS_S,
		FCMP_COND_D,
		FCMP_COND_S,
		FCVT_D_S,
		FCVT_S_D,
		FDIV_D,
		FDIV_S,
		FFINT_D_L,
		FFINT_D_W,
		FFINT_S_L,
		FFINT_S_W,
		FLD_D,
		FLD_S,
		FLDX_D,
		FLDX_S,
		FMADD_D,
		FMADD_S,
		FMAX_D,
		FMAX_S,
		FMIN_D,
		FMIN_S,
		FMOV_D,
		FMOV_S,
		FMSUB_D,
		FMSUB_S,
		FMUL_D,
		FMUL_S,
		FNEG_D,
		FNMADD_D,
		FNMADD_S,
		FNMSUB_D,
		FNMSUB_S,
		FSEL,
		FST_D,
		FST_S,
		FSTX_D,
		FSTX_S,
		FSUB_D,
		FSUB_S,
		FTINTRZ_L_D,
		FTINTRZ_L_S,
		FTINTRZ_W_D,
		FTINTRZ_W_S,
		IBAR,
		JIRL,
		LD_B,
		LD_BU,
		LD_D,
		LD_H,
		LD_HU,
		LDPTR_D,
		LDPTR_W,
		LD_W,
		LD_WU,
		LDX_B,
		LDX_BU,
		LDX_D,
		LDX_H,
		LDX_HU,
		LDX_W,
		LDX_WU,
		LL_D,
		LL_W,
		LU12I_W,
		LU32I_D,
		LU52I_D,
		MASKEQZ,
		MASKNEZ,
		MOD_D,
		MOD_DU,
		MOD_W,
		MOD_WU,
		MOVCF2FR,
		MOVCF2GR,
		MOVFCSR2GR,
		MOVFR2CF,
		MOVFR2GR_D,
		MOVFR2GR_S,
		MOVGR2CF,
		MOVGR2FR_D,
		MOVGR2FR_W,
		MUL_D,
		MULH_D,
		MULH_DU,
		MULH_W,
		MULH_WU,
		MUL_W,
		NOP,
		NOR,
		OR,
		ORI,
		ORN,
		PCADDI,
		PCADDU12I,
		PCADDU18I,
		PCALAU12I,
		PRELD,
		RDTIME_D,
		REVB_2H,
		REVB_2W,
		REVB_4H,
		REVB_D,
		REVH_2W,
		REVH_D,
		ROTR_D,
		ROTRI_D,
		ROTRI_W,
		ROTR_W,
		SC_D,
		SC_W,
		SLL_D,
		SLLI_D,
		SLLI_W,
		SLL_W,
		SLT,
		SLTI,
		SLTU,
		SLTUI,
		SRA_D,
		SRAI_D,
		SRAI_W,
		SRA_W,
		SRL_D,
		SRLI_D,
		SRLI_W,
		SRL_W,
		ST_B,
		ST_D,
		ST_H,
		STPTR_D,
		STPTR_W,
		ST_W,
		STX_B,
		STX_D,
		STX_H,
		STX_W,
		SUB_D,
		SUB_W,
		SYSCALL,
		VADD_B,
		VADD_D,
		VADD_H,
		VADDI_BU,
		VADDI_DU,
		VADDI_HU,
		VADDI_WU,
		VADD_W,
		VAND_V,
		VBITREVI_D,
		VBITSEL_V,
		VFADD_D,
		VFCMP_COND_D,
		VFDIV_D,
		VFMADD_D,
		VFMUL_D,
		VFMUL_S,
		VFNMADD_D,
		VFRSTPI_B,
		VFTINTRZ_L_D,
		VFTINTRZ_W_S,
		VHADDW_D_W,
		VILVH_D,
		VILVL_B,
		VILVL_D,
		VILVL_H,
		VILVL_W,
		VINSGR2VR_B,
		VINSGR2VR_D,
		VINSGR2VR_H,
		VINSGR2VR_W,
		VLD,
		VLDI,
		VLDX,
		VMADD_B,
		VMADD_D,
		VMADD_H,
		VMADD_W,
		VMAX_B,
		VMAX_BU,
		VMAX_D,
		VMAX_DU,
		VMAX_H,
		VMAX_HU,
		VMAX_W,
		VMAX_WU,
		VMIN_B,
		VMIN_BU,
		VMIN_D,
		VMIN_DU,
		VMIN_H,
		VMIN_HU,
		VMIN_W,
		VMIN_WU,
		VMSKNZ_B,
		VMUL_B,
		VMUL_D,
		VMUL_H,
		VMUL_W,
		VNOR_V,
		VORI_B,
		VORN_V,
		VOR_V,
		VPCNT_B,
		VPCNT_D,
		VPCNT_H,
		VPCNT_W,
		VPICKEV_W,
		VPICKVE2GR_B,
		VPICKVE2GR_BU,
		VPICKVE2GR_D,
		VPICKVE2GR_DU,
		VPICKVE2GR_H,
		VPICKVE2GR_HU,
		VPICKVE2GR_W,
		VPICKVE2GR_WU,
		VREPLGR2VR_B,
		VREPLGR2VR_D,
		VREPLGR2VR_H,
		VREPLGR2VR_W,
		VREPLVEI_D,
		VSEQ_B,
		VSEQI_B,
		VSEQI_D,
		VSEQI_H,
		VSEQI_W,
		VSETALLNEZ_B,
		VSETANYEQZ_B,
		VSHUF_B,
		VSLLI_B,
		VSLLI_D,
		VSLLI_H,
		VSLLI_W,
		VSLT_B,
		VSLT_D,
		VSLT_H,
		VSLT_W,
		VST,
		VSTX,
		VSUB_B,
		VSUB_D,
		VSUB_H,
		VSUB_W,
		VXOR_V,
		XOR,
		XORI,
		XVADD_D,
		XVBITREVI_D,
		XVBITSEL_V,
		XVFADD_D,
		XVFCMP_COND_D,
		XVFDIV_D,
		XVFMADD_D,
		XVFMADD_S,
		XVFMSUB_D,
		XVFMSUB_S,
		XVFMUL_D,
		XVFNMADD_D,
		XVFNMADD_S,
		XVFNMSUB_D,
		XVFNMSUB_S,
		XVFSUB_D,
		XVHADDW_D_W,
		XVHADDW_Q_D,
		XVILVH_D,
		XVILVL_D,
		XVLD,
		XVLDI,
		XVLDX,
		XVMAX_BU,
		XVMIN_BU,
		XVMSKNZ_B,
		XVORI_B,
		XVPACKEV_D,
		XVPACKOD_D,
		XVPERMI_D,
		XVPERMI_Q,
		XVPICKEV_D,
		XVPICKEV_W,
		XVPICKOD_D,
		XVPICKVE2GR_W,
		XVPICKVE_W,
		XVREPLGR2VR_B,
		XVREPLVE_D,
		XVSEQ_B,
		XVSETANYEQZ_B,
		XVSETEQZ_V,
		XVST,
		XVSTX,
		XVSUB_W,
		XVXORI_B,
		XVXOR_V,

		MAX_INSTRUCTION_ID
	};

} // namespace loongarch
