// Function pointer array for tailcall dispatch
// This maps bytecodes to function pointers for fast tailcall dispatch
[LA64_BC_INVALID]   = execute_invalid,
[LA64_BC_LD_D]      = la64_ld_d,
[LA64_BC_MOVE]      = la64_move,
[LA64_BC_OR]        = la64_or,
[LA64_BC_ST_D]      = la64_st_d,
[LA64_BC_ADDI_W]    = la64_addi_w,
[LA64_BC_ADDI_D]    = la64_addi_d,
[LA64_BC_ANDI]      = la64_andi,
[LA64_BC_ADD_D]     = la64_add_d,
[LA64_BC_SUB_D]     = la64_sub_d,
[LA64_BC_ORI]       = la64_ori,
[LA64_BC_SLLI_W]    = la64_slli_w,
[LA64_BC_SLLI_D]    = la64_slli_d,
[LA64_BC_LD_BU]     = la64_ld_bu,
[LA64_BC_ST_B]      = la64_st_b,
[LA64_BC_ST_W]      = la64_st_w,
[LA64_BC_PCADDI]    = la64_pcaddi,
[LA64_BC_PCALAU12I] = la64_pcalau12i,
[LA64_BC_LDPTR_D]   = la64_ldptr_d,
[LA64_BC_LDPTR_W]   = la64_ldptr_w,
[LA64_BC_STPTR_D]   = la64_stptr_d,
[LA64_BC_LU12I_W]   = la64_lu12i_w,
[LA64_BC_BSTRPICK_D] = la64_bstrpick_d,
[LA64_BC_AND]       = la64_and,
[LA64_BC_ALSL_D]    = la64_alsl_d,
[LA64_BC_SRLI_D]    = la64_srli_d,
[LA64_BC_LD_B]      = la64_ld_b,
[LA64_BC_STPTR_W]   = la64_stptr_w,
[LA64_BC_LDX_D]     = la64_ldx_d,
[LA64_BC_MASKEQZ]   = la64_maskeqz,
[LA64_BC_MASKNEZ]   = la64_masknez,
[LA64_BC_MUL_D]     = la64_mul_d,
[LA64_BC_SUB_W]     = la64_sub_w,
[LA64_BC_SLL_D]     = la64_sll_d,
[LA64_BC_STX_D]     = la64_stx_d,
[LA64_BC_BSTRPICK_W] = la64_bstrpick_w,
[LA64_BC_SLTU]      = la64_sltu,
[LA64_BC_LDX_W]     = la64_ldx_w,
[LA64_BC_STX_W]     = la64_stx_w,
[LA64_BC_XOR]       = la64_xor,
[LA64_BC_LD_HU]     = la64_ld_hu,
[LA64_BC_ADD_W]     = la64_add_w,
[LA64_BC_SRAI_D]    = la64_srai_d,
[LA64_BC_EXT_W_B]   = la64_ext_w_b,
[LA64_BC_LDX_BU]    = la64_ldx_bu,
[LA64_BC_BSTRINS_D] = la64_bstrins_d,
[LA64_BC_LU32I_D]   = la64_lu32i_d,
[LA64_BC_REVB_2H]   = la64_revb_2h,
[LA64_BC_BYTEPICK_D] = la64_bytepick_d,
[LA64_BC_SLTI]      = la64_slti,
[LA64_BC_ST_H]      = la64_st_h,
[LA64_BC_FLD_D]     = la64_fld_d,
[LA64_BC_FADD_D]    = la64_fadd_d,
[LA64_BC_FMUL_D]    = la64_fmul_d,
[LA64_BC_FST_D]     = la64_fst_d,
[LA64_BC_SRLI_W]    = la64_srli_w,
[LA64_BC_SRL_D]     = la64_srl_d,
[LA64_BC_LU52I_D]   = la64_lu52i_d,
[LA64_BC_XORI]      = la64_xori,
[LA64_BC_SLTUI]     = la64_sltui,
[LA64_BC_LD_H]      = la64_ld_h,
[LA64_BC_LDX_HU]    = la64_ldx_hu,
[LA64_BC_LD_WU]     = la64_ld_wu,
[LA64_BC_PCADDU12I] = la64_pcaddu12i,
[LA64_BC_PCADDU18I] = la64_pcaddu18i,
[LA64_BC_ANDN]      = la64_andn,
[LA64_BC_STX_B]     = la64_stx_b,
[LA64_BC_EXT_W_H]   = la64_ext_w_h,
[LA64_BC_LDX_B]     = la64_ldx_b,
[LA64_BC_SLT]       = la64_slt,
[LA64_BC_ORN]       = la64_orn,
[LA64_BC_MUL_W]     = la64_mul_w,
[LA64_BC_MOD_DU]    = la64_mod_du,
[LA64_BC_REVB_4H]   = la64_revb_4h,
[LA64_BC_LDX_H]     = la64_ldx_h,
[LA64_BC_STX_H]     = la64_stx_h,

// LSX (SIMD) instructions
[LA64_BC_VLD]       = la64_vld,
[LA64_BC_VST]       = la64_vst,
[LA64_BC_VLDX]      = la64_vldx,
[LA64_BC_VSTX]      = la64_vstx,
[LA64_BC_VFADD_D]   = la64_vfadd_d,
[LA64_BC_VFMADD_D]  = la64_vfmadd_d,
[LA64_BC_VHADDW_D_W] = la64_vhaddw_d_w,

// LASX (256-bit) instructions
[LA64_BC_XVLD]      = la64_xvld,
[LA64_BC_XVST]      = la64_xvst,
[LA64_BC_XVLDX]     = la64_xvldx,
[LA64_BC_XVSTX]     = la64_xvstx,

// Floating-point instructions
[LA64_BC_FMADD_D]   = la64_fmadd_d,
[LA64_BC_FLDX_D]    = la64_fldx_d,
[LA64_BC_FSTX_D]    = la64_fstx_d,

[LA64_BC_BEQZ]      = la64_beqz,
[LA64_BC_BNEZ]      = la64_bnez,
[LA64_BC_BCEQZ]     = la64_bceqz,
[LA64_BC_BCNEZ]     = la64_bcnez,
[LA64_BC_BEQ]       = la64_beq,
[LA64_BC_BNE]       = la64_bne,
[LA64_BC_JIRL]      = la64_jirl,
[LA64_BC_B]         = la64_b,
[LA64_BC_BL]        = la64_bl,
[LA64_BC_BLT]       = la64_blt,
[LA64_BC_BGE]       = la64_bge,
[LA64_BC_BLTU]      = la64_bltu,
[LA64_BC_BGEU]      = la64_bgeu,

[LA64_BC_FUNCTION]  = execute_decoded_function,
[LA64_BC_FUNCTION2] = execute_function_extended,
[LA64_BC_SYSCALL]   = la64_syscall,
[LA64_BC_SYSCALLIMM]= la64_syscall_imm,
[LA64_BC_NOP]       = la64_nop,
[LA64_BC_STOP]      = la64_stop,
#ifdef LA_BINARY_TRANSLATION
[LA64_BC_TRANSLATOR]= execute_translated_block,
#endif
[LA64_BC_LIVEPATCH] = execute_livepatch,
