import {PageConfig} from "../../types/language";

export const englishPageConfig: PageConfig = {
    settings: {
        initFailedHint: 'The page content loading failed. Please reload the page.',
        title: 'Settings',
        generalMenu: 'General Settings',
        updaterMenu: 'Update Settings',
        storageMenu: 'Storage Settings',
        shortcutMenu: 'Shortcuts',

        generalTitle: 'General Settings',
        storageTitle: 'Storage Settings',
        shortcutTitle: 'Shortcut Settings',
        updaterTitle: 'Update Settings',

        powerOnSelfStart: 'Power On Self Start',
        replaceGlobalHotkey: 'Replace Global Hotkey',
        autoHideWindow: 'Auto Hide Window',
        alwaysOnTop: 'Window Always Top',
        shortcutKeyOccupationHint: 'The default clipboard shortcut key of the system is already occupied by another program. Please release the shortcut key first.',
        replaceGlobalHotkeyNoPermissionHint: 'Please start the program as an administrator first, then you can modify this setting.',
        replaceGlobalHotkeyLinkHint: 'How to run a program as an administrator',
        replaceGlobalHotkeyHint: 'After opening, the system\'s built-in clipboard function will be disabled. Before uninstalling the program, please turn off this function first. Otherwise, the clipboard function will not be usable. After turning off this function, the default shortcut key will revert to "Alt + C".',
        languages: 'Languages',
        enableTag: 'Enable Tag Function',
        bindTagBtnShowLocation: 'Tag Binding Button Location',
        topRight: 'Top Right',
        bottomRight: 'Bottom Right',

        autoCheckUpdate: 'Automatically Check Updates',
        checkUpdateMode: 'Check Update Mode',
        regularCheck: 'Regular Check',
        afterRunningCheck: 'After Running Check',
        timeInterval: 'Time Interval',
        timeIntervalUnit: 'hours',
        timeIntervalHint: 'Please enter the time interval, the unit is hour, the range is 1 hour to 30 days (720 hours)',
        newVersionAlertMode: 'Detected a new version prompt',
        toast: 'Minor hint',
        dialog: 'Update Window',

        maxHistoryItems: 'Max Record Items',
        maxHistoryItemsHint: 'Limit the upper limit of data storage, 0 means no cleanup, maximum 10000 items',
        dataRetentionDays: 'Max Record Days',
        dataRetentionDaysHint: 'Limit data retention time, exceeding the number of days will automatically clean up, 0 means no cleanup, maximum retention time is 365 days',

        search: 'Search',
        wakeUpRoutine: 'Wake Up Routine',
        emptyShortcutConfig: 'No Shortcut Config',
        resetBtn: 'Reset',
        saveBtn: 'Save',
        restartModalTitle: 'Restart Confirmation',
        restartModalContent: 'The "Replace Global Hotkeys" function will only take effect after restarting the computer. Would you like to restart now?',
        restartModalCancelBtn: 'Restart Later',
        restartModalConfirmBtn: 'Now Restart',
        hardwareAccelerationDialogTitle: 'Restart Required',
        hardwareAccelerationDialogContent: 'Hardware acceleration setting has been changed. Application needs to restart to apply changes.',
        hardwareAccelerationDialogRestartNow: 'Restart Now',
        hardwareAccelerationDialogRestartLater: 'Restart Later',
        editHotkeyModalTitle: 'Edit Shortcut',
        editHotkeyModalHint: 'Press the shortcut key...',
        editHotkeyModalContent: 'Please press the shortcut key combination you want to set',
        editHotkeyModalCancelBtn: 'Cancel',
        editHotkeyModalConfirmBtn: 'Confirm',
        keyAvailableHint: 'The shortcut keys can be used normally.',
        keyNotAvailableHint: 'The shortcut keys are not available. Please check if they are being used by another program.',
        shortcutHint: 'The Win key combined with letter keys are mostly system keys and cannot be directly used. If you need to replace the clipboard function provided by the system, please go to "General Settings" and enable the "Replace Global Hotkeys" setting.',

        saveSuccessMsg: 'Save Success',
        saveFailedMsg: 'Save Failed',
        shortcutSaveErrorMsg: 'Save Shortcut Settings Failed: ',
        resetSuccessMsg: 'Reset Success',
        enableReplaceGlobalHotkeyFailedMsg: 'The "Replace Global Hotkeys" function failed to be enabled. Please confirm if the program was launched as an administrator.',
        disableReplaceGlobalHotkeyFailedMsg: 'The "Replace Global Hotkey" option failed to be closed. Please confirm if the program was launched as an administrator.',
    },
    list: {
        title: 'Clipboard',
        copySuccessMsg: 'Copy Success',
        copyFailedMsg: 'Copy Failed',
        fileNotExistCopyFailedMsg: 'File Not Exist, Copy Failed',
        searchHint: 'Input keywords to search',
        deleteBtn: 'Delete',
        bindTagBtn: 'Bind Tag',
        dataLoading: 'Data Loading...',
        allLoaded: 'All Loaded',
        typeText: 'Text',
        typeCode: 'Code',
        typeFile: 'File',
        registerShortcutKeysErrorHint: 'The registration of the "Wake Up Routine" shortcut key failed. Please check if this shortcut key is already in use. You can make the adjustment on the "Settings - Shortcuts" page here.',
        chars: 'chars',
        empty: 'No clipboard record exists',
        initFailedHint: 'The program initialization failed. Please run the program again.',
        updateTxt: 'New',
        menu: {
            program: 'Program',
            settings: 'Settings',
            reload: 'Reload',
            reloadHint: 'The application is reloading...',
            exit: 'Close',
            exitHint: 'The application is being closed...',
            data: 'Data',
            tagManger: 'Tag Manager',
            dataView: 'Data View',
            search: 'Search',
            dataImport: 'Data Import',
            dataExport: 'Data Export',
            clearData: 'Clear Data',
            clearDataSuccessMsg: 'Clear Data Success',
            clearDataFailedMsg: 'Clear Data Failed',
            themes: 'Themes',
            light: 'Light',
            dark: 'Dark',
            blue: 'Blue',
            pink: 'Pink',
            help: 'Help',
            instructions: 'Instructions',
            updateLog: 'Update Log',
            checkForUpdate: 'Check For Update',
            about: 'About',
        }
    },
    tags: {
        title: 'Tag Manager',
        bindDataHint: 'associated data: ',
        addTitle: 'Add Tag',
        editTitle: 'Edit Tag',
        tagName: 'Tag Name',
        tagNamePlaceholder: 'Please input tag name',
        tagNameHint: 'The label name should not exceed 5 characters. If it does, the extra characters will be hidden. For specific details, please refer to the preview effect.',
        tagColor: 'Tag Color',
        preview: 'Preview effect',
        saveBtn: 'Save',
        cancelBtn: 'Cancel',
        loadFailedMsg: 'Load Tag List Failed',
        tageNameIsNullWarnMsg: 'Tag Name Cannot Be Empty',
        saveSuccessMsg: 'Save Success',
        editSuccessMsg: 'Update Success',
        saveFailedMsg: 'Save Failed',
        editFailedMsg: 'Update Failed',
        deleteSuccessMsg: 'Delete Success',
        deleteFailedMsg: 'Delete Failed',
    },
    about: {
        title: 'About',
        appName: 'Clipboard',
        version: 'Version',
        problemFeedback: 'Problem Feedback',
    },
    update: {
        title: 'Update',
        versionName: 'Version',
        updateNotes: 'No Update Notes',
        notUpdateBtn: 'Not Update',
        reminderText: 'Next reminder time: ',
        days: ' days',
        downloadNowBtn: 'Download Now',
        restartLaterBtn: 'Restart Later',
        restartImmediatelyBtn: 'Restart Immediately',
        viewMoreBtn: 'View More',
        downloadingTitle: 'Downloading Update',
        backupTitle: 'Backing Up User Data',
        backupCompleted: 'Backup Completed',
        alreadyLatestHint: 'It is already the latest version at present',
        checkUpdateErrorHint: 'Check Update Error: ',
    },
    tray: {
        settings: 'Settings',
        checkUpdate: 'Check Update',
        about: 'About',
        restart: 'Restart',
        exit: 'Exit',
        clipboardMonitor: 'Clipboard Monitor',
    },
}