import {PageConfig} from "../../types/language";

// 导出中文页面配置
export const chinesePageConfig: PageConfig = {
    settings: {
        initFailedHint: '页面内容加载失败，请重新打开',
        title: '设置',
        generalMenu: '通用设置',
        storageMenu: '存储设置',
        shortcutMenu: '快捷键',
        updaterMenu: '更新设置',

        generalTitle: '通用设置',
        storageTitle: '存储设置',
        shortcutTitle: '快捷键设置',
        updaterTitle: '更新设置',

        powerOnSelfStart: '开机自启',
        replaceGlobalHotkey: '替换全局热键',
        autoHideWindow: '自动隐藏窗口',
        alwaysOnTop: '窗口始终置顶',
        shortcutKeyOccupationHint: '系统默认剪贴板快捷键被其他程序占用，请先释放快捷键',
        replaceGlobalHotkeyNoPermissionHint: '请先以管理员身份启动程序，才能修改此设置',
        replaceGlobalHotkeyLinkHint: '如何以管理员身份运行程序',
        replaceGlobalHotkeyHint: '打开后会关闭系统自带的剪贴板功能，卸载程序前请先关闭此功能，否则无法使用剪贴板功能，关闭此功能后，默认快捷键会恢复成“Alt + C”',
        languages: '语言',
        enableTag: '启用标签功能',
        bindTagBtnShowLocation: '标签绑定按钮位置',
        topRight: '右上角',
        bottomRight: '右下角',

        autoCheckUpdate: '自动检查更新',
        checkUpdateMode: '检查更新方式',
        regularCheck: '定时检查',
        afterRunningCheck: '启动时检查',
        timeInterval: '检查时间间隔',
        timeIntervalUnit: '小时',
        timeIntervalHint: '设置多长时间检查一次，单位：小时，可设置范围为：1小时-30天（720小时）',
        newVersionAlertMode: '检查到新版本提示',
        toast: '轻提示',
        dialog: '更新窗口',

        maxHistoryItems: '记录保留条数',
        maxHistoryItemsHint: '限制数据存储的上限，超过条数上限将自动清理旧数据，0表示不清理，最多保留10000条',
        dataRetentionDays: '记录保留时长',
        dataRetentionDaysHint: '限制数据保留时长，超过天数上限将自动清理，0表示不清理，最大保留365天',

        search: '搜索',
        wakeUpRoutine: '唤醒程序',
        emptyShortcutConfig: '暂无快捷键配置',
        resetBtn: '重置',
        saveBtn: '保存',
        restartModalTitle: '重启确认',
        restartModalContent: '“替换全局热键”功能需要重启电脑后才能生效，是否现在重启？',
        restartModalCancelBtn: '稍后重启',
        restartModalConfirmBtn: '现在重启',
        hardwareAccelerationDialogTitle: '需要重启',
        hardwareAccelerationDialogContent: '禁用硬件加速设置已更改，需要重启应用才能生效。',
        hardwareAccelerationDialogRestartNow: '现在重启',
        hardwareAccelerationDialogRestartLater: '稍后重启',
        editHotkeyModalTitle: '编辑快捷键',
        editHotkeyModalHint: '按下快捷键...',
        editHotkeyModalContent: '请按下您想要设置的快捷键组合',
        editHotkeyModalCancelBtn: '取消',
        editHotkeyModalConfirmBtn: '确认',
        keyAvailableHint: '快捷键可正常使用',
        keyNotAvailableHint: '快捷键不可用，请检查快捷键是否被其他程序占用',
        shortcutHint: 'Win键加字母键大部分都是系统键位，无法直接使用，如果需要替换系统自带的剪贴板功能，请到“通用设置”中打开“替换全局热键”设置',

        saveSuccessMsg: '保存成功',
        saveFailedMsg: '保存失败',
        shortcutSaveErrorMsg: '保存快捷键设置失败: ',
        resetSuccessMsg: '已重置',
        enableReplaceGlobalHotkeyFailedMsg: '打开“替换全局热键”失败，请确认程序是否以管理员身份启动',
        disableReplaceGlobalHotkeyFailedMsg: '关闭“替换全局热键”失败，请确认程序是否以管理员身份启动',
    },
    list: {
        title: '剪贴板',
        copySuccessMsg: '复制成功',
        copyFailedMsg: '复制失败',
        fileNotExistCopyFailedMsg: '文件不存在，复制失败',
        searchHint: '输入关键词搜索',
        deleteBtn: '删除',
        bindTagBtn: '绑定标签',
        dataLoading: '数据加载中...',
        allLoaded: '数据加载完毕',
        typeText: '文本',
        typeCode: '代码',
        typeFile: '文件',
        registerShortcutKeysErrorHint: '唤醒程序快捷键注册失败，请检查快捷键是否被其他占用，可在【设置-快捷键】页面调整',
        chars: '字符',
        empty: '暂无剪贴板记录',
        initFailedHint: '程序初始化失败，请重新运行程序',
        updateTxt: '新版本',
        menu: {
            program: '程序',
            settings: '偏好设置',
            reload: '重新加载',
            reloadHint: '正在重新加载应用程序...',
            exit: '退出程序',
            exitHint: '正在关闭应用程序...',
            data: '数据',
            tagManger: '标签管理',
            dataView: '数据视图',
            search: '搜索数据',
            dataImport: '数据导入',
            dataExport: '数据导出',
            clearData: '清空剪贴板',
            clearDataSuccessMsg: '清空历史记录成功',
            clearDataFailedMsg: '清空历史记录失败',
            themes: '主题',
            light: '浅色',
            dark: '深色',
            blue: '蓝色',
            pink: '粉色',
            help: '帮助',
            instructions: '使用说明',
            updateLog: '更新日志',
            checkForUpdate: '检查更新',
            about: '关于',
        }
    },
    tags: {
        title: '标签管理',
        bindDataHint: '关联数据：',
        addTitle: '添加标签',
        editTitle: '编辑标签',
        tagName: '标签名称',
        tagNamePlaceholder: '请输入标签名称',
        tagNameHint: '标签名称尽量不要超过5个字，如果超过则会隐藏超出的文字，具体情况参考预览效果',
        tagColor: '标签颜色',
        preview: '预览效果',
        saveBtn: '保存',
        cancelBtn: '取消',
        loadFailedMsg: '加载标签列表失败',
        tageNameIsNullWarnMsg: '标签名称不能为空',
        saveSuccessMsg: '保存成功',
        editSuccessMsg: '更新成功',
        saveFailedMsg: '保存失败',
        editFailedMsg: '更新失败',
        deleteSuccessMsg: '删除成功',
        deleteFailedMsg: '删除失败',
    },
    about: {
        title: '关于',
        appName: '剪贴板',
        version: '版本',
        problemFeedback: '问题反馈',
    },
    update: {
        title: '更新',
        versionName: '新版本',
        updateNotes: '暂无更新说明',
        notUpdateBtn: '暂不更新',
        reminderText: '下次提醒时间：',
        days: '天后',
        downloadNowBtn: '立即下载',
        restartLaterBtn: '稍后重启',
        restartImmediatelyBtn: '立即重启',
        viewMoreBtn: '查看更多',
        downloadingTitle: '下载更新中',
        backupTitle: '备份用户数据',
        backupCompleted: '备份完成',
        alreadyLatestHint: '已经是最新版本',
        checkUpdateErrorHint: '检查更新异常：',
    },
    tray: {
        settings: '设置',
        checkUpdate: '检查更新',
        about: '关于',
        restart: '重启',
        exit: '退出',
        clipboardMonitor: "剪贴板监听",
    },
}