/**
 * 更新器上下文
 */

import {listen} from "@tauri-apps/api/event";
import UpdaterService from "../../../services/UpdaterService.ts";
import {error} from "@tauri-apps/plugin-log";
import {ref} from "vue";

export const hasNewVersion = ref(false);

/**
 * 初始化修改自动检查更新任务状态监听
 */
let autoCheckUpdateUnListener: any = null;

export async function initUpdateAutoCheckUpdateListener() {
    return await listen('update-auto-check-update', (event: any) => {
        const payload = event.payload;
        const autoCheckUpdate = payload.isUpdate;
        if (autoCheckUpdate) {
            const update = UpdaterService.getInstance();
            update.stopAutoCheck();
            if (payload.updateMode === 'timing') {
                update.setIntervalTime(payload.interval * 60);
                update.startAutoCheck();
            }
        } else {
            const update = UpdaterService.getInstance();
            update.stopAutoCheck();
        }
    });
}

/**
 * 初始化更新器上下文
 * @param settings 设置
 */
export async function initializeUpdaterContext(settings: Settings) {
    try {
        // 初始化修改自动检查更新任务状态事件监听
        autoCheckUpdateUnListener = await initUpdateAutoCheckUpdateListener();

        // 开启自动检查更新
        if (settings.autoCheckUpdate) {
            if (settings.updateMode === 'timing') {
                const update = UpdaterService.getInstance();
                update.setIntervalTime(settings.autoCheckUpdateInterval * 60);
                update.startAutoCheck();
                // 启动时检查一次
                update.checkForUpdates(false);
            } else if (settings.updateMode === 'after-running') {
                const update = UpdaterService.getInstance();
                // 异步检查，同步会影响程序启动
                update.checkForUpdates(false);
            }
        }
    } catch (e) {
        console.error("更新器上下文初始化失败", e);
        error("更新器上下文初始化失败" + e);
    }
}

/**
 * 销毁更新器上下文
 */
export function destroyUpdaterContext() {
    // 清除修改自动检查更新任务状态事件监听
    if (autoCheckUpdateUnListener) {
        autoCheckUpdateUnListener();
    }

    // 关闭自动检查更新操作
    const update = UpdaterService.getInstance();
    update.stopAutoCheck();
}