import {load} from "@tauri-apps/plugin-store";

/**
 * 保存唤醒程序快捷键可用状态
 * @param available 是否可用
 */
export async function saveWakeUpRoutineKeyAvailable(available: boolean) {
    const store = await load("keyAvailable.json");
    await store.set("wake_up_routine_key_available", available);
    await store.save();
}

/**
 * 获取唤醒程序快捷键是否有效设置
 */
export async function getWakeUpRoutineKeyAvailable(): Promise<boolean | undefined> {
    const store = await load("keyAvailable.json");
    return await store.get("wake_up_routine_key_available");
}