export interface LanguageConfig {
    id: string;
    name: string;
    locale: any;
    dateLocale: any;
    pages: PageConfig;
}

export interface PageConfig {
    settings: {
        [x: string]: string;
        initFailedHint: string;
        // 设置页面标题
        title: string;
        // 设置页面左侧菜单文字
        generalMenu: string;
        storageMenu: string;
        shortcutMenu: string;
        updaterMenu: string;
        // 设置页面右侧页面标题
        generalTitle: string;
        storageTitle: string;
        shortcutTitle: string;
        updaterTitle: string;
        // 通用设置页面文字
        powerOnSelfStart: string;
        replaceGlobalHotkey: string;
        autoHideWindow: string;
        alwaysOnTop: string;
        shortcutKeyOccupationHint: string;
        replaceGlobalHotkeyNoPermissionHint: string;
        replaceGlobalHotkeyLinkHint: string;
        replaceGlobalHotkeyHint: string;
        languages: string;
        enableTag: string;
        bindTagBtnShowLocation: string;
        topRight: string;
        bottomRight: string;
        // 更新设置页面文字
        autoCheckUpdate: string;
        checkUpdateMode: string;
        regularCheck: string;
        afterRunningCheck: string;
        timeInterval: string;
        timeIntervalUnit: string;
        timeIntervalHint: string;
        newVersionAlertMode: string;
        toast: string;
        dialog: string;
        // 存储设置页面文字
        maxHistoryItems: string,
        maxHistoryItemsHint: string,
        dataRetentionDays: string,
        dataRetentionDaysHint: string,
        // 快捷键设置页面文字
        search: string;
        wakeUpRoutine: string;
        emptyShortcutConfig: string;
        // 设置页面底部按钮
        resetBtn: string;
        saveBtn: string;
        // 确认重启弹窗内容
        restartModalTitle: string;
        restartModalContent: string;
        restartModalCancelBtn: string;
        restartModalConfirmBtn: string;
        // 硬件加速设置对话框内容
        hardwareAccelerationDialogTitle: string;
        hardwareAccelerationDialogContent: string;
        hardwareAccelerationDialogRestartNow: string;
        hardwareAccelerationDialogRestartLater: string;
        // 快捷键编辑弹窗内容
        editHotkeyModalTitle: string;
        editHotkeyModalHint: string;
        editHotkeyModalContent: string;
        editHotkeyModalCancelBtn: string;
        editHotkeyModalConfirmBtn: string;
        keyAvailableHint: string;
        keyNotAvailableHint: string;
        shortcutHint: string;

        // 提示信息
        saveSuccessMsg: string;
        saveFailedMsg: string;
        shortcutSaveErrorMsg: string;
        resetSuccessMsg: string;
        enableReplaceGlobalHotkeyFailedMsg: string;
        disableReplaceGlobalHotkeyFailedMsg: string;
    },
    list: {
        title: string;
        copySuccessMsg: string;
        copyFailedMsg: string;
        fileNotExistCopyFailedMsg: string;
        searchHint: string;
        deleteBtn: string;
        bindTagBtn: string;
        dataLoading: string;
        allLoaded: string;
        typeText: string;
        typeCode: string;
        typeFile: string;
        registerShortcutKeysErrorHint: string;
        chars: string;
        empty: string;
        initFailedHint: string;
        updateTxt: string;
        menu: {
            [x: string]: string;
            program: string;
            settings: string;
            reload: string;
            reloadHint: string;
            exit: string;
            exitHint: string;
            data: string;
            tagManger: string;
            dataView: string;
            search: string;
            dataImport: string;
            dataExport: string;
            clearData: string;
            clearDataSuccessMsg: string;
            clearDataFailedMsg: string;
            themes: string;
            light: string;
            dark: string;
            blue: string;
            pink: string;
            help: string;
            instructions: string;
            updateLog: string;
            checkForUpdate: string;
            about: string;
        },
    },
    tags: {
        title: string;
        bindDataHint: string;
        addTitle: string;
        editTitle: string;
        tagName: string;
        tagNamePlaceholder: string;
        tagNameHint: string;
        tagColor: string;
        preview: string;
        saveBtn: string;
        cancelBtn: string;
        loadFailedMsg: string;
        tageNameIsNullWarnMsg: string;
        saveSuccessMsg: string;
        editSuccessMsg: string;
        saveFailedMsg: string;
        editFailedMsg: string;
        deleteSuccessMsg: string;
        deleteFailedMsg: string;
    },
    about: {
        title: string;
        appName: string;
        version: string;
        problemFeedback: string;
    },
    update: {
        title: string;
        versionName: string;
        updateNotes: string;
        notUpdateBtn: string;
        reminderText: string;
        days: string;
        downloadNowBtn: string;
        restartLaterBtn: string;
        restartImmediatelyBtn: string;
        viewMoreBtn: string;
        downloadingTitle: string;
        backupTitle: string;
        backupCompleted: string;
        alreadyLatestHint: string;
        checkUpdateErrorHint: string;
    },
    tray: {
        settings: string,
        checkUpdate: string,
        about: string,
        restart: string,
        exit: string,
        clipboardMonitor: string,
    }
}