% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs.R
\name{GibbsSampler}
\alias{GibbsSampler}
\title{The Metropolized restricted Gibbs sampler}
\usage{
GibbsSampler(
  y,
  x,
  n.vars = ncol(x),
  n.models = 10,
  tau = 0.9,
  len = 1000,
  k = 1,
  gamma = 0.5,
  info = c("AIC", "BIC", "AICc", "exBIC"),
  family = c("gaussian", "poisson", "binomial")
)
}
\arguments{
\item{y}{the response variable}

\item{x}{the predictors}

\item{n.vars}{the number of maximal predictors included in the candidate model}

\item{n.models}{the number of top selected models}

\item{tau}{the threshold to select the important predictors in second step, default is 0.9}

\item{len}{the half number of generated samples, default is 1000}

\item{k}{the tuning parameter, default is 1}

\item{gamma}{the parameter for extended BIC, default is 0.5}

\item{info}{the selected model selection criterion from AIC, AICc, BIC and exBIC}

\item{family}{the type of model from linear, logistic, poisson}
}
\value{
a list of summary
}
\description{
The Metropolized restricted Gibbs sampler
}
\examples{
x <- matrix(rnorm(1000), ncol = 10);
y <- rowSums(x[,1:5]) + rnorm(100)
m.s <- GibbsSampler(y,x,info = "BIC", family = "gaussian")

}
