---
name: RFC
about: Create a request for comments proposal
---

## Need/problem

Describe your use case. Give as much context as you can to help other contributors understand it well.

## Motivation

Please focus on explaining the motivation so that if this RFC is not accepted,
the motivation could be used to develop alternative solutions. In other words,
enumerate the constraints you are trying to solve without coupling them too
closely to the solution you have in mind.

## Detailed design

This is the bulk of the RFC. Explain the design in enough detail for somebody
familiar with Tuist to understand, and for somebody familiar with the
implementation to implement. This should get into specifics and corner-cases,
and include examples of how the feature is used. Any new terminology should be
defined here.

# Drawbacks

Why should we *not* do this? Please consider:

- implementation cost, both in term of code size and complexity
- the impact on teaching people Tuist
- integration of this feature with other existing and planned features
- cost of migrating existing projects (is it a breaking change?)

There are tradeoffs to choosing any path. Attempt to identify them here.

## Alternatives

List here the alternatives that you considered to tackle the problem and why you ruled them out in favour of your proposed solution.

# Adoption strategy

If we implement this proposal, how will existing Tuist developers adopt it? Is
this a breaking change?

# How we teach this

What names and terminology work best for these concepts and why? How is this
idea best presented? As a continuation of existing Tuist patterns?

Would the acceptance of this proposal mean the Tuist documentation must be
re-organized or altered? Does it change how Tuist is taught to new developers
at any level?

How should this feature be taught to existing Tuist developers?

# Unresolved questions

Optional, but suggested for first drafts. What parts of the design are still
TBD?