import os

from localstack.version import __version__

VERSION = __version__

# HTTP headers used to forward proxy request URLs
HEADER_LOCALSTACK_EDGE_URL = "x-localstack-edge"
HEADER_LOCALSTACK_REQUEST_URL = "x-localstack-request-url"
# HTTP header optionally added to LocalStack responses
HEADER_LOCALSTACK_IDENTIFIER = "x-localstack"
# xXx custom localstack authorization header only used in ext
HEADER_LOCALSTACK_AUTHORIZATION = "x-localstack-authorization"
HEADER_LOCALSTACK_TARGET = "x-localstack-target"
HEADER_AMZN_ERROR_TYPE = "X-Amzn-Errortype"

# backend service ports, for services that are behind a proxy (counting down from 4566)
DEFAULT_PORT_EDGE = 4566

# host name for localhost
LOCALHOST = "localhost"
LOCALHOST_IP = "127.0.0.1"
LOCALHOST_HOSTNAME = "localhost.localstack.cloud"

# User-agent string used in outgoing HTTP requests made by LocalStack
USER_AGENT_STRING = f"localstack/{VERSION}"

# version of the Maven dependency with Java utility code
LOCALSTACK_MAVEN_VERSION = "0.2.21"
MAVEN_REPO_URL = "https://repo1.maven.org/maven2"

# URL of localstack's artifacts repository on GitHub
ARTIFACTS_REPO = "https://github.com/localstack/localstack-artifacts"

# Artifacts endpoint
ASSETS_ENDPOINT = "https://assets.localstack.cloud"

# Hugging Face endpoint for localstack
HUGGING_FACE_ENDPOINT = "https://huggingface.co/localstack"

# host to bind to when starting the services
BIND_HOST = "0.0.0.0"

# root code folder
MODULE_MAIN_PATH = os.path.dirname(os.path.realpath(__file__))
# TODO rename to "ROOT_FOLDER"!
LOCALSTACK_ROOT_FOLDER = os.path.realpath(os.path.join(MODULE_MAIN_PATH, ".."))

# virtualenv folder
LOCALSTACK_VENV_FOLDER: str = os.environ.get("VIRTUAL_ENV")
if not LOCALSTACK_VENV_FOLDER:
    # fallback to the previous logic
    LOCALSTACK_VENV_FOLDER = os.path.join(LOCALSTACK_ROOT_FOLDER, ".venv")
    if not os.path.isdir(LOCALSTACK_VENV_FOLDER):
        # assuming this package lives here: <python>/lib/pythonX.X/site-packages/localstack/
        LOCALSTACK_VENV_FOLDER = os.path.realpath(
            os.path.join(LOCALSTACK_ROOT_FOLDER, "..", "..", "..")
        )

# default volume directory containing shared data
DEFAULT_VOLUME_DIR = "/var/lib/localstack"

# API Gateway path to indicate a user request sent to the gateway
PATH_USER_REQUEST = "_user_request_"

# name of LocalStack Docker image
DOCKER_IMAGE_NAME = "localstack/localstack"
DOCKER_IMAGE_NAME_PRO = "localstack/localstack-pro"
DOCKER_IMAGE_NAME_FULL = "localstack/localstack-full"

# backdoor API path used to retrieve or update config variables
CONFIG_UPDATE_PATH = "/?_config_"

# API path for localstack internal resources
INTERNAL_RESOURCE_PATH = "/_localstack"

# environment variable name to tag local test runs
ENV_INTERNAL_TEST_RUN = "LOCALSTACK_INTERNAL_TEST_RUN"

# environment variable name to tag collect metrics during a test run
ENV_INTERNAL_TEST_COLLECT_METRIC = "LOCALSTACK_INTERNAL_TEST_COLLECT_METRIC"

# environment variable that flags whether pro was activated. do not use it for security purposes!
ENV_PRO_ACTIVATED = "PRO_ACTIVATED"

# content types / encodings
HEADER_CONTENT_TYPE = "Content-Type"
TEXT_XML = "text/xml"
APPLICATION_AMZ_JSON_1_0 = "application/x-amz-json-1.0"
APPLICATION_AMZ_JSON_1_1 = "application/x-amz-json-1.1"
APPLICATION_AMZ_CBOR_1_1 = "application/x-amz-cbor-1.1"
APPLICATION_CBOR = "application/cbor"
APPLICATION_JSON = "application/json"
APPLICATION_XML = "application/xml"
APPLICATION_OCTET_STREAM = "application/octet-stream"
APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded"
HEADER_ACCEPT_ENCODING = "Accept-Encoding"

# strings to indicate truthy/falsy values
TRUE_STRINGS = ("1", "true", "True")
FALSE_STRINGS = ("0", "false", "False")
# strings with valid log levels for LS_LOG
LOG_LEVELS = ("trace-internal", "trace", "debug", "info", "warn", "error", "warning")

# API endpoint for analytics events
API_ENDPOINT = os.environ.get("API_ENDPOINT") or "https://api.localstack.cloud/v1"
# new analytics API endpoint
ANALYTICS_API = os.environ.get("ANALYTICS_API") or "https://analytics.localstack.cloud/v1"

# environment variable to indicate this process should run the localstack infrastructure
LOCALSTACK_INFRA_PROCESS = "LOCALSTACK_INFRA_PROCESS"

# AWS region us-east-1
AWS_REGION_US_EAST_1 = "us-east-1"

# environment variable to override max pool connections
try:
    MAX_POOL_CONNECTIONS = int(os.environ["MAX_POOL_CONNECTIONS"])
except Exception:
    MAX_POOL_CONNECTIONS = 150

# Fallback Account ID if not available in the client request
DEFAULT_AWS_ACCOUNT_ID = "000000000000"

# Credentials used for internal calls
INTERNAL_AWS_ACCESS_KEY_ID = "__internal_call__"
INTERNAL_AWS_SECRET_ACCESS_KEY = "__internal_call__"

# trace log levels (excluding/including internal API calls), configurable via $LS_LOG
LS_LOG_TRACE = "trace"
LS_LOG_TRACE_INTERNAL = "trace-internal"
TRACE_LOG_LEVELS = [LS_LOG_TRACE, LS_LOG_TRACE_INTERNAL]

# list of official docker images
OFFICIAL_IMAGES = [
    "localstack/localstack",
    "localstack/localstack-pro",
]

# port for debug py
DEFAULT_DEVELOP_PORT = 5678

# Default bucket name of the s3 bucket used for local lambda development
# This name should be accepted by all IaC tools, so should respect s3 bucket naming conventions
DEFAULT_BUCKET_MARKER_LOCAL = "hot-reload"
LEGACY_DEFAULT_BUCKET_MARKER_LOCAL = "__local__"

# output string that indicates that the stack is ready
READY_MARKER_OUTPUT = "Ready."

# Regex for `Credential` field in the Authorization header in AWS signature version v4
# The format is as follows:
#   Credential=<access-key-id>/<date>/<region-name>/<service-name>/aws4_request
# eg.
#   Credential=AKIAIOSFODNN7EXAMPLE/20130524/us-east-1/s3/aws4_request
AUTH_CREDENTIAL_REGEX = r"Credential=(?P<access_key_id>[a-zA-Z0-9-_.]{1,})/(?P<date>\d{8})/(?P<region_name>[a-z0-9-]{1,})/(?P<service_name>[a-z0-9]{1,})/"

# Custom resource tag to override the generated resource ID.
TAG_KEY_CUSTOM_ID = "_custom_id_"
