# LocalStack Resource Provider Scaffolding v2
from __future__ import annotations

import uuid
from pathlib import Path
from typing import TypedDict

import localstack.services.cloudformation.provider_utils as util
from localstack.services.cloudformation.resource_provider import (
    OperationStatus,
    ProgressEvent,
    ResourceProvider,
    ResourceRequest,
)


class CloudFormationWaitConditionProperties(TypedDict):
    Count: int | None
    Data: dict | None
    Handle: str | None
    Id: str | None
    Timeout: str | None


REPEATED_INVOCATION = "repeated_invocation"


class CloudFormationWaitConditionProvider(ResourceProvider[CloudFormationWaitConditionProperties]):
    TYPE = "AWS::CloudFormation::WaitCondition"  # Autogenerated. Don't change
    SCHEMA = util.get_schema_path(Path(__file__))  # Autogenerated. Don't change

    def create(
        self,
        request: ResourceRequest[CloudFormationWaitConditionProperties],
    ) -> ProgressEvent[CloudFormationWaitConditionProperties]:
        """
        Create a new resource.

        Primary identifier fields:
          - /properties/Id

        Read-only properties:
          - /properties/Data
          - /properties/Id

        """
        model = request.desired_state
        model["Data"] = {}  # TODO
        model["Id"] = f"{request.stack_id}/{uuid.uuid4()}/{request.logical_resource_id}"
        return ProgressEvent(status=OperationStatus.SUCCESS, resource_model=model)

    def read(
        self,
        request: ResourceRequest[CloudFormationWaitConditionProperties],
    ) -> ProgressEvent[CloudFormationWaitConditionProperties]:
        """
        Fetch resource information


        """
        raise NotImplementedError

    def delete(
        self,
        request: ResourceRequest[CloudFormationWaitConditionProperties],
    ) -> ProgressEvent[CloudFormationWaitConditionProperties]:
        """
        Delete a resource


        """
        return ProgressEvent(status=OperationStatus.SUCCESS, resource_model={})  # NO-OP

    def update(
        self,
        request: ResourceRequest[CloudFormationWaitConditionProperties],
    ) -> ProgressEvent[CloudFormationWaitConditionProperties]:
        """
        Update a resource


        """
        raise NotImplementedError
