from localstack.services.cloudformation.resource_provider import (
    CloudFormationResourceProviderPlugin,
    ResourceProvider,
)


class IAMInstanceProfileProviderPlugin(CloudFormationResourceProviderPlugin):
    name = "AWS::IAM::InstanceProfile"

    def __init__(self):
        self.factory: type[ResourceProvider] | None = None

    def load(self):
        from localstack.services.iam.resource_providers.aws_iam_instanceprofile import (
            IAMInstanceProfileProvider,
        )

        self.factory = IAMInstanceProfileProvider
