# LocalStack Resource Provider Scaffolding v2
from __future__ import annotations

from pathlib import Path
from typing import TypedDict

import localstack.services.cloudformation.provider_utils as util
from localstack.services.cloudformation.resource_provider import (
    OperationStatus,
    ProgressEvent,
    ResourceProvider,
    ResourceRequest,
)


class IAMServiceLinkedRoleProperties(TypedDict):
    AWSServiceName: str | None
    CustomSuffix: str | None
    Description: str | None
    Id: str | None


REPEATED_INVOCATION = "repeated_invocation"


class IAMServiceLinkedRoleProvider(ResourceProvider[IAMServiceLinkedRoleProperties]):
    TYPE = "AWS::IAM::ServiceLinkedRole"  # Autogenerated. Don't change
    SCHEMA = util.get_schema_path(Path(__file__))  # Autogenerated. Don't change

    def create(
        self,
        request: ResourceRequest[IAMServiceLinkedRoleProperties],
    ) -> ProgressEvent[IAMServiceLinkedRoleProperties]:
        """
        Create a new resource.

        Primary identifier fields:
          - /properties/Id

        Required properties:
          - AWSServiceName

        Create-only properties:
          - /properties/CustomSuffix
          - /properties/AWSServiceName

        Read-only properties:
          - /properties/Id

        """
        model = request.desired_state
        response = request.aws_client_factory.iam.create_service_linked_role(**model)
        model["Id"] = response["Role"]["RoleName"]  # TODO

        return ProgressEvent(
            status=OperationStatus.SUCCESS,
            resource_model=model,
        )

    def read(
        self,
        request: ResourceRequest[IAMServiceLinkedRoleProperties],
    ) -> ProgressEvent[IAMServiceLinkedRoleProperties]:
        """
        Fetch resource information


        """
        raise NotImplementedError

    def delete(
        self,
        request: ResourceRequest[IAMServiceLinkedRoleProperties],
    ) -> ProgressEvent[IAMServiceLinkedRoleProperties]:
        """
        Delete a resource
        """
        request.aws_client_factory.iam.delete_service_linked_role(
            RoleName=request.previous_state["Id"]
        )
        return ProgressEvent(
            status=OperationStatus.SUCCESS,
            resource_model={},
        )

    def update(
        self,
        request: ResourceRequest[IAMServiceLinkedRoleProperties],
    ) -> ProgressEvent[IAMServiceLinkedRoleProperties]:
        """
        Update a resource


        """
        raise NotImplementedError
