# LocalStack Resource Provider Scaffolding v2
from __future__ import annotations

from pathlib import Path
from typing import TypedDict

import localstack.services.cloudformation.provider_utils as util
from localstack.services.cloudformation.resource_provider import (
    OperationStatus,
    ProgressEvent,
    ResourceProvider,
    ResourceRequest,
)


class LogsLogStreamProperties(TypedDict):
    LogGroupName: str | None
    Id: str | None
    LogStreamName: str | None


REPEATED_INVOCATION = "repeated_invocation"


class LogsLogStreamProvider(ResourceProvider[LogsLogStreamProperties]):
    TYPE = "AWS::Logs::LogStream"  # Autogenerated. Don't change
    SCHEMA = util.get_schema_path(Path(__file__))  # Autogenerated. Don't change

    def create(
        self,
        request: ResourceRequest[LogsLogStreamProperties],
    ) -> ProgressEvent[LogsLogStreamProperties]:
        """
        Create a new resource.

        Primary identifier fields:
          - /properties/Id

        Required properties:
          - LogGroupName

        Create-only properties:
          - /properties/LogGroupName
          - /properties/LogStreamName

        Read-only properties:
          - /properties/Id

        """
        model = request.desired_state
        logs = request.aws_client_factory.logs

        if not model.get("LogStreamName"):
            model["LogStreamName"] = util.generate_default_name(
                stack_name=request.stack_name, logical_resource_id=request.logical_resource_id
            )

        logs.create_log_stream(
            logGroupName=model["LogGroupName"], logStreamName=model["LogStreamName"]
        )

        return ProgressEvent(
            status=OperationStatus.SUCCESS,
            resource_model=model,
            custom_context=request.custom_context,
        )

    def read(
        self,
        request: ResourceRequest[LogsLogStreamProperties],
    ) -> ProgressEvent[LogsLogStreamProperties]:
        """
        Fetch resource information


        """
        raise NotImplementedError

    def delete(
        self,
        request: ResourceRequest[LogsLogStreamProperties],
    ) -> ProgressEvent[LogsLogStreamProperties]:
        """
        Delete a resource
        """
        model = request.desired_state
        logs = request.aws_client_factory.logs

        logs.delete_log_stream(
            logGroupName=model["LogGroupName"], logStreamName=model["LogStreamName"]
        )

        return ProgressEvent(
            status=OperationStatus.SUCCESS,
            resource_model=model,
            custom_context=request.custom_context,
        )

    def update(
        self,
        request: ResourceRequest[LogsLogStreamProperties],
    ) -> ProgressEvent[LogsLogStreamProperties]:
        """
        Update a resource


        """
        raise NotImplementedError
