# LocalStack Resource Provider Scaffolding v2
from __future__ import annotations

from pathlib import Path
from typing import TypedDict

import localstack.services.cloudformation.provider_utils as util
from localstack.services.cloudformation.resource_provider import (
    OperationStatus,
    ProgressEvent,
    ResourceProvider,
    ResourceRequest,
)


class SESEmailIdentityProperties(TypedDict):
    EmailIdentity: str | None
    ConfigurationSetAttributes: ConfigurationSetAttributes | None
    DkimAttributes: DkimAttributes | None
    DkimDNSTokenName1: str | None
    DkimDNSTokenName2: str | None
    DkimDNSTokenName3: str | None
    DkimDNSTokenValue1: str | None
    DkimDNSTokenValue2: str | None
    DkimDNSTokenValue3: str | None
    DkimSigningAttributes: DkimSigningAttributes | None
    FeedbackAttributes: FeedbackAttributes | None
    MailFromAttributes: MailFromAttributes | None


class ConfigurationSetAttributes(TypedDict):
    ConfigurationSetName: str | None


class DkimSigningAttributes(TypedDict):
    DomainSigningPrivateKey: str | None
    DomainSigningSelector: str | None
    NextSigningKeyLength: str | None


class DkimAttributes(TypedDict):
    SigningEnabled: bool | None


class MailFromAttributes(TypedDict):
    BehaviorOnMxFailure: str | None
    MailFromDomain: str | None


class FeedbackAttributes(TypedDict):
    EmailForwardingEnabled: bool | None


REPEATED_INVOCATION = "repeated_invocation"


class SESEmailIdentityProvider(ResourceProvider[SESEmailIdentityProperties]):
    TYPE = "AWS::SES::EmailIdentity"  # Autogenerated. Don't change
    SCHEMA = util.get_schema_path(Path(__file__))  # Autogenerated. Don't change

    def create(
        self,
        request: ResourceRequest[SESEmailIdentityProperties],
    ) -> ProgressEvent[SESEmailIdentityProperties]:
        """
        Create a new resource.

        Primary identifier fields:
          - /properties/EmailIdentity

        Required properties:
          - EmailIdentity

        Create-only properties:
          - /properties/EmailIdentity

        Read-only properties:
          - /properties/DkimDNSTokenName1
          - /properties/DkimDNSTokenName2
          - /properties/DkimDNSTokenName3
          - /properties/DkimDNSTokenValue1
          - /properties/DkimDNSTokenValue2
          - /properties/DkimDNSTokenValue3

        IAM permissions required:
          - ses:CreateEmailIdentity
          - ses:PutEmailIdentityMailFromAttributes
          - ses:PutEmailIdentityFeedbackAttributes
          - ses:PutEmailIdentityDkimAttributes
          - ses:GetEmailIdentity

        """
        model = request.desired_state

        # TODO: validations

        if not request.custom_context.get(REPEATED_INVOCATION):
            # this is the first time this callback is invoked
            # TODO: defaults
            # TODO: idempotency
            # TODO: actually create the resource
            request.custom_context[REPEATED_INVOCATION] = True
            return ProgressEvent(
                status=OperationStatus.IN_PROGRESS,
                resource_model=model,
                custom_context=request.custom_context,
            )

        # TODO: check the status of the resource
        # - if finished, update the model with all fields and return success event:
        #   return ProgressEvent(status=OperationStatus.SUCCESS, resource_model=model)
        # - else
        #   return ProgressEvent(status=OperationStatus.IN_PROGRESS, resource_model=model)

        raise NotImplementedError

    def read(
        self,
        request: ResourceRequest[SESEmailIdentityProperties],
    ) -> ProgressEvent[SESEmailIdentityProperties]:
        """
        Fetch resource information

        IAM permissions required:
          - ses:GetEmailIdentity
        """
        raise NotImplementedError

    def list(
        self,
        request: ResourceRequest[SESEmailIdentityProperties],
    ) -> ProgressEvent[SESEmailIdentityProperties]:
        response = request.aws_client_factory.ses.list_identities()["Identities"]
        return ProgressEvent(
            status=OperationStatus.SUCCESS,
            resource_models=[SESEmailIdentityProperties(EmailIdentity=every) for every in response],
        )

    def delete(
        self,
        request: ResourceRequest[SESEmailIdentityProperties],
    ) -> ProgressEvent[SESEmailIdentityProperties]:
        """
        Delete a resource

        IAM permissions required:
          - ses:DeleteEmailIdentity
        """
        raise NotImplementedError

    def update(
        self,
        request: ResourceRequest[SESEmailIdentityProperties],
    ) -> ProgressEvent[SESEmailIdentityProperties]:
        """
        Update a resource

        IAM permissions required:
          - ses:PutEmailIdentityMailFromAttributes
          - ses:PutEmailIdentityFeedbackAttributes
          - ses:PutEmailIdentityConfigurationSetAttributes
          - ses:PutEmailIdentityDkimSigningAttributes
          - ses:PutEmailIdentityDkimAttributes
          - ses:GetEmailIdentity
        """
        raise NotImplementedError
