﻿//*********************************************************//
//    Copyright (c) Microsoft. All rights reserved.
//    
//    Apache 2.0 License
//    
//    You may obtain a copy of the License at
//    http://www.apache.org/licenses/LICENSE-2.0
//    
//    Unless required by applicable law or agreed to in writing, software 
//    distributed under the License is distributed on an "AS IS" BASIS, 
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
//    implied. See the License for the specific language governing 
//    permissions and limitations under the License.
//
//*********************************************************

using Orleans;
using System.Threading.Tasks;

namespace TwitterGrainInterfaces
{

    /// <summary>
    /// A grain to maintain a sentiment score against a hashtag
    /// </summary>
    [ExtendedPrimaryKey]
    public interface IHashtagGrain : Orleans.IGrain
    {
        Task AddScore(int score, string lastTweet);

        Task<Totals> GetTotals();
    }


}
