/*
 * Filter Design and Analysis Tool - Generated Filter Coefficients - C Source
 *  Generated by MATLAB - Signal Processing Toolbox
 */
/* General type conversion for MATLAB generated C-code  */
//#include "tmwtypes.h"
/*
 * Expected path to tmwtypes.h
 * D:\MATLAB6p5\extern\include\tmwtypes.h
 */
#define SHR_NSEC 11
const int SHR_NL[SHR_NSEC] = {1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
const double SHR_NUM[SHR_NSEC][3] = {
    {0.005552831432635, 0, 0}, {1, 1.85513392171, 1},     {1, 1.124552947132, 1},
    {1, 0.5494826514474, 1},   {1, 0.2530510147456, 1},   {1, 0.11421071021, 1},
    {1, 0.05050820570817, 1},  {1, 0.02143785084635, 1},  {1, 0.00825860312702, 1},
    {1, 0.002450310837442, 1}, {1, 0.0002559403222724, 1}};
const int SHR_DL[SHR_NSEC] = {1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
const double SHR_DEN[SHR_NSEC][3] = {{1, 0, 0},
                                     {1, -1.057889905107, 0.3423396079243},
                                     {1, -0.7388467662329, 0.5412706078096},
                                     {1, -0.4117206179617, 0.7452430383392},
                                     {1, -0.2065246935052, 0.8731924873369},
                                     {1, -0.09963328919647, 0.9398536266672},
                                     {1, -0.04798625768813, 0.9720831938723},
                                     {1, -0.02383999991344, 0.9871970879978},
                                     {1, -0.01277073265057, 0.9942264936653},
                                     {1, -0.00786818007856, 0.9975626107424},
                                     {1, -0.006013223609322, 0.9993310639802}};

class HalfrateFilter
{
public:
   HalfrateFilter()
   {
      memset(filter_regs, 0, SHR_NSEC * 2 * sizeof(double));
   }
   __forceinline double process(double x)
   {
      double filter_in = x;
      double y;

      for (int sec = 1; sec < SHR_NSEC; sec++)
      {
         // 2-pole IIR section
         y = filter_in * SHR_NUM[sec][0] + filter_regs[sec][0];
         filter_regs[sec][0] =
             filter_in * SHR_NUM[sec][1] - SHR_DEN[sec][1] * y + filter_regs[sec][1];
         filter_regs[sec][1] = filter_in * SHR_NUM[sec][2] - SHR_DEN[sec][2] * y;
         filter_in = y;
      }
      return filter_in;
   }

protected:
   double filter_regs[SHR_NSEC][2];
};
