#include "effect_defs.h"

/* reverb			*/

const float db60 = powf(10.f, 0.05f * -60.f);

enum revparam
{
   rp_predelay = 0,
   rp_shape,
   rp_roomsize,
   rp_decaytime,
   // rp_modrate,
   // rp_moddepth,
   rp_damping,
   // rp_variation,
   rp_locut,
   rp_freq1,
   rp_gain1,
   rp_hicut,
   rp_mix,
   rp_width,
};

Reverb1Effect::Reverb1Effect(SurgeStorage* storage, FxStorage* fxdata, pdata* pd)
    : Effect(storage, fxdata, pd), band1(storage), locut(storage), hicut(storage)
{
   b = 0;
}

Reverb1Effect::~Reverb1Effect()
{}

void Reverb1Effect::init()
{
   setvars(true);

   band1.coeff_peakEQ(band1.calc_omega(fxdata->p[rp_freq1].val.f / 12.f), 2,
                      fxdata->p[rp_gain1].val.f);
   locut.coeff_HP(locut.calc_omega(fxdata->p[rp_locut].val.f / 12.f), 0.5);
   hicut.coeff_LP2B(hicut.calc_omega(fxdata->p[rp_hicut].val.f / 12.f), 0.5);
   band1.coeff_instantize();
   locut.coeff_instantize();
   hicut.coeff_instantize();
   band1.suspend();
   locut.suspend();
   hicut.suspend();

   ringout = 10000000;
   b = 0;

   loadpreset(0);
   modphase = 0;
   update_rsize();
   // mix.set_target(fxdata->p[rp_mix].val.f);
   mix.set_target(1.f); // borde bli mest smooth
   mix.instantize();

   width.set_target(1.f); // borde bli mest smooth
   width.instantize();

   for (int t = 0; t < rev_taps; t++)
   {
      float x = (float)t / (rev_taps - 1.f);
      float xbp = -1.f + 2.f * x;

      out_tap[t] = 0;
      delay_pan_L[t] = sqrt(0.5 - 0.495 * xbp);
      delay_pan_R[t] = sqrt(0.5 + 0.495 * xbp);
   }
   delay_pos = 0;
}

void Reverb1Effect::setvars(bool init)
{}

void Reverb1Effect::clear_buffers()
{
   clear_block(predelay, max_rev_dly >> 2);
   clear_block(delay, (rev_taps * max_rev_dly) >> 2);
}

void Reverb1Effect::loadpreset(int id)
{
   shape = id;

   clear_buffers();

   switch (id)
   {
   case 0:
      delay_time[0] = 1339934;
      delay_time[1] = 962710;
      delay_time[2] = 1004427;
      delay_time[3] = 1103966;
      delay_time[4] = 1198575;
      delay_time[5] = 1743348;
      delay_time[6] = 1033425;
      delay_time[7] = 933313;
      delay_time[8] = 949407;
      delay_time[9] = 1402754;
      delay_time[10] = 1379894;
      delay_time[11] = 1225304;
      delay_time[12] = 1135598;
      delay_time[13] = 1402107;
      delay_time[14] = 956152;
      delay_time[15] = 1137737;
      break;
   case 1:
      delay_time[0] = 1265607;
      delay_time[1] = 844703;
      delay_time[2] = 856159;
      delay_time[3] = 1406425;
      delay_time[4] = 786608;
      delay_time[5] = 1163557;
      delay_time[6] = 1091206;
      delay_time[7] = 1129434;
      delay_time[8] = 1270379;
      delay_time[9] = 896997;
      delay_time[10] = 1415393;
      delay_time[11] = 782808;
      delay_time[12] = 868582;
      delay_time[13] = 1234463;
      delay_time[14] = 1000336;
      delay_time[15] = 968299;
      break;
   case 2:
      delay_time[0] = 1293101;
      delay_time[1] = 1334867;
      delay_time[2] = 1178781;
      delay_time[3] = 1850949;
      delay_time[4] = 1663760;
      delay_time[5] = 1982922;
      delay_time[6] = 1211021;
      delay_time[7] = 1824481;
      delay_time[8] = 1520266;
      delay_time[9] = 1351822;
      delay_time[10] = 1102711;
      delay_time[11] = 1513696;
      delay_time[12] = 1057618;
      delay_time[13] = 1671799;
      delay_time[14] = 1406360;
      delay_time[15] = 1170468;
      break;
   case 3:
      delay_time[0] = 1833435;
      delay_time[1] = 2462309;
      delay_time[2] = 2711583;
      delay_time[3] = 2219764;
      delay_time[4] = 1664194;
      delay_time[5] = 2109157;
      delay_time[6] = 1626137;
      delay_time[7] = 1434473;
      delay_time[8] = 2271242;
      delay_time[9] = 1621375;
      delay_time[10] = 1831218;
      delay_time[11] = 2640903;
      delay_time[12] = 1577737;
      delay_time[13] = 1871624;
      delay_time[14] = 2439164;
      delay_time[15] = 1427343;
      break;
   }

   for (int t = 0; t < rev_taps; t++)
   {
      /*float r = (float)(rand()/RAND_MAX);
      float rbp = (((float) rand()/RAND_MAX)*2.f - 1.f);
      float a = 256.f*(3000.f * (1.f + rbp*rbp * *f[rp_variation]))*(1.f + 1.f* *f[rp_roomsize]);
      delay_time[t] = (int)a;
      delay_time_mod[t] = delay_time[t];		*/
      delay_time[t] = (int)((float)(2.f * *f[rp_roomsize]) * delay_time[t]);
   }
   lastf[rp_roomsize] = *f[rp_roomsize];
   update_rtime();
}

void Reverb1Effect::update_rtime()
{
   int max_dt = 0;
   for (int t = 0; t < rev_taps; t++)
   {
      delay_fb[t] = powf(db60, delay_time[t] / (256.f * samplerate * powf(2.f, *f[rp_decaytime])));
      max_dt = max(max_dt, delay_time[t]);
   }
   lastf[rp_decaytime] = *f[rp_decaytime];
   float t = block_size_inv * ((float)(max_dt >> 8) + samplerate * powf(2.f, *f[rp_decaytime]) *
                                                          2.f); // *2 is to get the db120 time
   ringout_time = (int)t;
}
void Reverb1Effect::update_rsize()
{
   // memset(delay,0,rev_taps*max_rev_dly*sizeof(float));

   loadpreset(shape);

   //	lastf[rp_variation] = *f[rp_variation];
   // update_rtime();
}

void Reverb1Effect::process(float* dataL, float* dataR)
{
   _MM_ALIGN16 float wetL[block_size], wetR[block_size];

   if (fxdata->p[rp_shape].val.i != shape)
      loadpreset(fxdata->p[rp_shape].val.i);
   if ((b == 0) && (fabs(*f[rp_roomsize] - lastf[rp_roomsize]) > 0.001f))
      loadpreset(shape);
   //	if(fabs(*f[rp_variation] - lastf[rp_variation]) > 0.001f) update_rsize();
   if (fabs(*f[rp_decaytime] - lastf[rp_decaytime]) > 0.001f)
      update_rtime();

   // do more seldom
   if (b == 0)
   {
      band1.coeff_peakEQ(band1.calc_omega(*f[rp_freq1] * (1.f / 12.f)), 2, *f[rp_gain1]);
      locut.coeff_HP(locut.calc_omega(*f[rp_locut] * (1.f / 12.f)), 0.5);
      hicut.coeff_LP2B(hicut.calc_omega(*f[rp_hicut] * (1.f / 12.f)), 0.5);
   }
   b = (b + 1) & 31;

   mix.set_target_smoothed(*f[rp_mix]);
   width.set_target_smoothed(db_to_linear(*f[rp_width]));

   int pdtime = (int)(float)samplerate * note_to_pitch(12 * *f[rp_predelay]) *
                (fxdata->p[rp_predelay].temposync ? storage->temposyncratio_inv : 1.f);

#if PPC
   const vFloat zero = (vFloat)0.f;

   for (int k = 0; k < block_size; k++)
   {
      for (int t = 0; t < rev_taps; t++)
      {
         int dp = (delay_pos - (delay_time[t] >> 8));
         float newa = delay[t + ((dp & (max_rev_dly - 1)) << rev_tap_bits)];
         out_tap[t] = *f[rp_damping] * out_tap[t] + (1 - *f[rp_damping]) * newa;
      }

      float fb = 0;
      for (int t = 0; t < rev_taps; t += 4)
      {
         fb += out_tap[t] + out_tap[t + 1] + out_tap[t + 2] + out_tap[t + 3];
      }

      const float ca = -2.f / rev_taps;

      fb = ca * fb + predelay[(delay_pos - pdtime) & (max_rev_dly - 1)];

      delay_pos = (delay_pos + 1) & (max_rev_dly - 1);

      predelay[delay_pos] = 0.5f * (dataL[k] + dataR[k]);

      vFloat fb4 = (vFloat)(fb);

      vFloat L = (vFloat)(0.0), R = (vFloat)(0.0);

      for (int t = 0; t < rev_taps; t += 4)
      {
         vFloat ot = vec_ld(t << 2, out_tap);
         vFloat dfb = vec_ld(t << 2, delay_fb);
         vFloat a = vec_madd(dfb, vec_add(fb4, ot), zero);
         vec_st(a, ((delay_pos << rev_tap_bits) + t) << 2, delay);
         L = vec_madd(ot, vec_ld(t << 2, delay_pan_L), L);
         R = vec_madd(ot, vec_ld(t << 2, delay_pan_R), R);
      }
      L = vec_add(L, vec_sld(L, L, 8));
      L = vec_add(L, vec_sld(L, L, 4));
      vec_ste(L, k << 2, wetL);
      R = vec_add(R, vec_sld(R, R, 8));
      R = vec_add(R, vec_sld(R, R, 4));
      vec_ste(R, k << 2, wetR);
   }

#else
   const __m128 one4 = _mm_set1_ps(1.f);
   __m128 damp4 = _mm_load1_ps(f[rp_damping]);
   __m128 damp4m1 = _mm_sub_ps(one4, damp4);

   for (int k = 0; k < block_size; k++)
   {
      for (int t = 0; t < rev_taps; t += 4)
      {
         int dp = (delay_pos - (delay_time[t] >> 8));
         // float newa = delay[t + ((dp & (max_rev_dly-1))<<rev_tap_bits)];
         __m128 newa = _mm_load_ss(&delay[t + ((dp & (max_rev_dly - 1)) << rev_tap_bits)]);
         dp = (delay_pos - (delay_time[t + 1] >> 8));
         __m128 newb = _mm_load_ss(&delay[t + 1 + ((dp & (max_rev_dly - 1)) << rev_tap_bits)]);
         dp = (delay_pos - (delay_time[t + 2] >> 8));
         newa = _mm_unpacklo_ps(newa, newb); // a,b,0,0
         __m128 newc = _mm_load_ss(&delay[t + 2 + ((dp & (max_rev_dly - 1)) << rev_tap_bits)]);
         dp = (delay_pos - (delay_time[t + 3] >> 8));
         __m128 newd = _mm_load_ss(&delay[t + 3 + ((dp & (max_rev_dly - 1)) << rev_tap_bits)]);
         newc = _mm_unpacklo_ps(newc, newd);      // c,d,0,0
         __m128 new4 = _mm_movelh_ps(newa, newc); // a,b,c,d

         __m128 out_tap4 = _mm_load_ps(&out_tap[t]);
         out_tap4 = _mm_add_ps(_mm_mul_ps(out_tap4, damp4), _mm_mul_ps(new4, damp4m1));
         _mm_store_ps(&out_tap[t], out_tap4);
         // out_tap[t] = *f[rp_damping]*out_tap[t] + (1- *f[rp_damping])*newa;
      }

      __m128 fb = _mm_add_ps(_mm_add_ps(_mm_load_ps(out_tap), _mm_load_ps(out_tap + 4)),
                             _mm_add_ps(_mm_load_ps(out_tap + 8), _mm_load_ps(out_tap + 12)));
      fb = sum_ps_to_ss(fb);
      /*for(int t=0; t<rev_taps; t+=4)
      {
              fb += out_tap[t] + out_tap[t+1] + out_tap[t+2] + out_tap[t+3];
      }*/

      const __m128 ca = _mm_set_ss(((float)(-(2.f) / rev_taps)));
      // fb =  ca * fb + predelay[(delay_pos - pdtime)&(max_rev_dly-1)];
      fb = _mm_add_ss(_mm_mul_ss(ca, fb),
                      _mm_load_ss(&predelay[(delay_pos - pdtime) & (max_rev_dly - 1)]));

      delay_pos = (delay_pos + 1) & (max_rev_dly - 1);

      predelay[delay_pos] = 0.5f * (dataL[k] + dataR[k]);
      //__m128 fb4 = _mm_load1_ps(&fb);
      __m128 fb4 = _mm_shuffle_ps(fb, fb, 0);

      __m128 L = _mm_setzero_ps(), R = _mm_setzero_ps();
      for (int t = 0; t < rev_taps; t += 4)
      {
         __m128 ot = _mm_load_ps(&out_tap[t]);
         __m128 dfb = _mm_load_ps(&delay_fb[t]);
         __m128 a = _mm_mul_ps(dfb, _mm_add_ps(fb4, ot));
         _mm_store_ps(&delay[(delay_pos << rev_tap_bits) + t], a);
         L = _mm_add_ps(L, _mm_mul_ps(ot, _mm_load_ps(&delay_pan_L[t])));
         R = _mm_add_ps(R, _mm_mul_ps(ot, _mm_load_ps(&delay_pan_R[t])));
      }
      L = sum_ps_to_ss(L);
      R = sum_ps_to_ss(R);
      _mm_store_ss(&wetL[k], L);
      _mm_store_ss(&wetR[k], R);
   }
#endif
   locut.process_block_slowlag(wetL, wetR);
   band1.process_block_slowlag(wetL, wetR);
   hicut.process_block_slowlag(wetL, wetR);

   // scale width
   _MM_ALIGN16 float M[block_size], S[block_size];
   encodeMS(wetL, wetR, M, S, block_size_quad);
   width.multiply_block(S, block_size_quad);
   decodeMS(M, S, wetL, wetR, block_size_quad);

   mix.fade_2_blocks_to(dataL, wetL, dataR, wetR, dataL, dataR, block_size_quad);
}

void Reverb1Effect::suspend()
{
   init();
}

const char* Reverb1Effect::group_label(int id)
{
   switch (id)
   {
   case 0:
      return "Pre-Delay";
   case 1:
      return "Reverb";
   case 2:
      return "EQ";
   case 3:
      return "Mix";
   }
   return 0;
}
int Reverb1Effect::group_label_ypos(int id)
{
   switch (id)
   {
   case 0:
      return 1;
   case 1:
      return 5;
   case 2:
      return 15;
   case 3:
      return 25;
   }
   return 0;
}

void Reverb1Effect::init_ctrltypes()
{
   Effect::init_ctrltypes();

   fxdata->p[rp_predelay].set_name("Pre-Delay");
   fxdata->p[rp_predelay].set_type(ct_envtime);
   fxdata->p[rp_predelay].modulateable = false;

   fxdata->p[rp_shape].set_name("Room Shape");
   fxdata->p[rp_shape].set_type(ct_reverbshape);
   fxdata->p[rp_shape].modulateable = false;
   fxdata->p[rp_roomsize].set_name("Size");
   fxdata->p[rp_roomsize].set_type(ct_percent);
   fxdata->p[rp_roomsize].modulateable = false;
   fxdata->p[rp_decaytime].set_name("Decay Time");
   fxdata->p[rp_decaytime].set_type(ct_reverbtime);
   fxdata->p[rp_damping].set_name("HF Damp");
   fxdata->p[rp_damping].set_type(ct_percent);

   fxdata->p[rp_locut].set_name("Low Cut");
   fxdata->p[rp_locut].set_type(ct_freq_audible);
   fxdata->p[rp_freq1].set_name("Band1 Freq");
   fxdata->p[rp_freq1].set_type(ct_freq_audible);
   fxdata->p[rp_gain1].set_name("Band1 Gain");
   fxdata->p[rp_gain1].set_type(ct_decibel);
   fxdata->p[rp_hicut].set_name("High Cut");
   fxdata->p[rp_hicut].set_type(ct_freq_audible);

   fxdata->p[rp_mix].set_name("Mix");
   fxdata->p[rp_mix].set_type(ct_percent);
   fxdata->p[rp_width].set_name("Width");
   fxdata->p[rp_width].set_type(ct_decibel_narrow);

   // fxdata->p[rp_moddepth].set_name("mod depth");	fxdata->p[rp_moddepth].set_type(ct_percent);
   // //fxdata->p[rp_modrate].set_name("mod rate");
   // fxdata->p[rp_modrate].set_type(ct_lforate); fxdata->p[rp_variation].set_name("irregularity");
   // fxdata->p[rp_variation].set_type(ct_percent);

   fxdata->p[rp_predelay].posy_offset = 1;

   fxdata->p[rp_shape].posy_offset = 3;
   fxdata->p[rp_decaytime].posy_offset = 3;
   fxdata->p[rp_roomsize].posy_offset = 3;
   fxdata->p[rp_damping].posy_offset = 3;

   fxdata->p[rp_locut].posy_offset = 5;
   fxdata->p[rp_freq1].posy_offset = 5;
   fxdata->p[rp_gain1].posy_offset = 5;
   fxdata->p[rp_hicut].posy_offset = 5;

   fxdata->p[rp_mix].posy_offset = 7;
   fxdata->p[rp_width].posy_offset = 7;

   // sections
   // pre-delay
   // early reflections
   // tail
}
void Reverb1Effect::init_default_values()
{
   fxdata->p[rp_predelay].val.f = -4.f;
   fxdata->p[rp_shape].val.i = 0;
   fxdata->p[rp_decaytime].val.f = 1.f;
   fxdata->p[rp_roomsize].val.f = 0.5f;
   fxdata->p[rp_damping].val.f = 0.2f;
   fxdata->p[rp_freq1].val.f = 0.0f;
   fxdata->p[rp_gain1].val.f = 0.0f;
   fxdata->p[rp_locut].val.f = -24.0f;
   fxdata->p[rp_hicut].val.f = 72.0f;
   fxdata->p[rp_mix].val.f = 1.0f;
   fxdata->p[rp_width].val.f = 0.0f;

   // fxdata->p[rp_moddepth].val.f = 0.02f;
   // fxdata->p[rp_modrate].val.f = -2.5f;
   // fxdata->p[rp_variation].val.f = 0.5f;
}