# :raising_hand_man: Support

This document explains where and how to get help with most of my projects.
Please ensure you read through it thoroughly.

> :point_right: **Note**: before participating in the community, please read our
> [Code of Conduct][coc].
> By interacting with this repository, organization, or community you agree to
> abide by its terms.

## :grey_question: Asking quality questions

Questions can go to [Github Discussions][discussions] or feel free to join
the Discord [here][chat].

Help me help you! Spend time framing questions and add links and resources.
Spending the extra time up front can help save everyone time in the long run.
Here are some tips:

* Don't fall for the [XY problem][xy].
* Search to find out if a similar question has been asked or if a similar
  issue/bug has been reported.
* Try to define what you need help with:
    * Is there something in particular you want to do?
    * What problem are you encountering and what steps have you taken to try
        and fix it?
    * Is there a concept you don't understand?
* Provide sample code, such as a [CodeSandbox][cs] or a simple snippet, if
  possible.
* Screenshots can help, but if there's important text such as code or error
  messages in them, please also provide those.
* The more time you put into asking your question, the better I and others
  can help you.

## :old_key: Security

For any security or vulnerability related disclosure, please follow the
guidelines outlined in our [security policy][security].

## :handshake: Contributions

See [`CONTRIBUTING.md`][contributing] on how to contribute.

<!-- definitions -->
[coc]: https://github.com/lrstanley/girc/blob/master/.github/CODE_OF_CONDUCT.md
[contributing]: https://github.com/lrstanley/girc/blob/master/.github/CONTRIBUTING.md
[discussions]: https://github.com/lrstanley/girc/discussions/categories/q-a
[issues]: https://github.com/lrstanley/girc/issues/new/choose
[license]: https://github.com/lrstanley/girc/blob/master/LICENSE
[pull-requests]: https://github.com/lrstanley/girc/issues/new/choose
[security]: https://github.com/lrstanley/girc/security/policy
[support]: https://github.com/lrstanley/girc/blob/master/.github/SUPPORT.md

[xy]: https://meta.stackexchange.com/questions/66377/what-is-the-xy-problem/66378#66378
[chat]: https://liam.sh/chat
[cs]: https://codesandbox.io
